/* arrayqueue.c generated by valac 0.46.6, the Vala compiler
 * generated from arrayqueue.vala, do not modify */

/* arrayqueue.vala
 *
 * Copyright (C) 2012-2014  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;
typedef gboolean (*GeeForallFunc) (gpointer g, gpointer user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;
typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy* * lazy, gpointer user_data);

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;
typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, gpointer user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, gpointer user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, gpointer user_data);
typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, gpointer user_data);

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_ABSTRACT_QUEUE (gee_abstract_queue_get_type ())
#define GEE_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue))
#define GEE_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))
#define GEE_IS_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_IS_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_ABSTRACT_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))

typedef struct _GeeAbstractQueue GeeAbstractQueue;
typedef struct _GeeAbstractQueueClass GeeAbstractQueueClass;
typedef struct _GeeAbstractQueuePrivate GeeAbstractQueuePrivate;

#define GEE_TYPE_DEQUE (gee_deque_get_type ())
#define GEE_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_DEQUE, GeeDeque))
#define GEE_IS_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_DEQUE))
#define GEE_DEQUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_DEQUE, GeeDequeIface))

typedef struct _GeeDeque GeeDeque;
typedef struct _GeeDequeIface GeeDequeIface;

#define GEE_TYPE_ARRAY_QUEUE (gee_array_queue_get_type ())
#define GEE_ARRAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue))
#define GEE_ARRAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueueClass))
#define GEE_IS_ARRAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_QUEUE))
#define GEE_IS_ARRAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_QUEUE))
#define GEE_ARRAY_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueueClass))

typedef struct _GeeArrayQueue GeeArrayQueue;
typedef struct _GeeArrayQueueClass GeeArrayQueueClass;
typedef struct _GeeArrayQueuePrivate GeeArrayQueuePrivate;
typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, gpointer user_data);
enum  {
	GEE_ARRAY_QUEUE_0_PROPERTY,
	GEE_ARRAY_QUEUE_G_TYPE,
	GEE_ARRAY_QUEUE_G_DUP_FUNC,
	GEE_ARRAY_QUEUE_G_DESTROY_FUNC,
	GEE_ARRAY_QUEUE_SIZE_PROPERTY,
	GEE_ARRAY_QUEUE_IS_EMPTY_PROPERTY,
	GEE_ARRAY_QUEUE_READ_ONLY_PROPERTY,
	GEE_ARRAY_QUEUE_CAPACITY_PROPERTY,
	GEE_ARRAY_QUEUE_REMAINING_CAPACITY_PROPERTY,
	GEE_ARRAY_QUEUE_IS_FULL_PROPERTY,
	GEE_ARRAY_QUEUE_NUM_PROPERTIES
};
static GParamSpec* gee_array_queue_properties[GEE_ARRAY_QUEUE_NUM_PROPERTIES];

#define GEE_ARRAY_QUEUE_TYPE_ITERATOR (gee_array_queue_iterator_get_type ())
#define GEE_ARRAY_QUEUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator))
#define GEE_ARRAY_QUEUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorClass))
#define GEE_ARRAY_QUEUE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR))
#define GEE_ARRAY_QUEUE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_ARRAY_QUEUE_TYPE_ITERATOR))
#define GEE_ARRAY_QUEUE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorClass))

typedef struct _GeeArrayQueueIterator GeeArrayQueueIterator;
typedef struct _GeeArrayQueueIteratorClass GeeArrayQueueIteratorClass;
typedef struct _GeeArrayQueueIteratorPrivate GeeArrayQueueIteratorPrivate;
enum  {
	GEE_ARRAY_QUEUE_ITERATOR_0_PROPERTY,
	GEE_ARRAY_QUEUE_ITERATOR_G_TYPE,
	GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC,
	GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC,
	GEE_ARRAY_QUEUE_ITERATOR_VALID_PROPERTY,
	GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY_PROPERTY,
	GEE_ARRAY_QUEUE_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* gee_array_queue_iterator_properties[GEE_ARRAY_QUEUE_ITERATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, gpointer f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, gpointer f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, gpointer f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, gpointer f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, gpointer f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, gpointer f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, gint* result_length1);
	gpointer (*first_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*any_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*all_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gpointer (*max) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
	gpointer (*min) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
	GeeIterator* (*order_by) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, gint* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
	gboolean (*add_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*contains_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*remove_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*add_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*contains_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*remove_all_iterator) (GeeCollection* self, GeeIterator* iter);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, gpointer f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeQueue* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeQueue* self);
	GDestroyNotify (*get_g_destroy_func) (GeeQueue* self);
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeAbstractQueue {
	GeeAbstractCollection parent_instance;
	GeeAbstractQueuePrivate * priv;
};

struct _GeeAbstractQueueClass {
	GeeAbstractCollectionClass parent_class;
	gpointer (*peek) (GeeAbstractQueue* self);
	gpointer (*poll) (GeeAbstractQueue* self);
	void (*reserved0) (GeeAbstractQueue* self);
	void (*reserved1) (GeeAbstractQueue* self);
	void (*reserved2) (GeeAbstractQueue* self);
	void (*reserved3) (GeeAbstractQueue* self);
	void (*reserved4) (GeeAbstractQueue* self);
	void (*reserved5) (GeeAbstractQueue* self);
	void (*reserved6) (GeeAbstractQueue* self);
	void (*reserved7) (GeeAbstractQueue* self);
	void (*reserved8) (GeeAbstractQueue* self);
	void (*reserved9) (GeeAbstractQueue* self);
	gint (*get_capacity) (GeeAbstractQueue* self);
	gint (*get_remaining_capacity) (GeeAbstractQueue* self);
	gboolean (*get_is_full) (GeeAbstractQueue* self);
};

struct _GeeDequeIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeDeque* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeDeque* self);
	GDestroyNotify (*get_g_destroy_func) (GeeDeque* self);
	gboolean (*offer_head) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_head) (GeeDeque* self);
	gpointer (*poll_head) (GeeDeque* self);
	gint (*drain_head) (GeeDeque* self, GeeCollection* recipient, gint amount);
	gboolean (*offer_tail) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_tail) (GeeDeque* self);
	gpointer (*poll_tail) (GeeDeque* self);
	gint (*drain_tail) (GeeDeque* self, GeeCollection* recipient, gint amount);
};

struct _GeeArrayQueue {
	GeeAbstractQueue parent_instance;
	GeeArrayQueuePrivate * priv;
};

struct _GeeArrayQueueClass {
	GeeAbstractQueueClass parent_class;
};

struct _GeeArrayQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeEqualDataFunc _equal_func;
	gpointer _equal_func_target;
	GDestroyNotify _equal_func_target_destroy_notify;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _start;
	gint _length;
	gint _stamp;
};

struct _GeeArrayQueueIterator {
	GObject parent_instance;
	GeeArrayQueueIteratorPrivate * priv;
	GeeArrayQueue* _queue;
	gint _stamp;
	gint _offset;
	gboolean _removed;
};

struct _GeeArrayQueueIteratorClass {
	GObjectClass parent_class;
};

struct _GeeArrayQueueIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

static gint GeeArrayQueue_private_offset;
static gpointer gee_array_queue_parent_class = NULL;
static gint GeeArrayQueueIterator_private_offset;
static gpointer gee_array_queue_iterator_parent_class = NULL;
static GeeTraversableIface * gee_array_queue_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * gee_array_queue_iterator_gee_iterator_parent_iface = NULL;
static GeeDequeIface * gee_array_queue_gee_deque_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void gee_value_set_lazy (GValue* value,
                         gpointer v_object);
void gee_value_take_lazy (GValue* value,
                          gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeLazy, gee_lazy_unref)
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeAbstractCollection, g_object_unref)
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_abstract_queue_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeAbstractQueue, g_object_unref)
GType gee_deque_get_type (void) G_GNUC_CONST;
GType gee_array_queue_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeArrayQueue, g_object_unref)
GeeArrayQueue* gee_array_queue_new (GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    GeeEqualDataFunc equal_func,
                                    gpointer equal_func_target,
                                    GDestroyNotify equal_func_target_destroy_notify);
GeeArrayQueue* gee_array_queue_construct (GType object_type,
                                          GType g_type,
                                          GBoxedCopyFunc g_dup_func,
                                          GDestroyNotify g_destroy_func,
                                          GeeEqualDataFunc equal_func,
                                          gpointer equal_func_target,
                                          GDestroyNotify equal_func_target_destroy_notify);
GeeAbstractQueue* gee_abstract_queue_construct (GType object_type,
                                                GType g_type,
                                                GBoxedCopyFunc g_dup_func,
                                                GDestroyNotify g_destroy_func);
GeeEqualDataFunc gee_functions_get_equal_func_for (GType t,
                                                   gpointer* result_target,
                                                   GDestroyNotify* result_target_destroy_notify);
static GeeIterator* gee_array_queue_real_iterator (GeeAbstractCollection* base);
static GeeArrayQueueIterator* gee_array_queue_iterator_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     GeeArrayQueue* queue);
static GeeArrayQueueIterator* gee_array_queue_iterator_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func,
                                                           GeeArrayQueue* queue);
static GType gee_array_queue_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GeeArrayQueueIterator, g_object_unref)
static gboolean gee_array_queue_real_add (GeeAbstractCollection* base,
                                   gconstpointer element);
gboolean gee_deque_offer_tail (GeeDeque* self,
                               gconstpointer element);
static gboolean gee_array_queue_real_contains (GeeAbstractCollection* base,
                                        gconstpointer item);
static gint gee_array_queue_find_index (GeeArrayQueue* self,
                                 gconstpointer item);
static gboolean gee_array_queue_real_remove (GeeAbstractCollection* base,
                                      gconstpointer item);
static void gee_array_queue_remove_at (GeeArrayQueue* self,
                                gint index);
static void gee_array_queue_real_clear (GeeAbstractCollection* base);
static gboolean gee_array_queue_real_foreach (GeeAbstractCollection* base,
                                       GeeForallFunc f,
                                       gpointer f_target);
static gpointer gee_array_queue_real_peek (GeeAbstractQueue* base);
gpointer gee_deque_peek_head (GeeDeque* self);
static gpointer gee_array_queue_real_poll (GeeAbstractQueue* base);
gpointer gee_deque_poll_head (GeeDeque* self);
static gboolean gee_array_queue_real_offer_head (GeeDeque* base,
                                          gconstpointer element);
static void gee_array_queue_grow_if_needed (GeeArrayQueue* self);
static gpointer gee_array_queue_real_peek_head (GeeDeque* base);
static gpointer gee_array_queue_real_poll_head (GeeDeque* base);
static gint gee_array_queue_real_drain_head (GeeDeque* base,
                                      GeeCollection* recipient,
                                      gint amount);
gint gee_queue_drain (GeeQueue* self,
                      GeeCollection* recipient,
                      gint amount);
static gboolean gee_array_queue_real_offer_tail (GeeDeque* base,
                                          gconstpointer element);
static gpointer gee_array_queue_real_peek_tail (GeeDeque* base);
static gpointer gee_array_queue_real_poll_tail (GeeDeque* base);
static gint gee_array_queue_real_drain_tail (GeeDeque* base,
                                      GeeCollection* recipient,
                                      gint amount);
gpointer gee_deque_poll_tail (GeeDeque* self);
gboolean gee_collection_add (GeeCollection* self,
                             gconstpointer item);
GeeEqualDataFunc gee_array_queue_get_equal_func (GeeArrayQueue* self,
                                                 gpointer* result_target);
static void gee_array_queue_set_equal_func (GeeArrayQueue* self,
                                     GeeEqualDataFunc value,
                                     gpointer value_target);
gboolean gee_array_queue_get_is_empty (GeeArrayQueue* self);
#define GEE_QUEUE_UNBOUNDED_CAPACITY -1
static GeeArrayQueueIterator* gee_array_queue_iterator_new_from_iterator (GType g_type,
                                                                   GBoxedCopyFunc g_dup_func,
                                                                   GDestroyNotify g_destroy_func,
                                                                   GeeArrayQueueIterator* iter);
static GeeArrayQueueIterator* gee_array_queue_iterator_construct_from_iterator (GType object_type,
                                                                         GType g_type,
                                                                         GBoxedCopyFunc g_dup_func,
                                                                         GDestroyNotify g_destroy_func,
                                                                         GeeArrayQueueIterator* iter);
static gboolean gee_array_queue_iterator_real_next (GeeIterator* base);
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_array_queue_iterator_real_has_next (GeeIterator* base);
static gpointer gee_array_queue_iterator_real_get (GeeIterator* base);
static void gee_array_queue_iterator_real_remove (GeeIterator* base);
static gboolean gee_array_queue_iterator_real_foreach (GeeTraversable* base,
                                                GeeForallFunc f,
                                                gpointer f_target);
gboolean gee_iterator_get_valid (GeeIterator* self);
static GeeIterator** gee_array_queue_iterator_real_tee (GeeTraversable* base,
                                                 guint forks,
                                                 gint* result_length1);
static void gee_array_queue_iterator_finalize (GObject * obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
static void _vala_gee_array_queue_iterator_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_gee_array_queue_iterator_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void gee_array_queue_finalize (GObject * obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
gint gee_abstract_queue_get_capacity (GeeAbstractQueue* self);
gint gee_abstract_queue_get_remaining_capacity (GeeAbstractQueue* self);
gboolean gee_abstract_queue_get_is_full (GeeAbstractQueue* self);
static void _vala_gee_array_queue_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gee_array_queue_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array,
                       gsize element_size,
                       gint src,
                       gint dest,
                       gint length);

static inline gpointer
gee_array_queue_get_instance_private (GeeArrayQueue* self)
{
	return G_STRUCT_MEMBER_P (self, GeeArrayQueue_private_offset);
}

/**
 * Constructs a new, empty array queue.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeArrayQueue*
gee_array_queue_construct (GType object_type,
                           GType g_type,
                           GBoxedCopyFunc g_dup_func,
                           GDestroyNotify g_destroy_func,
                           GeeEqualDataFunc equal_func,
                           gpointer equal_func_target,
                           GDestroyNotify equal_func_target_destroy_notify)
{
	GeeArrayQueue * self = NULL;
	GeeEqualDataFunc _tmp3_;
	gpointer _tmp3__target;
	GDestroyNotify _tmp3__target_destroy_notify;
	gpointer* _tmp4_;
	self = (GeeArrayQueue*) gee_abstract_queue_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (equal_func == NULL) {
		void* _tmp0_ = NULL;
		GDestroyNotify _tmp1_ = NULL;
		GeeEqualDataFunc _tmp2_;
		_tmp2_ = gee_functions_get_equal_func_for (g_type, &_tmp0_, &_tmp1_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp2_;
		equal_func_target = _tmp0_;
		equal_func_target_destroy_notify = _tmp1_;
	}
	_tmp3_ = equal_func;
	_tmp3__target = equal_func_target;
	_tmp3__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
	self->priv->_equal_func = NULL;
	self->priv->_equal_func_target = NULL;
	self->priv->_equal_func_target_destroy_notify = NULL;
	self->priv->_equal_func = _tmp3_;
	self->priv->_equal_func_target = _tmp3__target;
	self->priv->_equal_func_target_destroy_notify = _tmp3__target_destroy_notify;
	_tmp4_ = g_new0 (gpointer, 10);
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) g_destroy_func), NULL);
	self->priv->_items = _tmp4_;
	self->priv->_items_length1 = 10;
	self->priv->__items_size_ = self->priv->_items_length1;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}

GeeArrayQueue*
gee_array_queue_new (GType g_type,
                     GBoxedCopyFunc g_dup_func,
                     GDestroyNotify g_destroy_func,
                     GeeEqualDataFunc equal_func,
                     gpointer equal_func_target,
                     GDestroyNotify equal_func_target_destroy_notify)
{
	return gee_array_queue_construct (GEE_TYPE_ARRAY_QUEUE, g_type, g_dup_func, g_destroy_func, equal_func, equal_func_target, equal_func_target_destroy_notify);
}

/**
 * {@inheritDoc}
 */
static GeeIterator*
gee_array_queue_real_iterator (GeeAbstractCollection* base)
{
	GeeArrayQueue * self;
	GeeArrayQueueIterator* _tmp0_;
	GeeIterator* result = NULL;
	self = (GeeArrayQueue*) base;
	_tmp0_ = gee_array_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_queue_real_add (GeeAbstractCollection* base,
                          gconstpointer element)
{
	GeeArrayQueue * self;
	gboolean result = FALSE;
	self = (GeeArrayQueue*) base;
	result = gee_deque_offer_tail ((GeeDeque*) self, element);
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_queue_real_contains (GeeAbstractCollection* base,
                               gconstpointer item)
{
	GeeArrayQueue * self;
	gboolean result = FALSE;
	self = (GeeArrayQueue*) base;
	result = gee_array_queue_find_index (self, item) != -1;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_queue_real_remove (GeeAbstractCollection* base,
                             gconstpointer item)
{
	GeeArrayQueue * self;
	gint _tmp0_;
	gint index = 0;
	gboolean result = FALSE;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_stamp;
	self->priv->_stamp = _tmp0_ + 1;
	index = gee_array_queue_find_index (self, item);
	if (index == -1) {
		result = FALSE;
		return result;
	} else {
		gee_array_queue_remove_at (self, index);
		result = TRUE;
		return result;
	}
}

/**
 * {@inheritDoc}
 */
static void
gee_array_queue_real_clear (GeeAbstractCollection* base)
{
	GeeArrayQueue * self;
	gint _tmp0_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_stamp;
	self->priv->_stamp = _tmp0_ + 1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < self->priv->_length)) {
					break;
				}
				_tmp3_ = self->priv->_items;
				_tmp3__length1 = self->priv->_items_length1;
				_tmp4_ = self->priv->_items;
				_tmp4__length1 = self->priv->_items_length1;
				((_tmp3_[(self->priv->_start + i) % _tmp4__length1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_[(self->priv->_start + i) % _tmp4__length1] = (self->priv->g_destroy_func (_tmp3_[(self->priv->_start + i) % _tmp4__length1]), NULL));
				_tmp3_[(self->priv->_start + i) % _tmp4__length1] = NULL;
			}
		}
	}
	self->priv->_length = 0;
	self->priv->_start = self->priv->_length;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_queue_real_foreach (GeeAbstractCollection* base,
                              GeeForallFunc f,
                              gpointer f_target)
{
	GeeArrayQueue * self;
	gboolean result = FALSE;
	self = (GeeArrayQueue*) base;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer* _tmp2_;
				gint _tmp2__length1;
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gconstpointer _tmp4_;
				gpointer _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->_length)) {
					break;
				}
				_tmp2_ = self->priv->_items;
				_tmp2__length1 = self->priv->_items_length1;
				_tmp3_ = self->priv->_items;
				_tmp3__length1 = self->priv->_items_length1;
				_tmp4_ = _tmp2_[(self->priv->_start + i) % _tmp3__length1];
				_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
				if (!f (_tmp5_, f_target)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_array_queue_real_peek (GeeAbstractQueue* base)
{
	GeeArrayQueue * self;
	gpointer _tmp0_;
	gpointer result = NULL;
	self = (GeeArrayQueue*) base;
	_tmp0_ = gee_deque_peek_head ((GeeDeque*) self);
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_array_queue_real_poll (GeeAbstractQueue* base)
{
	GeeArrayQueue * self;
	gpointer _tmp0_;
	gpointer result = NULL;
	self = (GeeArrayQueue*) base;
	_tmp0_ = gee_deque_poll_head ((GeeDeque*) self);
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_queue_real_offer_head (GeeDeque* base,
                                 gconstpointer element)
{
	GeeArrayQueue * self;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gpointer _tmp4_;
	gint _tmp5_;
	gboolean result = FALSE;
	self = (GeeArrayQueue*) base;
	gee_array_queue_grow_if_needed (self);
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_items;
	_tmp1__length1 = self->priv->_items_length1;
	self->priv->_start = ((_tmp0__length1 + self->priv->_start) - 1) % _tmp1__length1;
	_tmp2_ = self->priv->_length;
	self->priv->_length = _tmp2_ + 1;
	_tmp3_ = self->priv->_items;
	_tmp3__length1 = self->priv->_items_length1;
	_tmp4_ = ((element != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) element) : ((gpointer) element);
	((_tmp3_[self->priv->_start] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_[self->priv->_start] = (self->priv->g_destroy_func (_tmp3_[self->priv->_start]), NULL));
	_tmp3_[self->priv->_start] = _tmp4_;
	_tmp5_ = self->priv->_stamp;
	self->priv->_stamp = _tmp5_ + 1;
	result = TRUE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_array_queue_real_peek_head (GeeDeque* base)
{
	GeeArrayQueue * self;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gpointer result = NULL;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = _tmp0_[self->priv->_start];
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_array_queue_real_poll_head (GeeDeque* base)
{
	GeeArrayQueue * self;
	gint _tmp0_;
	gpointer result = NULL;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_stamp;
	self->priv->_stamp = _tmp0_ + 1;
	if (self->priv->_length == 0) {
		self->priv->_start = 0;
		result = NULL;
		return result;
	} else {
		gint _tmp1_;
		gpointer _result_ = NULL;
		gpointer* _tmp2_;
		gint _tmp2__length1;
		gpointer _tmp3_;
		gpointer* _tmp4_;
		gint _tmp4__length1;
		gpointer _tmp5_;
		_tmp1_ = self->priv->_length;
		self->priv->_length = _tmp1_ - 1;
		_tmp2_ = self->priv->_items;
		_tmp2__length1 = self->priv->_items_length1;
		_tmp3_ = _tmp2_[self->priv->_start];
		_tmp2_[self->priv->_start] = NULL;
		_result_ = _tmp3_;
		_tmp4_ = self->priv->_items;
		_tmp4__length1 = self->priv->_items_length1;
		self->priv->_start = (self->priv->_start + 1) % _tmp4__length1;
		_tmp5_ = _result_;
		_result_ = NULL;
		result = _tmp5_;
		((_result_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_result_ = (self->priv->g_destroy_func (_result_), NULL));
		return result;
	}
}

/**
 * {@inheritDoc}
 */
static gint
gee_array_queue_real_drain_head (GeeDeque* base,
                                 GeeCollection* recipient,
                                 gint amount)
{
	GeeArrayQueue * self;
	gint result = 0;
	self = (GeeArrayQueue*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	result = gee_queue_drain ((GeeQueue*) self, recipient, amount);
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_array_queue_real_offer_tail (GeeDeque* base,
                                 gconstpointer element)
{
	GeeArrayQueue * self;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	gpointer _tmp3_;
	gint _tmp4_;
	gboolean result = FALSE;
	self = (GeeArrayQueue*) base;
	gee_array_queue_grow_if_needed (self);
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_length;
	self->priv->_length = _tmp1_ + 1;
	_tmp2_ = self->priv->_items;
	_tmp2__length1 = self->priv->_items_length1;
	_tmp3_ = ((element != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) element) : ((gpointer) element);
	((_tmp0_[(self->priv->_start + _tmp1_) % _tmp2__length1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_[(self->priv->_start + _tmp1_) % _tmp2__length1] = (self->priv->g_destroy_func (_tmp0_[(self->priv->_start + _tmp1_) % _tmp2__length1]), NULL));
	_tmp0_[(self->priv->_start + _tmp1_) % _tmp2__length1] = _tmp3_;
	_tmp4_ = self->priv->_stamp;
	self->priv->_stamp = _tmp4_ + 1;
	result = TRUE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_array_queue_real_peek_tail (GeeDeque* base)
{
	GeeArrayQueue * self;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	gconstpointer _tmp3_;
	gpointer _tmp4_;
	gpointer result = NULL;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_items;
	_tmp1__length1 = self->priv->_items_length1;
	_tmp2_ = self->priv->_items;
	_tmp2__length1 = self->priv->_items_length1;
	_tmp3_ = _tmp0_[(((_tmp1__length1 + self->priv->_start) + self->priv->_length) - 1) % _tmp2__length1];
	_tmp4_ = ((_tmp3_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
	result = _tmp4_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_array_queue_real_poll_tail (GeeDeque* base)
{
	GeeArrayQueue * self;
	gint _tmp0_;
	gpointer result = NULL;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_stamp;
	self->priv->_stamp = _tmp0_ + 1;
	if (self->priv->_length == 0) {
		self->priv->_start = 0;
		result = NULL;
		return result;
	} else {
		gpointer* _tmp1_;
		gint _tmp1__length1;
		gpointer* _tmp2_;
		gint _tmp2__length1;
		gpointer* _tmp3_;
		gint _tmp3__length1;
		gpointer _tmp4_;
		_tmp1_ = self->priv->_items;
		_tmp1__length1 = self->priv->_items_length1;
		_tmp2_ = self->priv->_items;
		_tmp2__length1 = self->priv->_items_length1;
		self->priv->_length = self->priv->_length - 1;
		_tmp3_ = self->priv->_items;
		_tmp3__length1 = self->priv->_items_length1;
		_tmp4_ = _tmp1_[((_tmp2__length1 + self->priv->_start) + self->priv->_length) % _tmp3__length1];
		_tmp1_[((_tmp2__length1 + self->priv->_start) + self->priv->_length) % _tmp3__length1] = NULL;
		result = _tmp4_;
		return result;
	}
}

/**
 * {@inheritDoc}
 */
static gint
gee_array_queue_real_drain_tail (GeeDeque* base,
                                 GeeCollection* recipient,
                                 gint amount)
{
	GeeArrayQueue * self;
	gpointer item = NULL;
	gint drained = 0;
	gint result = 0;
	self = (GeeArrayQueue*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	item = NULL;
	drained = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gconstpointer _tmp4_;
		gint _tmp5_;
		if (amount == -1) {
			_tmp1_ = TRUE;
		} else {
			amount = amount - 1;
			_tmp1_ = amount >= 0;
		}
		if (_tmp1_) {
			gpointer _tmp2_;
			gconstpointer _tmp3_;
			_tmp2_ = gee_deque_poll_tail ((GeeDeque*) self);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			item = _tmp2_;
			_tmp3_ = item;
			_tmp0_ = _tmp3_ != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp4_ = item;
		gee_collection_add (recipient, _tmp4_);
		_tmp5_ = drained;
		drained = _tmp5_ + 1;
	}
	result = drained;
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
	return result;
}

/**
 * {@inheritDoc}
 */
static void
gee_array_queue_grow_if_needed (GeeArrayQueue* self)
{
	gpointer* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	if (_tmp0__length1 < (self->priv->_length + 1)) {
		gpointer* _tmp1_;
		gint _tmp1__length1;
		gint _tmp2_;
		_tmp1_ = self->priv->_items;
		_tmp1__length1 = self->priv->_items_length1;
		_tmp2_ = 2 * _tmp1__length1;
		self->priv->_items = g_renew (gpointer, self->priv->_items, 2 * _tmp1__length1);
		(_tmp2_ > self->priv->_items_length1) ? memset (self->priv->_items + self->priv->_items_length1, 0, sizeof (gpointer) * (_tmp2_ - self->priv->_items_length1)) : NULL;
		self->priv->_items_length1 = _tmp2_;
		self->priv->__items_size_ = _tmp2_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gpointer* _tmp5_;
					gint _tmp5__length1;
					gpointer* _tmp6_;
					gint _tmp6__length1;
					gpointer _tmp7_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					if (!(i < self->priv->_start)) {
						break;
					}
					_tmp5_ = self->priv->_items;
					_tmp5__length1 = self->priv->_items_length1;
					_tmp6_ = self->priv->_items;
					_tmp6__length1 = self->priv->_items_length1;
					_tmp7_ = _tmp6_[i];
					_tmp6_[i] = NULL;
					((_tmp5_[self->priv->_length + i] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp5_[self->priv->_length + i] = (self->priv->g_destroy_func (_tmp5_[self->priv->_length + i]), NULL));
					_tmp5_[self->priv->_length + i] = _tmp7_;
				}
			}
		}
	}
}

static gint
gee_array_queue_find_index (GeeArrayQueue* self,
                            gconstpointer item)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = self->priv->_start;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer* _tmp2_;
				gint _tmp2__length1;
				GeeEqualDataFunc _tmp3_ = NULL;
				gpointer _tmp3__target = NULL;
				GeeEqualDataFunc _tmp4_;
				gpointer _tmp4__target;
				gpointer* _tmp5_;
				gint _tmp5__length1;
				gconstpointer _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_items;
				_tmp2__length1 = self->priv->_items_length1;
				if (!(i < MIN (_tmp2__length1, self->priv->_start + self->priv->_length))) {
					break;
				}
				_tmp3_ = gee_array_queue_get_equal_func (self, &_tmp3__target);
				_tmp4_ = _tmp3_;
				_tmp4__target = _tmp3__target;
				_tmp5_ = self->priv->_items;
				_tmp5__length1 = self->priv->_items_length1;
				_tmp6_ = _tmp5_[i];
				if (_tmp4_ (item, _tmp6_, _tmp4__target)) {
					result = i;
					return result;
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gpointer* _tmp9_;
				gint _tmp9__length1;
				GeeEqualDataFunc _tmp10_ = NULL;
				gpointer _tmp10__target = NULL;
				GeeEqualDataFunc _tmp11_;
				gpointer _tmp11__target;
				gpointer* _tmp12_;
				gint _tmp12__length1;
				gconstpointer _tmp13_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = self->priv->_items;
				_tmp9__length1 = self->priv->_items_length1;
				if (!(i < ((self->priv->_start + self->priv->_length) - _tmp9__length1))) {
					break;
				}
				_tmp10_ = gee_array_queue_get_equal_func (self, &_tmp10__target);
				_tmp11_ = _tmp10_;
				_tmp11__target = _tmp10__target;
				_tmp12_ = self->priv->_items;
				_tmp12__length1 = self->priv->_items_length1;
				_tmp13_ = _tmp12_[i];
				if (_tmp11_ (item, _tmp13_, _tmp11__target)) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

static void
gee_array_queue_remove_at (GeeArrayQueue* self,
                           gint index)
{
	gint end = 0;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_items;
	_tmp1__length1 = self->priv->_items_length1;
	end = ((((_tmp0__length1 + self->priv->_start) + self->priv->_length) - 1) % _tmp1__length1) + 1;
	if (index == self->priv->_start) {
		gpointer* _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_items;
		_tmp2__length1 = self->priv->_items_length1;
		_tmp3_ = self->priv->_start;
		self->priv->_start = _tmp3_ + 1;
		((_tmp2_[_tmp3_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp2_[_tmp3_] = (self->priv->g_destroy_func (_tmp2_[_tmp3_]), NULL));
		_tmp2_[_tmp3_] = NULL;
		_tmp4_ = self->priv->_length;
		self->priv->_length = _tmp4_ - 1;
		return;
	} else {
		gboolean _tmp5_ = FALSE;
		if (index > self->priv->_start) {
			_tmp5_ = end <= self->priv->_start;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gpointer* _tmp6_;
			gint _tmp6__length1;
			gpointer* _tmp7_;
			gint _tmp7__length1;
			gpointer* _tmp8_;
			gint _tmp8__length1;
			gpointer* _tmp9_;
			gint _tmp9__length1;
			gpointer* _tmp10_;
			gint _tmp10__length1;
			gpointer _tmp11_;
			gint _tmp12_;
			_tmp6_ = self->priv->_items;
			_tmp6__length1 = self->priv->_items_length1;
			((_tmp6_[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp6_[index] = (self->priv->g_destroy_func (_tmp6_[index]), NULL));
			_tmp6_[index] = NULL;
			_tmp7_ = self->priv->_items;
			_tmp7__length1 = self->priv->_items_length1;
			_vala_array_move (self->priv->_items, sizeof (gpointer), index + 1, index, _tmp7__length1 - 1);
			_tmp8_ = self->priv->_items;
			_tmp8__length1 = self->priv->_items_length1;
			_tmp9_ = self->priv->_items;
			_tmp9__length1 = self->priv->_items_length1;
			_tmp10_ = self->priv->_items;
			_tmp10__length1 = self->priv->_items_length1;
			_tmp11_ = _tmp10_[0];
			_tmp10_[0] = NULL;
			((_tmp8_[_tmp9__length1 - 1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp8_[_tmp9__length1 - 1] = (self->priv->g_destroy_func (_tmp8_[_tmp9__length1 - 1]), NULL));
			_tmp8_[_tmp9__length1 - 1] = _tmp11_;
			_vala_array_move (self->priv->_items, sizeof (gpointer), 1, 0, end - 1);
			_tmp12_ = self->priv->_length;
			self->priv->_length = _tmp12_ - 1;
		} else {
			gpointer* _tmp13_;
			gint _tmp13__length1;
			gint _tmp14_;
			_tmp13_ = self->priv->_items;
			_tmp13__length1 = self->priv->_items_length1;
			((_tmp13_[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp13_[index] = (self->priv->g_destroy_func (_tmp13_[index]), NULL));
			_tmp13_[index] = NULL;
			_vala_array_move (self->priv->_items, sizeof (gpointer), index + 1, index, end - (index + 1));
			_tmp14_ = self->priv->_length;
			self->priv->_length = _tmp14_ - 1;
		}
	}
}

GeeEqualDataFunc
gee_array_queue_get_equal_func (GeeArrayQueue* self,
                                gpointer* result_target)
{
	GeeEqualDataFunc result;
	GeeEqualDataFunc _tmp0_;
	gpointer _tmp0__target;
	GeeEqualDataFunc _tmp1_;
	gpointer _tmp1__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp0__target = self->priv->_equal_func_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}

static void
gee_array_queue_set_equal_func (GeeArrayQueue* self,
                                GeeEqualDataFunc value,
                                gpointer value_target)
{
	g_return_if_fail (self != NULL);
}

static gint
gee_array_queue_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	GeeArrayQueue* self;
	self = (GeeArrayQueue*) base;
	result = self->priv->_length;
	return result;
}

gboolean
gee_array_queue_get_is_empty (GeeArrayQueue* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_length == 0;
	return result;
}

static gboolean
gee_array_queue_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	GeeArrayQueue* self;
	self = (GeeArrayQueue*) base;
	result = FALSE;
	return result;
}

static gint
gee_array_queue_real_get_capacity (GeeAbstractQueue* base)
{
	gint result;
	GeeArrayQueue* self;
	self = (GeeArrayQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}

static gint
gee_array_queue_real_get_remaining_capacity (GeeAbstractQueue* base)
{
	gint result;
	GeeArrayQueue* self;
	self = (GeeArrayQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}

static gboolean
gee_array_queue_real_get_is_full (GeeAbstractQueue* base)
{
	gboolean result;
	GeeArrayQueue* self;
	self = (GeeArrayQueue*) base;
	result = FALSE;
	return result;
}

static inline gpointer
gee_array_queue_iterator_get_instance_private (GeeArrayQueueIterator* self)
{
	return G_STRUCT_MEMBER_P (self, GeeArrayQueueIterator_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GeeArrayQueueIterator*
gee_array_queue_iterator_construct (GType object_type,
                                    GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    GeeArrayQueue* queue)
{
	GeeArrayQueueIterator * self = NULL;
	GeeArrayQueue* _tmp0_;
	GeeArrayQueue* _tmp1_;
	g_return_val_if_fail (queue != NULL, NULL);
	self = (GeeArrayQueueIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (queue);
	_g_object_unref0 (self->_queue);
	self->_queue = _tmp0_;
	_tmp1_ = self->_queue;
	self->_stamp = _tmp1_->priv->_stamp;
	return self;
}

static GeeArrayQueueIterator*
gee_array_queue_iterator_new (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func,
                              GeeArrayQueue* queue)
{
	return gee_array_queue_iterator_construct (GEE_ARRAY_QUEUE_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, queue);
}

static GeeArrayQueueIterator*
gee_array_queue_iterator_construct_from_iterator (GType object_type,
                                                  GType g_type,
                                                  GBoxedCopyFunc g_dup_func,
                                                  GDestroyNotify g_destroy_func,
                                                  GeeArrayQueueIterator* iter)
{
	GeeArrayQueueIterator * self = NULL;
	GeeArrayQueue* _tmp0_;
	GeeArrayQueue* _tmp1_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (GeeArrayQueueIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = iter->_queue;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->_queue);
	self->_queue = _tmp1_;
	self->_stamp = iter->_stamp;
	self->_offset = iter->_offset;
	self->_removed = iter->_removed;
	return self;
}

static GeeArrayQueueIterator*
gee_array_queue_iterator_new_from_iterator (GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            GeeArrayQueueIterator* iter)
{
	return gee_array_queue_iterator_construct_from_iterator (GEE_ARRAY_QUEUE_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, iter);
}

static gboolean
gee_array_queue_iterator_real_next (GeeIterator* base)
{
	GeeArrayQueueIterator * self;
	GeeArrayQueue* _tmp0_;
	gboolean result = FALSE;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->_queue;
	_vala_assert (_tmp0_->priv->_stamp == self->_stamp, "_queue._stamp == _stamp");
	if (gee_iterator_has_next ((GeeIterator*) self)) {
		gint _tmp1_;
		_tmp1_ = self->_offset;
		self->_offset = _tmp1_ + 1;
		self->_removed = FALSE;
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gboolean
gee_array_queue_iterator_real_has_next (GeeIterator* base)
{
	GeeArrayQueueIterator * self;
	GeeArrayQueue* _tmp0_;
	GeeArrayQueue* _tmp1_;
	gboolean result = FALSE;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->_queue;
	_vala_assert (_tmp0_->priv->_stamp == self->_stamp, "_queue._stamp == _stamp");
	_tmp1_ = self->_queue;
	result = (self->_offset + 1) < _tmp1_->priv->_length;
	return result;
}

static gpointer
gee_array_queue_iterator_real_get (GeeIterator* base)
{
	GeeArrayQueueIterator * self;
	GeeArrayQueue* _tmp0_;
	GeeArrayQueue* _tmp1_;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	GeeArrayQueue* _tmp3_;
	GeeArrayQueue* _tmp4_;
	gpointer* _tmp5_;
	gint _tmp5__length1;
	gconstpointer _tmp6_;
	gpointer _tmp7_;
	gpointer result = NULL;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->_queue;
	_vala_assert (_tmp0_->priv->_stamp == self->_stamp, "_queue._stamp == _stamp");
	_vala_assert (self->_offset != -1, "_offset != -1");
	_vala_assert (!self->_removed, "!_removed");
	_tmp1_ = self->_queue;
	_tmp2_ = _tmp1_->priv->_items;
	_tmp2__length1 = _tmp1_->priv->_items_length1;
	_tmp3_ = self->_queue;
	_tmp4_ = self->_queue;
	_tmp5_ = _tmp4_->priv->_items;
	_tmp5__length1 = _tmp4_->priv->_items_length1;
	_tmp6_ = _tmp2_[(_tmp3_->priv->_start + self->_offset) % _tmp5__length1];
	_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
	result = _tmp7_;
	return result;
}

static void
gee_array_queue_iterator_real_remove (GeeIterator* base)
{
	GeeArrayQueueIterator * self;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayQueue* _tmp3_;
	GeeArrayQueue* _tmp4_;
	GeeArrayQueue* _tmp5_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->_queue;
	_tmp1_ = _tmp0_->priv->_stamp;
	_tmp0_->priv->_stamp = _tmp1_ + 1;
	_tmp2_ = self->_stamp;
	self->_stamp = _tmp2_ + 1;
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp++ == _stamp++");
	_tmp3_ = self->_queue;
	_tmp4_ = self->_queue;
	_tmp5_ = self->_queue;
	_tmp6_ = _tmp5_->priv->_items;
	_tmp6__length1 = _tmp5_->priv->_items_length1;
	gee_array_queue_remove_at (_tmp3_, (_tmp4_->priv->_start + self->_offset) % _tmp6__length1);
	_tmp7_ = self->_offset;
	self->_offset = _tmp7_ - 1;
	self->_removed = TRUE;
}

static gboolean
gee_array_queue_iterator_real_foreach (GeeTraversable* base,
                                       GeeForallFunc f,
                                       gpointer f_target)
{
	GeeArrayQueueIterator * self;
	GeeArrayQueue* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayQueue* _tmp14_;
	gboolean result = FALSE;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->_queue;
	_vala_assert (_tmp0_->priv->_stamp == self->_stamp, "_queue._stamp == _stamp");
	_tmp1_ = gee_iterator_get_valid ((GeeIterator*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gint _tmp3_;
		_tmp3_ = self->_offset;
		self->_offset = _tmp3_ + 1;
		self->_removed = FALSE;
	}
	{
		gint i = 0;
		i = self->_offset;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GeeArrayQueue* _tmp6_;
				GeeArrayQueue* _tmp7_;
				gpointer* _tmp8_;
				gint _tmp8__length1;
				GeeArrayQueue* _tmp9_;
				GeeArrayQueue* _tmp10_;
				gpointer* _tmp11_;
				gint _tmp11__length1;
				gconstpointer _tmp12_;
				gpointer _tmp13_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->_queue;
				if (!(i < _tmp6_->priv->_length)) {
					break;
				}
				_tmp7_ = self->_queue;
				_tmp8_ = _tmp7_->priv->_items;
				_tmp8__length1 = _tmp7_->priv->_items_length1;
				_tmp9_ = self->_queue;
				_tmp10_ = self->_queue;
				_tmp11_ = _tmp10_->priv->_items;
				_tmp11__length1 = _tmp10_->priv->_items_length1;
				_tmp12_ = _tmp8_[(_tmp9_->priv->_start + i) % _tmp11__length1];
				_tmp13_ = ((_tmp12_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp12_) : ((gpointer) _tmp12_);
				if (!f (_tmp13_, f_target)) {
					self->_offset = i;
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp14_ = self->_queue;
	self->_offset = _tmp14_->priv->_length - 1;
	result = TRUE;
	return result;
}

static GeeIterator**
gee_array_queue_iterator_real_tee (GeeTraversable* base,
                                   guint forks,
                                   gint* result_length1)
{
	GeeArrayQueueIterator * self;
	GeeIterator** result = NULL;
	self = (GeeArrayQueueIterator*) base;
	if (forks == ((guint) 0)) {
		GeeIterator** _tmp0_;
		GeeIterator** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (GeeIterator*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	} else {
		GeeIterator** _result_ = NULL;
		GeeIterator** _tmp2_;
		gint _result__length1;
		gint __result__size_;
		GeeIterator** _tmp3_;
		gint _tmp3__length1;
		GeeIterator* _tmp4_;
		GeeIterator** _tmp9_;
		gint _tmp9__length1;
		_tmp2_ = g_new0 (GeeIterator*, forks + 1);
		_result_ = _tmp2_;
		_result__length1 = forks;
		__result__size_ = _result__length1;
		_tmp3_ = _result_;
		_tmp3__length1 = _result__length1;
		_tmp4_ = _g_object_ref0 ((GeeIterator*) self);
		_g_object_unref0 (_tmp3_[0]);
		_tmp3_[0] = _tmp4_;
		{
			guint i = 0U;
			i = (guint) 1;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					GeeIterator** _tmp7_;
					gint _tmp7__length1;
					GeeArrayQueueIterator* _tmp8_;
					if (!_tmp5_) {
						guint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < forks)) {
						break;
					}
					_tmp7_ = _result_;
					_tmp7__length1 = _result__length1;
					_tmp8_ = gee_array_queue_iterator_new_from_iterator (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
					_g_object_unref0 (_tmp7_[i]);
					_tmp7_[i] = (GeeIterator*) _tmp8_;
				}
			}
		}
		_tmp9_ = _result_;
		_tmp9__length1 = _result__length1;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		return result;
	}
}

static gboolean
gee_array_queue_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	GeeArrayQueueIterator* self;
	gboolean _tmp0_ = FALSE;
	self = (GeeArrayQueueIterator*) base;
	if (self->_offset != -1) {
		_tmp0_ = !self->_removed;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
gee_array_queue_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	GeeArrayQueueIterator* self;
	self = (GeeArrayQueueIterator*) base;
	result = FALSE;
	return result;
}

static void
gee_array_queue_iterator_class_init (GeeArrayQueueIteratorClass * klass,
                                     gpointer klass_data)
{
	gee_array_queue_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeArrayQueueIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_queue_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_queue_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_queue_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_VALID_PROPERTY, gee_array_queue_iterator_properties[GEE_ARRAY_QUEUE_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY_PROPERTY, gee_array_queue_iterator_properties[GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_array_queue_iterator_gee_traversable_get_g_type (GeeArrayQueueIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_array_queue_iterator_gee_traversable_get_g_dup_func (GeeArrayQueueIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_array_queue_iterator_gee_traversable_get_g_destroy_func (GeeArrayQueueIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_array_queue_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                         gpointer iface_data)
{
	gee_array_queue_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) gee_array_queue_iterator_real_foreach;
	iface->tee = (GeeIterator** (*) (GeeTraversable*, guint, gint*)) gee_array_queue_iterator_real_tee;
	iface->get_g_type = (GType (*) (GeeTraversable *)) gee_array_queue_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) gee_array_queue_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) gee_array_queue_iterator_gee_traversable_get_g_destroy_func;
}

static void
gee_array_queue_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                      gpointer iface_data)
{
	gee_array_queue_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (GeeIterator*)) gee_array_queue_iterator_real_next;
	iface->has_next = (gboolean (*) (GeeIterator*)) gee_array_queue_iterator_real_has_next;
	iface->get = (gpointer (*) (GeeIterator*)) gee_array_queue_iterator_real_get;
	iface->remove = (void (*) (GeeIterator*)) gee_array_queue_iterator_real_remove;
	iface->get_valid = gee_array_queue_iterator_real_get_valid;
	iface->get_read_only = gee_array_queue_iterator_real_get_read_only;
}

static void
gee_array_queue_iterator_instance_init (GeeArrayQueueIterator * self,
                                        gpointer klass)
{
	self->priv = gee_array_queue_iterator_get_instance_private (self);
	self->_offset = -1;
	self->_removed = FALSE;
}

static void
gee_array_queue_iterator_finalize (GObject * obj)
{
	GeeArrayQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator);
	_g_object_unref0 (self->_queue);
	G_OBJECT_CLASS (gee_array_queue_iterator_parent_class)->finalize (obj);
}

static GType
gee_array_queue_iterator_get_type (void)
{
	static volatile gsize gee_array_queue_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_queue_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayQueueIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_queue_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayQueueIterator), 0, (GInstanceInitFunc) gee_array_queue_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_array_queue_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_array_queue_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_queue_iterator_type_id;
		gee_array_queue_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeArrayQueueIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_queue_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_array_queue_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		GeeArrayQueueIterator_private_offset = g_type_add_instance_private (gee_array_queue_iterator_type_id, sizeof (GeeArrayQueueIteratorPrivate));
		g_once_init_leave (&gee_array_queue_iterator_type_id__volatile, gee_array_queue_iterator_type_id);
	}
	return gee_array_queue_iterator_type_id__volatile;
}

static void
_vala_gee_array_queue_iterator_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GeeArrayQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator);
	switch (property_id) {
		case GEE_ARRAY_QUEUE_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case GEE_ARRAY_QUEUE_ITERATOR_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_array_queue_iterator_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GeeArrayQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator);
	switch (property_id) {
		case GEE_ARRAY_QUEUE_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_array_queue_class_init (GeeArrayQueueClass * klass,
                            gpointer klass_data)
{
	gee_array_queue_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeArrayQueue_private_offset);
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection*)) gee_array_queue_real_iterator;
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_array_queue_real_add;
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_array_queue_real_contains;
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_array_queue_real_remove;
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection*)) gee_array_queue_real_clear;
	((GeeAbstractCollectionClass *) klass)->foreach = (gboolean (*) (GeeAbstractCollection*, GeeForallFunc, gpointer)) gee_array_queue_real_foreach;
	((GeeAbstractQueueClass *) klass)->peek = (gpointer (*) (GeeAbstractQueue*)) gee_array_queue_real_peek;
	((GeeAbstractQueueClass *) klass)->poll = (gpointer (*) (GeeAbstractQueue*)) gee_array_queue_real_poll;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_array_queue_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_array_queue_real_get_read_only;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_capacity = gee_array_queue_real_get_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_remaining_capacity = gee_array_queue_real_get_remaining_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_is_full = gee_array_queue_real_get_is_full;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_queue_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_queue_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_queue_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_SIZE_PROPERTY, gee_array_queue_properties[GEE_ARRAY_QUEUE_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_IS_EMPTY_PROPERTY, gee_array_queue_properties[GEE_ARRAY_QUEUE_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_READ_ONLY_PROPERTY, gee_array_queue_properties[GEE_ARRAY_QUEUE_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_CAPACITY_PROPERTY, gee_array_queue_properties[GEE_ARRAY_QUEUE_CAPACITY_PROPERTY] = g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_REMAINING_CAPACITY_PROPERTY, gee_array_queue_properties[GEE_ARRAY_QUEUE_REMAINING_CAPACITY_PROPERTY] = g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_IS_FULL_PROPERTY, gee_array_queue_properties[GEE_ARRAY_QUEUE_IS_FULL_PROPERTY] = g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_array_queue_gee_deque_get_g_type (GeeArrayQueue* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_array_queue_gee_deque_get_g_dup_func (GeeArrayQueue* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_array_queue_gee_deque_get_g_destroy_func (GeeArrayQueue* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_array_queue_gee_deque_interface_init (GeeDequeIface * iface,
                                          gpointer iface_data)
{
	gee_array_queue_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer_head = (gboolean (*) (GeeDeque*, gconstpointer)) gee_array_queue_real_offer_head;
	iface->peek_head = (gpointer (*) (GeeDeque*)) gee_array_queue_real_peek_head;
	iface->poll_head = (gpointer (*) (GeeDeque*)) gee_array_queue_real_poll_head;
	iface->drain_head = (gint (*) (GeeDeque*, GeeCollection*, gint)) gee_array_queue_real_drain_head;
	iface->offer_tail = (gboolean (*) (GeeDeque*, gconstpointer)) gee_array_queue_real_offer_tail;
	iface->peek_tail = (gpointer (*) (GeeDeque*)) gee_array_queue_real_peek_tail;
	iface->poll_tail = (gpointer (*) (GeeDeque*)) gee_array_queue_real_poll_tail;
	iface->drain_tail = (gint (*) (GeeDeque*, GeeCollection*, gint)) gee_array_queue_real_drain_tail;
	iface->get_g_type = (GType (*) (GeeDeque *)) gee_array_queue_gee_deque_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeDeque *)) gee_array_queue_gee_deque_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeDeque *)) gee_array_queue_gee_deque_get_g_destroy_func;
}

static void
gee_array_queue_instance_init (GeeArrayQueue * self,
                               gpointer klass)
{
	self->priv = gee_array_queue_get_instance_private (self);
	self->priv->_start = 0;
	self->priv->_length = 0;
	self->priv->_stamp = 0;
}

static void
gee_array_queue_finalize (GObject * obj)
{
	GeeArrayQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue);
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
	self->priv->_equal_func = NULL;
	self->priv->_equal_func_target = NULL;
	self->priv->_equal_func_target_destroy_notify = NULL;
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	G_OBJECT_CLASS (gee_array_queue_parent_class)->finalize (obj);
}

/**
 * Resizable array implementation of the {@link Deque} interface.
 *
 * The storage array grows automatically when needed.
 *
 * This implementation is pretty good for lookups at the end or random.
 * Because they are stored in an array this structure does not fit for deleting
 * arbitrary elements. For an alternative implementation see {@link LinkedList}.
 *
 * @see LinkedList
 */
GType
gee_array_queue_get_type (void)
{
	static volatile gsize gee_array_queue_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayQueue), 0, (GInstanceInitFunc) gee_array_queue_instance_init, NULL };
		static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_array_queue_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_queue_type_id;
		gee_array_queue_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_QUEUE, "GeeArrayQueue", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_queue_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
		GeeArrayQueue_private_offset = g_type_add_instance_private (gee_array_queue_type_id, sizeof (GeeArrayQueuePrivate));
		g_once_init_leave (&gee_array_queue_type_id__volatile, gee_array_queue_type_id);
	}
	return gee_array_queue_type_id__volatile;
}

static void
_vala_gee_array_queue_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GeeArrayQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue);
	switch (property_id) {
		case GEE_ARRAY_QUEUE_SIZE_PROPERTY:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_ARRAY_QUEUE_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, gee_array_queue_get_is_empty (self));
		break;
		case GEE_ARRAY_QUEUE_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GEE_ARRAY_QUEUE_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_abstract_queue_get_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_ARRAY_QUEUE_REMAINING_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_abstract_queue_get_remaining_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_ARRAY_QUEUE_IS_FULL_PROPERTY:
		g_value_set_boolean (value, gee_abstract_queue_get_is_full ((GeeAbstractQueue*) self));
		break;
		case GEE_ARRAY_QUEUE_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case GEE_ARRAY_QUEUE_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case GEE_ARRAY_QUEUE_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_array_queue_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GeeArrayQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue);
	switch (property_id) {
		case GEE_ARRAY_QUEUE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_QUEUE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_QUEUE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static void
_vala_array_move (gpointer array,
                  gsize element_size,
                  gint src,
                  gint dest,
                  gint length)
{
	memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}

