#!/usr/bin/env ruby

########################################################################
# make array of pointer to char from copyright file
# muquit@muquit.com Oct-12-2013 
########################################################################
class CopyrightTwoArrayOfPointerToChar
  ME = File.basename($0)
  COPYRIGHT_FILE = Dir.pwd + "/COPYRIGHT"
  def initialize
  end
  def doit
    lines = File.readlines(COPYRIGHT_FILE)
    if !lines
      puts "Error: could not read #{COPYRIGHT_FILE}"
      exit
    end
    t = Time.new
  puts <<-EOF
#ifndef COPYRIGHT_H
#define COPYRIGHT_H
  /*
  ** Automatically generated by #{ME}. 
  ** #{t}
  */
static char
  *mailsend_copyright[] = 
  {
EOF
    lines.each do |line|
    line.chomp!
    line = line.gsub(/\"/,"\\\"")
puts "\"#{line}\","
    end
  puts <<-EOF
(char *) NULL
  };
#endif /* COPYRIGHT_H */
EOF

  end
end

if __FILE__ == $0
  CopyrightTwoArrayOfPointerToChar.new.doit
end
