/*
* Miax
*
*  Copyright (C) 2004 by Ubaldo Porcheddu <ubaldo@eja.it>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include "iaxclient_lib.h"
#include "miax.h"

FILE *stderr;

int miax_closeall(int n) {

	int l;

	if (debug > 5 ) { fprintf(stderr,"Miax: status: %d\nMiax: event: %d\n",status, n); }

	if (status >= 0) {
		status=-1;

		if (n < 0) {
			iaxc_dump_all_calls();
			if (debug > 5 ) { fprintf(stderr,"Miax: call dumped.\n"); }
			}
		audio_close();
		if (debug > 5 ) { fprintf(stderr,"Miax: audio closed.\n"); }
		if (m > 0) { 
			modem_close(); 
			if (debug > 5 ) { fprintf(stderr,"Miax: modem closed.\n"); }
			}
		}
		
	return 0;		
	}


int miax_callback(struct iax_event *e, int callNo) {

	switch(e->etype) {
 		case 0:			//IAX_EVENT_CONNECT
	 		strcpy(number,e->ies.called_number);			
 			fprintf(stderr, "Miax: %s is looking for %s\n", e->ies.calling_number, number);
 			status=100;
			break;
		case 2: 		//IAX_EVENT_HANGUP:
			miax_closeall(2);			
			break;
		case 3: 		//IAX_EVENT_REJECT:
			miax_closeall(3);			
			break;
 		case 6: 		//IAX_EVENT_TIMEOUT:
			miax_closeall(6);			
 			break;
 		case 12: 		//IAX_EVENT_BUSY:
 			miax_closeall(12);			
 			break;
		case 13: 		//IAX_EVENT_ANSWER:
			status=130;			
 			break;
		default:
			break;
		}
	}


int console_loop(int status, char *number) {

	char buf[256];
	fd_set rfds;
	struct timeval tv;
	int retval;
    
	FD_ZERO(&rfds);
	FD_SET(0, &rfds);
	tv.tv_sec = 5;
	tv.tv_usec = 0;
    
    	if (status == 100) { printf("Press [ENTER] to accept incoming call.\n"); }
    
	if (retval = select(1, &rfds, NULL, NULL, &tv) > 0) {  
		read(0,buf,sizeof(buf));
		if (status == 100) { return 130; }
		if (strstr(buf,"h")) { 
			fprintf(stderr, "Miax: hanging up.\n");
			return -1; 
			}
		else { 
			strcpy(number,strtok(buf,"\n")); 
			return 101;
			}
		}
			
	return 0;
	}


void usage() { 
	fprintf(stderr, "Usage: miax [-hndupsragmbil]\n\n");
	fprintf(stderr, " -h 	this help\n");
	fprintf(stderr, " -n 	source number\n");
	fprintf(stderr, " -d 	destination number\n");
	fprintf(stderr, " -u 	username\n");
	fprintf(stderr, " -p 	password\n");
	fprintf(stderr, " -s 	server\n");
	fprintf(stderr, " -r 	register\n");
	fprintf(stderr, " -a 	audio device\n");
	fprintf(stderr, " -g 	gsm codec\n");
	fprintf(stderr, " -m 	modem device\n");
	fprintf(stderr, " -b 	bluetooth device\n");
	fprintf(stderr, " -i 	modem init string\n");
	fprintf(stderr, " -l 	log level\n");
	fprintf(stderr, " -o 	log output\n");
	fprintf(stderr, "\nReport bugs to <ubaldo@eja.it>\n");
	exit(1);
	}


int main(int argc, char **argv) {

	char c, buf[256], cmd[256];
	char *username, *password, *hostname="localhost", *source="352", *destination, *modem_i;
	char *audio_dev="/dev/dsp",*modem_dev="/dev/ttyS0",*log_output="/dev/stdout";
	int i,r=0,d=0,n=0;
	int compression=0;
	
	for(i=1;i<argc;i++)
	{
	   if(argv[i][0] == '-') 
	   {
	      switch(tolower(argv[i][1]))
	      {
		case 'g':
		  compression = 1;
		  break;
		case 'n':
		  if(i+1 >= argc) usage();
		  source = argv[++i];
		  break;
		case 'd':
		  if(i+1 >= argc) usage();
		  destination = argv[++i];
		  d=1;
		  break;
		case 'a':
		  if(i+1 >= argc) usage();
		  audio_dev = argv[++i];
		  break;
		case 'm':
		  if(i+1 >= argc) usage();
		  modem_dev = argv[++i];
		  m=1;
		  break;
		case 'r':
		  r=1;
		  break;
		case 'u':
		  if(i+1 >= argc) usage();
		  username = argv[++i];
		  break;
		case 'p':
		  if(i+1 >= argc) usage();
		  password = argv[++i];
		  break;
		case 's':
		  if(i+1 >= argc) usage();
		  hostname = argv[++i];
		  break;
		case 'l':
		  if(i+1 >= argc) usage();
		  debug = atoi(argv[++i]);
		  break;
		case 'o':
		  if(i+1 >= argc) usage();
		  log_output = argv[++i];
		  break;
		case 'i':
		  if(i+1 >= argc) usage();
		  modem_i = argv[++i];
		  m=2;
		  break;
		case 'b':
		  if(i+1 >= argc) usage();
		  audio_dev=modem_dev=argv[++i];
		  bt=1;
		  m=1;
		  break;
		default:
		  usage();
	      }
	   }
	}
	if (i<=1) { usage(); }
	
	printf("miax@eja.it\n");	

	stderr=fopen(log_output,"w");
	
	iaxc_initialize(1);

	if (compression == 0) {
		
		iaxc_set_encode_format(IAXC_FORMAT_SLINEAR);
		}
	else {
		iaxc_set_encode_format(IAXC_FORMAT_GSM);
		}
		
	iaxc_set_callerid("miax",source);

	if (r > 0) { iaxc_register(username,password,hostname); }
	
	if ( audio_init(audio_dev, compression) < 0) {
			fprintf(stderr,"Miax: cannot initialize audio device!\n"); 
			return -1;
			}
	
	if (m > 0) {
		if (modem_init(modem_dev) < 0)  { 
			fprintf(stderr,"Miax: cannot initialize modem device!\n"); 
			return -1;
			}
		if (m == 2) { sprintf(buf,"%s\r",modem_i); modem(buf); }
		}

	if (d > 0) { 
		sprintf(buf,"%s:%s@%s/%s",username,password,hostname,destination);
		iaxc_call(buf); 
		}

	iaxc_start_processing_thread();

	fprintf(stderr, "Miax: ready.\n");
		
	while(status >= 0) {
		n = miax_loop(status, number);  
		
		if (n == 101) { 				
			sprintf(buf,"%s:%s@%s/%s",username,password,hostname,number);
			iaxc_call(buf);
			status=0;
			}
		if (n == 130) {	
			iaxc_answer_call(0);
			status=0;
			}
		if (n < 0) { 
			miax_closeall(n); 
			break; 
			}
	    	}
	fprintf(stderr, "Miax: bye! :)\n\n");
	
	exit(0);
	}





