// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "url/url_constants.h"

namespace url {

const char kAboutBlankURL[] = "about:blank";
const char16_t kAboutBlankURL16[] = u"about:blank";
const char kAboutSrcdocURL[] = "about:srcdoc";
const char16_t kAboutSrcdocURL16[] = u"about:srcdoc";

const char kAboutBlankPath[] = "blank";
const char16_t kAboutBlankPath16[] = u"blank";
const char kAboutSrcdocPath[] = "srcdoc";
const char16_t kAboutSrcdocPath16[] = u"srcdoc";

const char kAboutScheme[] = "about";
const char16_t kAboutScheme16[] = u"about";
const char kBlobScheme[] = "blob";
const char16_t kBlobScheme16[] = u"blob";
const char kContentScheme[] = "content";
const char16_t kContentScheme16[] = u"content";
const char kContentIDScheme[] = "cid";
const char16_t kContentIDScheme16[] = u"cid";
const char kDataScheme[] = "data";
const char16_t kDataScheme16[] = u"data";
const char kFileScheme[] = "file";
const char16_t kFileScheme16[] = u"file";
const char kFileSystemScheme[] = "filesystem";
const char16_t kFileSystemScheme16[] = u"filesystem";
const char kFtpScheme[] = "ftp";
const char16_t kFtpScheme16[] = u"ftp";
const char kHttpScheme[] = "http";
const char16_t kHttpScheme16[] = u"http";
const char kHttpsScheme[] = "https";
const char16_t kHttpsScheme16[] = u"https";
const char kJavaScriptScheme[] = "javascript";
const char16_t kJavaScriptScheme16[] = u"javascript";
const char kMailToScheme[] = "mailto";
const char16_t kMailToScheme16[] = u"mailto";
// This is for QuicTransport (https://wicg.github.io/web-transport/).
// See also: https://www.iana.org/assignments/uri-schemes/prov/quic-transport
const char kQuicTransportScheme[] = "quic-transport";
const char16_t kQuicTransportScheme16[] = u"quic-transport";
const char kTelScheme[] = "tel";
const char16_t kTelScheme16[] = u"tel";
const char kUrnScheme[] = "urn";
const char16_t kUrnScheme16[] = u"urn";
const char kUuidInPackageScheme[] = "uuid-in-package";
const char16_t kUuidInPackageScheme16[] = u"uuid-in-package";
const char kWebcalScheme[] = "webcal";
const char16_t kWebcalScheme16[] = u"webcal";
const char kWsScheme[] = "ws";
const char16_t kWsScheme16[] = u"ws";
const char kWssScheme[] = "wss";
const char16_t kWssScheme16[] = u"wss";

const char kStandardSchemeSeparator[] = "://";
const char16_t kStandardSchemeSeparator16[] = u"://";

const size_t kMaxURLChars = 2 * 1024 * 1024;

}  // namespace url
