// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QUICHE_QUIC_TEST_TOOLS_TEST_CERTIFICATES_H_
#define QUICHE_QUIC_TEST_TOOLS_TEST_CERTIFICATES_H_

#include "absl/base/attributes.h"
#include "absl/strings/string_view.h"

namespace quic {
namespace test {

// A test certificate generated by //net/tools/quic/certs/generate-certs.sh.
ABSL_CONST_INIT extern const absl::string_view kTestCertificate;

// PEM-encoded version of |kTestCertificate|.
ABSL_CONST_INIT extern const char kTestCertificatePem[];

// |kTestCertificatePem| with a PEM-encoded root appended to the end.
ABSL_CONST_INIT extern const char kTestCertificateChainPem[];

// PEM-encoded certificate that contains a subjectAltName with an
// unknown/unsupported type.
ABSL_CONST_INIT extern const char kTestCertWithUnknownSanTypePem[];

// DER-encoded private key for |kTestCertificate|.
ABSL_CONST_INIT extern const absl::string_view kTestCertificatePrivateKey;

// PEM-encoded version of |kTestCertificatePrivateKey|.
ABSL_CONST_INIT extern const char kTestCertificatePrivateKeyPem[];

// The legacy PEM-encoded version of |kTestCertificatePrivateKey| manually
// generated from the one above using der2ascii.
ABSL_CONST_INIT extern const char kTestCertificatePrivateKeyLegacyPem[];

// Another DER-encoded test certificate, valid for foo.test, www.foo.test and
// *.wildcard.test.
ABSL_CONST_INIT extern const absl::string_view kWildcardCertificate;

// DER-encoded private key for |kWildcardCertificate|.
ABSL_CONST_INIT extern const absl::string_view kWildcardCertificatePrivateKey;

// PEM-encoded P-256 private key using legacy OpenSSL encoding.
ABSL_CONST_INIT extern const char kTestEcPrivateKeyLegacyPem[];

}  // namespace test
}  // namespace quic

#endif  // QUICHE_QUIC_TEST_TOOLS_TEST_CERTIFICATES_H_
