---
title: "Test the New Cloud Architecture"
description: "Would you like to be the first to try our new architecture and provide feedback? If so, this guide will help you sign up for our beta testing group."
custom_edit_url: "https://github.com/netdata/netdata/blob/master/docs/cloud/beta-architecture/new-architecture.md"
---

To enhance the stability and reliability of Netdata Cloud, we did extensive work on our backend, and we would like to give you the opportunity 
to be among the first users to try these changes to our Cloud architecture and provide feedback. 

The backend architecture changes should offer notable improvements in reliability and stability in Netdata Cloud, 
but more importantly, it allows us to develop new features and enhanced functionality, including features and enhancements
that you have specifically requested. Features that will be developed on the new architecture include:

- Parent/Child Cloud relationships
- Alert logs
- Alert management
- Much more

## Enabling the new architecture

To enable the new architecture, first ensure that you have installed the latest Netdata version following 
[our guide](https://github.com/netdata/netdata/blob/master/docs/get-started.mdx). Then, you or your administrator will need to retrieve the Space IDs 
within Netdata Cloud by clicking `Manage Space` in the left pane, selecting the `Space` tab, and copying the value in the `Space Id` field.
You can then send an email to [beta@Netdata.cloud](mailto:beta@netdata.cloud) requesting to be included in our beta testers, and include 
in the body of the email a list of Space IDs for any space you would like to have whitelisted for the update. If you received an email
invitation, you can also just reply to the invitation with your Space IDs in the body of the reply.

Feel free to send the Space IDs for multiple spaces to test the new infrastructure on each of them.

## Reporting issues

After you are set up with the new architecture changes, we ask that you report any issues you encounter in our 
[designated Discord channel](https://discord.gg/dGzdemHwHh). This feedback
will help us ensure the highest performance of the new architecture and expedite the development and release
of the aforementioned enhancements and features.

