"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const semver_1 = __importDefault(require("semver"));
const hap_nodejs_1 = require("hap-nodejs");
const node_persist_1 = __importDefault(require("node-persist"));
const logger_1 = require("@nrchkb/logger");
logger_1.loggerSetup({ timestampEnabled: 'NRCHKB' });
const log = logger_1.logger('NRCHKB');
if (process.env.NRCHKB_EXPERIMENTAL === 'true') {
    log.error('Experimental features enabled');
}
module.exports = (RED) => {
    const requiredNodeVersion = '10.22.1';
    const nodeVersion = process.version;
    if (semver_1.default.gte(nodeVersion, requiredNodeVersion)) {
        log.debug(`Node.js version requirement met. Required ${requiredNodeVersion}. Installed ${nodeVersion}`);
    }
    else {
        throw RangeError(`Node.js version requirement not met. Required ${requiredNodeVersion}. Installed ${nodeVersion}`);
    }
    const API = require('../lib/api')(RED);
    if (RED.settings.available() && RED.settings.userDir) {
        log.debug('RED settings available');
        const nrchkbStoragePath = path.resolve(RED.settings.userDir, 'nrchkb');
        node_persist_1.default.init({ dir: nrchkbStoragePath }).then(() => {
            API.init();
        });
        log.debug(`nrchkbStorage path set to ${nrchkbStoragePath}`);
        const hapStoragePath = path.resolve(RED.settings.userDir, 'homekit-persist');
        try {
            hap_nodejs_1.HAPStorage.setCustomStoragePath(hapStoragePath);
            log.debug(`HAPStorage path set to ${hapStoragePath}`);
        }
        catch (error) {
            log.debug('HAPStorage already initialized');
            log.error('node-red restart highly recommended');
            log.trace(error);
        }
    }
    else {
        log.debug('RED settings not available');
    }
    if (process.env.NRCHKB_EXPERIMENTAL === 'true') {
        log.debug('Registering nrchkb type');
        RED.nodes.registerType('nrchkb', function (config) {
            RED.nodes.createNode(this, config);
        });
    }
};
