"use strict";module.exports=function(r){require("source-map-support").install();var a=require("./modbus-basics"),d=require("./core/modbus-core"),u=require("./core/modbus-io-core"),l=require("debug")("contribModbus:read");r.nodes.registerType("modbus-read",function(e){r.nodes.createNode(this,e),this.name=e.name,this.topic=e.topic,this.unitid=e.unitid,this.dataType=e.dataType,this.adr=e.adr,this.quantity=e.quantity||1,this.rate=e.rate,this.rateUnit=e.rateUnit,this.delayOnStart=e.delayOnStart,this.startDelayTime=parseInt(e.startDelayTime)||10,this.showStatusActivities=e.showStatusActivities,this.showErrors=e.showErrors,this.connection=null,this.useIOFile=e.useIOFile,this.ioFile=r.nodes.getNode(e.ioFile),this.useIOForPayload=e.useIOForPayload,this.logIOActivities=e.logIOActivities,this.emptyMsgOnFail=e.emptyMsgOnFail,this.internalDebugLog=l,this.verboseLogging=r.settings.verbose;var s=this,o=!1;function t(e){r.settings.verbose&&s.warn("Client -> "+e+s.serverInfo)}s.INPUT_TIMEOUT_MILLISECONDS=1e3,s.statusText="waiting",s.delayTimerReading=!1,s.intervalTimerIdReading=!1,n(s.statusText),t("open node "+s.id);var i=r.nodes.getNode(e.server);function n(e){var t,i,n;"polling"===e&&o||(t=a.setNodeStatusProperties(e,s.showStatusActivities),i=s.statusText,-1!==e.search("active")||"polling"===e?(n=t.status+(" ( "+s.rate+" "+a.get_timeUnit_name(s.rateUnit))+" ) ",o=!1,n!==i&&s.status({fill:t.fill,shape:t.shape,text:n})):(n=t.status)!==i&&s.status({fill:t.fill,shape:t.shape,text:n}))}i&&(s.onModbusInit=function(){n("initialized")},s.onModbusConnect=function(){n("connected"),s.resetAllReadingTimer(),s.initializeReadingTimer()},s.onModbusRegister=function(){s.showStatusActivities&&n("registered"),i.serialSendingAllowed&&(s.resetAllReadingTimer(),s.initializeReadingTimer(),n("connected"))},s.onModbusActive=function(){n("active")},s.onModbusQueue=function(){n("queue")},s.onModbusError=function(e){n("failure"),i.reconnectOnTimeout&&s.resetAllReadingTimer(),s.showErrors&&s.warn(e)},s.onModbusClose=function(){n("closed"),s.resetAllReadingTimer()},s.onModbusBroken=function(){n("broken"),i.reconnectOnTimeout&&(n("reconnecting after "+i.reconnectTimeout+" msec."),s.resetAllReadingTimer())},s.onModbusReadDone=function(e,t){s.showStatusActivities&&n("reading done"),function(e,t,i){var n=i.topic||s.topic;{var o,r;s.useIOFile&&s.ioFile.lastUpdatedAt?(s.logIOActivities&&u.internalDebug("node.adr:"+s.adr+" node.quantity:"+s.quantity),r=u.nameValuesFromIOFile(s,i,e,t,s.adr),o=u.filterValueNames(s,r,d.functionCodeModbusRead(s.dataType),s.adr,s.quantity),r={topic:n,responseBuffer:t,input:i,sendingNodeId:s.id},s.useIOForPayload?(r.payload=o,r.values=e):(r.payload=e,r.valueNames=o),s.send([r,{topic:n,payload:t,values:e,input:i,valueNames:o,sendingNodeId:s.id}])):s.send([{topic:n,payload:e,responseBuffer:t,input:i,sendingNodeId:s.id},{topic:n,payload:t,values:e,input:i,sendingNodeId:s.id}])}}(e.data,e,t)},s.errorProtocolMsg=function(e,t){a.logMsgError(s,e,t),a.sendEmptyMsgOnFail(s,e,t)},s.onModbusReadError=function(e,t){s.internalDebugLog(e.message),s.errorProtocolMsg(e,t),a.setModbusError(s,i,e,t)},s.modbusPollingRead=function(){var e;i.client?(e={topic:s.topic||"polling",from:s.name,payload:{unitid:s.unitid,fc:d.functionCodeModbusRead(s.dataType),address:s.adr,quantity:s.quantity,messageId:d.getObjectId()}},s.showStatusActivities&&n("polling"),i.emit("readModbus",e,s.onModbusReadDone,s.onModbusReadError)):n("waiting")},s.resetDelayTimerToRead=function(e){e.delayTimerReading&&(t("resetDelayTimerToRead node "+e.id),clearTimeout(e.delayTimerReading)),e.delayTimerReading=null},s.resetIntervalToRead=function(e){e.intervalTimerIdReading&&(t("resetIntervalToRead node "+e.id),clearInterval(e.intervalTimerIdReading)),e.intervalTimerIdReading=null},s.resetAllReadingTimer=function(){s.resetDelayTimerToRead(s),s.resetIntervalToRead(s)},s.resetAllReadingTimer(),s.startIntervalReading=function(){s.intervalTimerIdReading||(t("startIntervalReading node "+s.id),s.intervalTimerIdReading=setInterval(s.modbusPollingRead,a.calc_rateByUnit(s.rate,s.rateUnit)))},s.initializeReadingTimer=function(){s.resetAllReadingTimer(),s.delayOnStart?(t("initializeReadingTimer delay timer node "+s.id),s.delayTimerReading=setTimeout(s.startIntervalReading,s.INPUT_TIMEOUT_MILLISECONDS*s.startDelayTime)):s.startIntervalReading()},s.removeNodeListenerFromModbusClient=function(){i.removeListener("mbinit",s.onModbusInit),i.removeListener("mbqueue",s.onModbusQueue),i.removeListener("mbconnected",s.onModbusConnect),i.removeListener("mbactive",s.onModbusActive),i.removeListener("mberror",s.onModbusError),i.removeListener("mbclosed",s.onModbusClose),i.removeListener("mbbroken",s.onModbusBroken),i.removeListener("mbregister",s.onModbusRegister),i.removeListener("mbderegister",s.onModbusClose)},this.on("close",function(e){s.resetAllReadingTimer(),s.removeNodeListenerFromModbusClient(),n("closed"),t("close node "+s.id),i.deregisterForModbus(s.id,e)}),s.showStatusActivities&&(i.on("mbinit",s.onModbusInit),i.on("mbqueue",s.onModbusQueue)),i.on("mbconnected",s.onModbusConnect),i.on("mbactive",s.onModbusActive),i.on("mberror",s.onModbusError),i.on("mbclosed",s.onModbusClose),i.on("mbbroken",s.onModbusBroken),i.on("mbregister",s.onModbusRegister),i.on("mbderegister",s.onModbusClose),i.registerForModbus(s))}),r.httpAdmin.post("/modbus/read/inject/:id",r.auth.needsPermission("modbus.inject.write"),function(t,i){t=r.nodes.getNode(t.params.id);if(t)try{t.modbusPollingRead(),i.sendStatus(200)}catch(e){i.sendStatus(500),t.error(r._("modbusinject.failed",{error:e.toString()}))}else i.sendStatus(404)})};
//# sourceMappingURL=maps/modbus-read.js.map
