--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: Payload Group "UB40"
version: 5
description: Group of payload detectors.
bundle_description: $VAR1 = {
          'Joomla' => 'Content Management System for building web sites.',
          'TIME.com' => 'Webportal for TIME Magazine.',
          'Tvigle' => 'Russian Video syndication website.',
          'Zulily' => 'Online shopping aimed for Moms with childerns apparel and home decor items.',
          'Picasa' => 'Google picasa is an image organizer and image viewer for organizing and editing digital photos, plus an integrated photo-sharing website.',
          'Harvard University' => 'Official website for Harvard University, Educational Institute.',
          'J.P. Morgan' => 'Financial services arm of J.P. Morgan Chase & Co.',
          'Nest Thermostat' => 'Manufactures of sensor driven Thermostats which are self-learning and programmable.',
          'MovieTickets.com' => 'Webportal for advanced movie ticketing, reviews and celebrity interviews.',
          'ConnMan' => 'Plug-in for managing internet connectivity in the linux based embedded devices.',
          'Zattoo' => 'Internet protocol television.',
          'Websense' => 'Company which produces Cyber security related products.',
          'Library of Congress' => 'Online collection of American history memories and culture.',
          'Comcast Mail' => 'Email service provided by Comcast.',
          'Bandcamp' => 'Explore online music posted by independendent artist.',
          'Zbigz' => 'Online BitTorrent Client.',
          'Kodi' => 'Open source media player.',
          'NAI' => 'Network Advertising Initiative - association comprises of 3rd party ad companies and educate consumers with online advertising.',
          'GNU Project' => 'Aggregates free software for Unix-compatible system.',
          'KVOA.com' => 'NBC-affiliated news channel for Tucson, Arizona.',
          'Coursera' => 'Educational site connecting people, offer online courses from top universities.',
          'Stanford University' => 'Official website for Stanford University, Educational Institute.',
          'European Union' => 'Official website for European Union.',
          'Jimdo' => 'Portal for to creating web site/blog.',
          'BBB' => 'Better Business Bureau - non-profit organization providing reliable business review.',
          'Indiegogo' => 'Online Fund raiser for new ideas/products.',
          'Gazprom Media' => 'Russian media group comprises television, radio, advertising, movie theaters and etc.',
          'HugeDomains.com' => 'Domain hosting service.',
          'Lycos' => 'Search engine also offers email, web hosting and social networking.',
          'Xfire' => 'Instant Messenger for gamers.',
          'Merriam-Webster' => 'Online dictionary and thesaurus.',
          'OwnerIQ' => 'Advertisement site.',
          'Google Translate' => 'Google translation service.',
          'Parallels' => 'Cloud services enablement and virtual access.',
          'bitly' => 'Web portal for bookmarking and sharing links.',
          'Skype' => 'A software application that allows users to chat, make voice/video calls, and transfer files over the Internet.',
          'Phoca' => 'Software components useful for web design.',
          'Amazon Cloud Player' => 'Media player by Amazon facilitates listening music from cloud or download on the device.',
          'Creative Commons' => 'Non-profit organization to share your creativity legally without losing the credits.',
          'SFGate' => 'Bay area news portal.',
          'TinyURL' => 'Shortens the long URL.',
          'Bluehost' => 'Web hosting portal.',
          'MailChimp' => 'Email service provider.',
          'CTV' => 'Canadian Television network.',
          'phpBB' => 'PHP based open source bulletin board software.',
          'AddToAny' => 'Social bookmarking and sharing platform.',
          'Google APIs' => 'Google Application Programming Interfaces that support the development of web applications that leverage Google services.',
          'CTV News' => 'News channel by CTV.',
          'eRecht24' => 'Russian Web portal for all legal related information.',
          'OverBlog' => 'Platform to create blogs.',
          'Viddler' => 'Online Video hosting service.'
        };

--]]

require "DetectorCommon"


local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "payload_group_bitters",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

--serviceId, clientId, ClientType, PayloadId, PayloadType, hostPattern, pathPattern, schemePattern, queryPattern
gUrlPatternList = {

    -- nest
    { 0, 0, 0, 1247, 22, "nest.com", "/", "http:", "", 2749},
    -- CTV
    { 0, 0, 0, 1248, 22, "ctv.ca", "/", "http:", "", 2750},
    -- CTV News
    { 0, 0, 0, 1249, 22, "ctvnews.ca", "/", "http:", "", 2751},
    { 0, 0, 0, 1249, 22, "ctvnews.cookieless.ca", "/", "http:", "", 2751},
    -- Indiegogo
    { 0, 0, 0, 1250, 22, "indiegogo.com", "/", "http:", "", 2752},
    -- KVOA
    { 0, 0, 0, 1251, 22, "kvoa.com", "/", "http:", "", 2753},
    { 0, 0, 0, 1251, 22, "kvoaweather.cordillera.tv", "/", "http:", "", 2753},
    -- MailChimp
    { 0, 0, 0, 1252, 22, "mailchimp.com", "/", "http:", "", 2754},
    -- MovieTickets.com
    { 0, 0, 0, 1253, 31, "movietickets.com", "/", "http:", "", 2755},
    { 0, 0, 0, 1253, 31, "movieticketscom.122.2o7.net", "/", "http:", "", 2755},
    -- Google APIs
    { 0, 0, 0, 1254, 22, "googleapis.com", "/", "http:", "", 178},
    -- Skype
    { 0, 0, 0, 1255, 22, "skype.com", "/", "http:", "", 832},
    -- Comcast Mail
    { 0, 0, 0, 1256, 22, "mail.comcast.net", "/", "http:", "", 2756},
    -- Coursera
    { 0, 0, 0, 1257, 22, "coursera.org", "/", "http:", "", 2757},
    { 0, 0, 0, 1257, 22, "coursera.com", "/", "http:", "", 2757},
    -- Kodi
    { 0, 0, 0, 1258, 22, "xbmc.org", "/", "http:", "", 2758},
    { 0, 0, 0, 1258, 22, "kodi.tv", "/", "http:", "", 2758},
    -- Gazprom Media
    { 0, 0, 0, 1259, 22, "gazprom-media.com", "/", "http:", "", 2760},
    -- Tvigle
    { 0, 0, 0, 1260, 22, "tvigle.ru", "/", "http:", "", 2761},
    { 0, 0, 0, 1260, 22, "tvigle.com", "/", "http:", "", 2761},
    --  J.P. Morgan
    { 0, 0, 0, 1261, 22, "jpmorgan.com", "/", "http:", "", 2140},
    { 0, 0, 0, 1261, 22, "jpmm.com", "/", "http:", "", 2140},
    --  Bandcamp
    { 0, 0, 0, 1262, 22, "bandcamp.com", "/", "http:", "", 2762},
    { 0, 0, 0, 1262, 22, "bcbits.com", "/", "http:", "", 2762},
    --  Bluehost
    { 0, 0, 0, 1264, 22, "bluehostforum.com", "/", "http:", "", 2764},
    { 0, 0, 0, 1264, 22, "bluehost.com", "/", "http:", "", 2764},
    { 0, 0, 0, 1264, 22, "bluehost-cdn.com", "/", "http:", "", 2764},
    --  SFGate 
    { 0, 0, 0, 1265, 33, "sfgate.com", "/", "http:", "", 2765},
    --  Library of Congress
    { 0, 0, 0, 1266, 22, "loc.gov", "/", "http:", "", 2766},
    --  OverBlog
    { 0, 0, 0, 1267, 22, "over-blog.com", "/", "http:", "", 2767},
    { 0, 0, 0, 1267, 22, "over-blog.net", "/", "http:", "", 2767},
    { 0, 0, 0, 1267, 22, "overblog.com", "/", "http:", "", 2767},
    { 0, 0, 0, 1267, 22, "over-blog-kiwi.com", "/", "http:", "", 2767},
    --  BBB
    { 0, 0, 0, 1268, 22, "bbb.org", "/", "http:", "", 2768},
    { 0, 0, 0, 1268, 22, "bbb.com", "/", "http:", "", 2768},
    --  AddToAny
    { 0, 0, 0, 1269, 22, "addtoany.com", "/", "http:", "", 2769},
    --  TIME.com
    { 0, 0, 0, 1270, 22, "time.com", "/", "http:", "", 2770},
    { 0, 0, 0, 1270, 22, "timeinc.net", "/", "http:", "", 2770},
    --  Phoca
    { 0, 0, 0, 1271, 22, "phoca.cz", "/", "http:", "", 2771},
    --  phpBB
    { 0, 0, 0, 1272, 22, "phpbb.com", "/", "http:", "", 2772},
    --  HugeDomains.com
    { 0, 0, 0, 1273, 22, "hugedomains.com", "/", "http:", "", 2773},
    --  GNU Project
    { 0, 0, 0, 1274, 22, "gnu.org", "/", "http:", "", 2774},
    --  Lycos
    { 0, 0, 0, 1275, 22, "lycos.com", "/", "http:", "", 2775},
    --  ConnMan
    { 0, 0, 0, 1276, 22, "connman.net", "/", "http:", "", 2776},
    --  Creative Commons
    { 0, 0, 0, 1277, 22, "creativecommons.org", "/", "http:", "", 2777},
    --  NAI
    { 0, 0, 0, 1278, 22, "networkadvertising.org", "/", "http:", "", 2778},
    -- Joomla
    { 0, 0, 0, 1279, 22, "joomla.org", "/", "http:", "", 2779},
    { 0, 0, 0, 1279, 22, "joomlacode.org", "/", "http:", "", 2779},
    -- TinyURL
    { 0, 0, 0, 1280, 22, "tinyurl.com", "/", "http:", "", 2780},
    -- Jimdo
    { 0, 0, 0, 1281, 22, "jimdo.com", "/", "http:", "", 2782},
    -- Stanford University
    { 0, 0, 0, 1282, 22, "stanford.edu", "/", "http:", "", 2783},
    { 0, 0, 0, 1282, 22, "gostanford.edu", "/", "http:", "", 2783},
    { 0, 0, 0, 1282, 22, "gostanford.com", "/", "http:", "", 2783},
    -- Harvard University
    { 0, 0, 0, 1283, 22, "harvard.edu", "/", "http:", "", 2784},
    -- eRecht24
    { 0, 0, 0, 1284, 22, "e-recht24.de", "/", "http:", "", 2785},
    -- European Union
    { 0, 0, 0, 1285, 22, "europa.eu", "/", "http:", "", 2786},
    -- bitly
    { 0, 0, 0, 1286, 22, "bitly.com", "/", "http:", "", 2787},
    -- Viddler 
    { 0, 0, 0, 1287, 1, "viddler.com", "/", "http:", "", 2788},
    -- Merriam-Webster
    { 0, 0, 0, 1288, 22, "merriam-webster.com", "/", "http:", "", 2789},
    -- Websense
    { 0, 0, 0, 1289, 22, "websense.com", "/", "http:", "", 2790},
    { 0, 0, 0, 1289, 22, "websense.tt.omtrdc.net", "/", "http:", "", 2790},
    -- ZbigZ
    { 0, 0, 0, 1290, 22, "zbigz.com", "/", "http:", "", 2791},
    -- Zulily
    { 0, 0, 0, 1291, 22, "zulily.com", "/", "http:", "", 2792},
    -- Zattoo
    { 0, 0, 0, 1292, 22, "zattoo.com", "/", "http:", "", 2793},
    -- Xfire 
    { 0, 0, 0, 1293, 22, "xfire.com", "/", "http:", "", 2794},
    -- Picasa
    { 0, 0, 0, 1294, 22, "picasa.google.com", "/", "http:", "", 785},
    { 0, 0, 0, 1294, 22, "picasa.com", "/", "http:", "", 785},
    { 0, 0, 0, 1294, 22, "picasaweb.com", "/", "http:", "", 785},
    -- Google Translate
    { 0, 0, 0, 1295, 22, "translate.google.com", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ac", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ad", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ae", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.af", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ag", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ai", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.al", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.am", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ao", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ar", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.as", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.at", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.au", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.az", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ba", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bd", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.be", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bf", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bh", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bi", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bj", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bn", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bo", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.br", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bs", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bt", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bw", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.by", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.bz", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ca", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.kh", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cc", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cd", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cf", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cat", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ch", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ci", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ck", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cl", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cm", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cn", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.co", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cr", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cu", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cv", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cy", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.cz", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.de", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.dj", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.dk", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.dm", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.do", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.dz", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ec", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ee", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.eg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.es", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.et", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.fi", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.fj", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.fm", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.fr", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ga", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ge", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gf", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gh", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gi", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gl", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gm", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gp", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gr", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gt", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.gy", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.hk", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.hn", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.hr", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ht", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.hu", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.id", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.iq", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ie", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.il", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.im", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.in", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.io", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.is", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.it", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.je", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.jm", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.jo", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.jp", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ke", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ki", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.kg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.kr", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.kw", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.kz", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.la", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.lb", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.lc", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.li", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.lk", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ls", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.lt", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.lu", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.lv", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ly", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ma", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.md", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.me", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mk", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ml", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mm", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mn", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ms", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mt", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mu", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mv", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mw", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mx", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.my", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.mz", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.na", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ne", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.nf", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ng", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ni", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.nl", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.no", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.np", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.nr", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.nu", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.nz", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.om", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.pk", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.pa", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.pe", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ph", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.pl", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.pg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.pn", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.pr", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ps", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.pt", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.py", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.qa", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ro", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.rs", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ru", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.rw", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sa", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sb", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sc", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.se", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sh", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.si", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sk", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sl", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sn", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sm", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.so", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.st", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sr", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.sv", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.td", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.th", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tj", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tk", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tl", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tm", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.to", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tn", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tr", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tt", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tw", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.tz", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ua", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ug", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.uk", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.us", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.uy", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.uz", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.vc", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ve", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.vg", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.vi", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.vn", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.vu", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.ws", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.za", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.zm", "/", "http:", "", 185},
    { 0, 0, 0, 1295, 22, "translate.google.zw", "/", "http:", "", 185},
    -- Parallels
    { 0, 0, 0, 1296, 22, "parallels.com", "/", "http:", "", 2802},
    -- OwnerIQ
    { 0, 0, 0, 1297, 22, "owneriq.com", "/", "http:", "", 2495},

}


function DetectorInit(detectorInstance)
-- ClientType, DHPSequence,  serviceId, clientId, PayloadId,  hostPattern, pathPattern, schemePattern, queryPattern
    gDetector = detectorInstance;

    -- nest 
    gDetector:addHttpPattern(2, 5, 0, 427, 19, 0, 0, 'Nest/', 2749);
    gDetector:addHttpPattern(2, 5, 0, 427, 19, 0, 0, 'AddLightness/', 2749);
    -- Kodi
    gDetector:addHttpPattern(2, 5, 0, 428, 19, 0, 0, 'XBMC/', 2758);
    gDetector:addHttpPattern(2, 5, 0, 428, 19, 0, 0, 'Kodi/', 2758);
    -- ConnMan
    gDetector:addHttpPattern(2, 5, 0, 432, 23, 0, 0, 'ConnMan/', 2776);
    -- Amazon Cloud Player
    gDetector:addHttpPattern(2, 5, 0, 433, 18, 0, 0, 'AmazonCloudPlayer/', 2781);
    -- Zattoo
    gDetector:addHttpPattern(2, 5, 0, 434, 19, 0, 0, 'Zattoo/', 2793);
 
    if gDetector.addAppUrl then
        for i,v in ipairs(gUrlPatternList) do
            gDetector:addAppUrl(v[1],v[2],v[3],v[4],v[5],v[6],v[7],v[8],v[9],v[10]);
        end
    end

    return gDetector;
end

function DetectorClean()
end

