--[[
# Copyright 2001-2014 Cisco Systems, Inc. and/or its affiliates. All rights
# reserved.
#
# This file contains proprietary Detector Content created by Cisco Systems,
# Inc. or its affiliates ("Cisco") and is distributed under the GNU General
# Public License, v2 (the "GPL").  This file may also include Detector Content
# contributed by third parties. Third party contributors are identified in the
# "authors" file.  The Detector Content created by Cisco is owned by, and
# remains the property of, Cisco.  Detector Content from third party
# contributors is owned by, and remains the property of, such third parties and
# is distributed under the GPL.  The term "Detector Content" means specifically
# formulated patterns and logic to identify applications based on network
# traffic characteristics, comprised of instructions in source code or object
# code form (including the structure, sequence, organization, and syntax
# thereof), and all documentation related thereto that have been officially
# approved by Cisco.  Modifications are considered part of the Detector
# Content.
--]]
--[[
detection_name: SSL Group "353"
version: 2
description: Group of SSL Host detectors.
bundle_description: $VAR1 = {
          'Naukri.com' => 'Indian job portal.',
          'Quizlet' => 'Online learning tool.',
          'Taleo' => 'Cloud-based talent management software vendor acquired by Oracle.',
          'U.S State' => 'U.S. Department of State website.',
          'NetSuite' => 'Advertising and marketing services.',
          'Nice' => 'Software solutions for call centers.',
          'Cydia' => 'An appstore for jailbroken IOS devices.',
          'Medium' => 'Online publishing platform.',
          'Elisa Viihde' => 'A Finnish telecommunications company.',
          'Google G-Suite' => 'Google\'s suite of intelligent apps.',
          'TribunNews' => 'Indonesian news website.',
          'Nametests' => 'News web site.',
          'Qatar Ministry of Interior' => 'Qatar Ministry of Interior official website.',
          'Avito' => 'Russian online marketplace.',
          'PixaBay' => 'Website for sharing high quality public domain photos, illustrations, vector graphics, and film footage.',
          'Boom Beach' => 'A web-based game.',
          'Blackbaud' => 'Fundraising software company.',
          'Pixnet' => 'Online Taiwanese mobile photo sharing, blogging, and social networking service.',
          'ADP Resource' => 'An ADP payroll solution website.',
          'ADP GlobalView' => 'An ADP payroll solution website.',
          'Azar Live' => 'Instant messaging and video.',
          'Bukalapak' => 'Online marketplace for retail goods.',
          'Behance' => 'Showcase for artwork.',
          'Beeg' => 'Adult video streaming site.',
          'blog.jp' => 'Japanese blogging site.',
          'ASKfm' => 'Question and answer themed search engine.',
          'Merdeka.com' => 'Indonesian news site.',
          'OneDio' => 'Turkish media platform which provides video, short & funny lists, tests & breaking news.',
          'GoToWebinar' => 'Citrix GoToMeeting service focused on delivering online seminars.',
          'Cerner Corporation' => 'Health care information systems.',
          'MoPub' => 'Mobile ad traffic.',
          'Ultimate Software' => 'HR and payroll software.',
          'SuccessFactors' => 'Cloud-based human resources solutions.',
          'MTV3' => 'Finnish commercial television station.',
          '1fichier' => 'Cloud storage service.',
          'Pixiv' => 'Japanese online community for artists.',
          'Mama.cn' => 'A website that communicates knowledge about infants and young children, sharing parenting experiences and family life experiences.',
          'ADP' => 'Payroll services.',
          'LeadLander' => 'Visiting websites which use LeadLander services to track customers.',
          'Youth.cn' => 'A website for the Communist Youth League of China.',
          'MS CDN' => 'Traffic relating to Microsoft Azure\'s Content Delivery Network. Traffic going to and from msecnd.net.',
          'ADP Streamline' => 'An ADP payroll solution website.',
          'The Sport Bible' => 'Latest sport news website.',
          'Manorama' => 'Daily morning newspaper, in Malayalam language.',
          'Viaplay' => 'Video on Demand service which offers films, sports, and TV series.',
          'Qatar Airways' => 'Qatar Airways Company official website.',
          'Albawaba' => 'Middle Eastern news.',
          'Xiaomi' => 'Chinese electronics company which develops and sells smartphones, mobile apps, laptops, and related consumer electronics.',
          'Blogfa' => 'Persian language blogging site.',
          'Onavo' => 'Data management app for iOS and Android.',
          'Uber' => 'Ride sharing application.',
          'Yle Areena' => 'Finland\'s national public broadcasting company.',
          'QuickBase' => 'Intuit business management software.',
          'NowNews' => 'Beirut-based Lebanese news website.',
          'ADP TotalSource' => 'An ADP payroll solution website.',
          '9Gag' => 'Meme aggregation site.',
          'Baike.com' => 'Social networking site.',
          'Yemonisoni' => 'Mobile ad traffic.',
          'PopCash' => 'Advertising platform.',
          'Onet' => 'Polish news web portal.',
          'ResearchGate' => 'A social networking site for scientists and researchers to share papers, ask and answer questions, and find collaborators.',
          'Marine Traffic' => 'Real-time information on the movements of ships in harbours and ports.',
          'State Bank of India' => 'Internet banking service provided by State Bank of India.',
          'Lyft' => 'Transportation network company offering car rides.',
          'ADP Workforce Now' => 'An ADP payroll solution website.',
          'GungHo Online Entertainment' => 'A Japanese game developer that produces console and mobile games.',
          'Circuit' => 'A Team collaboration tool with messaging, video, document and screen sharing.',
          'Russia Today' => 'Russian government run news website.',
          'Dealertrack' => 'Automobile dealership related Software-as-a-Service.',
          'Google APIs' => 'Google Application Programming Interfaces that support the development of web applications that leverage Google services.',
          'Orange' => 'French multinational telecommunications corporation.',
          'Paytm' => 'Indian electronic payment and e-commerce company based out of Delhi.',
          'Steam social networking' => 'Steam social networking traffic.',
          'Walkme' => 'Software-as-a-service company that helps users navigate the features of other web-based services.',
          'Ghaneely' => 'Music streaming service.',
          'Oman Airways' => 'Oman Airways official website.',
          'Souq' => 'An English-Arabic language e-commerce platform.',
          'PopAds' => 'Advertising network specialized in popunders on the Internet.',
          'TEEPR' => 'Chinese news site.',
          'Watan' => 'An Arabic newspaper.',
          'Zalo' => 'Free messaging and calling application.',
          'Ndtv' => 'Web site of Indian television media company.',
          'QuickBooks' => 'Intuit online accounting software.',
          'Sony LIV' => 'Entertainment media providing Video On Demand services.',
          'CNTV' => 'Chinese online news portal aorund the world.',
          'Qiita' => 'Technical knowledge sharing and collaboration platform for programmers.',
          'Mega' => 'Web site of cloud storage and file hosting service.',
          'Clash of Clans' => 'A web-based game.',
          'Fiesta' => 'Games website.',
          'OfferJuice' => 'General offerjuice.me website traffic.',
          'Xfinity' => 'A US cable television, telephone, & internet services provider.'
        };

--]]

require "DetectorCommon"

local DC = DetectorCommon

DetectorPackageInfo = {
    name =  "ssl_host_group_353",
    proto =  DC.ipproto.tcp,
    client = {
        init =  'DetectorInit',
        clean =  'DetectorClean',
        minimum_matches =  1
    }
}

gSSLHostPatternList = {
    -- Nice
    {0, 4661, 'nice.com', },
    {0, 4661, 'niceincontact.com', },
    {0, 4661, 'nice-incontact.com', },
    {0, 4661, 'incontact.com', },
    -- Walkme
    {0, 4600, 'walkme.com', },
    -- Sony LIV
    {0, 4567, 'sonyliv.com', },
    -- Lyft
    {0, 4566, 'lyft.com', },
    -- Yle Areena
    {0, 4565, 'yle.fi', },
    -- Viaplay
    {0, 4564, 'viaplay.tv', },
    {0, 4564, 'viaplay.com', },
    -- MTV3
    {0, 4563, 'katsomo.fi', },
    {0, 4563, 'mtv.fi', },
    {0, 4563, 'mtv_fi_api.frosomo.com', },
    -- Elisa Viihde
    {0, 4561, 'elisa.fi', },
    -- Watan
    {0, 4538, 'watanserb.com', },
    -- Oman Airways
    {0, 4537, 'omanair.com', },
    -- U.S State
    {0, 4532, 'state.gov', },
    {0, 4532, 'usa.gov', },
    -- Marine Traffic
    {0, 4517, 'marinetraffic.com', },
    -- Xiaomi
    {0, 4386, 'mi.com', },
    {0, 4386, 'appmifile.com', },
    {0, 4386, 'miui.com', },
    -- Youth.cn
    {0, 4383, 'youth.cn', },
    -- Xfinity
    {0, 4376, 'xfinity.com', },
    -- CNTV
    {0, 4310, 'cntv.cn', },
    -- TribunNews
    {0, 4301, 'tribunnews.com', },
    {0, 4301, 'tstatic.net', },
    -- The Sport Bible
    {0, 4298, 'sportbible.com', },
    -- TEEPR
    {0, 4296, 'teepr.com', },
    {0, 4296, 'tamedia.com.tw', },
    -- Taleo
    {0, 4294, 'taleo.net', },
    -- Souq
    {0, 4288, 'souq.com', },
    -- Bukalapak
    {0, 4247, 'bukalapak.com', },
    -- blog.jp
    {0, 4245, 'blog.jp', },
    -- Blogfa
    {0, 4244, 'blogfa.com', },
    -- PopCash
    {0, 4235, 'popcash.net', },
    -- PopAds
    {0, 4234, 'popads.net', },
    -- Pixnet
    {0, 4233, 'pixnet.net', },
    -- Pixiv
    {0, 4232, 'pixiv.net', },
    {0, 4232, 'pixiv.org', },
    {0, 4232, 'pximg.net', },
    {0, 4232, 'ads-pixiv.net', },
    {0, 4232, 'pixiv-recommend.net', },
    -- PixaBay
    {0, 4231, 'pixabay.com', },
    -- Paytm
    {0, 4230, 'paytm.com', },
    {0, 4230, 'getpaytm.com', },
    -- Orange
    {0, 4226, 'orange.com', },
    -- Onet
    {0, 4224, 'onet.pl', },
    -- OneDio
    {0, 4223, 'onedio.co', },
    -- OfferJuice
    {0, 4219, 'offerjuice.me', },
    -- NowNews
    {0, 4216, 'nownews.com', },
    -- Ndtv
    {0, 4215, 'ndtv.com', },
    {0, 4215, 'ndtvimg.com', },
    -- Naukri.com
    {0, 4214, 'naukri.com', },
    -- Nametests
    {0, 4213, 'nametests.com', },
    -- Merdeka.com
    {0, 4209, 'merdeka.com', },
    -- Mega
    {0, 4208, 'mega.co.nz', },
    {0, 4208, 'mega.nz', },
    -- Medium
    {0, 4207, 'medium.com', },
    -- Manorama
    {0, 4205, 'manoramaonline.com', },
    -- Mama.cn
    {0, 4204, 'mama.cn', },
    {0, 4204, 'cdnmama.com', },
    -- State Bank of India
    {0, 4202, 'onlinesbi.com', },
    -- Russia Today
    {0, 4195, 'rt.com', },
    -- ResearchGate
    {0, 4194, 'researchgate.net', },
    -- Quizlet
    {0, 4189, 'quizlet.com', },
    -- Qatar Ministry of Interior
    {0, 4187, 'portal.moi.gov.qa', },
    -- Qiita
    {0, 4186, 'qiita.com', },
    -- Qatar Airways
    {0, 4182, 'qatarairways.com', },
    -- Behance
    {0, 4180, 'behance.net', },
    -- Beeg
    {0, 4179, 'beeg.com', },
    -- Baike.com
    {0, 4178, 'baike.com', },
    -- Avito
    {0, 4175, 'avito.ma', },
    -- ASKfm
    {0, 4173, 'ask.fm', },
    -- Albawaba
    {0, 4172, 'albawaba.com', },
    -- 9Gag
    {0, 4167, '9gag.com', },
    -- 1fichier
    {0, 4165, '1fichier.com', },
    -- Ghaneely
    {0, 4158, 'binarywaves.com', },
    -- Azar Live
    {0, 4156, 'azarlive.com', },
    -- Uber
    {0, 4137, 'uber.com', },
    -- Google G-Suite
    {0, 4126, 'workspace.google.com', },
    -- Circuit
    {0, 4113, 'circuit.com', },
    -- Cydia
    {0, 4099, 'cydia.com', },
    {0, 4099, 'cydia.saurik.com', },
    -- Clash of Clans
    {0, 4095, 'clashofclans.com', },
    -- Boom Beach
    {0, 4093, 'boombeach.com', },
    -- MoPub
    {0, 4085, 'mopub.com', },
    -- Yemonisoni
    {0, 4083, 'yemonisoni.com', },
    -- Fiesta
    {0, 4077, 'fiesta.gamigo.com', },
    -- Ultimate Software
    {0, 3944, 'ultimatesoftware.com', },
    -- QuickBooks
    {0, 3936, 'quickbooks.intuit.com', },
    {0, 3936, 'quickbooksconnect.com', },
    -- QuickBase
    {0, 3935, 'quickbase.com', },
    -- Dealertrack
    {0, 3933, 'dealertrack.com', },
    -- Cerner Corporation
    {0, 3930, 'cerner.com', },
    -- ADP Workforce Now
    {0, 3928, 'workforcenow.adp.com', },
    -- ADP TotalSource
    {0, 3926, 'totalsource.adp.com', },
    -- ADP Streamline
    {0, 3925, 'streamline.adp.com', },
    -- ADP Resource
    {0, 3924, 'resource-secure.adp.com', },
    -- ADP GlobalView
    {0, 3923, 'globalview.adp.com', },
    -- ADP
    {0, 3922, 'adp.com', },
    -- SuccessFactors
    {0, 3901, 'successfactors.com', },
    -- Onavo
    {0, 3893, 'onavo.com', },
    -- NetSuite
    {0, 3892, 'netsuite.com', },
    -- Blackbaud
    {0, 3889, 'blackbaud.com', },
    -- GungHo Online Entertainment
    {0, 3853, 'gunghoonline.com', },
    {0, 3853, 'gungho.co.jp', },
    -- LeadLander
    {0, 3821, 'leadlander.com', },
    -- MS CDN
    {0, 2811, 'az416426.vo.msecdn.net', },
    {0, 2811, 'msecdn.net', },
    -- GoToWebinar
    {0, 2641, 'gotowebinar.com', },
    -- Steam social networking
    {0, 1155, 'steamcommunity.com', },
    -- Google APIs
    {0, 178, 'googleapis.com', },
    -- Mega
    {0, 4208, 'mega.io', },
    -- Zalo
    {0, 4662, 'zalo.me', },
    {0, 4662, 'zadn.vn', },
    {0, 4662, 'zdn.vn', },
    {0, 4662, 'zaloapp.com', },
    {0, 4662, 'zalo.zadn.vn', },
}

gSSLCnamePatternList = {
    -- Nice
    {0, 4661, 'nice.com', },
    {0, 4661, 'niceincontact.com', },
    {0, 4661, 'nice-incontact.com', },
    {0, 4661, 'incontact.com', },
    -- Walkme
    {0, 4600, 'walkme.com', },
    -- Sony LIV
    {0, 4567, 'sonyliv.com', },
    -- Lyft
    {0, 4566, 'lyft.com', },
    -- Yle Areena
    {0, 4565, 'yle.fi', },
    -- Viaplay
    {0, 4564, 'viaplay.tv', },
    {0, 4564, 'viaplay.com', },
    -- MTV3
    {0, 4563, 'katsomo.fi', },
    {0, 4563, 'mtv.fi', },
    {0, 4563, 'mtv_fi_api.frosomo.com', },
    -- Elisa Viihde
    {0, 4561, 'elisa.fi', },
    -- Watan
    {0, 4538, 'watanserb.com', },
    -- Oman Airways
    {0, 4537, 'omanair.com', },
    -- U.S State
    {0, 4532, 'state.gov', },
    {0, 4532, 'usa.gov', },
    -- Marine Traffic
    {0, 4517, 'marinetraffic.com', },
    -- Xiaomi
    {0, 4386, 'mi.com', },
    {0, 4386, 'appmifile.com', },
    {0, 4386, 'miui.com', },
    -- Youth.cn
    {0, 4383, 'youth.cn', },
    -- Xfinity
    {0, 4376, 'xfinity.com', },
    -- CNTV
    {0, 4310, 'cntv.cn', },
    -- TribunNews
    {0, 4301, 'tribunnews.com', },
    {0, 4301, 'tstatic.net', },
    -- The Sport Bible
    {0, 4298, 'sportbible.com', },
    -- TEEPR
    {0, 4296, 'teepr.com', },
    {0, 4296, 'tamedia.com.tw', },
    -- Taleo
    {0, 4294, 'taleo.net', },
    -- Souq
    {0, 4288, 'souq.com', },
    -- Bukalapak
    {0, 4247, 'bukalapak.com', },
    -- blog.jp
    {0, 4245, 'blog.jp', },
    -- Blogfa
    {0, 4244, 'blogfa.com', },
    -- PopCash
    {0, 4235, 'popcash.net', },
    -- PopAds
    {0, 4234, 'popads.net', },
    -- Pixnet
    {0, 4233, 'pixnet.net', },
    -- Pixiv
    {0, 4232, 'pixiv.net', },
    {0, 4232, 'pixiv.org', },
    {0, 4232, 'pximg.net', },
    {0, 4232, 'ads-pixiv.net', },
    {0, 4232, 'pixiv-recommend.net', },
    -- PixaBay
    {0, 4231, 'pixabay.com', },
    -- Paytm
    {0, 4230, 'paytm.com', },
    {0, 4230, 'getpaytm.com', },
    -- Orange
    {0, 4226, 'orange.com', },
    -- Onet
    {0, 4224, 'onet.pl', },
    -- OneDio
    {0, 4223, 'onedio.co', },
    -- OfferJuice
    {0, 4219, 'offerjuice.me', },
    -- NowNews
    {0, 4216, 'nownews.com', },
    -- Ndtv
    {0, 4215, 'ndtv.com', },
    {0, 4215, 'ndtvimg.com', },
    -- Naukri.com
    {0, 4214, 'naukri.com', },
    -- Nametests
    {0, 4213, 'nametests.com', },
    -- Merdeka.com
    {0, 4209, 'merdeka.com', },
    -- Mega
    {0, 4208, 'mega.co.nz', },
    {0, 4208, 'mega.nz', },
    -- Medium
    {0, 4207, 'medium.com', },
    -- Manorama
    {0, 4205, 'manoramaonline.com', },
    -- Mama.cn
    {0, 4204, 'mama.cn', },
    {0, 4204, 'cdnmama.com', },
    -- State Bank of India
    {0, 4202, 'onlinesbi.com', },
    -- Russia Today
    {0, 4195, 'rt.com', },
    -- ResearchGate
    {0, 4194, 'researchgate.net', },
    -- Quizlet
    {0, 4189, 'quizlet.com', },
    -- Qatar Ministry of Interior
    {0, 4187, 'portal.moi.gov.qa', },
    -- Qiita
    {0, 4186, 'qiita.com', },
    -- Qatar Airways
    {0, 4182, 'qatarairways.com', },
    -- Behance
    {0, 4180, 'behance.net', },
    -- Beeg
    {0, 4179, 'beeg.com', },
    -- Baike.com
    {0, 4178, 'baike.com', },
    -- Avito
    {0, 4175, 'avito.ma', },
    -- ASKfm
    {0, 4173, 'ask.fm', },
    -- Albawaba
    {0, 4172, 'albawaba.com', },
    -- 9Gag
    {0, 4167, '9gag.com', },
    -- 1fichier
    {0, 4165, '1fichier.com', },
    -- Ghaneely
    {0, 4158, 'binarywaves.com', },
    -- Azar Live
    {0, 4156, 'azarlive.com', },
    -- Uber
    {0, 4137, 'uber.com', },
    -- Google G-Suite
    {0, 4126, 'workspace.google.com', },
    -- Circuit
    {0, 4113, 'circuit.com', },
    -- Cydia
    {0, 4099, 'cydia.com', },
    {0, 4099, 'cydia.saurik.com', },
    -- Clash of Clans
    {0, 4095, 'clashofclans.com', },
    -- Boom Beach
    {0, 4093, 'boombeach.com', },
    -- MoPub
    {0, 4085, 'mopub.com', },
    -- Yemonisoni
    {0, 4083, 'yemonisoni.com', },
    -- Fiesta
    {0, 4077, 'fiesta.gamigo.com', },
    -- Ultimate Software
    {0, 3944, 'ultimatesoftware.com', },
    -- QuickBooks
    {0, 3936, 'quickbooks.intuit.com', },
    {0, 3936, 'quickbooksconnect.com', },
    -- QuickBase
    {0, 3935, 'quickbase.com', },
    -- Dealertrack
    {0, 3933, 'dealertrack.com', },
    -- Cerner Corporation
    {0, 3930, 'cerner.com', },
    -- ADP Workforce Now
    {0, 3928, 'workforcenow.adp.com', },
    -- ADP TotalSource
    {0, 3926, 'totalsource.adp.com', },
    -- ADP Streamline
    {0, 3925, 'streamline.adp.com', },
    -- ADP Resource
    {0, 3924, 'resource-secure.adp.com', },
    -- ADP GlobalView
    {0, 3923, 'globalview.adp.com', },
    -- ADP
    {0, 3922, 'adp.com', },
    -- SuccessFactors
    {0, 3901, 'successfactors.com', },
    -- Onavo
    {0, 3893, 'onavo.com', },
    -- NetSuite
    {0, 3892, 'netsuite.com', },
    -- Blackbaud
    {0, 3889, 'blackbaud.com', },
    -- GungHo Online Entertainment
    {0, 3853, 'gunghoonline.com', },
    {0, 3853, 'gungho.co.jp', },
    -- LeadLander
    {0, 3821, 'leadlander.com', },
    -- MS CDN
    {0, 2811, 'az416426.vo.msecdn.net', },
    {0, 2811, 'msecdn.net', },
    -- GoToWebinar
    {0, 2641, 'gotowebinar.com', },
    -- Steam social networking
    {0, 1155, 'steamcommunity.com', },
    -- Google APIs
    {0, 178, 'googleapis.com', },
    -- Mega
    {0, 4208, 'mega.io', },
    -- Zalo
    {0, 4662, 'zalo.me', },
    {0, 4662, 'zadn.vn', },
    {0, 4662, 'zdn.vn', },
    {0, 4662, 'zaloapp.com', },
    {0, 4662, 'zalo.zadn.vn', },
}

function DetectorInit(detectorInstance)

    gDetector = detectorInstance;

    if gDetector.addSSLCertPattern then
        for i,v in ipairs(gSSLHostPatternList) do
            gDetector:addSSLCertPattern(v[1],v[2],v[3]);
        end
    end
    gSSLHostPatternList = nil

    if gDetector.addSSLCnamePattern then
        for i,v in ipairs(gSSLCnamePatternList) do
            gDetector:addSSLCnamePattern(v[1],v[2],v[3]);
        end
    end
    gSSLCnamePatternList = nil

    return gDetector;
end

function DetectorClean()
end
