/* SPDX-License-Identifier: GPL-2.0-only */

#pragma once

/**
 * See Microsemi_PoE_PD69104B1_Generic_UG_Reg_Map.pdf
 *
 * http://ww1.microchip.com/downloads/en/DeviceDoc/Microsemi_PoE_PD69104B1_Generic_UG_Reg_Map.pdf
 */

#define GENMASK(h, l) \
	(((~0UL) << (l)) & (~0UL >> (32 - 1 - (h))))


#define PD69104_REG_STATP(x)							(0xC + x)
#define PD69104_REG_STATP_DETECTION_MASK				0x07
#define PD69104_REG_STATP_DETECTION_SHIFT				0x0
#define PD69104_REG_STATP_DETECTION_SHORT_CIRCUIT		0x1
#define PD69104_REG_STATP_DETECTION_CPD_TOO_HIGH		0x2
#define PD69104_REG_STATP_DETECTION_RSIG_TOO_LOW		0x3
#define PD69104_REG_STATP_DETECTION_GOOD				0x4
#define PD69104_REG_STATP_DETECTION_RSIG_TOO_HIGH		0x5
#define PD69104_REG_STATP_DETECTION_RSIG_OPEN_CIRCUIT	0x6
#define PD69104_REG_STATP_CLASSIFICATION_MASK			0x70
#define PD69104_REG_STATP_CLASSIFICATION_SHIFT			0x4
#define PD69104_REG_STATP_CLASSIFICATION_OVER_CURRENT	0x7


#define PD69104_REG_STATPWR								0x10
#define PD69104_REG_STATPWR_PWR_ENABLED_MASK			0xF
#define PD69104_REG_STATPWR_PWR_ENABLED_SHIFT			0x0
#define PD69104_REG_STATPWR_PWR_ENABLED_PORT_MASK(x)	(0x1 << (PD69104_REG_STATPWR_PWR_ENABLED_SHIFT + x))
#define PD69104_REG_STATPWR_PWR_GOOD_MASK				0xF0
#define PD69104_REG_STATPWR_PWR_GOOD_SHIFT				0x4
#define PD69104_REG_STATPWR_PWR_GOOD_PORT_MASK(x)		(0x1 << (PD69104_REG_STATPWR_PWR_GOOD_SHIFT + x))

#define PD69104_REG_OPMD							0x12
#define PD69104_REG_OPMD_PORT_SHIFT(x)				(0x2 * x)
#define PD69104_REG_OPMD_PORT_MASK(x)				(0x3 << PD69104_REG_OPMD_PORT_SHIFT(x))
#define PD69104_REG_OPMD_SHUTDOWN					0x0
#define PD69104_REG_OPMD_MANUAL						0x1
#define PD69104_REG_OPMD_SEMI_AUTO					0x2
#define PD69104_REG_OPMD_AUTO						0x3

#define PD69104_REG_DETENA								0x14
#define PD69104_REG_DETENA_DETECTION_PORT_SHIFT(x)		(x)
#define PD69104_REG_DETENA_DETECTION_PORT_MASK(x)		(1 << PD69104_REG_DETENA_DETECTION_PORT_SHIFT(x))
#define PD69104_REG_DETENA_CLASSIFICATION_PORT_SHIFT(x)	(4 + x)
#define PD69104_REG_DETENA_CLASSIFICATION_PORT_MASK(x)	(1 << PD69104_REG_DETENA_CLASSIFICATION_PORT_SHIFT(x))

#define PD69104_REG_ID				0x1B
#define PD69104_REG_ID_REV_MASK		0x7
#define PD69104_REG_ID_REV_SHIFT	0x0
#define PD69104_REG_ID_DEV_MASK		0xF8
#define PD69104_REG_ID_DEV_SHIFT	0x3

#define PD69104_REG_FIRMWARE			0x41

#define PD69104_REG_DEVID				0x43

/* Extended Auto Mode only */
#define PD69104_REG_VTEMP				0x70

#define PD69104_REG_PORT_SR_BASE		0x75
#define PD69104_REG_PORT_SR(x)			(PD69104_REG_PORT_SR_BASE + (x < 3 ? 0 : 1))
#define PD69104_REG_PORT_SR_MASK(x)		((x % 2) == 0 ? 0x0F : 0xF0)
#define PD69104_REG_PORT_SR_SHIFT(x)	((x % 2) == 0 ? 0 : 4)
#define PD69104_REG_PORT_SR_OVER_TEMP		0x1
#define PD69104_REG_PORT_SR_OFF_PM			0x2

#define PD69104_REG_PRIO_CR				0x80

#define PD69104_REG_PWR_CR_BASE			0x81
#define PD69104_REG_PWR_CR(x)			(PD69104_REG_PWR_CR_BASE + x)
#define PD69104_REG_PWR_CR_PAL_MASK		GENMASK(5, 0)

#define PD69104_REG_PWR_BNK_BASE		0x89
#define PD69104_REG_PWR_BNK_NUM_BANKS	0x7
#define PD69104_REG_PWR_BNK(x)			(PD69104_REG_PWR_BNK_BASE + x)

#define PD69104_REG_PWRGD						0x91
#define PD69104_REG_PWRGD_PIN_STATUS_MASK		GENMASK(6, 3)
#define PD69104_REG_PWRGD_PIN_STATUS_SHIFT		3

#define PD69104_REG_PORT_CONS_BASE		0x92
#define PD69104_REG_PORT_CONS(x)			(PD69104_REG_PORT_CONS_BASE + x)
