# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class AlgorithmObjectIdentifiers:

    _name_  = u'AlgorithmObjectIdentifiers'
    _oid_   = [2, 5, 1, 8, 8]
    
    _obj_ = [
        u'ID',
        u'nullAlgorithm',
        u'encryptionAlgorithm',
        u'hashAlgorithm',
        u'signatureAlgorithm',
        u'id-ea',
        u'id-ha',
        u'id-sa',
        u'id-ea-rsa',
        u'id-ha-sqMod-n',
        u'id-sa-sqMod-nWithRSA',
        u'us-iso',
        u'ansi-x9-57',
        u'ansi-x9-62',
        u'ansi-x9-42',
        u'iso-standard',
        u'iso9797',
        u'iso-organization',
        u'certicom',
        u'certicom-curve',
        u'teletrust',
        u'ecStdCurvesAndGen',
        u'versionOne',
        u'us-joint',
        u'usgov',
        u'dodAlgorithms',
        u'csor',
        u'nistAlgorithms',
        u'aes',
        u'hashAlgs',
        u'sigAlgs',
        u'rsadsi',
        u'pkcs-1',
        u'digestAlgorithm',
        u'id-aes128-CBC',
        u'id-aes192-CBC',
        u'id-aes256-CBC',
        u'id-aes128-wrap',
        u'id-aes192-wrap',
        u'id-aes256-wrap',
        u'rsaEncryption',
        u'id-keyExchangeAlgorithm',
        u'id-dsa',
        u'id-ecPublicKey',
        u'id-ecDH',
        u'id-ecMQV',
        u'dh-public-number',
        u'id-sha1',
        u'id-sha256',
        u'id-sha384',
        u'id-sha512',
        u'id-sha224',
        u'id-sha512-224',
        u'id-sha512-256',
        u'hashAlg',
        u'sha1WithRSAEncryption',
        u'sha256WithRSAEncryption',
        u'sha384WithRSAEncryption',
        u'sha512WithRSAEncryption',
        u'sha224WithRSAEncryption',
        u'id-RSASSA-PSS',
        u'id-mgf1',
        u'id-dsa-with-sha1',
        u'id-dsa-with-sha224',
        u'id-dsa-with-sha256',
        u'ecdsa-with-SHA224',
        u'ecdsa-with-SHA256',
        u'ecdsa-with-SHA384',
        u'ecdsa-with-SHA512',
        u'secp192r1',
        u'sect163k1',
        u'sect163r2',
        u'secp224r1',
        u'sect233k1',
        u'sect233r1',
        u'secp256r1',
        u'sect283k1',
        u'sect283r1',
        u'secp384r1',
        u'sect409k1',
        u'sect409r1',
        u'secp521r1',
        u'sect571k1',
        u'sect571r1',
        u'brainpoolP160r1',
        u'brainpoolP160t1',
        u'brainpoolP192r1',
        u'brainpoolP192t1',
        u'brainpoolP224r1',
        u'brainpoolP224t1',
        u'brainpoolP256r1',
        u'brainpoolP256t1',
        u'brainpoolP320r1',
        u'brainpoolP320t1',
        u'brainpoolP384r1',
        u'brainpoolP384t1',
        u'brainpoolP512r1',
        u'brainpoolP512t1',
        u'X509Curves',
        u'id-hmacWithSHA224',
        u'id-hmacWithSHA256',
        u'id-hmacWithSHA384',
        u'id-hmacWithSHA512',
        u'id-gmac',
        u'mD5Algorithm',
        u'sha1Algorithm',
        u'sha224',
        u'sha256',
        u'sha384',
        u'sha512',
        u'HashAlgorithms',
        u'aes128-CBC',
        u'aes192-CBC',
        u'aes256-CBC',
        u'AES-InitializationVector',
        u'rsaEncryptionAlgorithm',
        u'keyExchangeAlgorithm',
        u'KEA-Parms-Id',
        u'dsa',
        u'DSS-Parms',
        u'ecPublicKey',
        u'ecDH',
        u'ecMQV',
        u'dh-public-numberAlgorithm',
        u'DomainParameters',
        u'ValidationParms',
        u'sha1WithRSAEncryptionAlgorithm',
        u'sha224WithRSAEncryptionAlgorithm',
        u'sha256WithRSAEncryptionAlgorithm',
        u'sha384WithRSAEncryptionAlgorithm',
        u'sha512WithRSAEncryptionAlgorithm',
        u'rSASSA-PSS',
        u'dsa-with-sha224',
        u'dsa-with-sha256',
        u'ecdsa-with-SHA224-Algorithm',
        u'ecdsa-with-SHA256-Algorithm',
        u'ecdsa-with-SHA384-Algorithm',
        u'ecdsa-with-SHA512-Algorithm',
        u'hmacWithSHA224',
        u'hmacWithSHA256',
        u'hmacWithSHA384',
        u'hmacWithSHA512',
        u'AllAlgorithmsOID',
        ]
    _type_ = [
        u'ID',
        u'AES-InitializationVector',
        u'KEA-Parms-Id',
        u'DSS-Parms',
        u'DomainParameters',
        u'ValidationParms',
        ]
    _set_ = [
        u'X509Curves',
        u'HashAlgorithms',
        u'AllAlgorithmsOID',
        ]
    _val_ = [
        u'nullAlgorithm',
        u'encryptionAlgorithm',
        u'hashAlgorithm',
        u'signatureAlgorithm',
        u'id-ea',
        u'id-ha',
        u'id-sa',
        u'id-ea-rsa',
        u'id-ha-sqMod-n',
        u'id-sa-sqMod-nWithRSA',
        u'us-iso',
        u'ansi-x9-57',
        u'ansi-x9-62',
        u'ansi-x9-42',
        u'iso-standard',
        u'iso9797',
        u'iso-organization',
        u'certicom',
        u'certicom-curve',
        u'teletrust',
        u'ecStdCurvesAndGen',
        u'versionOne',
        u'us-joint',
        u'usgov',
        u'dodAlgorithms',
        u'csor',
        u'nistAlgorithms',
        u'aes',
        u'hashAlgs',
        u'sigAlgs',
        u'rsadsi',
        u'pkcs-1',
        u'digestAlgorithm',
        u'id-aes128-CBC',
        u'id-aes192-CBC',
        u'id-aes256-CBC',
        u'id-aes128-wrap',
        u'id-aes192-wrap',
        u'id-aes256-wrap',
        u'rsaEncryption',
        u'id-keyExchangeAlgorithm',
        u'id-dsa',
        u'id-ecPublicKey',
        u'id-ecDH',
        u'id-ecMQV',
        u'dh-public-number',
        u'id-sha1',
        u'id-sha256',
        u'id-sha384',
        u'id-sha512',
        u'id-sha224',
        u'id-sha512-224',
        u'id-sha512-256',
        u'hashAlg',
        u'sha1WithRSAEncryption',
        u'sha256WithRSAEncryption',
        u'sha384WithRSAEncryption',
        u'sha512WithRSAEncryption',
        u'sha224WithRSAEncryption',
        u'id-RSASSA-PSS',
        u'id-mgf1',
        u'id-dsa-with-sha1',
        u'id-dsa-with-sha224',
        u'id-dsa-with-sha256',
        u'ecdsa-with-SHA224',
        u'ecdsa-with-SHA256',
        u'ecdsa-with-SHA384',
        u'ecdsa-with-SHA512',
        u'secp192r1',
        u'sect163k1',
        u'sect163r2',
        u'secp224r1',
        u'sect233k1',
        u'sect233r1',
        u'secp256r1',
        u'sect283k1',
        u'sect283r1',
        u'secp384r1',
        u'sect409k1',
        u'sect409r1',
        u'secp521r1',
        u'sect571k1',
        u'sect571r1',
        u'brainpoolP160r1',
        u'brainpoolP160t1',
        u'brainpoolP192r1',
        u'brainpoolP192t1',
        u'brainpoolP224r1',
        u'brainpoolP224t1',
        u'brainpoolP256r1',
        u'brainpoolP256t1',
        u'brainpoolP320r1',
        u'brainpoolP320t1',
        u'brainpoolP384r1',
        u'brainpoolP384t1',
        u'brainpoolP512r1',
        u'brainpoolP512t1',
        u'id-hmacWithSHA224',
        u'id-hmacWithSHA256',
        u'id-hmacWithSHA384',
        u'id-hmacWithSHA512',
        u'id-gmac',
        u'mD5Algorithm',
        u'sha1Algorithm',
        u'sha224',
        u'sha256',
        u'sha384',
        u'sha512',
        u'aes128-CBC',
        u'aes192-CBC',
        u'aes256-CBC',
        u'rsaEncryptionAlgorithm',
        u'keyExchangeAlgorithm',
        u'dsa',
        u'ecPublicKey',
        u'ecDH',
        u'ecMQV',
        u'dh-public-numberAlgorithm',
        u'sha1WithRSAEncryptionAlgorithm',
        u'sha224WithRSAEncryptionAlgorithm',
        u'sha256WithRSAEncryptionAlgorithm',
        u'sha384WithRSAEncryptionAlgorithm',
        u'sha512WithRSAEncryptionAlgorithm',
        u'rSASSA-PSS',
        u'dsa-with-sha224',
        u'dsa-with-sha256',
        u'ecdsa-with-SHA224-Algorithm',
        u'ecdsa-with-SHA256-Algorithm',
        u'ecdsa-with-SHA384-Algorithm',
        u'ecdsa-with-SHA512-Algorithm',
        u'hmacWithSHA224',
        u'hmacWithSHA256',
        u'hmacWithSHA384',
        u'hmacWithSHA512',
        ]
    _class_ = [
        u'mD5Algorithm',
        u'sha1Algorithm',
        u'sha224',
        u'sha256',
        u'sha384',
        u'sha512',
        u'HashAlgorithms',
        u'aes128-CBC',
        u'aes192-CBC',
        u'aes256-CBC',
        u'rsaEncryptionAlgorithm',
        u'keyExchangeAlgorithm',
        u'dsa',
        u'ecPublicKey',
        u'ecDH',
        u'ecMQV',
        u'dh-public-numberAlgorithm',
        u'sha1WithRSAEncryptionAlgorithm',
        u'sha224WithRSAEncryptionAlgorithm',
        u'sha256WithRSAEncryptionAlgorithm',
        u'sha384WithRSAEncryptionAlgorithm',
        u'sha512WithRSAEncryptionAlgorithm',
        u'rSASSA-PSS',
        u'dsa-with-sha224',
        u'dsa-with-sha256',
        u'ecdsa-with-SHA224-Algorithm',
        u'ecdsa-with-SHA256-Algorithm',
        u'ecdsa-with-SHA384-Algorithm',
        u'ecdsa-with-SHA512-Algorithm',
        u'hmacWithSHA224',
        u'hmacWithSHA256',
        u'hmacWithSHA384',
        u'hmacWithSHA512',
        u'AllAlgorithmsOID',
        ]
    _param_ = [
        ]
    
    #-----< ID >-----#
    ID = OID(name=u'ID', mode=MODE_TYPE)
    
    #-----< nullAlgorithm >-----#
    nullAlgorithm = OID(name=u'nullAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    nullAlgorithm._val = (2, 5, 8, 0)
    
    #-----< encryptionAlgorithm >-----#
    encryptionAlgorithm = OID(name=u'encryptionAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    encryptionAlgorithm._val = (2, 5, 8, 1)
    
    #-----< hashAlgorithm >-----#
    hashAlgorithm = OID(name=u'hashAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    hashAlgorithm._val = (2, 5, 8, 2)
    
    #-----< signatureAlgorithm >-----#
    signatureAlgorithm = OID(name=u'signatureAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    signatureAlgorithm._val = (2, 5, 8, 3)
    
    #-----< id-ea >-----#
    id_ea = OID(name=u'id-ea', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_ea._val = (2, 5, 8, 1)
    
    #-----< id-ha >-----#
    id_ha = OID(name=u'id-ha', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_ha._val = (2, 5, 8, 2)
    
    #-----< id-sa >-----#
    id_sa = OID(name=u'id-sa', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_sa._val = (2, 5, 8, 3)
    
    #-----< id-ea-rsa >-----#
    id_ea_rsa = OID(name=u'id-ea-rsa', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_ea_rsa._val = (2, 5, 8, 1, 1)
    
    #-----< id-ha-sqMod-n >-----#
    id_ha_sqMod_n = OID(name=u'id-ha-sqMod-n', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_ha_sqMod_n._val = (2, 5, 8, 2, 1)
    
    #-----< id-sa-sqMod-nWithRSA >-----#
    id_sa_sqMod_nWithRSA = OID(name=u'id-sa-sqMod-nWithRSA', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_sa_sqMod_nWithRSA._val = (2, 5, 8, 3, 1)
    
    #-----< us-iso >-----#
    us_iso = OID(name=u'us-iso', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    us_iso._val = (1, 2, 840)
    
    #-----< ansi-x9-57 >-----#
    ansi_x9_57 = OID(name=u'ansi-x9-57', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    ansi_x9_57._val = (1, 2, 840, 10040)
    
    #-----< ansi-x9-62 >-----#
    ansi_x9_62 = OID(name=u'ansi-x9-62', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    ansi_x9_62._val = (1, 2, 840, 10045)
    
    #-----< ansi-x9-42 >-----#
    ansi_x9_42 = OID(name=u'ansi-x9-42', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    ansi_x9_42._val = (1, 2, 840, 10046)
    
    #-----< iso-standard >-----#
    iso_standard = OID(name=u'iso-standard', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    iso_standard._val = (1, 0)
    
    #-----< iso9797 >-----#
    iso9797 = OID(name=u'iso9797', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    iso9797._val = (1, 0, 9797)
    
    #-----< iso-organization >-----#
    iso_organization = OID(name=u'iso-organization', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    iso_organization._val = (1, 3)
    
    #-----< certicom >-----#
    certicom = OID(name=u'certicom', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    certicom._val = (1, 3, 132)
    
    #-----< certicom-curve >-----#
    certicom_curve = OID(name=u'certicom-curve', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    certicom_curve._val = (1, 3, 132, 0)
    
    #-----< teletrust >-----#
    teletrust = OID(name=u'teletrust', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    teletrust._val = (1, 3, 36)
    
    #-----< ecStdCurvesAndGen >-----#
    ecStdCurvesAndGen = OID(name=u'ecStdCurvesAndGen', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    ecStdCurvesAndGen._val = (1, 3, 36, 3, 3, 2, 8)
    
    #-----< versionOne >-----#
    versionOne = OID(name=u'versionOne', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    versionOne._val = (1, 3, 36, 3, 3, 2, 8, 1, 1)
    
    #-----< us-joint >-----#
    us_joint = OID(name=u'us-joint', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    us_joint._val = (2, 16, 840)
    
    #-----< usgov >-----#
    usgov = OID(name=u'usgov', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    usgov._val = (2, 16, 840, 1, 101)
    
    #-----< dodAlgorithms >-----#
    dodAlgorithms = OID(name=u'dodAlgorithms', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    dodAlgorithms._val = (2, 16, 840, 1, 101, 2, 1, 1)
    
    #-----< csor >-----#
    csor = OID(name=u'csor', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    csor._val = (2, 16, 840, 1, 101, 3)
    
    #-----< nistAlgorithms >-----#
    nistAlgorithms = OID(name=u'nistAlgorithms', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    nistAlgorithms._val = (2, 16, 840, 1, 101, 3, 4)
    
    #-----< aes >-----#
    aes = OID(name=u'aes', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    aes._val = (2, 16, 840, 1, 101, 3, 4, 1)
    
    #-----< hashAlgs >-----#
    hashAlgs = OID(name=u'hashAlgs', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    hashAlgs._val = (2, 16, 840, 1, 101, 3, 4, 2)
    
    #-----< sigAlgs >-----#
    sigAlgs = OID(name=u'sigAlgs', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sigAlgs._val = (2, 16, 840, 1, 101, 3, 4, 3)
    
    #-----< rsadsi >-----#
    rsadsi = OID(name=u'rsadsi', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    rsadsi._val = (1, 2, 840, 113549)
    
    #-----< pkcs-1 >-----#
    pkcs_1 = OID(name=u'pkcs-1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    pkcs_1._val = (1, 2, 840, 113549, 1, 1)
    
    #-----< digestAlgorithm >-----#
    digestAlgorithm = OID(name=u'digestAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    digestAlgorithm._val = (1, 2, 840, 113549, 2)
    
    #-----< id-aes128-CBC >-----#
    id_aes128_CBC = OID(name=u'id-aes128-CBC', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_aes128_CBC._val = (2, 16, 840, 1, 101, 3, 4, 1, 2)
    
    #-----< id-aes192-CBC >-----#
    id_aes192_CBC = OID(name=u'id-aes192-CBC', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_aes192_CBC._val = (2, 16, 840, 1, 101, 3, 4, 1, 22)
    
    #-----< id-aes256-CBC >-----#
    id_aes256_CBC = OID(name=u'id-aes256-CBC', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_aes256_CBC._val = (2, 16, 840, 1, 101, 3, 4, 1, 42)
    
    #-----< id-aes128-wrap >-----#
    id_aes128_wrap = OID(name=u'id-aes128-wrap', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_aes128_wrap._val = (2, 16, 840, 1, 101, 3, 4, 1, 5)
    
    #-----< id-aes192-wrap >-----#
    id_aes192_wrap = OID(name=u'id-aes192-wrap', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_aes192_wrap._val = (2, 16, 840, 1, 101, 3, 4, 1, 25)
    
    #-----< id-aes256-wrap >-----#
    id_aes256_wrap = OID(name=u'id-aes256-wrap', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_aes256_wrap._val = (2, 16, 840, 1, 101, 3, 4, 1, 45)
    
    #-----< rsaEncryption >-----#
    rsaEncryption = OID(name=u'rsaEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    rsaEncryption._val = (1, 2, 840, 113549, 1, 1, 1)
    
    #-----< id-keyExchangeAlgorithm >-----#
    id_keyExchangeAlgorithm = OID(name=u'id-keyExchangeAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_keyExchangeAlgorithm._val = (2, 16, 840, 1, 101, 2, 1, 1, 22)
    
    #-----< id-dsa >-----#
    id_dsa = OID(name=u'id-dsa', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_dsa._val = (1, 2, 840, 10040, 4, 1)
    
    #-----< id-ecPublicKey >-----#
    id_ecPublicKey = OID(name=u'id-ecPublicKey', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_ecPublicKey._val = (1, 2, 840, 10045, 2, 1)
    
    #-----< id-ecDH >-----#
    id_ecDH = OID(name=u'id-ecDH', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_ecDH._val = (1, 3, 132, 1, 12)
    
    #-----< id-ecMQV >-----#
    id_ecMQV = OID(name=u'id-ecMQV', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_ecMQV._val = (1, 3, 132, 1, 13)
    
    #-----< dh-public-number >-----#
    dh_public_number = OID(name=u'dh-public-number', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    dh_public_number._val = (1, 2, 840, 10046, 2, 1)
    
    #-----< id-sha1 >-----#
    id_sha1 = OID(name=u'id-sha1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_sha1._val = (1, 3, 14, 3, 2, 26)
    
    #-----< id-sha256 >-----#
    id_sha256 = OID(name=u'id-sha256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_sha256._val = (2, 16, 840, 1, 101, 3, 4, 2, 1)
    
    #-----< id-sha384 >-----#
    id_sha384 = OID(name=u'id-sha384', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_sha384._val = (2, 16, 840, 1, 101, 3, 4, 2, 2)
    
    #-----< id-sha512 >-----#
    id_sha512 = OID(name=u'id-sha512', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_sha512._val = (2, 16, 840, 1, 101, 3, 4, 2, 3)
    
    #-----< id-sha224 >-----#
    id_sha224 = OID(name=u'id-sha224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_sha224._val = (2, 16, 840, 1, 101, 3, 4, 2, 4)
    
    #-----< id-sha512-224 >-----#
    id_sha512_224 = OID(name=u'id-sha512-224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_sha512_224._val = (2, 16, 840, 1, 101, 3, 4, 2, 5)
    
    #-----< id-sha512-256 >-----#
    id_sha512_256 = OID(name=u'id-sha512-256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_sha512_256._val = (2, 16, 840, 1, 101, 3, 4, 2, 6)
    
    #-----< hashAlg >-----#
    hashAlg = OID(name=u'hashAlg', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    hashAlg._val = (1, 3, 6, 1, 4, 1, 1722, 12, 2)
    
    #-----< sha1WithRSAEncryption >-----#
    sha1WithRSAEncryption = OID(name=u'sha1WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sha1WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 5)
    
    #-----< sha256WithRSAEncryption >-----#
    sha256WithRSAEncryption = OID(name=u'sha256WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sha256WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 11)
    
    #-----< sha384WithRSAEncryption >-----#
    sha384WithRSAEncryption = OID(name=u'sha384WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sha384WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 12)
    
    #-----< sha512WithRSAEncryption >-----#
    sha512WithRSAEncryption = OID(name=u'sha512WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sha512WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 13)
    
    #-----< sha224WithRSAEncryption >-----#
    sha224WithRSAEncryption = OID(name=u'sha224WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sha224WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 14)
    
    #-----< id-RSASSA-PSS >-----#
    id_RSASSA_PSS = OID(name=u'id-RSASSA-PSS', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_RSASSA_PSS._val = (1, 2, 840, 113549, 1, 1, 10)
    
    #-----< id-mgf1 >-----#
    id_mgf1 = OID(name=u'id-mgf1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_mgf1._val = (1, 2, 840, 113549, 1, 1, 8)
    
    #-----< id-dsa-with-sha1 >-----#
    id_dsa_with_sha1 = OID(name=u'id-dsa-with-sha1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_dsa_with_sha1._val = (1, 2, 840, 10040, 4, 3)
    
    #-----< id-dsa-with-sha224 >-----#
    id_dsa_with_sha224 = OID(name=u'id-dsa-with-sha224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_dsa_with_sha224._val = (2, 16, 840, 1, 101, 3, 4, 3, 1)
    
    #-----< id-dsa-with-sha256 >-----#
    id_dsa_with_sha256 = OID(name=u'id-dsa-with-sha256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_dsa_with_sha256._val = (2, 16, 840, 1, 101, 3, 4, 3, 2)
    
    #-----< ecdsa-with-SHA224 >-----#
    ecdsa_with_SHA224 = OID(name=u'ecdsa-with-SHA224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    ecdsa_with_SHA224._val = (1, 2, 840, 10045, 4, 3, 1)
    
    #-----< ecdsa-with-SHA256 >-----#
    ecdsa_with_SHA256 = OID(name=u'ecdsa-with-SHA256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    ecdsa_with_SHA256._val = (1, 2, 840, 10045, 4, 3, 2)
    
    #-----< ecdsa-with-SHA384 >-----#
    ecdsa_with_SHA384 = OID(name=u'ecdsa-with-SHA384', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    ecdsa_with_SHA384._val = (1, 2, 840, 10045, 4, 3, 3)
    
    #-----< ecdsa-with-SHA512 >-----#
    ecdsa_with_SHA512 = OID(name=u'ecdsa-with-SHA512', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    ecdsa_with_SHA512._val = (1, 2, 840, 10045, 4, 3, 4)
    
    #-----< secp192r1 >-----#
    secp192r1 = OID(name=u'secp192r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    secp192r1._val = (1, 2, 840, 10045, 3, 1, 1)
    
    #-----< sect163k1 >-----#
    sect163k1 = OID(name=u'sect163k1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect163k1._val = (1, 3, 132, 0, 1)
    
    #-----< sect163r2 >-----#
    sect163r2 = OID(name=u'sect163r2', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect163r2._val = (1, 3, 132, 0, 15)
    
    #-----< secp224r1 >-----#
    secp224r1 = OID(name=u'secp224r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    secp224r1._val = (1, 3, 132, 0, 33)
    
    #-----< sect233k1 >-----#
    sect233k1 = OID(name=u'sect233k1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect233k1._val = (1, 3, 132, 0, 26)
    
    #-----< sect233r1 >-----#
    sect233r1 = OID(name=u'sect233r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect233r1._val = (1, 3, 132, 0, 27)
    
    #-----< secp256r1 >-----#
    secp256r1 = OID(name=u'secp256r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    secp256r1._val = (1, 2, 840, 10045, 3, 1, 7)
    
    #-----< sect283k1 >-----#
    sect283k1 = OID(name=u'sect283k1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect283k1._val = (1, 3, 132, 0, 16)
    
    #-----< sect283r1 >-----#
    sect283r1 = OID(name=u'sect283r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect283r1._val = (1, 3, 132, 0, 17)
    
    #-----< secp384r1 >-----#
    secp384r1 = OID(name=u'secp384r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    secp384r1._val = (1, 3, 132, 0, 34)
    
    #-----< sect409k1 >-----#
    sect409k1 = OID(name=u'sect409k1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect409k1._val = (1, 3, 132, 0, 36)
    
    #-----< sect409r1 >-----#
    sect409r1 = OID(name=u'sect409r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect409r1._val = (1, 3, 132, 0, 37)
    
    #-----< secp521r1 >-----#
    secp521r1 = OID(name=u'secp521r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    secp521r1._val = (1, 3, 132, 0, 35)
    
    #-----< sect571k1 >-----#
    sect571k1 = OID(name=u'sect571k1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect571k1._val = (1, 3, 132, 0, 38)
    
    #-----< sect571r1 >-----#
    sect571r1 = OID(name=u'sect571r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    sect571r1._val = (1, 3, 132, 0, 39)
    
    #-----< brainpoolP160r1 >-----#
    brainpoolP160r1 = OID(name=u'brainpoolP160r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP160r1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 1)
    
    #-----< brainpoolP160t1 >-----#
    brainpoolP160t1 = OID(name=u'brainpoolP160t1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP160t1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 2)
    
    #-----< brainpoolP192r1 >-----#
    brainpoolP192r1 = OID(name=u'brainpoolP192r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP192r1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 3)
    
    #-----< brainpoolP192t1 >-----#
    brainpoolP192t1 = OID(name=u'brainpoolP192t1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP192t1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 4)
    
    #-----< brainpoolP224r1 >-----#
    brainpoolP224r1 = OID(name=u'brainpoolP224r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP224r1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 5)
    
    #-----< brainpoolP224t1 >-----#
    brainpoolP224t1 = OID(name=u'brainpoolP224t1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP224t1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 6)
    
    #-----< brainpoolP256r1 >-----#
    brainpoolP256r1 = OID(name=u'brainpoolP256r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP256r1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 7)
    
    #-----< brainpoolP256t1 >-----#
    brainpoolP256t1 = OID(name=u'brainpoolP256t1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP256t1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 8)
    
    #-----< brainpoolP320r1 >-----#
    brainpoolP320r1 = OID(name=u'brainpoolP320r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP320r1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 9)
    
    #-----< brainpoolP320t1 >-----#
    brainpoolP320t1 = OID(name=u'brainpoolP320t1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP320t1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 10)
    
    #-----< brainpoolP384r1 >-----#
    brainpoolP384r1 = OID(name=u'brainpoolP384r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP384r1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 11)
    
    #-----< brainpoolP384t1 >-----#
    brainpoolP384t1 = OID(name=u'brainpoolP384t1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP384t1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 12)
    
    #-----< brainpoolP512r1 >-----#
    brainpoolP512r1 = OID(name=u'brainpoolP512r1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP512r1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 13)
    
    #-----< brainpoolP512t1 >-----#
    brainpoolP512t1 = OID(name=u'brainpoolP512t1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    brainpoolP512t1._val = (1, 3, 36, 3, 3, 2, 8, 1, 1, 14)
    
    #-----< X509Curves >-----#
    X509Curves = OID(name=u'X509Curves', mode=MODE_SET)
    X509Curves._val = ASN1Set(rv=[(1, 2, 840, 10045, 3, 1, 1), (1, 3, 132, 0, 1), (1, 3, 132, 0, 15), (1, 3, 132, 0, 33), (1, 3, 132, 0, 26), (1, 3, 132, 0, 27), (1, 2, 840, 10045, 3, 1, 7), (1, 3, 132, 0, 16), (1, 3, 132, 0, 17), (1, 3, 132, 0, 34), (1, 3, 132, 0, 36), (1, 3, 132, 0, 37), (1, 3, 132, 0, 35), (1, 3, 132, 0, 38), (1, 3, 132, 0, 39)], rr=[], ev=None, er=[])
    
    #-----< id-hmacWithSHA224 >-----#
    id_hmacWithSHA224 = OID(name=u'id-hmacWithSHA224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_hmacWithSHA224._val = (1, 2, 840, 113549, 2, 8)
    
    #-----< id-hmacWithSHA256 >-----#
    id_hmacWithSHA256 = OID(name=u'id-hmacWithSHA256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_hmacWithSHA256._val = (1, 2, 840, 113549, 2, 9)
    
    #-----< id-hmacWithSHA384 >-----#
    id_hmacWithSHA384 = OID(name=u'id-hmacWithSHA384', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_hmacWithSHA384._val = (1, 2, 840, 113549, 2, 10)
    
    #-----< id-hmacWithSHA512 >-----#
    id_hmacWithSHA512 = OID(name=u'id-hmacWithSHA512', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_hmacWithSHA512._val = (1, 2, 840, 113549, 2, 11)
    
    #-----< id-gmac >-----#
    id_gmac = OID(name=u'id-gmac', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ID')))
    id_gmac._val = (1, 0, 9797, 3, 4)
    
    #-----< mD5Algorithm >-----#
    mD5Algorithm = CLASS(name=u'mD5Algorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _mD5Algorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    mD5Algorithm._val = dict([(u'Type', _mD5Algorithm_val_Type), (u'id', (1, 2, 840, 113549, 2, 5))])
    
    #-----< sha1Algorithm >-----#
    sha1Algorithm = CLASS(name=u'sha1Algorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _sha1Algorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    sha1Algorithm._val = dict([(u'Type', _sha1Algorithm_val_Type), (u'id', (1, 3, 14, 3, 2, 26))])
    
    #-----< sha224 >-----#
    sha224 = CLASS(name=u'sha224', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    sha224._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))])
    
    #-----< sha256 >-----#
    sha256 = CLASS(name=u'sha256', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    sha256._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))])
    
    #-----< sha384 >-----#
    sha384 = CLASS(name=u'sha384', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    sha384._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))])
    
    #-----< sha512 >-----#
    sha512 = CLASS(name=u'sha512', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    sha512._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])
    
    #-----< HashAlgorithms >-----#
    HashAlgorithms = CLASS(name=u'HashAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _HashAlgorithms_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    HashAlgorithms._val = ASN1Set(rv=[dict([(u'Type', _HashAlgorithms_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    
    #-----< aes128-CBC >-----#
    aes128_CBC = CLASS(name=u'aes128-CBC', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _aes128_CBC_val_Type = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    aes128_CBC._val = dict([(u'Type', _aes128_CBC_val_Type), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))])
    
    #-----< aes192-CBC >-----#
    aes192_CBC = CLASS(name=u'aes192-CBC', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _aes192_CBC_val_Type = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    aes192_CBC._val = dict([(u'Type', _aes192_CBC_val_Type), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))])
    
    #-----< aes256-CBC >-----#
    aes256_CBC = CLASS(name=u'aes256-CBC', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _aes256_CBC_val_Type = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    aes256_CBC._val = dict([(u'Type', _aes256_CBC_val_Type), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))])
    
    #-----< AES-InitializationVector >-----#
    AES_InitializationVector = OCT_STR(name=u'AES-InitializationVector', mode=MODE_TYPE)
    AES_InitializationVector._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< rsaEncryptionAlgorithm >-----#
    rsaEncryptionAlgorithm = CLASS(name=u'rsaEncryptionAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _rsaEncryptionAlgorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    rsaEncryptionAlgorithm._val = dict([(u'Type', _rsaEncryptionAlgorithm_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 1))])
    
    #-----< keyExchangeAlgorithm >-----#
    keyExchangeAlgorithm = CLASS(name=u'keyExchangeAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _keyExchangeAlgorithm_val_Type = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    keyExchangeAlgorithm._val = dict([(u'Type', _keyExchangeAlgorithm_val_Type), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))])
    
    #-----< KEA-Parms-Id >-----#
    KEA_Parms_Id = OCT_STR(name=u'KEA-Parms-Id', mode=MODE_TYPE)
    KEA_Parms_Id._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    
    #-----< dsa >-----#
    dsa = CLASS(name=u'dsa', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _dsa_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    dsa._val = dict([(u'Type', _dsa_val_Type), (u'id', (1, 2, 840, 10040, 4, 1))])
    
    #-----< DSS-Parms >-----#
    DSS_Parms = SEQ(name=u'DSS-Parms', mode=MODE_TYPE)
    _DSS_Parms_p = INT(name=u'p', mode=MODE_TYPE)
    _DSS_Parms_q = INT(name=u'q', mode=MODE_TYPE)
    _DSS_Parms_g = INT(name=u'g', mode=MODE_TYPE)
    DSS_Parms._cont = ASN1Dict([
        (u'p', _DSS_Parms_p),
        (u'q', _DSS_Parms_q),
        (u'g', _DSS_Parms_g),
        ])
    DSS_Parms._ext = []
    
    #-----< ecPublicKey >-----#
    ecPublicKey = CLASS(name=u'ecPublicKey', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _ecPublicKey_val_Type = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ecPublicKey._val = dict([(u'Type', _ecPublicKey_val_Type), (u'id', (1, 2, 840, 10045, 2, 1))])
    
    #-----< ecDH >-----#
    ecDH = CLASS(name=u'ecDH', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _ecDH_val_Type = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ecDH._val = dict([(u'Type', _ecDH_val_Type), (u'id', (1, 3, 132, 1, 12))])
    
    #-----< ecMQV >-----#
    ecMQV = CLASS(name=u'ecMQV', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _ecMQV_val_Type = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ecMQV._val = dict([(u'Type', _ecMQV_val_Type), (u'id', (1, 3, 132, 1, 13))])
    
    #-----< dh-public-numberAlgorithm >-----#
    dh_public_numberAlgorithm = CLASS(name=u'dh-public-numberAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _dh_public_numberAlgorithm_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    dh_public_numberAlgorithm._val = dict([(u'Type', _dh_public_numberAlgorithm_val_Type), (u'id', (1, 2, 840, 10046, 2, 1))])
    
    #-----< DomainParameters >-----#
    DomainParameters = SEQ(name=u'DomainParameters', mode=MODE_TYPE)
    _DomainParameters_p = INT(name=u'p', mode=MODE_TYPE)
    _DomainParameters_g = INT(name=u'g', mode=MODE_TYPE)
    _DomainParameters_q = INT(name=u'q', mode=MODE_TYPE)
    _DomainParameters_j = INT(name=u'j', mode=MODE_TYPE, opt=True)
    _DomainParameters_validationParms = SEQ(name=u'validationParms', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'ValidationParms')), opt=True)
    DomainParameters._cont = ASN1Dict([
        (u'p', _DomainParameters_p),
        (u'g', _DomainParameters_g),
        (u'q', _DomainParameters_q),
        (u'j', _DomainParameters_j),
        (u'validationParms', _DomainParameters_validationParms),
        ])
    DomainParameters._ext = []
    
    #-----< ValidationParms >-----#
    ValidationParms = SEQ(name=u'ValidationParms', mode=MODE_TYPE)
    _ValidationParms_seed = BIT_STR(name=u'seed', mode=MODE_TYPE)
    _ValidationParms_pgenCounter = INT(name=u'pgenCounter', mode=MODE_TYPE)
    ValidationParms._cont = ASN1Dict([
        (u'seed', _ValidationParms_seed),
        (u'pgenCounter', _ValidationParms_pgenCounter),
        ])
    ValidationParms._ext = []
    
    #-----< sha1WithRSAEncryptionAlgorithm >-----#
    sha1WithRSAEncryptionAlgorithm = CLASS(name=u'sha1WithRSAEncryptionAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _sha1WithRSAEncryptionAlgorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    sha1WithRSAEncryptionAlgorithm._val = dict([(u'Type', _sha1WithRSAEncryptionAlgorithm_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 5))])
    
    #-----< sha224WithRSAEncryptionAlgorithm >-----#
    sha224WithRSAEncryptionAlgorithm = CLASS(name=u'sha224WithRSAEncryptionAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _sha224WithRSAEncryptionAlgorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    sha224WithRSAEncryptionAlgorithm._val = dict([(u'Type', _sha224WithRSAEncryptionAlgorithm_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 14))])
    
    #-----< sha256WithRSAEncryptionAlgorithm >-----#
    sha256WithRSAEncryptionAlgorithm = CLASS(name=u'sha256WithRSAEncryptionAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _sha256WithRSAEncryptionAlgorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    sha256WithRSAEncryptionAlgorithm._val = dict([(u'Type', _sha256WithRSAEncryptionAlgorithm_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 11))])
    
    #-----< sha384WithRSAEncryptionAlgorithm >-----#
    sha384WithRSAEncryptionAlgorithm = CLASS(name=u'sha384WithRSAEncryptionAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _sha384WithRSAEncryptionAlgorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    sha384WithRSAEncryptionAlgorithm._val = dict([(u'Type', _sha384WithRSAEncryptionAlgorithm_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 12))])
    
    #-----< sha512WithRSAEncryptionAlgorithm >-----#
    sha512WithRSAEncryptionAlgorithm = CLASS(name=u'sha512WithRSAEncryptionAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _sha512WithRSAEncryptionAlgorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    sha512WithRSAEncryptionAlgorithm._val = dict([(u'Type', _sha512WithRSAEncryptionAlgorithm_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 13))])
    
    #-----< rSASSA-PSS >-----#
    rSASSA_PSS = CLASS(name=u'rSASSA-PSS', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _rSASSA_PSS_val_Type = SEQ(name=u'Type', mode=MODE_TYPE)
    __rSASSA_PSS_val_Type_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___rSASSA_PSS_val_Type_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____rSASSA_PSS_val_Type_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____rSASSA_PSS_val_Type_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____rSASSA_PSS_val_Type_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _____rSASSA_PSS_val_Type_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ___rSASSA_PSS_val_Type_hashAlgorithm_algorithm._const_tab = ____rSASSA_PSS_val_Type_hashAlgorithm_algorithm_tab
    ___rSASSA_PSS_val_Type_hashAlgorithm_algorithm._const_tab_at = None
    ___rSASSA_PSS_val_Type_hashAlgorithm_algorithm._const_tab_id = u'id'
    ___rSASSA_PSS_val_Type_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___rSASSA_PSS_val_Type_hashAlgorithm_parameters._const_tab = ____rSASSA_PSS_val_Type_hashAlgorithm_algorithm_tab
    ___rSASSA_PSS_val_Type_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ___rSASSA_PSS_val_Type_hashAlgorithm_parameters._const_tab_id = u'Type'
    __rSASSA_PSS_val_Type_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ___rSASSA_PSS_val_Type_hashAlgorithm_algorithm),
        (u'parameters', ___rSASSA_PSS_val_Type_hashAlgorithm_parameters),
        ])
    __rSASSA_PSS_val_Type_hashAlgorithm._ext = []
    __rSASSA_PSS_val_Type_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    __rSASSA_PSS_val_Type_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _rSASSA_PSS_val_Type._cont = ASN1Dict([
        (u'hashAlgorithm', __rSASSA_PSS_val_Type_hashAlgorithm),
        (u'saltLength', __rSASSA_PSS_val_Type_saltLength),
        (u'trailerField', __rSASSA_PSS_val_Type_trailerField),
        ])
    _rSASSA_PSS_val_Type._ext = None
    rSASSA_PSS._val = dict([(u'Type', _rSASSA_PSS_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 10))])
    
    #-----< dsa-with-sha224 >-----#
    dsa_with_sha224 = CLASS(name=u'dsa-with-sha224', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    dsa_with_sha224._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))])
    
    #-----< dsa-with-sha256 >-----#
    dsa_with_sha256 = CLASS(name=u'dsa-with-sha256', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    dsa_with_sha256._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))])
    
    #-----< ecdsa-with-SHA224-Algorithm >-----#
    ecdsa_with_SHA224_Algorithm = CLASS(name=u'ecdsa-with-SHA224-Algorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ecdsa_with_SHA224_Algorithm._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))])
    
    #-----< ecdsa-with-SHA256-Algorithm >-----#
    ecdsa_with_SHA256_Algorithm = CLASS(name=u'ecdsa-with-SHA256-Algorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ecdsa_with_SHA256_Algorithm._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))])
    
    #-----< ecdsa-with-SHA384-Algorithm >-----#
    ecdsa_with_SHA384_Algorithm = CLASS(name=u'ecdsa-with-SHA384-Algorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ecdsa_with_SHA384_Algorithm._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))])
    
    #-----< ecdsa-with-SHA512-Algorithm >-----#
    ecdsa_with_SHA512_Algorithm = CLASS(name=u'ecdsa-with-SHA512-Algorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ecdsa_with_SHA512_Algorithm._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))])
    
    #-----< hmacWithSHA224 >-----#
    hmacWithSHA224 = CLASS(name=u'hmacWithSHA224', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _hmacWithSHA224_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    hmacWithSHA224._val = dict([(u'Type', _hmacWithSHA224_val_Type), (u'id', (1, 2, 840, 113549, 2, 8))])
    
    #-----< hmacWithSHA256 >-----#
    hmacWithSHA256 = CLASS(name=u'hmacWithSHA256', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _hmacWithSHA256_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    hmacWithSHA256._val = dict([(u'Type', _hmacWithSHA256_val_Type), (u'id', (1, 2, 840, 113549, 2, 9))])
    
    #-----< hmacWithSHA384 >-----#
    hmacWithSHA384 = CLASS(name=u'hmacWithSHA384', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _hmacWithSHA384_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    hmacWithSHA384._val = dict([(u'Type', _hmacWithSHA384_val_Type), (u'id', (1, 2, 840, 113549, 2, 10))])
    
    #-----< hmacWithSHA512 >-----#
    hmacWithSHA512 = CLASS(name=u'hmacWithSHA512', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _hmacWithSHA512_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    hmacWithSHA512._val = dict([(u'Type', _hmacWithSHA512_val_Type), (u'id', (1, 2, 840, 113549, 2, 11))])
    
    #-----< AllAlgorithmsOID >-----#
    AllAlgorithmsOID = CLASS(name=u'AllAlgorithmsOID', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _AllAlgorithmsOID_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _AllAlgorithmsOID_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _AllAlgorithmsOID_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _AllAlgorithmsOID_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _AllAlgorithmsOID_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _AllAlgorithmsOID_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _AllAlgorithmsOID_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _AllAlgorithmsOID_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _AllAlgorithmsOID_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _AllAlgorithmsOID_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    __AllAlgorithmsOID_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _____AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm._const_tab = ____AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm_tab
    ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_parameters._const_tab = ____AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm_tab
    ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    __AllAlgorithmsOID_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_parameters),
        ])
    __AllAlgorithmsOID_val_Type_21_hashAlgorithm._ext = []
    __AllAlgorithmsOID_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    __AllAlgorithmsOID_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _AllAlgorithmsOID_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', __AllAlgorithmsOID_val_Type_21_hashAlgorithm),
        (u'saltLength', __AllAlgorithmsOID_val_Type_21_saltLength),
        (u'trailerField', __AllAlgorithmsOID_val_Type_21_trailerField),
        ])
    _AllAlgorithmsOID_val_Type_21._ext = None
    _AllAlgorithmsOID_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _AllAlgorithmsOID_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    AllAlgorithmsOID._val = ASN1Set(rv=[dict([(u'Type', _AllAlgorithmsOID_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _AllAlgorithmsOID_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    
    _all_ = [
        ID,
        nullAlgorithm,
        encryptionAlgorithm,
        hashAlgorithm,
        signatureAlgorithm,
        id_ea,
        id_ha,
        id_sa,
        id_ea_rsa,
        id_ha_sqMod_n,
        id_sa_sqMod_nWithRSA,
        us_iso,
        ansi_x9_57,
        ansi_x9_62,
        ansi_x9_42,
        iso_standard,
        iso9797,
        iso_organization,
        certicom,
        certicom_curve,
        teletrust,
        ecStdCurvesAndGen,
        versionOne,
        us_joint,
        usgov,
        dodAlgorithms,
        csor,
        nistAlgorithms,
        aes,
        hashAlgs,
        sigAlgs,
        rsadsi,
        pkcs_1,
        digestAlgorithm,
        id_aes128_CBC,
        id_aes192_CBC,
        id_aes256_CBC,
        id_aes128_wrap,
        id_aes192_wrap,
        id_aes256_wrap,
        rsaEncryption,
        id_keyExchangeAlgorithm,
        id_dsa,
        id_ecPublicKey,
        id_ecDH,
        id_ecMQV,
        dh_public_number,
        id_sha1,
        id_sha256,
        id_sha384,
        id_sha512,
        id_sha224,
        id_sha512_224,
        id_sha512_256,
        hashAlg,
        sha1WithRSAEncryption,
        sha256WithRSAEncryption,
        sha384WithRSAEncryption,
        sha512WithRSAEncryption,
        sha224WithRSAEncryption,
        id_RSASSA_PSS,
        id_mgf1,
        id_dsa_with_sha1,
        id_dsa_with_sha224,
        id_dsa_with_sha256,
        ecdsa_with_SHA224,
        ecdsa_with_SHA256,
        ecdsa_with_SHA384,
        ecdsa_with_SHA512,
        secp192r1,
        sect163k1,
        sect163r2,
        secp224r1,
        sect233k1,
        sect233r1,
        secp256r1,
        sect283k1,
        sect283r1,
        secp384r1,
        sect409k1,
        sect409r1,
        secp521r1,
        sect571k1,
        sect571r1,
        brainpoolP160r1,
        brainpoolP160t1,
        brainpoolP192r1,
        brainpoolP192t1,
        brainpoolP224r1,
        brainpoolP224t1,
        brainpoolP256r1,
        brainpoolP256t1,
        brainpoolP320r1,
        brainpoolP320t1,
        brainpoolP384r1,
        brainpoolP384t1,
        brainpoolP512r1,
        brainpoolP512t1,
        X509Curves,
        id_hmacWithSHA224,
        id_hmacWithSHA256,
        id_hmacWithSHA384,
        id_hmacWithSHA512,
        id_gmac,
        mD5Algorithm,
        _mD5Algorithm_val_Type,
        sha1Algorithm,
        _sha1Algorithm_val_Type,
        sha224,
        sha256,
        sha384,
        sha512,
        HashAlgorithms,
        _HashAlgorithms_val_Type_0,
        aes128_CBC,
        _aes128_CBC_val_Type,
        aes192_CBC,
        _aes192_CBC_val_Type,
        aes256_CBC,
        _aes256_CBC_val_Type,
        AES_InitializationVector,
        rsaEncryptionAlgorithm,
        _rsaEncryptionAlgorithm_val_Type,
        keyExchangeAlgorithm,
        _keyExchangeAlgorithm_val_Type,
        KEA_Parms_Id,
        dsa,
        _dsa_val_Type,
        _DSS_Parms_p,
        _DSS_Parms_q,
        _DSS_Parms_g,
        DSS_Parms,
        ecPublicKey,
        _ecPublicKey_val_Type,
        ecDH,
        _ecDH_val_Type,
        ecMQV,
        _ecMQV_val_Type,
        dh_public_numberAlgorithm,
        _dh_public_numberAlgorithm_val_Type,
        _DomainParameters_p,
        _DomainParameters_g,
        _DomainParameters_q,
        _DomainParameters_j,
        _DomainParameters_validationParms,
        DomainParameters,
        _ValidationParms_seed,
        _ValidationParms_pgenCounter,
        ValidationParms,
        sha1WithRSAEncryptionAlgorithm,
        _sha1WithRSAEncryptionAlgorithm_val_Type,
        sha224WithRSAEncryptionAlgorithm,
        _sha224WithRSAEncryptionAlgorithm_val_Type,
        sha256WithRSAEncryptionAlgorithm,
        _sha256WithRSAEncryptionAlgorithm_val_Type,
        sha384WithRSAEncryptionAlgorithm,
        _sha384WithRSAEncryptionAlgorithm_val_Type,
        sha512WithRSAEncryptionAlgorithm,
        _sha512WithRSAEncryptionAlgorithm_val_Type,
        rSASSA_PSS,
        ____rSASSA_PSS_val_Type_hashAlgorithm_algorithm_tab,
        _____rSASSA_PSS_val_Type_hashAlgorithm_algorithm_tab_val_Type_0,
        ___rSASSA_PSS_val_Type_hashAlgorithm_algorithm,
        ___rSASSA_PSS_val_Type_hashAlgorithm_parameters,
        __rSASSA_PSS_val_Type_hashAlgorithm,
        __rSASSA_PSS_val_Type_saltLength,
        __rSASSA_PSS_val_Type_trailerField,
        _rSASSA_PSS_val_Type,
        dsa_with_sha224,
        dsa_with_sha256,
        ecdsa_with_SHA224_Algorithm,
        ecdsa_with_SHA256_Algorithm,
        ecdsa_with_SHA384_Algorithm,
        ecdsa_with_SHA512_Algorithm,
        hmacWithSHA224,
        _hmacWithSHA224_val_Type,
        hmacWithSHA256,
        _hmacWithSHA256_val_Type,
        hmacWithSHA384,
        _hmacWithSHA384_val_Type,
        hmacWithSHA512,
        _hmacWithSHA512_val_Type,
        AllAlgorithmsOID,
        _AllAlgorithmsOID_val_Type_0,
        _AllAlgorithmsOID_val_Type_1,
        _AllAlgorithmsOID_val_Type_6,
        _AllAlgorithmsOID_val_Type_7,
        _AllAlgorithmsOID_val_Type_8,
        _AllAlgorithmsOID_val_Type_9,
        _AllAlgorithmsOID_val_Type_10,
        _AllAlgorithmsOID_val_Type_11,
        _AllAlgorithmsOID_val_Type_12,
        _AllAlgorithmsOID_val_Type_13,
        _AllAlgorithmsOID_val_Type_14,
        _AllAlgorithmsOID_val_Type_15,
        _AllAlgorithmsOID_val_Type_16,
        _AllAlgorithmsOID_val_Type_17,
        _AllAlgorithmsOID_val_Type_18,
        _AllAlgorithmsOID_val_Type_19,
        _AllAlgorithmsOID_val_Type_20,
        ____AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm_tab,
        _____AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_algorithm,
        ___AllAlgorithmsOID_val_Type_21_hashAlgorithm_parameters,
        __AllAlgorithmsOID_val_Type_21_hashAlgorithm,
        __AllAlgorithmsOID_val_Type_21_saltLength,
        __AllAlgorithmsOID_val_Type_21_trailerField,
        _AllAlgorithmsOID_val_Type_21,
        _AllAlgorithmsOID_val_Type_28,
        _AllAlgorithmsOID_val_Type_29,
        _AllAlgorithmsOID_val_Type_30,
        _AllAlgorithmsOID_val_Type_31,
    ]

class AttributeCertificateDefinitions:

    _name_  = u'AttributeCertificateDefinitions'
    _oid_   = [2, 5, 1, 32, 8]
    
    _obj_ = [
        u'AttributeCertificate',
        u'TBSAttributeCertificate',
        u'AttCertVersion',
        u'Holder',
        u'IssuerSerial',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'AttCertValidityPeriod',
        u'AttributeCertificationPath',
        u'ACPathData',
        u'PrivilegePolicy',
        u'role',
        u'RoleSyntax',
        u'xmlPrivilegeInfo',
        u'permission',
        u'DualStringSyntax',
        u'dualStringMatch',
        u'timeSpecification',
        u'timeSpecificationMatch',
        u'targetingInformation',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'userNotice',
        u'acceptablePrivilegePolicies',
        u'AcceptablePrivilegePoliciesSyntax',
        u'singleUse',
        u'groupAC',
        u'noRevAvail',
        u'sOAIdentifier',
        u'sOAIdentifierMatch',
        u'attributeDescriptor',
        u'AttributeDescriptorSyntax',
        u'AttributeIdentifier',
        u'AttributeIDs',
        u'AttributeName',
        u'AttributeDescription',
        u'PrivilegePolicyIdentifier',
        u'attDescriptor',
        u'roleSpecCertIdentifier',
        u'RoleSpecCertIdentifierSyntax',
        u'RoleSpecCertIdentifier',
        u'roleSpecCertIdMatch',
        u'basicAttConstraints',
        u'BasicAttConstraintsSyntax',
        u'basicAttConstraintsMatch',
        u'delegatedNameConstraints',
        u'delegatedNameConstraintsMatch',
        u'acceptableCertPolicies',
        u'AcceptableCertPoliciesSyntax',
        u'CertPolicyId',
        u'acceptableCertPoliciesMatch',
        u'authorityAttributeIdentifier',
        u'AuthorityAttributeIdentifierSyntax',
        u'AuthAttId',
        u'authAttIdMatch',
        u'indirectIssuer',
        u'issuedOnBehalfOf',
        u'noAssertion',
        u'allowedAttributeAssignments',
        u'AllowedAttributeAssignments',
        u'attributeMappings',
        u'AttributeMappings',
        u'holderNameConstraints',
        u'HolderNameConstraintsSyntax',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'pmiUser',
        u'pmiAA',
        u'pmiSOA',
        u'attCertCRLDistributionPt',
        u'pmiDelegationPath',
        u'privilegePolicy',
        u'protectedPrivilegePolicy',
        u'attributeCertificateAttribute',
        u'aACertificate',
        u'attributeDescriptorCertificate',
        u'attributeCertificateRevocationList',
        u'eeAttrCertificateRevocationList',
        u'attributeAuthorityRevocationList',
        u'delegationPath',
        u'AttCertPath',
        u'privPolicy',
        u'protPrivPolicy',
        u'xmlPrivPolicy',
        u'attributeCertificateExactMatch',
        u'AttributeCertificateExactAssertion',
        u'attributeCertificateMatch',
        u'AttributeCertificateAssertion',
        u'holderIssuerMatch',
        u'HolderIssuerAssertion',
        u'delegationPathMatch',
        u'DelMatchSyntax',
        u'extensionPresenceMatch',
        u'id-oc-pmiUser',
        u'id-oc-pmiAA',
        u'id-oc-pmiSOA',
        u'id-oc-attCertCRLDistributionPts',
        u'id-oc-privilegePolicy',
        u'id-oc-pmiDelegationPath',
        u'id-oc-protectedPrivilegePolicy',
        u'id-at-attributeCertificate',
        u'id-at-attributeCertificateRevocationList',
        u'id-at-aACertificate',
        u'id-at-attributeDescriptorCertificate',
        u'id-at-attributeAuthorityRevocationList',
        u'id-at-privPolicy',
        u'id-at-role',
        u'id-at-delegationPath',
        u'id-at-protPrivPolicy',
        u'id-at-xMLPrivilegeInfo',
        u'id-at-xmlPrivPolicy',
        u'id-at-permission',
        u'id-at-eeAttrCertificateRevocationList',
        u'id-ce-authorityAttributeIdentifier',
        u'id-ce-roleSpecCertIdentifier',
        u'id-ce-basicAttConstraints',
        u'id-ce-delegatedNameConstraints',
        u'id-ce-timeSpecification',
        u'id-ce-attributeDescriptor',
        u'id-ce-userNotice',
        u'id-ce-sOAIdentifier',
        u'id-ce-acceptableCertPolicies',
        u'id-ce-targetingInformation',
        u'id-ce-noRevAvail',
        u'id-ce-acceptablePrivilegePolicies',
        u'id-ce-indirectIssuer',
        u'id-ce-noAssertion',
        u'id-ce-issuedOnBehalfOf',
        u'id-ce-singleUse',
        u'id-ce-groupAC',
        u'id-ce-allowedAttributeAssignments',
        u'id-ce-attributeMappings',
        u'id-ce-holderNameConstraints',
        u'id-mr-attributeCertificateMatch',
        u'id-mr-attributeCertificateExactMatch',
        u'id-mr-holderIssuerMatch',
        u'id-mr-authAttIdMatch',
        u'id-mr-roleSpecCertIdMatch',
        u'id-mr-basicAttConstraintsMatch',
        u'id-mr-delegatedNameConstraintsMatch',
        u'id-mr-timeSpecMatch',
        u'id-mr-attDescriptorMatch',
        u'id-mr-acceptableCertPoliciesMatch',
        u'id-mr-delegationPathMatch',
        u'id-mr-sOAIdentifierMatch',
        u'id-mr-extensionPresenceMatch',
        u'id-mr-dualStringMatch',
        ]
    _type_ = [
        u'AttributeCertificate',
        u'TBSAttributeCertificate',
        u'AttCertVersion',
        u'Holder',
        u'IssuerSerial',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'AttCertValidityPeriod',
        u'AttributeCertificationPath',
        u'ACPathData',
        u'PrivilegePolicy',
        u'RoleSyntax',
        u'DualStringSyntax',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'AcceptablePrivilegePoliciesSyntax',
        u'AttributeDescriptorSyntax',
        u'AttributeIdentifier',
        u'AttributeName',
        u'AttributeDescription',
        u'PrivilegePolicyIdentifier',
        u'RoleSpecCertIdentifierSyntax',
        u'RoleSpecCertIdentifier',
        u'BasicAttConstraintsSyntax',
        u'AcceptableCertPoliciesSyntax',
        u'CertPolicyId',
        u'AuthorityAttributeIdentifierSyntax',
        u'AuthAttId',
        u'AllowedAttributeAssignments',
        u'AttributeMappings',
        u'HolderNameConstraintsSyntax',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'AttCertPath',
        u'AttributeCertificateExactAssertion',
        u'AttributeCertificateAssertion',
        u'HolderIssuerAssertion',
        u'DelMatchSyntax',
        ]
    _set_ = [
        u'AttributeIDs',
        ]
    _val_ = [
        u'role',
        u'xmlPrivilegeInfo',
        u'permission',
        u'dualStringMatch',
        u'timeSpecification',
        u'timeSpecificationMatch',
        u'targetingInformation',
        u'userNotice',
        u'acceptablePrivilegePolicies',
        u'singleUse',
        u'groupAC',
        u'noRevAvail',
        u'sOAIdentifier',
        u'sOAIdentifierMatch',
        u'attributeDescriptor',
        u'attDescriptor',
        u'roleSpecCertIdentifier',
        u'roleSpecCertIdMatch',
        u'basicAttConstraints',
        u'basicAttConstraintsMatch',
        u'delegatedNameConstraints',
        u'delegatedNameConstraintsMatch',
        u'acceptableCertPolicies',
        u'acceptableCertPoliciesMatch',
        u'authorityAttributeIdentifier',
        u'authAttIdMatch',
        u'indirectIssuer',
        u'issuedOnBehalfOf',
        u'noAssertion',
        u'allowedAttributeAssignments',
        u'attributeMappings',
        u'holderNameConstraints',
        u'pmiUser',
        u'pmiAA',
        u'pmiSOA',
        u'attCertCRLDistributionPt',
        u'pmiDelegationPath',
        u'privilegePolicy',
        u'protectedPrivilegePolicy',
        u'attributeCertificateAttribute',
        u'aACertificate',
        u'attributeDescriptorCertificate',
        u'attributeCertificateRevocationList',
        u'eeAttrCertificateRevocationList',
        u'attributeAuthorityRevocationList',
        u'delegationPath',
        u'privPolicy',
        u'protPrivPolicy',
        u'xmlPrivPolicy',
        u'attributeCertificateExactMatch',
        u'attributeCertificateMatch',
        u'holderIssuerMatch',
        u'delegationPathMatch',
        u'extensionPresenceMatch',
        u'id-oc-pmiUser',
        u'id-oc-pmiAA',
        u'id-oc-pmiSOA',
        u'id-oc-attCertCRLDistributionPts',
        u'id-oc-privilegePolicy',
        u'id-oc-pmiDelegationPath',
        u'id-oc-protectedPrivilegePolicy',
        u'id-at-attributeCertificate',
        u'id-at-attributeCertificateRevocationList',
        u'id-at-aACertificate',
        u'id-at-attributeDescriptorCertificate',
        u'id-at-attributeAuthorityRevocationList',
        u'id-at-privPolicy',
        u'id-at-role',
        u'id-at-delegationPath',
        u'id-at-protPrivPolicy',
        u'id-at-xMLPrivilegeInfo',
        u'id-at-xmlPrivPolicy',
        u'id-at-permission',
        u'id-at-eeAttrCertificateRevocationList',
        u'id-ce-authorityAttributeIdentifier',
        u'id-ce-roleSpecCertIdentifier',
        u'id-ce-basicAttConstraints',
        u'id-ce-delegatedNameConstraints',
        u'id-ce-timeSpecification',
        u'id-ce-attributeDescriptor',
        u'id-ce-userNotice',
        u'id-ce-sOAIdentifier',
        u'id-ce-acceptableCertPolicies',
        u'id-ce-targetingInformation',
        u'id-ce-noRevAvail',
        u'id-ce-acceptablePrivilegePolicies',
        u'id-ce-indirectIssuer',
        u'id-ce-noAssertion',
        u'id-ce-issuedOnBehalfOf',
        u'id-ce-singleUse',
        u'id-ce-groupAC',
        u'id-ce-allowedAttributeAssignments',
        u'id-ce-attributeMappings',
        u'id-ce-holderNameConstraints',
        u'id-mr-attributeCertificateMatch',
        u'id-mr-attributeCertificateExactMatch',
        u'id-mr-holderIssuerMatch',
        u'id-mr-authAttIdMatch',
        u'id-mr-roleSpecCertIdMatch',
        u'id-mr-basicAttConstraintsMatch',
        u'id-mr-delegatedNameConstraintsMatch',
        u'id-mr-timeSpecMatch',
        u'id-mr-attDescriptorMatch',
        u'id-mr-acceptableCertPoliciesMatch',
        u'id-mr-delegationPathMatch',
        u'id-mr-sOAIdentifierMatch',
        u'id-mr-extensionPresenceMatch',
        u'id-mr-dualStringMatch',
        ]
    _class_ = [
        u'role',
        u'xmlPrivilegeInfo',
        u'permission',
        u'dualStringMatch',
        u'timeSpecification',
        u'timeSpecificationMatch',
        u'targetingInformation',
        u'userNotice',
        u'acceptablePrivilegePolicies',
        u'singleUse',
        u'groupAC',
        u'noRevAvail',
        u'sOAIdentifier',
        u'sOAIdentifierMatch',
        u'attributeDescriptor',
        u'AttributeIDs',
        u'attDescriptor',
        u'roleSpecCertIdentifier',
        u'roleSpecCertIdMatch',
        u'basicAttConstraints',
        u'basicAttConstraintsMatch',
        u'delegatedNameConstraints',
        u'delegatedNameConstraintsMatch',
        u'acceptableCertPolicies',
        u'acceptableCertPoliciesMatch',
        u'authorityAttributeIdentifier',
        u'authAttIdMatch',
        u'indirectIssuer',
        u'issuedOnBehalfOf',
        u'noAssertion',
        u'allowedAttributeAssignments',
        u'attributeMappings',
        u'holderNameConstraints',
        u'pmiUser',
        u'pmiAA',
        u'pmiSOA',
        u'attCertCRLDistributionPt',
        u'pmiDelegationPath',
        u'privilegePolicy',
        u'protectedPrivilegePolicy',
        u'attributeCertificateAttribute',
        u'aACertificate',
        u'attributeDescriptorCertificate',
        u'attributeCertificateRevocationList',
        u'eeAttrCertificateRevocationList',
        u'attributeAuthorityRevocationList',
        u'delegationPath',
        u'privPolicy',
        u'protPrivPolicy',
        u'xmlPrivPolicy',
        u'attributeCertificateExactMatch',
        u'attributeCertificateMatch',
        u'holderIssuerMatch',
        u'delegationPathMatch',
        u'extensionPresenceMatch',
        ]
    _param_ = [
        ]
    
    #-----< AttributeCertificate >-----#
    AttributeCertificate = SEQ(name=u'AttributeCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    _AttributeCertificate_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'TBSAttributeCertificate')))
    _AttributeCertificate_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __AttributeCertificate_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___AttributeCertificate_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___AttributeCertificate_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab = ___AttributeCertificate_algorithmIdentifier_algorithm_tab
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab_at = None
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __AttributeCertificate_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab = ___AttributeCertificate_algorithmIdentifier_algorithm_tab
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _AttributeCertificate_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificate_algorithmIdentifier_algorithm),
        (u'parameters', __AttributeCertificate_algorithmIdentifier_parameters),
        ])
    _AttributeCertificate_algorithmIdentifier._ext = []
    _AttributeCertificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    AttributeCertificate._cont = ASN1Dict([
        (u'toBeSigned', _AttributeCertificate_toBeSigned),
        (u'algorithmIdentifier', _AttributeCertificate_algorithmIdentifier),
        (u'signature', _AttributeCertificate_signature),
        ])
    AttributeCertificate._ext = []
    
    #-----< TBSAttributeCertificate >-----#
    TBSAttributeCertificate = SEQ(name=u'TBSAttributeCertificate', mode=MODE_TYPE)
    _TBSAttributeCertificate_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertVersion')))
    _TBSAttributeCertificate_holder = SEQ(name=u'holder', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Holder')))
    _TBSAttributeCertificate_issuer = SEQ(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertIssuer')))
    _TBSAttributeCertificate_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __TBSAttributeCertificate_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___TBSAttributeCertificate_signature_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_trailerField),
        ])
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21._ext = None
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___TBSAttributeCertificate_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __TBSAttributeCertificate_signature_algorithm._const_tab = ___TBSAttributeCertificate_signature_algorithm_tab
    __TBSAttributeCertificate_signature_algorithm._const_tab_at = None
    __TBSAttributeCertificate_signature_algorithm._const_tab_id = u'id'
    __TBSAttributeCertificate_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __TBSAttributeCertificate_signature_parameters._const_tab = ___TBSAttributeCertificate_signature_algorithm_tab
    __TBSAttributeCertificate_signature_parameters._const_tab_at = ('..', u'algorithm')
    __TBSAttributeCertificate_signature_parameters._const_tab_id = u'Type'
    _TBSAttributeCertificate_signature._cont = ASN1Dict([
        (u'algorithm', __TBSAttributeCertificate_signature_algorithm),
        (u'parameters', __TBSAttributeCertificate_signature_parameters),
        ])
    _TBSAttributeCertificate_signature._ext = []
    _TBSAttributeCertificate_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _TBSAttributeCertificate_attrCertValidityPeriod = SEQ(name=u'attrCertValidityPeriod', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertValidityPeriod')))
    _TBSAttributeCertificate_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE)
    __TBSAttributeCertificate_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___TBSAttributeCertificate_attributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____TBSAttributeCertificate_attributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____TBSAttributeCertificate_attributes__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    _____TBSAttributeCertificate_attributes__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0 = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____TBSAttributeCertificate_attributes__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____TBSAttributeCertificate_attributes__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____TBSAttributeCertificate_attributes__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___TBSAttributeCertificate_attributes__item__type._const_tab = ____TBSAttributeCertificate_attributes__item__type_tab
    ___TBSAttributeCertificate_attributes__item__type._const_tab_at = None
    ___TBSAttributeCertificate_attributes__item__type._const_tab_id = u'id'
    ___TBSAttributeCertificate_attributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____TBSAttributeCertificate_attributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____TBSAttributeCertificate_attributes__item__values__item_._const_tab = ____TBSAttributeCertificate_attributes__item__type_tab
    ____TBSAttributeCertificate_attributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____TBSAttributeCertificate_attributes__item__values__item_._const_tab_id = u'Type'
    ___TBSAttributeCertificate_attributes__item__values._cont = ____TBSAttributeCertificate_attributes__item__values__item_
    ___TBSAttributeCertificate_attributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___TBSAttributeCertificate_attributes__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____TBSAttributeCertificate_attributes__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__value._const_tab = ____TBSAttributeCertificate_attributes__item__type_tab
    _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______TBSAttributeCertificate_attributes__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__contextList._cont = ______TBSAttributeCertificate_attributes__item__valuesWithContext__item__contextList__item_
    _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____TBSAttributeCertificate_attributes__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__value),
        (u'contextList', _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__contextList),
        ])
    ____TBSAttributeCertificate_attributes__item__valuesWithContext__item_._ext = []
    ___TBSAttributeCertificate_attributes__item__valuesWithContext._cont = ____TBSAttributeCertificate_attributes__item__valuesWithContext__item_
    ___TBSAttributeCertificate_attributes__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __TBSAttributeCertificate_attributes__item_._cont = ASN1Dict([
        (u'type', ___TBSAttributeCertificate_attributes__item__type),
        (u'values', ___TBSAttributeCertificate_attributes__item__values),
        (u'valuesWithContext', ___TBSAttributeCertificate_attributes__item__valuesWithContext),
        ])
    __TBSAttributeCertificate_attributes__item_._ext = []
    _TBSAttributeCertificate_attributes._cont = __TBSAttributeCertificate_attributes__item_
    _TBSAttributeCertificate_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UniqueIdentifier')), opt=True)
    _TBSAttributeCertificate_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True)
    TBSAttributeCertificate._cont = ASN1Dict([
        (u'version', _TBSAttributeCertificate_version),
        (u'holder', _TBSAttributeCertificate_holder),
        (u'issuer', _TBSAttributeCertificate_issuer),
        (u'signature', _TBSAttributeCertificate_signature),
        (u'serialNumber', _TBSAttributeCertificate_serialNumber),
        (u'attrCertValidityPeriod', _TBSAttributeCertificate_attrCertValidityPeriod),
        (u'attributes', _TBSAttributeCertificate_attributes),
        (u'issuerUniqueID', _TBSAttributeCertificate_issuerUniqueID),
        (u'extensions', _TBSAttributeCertificate_extensions),
        ])
    TBSAttributeCertificate._ext = [u'extensions']
    
    #-----< AttCertVersion >-----#
    AttCertVersion = INT(name=u'AttCertVersion', mode=MODE_TYPE)
    AttCertVersion._cont = ASN1Dict([(u'v2', 1)])
    
    #-----< Holder >-----#
    Holder = SEQ(name=u'Holder', mode=MODE_TYPE)
    _Holder_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')), opt=True)
    _Holder_entityName = SEQ_OF(name=u'entityName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _Holder_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'ObjectDigestInfo')), opt=True)
    Holder._cont = ASN1Dict([
        (u'baseCertificateID', _Holder_baseCertificateID),
        (u'entityName', _Holder_entityName),
        (u'objectDigestInfo', _Holder_objectDigestInfo),
        ])
    Holder._ext = None
    
    #-----< IssuerSerial >-----#
    IssuerSerial = SEQ(name=u'IssuerSerial', mode=MODE_TYPE)
    _IssuerSerial_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    _IssuerSerial_serial = INT(name=u'serial', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _IssuerSerial_issuerUID = BIT_STR(name=u'issuerUID', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UniqueIdentifier')), opt=True)
    IssuerSerial._cont = ASN1Dict([
        (u'issuer', _IssuerSerial_issuer),
        (u'serial', _IssuerSerial_serial),
        (u'issuerUID', _IssuerSerial_issuerUID),
        ])
    IssuerSerial._ext = []
    
    #-----< ObjectDigestInfo >-----#
    ObjectDigestInfo = SEQ(name=u'ObjectDigestInfo', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType = ENUM(name=u'digestedObjectType', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType._cont = ASN1Dict([(u'publicKey', 0), (u'publicKeyCert', 1), (u'otherObjectTypes', 2)])
    _ObjectDigestInfo_digestedObjectType._ext = None
    _ObjectDigestInfo_otherObjectTypeID = OID(name=u'otherObjectTypeID', mode=MODE_TYPE, opt=True)
    _ObjectDigestInfo_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __ObjectDigestInfo_digestAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___ObjectDigestInfo_digestAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_trailerField),
        ])
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21._ext = None
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___ObjectDigestInfo_digestAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab = ___ObjectDigestInfo_digestAlgorithm_algorithm_tab
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab_at = None
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab_id = u'id'
    __ObjectDigestInfo_digestAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab = ___ObjectDigestInfo_digestAlgorithm_algorithm_tab
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab_id = u'Type'
    _ObjectDigestInfo_digestAlgorithm._cont = ASN1Dict([
        (u'algorithm', __ObjectDigestInfo_digestAlgorithm_algorithm),
        (u'parameters', __ObjectDigestInfo_digestAlgorithm_parameters),
        ])
    _ObjectDigestInfo_digestAlgorithm._ext = []
    _ObjectDigestInfo_objectDigest = BIT_STR(name=u'objectDigest', mode=MODE_TYPE)
    ObjectDigestInfo._cont = ASN1Dict([
        (u'digestedObjectType', _ObjectDigestInfo_digestedObjectType),
        (u'otherObjectTypeID', _ObjectDigestInfo_otherObjectTypeID),
        (u'digestAlgorithm', _ObjectDigestInfo_digestAlgorithm),
        (u'objectDigest', _ObjectDigestInfo_objectDigest),
        ])
    ObjectDigestInfo._ext = []
    
    #-----< AttCertIssuer >-----#
    AttCertIssuer = SEQ(name=u'AttCertIssuer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AttCertIssuer_issuerName = SEQ_OF(name=u'issuerName', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _AttCertIssuer_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')), opt=True)
    _AttCertIssuer_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'ObjectDigestInfo')), opt=True)
    AttCertIssuer._cont = ASN1Dict([
        (u'issuerName', _AttCertIssuer_issuerName),
        (u'baseCertificateID', _AttCertIssuer_baseCertificateID),
        (u'objectDigestInfo', _AttCertIssuer_objectDigestInfo),
        ])
    AttCertIssuer._ext = []
    
    #-----< AttCertValidityPeriod >-----#
    AttCertValidityPeriod = SEQ(name=u'AttCertValidityPeriod', mode=MODE_TYPE)
    _AttCertValidityPeriod_notBeforeTime = TIME_GEN(name=u'notBeforeTime', mode=MODE_TYPE)
    _AttCertValidityPeriod_notAfterTime = TIME_GEN(name=u'notAfterTime', mode=MODE_TYPE)
    AttCertValidityPeriod._cont = ASN1Dict([
        (u'notBeforeTime', _AttCertValidityPeriod_notBeforeTime),
        (u'notAfterTime', _AttCertValidityPeriod_notAfterTime),
        ])
    AttCertValidityPeriod._ext = []
    
    #-----< AttributeCertificationPath >-----#
    AttributeCertificationPath = SEQ(name=u'AttributeCertificationPath', mode=MODE_TYPE)
    _AttributeCertificationPath_attributeCertificate = SEQ(name=u'attributeCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    _AttributeCertificationPath_acPath = SEQ_OF(name=u'acPath', mode=MODE_TYPE, opt=True)
    __AttributeCertificationPath_acPath__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'ACPathData')))
    _AttributeCertificationPath_acPath._cont = __AttributeCertificationPath_acPath__item_
    AttributeCertificationPath._cont = ASN1Dict([
        (u'attributeCertificate', _AttributeCertificationPath_attributeCertificate),
        (u'acPath', _AttributeCertificationPath_acPath),
        ])
    AttributeCertificationPath._ext = []
    
    #-----< ACPathData >-----#
    ACPathData = SEQ(name=u'ACPathData', mode=MODE_TYPE)
    _ACPathData_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')), opt=True)
    _ACPathData_attributeCertificate = SEQ(name=u'attributeCertificate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')), opt=True)
    ACPathData._cont = ASN1Dict([
        (u'certificate', _ACPathData_certificate),
        (u'attributeCertificate', _ACPathData_attributeCertificate),
        ])
    ACPathData._ext = []
    
    #-----< PrivilegePolicy >-----#
    PrivilegePolicy = OID(name=u'PrivilegePolicy', mode=MODE_TYPE)
    
    #-----< role >-----#
    role = CLASS(name=u'role', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _role_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'RoleSyntax')))
    role._val = dict([(u'Type', _role_val_Type), (u'id', (2, 5, 4, 72))])
    
    #-----< RoleSyntax >-----#
    RoleSyntax = SEQ(name=u'RoleSyntax', mode=MODE_TYPE)
    _RoleSyntax_roleAuthority = SEQ_OF(name=u'roleAuthority', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _RoleSyntax_roleName = CHOICE(name=u'roleName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    RoleSyntax._cont = ASN1Dict([
        (u'roleAuthority', _RoleSyntax_roleAuthority),
        (u'roleName', _RoleSyntax_roleName),
        ])
    RoleSyntax._ext = []
    
    #-----< xmlPrivilegeInfo >-----#
    xmlPrivilegeInfo = CLASS(name=u'xmlPrivilegeInfo', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _xmlPrivilegeInfo_val_Type = STR_UTF8(name=u'Type', mode=MODE_TYPE)
    xmlPrivilegeInfo._val = dict([(u'Type', _xmlPrivilegeInfo_val_Type), (u'id', (2, 5, 4, 75))])
    
    #-----< permission >-----#
    permission = CLASS(name=u'permission', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _permission_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'DualStringSyntax')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'DualStringSyntax')))
    permission._val = dict([(u'Type', _permission_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'id', (2, 5, 13, 69))])), (u'id', (2, 5, 4, 82))])
    
    #-----< DualStringSyntax >-----#
    DualStringSyntax = SEQ(name=u'DualStringSyntax', mode=MODE_TYPE)
    _DualStringSyntax_operation = CHOICE(name=u'operation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    _DualStringSyntax_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    DualStringSyntax._cont = ASN1Dict([
        (u'operation', _DualStringSyntax_operation),
        (u'object', _DualStringSyntax_object),
        ])
    DualStringSyntax._ext = []
    
    #-----< dualStringMatch >-----#
    dualStringMatch = CLASS(name=u'dualStringMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _dualStringMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'DualStringSyntax')))
    dualStringMatch._val = dict([(u'AssertionType', _dualStringMatch_val_AssertionType), (u'id', (2, 5, 13, 69))])
    
    #-----< timeSpecification >-----#
    timeSpecification = CLASS(name=u'timeSpecification', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _timeSpecification_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'TimeSpecification')))
    timeSpecification._val = dict([(u'ExtnType', _timeSpecification_val_ExtnType), (u'id', (2, 5, 29, 43))])
    
    #-----< timeSpecificationMatch >-----#
    timeSpecificationMatch = CLASS(name=u'timeSpecificationMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _timeSpecificationMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'TimeSpecification')))
    timeSpecificationMatch._val = dict([(u'AssertionType', _timeSpecificationMatch_val_AssertionType), (u'id', (2, 5, 13, 57))])
    
    #-----< targetingInformation >-----#
    targetingInformation = CLASS(name=u'targetingInformation', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _targetingInformation_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE)
    __targetingInformation_val_ExtnType__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Targets')))
    _targetingInformation_val_ExtnType._cont = __targetingInformation_val_ExtnType__item_
    _targetingInformation_val_ExtnType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    targetingInformation._val = dict([(u'ExtnType', _targetingInformation_val_ExtnType), (u'id', (2, 5, 29, 55))])
    
    #-----< Targets >-----#
    Targets = SEQ_OF(name=u'Targets', mode=MODE_TYPE)
    _Targets__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Target')))
    Targets._cont = _Targets__item_
    Targets._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< Target >-----#
    Target = CHOICE(name=u'Target', mode=MODE_TYPE)
    _Target_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _Target_targetGroup = CHOICE(name=u'targetGroup', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _Target_targetCert = SEQ(name=u'targetCert', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'TargetCert')))
    Target._cont = ASN1Dict([
        (u'targetName', _Target_targetName),
        (u'targetGroup', _Target_targetGroup),
        (u'targetCert', _Target_targetCert),
        ])
    Target._ext = []
    
    #-----< TargetCert >-----#
    TargetCert = SEQ(name=u'TargetCert', mode=MODE_TYPE)
    _TargetCert_targetCertificate = SEQ(name=u'targetCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')))
    _TargetCert_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _TargetCert_certDigestInfo = SEQ(name=u'certDigestInfo', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'ObjectDigestInfo')), opt=True)
    TargetCert._cont = ASN1Dict([
        (u'targetCertificate', _TargetCert_targetCertificate),
        (u'targetName', _TargetCert_targetName),
        (u'certDigestInfo', _TargetCert_certDigestInfo),
        ])
    TargetCert._ext = None
    
    #-----< userNotice >-----#
    userNotice = CLASS(name=u'userNotice', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _userNotice_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE)
    __userNotice_val_ExtnType__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PkiPmiExternalDataTypes', 'UserNotice')))
    _userNotice_val_ExtnType._cont = __userNotice_val_ExtnType__item_
    _userNotice_val_ExtnType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    userNotice._val = dict([(u'ExtnType', _userNotice_val_ExtnType), (u'id', (2, 5, 29, 49))])
    
    #-----< acceptablePrivilegePolicies >-----#
    acceptablePrivilegePolicies = CLASS(name=u'acceptablePrivilegePolicies', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _acceptablePrivilegePolicies_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AcceptablePrivilegePoliciesSyntax')))
    acceptablePrivilegePolicies._val = dict([(u'ExtnType', _acceptablePrivilegePolicies_val_ExtnType), (u'id', (2, 5, 29, 57))])
    
    #-----< AcceptablePrivilegePoliciesSyntax >-----#
    AcceptablePrivilegePoliciesSyntax = SEQ_OF(name=u'AcceptablePrivilegePoliciesSyntax', mode=MODE_TYPE)
    _AcceptablePrivilegePoliciesSyntax__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'PrivilegePolicy')))
    AcceptablePrivilegePoliciesSyntax._cont = _AcceptablePrivilegePoliciesSyntax__item_
    AcceptablePrivilegePoliciesSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< singleUse >-----#
    singleUse = CLASS(name=u'singleUse', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _singleUse_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    singleUse._val = dict([(u'ExtnType', _singleUse_val_ExtnType), (u'id', (2, 5, 29, 65))])
    
    #-----< groupAC >-----#
    groupAC = CLASS(name=u'groupAC', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _groupAC_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    groupAC._val = dict([(u'ExtnType', _groupAC_val_ExtnType), (u'id', (2, 5, 29, 66))])
    
    #-----< noRevAvail >-----#
    noRevAvail = CLASS(name=u'noRevAvail', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _noRevAvail_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    noRevAvail._val = dict([(u'ExtnType', _noRevAvail_val_ExtnType), (u'id', (2, 5, 29, 56))])
    
    #-----< sOAIdentifier >-----#
    sOAIdentifier = CLASS(name=u'sOAIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _sOAIdentifier_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    sOAIdentifier._val = dict([(u'ExtnType', _sOAIdentifier_val_ExtnType), (u'id', (2, 5, 29, 50))])
    
    #-----< sOAIdentifierMatch >-----#
    sOAIdentifierMatch = CLASS(name=u'sOAIdentifierMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _sOAIdentifierMatch_val_AssertionType = NULL(name=u'AssertionType', mode=MODE_TYPE)
    sOAIdentifierMatch._val = dict([(u'AssertionType', _sOAIdentifierMatch_val_AssertionType), (u'id', (2, 5, 13, 66))])
    
    #-----< attributeDescriptor >-----#
    attributeDescriptor = CLASS(name=u'attributeDescriptor', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _attributeDescriptor_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeDescriptorSyntax')))
    attributeDescriptor._val = dict([(u'ExtnType', _attributeDescriptor_val_ExtnType), (u'id', (2, 5, 29, 48))])
    
    #-----< AttributeDescriptorSyntax >-----#
    AttributeDescriptorSyntax = SEQ(name=u'AttributeDescriptorSyntax', mode=MODE_TYPE)
    _AttributeDescriptorSyntax_identifier = OID(name=u'identifier', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeIdentifier')))
    _AttributeDescriptorSyntax_attributeSyntax = OCT_STR(name=u'attributeSyntax', mode=MODE_TYPE)
    _AttributeDescriptorSyntax_attributeSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _AttributeDescriptorSyntax_name = STR_UTF8(name=u'name', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeName')), opt=True)
    _AttributeDescriptorSyntax_description = STR_UTF8(name=u'description', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeDescription')), opt=True)
    _AttributeDescriptorSyntax_dominationRule = SEQ(name=u'dominationRule', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'PrivilegePolicyIdentifier')))
    AttributeDescriptorSyntax._cont = ASN1Dict([
        (u'identifier', _AttributeDescriptorSyntax_identifier),
        (u'attributeSyntax', _AttributeDescriptorSyntax_attributeSyntax),
        (u'name', _AttributeDescriptorSyntax_name),
        (u'description', _AttributeDescriptorSyntax_description),
        (u'dominationRule', _AttributeDescriptorSyntax_dominationRule),
        ])
    AttributeDescriptorSyntax._ext = []
    
    #-----< AttributeIdentifier >-----#
    AttributeIdentifier = OID(name=u'AttributeIdentifier', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _AttributeIdentifier_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _AttributeIdentifier_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    AttributeIdentifier._const_tab = _AttributeIdentifier_tab
    AttributeIdentifier._const_tab_at = None
    AttributeIdentifier._const_tab_id = u'id'
    
    #-----< AttributeIDs >-----#
    AttributeIDs = CLASS(name=u'AttributeIDs', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    AttributeIDs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< AttributeName >-----#
    AttributeName = STR_UTF8(name=u'AttributeName', mode=MODE_TYPE)
    AttributeName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AttributeDescription >-----#
    AttributeDescription = STR_UTF8(name=u'AttributeDescription', mode=MODE_TYPE)
    AttributeDescription._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PrivilegePolicyIdentifier >-----#
    PrivilegePolicyIdentifier = SEQ(name=u'PrivilegePolicyIdentifier', mode=MODE_TYPE)
    _PrivilegePolicyIdentifier_privilegePolicy = OID(name=u'privilegePolicy', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'PrivilegePolicy')))
    _PrivilegePolicyIdentifier_privPolSyntax = CHOICE(name=u'privPolSyntax', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'InfoSyntax')))
    PrivilegePolicyIdentifier._cont = ASN1Dict([
        (u'privilegePolicy', _PrivilegePolicyIdentifier_privilegePolicy),
        (u'privPolSyntax', _PrivilegePolicyIdentifier_privPolSyntax),
        ])
    PrivilegePolicyIdentifier._ext = []
    
    #-----< attDescriptor >-----#
    attDescriptor = CLASS(name=u'attDescriptor', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _attDescriptor_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeDescriptorSyntax')))
    attDescriptor._val = dict([(u'AssertionType', _attDescriptor_val_AssertionType), (u'id', (2, 5, 13, 58))])
    
    #-----< roleSpecCertIdentifier >-----#
    roleSpecCertIdentifier = CLASS(name=u'roleSpecCertIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _roleSpecCertIdentifier_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'RoleSpecCertIdentifierSyntax')))
    roleSpecCertIdentifier._val = dict([(u'ExtnType', _roleSpecCertIdentifier_val_ExtnType), (u'id', (2, 5, 29, 39))])
    
    #-----< RoleSpecCertIdentifierSyntax >-----#
    RoleSpecCertIdentifierSyntax = SEQ_OF(name=u'RoleSpecCertIdentifierSyntax', mode=MODE_TYPE)
    _RoleSpecCertIdentifierSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'RoleSpecCertIdentifier')))
    RoleSpecCertIdentifierSyntax._cont = _RoleSpecCertIdentifierSyntax__item_
    RoleSpecCertIdentifierSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< RoleSpecCertIdentifier >-----#
    RoleSpecCertIdentifier = SEQ(name=u'RoleSpecCertIdentifier', mode=MODE_TYPE)
    _RoleSpecCertIdentifier_roleName = CHOICE(name=u'roleName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _RoleSpecCertIdentifier_roleCertIssuer = CHOICE(name=u'roleCertIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _RoleSpecCertIdentifier_roleCertSerialNumber = INT(name=u'roleCertSerialNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')), opt=True)
    _RoleSpecCertIdentifier_roleCertLocator = SEQ_OF(name=u'roleCertLocator', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    RoleSpecCertIdentifier._cont = ASN1Dict([
        (u'roleName', _RoleSpecCertIdentifier_roleName),
        (u'roleCertIssuer', _RoleSpecCertIdentifier_roleCertIssuer),
        (u'roleCertSerialNumber', _RoleSpecCertIdentifier_roleCertSerialNumber),
        (u'roleCertLocator', _RoleSpecCertIdentifier_roleCertLocator),
        ])
    RoleSpecCertIdentifier._ext = []
    
    #-----< roleSpecCertIdMatch >-----#
    roleSpecCertIdMatch = CLASS(name=u'roleSpecCertIdMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _roleSpecCertIdMatch_val_AssertionType = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'RoleSpecCertIdentifierSyntax')))
    roleSpecCertIdMatch._val = dict([(u'AssertionType', _roleSpecCertIdMatch_val_AssertionType), (u'id', (2, 5, 13, 54))])
    
    #-----< basicAttConstraints >-----#
    basicAttConstraints = CLASS(name=u'basicAttConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _basicAttConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'BasicAttConstraintsSyntax')))
    basicAttConstraints._val = dict([(u'ExtnType', _basicAttConstraints_val_ExtnType), (u'id', (2, 5, 29, 41))])
    
    #-----< BasicAttConstraintsSyntax >-----#
    BasicAttConstraintsSyntax = SEQ(name=u'BasicAttConstraintsSyntax', mode=MODE_TYPE)
    _BasicAttConstraintsSyntax_authority = BOOL(name=u'authority', mode=MODE_TYPE, default=False)
    _BasicAttConstraintsSyntax_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _BasicAttConstraintsSyntax_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    BasicAttConstraintsSyntax._cont = ASN1Dict([
        (u'authority', _BasicAttConstraintsSyntax_authority),
        (u'pathLenConstraint', _BasicAttConstraintsSyntax_pathLenConstraint),
        ])
    BasicAttConstraintsSyntax._ext = []
    
    #-----< basicAttConstraintsMatch >-----#
    basicAttConstraintsMatch = CLASS(name=u'basicAttConstraintsMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _basicAttConstraintsMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'BasicAttConstraintsSyntax')))
    basicAttConstraintsMatch._val = dict([(u'AssertionType', _basicAttConstraintsMatch_val_AssertionType), (u'id', (2, 5, 13, 55))])
    
    #-----< delegatedNameConstraints >-----#
    delegatedNameConstraints = CLASS(name=u'delegatedNameConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _delegatedNameConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')))
    delegatedNameConstraints._val = dict([(u'ExtnType', _delegatedNameConstraints_val_ExtnType), (u'id', (2, 5, 29, 42))])
    
    #-----< delegatedNameConstraintsMatch >-----#
    delegatedNameConstraintsMatch = CLASS(name=u'delegatedNameConstraintsMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _delegatedNameConstraintsMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')))
    delegatedNameConstraintsMatch._val = dict([(u'AssertionType', _delegatedNameConstraintsMatch_val_AssertionType), (u'id', (2, 5, 13, 56))])
    
    #-----< acceptableCertPolicies >-----#
    acceptableCertPolicies = CLASS(name=u'acceptableCertPolicies', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _acceptableCertPolicies_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AcceptableCertPoliciesSyntax')))
    acceptableCertPolicies._val = dict([(u'ExtnType', _acceptableCertPolicies_val_ExtnType), (u'id', (2, 5, 29, 52))])
    
    #-----< AcceptableCertPoliciesSyntax >-----#
    AcceptableCertPoliciesSyntax = SEQ_OF(name=u'AcceptableCertPoliciesSyntax', mode=MODE_TYPE)
    _AcceptableCertPoliciesSyntax__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'CertPolicyId')))
    AcceptableCertPoliciesSyntax._cont = _AcceptableCertPoliciesSyntax__item_
    AcceptableCertPoliciesSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< CertPolicyId >-----#
    CertPolicyId = OID(name=u'CertPolicyId', mode=MODE_TYPE)
    
    #-----< acceptableCertPoliciesMatch >-----#
    acceptableCertPoliciesMatch = CLASS(name=u'acceptableCertPoliciesMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _acceptableCertPoliciesMatch_val_AssertionType = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AcceptableCertPoliciesSyntax')))
    acceptableCertPoliciesMatch._val = dict([(u'AssertionType', _acceptableCertPoliciesMatch_val_AssertionType), (u'id', (2, 5, 13, 59))])
    
    #-----< authorityAttributeIdentifier >-----#
    authorityAttributeIdentifier = CLASS(name=u'authorityAttributeIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _authorityAttributeIdentifier_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AuthorityAttributeIdentifierSyntax')))
    authorityAttributeIdentifier._val = dict([(u'ExtnType', _authorityAttributeIdentifier_val_ExtnType), (u'id', (2, 5, 29, 38))])
    
    #-----< AuthorityAttributeIdentifierSyntax >-----#
    AuthorityAttributeIdentifierSyntax = SEQ_OF(name=u'AuthorityAttributeIdentifierSyntax', mode=MODE_TYPE)
    _AuthorityAttributeIdentifierSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AuthAttId')))
    AuthorityAttributeIdentifierSyntax._cont = _AuthorityAttributeIdentifierSyntax__item_
    AuthorityAttributeIdentifierSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AuthAttId >-----#
    AuthAttId = SEQ(name=u'AuthAttId', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')))
    
    #-----< authAttIdMatch >-----#
    authAttIdMatch = CLASS(name=u'authAttIdMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _authAttIdMatch_val_AssertionType = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AuthorityAttributeIdentifierSyntax')))
    authAttIdMatch._val = dict([(u'AssertionType', _authAttIdMatch_val_AssertionType), (u'id', (2, 5, 13, 53))])
    
    #-----< indirectIssuer >-----#
    indirectIssuer = CLASS(name=u'indirectIssuer', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _indirectIssuer_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    indirectIssuer._val = dict([(u'ExtnType', _indirectIssuer_val_ExtnType), (u'id', (2, 5, 29, 61))])
    
    #-----< issuedOnBehalfOf >-----#
    issuedOnBehalfOf = CLASS(name=u'issuedOnBehalfOf', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _issuedOnBehalfOf_val_ExtnType = CHOICE(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    issuedOnBehalfOf._val = dict([(u'ExtnType', _issuedOnBehalfOf_val_ExtnType), (u'id', (2, 5, 29, 64))])
    
    #-----< noAssertion >-----#
    noAssertion = CLASS(name=u'noAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _noAssertion_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    noAssertion._val = dict([(u'ExtnType', _noAssertion_val_ExtnType), (u'id', (2, 5, 29, 62))])
    
    #-----< allowedAttributeAssignments >-----#
    allowedAttributeAssignments = CLASS(name=u'allowedAttributeAssignments', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _allowedAttributeAssignments_val_ExtnType = SET_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AllowedAttributeAssignments')))
    allowedAttributeAssignments._val = dict([(u'ExtnType', _allowedAttributeAssignments_val_ExtnType), (u'id', (2, 5, 29, 67))])
    
    #-----< AllowedAttributeAssignments >-----#
    AllowedAttributeAssignments = SET_OF(name=u'AllowedAttributeAssignments', mode=MODE_TYPE)
    _AllowedAttributeAssignments__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __AllowedAttributeAssignments__item__attributes = SET_OF(name=u'attributes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AllowedAttributeAssignments__item__attributes__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ____AllowedAttributeAssignments__item__attributes__item__attributeType = OID(name=u'attributeType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues = SEQ(name=u'attributeTypeandValues', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab._val = ASN1Set(rv=[dict([(u'Type', _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type._const_tab = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type._const_tab_at = None
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type._const_tab_id = u'id'
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values = SET_OF(name=u'values', mode=MODE_TYPE)
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_._const_tab = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_._const_tab_at = ('..', '..', u'type')
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_._const_tab_id = u'Type'
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values._cont = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value._const_tab = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value._const_tab_id = u'Type'
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ________AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList._cont = ________AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList__item_
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value),
        (u'contextList', _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList),
        ])
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_._ext = []
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext._cont = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues._cont = ASN1Dict([
        (u'type', _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type),
        (u'values', _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values),
        (u'valuesWithContext', _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext),
        ])
    ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues._ext = []
    ___AllowedAttributeAssignments__item__attributes__item_._cont = ASN1Dict([
        (u'attributeType', ____AllowedAttributeAssignments__item__attributes__item__attributeType),
        (u'attributeTypeandValues', ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues),
        ])
    ___AllowedAttributeAssignments__item__attributes__item_._ext = []
    __AllowedAttributeAssignments__item__attributes._cont = ___AllowedAttributeAssignments__item__attributes__item_
    __AllowedAttributeAssignments__item__holderDomain = CHOICE(name=u'holderDomain', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _AllowedAttributeAssignments__item_._cont = ASN1Dict([
        (u'attributes', __AllowedAttributeAssignments__item__attributes),
        (u'holderDomain', __AllowedAttributeAssignments__item__holderDomain),
        ])
    _AllowedAttributeAssignments__item_._ext = []
    AllowedAttributeAssignments._cont = _AllowedAttributeAssignments__item_
    
    #-----< attributeMappings >-----#
    attributeMappings = CLASS(name=u'attributeMappings', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _attributeMappings_val_ExtnType = SET_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeMappings')))
    attributeMappings._val = dict([(u'ExtnType', _attributeMappings_val_ExtnType), (u'id', (2, 5, 29, 68))])
    
    #-----< AttributeMappings >-----#
    AttributeMappings = SET_OF(name=u'AttributeMappings', mode=MODE_TYPE)
    _AttributeMappings__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    __AttributeMappings__item__typeMappings = SEQ(name=u'typeMappings', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AttributeMappings__item__typeMappings_local = OID(name=u'local', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___AttributeMappings__item__typeMappings_remote = OID(name=u'remote', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    __AttributeMappings__item__typeMappings._cont = ASN1Dict([
        (u'local', ___AttributeMappings__item__typeMappings_local),
        (u'remote', ___AttributeMappings__item__typeMappings_remote),
        ])
    __AttributeMappings__item__typeMappings._ext = []
    __AttributeMappings__item__typeValueMappings = SEQ(name=u'typeValueMappings', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AttributeMappings__item__typeValueMappings_local = SEQ(name=u'local', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAndValue')))
    ___AttributeMappings__item__typeValueMappings_remote = SEQ(name=u'remote', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAndValue')))
    __AttributeMappings__item__typeValueMappings._cont = ASN1Dict([
        (u'local', ___AttributeMappings__item__typeValueMappings_local),
        (u'remote', ___AttributeMappings__item__typeValueMappings_remote),
        ])
    __AttributeMappings__item__typeValueMappings._ext = []
    _AttributeMappings__item_._cont = ASN1Dict([
        (u'typeMappings', __AttributeMappings__item__typeMappings),
        (u'typeValueMappings', __AttributeMappings__item__typeValueMappings),
        ])
    _AttributeMappings__item_._ext = None
    AttributeMappings._cont = _AttributeMappings__item_
    
    #-----< holderNameConstraints >-----#
    holderNameConstraints = CLASS(name=u'holderNameConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _holderNameConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'HolderNameConstraintsSyntax')))
    holderNameConstraints._val = dict([(u'ExtnType', _holderNameConstraints_val_ExtnType), (u'id', (2, 5, 29, 69))])
    
    #-----< HolderNameConstraintsSyntax >-----#
    HolderNameConstraintsSyntax = SEQ(name=u'HolderNameConstraintsSyntax', mode=MODE_TYPE)
    _HolderNameConstraintsSyntax_permittedSubtrees = SEQ_OF(name=u'permittedSubtrees', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'GeneralSubtrees')))
    _HolderNameConstraintsSyntax_excludedSubtrees = SEQ_OF(name=u'excludedSubtrees', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'GeneralSubtrees')), opt=True)
    HolderNameConstraintsSyntax._cont = ASN1Dict([
        (u'permittedSubtrees', _HolderNameConstraintsSyntax_permittedSubtrees),
        (u'excludedSubtrees', _HolderNameConstraintsSyntax_excludedSubtrees),
        ])
    HolderNameConstraintsSyntax._ext = []
    
    #-----< GeneralSubtrees >-----#
    GeneralSubtrees = SEQ_OF(name=u'GeneralSubtrees', mode=MODE_TYPE)
    _GeneralSubtrees__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'GeneralSubtree')))
    GeneralSubtrees._cont = _GeneralSubtrees__item_
    GeneralSubtrees._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralSubtree >-----#
    GeneralSubtree = SEQ(name=u'GeneralSubtree', mode=MODE_TYPE)
    _GeneralSubtree_base = CHOICE(name=u'base', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _GeneralSubtree_minimum = INT(name=u'minimum', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'BaseDistance')), default=0)
    _GeneralSubtree_maximum = INT(name=u'maximum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'BaseDistance')), opt=True)
    GeneralSubtree._cont = ASN1Dict([
        (u'base', _GeneralSubtree_base),
        (u'minimum', _GeneralSubtree_minimum),
        (u'maximum', _GeneralSubtree_maximum),
        ])
    GeneralSubtree._ext = []
    
    #-----< BaseDistance >-----#
    BaseDistance = INT(name=u'BaseDistance', mode=MODE_TYPE)
    BaseDistance._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< pmiUser >-----#
    pmiUser = CLASS(name=u'pmiUser', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    __pmiUser_OptionalAttributes_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificateExactAssertion')))
    pmiUser._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 58))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 24))])
    
    #-----< pmiAA >-----#
    pmiAA = CLASS(name=u'pmiAA', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListExactAssertion')))
    __pmiUser_OptionalAttributes_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    pmiAA._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 61))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'AttrCertificateRevocationList']), (u'ldapDesc', u'X.509 Attr certificate revocation list'), (u'id', (2, 5, 4, 59))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'AACertificateRevocationList']), (u'ldapDesc', u'X.509 AA certificate revocation list'), (u'id', (2, 5, 4, 63))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 25))])
    
    #-----< pmiSOA >-----#
    pmiSOA = CLASS(name=u'pmiSOA', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    __pmiUser_OptionalAttributes_val_Type_2_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    pmiSOA._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'AttrCertificateRevocationList']), (u'ldapDesc', u'X.509 Attr certificate revocation list'), (u'id', (2, 5, 4, 59))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'AACertificateRevocationList']), (u'ldapDesc', u'X.509 AA certificate revocation list'), (u'id', (2, 5, 4, 63))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 62))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 26))])
    
    #-----< attCertCRLDistributionPt >-----#
    attCertCRLDistributionPt = CLASS(name=u'attCertCRLDistributionPt', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    attCertCRLDistributionPt._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'AttrCertificateRevocationList']), (u'ldapDesc', u'X.509 Attr certificate revocation list'), (u'id', (2, 5, 4, 59))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'AACertificateRevocationList']), (u'ldapDesc', u'X.509 AA certificate revocation list'), (u'id', (2, 5, 4, 63))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 27))])
    
    #-----< pmiDelegationPath >-----#
    pmiDelegationPath = CLASS(name=u'pmiDelegationPath', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertPath')))
    pmiDelegationPath._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_1), (u'id', (2, 5, 4, 73))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 33))])
    
    #-----< privilegePolicy >-----#
    privilegePolicy = CLASS(name=u'privilegePolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicySyntax')))
    privilegePolicy._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_2), (u'id', (2, 5, 4, 71))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 32))])
    
    #-----< protectedPrivilegePolicy >-----#
    protectedPrivilegePolicy = CLASS(name=u'protectedPrivilegePolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    protectedPrivilegePolicy._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 74))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 34))])
    
    #-----< attributeCertificateAttribute >-----#
    attributeCertificateAttribute = CLASS(name=u'attributeCertificateAttribute', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _attributeCertificateAttribute_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    attributeCertificateAttribute._val = dict([(u'Type', _attributeCertificateAttribute_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 58))])
    
    #-----< aACertificate >-----#
    aACertificate = CLASS(name=u'aACertificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _aACertificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    aACertificate._val = dict([(u'Type', _aACertificate_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 61))])
    
    #-----< attributeDescriptorCertificate >-----#
    attributeDescriptorCertificate = CLASS(name=u'attributeDescriptorCertificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _attributeDescriptorCertificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    attributeDescriptorCertificate._val = dict([(u'Type', _attributeDescriptorCertificate_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 62))])
    
    #-----< attributeCertificateRevocationList >-----#
    attributeCertificateRevocationList = CLASS(name=u'attributeCertificateRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _attributeCertificateRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    attributeCertificateRevocationList._val = dict([(u'Type', _attributeCertificateRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'AttrCertificateRevocationList']), (u'ldapDesc', u'X.509 Attr certificate revocation list'), (u'id', (2, 5, 4, 59))])
    
    #-----< eeAttrCertificateRevocationList >-----#
    eeAttrCertificateRevocationList = CLASS(name=u'eeAttrCertificateRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _eeAttrCertificateRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    eeAttrCertificateRevocationList._val = dict([(u'Type', _eeAttrCertificateRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'EEAttrCertificateRevocationList']), (u'ldapDesc', u'X.509 EEAttr certificate revocation list'), (u'id', (2, 5, 4, 102))])
    
    #-----< attributeAuthorityRevocationList >-----#
    attributeAuthorityRevocationList = CLASS(name=u'attributeAuthorityRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _attributeAuthorityRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    attributeAuthorityRevocationList._val = dict([(u'Type', _attributeAuthorityRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'AACertificateRevocationList']), (u'ldapDesc', u'X.509 AA certificate revocation list'), (u'id', (2, 5, 4, 63))])
    
    #-----< delegationPath >-----#
    delegationPath = CLASS(name=u'delegationPath', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _delegationPath_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertPath')))
    delegationPath._val = dict([(u'Type', _delegationPath_val_Type), (u'id', (2, 5, 4, 73))])
    
    #-----< AttCertPath >-----#
    AttCertPath = SEQ_OF(name=u'AttCertPath', mode=MODE_TYPE)
    _AttCertPath__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    AttCertPath._cont = _AttCertPath__item_
    
    #-----< privPolicy >-----#
    privPolicy = CLASS(name=u'privPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _privPolicy_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicySyntax')))
    privPolicy._val = dict([(u'Type', _privPolicy_val_Type), (u'id', (2, 5, 4, 71))])
    
    #-----< protPrivPolicy >-----#
    protPrivPolicy = CLASS(name=u'protPrivPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _protPrivPolicy_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    protPrivPolicy._val = dict([(u'Type', _protPrivPolicy_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 74))])
    
    #-----< xmlPrivPolicy >-----#
    xmlPrivPolicy = CLASS(name=u'xmlPrivPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _xmlPrivPolicy_val_Type = STR_UTF8(name=u'Type', mode=MODE_TYPE)
    xmlPrivPolicy._val = dict([(u'Type', _xmlPrivPolicy_val_Type), (u'id', (2, 5, 4, 76))])
    
    #-----< attributeCertificateExactMatch >-----#
    attributeCertificateExactMatch = CLASS(name=u'attributeCertificateExactMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _attributeCertificateExactMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificateExactAssertion')))
    attributeCertificateExactMatch._val = dict([(u'AssertionType', _attributeCertificateExactMatch_val_AssertionType), (u'id', (2, 5, 13, 45))])
    
    #-----< AttributeCertificateExactAssertion >-----#
    AttributeCertificateExactAssertion = SEQ(name=u'AttributeCertificateExactAssertion', mode=MODE_TYPE)
    _AttributeCertificateExactAssertion_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _AttributeCertificateExactAssertion_issuer = SEQ(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertIssuer')))
    AttributeCertificateExactAssertion._cont = ASN1Dict([
        (u'serialNumber', _AttributeCertificateExactAssertion_serialNumber),
        (u'issuer', _AttributeCertificateExactAssertion_issuer),
        ])
    AttributeCertificateExactAssertion._ext = []
    
    #-----< attributeCertificateMatch >-----#
    attributeCertificateMatch = CLASS(name=u'attributeCertificateMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _attributeCertificateMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificateAssertion')))
    attributeCertificateMatch._val = dict([(u'AssertionType', _attributeCertificateMatch_val_AssertionType), (u'id', (2, 5, 13, 42))])
    
    #-----< AttributeCertificateAssertion >-----#
    AttributeCertificateAssertion = SEQ(name=u'AttributeCertificateAssertion', mode=MODE_TYPE)
    _AttributeCertificateAssertion_holder = CHOICE(name=u'holder', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AttributeCertificateAssertion_holder_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')))
    __AttributeCertificateAssertion_holder_holderName = SEQ_OF(name=u'holderName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    _AttributeCertificateAssertion_holder._cont = ASN1Dict([
        (u'baseCertificateID', __AttributeCertificateAssertion_holder_baseCertificateID),
        (u'holderName', __AttributeCertificateAssertion_holder_holderName),
        ])
    _AttributeCertificateAssertion_holder._ext = []
    _AttributeCertificateAssertion_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _AttributeCertificateAssertion_attCertValidity = TIME_GEN(name=u'attCertValidity', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _AttributeCertificateAssertion_attType = SET_OF(name=u'attType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AttributeCertificateAssertion_attType__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _AttributeCertificateAssertion_attType._cont = __AttributeCertificateAssertion_attType__item_
    AttributeCertificateAssertion._cont = ASN1Dict([
        (u'holder', _AttributeCertificateAssertion_holder),
        (u'issuer', _AttributeCertificateAssertion_issuer),
        (u'attCertValidity', _AttributeCertificateAssertion_attCertValidity),
        (u'attType', _AttributeCertificateAssertion_attType),
        ])
    AttributeCertificateAssertion._ext = []
    
    #-----< holderIssuerMatch >-----#
    holderIssuerMatch = CLASS(name=u'holderIssuerMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _holderIssuerMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'HolderIssuerAssertion')))
    holderIssuerMatch._val = dict([(u'AssertionType', _holderIssuerMatch_val_AssertionType), (u'id', (2, 5, 13, 46))])
    
    #-----< HolderIssuerAssertion >-----#
    HolderIssuerAssertion = SEQ(name=u'HolderIssuerAssertion', mode=MODE_TYPE)
    _HolderIssuerAssertion_holder = SEQ(name=u'holder', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Holder')), opt=True)
    _HolderIssuerAssertion_issuer = SEQ(name=u'issuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertIssuer')), opt=True)
    HolderIssuerAssertion._cont = ASN1Dict([
        (u'holder', _HolderIssuerAssertion_holder),
        (u'issuer', _HolderIssuerAssertion_issuer),
        ])
    HolderIssuerAssertion._ext = []
    
    #-----< delegationPathMatch >-----#
    delegationPathMatch = CLASS(name=u'delegationPathMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _delegationPathMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'DelMatchSyntax')))
    delegationPathMatch._val = dict([(u'AssertionType', _delegationPathMatch_val_AssertionType), (u'id', (2, 5, 13, 61))])
    
    #-----< DelMatchSyntax >-----#
    DelMatchSyntax = SEQ(name=u'DelMatchSyntax', mode=MODE_TYPE)
    _DelMatchSyntax_firstIssuer = SEQ(name=u'firstIssuer', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertIssuer')))
    _DelMatchSyntax_lastHolder = SEQ(name=u'lastHolder', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Holder')))
    DelMatchSyntax._cont = ASN1Dict([
        (u'firstIssuer', _DelMatchSyntax_firstIssuer),
        (u'lastHolder', _DelMatchSyntax_lastHolder),
        ])
    DelMatchSyntax._ext = []
    
    #-----< extensionPresenceMatch >-----#
    extensionPresenceMatch = CLASS(name=u'extensionPresenceMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _extensionPresenceMatch_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'EXTENSION'), [u'id']))
    extensionPresenceMatch._val = dict([(u'AssertionType', _extensionPresenceMatch_val_AssertionType), (u'id', (2, 5, 13, 67))])
    
    #-----< id-oc-pmiUser >-----#
    id_oc_pmiUser = OID(name=u'id-oc-pmiUser', mode=MODE_VALUE)
    id_oc_pmiUser._val = (2, 5, 6, 24)
    
    #-----< id-oc-pmiAA >-----#
    id_oc_pmiAA = OID(name=u'id-oc-pmiAA', mode=MODE_VALUE)
    id_oc_pmiAA._val = (2, 5, 6, 25)
    
    #-----< id-oc-pmiSOA >-----#
    id_oc_pmiSOA = OID(name=u'id-oc-pmiSOA', mode=MODE_VALUE)
    id_oc_pmiSOA._val = (2, 5, 6, 26)
    
    #-----< id-oc-attCertCRLDistributionPts >-----#
    id_oc_attCertCRLDistributionPts = OID(name=u'id-oc-attCertCRLDistributionPts', mode=MODE_VALUE)
    id_oc_attCertCRLDistributionPts._val = (2, 5, 6, 27)
    
    #-----< id-oc-privilegePolicy >-----#
    id_oc_privilegePolicy = OID(name=u'id-oc-privilegePolicy', mode=MODE_VALUE)
    id_oc_privilegePolicy._val = (2, 5, 6, 32)
    
    #-----< id-oc-pmiDelegationPath >-----#
    id_oc_pmiDelegationPath = OID(name=u'id-oc-pmiDelegationPath', mode=MODE_VALUE)
    id_oc_pmiDelegationPath._val = (2, 5, 6, 33)
    
    #-----< id-oc-protectedPrivilegePolicy >-----#
    id_oc_protectedPrivilegePolicy = OID(name=u'id-oc-protectedPrivilegePolicy', mode=MODE_VALUE)
    id_oc_protectedPrivilegePolicy._val = (2, 5, 6, 34)
    
    #-----< id-at-attributeCertificate >-----#
    id_at_attributeCertificate = OID(name=u'id-at-attributeCertificate', mode=MODE_VALUE)
    id_at_attributeCertificate._val = (2, 5, 4, 58)
    
    #-----< id-at-attributeCertificateRevocationList >-----#
    id_at_attributeCertificateRevocationList = OID(name=u'id-at-attributeCertificateRevocationList', mode=MODE_VALUE)
    id_at_attributeCertificateRevocationList._val = (2, 5, 4, 59)
    
    #-----< id-at-aACertificate >-----#
    id_at_aACertificate = OID(name=u'id-at-aACertificate', mode=MODE_VALUE)
    id_at_aACertificate._val = (2, 5, 4, 61)
    
    #-----< id-at-attributeDescriptorCertificate >-----#
    id_at_attributeDescriptorCertificate = OID(name=u'id-at-attributeDescriptorCertificate', mode=MODE_VALUE)
    id_at_attributeDescriptorCertificate._val = (2, 5, 4, 62)
    
    #-----< id-at-attributeAuthorityRevocationList >-----#
    id_at_attributeAuthorityRevocationList = OID(name=u'id-at-attributeAuthorityRevocationList', mode=MODE_VALUE)
    id_at_attributeAuthorityRevocationList._val = (2, 5, 4, 63)
    
    #-----< id-at-privPolicy >-----#
    id_at_privPolicy = OID(name=u'id-at-privPolicy', mode=MODE_VALUE)
    id_at_privPolicy._val = (2, 5, 4, 71)
    
    #-----< id-at-role >-----#
    id_at_role = OID(name=u'id-at-role', mode=MODE_VALUE)
    id_at_role._val = (2, 5, 4, 72)
    
    #-----< id-at-delegationPath >-----#
    id_at_delegationPath = OID(name=u'id-at-delegationPath', mode=MODE_VALUE)
    id_at_delegationPath._val = (2, 5, 4, 73)
    
    #-----< id-at-protPrivPolicy >-----#
    id_at_protPrivPolicy = OID(name=u'id-at-protPrivPolicy', mode=MODE_VALUE)
    id_at_protPrivPolicy._val = (2, 5, 4, 74)
    
    #-----< id-at-xMLPrivilegeInfo >-----#
    id_at_xMLPrivilegeInfo = OID(name=u'id-at-xMLPrivilegeInfo', mode=MODE_VALUE)
    id_at_xMLPrivilegeInfo._val = (2, 5, 4, 75)
    
    #-----< id-at-xmlPrivPolicy >-----#
    id_at_xmlPrivPolicy = OID(name=u'id-at-xmlPrivPolicy', mode=MODE_VALUE)
    id_at_xmlPrivPolicy._val = (2, 5, 4, 76)
    
    #-----< id-at-permission >-----#
    id_at_permission = OID(name=u'id-at-permission', mode=MODE_VALUE)
    id_at_permission._val = (2, 5, 4, 82)
    
    #-----< id-at-eeAttrCertificateRevocationList >-----#
    id_at_eeAttrCertificateRevocationList = OID(name=u'id-at-eeAttrCertificateRevocationList', mode=MODE_VALUE)
    id_at_eeAttrCertificateRevocationList._val = (2, 5, 4, 102)
    
    #-----< id-ce-authorityAttributeIdentifier >-----#
    id_ce_authorityAttributeIdentifier = OID(name=u'id-ce-authorityAttributeIdentifier', mode=MODE_VALUE)
    id_ce_authorityAttributeIdentifier._val = (2, 5, 29, 38)
    
    #-----< id-ce-roleSpecCertIdentifier >-----#
    id_ce_roleSpecCertIdentifier = OID(name=u'id-ce-roleSpecCertIdentifier', mode=MODE_VALUE)
    id_ce_roleSpecCertIdentifier._val = (2, 5, 29, 39)
    
    #-----< id-ce-basicAttConstraints >-----#
    id_ce_basicAttConstraints = OID(name=u'id-ce-basicAttConstraints', mode=MODE_VALUE)
    id_ce_basicAttConstraints._val = (2, 5, 29, 41)
    
    #-----< id-ce-delegatedNameConstraints >-----#
    id_ce_delegatedNameConstraints = OID(name=u'id-ce-delegatedNameConstraints', mode=MODE_VALUE)
    id_ce_delegatedNameConstraints._val = (2, 5, 29, 42)
    
    #-----< id-ce-timeSpecification >-----#
    id_ce_timeSpecification = OID(name=u'id-ce-timeSpecification', mode=MODE_VALUE)
    id_ce_timeSpecification._val = (2, 5, 29, 43)
    
    #-----< id-ce-attributeDescriptor >-----#
    id_ce_attributeDescriptor = OID(name=u'id-ce-attributeDescriptor', mode=MODE_VALUE)
    id_ce_attributeDescriptor._val = (2, 5, 29, 48)
    
    #-----< id-ce-userNotice >-----#
    id_ce_userNotice = OID(name=u'id-ce-userNotice', mode=MODE_VALUE)
    id_ce_userNotice._val = (2, 5, 29, 49)
    
    #-----< id-ce-sOAIdentifier >-----#
    id_ce_sOAIdentifier = OID(name=u'id-ce-sOAIdentifier', mode=MODE_VALUE)
    id_ce_sOAIdentifier._val = (2, 5, 29, 50)
    
    #-----< id-ce-acceptableCertPolicies >-----#
    id_ce_acceptableCertPolicies = OID(name=u'id-ce-acceptableCertPolicies', mode=MODE_VALUE)
    id_ce_acceptableCertPolicies._val = (2, 5, 29, 52)
    
    #-----< id-ce-targetingInformation >-----#
    id_ce_targetingInformation = OID(name=u'id-ce-targetingInformation', mode=MODE_VALUE)
    id_ce_targetingInformation._val = (2, 5, 29, 55)
    
    #-----< id-ce-noRevAvail >-----#
    id_ce_noRevAvail = OID(name=u'id-ce-noRevAvail', mode=MODE_VALUE)
    id_ce_noRevAvail._val = (2, 5, 29, 56)
    
    #-----< id-ce-acceptablePrivilegePolicies >-----#
    id_ce_acceptablePrivilegePolicies = OID(name=u'id-ce-acceptablePrivilegePolicies', mode=MODE_VALUE)
    id_ce_acceptablePrivilegePolicies._val = (2, 5, 29, 57)
    
    #-----< id-ce-indirectIssuer >-----#
    id_ce_indirectIssuer = OID(name=u'id-ce-indirectIssuer', mode=MODE_VALUE)
    id_ce_indirectIssuer._val = (2, 5, 29, 61)
    
    #-----< id-ce-noAssertion >-----#
    id_ce_noAssertion = OID(name=u'id-ce-noAssertion', mode=MODE_VALUE)
    id_ce_noAssertion._val = (2, 5, 29, 62)
    
    #-----< id-ce-issuedOnBehalfOf >-----#
    id_ce_issuedOnBehalfOf = OID(name=u'id-ce-issuedOnBehalfOf', mode=MODE_VALUE)
    id_ce_issuedOnBehalfOf._val = (2, 5, 29, 64)
    
    #-----< id-ce-singleUse >-----#
    id_ce_singleUse = OID(name=u'id-ce-singleUse', mode=MODE_VALUE)
    id_ce_singleUse._val = (2, 5, 29, 65)
    
    #-----< id-ce-groupAC >-----#
    id_ce_groupAC = OID(name=u'id-ce-groupAC', mode=MODE_VALUE)
    id_ce_groupAC._val = (2, 5, 29, 66)
    
    #-----< id-ce-allowedAttributeAssignments >-----#
    id_ce_allowedAttributeAssignments = OID(name=u'id-ce-allowedAttributeAssignments', mode=MODE_VALUE)
    id_ce_allowedAttributeAssignments._val = (2, 5, 29, 67)
    
    #-----< id-ce-attributeMappings >-----#
    id_ce_attributeMappings = OID(name=u'id-ce-attributeMappings', mode=MODE_VALUE)
    id_ce_attributeMappings._val = (2, 5, 29, 68)
    
    #-----< id-ce-holderNameConstraints >-----#
    id_ce_holderNameConstraints = OID(name=u'id-ce-holderNameConstraints', mode=MODE_VALUE)
    id_ce_holderNameConstraints._val = (2, 5, 29, 69)
    
    #-----< id-mr-attributeCertificateMatch >-----#
    id_mr_attributeCertificateMatch = OID(name=u'id-mr-attributeCertificateMatch', mode=MODE_VALUE)
    id_mr_attributeCertificateMatch._val = (2, 5, 13, 42)
    
    #-----< id-mr-attributeCertificateExactMatch >-----#
    id_mr_attributeCertificateExactMatch = OID(name=u'id-mr-attributeCertificateExactMatch', mode=MODE_VALUE)
    id_mr_attributeCertificateExactMatch._val = (2, 5, 13, 45)
    
    #-----< id-mr-holderIssuerMatch >-----#
    id_mr_holderIssuerMatch = OID(name=u'id-mr-holderIssuerMatch', mode=MODE_VALUE)
    id_mr_holderIssuerMatch._val = (2, 5, 13, 46)
    
    #-----< id-mr-authAttIdMatch >-----#
    id_mr_authAttIdMatch = OID(name=u'id-mr-authAttIdMatch', mode=MODE_VALUE)
    id_mr_authAttIdMatch._val = (2, 5, 13, 53)
    
    #-----< id-mr-roleSpecCertIdMatch >-----#
    id_mr_roleSpecCertIdMatch = OID(name=u'id-mr-roleSpecCertIdMatch', mode=MODE_VALUE)
    id_mr_roleSpecCertIdMatch._val = (2, 5, 13, 54)
    
    #-----< id-mr-basicAttConstraintsMatch >-----#
    id_mr_basicAttConstraintsMatch = OID(name=u'id-mr-basicAttConstraintsMatch', mode=MODE_VALUE)
    id_mr_basicAttConstraintsMatch._val = (2, 5, 13, 55)
    
    #-----< id-mr-delegatedNameConstraintsMatch >-----#
    id_mr_delegatedNameConstraintsMatch = OID(name=u'id-mr-delegatedNameConstraintsMatch', mode=MODE_VALUE)
    id_mr_delegatedNameConstraintsMatch._val = (2, 5, 13, 56)
    
    #-----< id-mr-timeSpecMatch >-----#
    id_mr_timeSpecMatch = OID(name=u'id-mr-timeSpecMatch', mode=MODE_VALUE)
    id_mr_timeSpecMatch._val = (2, 5, 13, 57)
    
    #-----< id-mr-attDescriptorMatch >-----#
    id_mr_attDescriptorMatch = OID(name=u'id-mr-attDescriptorMatch', mode=MODE_VALUE)
    id_mr_attDescriptorMatch._val = (2, 5, 13, 58)
    
    #-----< id-mr-acceptableCertPoliciesMatch >-----#
    id_mr_acceptableCertPoliciesMatch = OID(name=u'id-mr-acceptableCertPoliciesMatch', mode=MODE_VALUE)
    id_mr_acceptableCertPoliciesMatch._val = (2, 5, 13, 59)
    
    #-----< id-mr-delegationPathMatch >-----#
    id_mr_delegationPathMatch = OID(name=u'id-mr-delegationPathMatch', mode=MODE_VALUE)
    id_mr_delegationPathMatch._val = (2, 5, 13, 61)
    
    #-----< id-mr-sOAIdentifierMatch >-----#
    id_mr_sOAIdentifierMatch = OID(name=u'id-mr-sOAIdentifierMatch', mode=MODE_VALUE)
    id_mr_sOAIdentifierMatch._val = (2, 5, 13, 66)
    
    #-----< id-mr-extensionPresenceMatch >-----#
    id_mr_extensionPresenceMatch = OID(name=u'id-mr-extensionPresenceMatch', mode=MODE_VALUE)
    id_mr_extensionPresenceMatch._val = (2, 5, 13, 67)
    
    #-----< id-mr-dualStringMatch >-----#
    id_mr_dualStringMatch = OID(name=u'id-mr-dualStringMatch', mode=MODE_VALUE)
    id_mr_dualStringMatch._val = (2, 5, 13, 69)
    
    _all_ = [
        _AttributeCertificate_toBeSigned,
        ___AttributeCertificate_algorithmIdentifier_algorithm_tab,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_0,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_1,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_6,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_7,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_8,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_9,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_10,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_11,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_12,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_13,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_14,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_15,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_16,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_17,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_18,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_19,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_20,
        _______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        _____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_21,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_28,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_29,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_30,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Type_31,
        __AttributeCertificate_algorithmIdentifier_algorithm,
        __AttributeCertificate_algorithmIdentifier_parameters,
        _AttributeCertificate_algorithmIdentifier,
        _AttributeCertificate_signature,
        AttributeCertificate,
        _TBSAttributeCertificate_version,
        _TBSAttributeCertificate_holder,
        _TBSAttributeCertificate_issuer,
        ___TBSAttributeCertificate_signature_algorithm_tab,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_0,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_1,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_6,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_7,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_8,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_9,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_10,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_11,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_12,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_13,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_14,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_15,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_16,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_17,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_18,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_19,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_20,
        _______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm,
        _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_saltLength,
        _____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21_trailerField,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_21,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_28,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_29,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_30,
        ____TBSAttributeCertificate_signature_algorithm_tab_val_Type_31,
        __TBSAttributeCertificate_signature_algorithm,
        __TBSAttributeCertificate_signature_parameters,
        _TBSAttributeCertificate_signature,
        _TBSAttributeCertificate_serialNumber,
        _TBSAttributeCertificate_attrCertValidityPeriod,
        ____TBSAttributeCertificate_attributes__item__type_tab,
        _____TBSAttributeCertificate_attributes__item__type_tab_val_Type_0,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType,
        _____TBSAttributeCertificate_attributes__item__type_tab_val_Type_1,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0,
        ___TBSAttributeCertificate_attributes__item__type,
        ____TBSAttributeCertificate_attributes__item__values__item_,
        ___TBSAttributeCertificate_attributes__item__values,
        _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__value,
        ______TBSAttributeCertificate_attributes__item__valuesWithContext__item__contextList__item_,
        _____TBSAttributeCertificate_attributes__item__valuesWithContext__item__contextList,
        ____TBSAttributeCertificate_attributes__item__valuesWithContext__item_,
        ___TBSAttributeCertificate_attributes__item__valuesWithContext,
        __TBSAttributeCertificate_attributes__item_,
        _TBSAttributeCertificate_attributes,
        _TBSAttributeCertificate_issuerUniqueID,
        _TBSAttributeCertificate_extensions,
        TBSAttributeCertificate,
        AttCertVersion,
        _Holder_baseCertificateID,
        _Holder_entityName,
        _Holder_objectDigestInfo,
        Holder,
        _IssuerSerial_issuer,
        _IssuerSerial_serial,
        _IssuerSerial_issuerUID,
        IssuerSerial,
        _ObjectDigestInfo_digestedObjectType,
        _ObjectDigestInfo_otherObjectTypeID,
        ___ObjectDigestInfo_digestAlgorithm_algorithm_tab,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_0,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_1,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_6,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_7,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_8,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_9,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_10,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_11,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_12,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_13,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_14,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_15,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_16,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_17,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_18,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_19,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_20,
        _______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_hashAlgorithm,
        _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_saltLength,
        _____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21_trailerField,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_21,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_28,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_29,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_30,
        ____ObjectDigestInfo_digestAlgorithm_algorithm_tab_val_Type_31,
        __ObjectDigestInfo_digestAlgorithm_algorithm,
        __ObjectDigestInfo_digestAlgorithm_parameters,
        _ObjectDigestInfo_digestAlgorithm,
        _ObjectDigestInfo_objectDigest,
        ObjectDigestInfo,
        _AttCertIssuer_issuerName,
        _AttCertIssuer_baseCertificateID,
        _AttCertIssuer_objectDigestInfo,
        AttCertIssuer,
        _AttCertValidityPeriod_notBeforeTime,
        _AttCertValidityPeriod_notAfterTime,
        AttCertValidityPeriod,
        _AttributeCertificationPath_attributeCertificate,
        __AttributeCertificationPath_acPath__item_,
        _AttributeCertificationPath_acPath,
        AttributeCertificationPath,
        _ACPathData_certificate,
        _ACPathData_attributeCertificate,
        ACPathData,
        PrivilegePolicy,
        role,
        _role_val_Type,
        _RoleSyntax_roleAuthority,
        _RoleSyntax_roleName,
        RoleSyntax,
        xmlPrivilegeInfo,
        _xmlPrivilegeInfo_val_Type,
        permission,
        _permission_val_Type,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1,
        _DualStringSyntax_operation,
        _DualStringSyntax_object,
        DualStringSyntax,
        dualStringMatch,
        _dualStringMatch_val_AssertionType,
        timeSpecification,
        _timeSpecification_val_ExtnType,
        timeSpecificationMatch,
        _timeSpecificationMatch_val_AssertionType,
        targetingInformation,
        __targetingInformation_val_ExtnType__item_,
        _targetingInformation_val_ExtnType,
        _Targets__item_,
        Targets,
        _Target_targetName,
        _Target_targetGroup,
        _Target_targetCert,
        Target,
        _TargetCert_targetCertificate,
        _TargetCert_targetName,
        _TargetCert_certDigestInfo,
        TargetCert,
        userNotice,
        __userNotice_val_ExtnType__item_,
        _userNotice_val_ExtnType,
        acceptablePrivilegePolicies,
        _acceptablePrivilegePolicies_val_ExtnType,
        _AcceptablePrivilegePoliciesSyntax__item_,
        AcceptablePrivilegePoliciesSyntax,
        singleUse,
        _singleUse_val_ExtnType,
        groupAC,
        _groupAC_val_ExtnType,
        noRevAvail,
        _noRevAvail_val_ExtnType,
        sOAIdentifier,
        _sOAIdentifier_val_ExtnType,
        sOAIdentifierMatch,
        _sOAIdentifierMatch_val_AssertionType,
        attributeDescriptor,
        _attributeDescriptor_val_ExtnType,
        _AttributeDescriptorSyntax_identifier,
        _AttributeDescriptorSyntax_attributeSyntax,
        _AttributeDescriptorSyntax_name,
        _AttributeDescriptorSyntax_description,
        _AttributeDescriptorSyntax_dominationRule,
        AttributeDescriptorSyntax,
        _AttributeIdentifier_tab,
        AttributeIdentifier,
        AttributeIDs,
        AttributeName,
        AttributeDescription,
        _PrivilegePolicyIdentifier_privilegePolicy,
        _PrivilegePolicyIdentifier_privPolSyntax,
        PrivilegePolicyIdentifier,
        attDescriptor,
        _attDescriptor_val_AssertionType,
        roleSpecCertIdentifier,
        _roleSpecCertIdentifier_val_ExtnType,
        _RoleSpecCertIdentifierSyntax__item_,
        RoleSpecCertIdentifierSyntax,
        _RoleSpecCertIdentifier_roleName,
        _RoleSpecCertIdentifier_roleCertIssuer,
        _RoleSpecCertIdentifier_roleCertSerialNumber,
        _RoleSpecCertIdentifier_roleCertLocator,
        RoleSpecCertIdentifier,
        roleSpecCertIdMatch,
        _roleSpecCertIdMatch_val_AssertionType,
        basicAttConstraints,
        _basicAttConstraints_val_ExtnType,
        _BasicAttConstraintsSyntax_authority,
        _BasicAttConstraintsSyntax_pathLenConstraint,
        BasicAttConstraintsSyntax,
        basicAttConstraintsMatch,
        _basicAttConstraintsMatch_val_AssertionType,
        delegatedNameConstraints,
        _delegatedNameConstraints_val_ExtnType,
        delegatedNameConstraintsMatch,
        _delegatedNameConstraintsMatch_val_AssertionType,
        acceptableCertPolicies,
        _acceptableCertPolicies_val_ExtnType,
        _AcceptableCertPoliciesSyntax__item_,
        AcceptableCertPoliciesSyntax,
        CertPolicyId,
        acceptableCertPoliciesMatch,
        _acceptableCertPoliciesMatch_val_AssertionType,
        authorityAttributeIdentifier,
        _authorityAttributeIdentifier_val_ExtnType,
        _AuthorityAttributeIdentifierSyntax__item_,
        AuthorityAttributeIdentifierSyntax,
        AuthAttId,
        authAttIdMatch,
        _authAttIdMatch_val_AssertionType,
        indirectIssuer,
        _indirectIssuer_val_ExtnType,
        issuedOnBehalfOf,
        _issuedOnBehalfOf_val_ExtnType,
        noAssertion,
        _noAssertion_val_ExtnType,
        allowedAttributeAssignments,
        _allowedAttributeAssignments_val_ExtnType,
        ____AllowedAttributeAssignments__item__attributes__item__attributeType,
        ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab,
        _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_0,
        _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_1,
        _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type,
        ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_,
        _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values,
        _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value,
        ________AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList__item_,
        _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList,
        ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_,
        _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext,
        ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues,
        ___AllowedAttributeAssignments__item__attributes__item_,
        __AllowedAttributeAssignments__item__attributes,
        __AllowedAttributeAssignments__item__holderDomain,
        _AllowedAttributeAssignments__item_,
        AllowedAttributeAssignments,
        attributeMappings,
        _attributeMappings_val_ExtnType,
        ___AttributeMappings__item__typeMappings_local,
        ___AttributeMappings__item__typeMappings_remote,
        __AttributeMappings__item__typeMappings,
        ___AttributeMappings__item__typeValueMappings_local,
        ___AttributeMappings__item__typeValueMappings_remote,
        __AttributeMappings__item__typeValueMappings,
        _AttributeMappings__item_,
        AttributeMappings,
        holderNameConstraints,
        _holderNameConstraints_val_ExtnType,
        _HolderNameConstraintsSyntax_permittedSubtrees,
        _HolderNameConstraintsSyntax_excludedSubtrees,
        HolderNameConstraintsSyntax,
        _GeneralSubtrees__item_,
        GeneralSubtrees,
        _GeneralSubtree_base,
        _GeneralSubtree_minimum,
        _GeneralSubtree_maximum,
        GeneralSubtree,
        BaseDistance,
        pmiUser,
        ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0,
        __pmiUser_OptionalAttributes_val_Type_0,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2,
        pmiAA,
        __pmiUser_OptionalAttributes_val_Type_1,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3,
        __pmiUser_OptionalAttributes_val_Type_2,
        pmiSOA,
        __pmiUser_OptionalAttributes_val_Type_0_0,
        __pmiUser_OptionalAttributes_val_Type_2_0,
        attCertCRLDistributionPt,
        pmiDelegationPath,
        __pmiUser_OptionalAttributes_val_Type_0_1,
        privilegePolicy,
        __pmiUser_OptionalAttributes_val_Type_0_2,
        protectedPrivilegePolicy,
        attributeCertificateAttribute,
        _attributeCertificateAttribute_val_Type,
        aACertificate,
        _aACertificate_val_Type,
        attributeDescriptorCertificate,
        _attributeDescriptorCertificate_val_Type,
        attributeCertificateRevocationList,
        _attributeCertificateRevocationList_val_Type,
        eeAttrCertificateRevocationList,
        _eeAttrCertificateRevocationList_val_Type,
        attributeAuthorityRevocationList,
        _attributeAuthorityRevocationList_val_Type,
        delegationPath,
        _delegationPath_val_Type,
        _AttCertPath__item_,
        AttCertPath,
        privPolicy,
        _privPolicy_val_Type,
        protPrivPolicy,
        _protPrivPolicy_val_Type,
        xmlPrivPolicy,
        _xmlPrivPolicy_val_Type,
        attributeCertificateExactMatch,
        _attributeCertificateExactMatch_val_AssertionType,
        _AttributeCertificateExactAssertion_serialNumber,
        _AttributeCertificateExactAssertion_issuer,
        AttributeCertificateExactAssertion,
        attributeCertificateMatch,
        _attributeCertificateMatch_val_AssertionType,
        __AttributeCertificateAssertion_holder_baseCertificateID,
        __AttributeCertificateAssertion_holder_holderName,
        _AttributeCertificateAssertion_holder,
        _AttributeCertificateAssertion_issuer,
        _AttributeCertificateAssertion_attCertValidity,
        __AttributeCertificateAssertion_attType__item_,
        _AttributeCertificateAssertion_attType,
        AttributeCertificateAssertion,
        holderIssuerMatch,
        _holderIssuerMatch_val_AssertionType,
        _HolderIssuerAssertion_holder,
        _HolderIssuerAssertion_issuer,
        HolderIssuerAssertion,
        delegationPathMatch,
        _delegationPathMatch_val_AssertionType,
        _DelMatchSyntax_firstIssuer,
        _DelMatchSyntax_lastHolder,
        DelMatchSyntax,
        extensionPresenceMatch,
        _extensionPresenceMatch_val_AssertionType,
        id_oc_pmiUser,
        id_oc_pmiAA,
        id_oc_pmiSOA,
        id_oc_attCertCRLDistributionPts,
        id_oc_privilegePolicy,
        id_oc_pmiDelegationPath,
        id_oc_protectedPrivilegePolicy,
        id_at_attributeCertificate,
        id_at_attributeCertificateRevocationList,
        id_at_aACertificate,
        id_at_attributeDescriptorCertificate,
        id_at_attributeAuthorityRevocationList,
        id_at_privPolicy,
        id_at_role,
        id_at_delegationPath,
        id_at_protPrivPolicy,
        id_at_xMLPrivilegeInfo,
        id_at_xmlPrivPolicy,
        id_at_permission,
        id_at_eeAttrCertificateRevocationList,
        id_ce_authorityAttributeIdentifier,
        id_ce_roleSpecCertIdentifier,
        id_ce_basicAttConstraints,
        id_ce_delegatedNameConstraints,
        id_ce_timeSpecification,
        id_ce_attributeDescriptor,
        id_ce_userNotice,
        id_ce_sOAIdentifier,
        id_ce_acceptableCertPolicies,
        id_ce_targetingInformation,
        id_ce_noRevAvail,
        id_ce_acceptablePrivilegePolicies,
        id_ce_indirectIssuer,
        id_ce_noAssertion,
        id_ce_issuedOnBehalfOf,
        id_ce_singleUse,
        id_ce_groupAC,
        id_ce_allowedAttributeAssignments,
        id_ce_attributeMappings,
        id_ce_holderNameConstraints,
        id_mr_attributeCertificateMatch,
        id_mr_attributeCertificateExactMatch,
        id_mr_holderIssuerMatch,
        id_mr_authAttIdMatch,
        id_mr_roleSpecCertIdMatch,
        id_mr_basicAttConstraintsMatch,
        id_mr_delegatedNameConstraintsMatch,
        id_mr_timeSpecMatch,
        id_mr_attDescriptorMatch,
        id_mr_acceptableCertPoliciesMatch,
        id_mr_delegationPathMatch,
        id_mr_sOAIdentifierMatch,
        id_mr_extensionPresenceMatch,
        id_mr_dualStringMatch,
    ]

class AuthenticationFramework:

    _name_  = u'AuthenticationFramework'
    _oid_   = [2, 5, 1, 7, 8]
    
    _obj_ = [
        u'SIGNATURE',
        u'SIGNED',
        u'HASH',
        u'ENCRYPTED',
        u'ENCRYPTED-HASH',
        u'FINGERPRINT',
        u'ALGORITHM',
        u'AlgorithmIdentifier',
        u'SupportedAlgorithms',
        u'SupportedCurves',
        u'dummyCurv',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'SubjectPublicKeyInfo',
        u'PublicKey',
        u'Time',
        u'Extensions',
        u'Extension',
        u'der',
        u'ExtensionSet',
        u'EXTENSION',
        u'Certificates',
        u'ForwardCertificationPath',
        u'CrossCertificates',
        u'CertificationPath',
        u'PkiPath',
        u'CertificateList',
        u'CertificateListContent',
        u'CertAVL',
        u'TBSCertAVL',
        u'AvlSerialNumber',
        u'PKCertIdentifier',
        u'IssuerSerialNumber',
        u'ScopeRestrictions',
        u'SCOPE-RESTRICTION',
        u'ScopeRestriction',
        u'protRestrict',
        u'ProtRestriction',
        u'pkiUser',
        u'pkiCA',
        u'cRLDistributionPoint',
        u'cRLDistPtNameForm',
        u'deltaCRL',
        u'cpCps',
        u'pkiCertPath',
        u'userCertificate',
        u'cACertificate',
        u'crossCertificatePair',
        u'CertificatePair',
        u'certificateRevocationList',
        u'eepkCertificateRevocationList',
        u'authorityRevocationList',
        u'deltaRevocationList',
        u'supportedAlgorithms',
        u'SupportedAlgorithm',
        u'certificationPracticeStmt',
        u'InfoSyntax',
        u'POLICY',
        u'HashedPolicyInfo',
        u'Policies',
        u'certificatePolicy',
        u'PolicySyntax',
        u'PolicyID',
        u'pkiPath',
        u'userPassword',
        u'x509Certificate',
        u'x509CertificateList',
        u'x509CertificatePair',
        u'x509SupportedAlgorithm',
        u'id-oc-cRLDistributionPoint',
        u'id-oc-pkiUser',
        u'id-oc-pkiCA',
        u'id-oc-deltaCRL',
        u'id-oc-cpCps',
        u'id-oc-pkiCertPath',
        u'id-nf-cRLDistPtNameForm',
        u'id-at-userPassword',
        u'id-at-userCertificate',
        u'id-at-cAcertificate',
        u'id-at-authorityRevocationList',
        u'id-at-certificateRevocationList',
        u'id-at-crossCertificatePair',
        u'id-at-supportedAlgorithms',
        u'id-at-deltaRevocationList',
        u'id-at-certificationPracticeStmt',
        u'id-at-certificatePolicy',
        u'id-at-pkiPath',
        u'id-at-eepkCertificateRevocationList',
        u'id-lsx-x509Certificate',
        u'id-lsx-x509CertificateList',
        u'id-lsx-x509CertificatePair',
        u'id-lsx-x509SupportedAlgorithm',
        u'id-protRestrict',
        ]
    _type_ = [
        u'SIGNATURE',
        u'SIGNED',
        u'HASH',
        u'ENCRYPTED',
        u'ENCRYPTED-HASH',
        u'FINGERPRINT',
        u'ALGORITHM',
        u'AlgorithmIdentifier',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'SubjectPublicKeyInfo',
        u'PublicKey',
        u'Time',
        u'Extensions',
        u'Extension',
        u'EXTENSION',
        u'Certificates',
        u'ForwardCertificationPath',
        u'CrossCertificates',
        u'CertificationPath',
        u'PkiPath',
        u'CertificateList',
        u'CertificateListContent',
        u'CertAVL',
        u'TBSCertAVL',
        u'AvlSerialNumber',
        u'PKCertIdentifier',
        u'IssuerSerialNumber',
        u'ScopeRestrictions',
        u'SCOPE-RESTRICTION',
        u'ScopeRestriction',
        u'ProtRestriction',
        u'CertificatePair',
        u'SupportedAlgorithm',
        u'InfoSyntax',
        u'POLICY',
        u'HashedPolicyInfo',
        u'PolicySyntax',
        u'PolicyID',
        ]
    _set_ = [
        u'SupportedAlgorithms',
        u'SupportedCurves',
        u'ExtensionSet',
        u'Policies',
        ]
    _val_ = [
        u'dummyCurv',
        u'der',
        u'protRestrict',
        u'pkiUser',
        u'pkiCA',
        u'cRLDistributionPoint',
        u'cRLDistPtNameForm',
        u'deltaCRL',
        u'cpCps',
        u'pkiCertPath',
        u'userCertificate',
        u'cACertificate',
        u'crossCertificatePair',
        u'certificateRevocationList',
        u'eepkCertificateRevocationList',
        u'authorityRevocationList',
        u'deltaRevocationList',
        u'supportedAlgorithms',
        u'certificationPracticeStmt',
        u'certificatePolicy',
        u'pkiPath',
        u'userPassword',
        u'x509Certificate',
        u'x509CertificateList',
        u'x509CertificatePair',
        u'x509SupportedAlgorithm',
        u'id-oc-cRLDistributionPoint',
        u'id-oc-pkiUser',
        u'id-oc-pkiCA',
        u'id-oc-deltaCRL',
        u'id-oc-cpCps',
        u'id-oc-pkiCertPath',
        u'id-nf-cRLDistPtNameForm',
        u'id-at-userPassword',
        u'id-at-userCertificate',
        u'id-at-cAcertificate',
        u'id-at-authorityRevocationList',
        u'id-at-certificateRevocationList',
        u'id-at-crossCertificatePair',
        u'id-at-supportedAlgorithms',
        u'id-at-deltaRevocationList',
        u'id-at-certificationPracticeStmt',
        u'id-at-certificatePolicy',
        u'id-at-pkiPath',
        u'id-at-eepkCertificateRevocationList',
        u'id-lsx-x509Certificate',
        u'id-lsx-x509CertificateList',
        u'id-lsx-x509CertificatePair',
        u'id-lsx-x509SupportedAlgorithm',
        u'id-protRestrict',
        ]
    _class_ = [
        u'ALGORITHM',
        u'SupportedAlgorithms',
        u'ExtensionSet',
        u'EXTENSION',
        u'SCOPE-RESTRICTION',
        u'protRestrict',
        u'pkiUser',
        u'pkiCA',
        u'cRLDistributionPoint',
        u'cRLDistPtNameForm',
        u'deltaCRL',
        u'cpCps',
        u'pkiCertPath',
        u'userCertificate',
        u'cACertificate',
        u'crossCertificatePair',
        u'certificateRevocationList',
        u'eepkCertificateRevocationList',
        u'authorityRevocationList',
        u'deltaRevocationList',
        u'supportedAlgorithms',
        u'certificationPracticeStmt',
        u'POLICY',
        u'Policies',
        u'certificatePolicy',
        u'pkiPath',
        u'userPassword',
        u'x509Certificate',
        u'x509CertificateList',
        u'x509CertificatePair',
        u'x509SupportedAlgorithm',
        ]
    _param_ = [
        u'SIGNED',
        u'HASH',
        u'ENCRYPTED',
        u'ENCRYPTED-HASH',
        u'FINGERPRINT',
        u'AlgorithmIdentifier',
        ]
    
    #-----< SIGNATURE >-----#
    SIGNATURE = SEQ(name=u'SIGNATURE', mode=MODE_TYPE)
    _SIGNATURE_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __SIGNATURE_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___SIGNATURE_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___SIGNATURE_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __SIGNATURE_algorithmIdentifier_algorithm._const_tab = ___SIGNATURE_algorithmIdentifier_algorithm_tab
    __SIGNATURE_algorithmIdentifier_algorithm._const_tab_at = None
    __SIGNATURE_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __SIGNATURE_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __SIGNATURE_algorithmIdentifier_parameters._const_tab = ___SIGNATURE_algorithmIdentifier_algorithm_tab
    __SIGNATURE_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __SIGNATURE_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _SIGNATURE_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __SIGNATURE_algorithmIdentifier_algorithm),
        (u'parameters', __SIGNATURE_algorithmIdentifier_parameters),
        ])
    _SIGNATURE_algorithmIdentifier._ext = []
    _SIGNATURE_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    SIGNATURE._cont = ASN1Dict([
        (u'algorithmIdentifier', _SIGNATURE_algorithmIdentifier),
        (u'signature', _SIGNATURE_signature),
        ])
    SIGNATURE._ext = []
    
    #-----< SIGNED >-----#
    SIGNED = SEQ(name=u'SIGNED', mode=MODE_TYPE, param=True)
    
    #-----< HASH >-----#
    HASH = SEQ(name=u'HASH', mode=MODE_TYPE)
    _HASH_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __HASH_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___HASH_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____HASH_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___HASH_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____HASH_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __HASH_algorithmIdentifier_algorithm._const_tab = ___HASH_algorithmIdentifier_algorithm_tab
    __HASH_algorithmIdentifier_algorithm._const_tab_at = None
    __HASH_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __HASH_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __HASH_algorithmIdentifier_parameters._const_tab = ___HASH_algorithmIdentifier_algorithm_tab
    __HASH_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __HASH_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _HASH_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __HASH_algorithmIdentifier_algorithm),
        (u'parameters', __HASH_algorithmIdentifier_parameters),
        ])
    _HASH_algorithmIdentifier._ext = []
    _HASH_hashValue = BIT_STR(name=u'hashValue', mode=MODE_TYPE)
    HASH._cont = ASN1Dict([
        (u'algorithmIdentifier', _HASH_algorithmIdentifier),
        (u'hashValue', _HASH_hashValue),
        ])
    HASH._ext = []
    
    #-----< ENCRYPTED >-----#
    ENCRYPTED = BIT_STR(name=u'ENCRYPTED', mode=MODE_TYPE)
    
    #-----< ENCRYPTED-HASH >-----#
    ENCRYPTED_HASH = BIT_STR(name=u'ENCRYPTED-HASH', mode=MODE_TYPE)
    
    #-----< FINGERPRINT >-----#
    FINGERPRINT = SEQ(name=u'FINGERPRINT', mode=MODE_TYPE)
    _FINGERPRINT_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __FINGERPRINT_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___FINGERPRINT_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___FINGERPRINT_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __FINGERPRINT_algorithmIdentifier_algorithm._const_tab = ___FINGERPRINT_algorithmIdentifier_algorithm_tab
    __FINGERPRINT_algorithmIdentifier_algorithm._const_tab_at = None
    __FINGERPRINT_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __FINGERPRINT_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __FINGERPRINT_algorithmIdentifier_parameters._const_tab = ___FINGERPRINT_algorithmIdentifier_algorithm_tab
    __FINGERPRINT_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __FINGERPRINT_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _FINGERPRINT_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __FINGERPRINT_algorithmIdentifier_algorithm),
        (u'parameters', __FINGERPRINT_algorithmIdentifier_parameters),
        ])
    _FINGERPRINT_algorithmIdentifier._ext = []
    _FINGERPRINT_fingerprint = BIT_STR(name=u'fingerprint', mode=MODE_TYPE)
    FINGERPRINT._cont = ASN1Dict([
        (u'algorithmIdentifier', _FINGERPRINT_algorithmIdentifier),
        (u'fingerprint', _FINGERPRINT_fingerprint),
        ])
    FINGERPRINT._ext = []
    
    #-----< ALGORITHM >-----#
    ALGORITHM = CLASS(name=u'ALGORITHM', mode=MODE_TYPE)
    _ALGORITHM_Type = OPEN(name=u'Type', mode=MODE_TYPE, opt=True)
    _ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    ALGORITHM._cont = ASN1Dict([
        (u'Type', _ALGORITHM_Type),
        (u'id', _ALGORITHM_id),
        ])
    
    #-----< AlgorithmIdentifier >-----#
    AlgorithmIdentifier = SEQ(name=u'AlgorithmIdentifier', mode=MODE_TYPE, param=True)
    
    #-----< SupportedAlgorithms >-----#
    SupportedAlgorithms = CLASS(name=u'SupportedAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _SupportedAlgorithms_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _SupportedAlgorithms_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _SupportedAlgorithms_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _SupportedAlgorithms_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _SupportedAlgorithms_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _SupportedAlgorithms_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _SupportedAlgorithms_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _SupportedAlgorithms_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _SupportedAlgorithms_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _SupportedAlgorithms_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    __SupportedAlgorithms_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _____SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ___SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm._const_tab = ____SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm_tab
    ___SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ___SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ___SupportedAlgorithms_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___SupportedAlgorithms_val_Type_21_hashAlgorithm_parameters._const_tab = ____SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm_tab
    ___SupportedAlgorithms_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ___SupportedAlgorithms_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    __SupportedAlgorithms_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ___SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ___SupportedAlgorithms_val_Type_21_hashAlgorithm_parameters),
        ])
    __SupportedAlgorithms_val_Type_21_hashAlgorithm._ext = []
    __SupportedAlgorithms_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    __SupportedAlgorithms_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _SupportedAlgorithms_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', __SupportedAlgorithms_val_Type_21_hashAlgorithm),
        (u'saltLength', __SupportedAlgorithms_val_Type_21_saltLength),
        (u'trailerField', __SupportedAlgorithms_val_Type_21_trailerField),
        ])
    _SupportedAlgorithms_val_Type_21._ext = None
    _SupportedAlgorithms_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _SupportedAlgorithms_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    SupportedAlgorithms._val = ASN1Set(rv=[dict([(u'Type', _SupportedAlgorithms_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _SupportedAlgorithms_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _SupportedAlgorithms_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _SupportedAlgorithms_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _SupportedAlgorithms_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _SupportedAlgorithms_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _SupportedAlgorithms_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _SupportedAlgorithms_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _SupportedAlgorithms_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _SupportedAlgorithms_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _SupportedAlgorithms_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _SupportedAlgorithms_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _SupportedAlgorithms_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _SupportedAlgorithms_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _SupportedAlgorithms_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _SupportedAlgorithms_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _SupportedAlgorithms_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _SupportedAlgorithms_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _SupportedAlgorithms_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _SupportedAlgorithms_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _SupportedAlgorithms_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _SupportedAlgorithms_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=[], er=[])
    
    #-----< SupportedCurves >-----#
    SupportedCurves = OID(name=u'SupportedCurves', mode=MODE_SET)
    SupportedCurves._val = ASN1Set(rv=[(2, 5, 5)], rr=[], ev=[], er=[])
    
    #-----< dummyCurv >-----#
    dummyCurv = OID(name=u'dummyCurv', mode=MODE_VALUE)
    dummyCurv._val = (2, 5, 5)
    
    #-----< Certificate >-----#
    Certificate = SEQ(name=u'Certificate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    _Certificate_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'TBSCertificate')))
    _Certificate_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __Certificate_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___Certificate_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___Certificate_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __Certificate_algorithmIdentifier_algorithm._const_tab = ___Certificate_algorithmIdentifier_algorithm_tab
    __Certificate_algorithmIdentifier_algorithm._const_tab_at = None
    __Certificate_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __Certificate_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __Certificate_algorithmIdentifier_parameters._const_tab = ___Certificate_algorithmIdentifier_algorithm_tab
    __Certificate_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __Certificate_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _Certificate_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __Certificate_algorithmIdentifier_algorithm),
        (u'parameters', __Certificate_algorithmIdentifier_parameters),
        ])
    _Certificate_algorithmIdentifier._ext = []
    _Certificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    Certificate._cont = ASN1Dict([
        (u'toBeSigned', _Certificate_toBeSigned),
        (u'algorithmIdentifier', _Certificate_algorithmIdentifier),
        (u'signature', _Certificate_signature),
        ])
    Certificate._ext = []
    
    #-----< TBSCertificate >-----#
    TBSCertificate = SEQ(name=u'TBSCertificate', mode=MODE_TYPE)
    _TBSCertificate_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Version')), default=0)
    _TBSCertificate_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _TBSCertificate_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __TBSCertificate_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___TBSCertificate_signature_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____TBSCertificate_signature_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____TBSCertificate_signature_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____TBSCertificate_signature_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____TBSCertificate_signature_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____TBSCertificate_signature_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____TBSCertificate_signature_algorithm_tab_val_Type_21_trailerField),
        ])
    ____TBSCertificate_signature_algorithm_tab_val_Type_21._ext = None
    ____TBSCertificate_signature_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___TBSCertificate_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____TBSCertificate_signature_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __TBSCertificate_signature_algorithm._const_tab = ___TBSCertificate_signature_algorithm_tab
    __TBSCertificate_signature_algorithm._const_tab_at = None
    __TBSCertificate_signature_algorithm._const_tab_id = u'id'
    __TBSCertificate_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __TBSCertificate_signature_parameters._const_tab = ___TBSCertificate_signature_algorithm_tab
    __TBSCertificate_signature_parameters._const_tab_at = ('..', u'algorithm')
    __TBSCertificate_signature_parameters._const_tab_id = u'Type'
    _TBSCertificate_signature._cont = ASN1Dict([
        (u'algorithm', __TBSCertificate_signature_algorithm),
        (u'parameters', __TBSCertificate_signature_parameters),
        ])
    _TBSCertificate_signature._ext = []
    _TBSCertificate_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _TBSCertificate_validity = SEQ(name=u'validity', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Validity')))
    _TBSCertificate_subject = CHOICE(name=u'subject', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _TBSCertificate_subjectPublicKeyInfo = SEQ(name=u'subjectPublicKeyInfo', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SubjectPublicKeyInfo')))
    _TBSCertificate_issuerUniqueIdentifier = BIT_STR(name=u'issuerUniqueIdentifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UniqueIdentifier')), opt=True)
    _TBSCertificate_subjectUniqueIdentifier = BIT_STR(name=u'subjectUniqueIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UniqueIdentifier')), opt=True, group=0)
    _TBSCertificate_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True, group=1)
    TBSCertificate._cont = ASN1Dict([
        (u'version', _TBSCertificate_version),
        (u'serialNumber', _TBSCertificate_serialNumber),
        (u'signature', _TBSCertificate_signature),
        (u'issuer', _TBSCertificate_issuer),
        (u'validity', _TBSCertificate_validity),
        (u'subject', _TBSCertificate_subject),
        (u'subjectPublicKeyInfo', _TBSCertificate_subjectPublicKeyInfo),
        (u'issuerUniqueIdentifier', _TBSCertificate_issuerUniqueIdentifier),
        (u'subjectUniqueIdentifier', _TBSCertificate_subjectUniqueIdentifier),
        (u'extensions', _TBSCertificate_extensions),
        ])
    TBSCertificate._ext = [u'subjectUniqueIdentifier', u'extensions']
    
    #-----< Version >-----#
    Version = INT(name=u'Version', mode=MODE_TYPE)
    Version._cont = ASN1Dict([(u'v1', 0), (u'v2', 1), (u'v3', 2)])
    
    #-----< CertificateSerialNumber >-----#
    CertificateSerialNumber = INT(name=u'CertificateSerialNumber', mode=MODE_TYPE)
    
    #-----< Validity >-----#
    Validity = SEQ(name=u'Validity', mode=MODE_TYPE)
    _Validity_notBefore = CHOICE(name=u'notBefore', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    _Validity_notAfter = CHOICE(name=u'notAfter', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    Validity._cont = ASN1Dict([
        (u'notBefore', _Validity_notBefore),
        (u'notAfter', _Validity_notAfter),
        ])
    Validity._ext = []
    
    #-----< SubjectPublicKeyInfo >-----#
    SubjectPublicKeyInfo = SEQ(name=u'SubjectPublicKeyInfo', mode=MODE_TYPE)
    _SubjectPublicKeyInfo_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __SubjectPublicKeyInfo_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___SubjectPublicKeyInfo_algorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_trailerField),
        ])
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21._ext = None
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___SubjectPublicKeyInfo_algorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab = ___SubjectPublicKeyInfo_algorithm_algorithm_tab
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab_at = None
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab_id = u'id'
    __SubjectPublicKeyInfo_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab = ___SubjectPublicKeyInfo_algorithm_algorithm_tab
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab_id = u'Type'
    _SubjectPublicKeyInfo_algorithm._cont = ASN1Dict([
        (u'algorithm', __SubjectPublicKeyInfo_algorithm_algorithm),
        (u'parameters', __SubjectPublicKeyInfo_algorithm_parameters),
        ])
    _SubjectPublicKeyInfo_algorithm._ext = []
    _SubjectPublicKeyInfo_subjectPublicKey = BIT_STR(name=u'subjectPublicKey', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PublicKey')))
    SubjectPublicKeyInfo._cont = ASN1Dict([
        (u'algorithm', _SubjectPublicKeyInfo_algorithm),
        (u'subjectPublicKey', _SubjectPublicKeyInfo_subjectPublicKey),
        ])
    SubjectPublicKeyInfo._ext = []
    
    #-----< PublicKey >-----#
    PublicKey = BIT_STR(name=u'PublicKey', mode=MODE_TYPE)
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalizedTime = TIME_GEN(name=u'generalizedTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalizedTime', _Time_generalizedTime),
        ])
    Time._ext = None
    
    #-----< Extensions >-----#
    Extensions = SEQ_OF(name=u'Extensions', mode=MODE_TYPE)
    _Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Extension')))
    Extensions._cont = _Extensions__item_
    Extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< Extension >-----#
    Extension = SEQ(name=u'Extension', mode=MODE_TYPE)
    _Extension_extnId = OID(name=u'extnId', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'EXTENSION'), [u'id']))
    __Extension_extnId_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    __Extension_extnId_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _Extension_extnId._const_tab = __Extension_extnId_tab
    _Extension_extnId._const_tab_at = None
    _Extension_extnId._const_tab_id = u'id'
    _Extension_critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    _Extension_extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    _Extension_extnValue._const_cont_enc = (2, 1, 2, 1)
    Extension._cont = ASN1Dict([
        (u'extnId', _Extension_extnId),
        (u'critical', _Extension_critical),
        (u'extnValue', _Extension_extnValue),
        ])
    Extension._ext = []
    
    #-----< der >-----#
    der = OID(name=u'der', mode=MODE_VALUE)
    der._val = (2, 1, 2, 1)
    
    #-----< ExtensionSet >-----#
    ExtensionSet = CLASS(name=u'ExtensionSet', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    ExtensionSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< EXTENSION >-----#
    EXTENSION = CLASS(name=u'EXTENSION', mode=MODE_TYPE)
    _EXTENSION_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _EXTENSION_ExtnType = OPEN(name=u'ExtnType', mode=MODE_TYPE)
    EXTENSION._cont = ASN1Dict([
        (u'id', _EXTENSION_id),
        (u'ExtnType', _EXTENSION_ExtnType),
        ])
    
    #-----< Certificates >-----#
    Certificates = SEQ(name=u'Certificates', mode=MODE_TYPE)
    _Certificates_userCertificate = SEQ(name=u'userCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    _Certificates_certificationPath = SEQ_OF(name=u'certificationPath', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ForwardCertificationPath')), opt=True)
    Certificates._cont = ASN1Dict([
        (u'userCertificate', _Certificates_userCertificate),
        (u'certificationPath', _Certificates_certificationPath),
        ])
    Certificates._ext = []
    
    #-----< ForwardCertificationPath >-----#
    ForwardCertificationPath = SEQ_OF(name=u'ForwardCertificationPath', mode=MODE_TYPE)
    _ForwardCertificationPath__item_ = SET_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CrossCertificates')))
    ForwardCertificationPath._cont = _ForwardCertificationPath__item_
    ForwardCertificationPath._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< CrossCertificates >-----#
    CrossCertificates = SET_OF(name=u'CrossCertificates', mode=MODE_TYPE)
    _CrossCertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    CrossCertificates._cont = _CrossCertificates__item_
    CrossCertificates._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< CertificationPath >-----#
    CertificationPath = SEQ(name=u'CertificationPath', mode=MODE_TYPE)
    _CertificationPath_userCertificate = SEQ(name=u'userCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    _CertificationPath_theCACertificates = SEQ_OF(name=u'theCACertificates', mode=MODE_TYPE, opt=True)
    __CertificationPath_theCACertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificatePair')))
    _CertificationPath_theCACertificates._cont = __CertificationPath_theCACertificates__item_
    _CertificationPath_theCACertificates._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    CertificationPath._cont = ASN1Dict([
        (u'userCertificate', _CertificationPath_userCertificate),
        (u'theCACertificates', _CertificationPath_theCACertificates),
        ])
    CertificationPath._ext = []
    
    #-----< PkiPath >-----#
    PkiPath = SEQ_OF(name=u'PkiPath', mode=MODE_TYPE)
    _PkiPath__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    PkiPath._cont = _PkiPath__item_
    PkiPath._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< CertificateList >-----#
    CertificateList = SEQ(name=u'CertificateList', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    _CertificateList_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateListContent')))
    _CertificateList_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __CertificateList_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___CertificateList_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___CertificateList_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __CertificateList_algorithmIdentifier_algorithm._const_tab = ___CertificateList_algorithmIdentifier_algorithm_tab
    __CertificateList_algorithmIdentifier_algorithm._const_tab_at = None
    __CertificateList_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __CertificateList_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __CertificateList_algorithmIdentifier_parameters._const_tab = ___CertificateList_algorithmIdentifier_algorithm_tab
    __CertificateList_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __CertificateList_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _CertificateList_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __CertificateList_algorithmIdentifier_algorithm),
        (u'parameters', __CertificateList_algorithmIdentifier_parameters),
        ])
    _CertificateList_algorithmIdentifier._ext = []
    _CertificateList_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    CertificateList._cont = ASN1Dict([
        (u'toBeSigned', _CertificateList_toBeSigned),
        (u'algorithmIdentifier', _CertificateList_algorithmIdentifier),
        (u'signature', _CertificateList_signature),
        ])
    CertificateList._ext = []
    
    #-----< CertificateListContent >-----#
    CertificateListContent = SEQ(name=u'CertificateListContent', mode=MODE_TYPE)
    _CertificateListContent_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Version')), opt=True)
    _CertificateListContent_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __CertificateListContent_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___CertificateListContent_signature_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____CertificateListContent_signature_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____CertificateListContent_signature_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____CertificateListContent_signature_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____CertificateListContent_signature_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____CertificateListContent_signature_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____CertificateListContent_signature_algorithm_tab_val_Type_21_trailerField),
        ])
    ____CertificateListContent_signature_algorithm_tab_val_Type_21._ext = None
    ____CertificateListContent_signature_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertificateListContent_signature_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___CertificateListContent_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____CertificateListContent_signature_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __CertificateListContent_signature_algorithm._const_tab = ___CertificateListContent_signature_algorithm_tab
    __CertificateListContent_signature_algorithm._const_tab_at = None
    __CertificateListContent_signature_algorithm._const_tab_id = u'id'
    __CertificateListContent_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __CertificateListContent_signature_parameters._const_tab = ___CertificateListContent_signature_algorithm_tab
    __CertificateListContent_signature_parameters._const_tab_at = ('..', u'algorithm')
    __CertificateListContent_signature_parameters._const_tab_id = u'Type'
    _CertificateListContent_signature._cont = ASN1Dict([
        (u'algorithm', __CertificateListContent_signature_algorithm),
        (u'parameters', __CertificateListContent_signature_parameters),
        ])
    _CertificateListContent_signature._ext = []
    _CertificateListContent_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _CertificateListContent_thisUpdate = CHOICE(name=u'thisUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    _CertificateListContent_nextUpdate = CHOICE(name=u'nextUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')), opt=True)
    _CertificateListContent_revokedCertificates = SEQ_OF(name=u'revokedCertificates', mode=MODE_TYPE, opt=True)
    __CertificateListContent_revokedCertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ___CertificateListContent_revokedCertificates__item__serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    ___CertificateListContent_revokedCertificates__item__revocationDate = CHOICE(name=u'revocationDate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    ___CertificateListContent_revokedCertificates__item__crlEntryExtensions = SEQ_OF(name=u'crlEntryExtensions', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True)
    __CertificateListContent_revokedCertificates__item_._cont = ASN1Dict([
        (u'serialNumber', ___CertificateListContent_revokedCertificates__item__serialNumber),
        (u'revocationDate', ___CertificateListContent_revokedCertificates__item__revocationDate),
        (u'crlEntryExtensions', ___CertificateListContent_revokedCertificates__item__crlEntryExtensions),
        ])
    __CertificateListContent_revokedCertificates__item_._ext = []
    _CertificateListContent_revokedCertificates._cont = __CertificateListContent_revokedCertificates__item_
    _CertificateListContent_crlExtensions = SEQ_OF(name=u'crlExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True)
    CertificateListContent._cont = ASN1Dict([
        (u'version', _CertificateListContent_version),
        (u'signature', _CertificateListContent_signature),
        (u'issuer', _CertificateListContent_issuer),
        (u'thisUpdate', _CertificateListContent_thisUpdate),
        (u'nextUpdate', _CertificateListContent_nextUpdate),
        (u'revokedCertificates', _CertificateListContent_revokedCertificates),
        (u'crlExtensions', _CertificateListContent_crlExtensions),
        ])
    CertificateListContent._ext = [u'crlExtensions']
    
    #-----< CertAVL >-----#
    CertAVL = SEQ(name=u'CertAVL', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    _CertAVL_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'TBSCertAVL')))
    _CertAVL_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __CertAVL_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___CertAVL_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___CertAVL_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __CertAVL_algorithmIdentifier_algorithm._const_tab = ___CertAVL_algorithmIdentifier_algorithm_tab
    __CertAVL_algorithmIdentifier_algorithm._const_tab_at = None
    __CertAVL_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __CertAVL_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __CertAVL_algorithmIdentifier_parameters._const_tab = ___CertAVL_algorithmIdentifier_algorithm_tab
    __CertAVL_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __CertAVL_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _CertAVL_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __CertAVL_algorithmIdentifier_algorithm),
        (u'parameters', __CertAVL_algorithmIdentifier_parameters),
        ])
    _CertAVL_algorithmIdentifier._ext = []
    _CertAVL_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    CertAVL._cont = ASN1Dict([
        (u'toBeSigned', _CertAVL_toBeSigned),
        (u'algorithmIdentifier', _CertAVL_algorithmIdentifier),
        (u'signature', _CertAVL_signature),
        ])
    CertAVL._ext = []
    
    #-----< TBSCertAVL >-----#
    TBSCertAVL = SEQ(name=u'TBSCertAVL', mode=MODE_TYPE)
    _TBSCertAVL_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Version')), default=0)
    _TBSCertAVL_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AvlSerialNumber')), opt=True)
    _TBSCertAVL_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __TBSCertAVL_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___TBSCertAVL_signature_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____TBSCertAVL_signature_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____TBSCertAVL_signature_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____TBSCertAVL_signature_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____TBSCertAVL_signature_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____TBSCertAVL_signature_algorithm_tab_val_Type_21_trailerField),
        ])
    ____TBSCertAVL_signature_algorithm_tab_val_Type_21._ext = None
    ____TBSCertAVL_signature_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TBSCertAVL_signature_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___TBSCertAVL_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____TBSCertAVL_signature_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __TBSCertAVL_signature_algorithm._const_tab = ___TBSCertAVL_signature_algorithm_tab
    __TBSCertAVL_signature_algorithm._const_tab_at = None
    __TBSCertAVL_signature_algorithm._const_tab_id = u'id'
    __TBSCertAVL_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __TBSCertAVL_signature_parameters._const_tab = ___TBSCertAVL_signature_algorithm_tab
    __TBSCertAVL_signature_parameters._const_tab_at = ('..', u'algorithm')
    __TBSCertAVL_signature_parameters._const_tab_id = u'Type'
    _TBSCertAVL_signature._cont = ASN1Dict([
        (u'algorithm', __TBSCertAVL_signature_algorithm),
        (u'parameters', __TBSCertAVL_signature_parameters),
        ])
    _TBSCertAVL_signature._ext = []
    _TBSCertAVL_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _TBSCertAVL_constrained = BOOL(name=u'constrained', mode=MODE_TYPE)
    _TBSCertAVL_entries = SEQ_OF(name=u'entries', mode=MODE_TYPE)
    __TBSCertAVL_entries__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ___TBSCertAVL_entries__item__idType = CHOICE(name=u'idType', mode=MODE_TYPE)
    ____TBSCertAVL_entries__item__idType_certIdentifier = CHOICE(name=u'certIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'PKCertIdentifier')))
    ____TBSCertAVL_entries__item__idType_entityGroup = SEQ_OF(name=u'entityGroup', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ___TBSCertAVL_entries__item__idType._cont = ASN1Dict([
        (u'certIdentifier', ____TBSCertAVL_entries__item__idType_certIdentifier),
        (u'entityGroup', ____TBSCertAVL_entries__item__idType_entityGroup),
        ])
    ___TBSCertAVL_entries__item__idType._ext = []
    ___TBSCertAVL_entries__item__scope = SEQ_OF(name=u'scope', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'ScopeRestrictions')), opt=True)
    ___TBSCertAVL_entries__item__entryExtensions = SEQ_OF(name=u'entryExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True)
    __TBSCertAVL_entries__item_._cont = ASN1Dict([
        (u'idType', ___TBSCertAVL_entries__item__idType),
        (u'scope', ___TBSCertAVL_entries__item__scope),
        (u'entryExtensions', ___TBSCertAVL_entries__item__entryExtensions),
        ])
    __TBSCertAVL_entries__item_._ext = []
    _TBSCertAVL_entries._cont = __TBSCertAVL_entries__item_
    _TBSCertAVL_entries._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _TBSCertAVL_avlExtensions = SEQ_OF(name=u'avlExtensions', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True)
    TBSCertAVL._cont = ASN1Dict([
        (u'version', _TBSCertAVL_version),
        (u'serialNumber', _TBSCertAVL_serialNumber),
        (u'signature', _TBSCertAVL_signature),
        (u'issuer', _TBSCertAVL_issuer),
        (u'constrained', _TBSCertAVL_constrained),
        (u'entries', _TBSCertAVL_entries),
        (u'avlExtensions', _TBSCertAVL_avlExtensions),
        ])
    TBSCertAVL._ext = [u'avlExtensions']
    
    #-----< AvlSerialNumber >-----#
    AvlSerialNumber = INT(name=u'AvlSerialNumber', mode=MODE_TYPE)
    AvlSerialNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< PKCertIdentifier >-----#
    PKCertIdentifier = CHOICE(name=u'PKCertIdentifier', mode=MODE_TYPE)
    _PKCertIdentifier_issuerSerialNumber = SEQ(name=u'issuerSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'IssuerSerialNumber')))
    _PKCertIdentifier_fingerprintPKC = SEQ(name=u'fingerprintPKC', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'FINGERPRINT')))
    __PKCertIdentifier_fingerprintPKC_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ________PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _________PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ________PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _________PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = ________PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = ________PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm._const_tab = ____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab
    ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm._const_tab_at = None
    ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_parameters._const_tab = ____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab
    ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __PKCertIdentifier_fingerprintPKC_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm),
        (u'parameters', ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_parameters),
        ])
    __PKCertIdentifier_fingerprintPKC_algorithmIdentifier._ext = []
    __PKCertIdentifier_fingerprintPKC_fingerprint = BIT_STR(name=u'fingerprint', mode=MODE_TYPE)
    _PKCertIdentifier_fingerprintPKC._cont = ASN1Dict([
        (u'algorithmIdentifier', __PKCertIdentifier_fingerprintPKC_algorithmIdentifier),
        (u'fingerprint', __PKCertIdentifier_fingerprintPKC_fingerprint),
        ])
    _PKCertIdentifier_fingerprintPKC._ext = []
    _PKCertIdentifier_fingerprintPK = SEQ(name=u'fingerprintPK', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'FINGERPRINT')))
    __PKCertIdentifier_fingerprintPK_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_algorithm._const_tab = ____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab
    ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_algorithm._const_tab_at = None
    ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_parameters._const_tab = ____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab
    ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __PKCertIdentifier_fingerprintPK_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_algorithm),
        (u'parameters', ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_parameters),
        ])
    __PKCertIdentifier_fingerprintPK_algorithmIdentifier._ext = []
    __PKCertIdentifier_fingerprintPK_fingerprint = BIT_STR(name=u'fingerprint', mode=MODE_TYPE)
    _PKCertIdentifier_fingerprintPK._cont = ASN1Dict([
        (u'algorithmIdentifier', __PKCertIdentifier_fingerprintPK_algorithmIdentifier),
        (u'fingerprint', __PKCertIdentifier_fingerprintPK_fingerprint),
        ])
    _PKCertIdentifier_fingerprintPK._ext = []
    PKCertIdentifier._cont = ASN1Dict([
        (u'issuerSerialNumber', _PKCertIdentifier_issuerSerialNumber),
        (u'fingerprintPKC', _PKCertIdentifier_fingerprintPKC),
        (u'fingerprintPK', _PKCertIdentifier_fingerprintPK),
        ])
    PKCertIdentifier._ext = []
    
    #-----< IssuerSerialNumber >-----#
    IssuerSerialNumber = SEQ(name=u'IssuerSerialNumber', mode=MODE_TYPE)
    _IssuerSerialNumber_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _IssuerSerialNumber_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    IssuerSerialNumber._cont = ASN1Dict([
        (u'issuer', _IssuerSerialNumber_issuer),
        (u'serialNumber', _IssuerSerialNumber_serialNumber),
        ])
    IssuerSerialNumber._ext = []
    
    #-----< ScopeRestrictions >-----#
    ScopeRestrictions = SEQ_OF(name=u'ScopeRestrictions', mode=MODE_TYPE)
    _ScopeRestrictions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ScopeRestriction')))
    ScopeRestrictions._cont = _ScopeRestrictions__item_
    
    #-----< SCOPE-RESTRICTION >-----#
    SCOPE_RESTRICTION = CLASS(name=u'SCOPE-RESTRICTION', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< ScopeRestriction >-----#
    ScopeRestriction = SEQ(name=u'ScopeRestriction', mode=MODE_TYPE)
    _ScopeRestriction_id = OID(name=u'id', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'SCOPE-RESTRICTION'), [u'id']))
    _ScopeRestriction_restriction = OPEN(name=u'restriction', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'SCOPE-RESTRICTION'), [u'Type']))
    ScopeRestriction._cont = ASN1Dict([
        (u'id', _ScopeRestriction_id),
        (u'restriction', _ScopeRestriction_restriction),
        ])
    ScopeRestriction._ext = []
    
    #-----< protRestrict >-----#
    protRestrict = CLASS(name=u'protRestrict', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _protRestrict_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ProtRestriction')))
    protRestrict._val = dict([(u'ExtnType', _protRestrict_val_ExtnType), (u'id', (2, 5, 41, 1))])
    
    #-----< ProtRestriction >-----#
    ProtRestriction = SEQ_OF(name=u'ProtRestriction', mode=MODE_TYPE)
    _ProtRestriction__item_ = OID(name='_item_', mode=MODE_TYPE)
    ProtRestriction._cont = _ProtRestriction__item_
    ProtRestriction._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< pkiUser >-----#
    pkiUser = CLASS(name=u'pkiUser', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    __pmiUser_OptionalAttributes_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')))
    pkiUser._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)), (u'ldapName', [u'userCertificate']), (u'ldapDesc', u'X.509 user certificate'), (u'id', (2, 5, 4, 36))])], rr=[], ev=None, er=[])), (u'ldapName', [u'pkiUser']), (u'ldapDesc', u'X.509 PKI User'), (u'id', (2, 5, 6, 21))])
    
    #-----< pkiCA >-----#
    pkiCA = CLASS(name=u'pkiCA', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListExactAssertion')))
    __pmiUser_OptionalAttributes_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    __pmiUser_OptionalAttributes_val_Type_3 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    __pmiUser_OptionalAttributes_val_Type_4 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificatePair')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairExactAssertion')))
    pkiCA._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)), (u'ldapName', [u'cACertificate']), (u'ldapDesc', u'X.509 CA certificate'), (u'id', (2, 5, 4, 37))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 certificate revocation list'), (u'id', (2, 5, 4, 39))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 EEPK certificate revocation list'), (u'id', (2, 5, 4, 101))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_3), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'authorityRevocationList']), (u'ldapDesc', u'X.509 authority revocation list'), (u'id', (2, 5, 4, 38))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_4), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 3)), (u'ldapName', [u'certificatePairExactMatch']), (u'ldapDesc', u'X.509 Certificate Pair Exact Match'), (u'id', (2, 5, 13, 36))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 10)), (u'ldapName', [u'crossCertificatePair']), (u'ldapDesc', u'X.509 cross certificate pair'), (u'id', (2, 5, 4, 40))])], rr=[], ev=None, er=[])), (u'ldapName', [u'pkiCA']), (u'ldapDesc', u'X.509 PKI Certificate Authority'), (u'id', (2, 5, 6, 22))])
    
    #-----< cRLDistributionPoint >-----#
    cRLDistributionPoint = CLASS(name=u'cRLDistributionPoint', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3 = CHOICE(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'SubstringAssertion')))
    ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    __pmiUser_OptionalAttributes_val_Type_0_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    cRLDistributionPoint._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'structural'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'derivation', dict([(u'Type', ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'caseIgnoreMatch']), (u'id', (2, 5, 13, 2))])), (u'substrings-match', dict([(u'AssertionType', _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 58)), (u'ldapName', [u'caseIgnoreSubstringsMatch']), (u'id', (2, 5, 13, 4))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'name']), (u'id', (2, 5, 4, 41))])), (u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'cn', u'commonName']), (u'id', (2, 5, 4, 3))])], rr=[], ev=None, er=[])), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 certificate revocation list'), (u'id', (2, 5, 4, 39))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 EEPK certificate revocation list'), (u'id', (2, 5, 4, 101))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'authorityRevocationList']), (u'ldapDesc', u'X.509 authority revocation list'), (u'id', (2, 5, 4, 38))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_3), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'deltaRevocationList']), (u'ldapDesc', u'X.509 delta revocation list'), (u'id', (2, 5, 4, 53))])], rr=[], ev=None, er=[])), (u'ldapName', [u'cRLDistributionPoint']), (u'ldapDesc', u'X.509 CRL distribution point'), (u'id', (2, 5, 6, 19))])
    
    #-----< cRLDistPtNameForm >-----#
    cRLDistPtNameForm = CLASS(name=u'cRLDistPtNameForm', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'NAME-FORM')))
    __cRLDistPtNameForm_MandatoryAttributes_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    cRLDistPtNameForm._val = dict([(u'namedObjectClass', dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'structural'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'derivation', dict([(u'Type', ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'caseIgnoreMatch']), (u'id', (2, 5, 13, 2))])), (u'substrings-match', dict([(u'AssertionType', _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 58)), (u'ldapName', [u'caseIgnoreSubstringsMatch']), (u'id', (2, 5, 13, 4))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'name']), (u'id', (2, 5, 4, 41))])), (u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'cn', u'commonName']), (u'id', (2, 5, 4, 3))])], rr=[], ev=None, er=[])), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 certificate revocation list'), (u'id', (2, 5, 4, 39))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 EEPK certificate revocation list'), (u'id', (2, 5, 4, 101))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'authorityRevocationList']), (u'ldapDesc', u'X.509 authority revocation list'), (u'id', (2, 5, 4, 38))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_3), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'deltaRevocationList']), (u'ldapDesc', u'X.509 delta revocation list'), (u'id', (2, 5, 4, 53))])], rr=[], ev=None, er=[])), (u'ldapName', [u'cRLDistributionPoint']), (u'ldapDesc', u'X.509 CRL distribution point'), (u'id', (2, 5, 6, 19))])), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'derivation', dict([(u'Type', ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'caseIgnoreMatch']), (u'id', (2, 5, 13, 2))])), (u'substrings-match', dict([(u'AssertionType', _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 58)), (u'ldapName', [u'caseIgnoreSubstringsMatch']), (u'id', (2, 5, 13, 4))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'name']), (u'id', (2, 5, 4, 41))])), (u'Type', __cRLDistPtNameForm_MandatoryAttributes_val_Type_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'cn', u'commonName']), (u'id', (2, 5, 4, 3))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 15, 14))])
    
    #-----< deltaCRL >-----#
    deltaCRL = CLASS(name=u'deltaCRL', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    deltaCRL._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'deltaRevocationList']), (u'ldapDesc', u'X.509 delta revocation list'), (u'id', (2, 5, 4, 53))])], rr=[], ev=None, er=[])), (u'ldapName', [u'deltaCRL']), (u'ldapDesc', u'X.509 delta CRL'), (u'id', (2, 5, 6, 23))])
    
    #-----< cpCps >-----#
    cpCps = CLASS(name=u'cpCps', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicySyntax')))
    __pmiUser_OptionalAttributes_val_Type_1_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'InfoSyntax')))
    cpCps._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_1), (u'id', (2, 5, 4, 69))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1_0), (u'id', (2, 5, 4, 68))])], rr=[], ev=None, er=[])), (u'ldapName', [u'cpCps']), (u'ldapDesc', u'Certificate Policy and Certification Practice Statement'), (u'id', (2, 5, 6, 30))])
    
    #-----< pkiCertPath >-----#
    pkiCertPath = CLASS(name=u'pkiCertPath', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_2 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PkiPath')))
    pkiCertPath._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_2), (u'id', (2, 5, 4, 70))])], rr=[], ev=None, er=[])), (u'ldapName', [u'pkiCertPath']), (u'ldapDesc', u'PKI Certification Path'), (u'id', (2, 5, 6, 31))])
    
    #-----< userCertificate >-----#
    userCertificate = CLASS(name=u'userCertificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _userCertificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    userCertificate._val = dict([(u'Type', _userCertificate_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)), (u'ldapName', [u'userCertificate']), (u'ldapDesc', u'X.509 user certificate'), (u'id', (2, 5, 4, 36))])
    
    #-----< cACertificate >-----#
    cACertificate = CLASS(name=u'cACertificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _cACertificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    cACertificate._val = dict([(u'Type', _cACertificate_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)), (u'ldapName', [u'cACertificate']), (u'ldapDesc', u'X.509 CA certificate'), (u'id', (2, 5, 4, 37))])
    
    #-----< crossCertificatePair >-----#
    crossCertificatePair = CLASS(name=u'crossCertificatePair', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _crossCertificatePair_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificatePair')))
    crossCertificatePair._val = dict([(u'Type', _crossCertificatePair_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 3)), (u'ldapName', [u'certificatePairExactMatch']), (u'ldapDesc', u'X.509 Certificate Pair Exact Match'), (u'id', (2, 5, 13, 36))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 10)), (u'ldapName', [u'crossCertificatePair']), (u'ldapDesc', u'X.509 cross certificate pair'), (u'id', (2, 5, 4, 40))])
    
    #-----< CertificatePair >-----#
    CertificatePair = SEQ(name=u'CertificatePair', mode=MODE_TYPE)
    _CertificatePair_issuedToThisCA = SEQ(name=u'issuedToThisCA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')), opt=True)
    _CertificatePair_issuedByThisCA = SEQ(name=u'issuedByThisCA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')), opt=True)
    CertificatePair._cont = ASN1Dict([
        (u'issuedToThisCA', _CertificatePair_issuedToThisCA),
        (u'issuedByThisCA', _CertificatePair_issuedByThisCA),
        ])
    CertificatePair._ext = []
    
    #-----< certificateRevocationList >-----#
    certificateRevocationList = CLASS(name=u'certificateRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _certificateRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    certificateRevocationList._val = dict([(u'Type', _certificateRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 certificate revocation list'), (u'id', (2, 5, 4, 39))])
    
    #-----< eepkCertificateRevocationList >-----#
    eepkCertificateRevocationList = CLASS(name=u'eepkCertificateRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _eepkCertificateRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    eepkCertificateRevocationList._val = dict([(u'Type', _eepkCertificateRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 EEPK certificate revocation list'), (u'id', (2, 5, 4, 101))])
    
    #-----< authorityRevocationList >-----#
    authorityRevocationList = CLASS(name=u'authorityRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _authorityRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    authorityRevocationList._val = dict([(u'Type', _authorityRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'authorityRevocationList']), (u'ldapDesc', u'X.509 authority revocation list'), (u'id', (2, 5, 4, 38))])
    
    #-----< deltaRevocationList >-----#
    deltaRevocationList = CLASS(name=u'deltaRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _deltaRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    deltaRevocationList._val = dict([(u'Type', _deltaRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'deltaRevocationList']), (u'ldapDesc', u'X.509 delta revocation list'), (u'id', (2, 5, 4, 53))])
    
    #-----< supportedAlgorithms >-----#
    supportedAlgorithms = CLASS(name=u'supportedAlgorithms', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _supportedAlgorithms_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SupportedAlgorithm')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _____________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = ____________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = ____________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_trailerField),
        ])
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21._ext = None
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm._const_tab = ________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab
    _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm._const_tab_at = None
    _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm._const_tab_id = u'id'
    _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters._const_tab = ________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab
    _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters._const_tab_at = ('..', u'algorithm')
    _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters._const_tab_id = u'Type'
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4._cont = ASN1Dict([
        (u'algorithm', _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm),
        (u'parameters', _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters),
        ])
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4._ext = []
    supportedAlgorithms._val = dict([(u'Type', _supportedAlgorithms_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 7)), (u'ldapName', [u'algorithmIdentifierMatch']), (u'ldapDesc', u'X.509 Algorithm Identifier Match'), (u'id', (2, 5, 13, 40))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 49)), (u'ldapName', [u'supportedAlgorithms']), (u'ldapDesc', u'X.509 support algorithms'), (u'id', (2, 5, 4, 52))])
    
    #-----< SupportedAlgorithm >-----#
    SupportedAlgorithm = SEQ(name=u'SupportedAlgorithm', mode=MODE_TYPE)
    _SupportedAlgorithm_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __SupportedAlgorithm_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___SupportedAlgorithm_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___SupportedAlgorithm_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __SupportedAlgorithm_algorithmIdentifier_algorithm._const_tab = ___SupportedAlgorithm_algorithmIdentifier_algorithm_tab
    __SupportedAlgorithm_algorithmIdentifier_algorithm._const_tab_at = None
    __SupportedAlgorithm_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __SupportedAlgorithm_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __SupportedAlgorithm_algorithmIdentifier_parameters._const_tab = ___SupportedAlgorithm_algorithmIdentifier_algorithm_tab
    __SupportedAlgorithm_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __SupportedAlgorithm_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _SupportedAlgorithm_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __SupportedAlgorithm_algorithmIdentifier_algorithm),
        (u'parameters', __SupportedAlgorithm_algorithmIdentifier_parameters),
        ])
    _SupportedAlgorithm_algorithmIdentifier._ext = []
    _SupportedAlgorithm_intendedUsage = BIT_STR(name=u'intendedUsage', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'KeyUsage')), opt=True)
    _SupportedAlgorithm_intendedCertificatePolicies = SEQ_OF(name=u'intendedCertificatePolicies', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificatePoliciesSyntax')), opt=True)
    SupportedAlgorithm._cont = ASN1Dict([
        (u'algorithmIdentifier', _SupportedAlgorithm_algorithmIdentifier),
        (u'intendedUsage', _SupportedAlgorithm_intendedUsage),
        (u'intendedCertificatePolicies', _SupportedAlgorithm_intendedCertificatePolicies),
        ])
    SupportedAlgorithm._ext = []
    
    #-----< certificationPracticeStmt >-----#
    certificationPracticeStmt = CLASS(name=u'certificationPracticeStmt', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _certificationPracticeStmt_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'InfoSyntax')))
    certificationPracticeStmt._val = dict([(u'Type', _certificationPracticeStmt_val_Type), (u'id', (2, 5, 4, 68))])
    
    #-----< InfoSyntax >-----#
    InfoSyntax = CHOICE(name=u'InfoSyntax', mode=MODE_TYPE)
    _InfoSyntax_content = CHOICE(name=u'content', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    _InfoSyntax_pointer = SEQ(name=u'pointer', mode=MODE_TYPE)
    __InfoSyntax_pointer_name = SEQ_OF(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    __InfoSyntax_pointer_hash = SEQ(name=u'hash', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'HASH')), opt=True)
    ___InfoSyntax_pointer_hash_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    __________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', __________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    _____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm._const_tab = _____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab
    ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm._const_tab_at = None
    ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters._const_tab = _____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab
    ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___InfoSyntax_pointer_hash_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm),
        (u'parameters', ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters),
        ])
    ___InfoSyntax_pointer_hash_algorithmIdentifier._ext = []
    ___InfoSyntax_pointer_hash_hashValue = BIT_STR(name=u'hashValue', mode=MODE_TYPE)
    __InfoSyntax_pointer_hash._cont = ASN1Dict([
        (u'algorithmIdentifier', ___InfoSyntax_pointer_hash_algorithmIdentifier),
        (u'hashValue', ___InfoSyntax_pointer_hash_hashValue),
        ])
    __InfoSyntax_pointer_hash._ext = []
    _InfoSyntax_pointer._cont = ASN1Dict([
        (u'name', __InfoSyntax_pointer_name),
        (u'hash', __InfoSyntax_pointer_hash),
        ])
    _InfoSyntax_pointer._ext = []
    InfoSyntax._cont = ASN1Dict([
        (u'content', _InfoSyntax_content),
        (u'pointer', _InfoSyntax_pointer),
        ])
    InfoSyntax._ext = []
    
    #-----< POLICY >-----#
    POLICY = CLASS(name=u'POLICY', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< HashedPolicyInfo >-----#
    HashedPolicyInfo = OPEN(name=u'HashedPolicyInfo', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'POLICY'), [u'Type']))
    _HashedPolicyInfo_tab = CLASS(name='_tab_POLICY', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'POLICY')))
    _HashedPolicyInfo_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    HashedPolicyInfo._const_tab = _HashedPolicyInfo_tab
    HashedPolicyInfo._const_tab_at = None
    HashedPolicyInfo._const_tab_id = u'Type'
    
    #-----< Policies >-----#
    Policies = CLASS(name=u'Policies', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'POLICY')))
    Policies._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< certificatePolicy >-----#
    certificatePolicy = CLASS(name=u'certificatePolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _certificatePolicy_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicySyntax')))
    certificatePolicy._val = dict([(u'Type', _certificatePolicy_val_Type), (u'id', (2, 5, 4, 69))])
    
    #-----< PolicySyntax >-----#
    PolicySyntax = SEQ(name=u'PolicySyntax', mode=MODE_TYPE)
    _PolicySyntax_policyIdentifier = OID(name=u'policyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicyID')))
    _PolicySyntax_policySyntax = CHOICE(name=u'policySyntax', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'InfoSyntax')))
    PolicySyntax._cont = ASN1Dict([
        (u'policyIdentifier', _PolicySyntax_policyIdentifier),
        (u'policySyntax', _PolicySyntax_policySyntax),
        ])
    PolicySyntax._ext = []
    
    #-----< PolicyID >-----#
    PolicyID = OID(name=u'PolicyID', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    
    #-----< pkiPath >-----#
    pkiPath = CLASS(name=u'pkiPath', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pkiPath_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PkiPath')))
    pkiPath._val = dict([(u'Type', _pkiPath_val_Type), (u'id', (2, 5, 4, 70))])
    
    #-----< userPassword >-----#
    userPassword = CLASS(name=u'userPassword', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _userPassword_val_Type = OCT_STR(name=u'Type', mode=MODE_TYPE)
    _userPassword_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_5 = OCT_STR(name=u'AssertionType', mode=MODE_TYPE)
    userPassword._val = dict([(u'Type', _userPassword_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_5), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 40)), (u'ldapName', [u'octetStringMatch']), (u'id', (2, 5, 13, 17))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 40)), (u'ldapName', [u'userPassword']), (u'id', (2, 5, 4, 35))])
    
    #-----< x509Certificate >-----#
    x509Certificate = CLASS(name=u'x509Certificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _x509Certificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    x509Certificate._val = dict([(u'ldapDesc', u'X.509 Certificate'), (u'Type', _x509Certificate_val_Type), (u'id', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8))])
    
    #-----< x509CertificateList >-----#
    x509CertificateList = CLASS(name=u'x509CertificateList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _x509CertificateList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    x509CertificateList._val = dict([(u'ldapDesc', u'X.509 Certificate List'), (u'Type', _x509CertificateList_val_Type), (u'id', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9))])
    
    #-----< x509CertificatePair >-----#
    x509CertificatePair = CLASS(name=u'x509CertificatePair', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _x509CertificatePair_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificatePair')))
    x509CertificatePair._val = dict([(u'ldapDesc', u'X.509 Certificate Pair'), (u'Type', _x509CertificatePair_val_Type), (u'id', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 10))])
    
    #-----< x509SupportedAlgorithm >-----#
    x509SupportedAlgorithm = CLASS(name=u'x509SupportedAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _x509SupportedAlgorithm_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SupportedAlgorithm')))
    x509SupportedAlgorithm._val = dict([(u'ldapDesc', u'X.509 Supported Algorithm'), (u'Type', _x509SupportedAlgorithm_val_Type), (u'id', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 49))])
    
    #-----< id-oc-cRLDistributionPoint >-----#
    id_oc_cRLDistributionPoint = OID(name=u'id-oc-cRLDistributionPoint', mode=MODE_VALUE)
    id_oc_cRLDistributionPoint._val = (2, 5, 6, 19)
    
    #-----< id-oc-pkiUser >-----#
    id_oc_pkiUser = OID(name=u'id-oc-pkiUser', mode=MODE_VALUE)
    id_oc_pkiUser._val = (2, 5, 6, 21)
    
    #-----< id-oc-pkiCA >-----#
    id_oc_pkiCA = OID(name=u'id-oc-pkiCA', mode=MODE_VALUE)
    id_oc_pkiCA._val = (2, 5, 6, 22)
    
    #-----< id-oc-deltaCRL >-----#
    id_oc_deltaCRL = OID(name=u'id-oc-deltaCRL', mode=MODE_VALUE)
    id_oc_deltaCRL._val = (2, 5, 6, 23)
    
    #-----< id-oc-cpCps >-----#
    id_oc_cpCps = OID(name=u'id-oc-cpCps', mode=MODE_VALUE)
    id_oc_cpCps._val = (2, 5, 6, 30)
    
    #-----< id-oc-pkiCertPath >-----#
    id_oc_pkiCertPath = OID(name=u'id-oc-pkiCertPath', mode=MODE_VALUE)
    id_oc_pkiCertPath._val = (2, 5, 6, 31)
    
    #-----< id-nf-cRLDistPtNameForm >-----#
    id_nf_cRLDistPtNameForm = OID(name=u'id-nf-cRLDistPtNameForm', mode=MODE_VALUE)
    id_nf_cRLDistPtNameForm._val = (2, 5, 15, 14)
    
    #-----< id-at-userPassword >-----#
    id_at_userPassword = OID(name=u'id-at-userPassword', mode=MODE_VALUE)
    id_at_userPassword._val = (2, 5, 4, 35)
    
    #-----< id-at-userCertificate >-----#
    id_at_userCertificate = OID(name=u'id-at-userCertificate', mode=MODE_VALUE)
    id_at_userCertificate._val = (2, 5, 4, 36)
    
    #-----< id-at-cAcertificate >-----#
    id_at_cAcertificate = OID(name=u'id-at-cAcertificate', mode=MODE_VALUE)
    id_at_cAcertificate._val = (2, 5, 4, 37)
    
    #-----< id-at-authorityRevocationList >-----#
    id_at_authorityRevocationList = OID(name=u'id-at-authorityRevocationList', mode=MODE_VALUE)
    id_at_authorityRevocationList._val = (2, 5, 4, 38)
    
    #-----< id-at-certificateRevocationList >-----#
    id_at_certificateRevocationList = OID(name=u'id-at-certificateRevocationList', mode=MODE_VALUE)
    id_at_certificateRevocationList._val = (2, 5, 4, 39)
    
    #-----< id-at-crossCertificatePair >-----#
    id_at_crossCertificatePair = OID(name=u'id-at-crossCertificatePair', mode=MODE_VALUE)
    id_at_crossCertificatePair._val = (2, 5, 4, 40)
    
    #-----< id-at-supportedAlgorithms >-----#
    id_at_supportedAlgorithms = OID(name=u'id-at-supportedAlgorithms', mode=MODE_VALUE)
    id_at_supportedAlgorithms._val = (2, 5, 4, 52)
    
    #-----< id-at-deltaRevocationList >-----#
    id_at_deltaRevocationList = OID(name=u'id-at-deltaRevocationList', mode=MODE_VALUE)
    id_at_deltaRevocationList._val = (2, 5, 4, 53)
    
    #-----< id-at-certificationPracticeStmt >-----#
    id_at_certificationPracticeStmt = OID(name=u'id-at-certificationPracticeStmt', mode=MODE_VALUE)
    id_at_certificationPracticeStmt._val = (2, 5, 4, 68)
    
    #-----< id-at-certificatePolicy >-----#
    id_at_certificatePolicy = OID(name=u'id-at-certificatePolicy', mode=MODE_VALUE)
    id_at_certificatePolicy._val = (2, 5, 4, 69)
    
    #-----< id-at-pkiPath >-----#
    id_at_pkiPath = OID(name=u'id-at-pkiPath', mode=MODE_VALUE)
    id_at_pkiPath._val = (2, 5, 4, 70)
    
    #-----< id-at-eepkCertificateRevocationList >-----#
    id_at_eepkCertificateRevocationList = OID(name=u'id-at-eepkCertificateRevocationList', mode=MODE_VALUE)
    id_at_eepkCertificateRevocationList._val = (2, 5, 4, 101)
    
    #-----< id-lsx-x509Certificate >-----#
    id_lsx_x509Certificate = OID(name=u'id-lsx-x509Certificate', mode=MODE_VALUE)
    id_lsx_x509Certificate._val = (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)
    
    #-----< id-lsx-x509CertificateList >-----#
    id_lsx_x509CertificateList = OID(name=u'id-lsx-x509CertificateList', mode=MODE_VALUE)
    id_lsx_x509CertificateList._val = (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)
    
    #-----< id-lsx-x509CertificatePair >-----#
    id_lsx_x509CertificatePair = OID(name=u'id-lsx-x509CertificatePair', mode=MODE_VALUE)
    id_lsx_x509CertificatePair._val = (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 10)
    
    #-----< id-lsx-x509SupportedAlgorithm >-----#
    id_lsx_x509SupportedAlgorithm = OID(name=u'id-lsx-x509SupportedAlgorithm', mode=MODE_VALUE)
    id_lsx_x509SupportedAlgorithm._val = (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 49)
    
    #-----< id-protRestrict >-----#
    id_protRestrict = OID(name=u'id-protRestrict', mode=MODE_VALUE)
    id_protRestrict._val = (2, 5, 41, 1)
    
    _all_ = [
        ___SIGNATURE_algorithmIdentifier_algorithm_tab,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_0,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_1,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_6,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_7,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_8,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_9,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_10,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_11,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_12,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_13,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_14,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_15,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_16,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_17,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_18,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_19,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_20,
        _______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        _____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_21,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_28,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_29,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_30,
        ____SIGNATURE_algorithmIdentifier_algorithm_tab_val_Type_31,
        __SIGNATURE_algorithmIdentifier_algorithm,
        __SIGNATURE_algorithmIdentifier_parameters,
        _SIGNATURE_algorithmIdentifier,
        _SIGNATURE_signature,
        SIGNATURE,
        ___HASH_algorithmIdentifier_algorithm_tab,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_0,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_1,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_6,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_7,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_8,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_9,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_10,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_11,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_12,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_13,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_14,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_15,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_16,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_17,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_18,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_19,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_20,
        _______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        _____HASH_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_21,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_28,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_29,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_30,
        ____HASH_algorithmIdentifier_algorithm_tab_val_Type_31,
        __HASH_algorithmIdentifier_algorithm,
        __HASH_algorithmIdentifier_parameters,
        _HASH_algorithmIdentifier,
        _HASH_hashValue,
        HASH,
        ENCRYPTED,
        ENCRYPTED_HASH,
        ___FINGERPRINT_algorithmIdentifier_algorithm_tab,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_0,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_1,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_6,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_7,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_8,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_9,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_10,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_11,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_12,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_13,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_14,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_15,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_16,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_17,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_18,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_19,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_20,
        _______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        _____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_21,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_28,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_29,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_30,
        ____FINGERPRINT_algorithmIdentifier_algorithm_tab_val_Type_31,
        __FINGERPRINT_algorithmIdentifier_algorithm,
        __FINGERPRINT_algorithmIdentifier_parameters,
        _FINGERPRINT_algorithmIdentifier,
        _FINGERPRINT_fingerprint,
        FINGERPRINT,
        _ALGORITHM_Type,
        _ALGORITHM_id,
        ALGORITHM,
        SupportedAlgorithms,
        _SupportedAlgorithms_val_Type_0,
        _SupportedAlgorithms_val_Type_1,
        _SupportedAlgorithms_val_Type_6,
        _SupportedAlgorithms_val_Type_7,
        _SupportedAlgorithms_val_Type_8,
        _SupportedAlgorithms_val_Type_9,
        _SupportedAlgorithms_val_Type_10,
        _SupportedAlgorithms_val_Type_11,
        _SupportedAlgorithms_val_Type_12,
        _SupportedAlgorithms_val_Type_13,
        _SupportedAlgorithms_val_Type_14,
        _SupportedAlgorithms_val_Type_15,
        _SupportedAlgorithms_val_Type_16,
        _SupportedAlgorithms_val_Type_17,
        _SupportedAlgorithms_val_Type_18,
        _SupportedAlgorithms_val_Type_19,
        _SupportedAlgorithms_val_Type_20,
        ____SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm_tab,
        _____SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ___SupportedAlgorithms_val_Type_21_hashAlgorithm_algorithm,
        ___SupportedAlgorithms_val_Type_21_hashAlgorithm_parameters,
        __SupportedAlgorithms_val_Type_21_hashAlgorithm,
        __SupportedAlgorithms_val_Type_21_saltLength,
        __SupportedAlgorithms_val_Type_21_trailerField,
        _SupportedAlgorithms_val_Type_21,
        _SupportedAlgorithms_val_Type_28,
        _SupportedAlgorithms_val_Type_29,
        _SupportedAlgorithms_val_Type_30,
        _SupportedAlgorithms_val_Type_31,
        SupportedCurves,
        dummyCurv,
        _Certificate_toBeSigned,
        ___Certificate_algorithmIdentifier_algorithm_tab,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_0,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_1,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_6,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_7,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_8,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_9,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_10,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_11,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_12,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_13,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_14,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_15,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_16,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_17,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_18,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_19,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_20,
        _______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        _____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_21,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_28,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_29,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_30,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Type_31,
        __Certificate_algorithmIdentifier_algorithm,
        __Certificate_algorithmIdentifier_parameters,
        _Certificate_algorithmIdentifier,
        _Certificate_signature,
        Certificate,
        _TBSCertificate_version,
        _TBSCertificate_serialNumber,
        ___TBSCertificate_signature_algorithm_tab,
        ____TBSCertificate_signature_algorithm_tab_val_Type_0,
        ____TBSCertificate_signature_algorithm_tab_val_Type_1,
        ____TBSCertificate_signature_algorithm_tab_val_Type_6,
        ____TBSCertificate_signature_algorithm_tab_val_Type_7,
        ____TBSCertificate_signature_algorithm_tab_val_Type_8,
        ____TBSCertificate_signature_algorithm_tab_val_Type_9,
        ____TBSCertificate_signature_algorithm_tab_val_Type_10,
        ____TBSCertificate_signature_algorithm_tab_val_Type_11,
        ____TBSCertificate_signature_algorithm_tab_val_Type_12,
        ____TBSCertificate_signature_algorithm_tab_val_Type_13,
        ____TBSCertificate_signature_algorithm_tab_val_Type_14,
        ____TBSCertificate_signature_algorithm_tab_val_Type_15,
        ____TBSCertificate_signature_algorithm_tab_val_Type_16,
        ____TBSCertificate_signature_algorithm_tab_val_Type_17,
        ____TBSCertificate_signature_algorithm_tab_val_Type_18,
        ____TBSCertificate_signature_algorithm_tab_val_Type_19,
        ____TBSCertificate_signature_algorithm_tab_val_Type_20,
        _______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____TBSCertificate_signature_algorithm_tab_val_Type_21_hashAlgorithm,
        _____TBSCertificate_signature_algorithm_tab_val_Type_21_saltLength,
        _____TBSCertificate_signature_algorithm_tab_val_Type_21_trailerField,
        ____TBSCertificate_signature_algorithm_tab_val_Type_21,
        ____TBSCertificate_signature_algorithm_tab_val_Type_28,
        ____TBSCertificate_signature_algorithm_tab_val_Type_29,
        ____TBSCertificate_signature_algorithm_tab_val_Type_30,
        ____TBSCertificate_signature_algorithm_tab_val_Type_31,
        __TBSCertificate_signature_algorithm,
        __TBSCertificate_signature_parameters,
        _TBSCertificate_signature,
        _TBSCertificate_issuer,
        _TBSCertificate_validity,
        _TBSCertificate_subject,
        _TBSCertificate_subjectPublicKeyInfo,
        _TBSCertificate_issuerUniqueIdentifier,
        _TBSCertificate_subjectUniqueIdentifier,
        _TBSCertificate_extensions,
        TBSCertificate,
        Version,
        CertificateSerialNumber,
        _Validity_notBefore,
        _Validity_notAfter,
        Validity,
        ___SubjectPublicKeyInfo_algorithm_algorithm_tab,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_0,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_1,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_6,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_7,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_8,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_9,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_10,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_11,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_12,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_13,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_14,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_15,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_16,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_17,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_18,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_19,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_20,
        _______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_hashAlgorithm,
        _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_saltLength,
        _____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21_trailerField,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_21,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_28,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_29,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_30,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Type_31,
        __SubjectPublicKeyInfo_algorithm_algorithm,
        __SubjectPublicKeyInfo_algorithm_parameters,
        _SubjectPublicKeyInfo_algorithm,
        _SubjectPublicKeyInfo_subjectPublicKey,
        SubjectPublicKeyInfo,
        PublicKey,
        _Time_utcTime,
        _Time_generalizedTime,
        Time,
        _Extensions__item_,
        Extensions,
        __Extension_extnId_tab,
        _Extension_extnId,
        _Extension_critical,
        _Extension_extnValue,
        Extension,
        der,
        ExtensionSet,
        _EXTENSION_id,
        _EXTENSION_ExtnType,
        EXTENSION,
        _Certificates_userCertificate,
        _Certificates_certificationPath,
        Certificates,
        _ForwardCertificationPath__item_,
        ForwardCertificationPath,
        _CrossCertificates__item_,
        CrossCertificates,
        _CertificationPath_userCertificate,
        __CertificationPath_theCACertificates__item_,
        _CertificationPath_theCACertificates,
        CertificationPath,
        _PkiPath__item_,
        PkiPath,
        _CertificateList_toBeSigned,
        ___CertificateList_algorithmIdentifier_algorithm_tab,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_0,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_1,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_6,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_7,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_8,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_9,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_10,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_11,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_12,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_13,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_14,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_15,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_16,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_17,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_18,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_19,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_20,
        _______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        _____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_21,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_28,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_29,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_30,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Type_31,
        __CertificateList_algorithmIdentifier_algorithm,
        __CertificateList_algorithmIdentifier_parameters,
        _CertificateList_algorithmIdentifier,
        _CertificateList_signature,
        CertificateList,
        _CertificateListContent_version,
        ___CertificateListContent_signature_algorithm_tab,
        ____CertificateListContent_signature_algorithm_tab_val_Type_0,
        ____CertificateListContent_signature_algorithm_tab_val_Type_1,
        ____CertificateListContent_signature_algorithm_tab_val_Type_6,
        ____CertificateListContent_signature_algorithm_tab_val_Type_7,
        ____CertificateListContent_signature_algorithm_tab_val_Type_8,
        ____CertificateListContent_signature_algorithm_tab_val_Type_9,
        ____CertificateListContent_signature_algorithm_tab_val_Type_10,
        ____CertificateListContent_signature_algorithm_tab_val_Type_11,
        ____CertificateListContent_signature_algorithm_tab_val_Type_12,
        ____CertificateListContent_signature_algorithm_tab_val_Type_13,
        ____CertificateListContent_signature_algorithm_tab_val_Type_14,
        ____CertificateListContent_signature_algorithm_tab_val_Type_15,
        ____CertificateListContent_signature_algorithm_tab_val_Type_16,
        ____CertificateListContent_signature_algorithm_tab_val_Type_17,
        ____CertificateListContent_signature_algorithm_tab_val_Type_18,
        ____CertificateListContent_signature_algorithm_tab_val_Type_19,
        ____CertificateListContent_signature_algorithm_tab_val_Type_20,
        _______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____CertificateListContent_signature_algorithm_tab_val_Type_21_hashAlgorithm,
        _____CertificateListContent_signature_algorithm_tab_val_Type_21_saltLength,
        _____CertificateListContent_signature_algorithm_tab_val_Type_21_trailerField,
        ____CertificateListContent_signature_algorithm_tab_val_Type_21,
        ____CertificateListContent_signature_algorithm_tab_val_Type_28,
        ____CertificateListContent_signature_algorithm_tab_val_Type_29,
        ____CertificateListContent_signature_algorithm_tab_val_Type_30,
        ____CertificateListContent_signature_algorithm_tab_val_Type_31,
        __CertificateListContent_signature_algorithm,
        __CertificateListContent_signature_parameters,
        _CertificateListContent_signature,
        _CertificateListContent_issuer,
        _CertificateListContent_thisUpdate,
        _CertificateListContent_nextUpdate,
        ___CertificateListContent_revokedCertificates__item__serialNumber,
        ___CertificateListContent_revokedCertificates__item__revocationDate,
        ___CertificateListContent_revokedCertificates__item__crlEntryExtensions,
        __CertificateListContent_revokedCertificates__item_,
        _CertificateListContent_revokedCertificates,
        _CertificateListContent_crlExtensions,
        CertificateListContent,
        _CertAVL_toBeSigned,
        ___CertAVL_algorithmIdentifier_algorithm_tab,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_0,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_1,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_6,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_7,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_8,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_9,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_10,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_11,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_12,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_13,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_14,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_15,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_16,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_17,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_18,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_19,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_20,
        _______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        _____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_21,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_28,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_29,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_30,
        ____CertAVL_algorithmIdentifier_algorithm_tab_val_Type_31,
        __CertAVL_algorithmIdentifier_algorithm,
        __CertAVL_algorithmIdentifier_parameters,
        _CertAVL_algorithmIdentifier,
        _CertAVL_signature,
        CertAVL,
        _TBSCertAVL_version,
        _TBSCertAVL_serialNumber,
        ___TBSCertAVL_signature_algorithm_tab,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_0,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_1,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_6,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_7,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_8,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_9,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_10,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_11,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_12,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_13,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_14,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_15,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_16,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_17,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_18,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_19,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_20,
        _______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____TBSCertAVL_signature_algorithm_tab_val_Type_21_hashAlgorithm,
        _____TBSCertAVL_signature_algorithm_tab_val_Type_21_saltLength,
        _____TBSCertAVL_signature_algorithm_tab_val_Type_21_trailerField,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_21,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_28,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_29,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_30,
        ____TBSCertAVL_signature_algorithm_tab_val_Type_31,
        __TBSCertAVL_signature_algorithm,
        __TBSCertAVL_signature_parameters,
        _TBSCertAVL_signature,
        _TBSCertAVL_issuer,
        _TBSCertAVL_constrained,
        ____TBSCertAVL_entries__item__idType_certIdentifier,
        ____TBSCertAVL_entries__item__idType_entityGroup,
        ___TBSCertAVL_entries__item__idType,
        ___TBSCertAVL_entries__item__scope,
        ___TBSCertAVL_entries__item__entryExtensions,
        __TBSCertAVL_entries__item_,
        _TBSCertAVL_entries,
        _TBSCertAVL_avlExtensions,
        TBSCertAVL,
        AvlSerialNumber,
        _PKCertIdentifier_issuerSerialNumber,
        ____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_0,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_1,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_6,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_7,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_8,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_9,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_10,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_11,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_12,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_13,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_14,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_15,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_16,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_17,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_18,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_19,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_20,
        ________PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        _________PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        _______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        ______PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_21,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_28,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_29,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_30,
        _____PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm_tab_val_Type_31,
        ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_algorithm,
        ___PKCertIdentifier_fingerprintPKC_algorithmIdentifier_parameters,
        __PKCertIdentifier_fingerprintPKC_algorithmIdentifier,
        __PKCertIdentifier_fingerprintPKC_fingerprint,
        _PKCertIdentifier_fingerprintPKC,
        ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_algorithm,
        ___PKCertIdentifier_fingerprintPK_algorithmIdentifier_parameters,
        __PKCertIdentifier_fingerprintPK_algorithmIdentifier,
        __PKCertIdentifier_fingerprintPK_fingerprint,
        _PKCertIdentifier_fingerprintPK,
        PKCertIdentifier,
        _IssuerSerialNumber_issuer,
        _IssuerSerialNumber_serialNumber,
        IssuerSerialNumber,
        _ScopeRestrictions__item_,
        ScopeRestrictions,
        SCOPE_RESTRICTION,
        _ScopeRestriction_id,
        _ScopeRestriction_restriction,
        ScopeRestriction,
        protRestrict,
        _protRestrict_val_ExtnType,
        _ProtRestriction__item_,
        ProtRestriction,
        pkiUser,
        ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType,
        __pmiUser_OptionalAttributes_val_Type_0,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0,
        pkiCA,
        __pmiUser_OptionalAttributes_val_Type_1,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_1,
        __pmiUser_OptionalAttributes_val_Type_2,
        __pmiUser_OptionalAttributes_val_Type_3,
        __pmiUser_OptionalAttributes_val_Type_4,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_2,
        cRLDistributionPoint,
        ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_3,
        _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType,
        ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0_0,
        __pmiUser_OptionalAttributes_val_Type_0_0,
        cRLDistPtNameForm,
        __cRLDistPtNameForm_MandatoryAttributes_val_Type_0,
        deltaCRL,
        cpCps,
        __pmiUser_OptionalAttributes_val_Type_0_1,
        __pmiUser_OptionalAttributes_val_Type_1_0,
        pkiCertPath,
        __pmiUser_OptionalAttributes_val_Type_0_2,
        userCertificate,
        _userCertificate_val_Type,
        cACertificate,
        _cACertificate_val_Type,
        crossCertificatePair,
        _crossCertificatePair_val_Type,
        _CertificatePair_issuedToThisCA,
        _CertificatePair_issuedByThisCA,
        CertificatePair,
        certificateRevocationList,
        _certificateRevocationList_val_Type,
        eepkCertificateRevocationList,
        _eepkCertificateRevocationList_val_Type,
        authorityRevocationList,
        _authorityRevocationList_val_Type,
        deltaRevocationList,
        _deltaRevocationList_val_Type,
        supportedAlgorithms,
        _supportedAlgorithms_val_Type,
        ________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_0,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_1,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_6,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_7,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_8,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_9,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_10,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_11,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_12,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_13,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_14,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_15,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_16,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_17,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_18,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_19,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_20,
        ____________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        _____________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ___________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_hashAlgorithm,
        __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_saltLength,
        __________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21_trailerField,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_21,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_28,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_29,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_30,
        _________TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab_val_Type_31,
        _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm,
        _______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_4,
        ___SupportedAlgorithm_algorithmIdentifier_algorithm_tab,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_0,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_1,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_6,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_7,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_8,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_9,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_10,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_11,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_12,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_13,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_14,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_15,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_16,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_17,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_18,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_19,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_20,
        _______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        _____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_21,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_28,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_29,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_30,
        ____SupportedAlgorithm_algorithmIdentifier_algorithm_tab_val_Type_31,
        __SupportedAlgorithm_algorithmIdentifier_algorithm,
        __SupportedAlgorithm_algorithmIdentifier_parameters,
        _SupportedAlgorithm_algorithmIdentifier,
        _SupportedAlgorithm_intendedUsage,
        _SupportedAlgorithm_intendedCertificatePolicies,
        SupportedAlgorithm,
        certificationPracticeStmt,
        _certificationPracticeStmt_val_Type,
        _InfoSyntax_content,
        __InfoSyntax_pointer_name,
        _____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_0,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_1,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_6,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_7,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_8,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_9,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_10,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_11,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_12,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_13,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_14,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_15,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_16,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_17,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_18,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_19,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_20,
        _________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        __________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ________InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        _______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_21,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_28,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_29,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_30,
        ______InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab_val_Type_31,
        ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm,
        ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters,
        ___InfoSyntax_pointer_hash_algorithmIdentifier,
        ___InfoSyntax_pointer_hash_hashValue,
        __InfoSyntax_pointer_hash,
        _InfoSyntax_pointer,
        InfoSyntax,
        POLICY,
        _HashedPolicyInfo_tab,
        HashedPolicyInfo,
        Policies,
        certificatePolicy,
        _certificatePolicy_val_Type,
        _PolicySyntax_policyIdentifier,
        _PolicySyntax_policySyntax,
        PolicySyntax,
        PolicyID,
        pkiPath,
        _pkiPath_val_Type,
        userPassword,
        _userPassword_val_Type,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_5,
        x509Certificate,
        _x509Certificate_val_Type,
        x509CertificateList,
        _x509CertificateList_val_Type,
        x509CertificatePair,
        _x509CertificatePair_val_Type,
        x509SupportedAlgorithm,
        _x509SupportedAlgorithm_val_Type,
        id_oc_cRLDistributionPoint,
        id_oc_pkiUser,
        id_oc_pkiCA,
        id_oc_deltaCRL,
        id_oc_cpCps,
        id_oc_pkiCertPath,
        id_nf_cRLDistPtNameForm,
        id_at_userPassword,
        id_at_userCertificate,
        id_at_cAcertificate,
        id_at_authorityRevocationList,
        id_at_certificateRevocationList,
        id_at_crossCertificatePair,
        id_at_supportedAlgorithms,
        id_at_deltaRevocationList,
        id_at_certificationPracticeStmt,
        id_at_certificatePolicy,
        id_at_pkiPath,
        id_at_eepkCertificateRevocationList,
        id_lsx_x509Certificate,
        id_lsx_x509CertificateList,
        id_lsx_x509CertificatePair,
        id_lsx_x509SupportedAlgorithm,
        id_protRestrict,
    ]

class BasicAccessControl:

    _name_  = u'BasicAccessControl'
    _oid_   = [2, 5, 1, 24, 8]
    
    _obj_ = [
        u'accessControlScheme',
        u'ACIItem',
        u'Precedence',
        u'ProtectedItems',
        u'MaxValueCount',
        u'RestrictedValue',
        u'UserClasses',
        u'ItemPermission',
        u'UserPermission',
        u'AuthenticationLevel',
        u'GrantsAndDenials',
        u'prescriptiveACI',
        u'entryACI',
        u'subentryACI',
        u'id-aca-accessControlScheme',
        u'id-aca-prescriptiveACI',
        u'id-aca-entryACI',
        u'id-aca-subentryACI',
        u'basicAccessControlScheme',
        u'simplifiedAccessControlScheme',
        u'rule-based-access-control',
        u'rule-and-basic-access-control',
        u'rule-and-simple-access-control',
        ]
    _type_ = [
        u'ACIItem',
        u'Precedence',
        u'ProtectedItems',
        u'MaxValueCount',
        u'RestrictedValue',
        u'UserClasses',
        u'ItemPermission',
        u'UserPermission',
        u'AuthenticationLevel',
        u'GrantsAndDenials',
        ]
    _set_ = [
        ]
    _val_ = [
        u'accessControlScheme',
        u'prescriptiveACI',
        u'entryACI',
        u'subentryACI',
        u'id-aca-accessControlScheme',
        u'id-aca-prescriptiveACI',
        u'id-aca-entryACI',
        u'id-aca-subentryACI',
        u'basicAccessControlScheme',
        u'simplifiedAccessControlScheme',
        u'rule-based-access-control',
        u'rule-and-basic-access-control',
        u'rule-and-simple-access-control',
        ]
    _class_ = [
        u'accessControlScheme',
        u'prescriptiveACI',
        u'entryACI',
        u'subentryACI',
        ]
    _param_ = [
        ]
    
    #-----< accessControlScheme >-----#
    accessControlScheme = CLASS(name=u'accessControlScheme', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _accessControlScheme_val_Type = OID(name=u'Type', mode=MODE_TYPE)
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    accessControlScheme._val = dict([(u'Type', _accessControlScheme_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'id', (2, 5, 24, 1))])
    
    #-----< ACIItem >-----#
    ACIItem = SEQ(name=u'ACIItem', mode=MODE_TYPE)
    _ACIItem_identificationTag = CHOICE(name=u'identificationTag', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    _ACIItem_precedence = INT(name=u'precedence', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'Precedence')))
    _ACIItem_authenticationLevel = CHOICE(name=u'authenticationLevel', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'AuthenticationLevel')))
    _ACIItem_itemOrUserFirst = CHOICE(name=u'itemOrUserFirst', mode=MODE_TYPE)
    __ACIItem_itemOrUserFirst_itemFirst = SEQ(name=u'itemFirst', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ACIItem_itemOrUserFirst_itemFirst_protectedItems = SEQ(name=u'protectedItems', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ProtectedItems')))
    ___ACIItem_itemOrUserFirst_itemFirst_itemPermissions = SET_OF(name=u'itemPermissions', mode=MODE_TYPE)
    ____ACIItem_itemOrUserFirst_itemFirst_itemPermissions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ItemPermission')))
    ___ACIItem_itemOrUserFirst_itemFirst_itemPermissions._cont = ____ACIItem_itemOrUserFirst_itemFirst_itemPermissions__item_
    __ACIItem_itemOrUserFirst_itemFirst._cont = ASN1Dict([
        (u'protectedItems', ___ACIItem_itemOrUserFirst_itemFirst_protectedItems),
        (u'itemPermissions', ___ACIItem_itemOrUserFirst_itemFirst_itemPermissions),
        ])
    __ACIItem_itemOrUserFirst_itemFirst._ext = []
    __ACIItem_itemOrUserFirst_userFirst = SEQ(name=u'userFirst', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ACIItem_itemOrUserFirst_userFirst_userClasses = SEQ(name=u'userClasses', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'UserClasses')))
    ___ACIItem_itemOrUserFirst_userFirst_userPermissions = SET_OF(name=u'userPermissions', mode=MODE_TYPE)
    ____ACIItem_itemOrUserFirst_userFirst_userPermissions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'UserPermission')))
    ___ACIItem_itemOrUserFirst_userFirst_userPermissions._cont = ____ACIItem_itemOrUserFirst_userFirst_userPermissions__item_
    __ACIItem_itemOrUserFirst_userFirst._cont = ASN1Dict([
        (u'userClasses', ___ACIItem_itemOrUserFirst_userFirst_userClasses),
        (u'userPermissions', ___ACIItem_itemOrUserFirst_userFirst_userPermissions),
        ])
    __ACIItem_itemOrUserFirst_userFirst._ext = []
    _ACIItem_itemOrUserFirst._cont = ASN1Dict([
        (u'itemFirst', __ACIItem_itemOrUserFirst_itemFirst),
        (u'userFirst', __ACIItem_itemOrUserFirst_userFirst),
        ])
    _ACIItem_itemOrUserFirst._ext = []
    ACIItem._cont = ASN1Dict([
        (u'identificationTag', _ACIItem_identificationTag),
        (u'precedence', _ACIItem_precedence),
        (u'authenticationLevel', _ACIItem_authenticationLevel),
        (u'itemOrUserFirst', _ACIItem_itemOrUserFirst),
        ])
    ACIItem._ext = []
    
    #-----< Precedence >-----#
    Precedence = INT(name=u'Precedence', mode=MODE_TYPE)
    Precedence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=[], er=[])
    
    #-----< ProtectedItems >-----#
    ProtectedItems = SEQ(name=u'ProtectedItems', mode=MODE_TYPE)
    _ProtectedItems_entry = NULL(name=u'entry', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ProtectedItems_allUserAttributeTypes = NULL(name=u'allUserAttributeTypes', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ProtectedItems_attributeType = SET_OF(name=u'attributeType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_attributeType__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _ProtectedItems_attributeType._cont = __ProtectedItems_attributeType__item_
    _ProtectedItems_attributeType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_allAttributeValues = SET_OF(name=u'allAttributeValues', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_allAttributeValues__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _ProtectedItems_allAttributeValues._cont = __ProtectedItems_allAttributeValues__item_
    _ProtectedItems_allAttributeValues._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_allUserAttributeTypesAndValues = NULL(name=u'allUserAttributeTypesAndValues', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ProtectedItems_attributeValue = SET_OF(name=u'attributeValue', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_attributeValue__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAndValue')))
    _ProtectedItems_attributeValue._cont = __ProtectedItems_attributeValue__item_
    _ProtectedItems_attributeValue._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_selfValue = SET_OF(name=u'selfValue', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_selfValue__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _ProtectedItems_selfValue._cont = __ProtectedItems_selfValue__item_
    _ProtectedItems_selfValue._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_rangeOfValues = CHOICE(name=u'rangeOfValues', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')), opt=True)
    _ProtectedItems_maxValueCount = SET_OF(name=u'maxValueCount', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_maxValueCount__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'MaxValueCount')))
    _ProtectedItems_maxValueCount._cont = __ProtectedItems_maxValueCount__item_
    _ProtectedItems_maxValueCount._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_maxImmSub = INT(name=u'maxImmSub', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ProtectedItems_restrictedBy = SET_OF(name=u'restrictedBy', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_restrictedBy__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'RestrictedValue')))
    _ProtectedItems_restrictedBy._cont = __ProtectedItems_restrictedBy__item_
    _ProtectedItems_restrictedBy._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_contexts = SET_OF(name=u'contexts', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_contexts__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'ContextAssertion')))
    _ProtectedItems_contexts._cont = __ProtectedItems_contexts__item_
    _ProtectedItems_contexts._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_classes = CHOICE(name=u'classes', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Refinement')), opt=True)
    ProtectedItems._cont = ASN1Dict([
        (u'entry', _ProtectedItems_entry),
        (u'allUserAttributeTypes', _ProtectedItems_allUserAttributeTypes),
        (u'attributeType', _ProtectedItems_attributeType),
        (u'allAttributeValues', _ProtectedItems_allAttributeValues),
        (u'allUserAttributeTypesAndValues', _ProtectedItems_allUserAttributeTypesAndValues),
        (u'attributeValue', _ProtectedItems_attributeValue),
        (u'selfValue', _ProtectedItems_selfValue),
        (u'rangeOfValues', _ProtectedItems_rangeOfValues),
        (u'maxValueCount', _ProtectedItems_maxValueCount),
        (u'maxImmSub', _ProtectedItems_maxImmSub),
        (u'restrictedBy', _ProtectedItems_restrictedBy),
        (u'contexts', _ProtectedItems_contexts),
        (u'classes', _ProtectedItems_classes),
        ])
    ProtectedItems._ext = []
    
    #-----< MaxValueCount >-----#
    MaxValueCount = SEQ(name=u'MaxValueCount', mode=MODE_TYPE)
    _MaxValueCount_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _MaxValueCount_maxCount = INT(name=u'maxCount', mode=MODE_TYPE)
    MaxValueCount._cont = ASN1Dict([
        (u'type', _MaxValueCount_type),
        (u'maxCount', _MaxValueCount_maxCount),
        ])
    MaxValueCount._ext = []
    
    #-----< RestrictedValue >-----#
    RestrictedValue = SEQ(name=u'RestrictedValue', mode=MODE_TYPE)
    _RestrictedValue_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _RestrictedValue_valuesIn = OID(name=u'valuesIn', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    RestrictedValue._cont = ASN1Dict([
        (u'type', _RestrictedValue_type),
        (u'valuesIn', _RestrictedValue_valuesIn),
        ])
    RestrictedValue._ext = []
    
    #-----< UserClasses >-----#
    UserClasses = SEQ(name=u'UserClasses', mode=MODE_TYPE)
    _UserClasses_allUsers = NULL(name=u'allUsers', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _UserClasses_thisEntry = NULL(name=u'thisEntry', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _UserClasses_name = SET_OF(name=u'name', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __UserClasses_name__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'NameAndOptionalUID')))
    _UserClasses_name._cont = __UserClasses_name__item_
    _UserClasses_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _UserClasses_userGroup = SET_OF(name=u'userGroup', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __UserClasses_userGroup__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'NameAndOptionalUID')))
    _UserClasses_userGroup._cont = __UserClasses_userGroup__item_
    _UserClasses_userGroup._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _UserClasses_subtree = SET_OF(name=u'subtree', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __UserClasses_subtree__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'SubtreeSpecification')))
    _UserClasses_subtree._cont = __UserClasses_subtree__item_
    _UserClasses_subtree._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    UserClasses._cont = ASN1Dict([
        (u'allUsers', _UserClasses_allUsers),
        (u'thisEntry', _UserClasses_thisEntry),
        (u'name', _UserClasses_name),
        (u'userGroup', _UserClasses_userGroup),
        (u'subtree', _UserClasses_subtree),
        ])
    UserClasses._ext = []
    
    #-----< ItemPermission >-----#
    ItemPermission = SEQ(name=u'ItemPermission', mode=MODE_TYPE)
    _ItemPermission_precedence = INT(name=u'precedence', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'Precedence')), opt=True)
    _ItemPermission_userClasses = SEQ(name=u'userClasses', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'UserClasses')))
    _ItemPermission_grantsAndDenials = BIT_STR(name=u'grantsAndDenials', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'GrantsAndDenials')))
    ItemPermission._cont = ASN1Dict([
        (u'precedence', _ItemPermission_precedence),
        (u'userClasses', _ItemPermission_userClasses),
        (u'grantsAndDenials', _ItemPermission_grantsAndDenials),
        ])
    ItemPermission._ext = []
    
    #-----< UserPermission >-----#
    UserPermission = SEQ(name=u'UserPermission', mode=MODE_TYPE)
    _UserPermission_precedence = INT(name=u'precedence', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'Precedence')), opt=True)
    _UserPermission_protectedItems = SEQ(name=u'protectedItems', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ProtectedItems')))
    _UserPermission_grantsAndDenials = BIT_STR(name=u'grantsAndDenials', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'GrantsAndDenials')))
    UserPermission._cont = ASN1Dict([
        (u'precedence', _UserPermission_precedence),
        (u'protectedItems', _UserPermission_protectedItems),
        (u'grantsAndDenials', _UserPermission_grantsAndDenials),
        ])
    UserPermission._ext = []
    
    #-----< AuthenticationLevel >-----#
    AuthenticationLevel = CHOICE(name=u'AuthenticationLevel', mode=MODE_TYPE)
    _AuthenticationLevel_basicLevels = SEQ(name=u'basicLevels', mode=MODE_TYPE)
    __AuthenticationLevel_basicLevels_level = ENUM(name=u'level', mode=MODE_TYPE)
    __AuthenticationLevel_basicLevels_level._cont = ASN1Dict([(u'none', 0), (u'simple', 1), (u'strong', 2)])
    __AuthenticationLevel_basicLevels_level._ext = []
    __AuthenticationLevel_basicLevels_localQualifier = INT(name=u'localQualifier', mode=MODE_TYPE, opt=True)
    __AuthenticationLevel_basicLevels_signed = BOOL(name=u'signed', mode=MODE_TYPE, default=False)
    _AuthenticationLevel_basicLevels._cont = ASN1Dict([
        (u'level', __AuthenticationLevel_basicLevels_level),
        (u'localQualifier', __AuthenticationLevel_basicLevels_localQualifier),
        (u'signed', __AuthenticationLevel_basicLevels_signed),
        ])
    _AuthenticationLevel_basicLevels._ext = []
    _AuthenticationLevel_other = EXT(name=u'other', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    AuthenticationLevel._cont = ASN1Dict([
        (u'basicLevels', _AuthenticationLevel_basicLevels),
        (u'other', _AuthenticationLevel_other),
        ])
    AuthenticationLevel._ext = []
    
    #-----< GrantsAndDenials >-----#
    GrantsAndDenials = BIT_STR(name=u'GrantsAndDenials', mode=MODE_TYPE)
    GrantsAndDenials._cont = ASN1Dict([(u'grantAdd', 0), (u'denyAdd', 1), (u'grantDiscloseOnError', 2), (u'denyDiscloseOnError', 3), (u'grantRead', 4), (u'denyRead', 5), (u'grantRemove', 6), (u'denyRemove', 7), (u'grantBrowse', 8), (u'denyBrowse', 9), (u'grantExport', 10), (u'denyExport', 11), (u'grantImport', 12), (u'denyImport', 13), (u'grantModify', 14), (u'denyModify', 15), (u'grantRename', 16), (u'denyRename', 17), (u'grantReturnDN', 18), (u'denyReturnDN', 19), (u'grantCompare', 20), (u'denyCompare', 21), (u'grantFilterMatch', 22), (u'denyFilterMatch', 23), (u'grantInvoke', 24), (u'denyInvoke', 25)])
    
    #-----< prescriptiveACI >-----#
    prescriptiveACI = CLASS(name=u'prescriptiveACI', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _prescriptiveACI_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ACIItem')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0 = CHOICE(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    prescriptiveACI._val = dict([(u'Type', _prescriptiveACI_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'directoryStringFirstComponentMatch']), (u'id', (2, 5, 13, 31))])), (u'usage', u'directoryOperation'), (u'id', (2, 5, 24, 4))])
    
    #-----< entryACI >-----#
    entryACI = CLASS(name=u'entryACI', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _entryACI_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ACIItem')))
    entryACI._val = dict([(u'Type', _entryACI_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'directoryStringFirstComponentMatch']), (u'id', (2, 5, 13, 31))])), (u'usage', u'directoryOperation'), (u'id', (2, 5, 24, 5))])
    
    #-----< subentryACI >-----#
    subentryACI = CLASS(name=u'subentryACI', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _subentryACI_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ACIItem')))
    subentryACI._val = dict([(u'Type', _subentryACI_val_Type), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'directoryStringFirstComponentMatch']), (u'id', (2, 5, 13, 31))])), (u'usage', u'directoryOperation'), (u'id', (2, 5, 24, 6))])
    
    #-----< id-aca-accessControlScheme >-----#
    id_aca_accessControlScheme = OID(name=u'id-aca-accessControlScheme', mode=MODE_VALUE)
    id_aca_accessControlScheme._val = (2, 5, 24, 1)
    
    #-----< id-aca-prescriptiveACI >-----#
    id_aca_prescriptiveACI = OID(name=u'id-aca-prescriptiveACI', mode=MODE_VALUE)
    id_aca_prescriptiveACI._val = (2, 5, 24, 4)
    
    #-----< id-aca-entryACI >-----#
    id_aca_entryACI = OID(name=u'id-aca-entryACI', mode=MODE_VALUE)
    id_aca_entryACI._val = (2, 5, 24, 5)
    
    #-----< id-aca-subentryACI >-----#
    id_aca_subentryACI = OID(name=u'id-aca-subentryACI', mode=MODE_VALUE)
    id_aca_subentryACI._val = (2, 5, 24, 6)
    
    #-----< basicAccessControlScheme >-----#
    basicAccessControlScheme = OID(name=u'basicAccessControlScheme', mode=MODE_VALUE)
    basicAccessControlScheme._val = (2, 5, 28, 1)
    
    #-----< simplifiedAccessControlScheme >-----#
    simplifiedAccessControlScheme = OID(name=u'simplifiedAccessControlScheme', mode=MODE_VALUE)
    simplifiedAccessControlScheme._val = (2, 5, 28, 2)
    
    #-----< rule-based-access-control >-----#
    rule_based_access_control = OID(name=u'rule-based-access-control', mode=MODE_VALUE)
    rule_based_access_control._val = (2, 5, 28, 3)
    
    #-----< rule-and-basic-access-control >-----#
    rule_and_basic_access_control = OID(name=u'rule-and-basic-access-control', mode=MODE_VALUE)
    rule_and_basic_access_control._val = (2, 5, 28, 4)
    
    #-----< rule-and-simple-access-control >-----#
    rule_and_simple_access_control = OID(name=u'rule-and-simple-access-control', mode=MODE_VALUE)
    rule_and_simple_access_control._val = (2, 5, 28, 5)
    
    _all_ = [
        accessControlScheme,
        _accessControlScheme_val_Type,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType,
        _ACIItem_identificationTag,
        _ACIItem_precedence,
        _ACIItem_authenticationLevel,
        ___ACIItem_itemOrUserFirst_itemFirst_protectedItems,
        ____ACIItem_itemOrUserFirst_itemFirst_itemPermissions__item_,
        ___ACIItem_itemOrUserFirst_itemFirst_itemPermissions,
        __ACIItem_itemOrUserFirst_itemFirst,
        ___ACIItem_itemOrUserFirst_userFirst_userClasses,
        ____ACIItem_itemOrUserFirst_userFirst_userPermissions__item_,
        ___ACIItem_itemOrUserFirst_userFirst_userPermissions,
        __ACIItem_itemOrUserFirst_userFirst,
        _ACIItem_itemOrUserFirst,
        ACIItem,
        Precedence,
        _ProtectedItems_entry,
        _ProtectedItems_allUserAttributeTypes,
        __ProtectedItems_attributeType__item_,
        _ProtectedItems_attributeType,
        __ProtectedItems_allAttributeValues__item_,
        _ProtectedItems_allAttributeValues,
        _ProtectedItems_allUserAttributeTypesAndValues,
        __ProtectedItems_attributeValue__item_,
        _ProtectedItems_attributeValue,
        __ProtectedItems_selfValue__item_,
        _ProtectedItems_selfValue,
        _ProtectedItems_rangeOfValues,
        __ProtectedItems_maxValueCount__item_,
        _ProtectedItems_maxValueCount,
        _ProtectedItems_maxImmSub,
        __ProtectedItems_restrictedBy__item_,
        _ProtectedItems_restrictedBy,
        __ProtectedItems_contexts__item_,
        _ProtectedItems_contexts,
        _ProtectedItems_classes,
        ProtectedItems,
        _MaxValueCount_type,
        _MaxValueCount_maxCount,
        MaxValueCount,
        _RestrictedValue_type,
        _RestrictedValue_valuesIn,
        RestrictedValue,
        _UserClasses_allUsers,
        _UserClasses_thisEntry,
        __UserClasses_name__item_,
        _UserClasses_name,
        __UserClasses_userGroup__item_,
        _UserClasses_userGroup,
        __UserClasses_subtree__item_,
        _UserClasses_subtree,
        UserClasses,
        _ItemPermission_precedence,
        _ItemPermission_userClasses,
        _ItemPermission_grantsAndDenials,
        ItemPermission,
        _UserPermission_precedence,
        _UserPermission_protectedItems,
        _UserPermission_grantsAndDenials,
        UserPermission,
        __AuthenticationLevel_basicLevels_level,
        __AuthenticationLevel_basicLevels_localQualifier,
        __AuthenticationLevel_basicLevels_signed,
        _AuthenticationLevel_basicLevels,
        _AuthenticationLevel_other,
        AuthenticationLevel,
        GrantsAndDenials,
        prescriptiveACI,
        _prescriptiveACI_val_Type,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0,
        entryACI,
        _entryACI_val_Type,
        subentryACI,
        _subentryACI_val_Type,
        id_aca_accessControlScheme,
        id_aca_prescriptiveACI,
        id_aca_entryACI,
        id_aca_subentryACI,
        basicAccessControlScheme,
        simplifiedAccessControlScheme,
        rule_based_access_control,
        rule_and_basic_access_control,
        rule_and_simple_access_control,
    ]

class CertificateExtensions:

    _name_  = u'CertificateExtensions'
    _oid_   = [2, 5, 1, 26, 8]
    
    _obj_ = [
        u'authorityKeyIdentifier',
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'subjectKeyIdentifier',
        u'SubjectKeyIdentifier',
        u'keyUsage',
        u'KeyUsage',
        u'extKeyUsage',
        u'KeyPurposeId',
        u'privateKeyUsagePeriod',
        u'PrivateKeyUsagePeriod',
        u'certificatePolicies',
        u'CertificatePoliciesSyntax',
        u'PolicyInformation',
        u'CertPolicyId',
        u'PolicyQualifierInfo',
        u'SupportedPolicyQualifiers',
        u'anyPolicy',
        u'CERT-POLICY-QUALIFIER',
        u'policyMappings',
        u'PolicyMappingsSyntax',
        u'authorizationValidation',
        u'AvlId',
        u'subjectAltName',
        u'GeneralNames',
        u'GeneralName',
        u'OTHER-NAME',
        u'EDIPartyName',
        u'issuerAltName',
        u'subjectDirectoryAttributes',
        u'AttributesSyntax',
        u'basicConstraints',
        u'BasicConstraintsSyntax',
        u'nameConstraints',
        u'NameConstraintsSyntax',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'policyConstraints',
        u'PolicyConstraintsSyntax',
        u'SkipCerts',
        u'inhibitAnyPolicy',
        u'cRLNumber',
        u'CRLNumber',
        u'crlScope',
        u'CRLScopeSyntax',
        u'PerAuthorityScope',
        u'OnlyCertificateTypes',
        u'NumberRange',
        u'BaseRevocationInfo',
        u'statusReferrals',
        u'StatusReferrals',
        u'StatusReferral',
        u'CRLReferral',
        u'DeltaRefInfo',
        u'OTHER-REFERRAL',
        u'cRLStreamIdentifier',
        u'CRLStreamIdentifier',
        u'orderedList',
        u'OrderedListSyntax',
        u'deltaInfo',
        u'DeltaInformation',
        u'toBeRevoked',
        u'ToBeRevokedSyntax',
        u'ToBeRevokedGroup',
        u'ReasonInfo',
        u'CertificateGroup',
        u'CertificateGroupNumberRange',
        u'CertificateSerialNumbers',
        u'revokedGroups',
        u'RevokedGroupsSyntax',
        u'RevokedGroup',
        u'RevokedCertificateGroup',
        u'expiredCertsOnCRL',
        u'ExpiredCertsOnCRL',
        u'reasonCode',
        u'CRLReason',
        u'holdInstructionCode',
        u'HoldInstruction',
        u'invalidityDate',
        u'cRLDistributionPoints',
        u'CRLDistPointsSyntax',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'issuingDistributionPoint',
        u'IssuingDistPointSyntax',
        u'certificateIssuer',
        u'deltaCRLIndicator',
        u'BaseCRLNumber',
        u'baseUpdateTime',
        u'freshestCRL',
        u'aAissuingDistributionPoint',
        u'AAIssuingDistPointSyntax',
        u'certificateExactMatch',
        u'CertificateExactAssertion',
        u'certificateMatch',
        u'CertificateAssertion',
        u'AltNameType',
        u'CertPolicySet',
        u'certificatePairExactMatch',
        u'CertificatePairExactAssertion',
        u'certificatePairMatch',
        u'CertificatePairAssertion',
        u'certificateListExactMatch',
        u'CertificateListExactAssertion',
        u'certificateListMatch',
        u'CertificateListAssertion',
        u'algorithmIdentifierMatch',
        u'policyMatch',
        u'pkiPathMatch',
        u'PkiPathMatchSyntax',
        u'enhancedCertificateMatch',
        u'EnhancedCertificateAssertion',
        u'AltName',
        u'certExactAssertion',
        u'certAssertion',
        u'certPairExactAssertion',
        u'certPairAssertion',
        u'certListExactAssertion',
        u'certListAssertion',
        u'algorithmIdentifier',
        u'id-ce-subjectDirectoryAttributes',
        u'id-ce-subjectKeyIdentifier',
        u'id-ce-keyUsage',
        u'id-ce-privateKeyUsagePeriod',
        u'id-ce-subjectAltName',
        u'id-ce-issuerAltName',
        u'id-ce-basicConstraints',
        u'id-ce-cRLNumber',
        u'id-ce-reasonCode',
        u'id-ce-holdInstructionCode',
        u'id-ce-invalidityDate',
        u'id-ce-deltaCRLIndicator',
        u'id-ce-issuingDistributionPoint',
        u'id-ce-certificateIssuer',
        u'id-ce-nameConstraints',
        u'id-ce-cRLDistributionPoints',
        u'id-ce-certificatePolicies',
        u'id-ce-policyMappings',
        u'id-ce-authorityKeyIdentifier',
        u'id-ce-policyConstraints',
        u'id-ce-extKeyUsage',
        u'id-ce-cRLStreamIdentifier',
        u'id-ce-cRLScope',
        u'id-ce-statusReferrals',
        u'id-ce-freshestCRL',
        u'id-ce-orderedList',
        u'id-ce-baseUpdateTime',
        u'id-ce-deltaInfo',
        u'id-ce-inhibitAnyPolicy',
        u'id-ce-toBeRevoked',
        u'id-ce-revokedGroups',
        u'id-ce-expiredCertsOnCRL',
        u'id-ce-aAissuingDistributionPoint',
        u'id-ce-authorizationValidation',
        u'id-mr-certificateExactMatch',
        u'id-mr-certificateMatch',
        u'id-mr-certificatePairExactMatch',
        u'id-mr-certificatePairMatch',
        u'id-mr-certificateListExactMatch',
        u'id-mr-certificateListMatch',
        u'id-mr-algorithmIdentifierMatch',
        u'id-mr-policyMatch',
        u'id-mr-pkiPathMatch',
        u'id-mr-enhancedCertificateMatch',
        u'id-ldx-certExactAssertion',
        u'id-ldx-certAssertion',
        u'id-ldx-certPairExactAssertion',
        u'id-ldx-certPairAssertion',
        u'id-ldx-certListExactAssertion',
        u'id-ldx-certListAssertion',
        u'id-ldx-algorithmIdentifier',
        ]
    _type_ = [
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'SubjectKeyIdentifier',
        u'KeyUsage',
        u'KeyPurposeId',
        u'PrivateKeyUsagePeriod',
        u'CertificatePoliciesSyntax',
        u'PolicyInformation',
        u'CertPolicyId',
        u'PolicyQualifierInfo',
        u'CERT-POLICY-QUALIFIER',
        u'PolicyMappingsSyntax',
        u'AvlId',
        u'GeneralNames',
        u'GeneralName',
        u'OTHER-NAME',
        u'EDIPartyName',
        u'AttributesSyntax',
        u'BasicConstraintsSyntax',
        u'NameConstraintsSyntax',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'PolicyConstraintsSyntax',
        u'SkipCerts',
        u'CRLNumber',
        u'CRLScopeSyntax',
        u'PerAuthorityScope',
        u'OnlyCertificateTypes',
        u'NumberRange',
        u'BaseRevocationInfo',
        u'StatusReferrals',
        u'StatusReferral',
        u'CRLReferral',
        u'DeltaRefInfo',
        u'OTHER-REFERRAL',
        u'CRLStreamIdentifier',
        u'OrderedListSyntax',
        u'DeltaInformation',
        u'ToBeRevokedSyntax',
        u'ToBeRevokedGroup',
        u'ReasonInfo',
        u'CertificateGroup',
        u'CertificateGroupNumberRange',
        u'CertificateSerialNumbers',
        u'RevokedGroupsSyntax',
        u'RevokedGroup',
        u'RevokedCertificateGroup',
        u'ExpiredCertsOnCRL',
        u'CRLReason',
        u'HoldInstruction',
        u'CRLDistPointsSyntax',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'IssuingDistPointSyntax',
        u'BaseCRLNumber',
        u'AAIssuingDistPointSyntax',
        u'CertificateExactAssertion',
        u'CertificateAssertion',
        u'AltNameType',
        u'CertPolicySet',
        u'CertificatePairExactAssertion',
        u'CertificatePairAssertion',
        u'CertificateListExactAssertion',
        u'CertificateListAssertion',
        u'PkiPathMatchSyntax',
        u'EnhancedCertificateAssertion',
        u'AltName',
        ]
    _set_ = [
        u'SupportedPolicyQualifiers',
        ]
    _val_ = [
        u'authorityKeyIdentifier',
        u'subjectKeyIdentifier',
        u'keyUsage',
        u'extKeyUsage',
        u'privateKeyUsagePeriod',
        u'certificatePolicies',
        u'anyPolicy',
        u'policyMappings',
        u'authorizationValidation',
        u'subjectAltName',
        u'issuerAltName',
        u'subjectDirectoryAttributes',
        u'basicConstraints',
        u'nameConstraints',
        u'policyConstraints',
        u'inhibitAnyPolicy',
        u'cRLNumber',
        u'crlScope',
        u'statusReferrals',
        u'cRLStreamIdentifier',
        u'orderedList',
        u'deltaInfo',
        u'toBeRevoked',
        u'revokedGroups',
        u'expiredCertsOnCRL',
        u'reasonCode',
        u'holdInstructionCode',
        u'invalidityDate',
        u'cRLDistributionPoints',
        u'issuingDistributionPoint',
        u'certificateIssuer',
        u'deltaCRLIndicator',
        u'baseUpdateTime',
        u'freshestCRL',
        u'aAissuingDistributionPoint',
        u'certificateExactMatch',
        u'certificateMatch',
        u'certificatePairExactMatch',
        u'certificatePairMatch',
        u'certificateListExactMatch',
        u'certificateListMatch',
        u'algorithmIdentifierMatch',
        u'policyMatch',
        u'pkiPathMatch',
        u'enhancedCertificateMatch',
        u'certExactAssertion',
        u'certAssertion',
        u'certPairExactAssertion',
        u'certPairAssertion',
        u'certListExactAssertion',
        u'certListAssertion',
        u'algorithmIdentifier',
        u'id-ce-subjectDirectoryAttributes',
        u'id-ce-subjectKeyIdentifier',
        u'id-ce-keyUsage',
        u'id-ce-privateKeyUsagePeriod',
        u'id-ce-subjectAltName',
        u'id-ce-issuerAltName',
        u'id-ce-basicConstraints',
        u'id-ce-cRLNumber',
        u'id-ce-reasonCode',
        u'id-ce-holdInstructionCode',
        u'id-ce-invalidityDate',
        u'id-ce-deltaCRLIndicator',
        u'id-ce-issuingDistributionPoint',
        u'id-ce-certificateIssuer',
        u'id-ce-nameConstraints',
        u'id-ce-cRLDistributionPoints',
        u'id-ce-certificatePolicies',
        u'id-ce-policyMappings',
        u'id-ce-authorityKeyIdentifier',
        u'id-ce-policyConstraints',
        u'id-ce-extKeyUsage',
        u'id-ce-cRLStreamIdentifier',
        u'id-ce-cRLScope',
        u'id-ce-statusReferrals',
        u'id-ce-freshestCRL',
        u'id-ce-orderedList',
        u'id-ce-baseUpdateTime',
        u'id-ce-deltaInfo',
        u'id-ce-inhibitAnyPolicy',
        u'id-ce-toBeRevoked',
        u'id-ce-revokedGroups',
        u'id-ce-expiredCertsOnCRL',
        u'id-ce-aAissuingDistributionPoint',
        u'id-ce-authorizationValidation',
        u'id-mr-certificateExactMatch',
        u'id-mr-certificateMatch',
        u'id-mr-certificatePairExactMatch',
        u'id-mr-certificatePairMatch',
        u'id-mr-certificateListExactMatch',
        u'id-mr-certificateListMatch',
        u'id-mr-algorithmIdentifierMatch',
        u'id-mr-policyMatch',
        u'id-mr-pkiPathMatch',
        u'id-mr-enhancedCertificateMatch',
        u'id-ldx-certExactAssertion',
        u'id-ldx-certAssertion',
        u'id-ldx-certPairExactAssertion',
        u'id-ldx-certPairAssertion',
        u'id-ldx-certListExactAssertion',
        u'id-ldx-certListAssertion',
        u'id-ldx-algorithmIdentifier',
        ]
    _class_ = [
        u'authorityKeyIdentifier',
        u'subjectKeyIdentifier',
        u'keyUsage',
        u'extKeyUsage',
        u'privateKeyUsagePeriod',
        u'certificatePolicies',
        u'SupportedPolicyQualifiers',
        u'CERT-POLICY-QUALIFIER',
        u'policyMappings',
        u'authorizationValidation',
        u'subjectAltName',
        u'OTHER-NAME',
        u'issuerAltName',
        u'subjectDirectoryAttributes',
        u'basicConstraints',
        u'nameConstraints',
        u'policyConstraints',
        u'inhibitAnyPolicy',
        u'cRLNumber',
        u'crlScope',
        u'statusReferrals',
        u'OTHER-REFERRAL',
        u'cRLStreamIdentifier',
        u'orderedList',
        u'deltaInfo',
        u'toBeRevoked',
        u'revokedGroups',
        u'expiredCertsOnCRL',
        u'reasonCode',
        u'holdInstructionCode',
        u'invalidityDate',
        u'cRLDistributionPoints',
        u'issuingDistributionPoint',
        u'certificateIssuer',
        u'deltaCRLIndicator',
        u'baseUpdateTime',
        u'freshestCRL',
        u'aAissuingDistributionPoint',
        u'certificateExactMatch',
        u'certificateMatch',
        u'certificatePairExactMatch',
        u'certificatePairMatch',
        u'certificateListExactMatch',
        u'certificateListMatch',
        u'algorithmIdentifierMatch',
        u'policyMatch',
        u'pkiPathMatch',
        u'enhancedCertificateMatch',
        u'certExactAssertion',
        u'certAssertion',
        u'certPairExactAssertion',
        u'certPairAssertion',
        u'certListExactAssertion',
        u'certListAssertion',
        u'algorithmIdentifier',
        ]
    _param_ = [
        ]
    
    #-----< authorityKeyIdentifier >-----#
    authorityKeyIdentifier = CLASS(name=u'authorityKeyIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _authorityKeyIdentifier_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'AuthorityKeyIdentifier')))
    authorityKeyIdentifier._val = dict([(u'ExtnType', _authorityKeyIdentifier_val_ExtnType), (u'id', (2, 5, 29, 35))])
    
    #-----< AuthorityKeyIdentifier >-----#
    AuthorityKeyIdentifier = SEQ(name=u'AuthorityKeyIdentifier', mode=MODE_TYPE)
    _AuthorityKeyIdentifier_keyIdentifier = OCT_STR(name=u'keyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'KeyIdentifier')), opt=True)
    _AuthorityKeyIdentifier_authorityCertIssuer = SEQ_OF(name=u'authorityCertIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _AuthorityKeyIdentifier_authorityCertSerialNumber = INT(name=u'authorityCertSerialNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')), opt=True)
    AuthorityKeyIdentifier._cont = ASN1Dict([
        (u'keyIdentifier', _AuthorityKeyIdentifier_keyIdentifier),
        (u'authorityCertIssuer', _AuthorityKeyIdentifier_authorityCertIssuer),
        (u'authorityCertSerialNumber', _AuthorityKeyIdentifier_authorityCertSerialNumber),
        ])
    AuthorityKeyIdentifier._ext = []
    
    #-----< KeyIdentifier >-----#
    KeyIdentifier = OCT_STR(name=u'KeyIdentifier', mode=MODE_TYPE)
    
    #-----< subjectKeyIdentifier >-----#
    subjectKeyIdentifier = CLASS(name=u'subjectKeyIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _subjectKeyIdentifier_val_ExtnType = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'SubjectKeyIdentifier')))
    subjectKeyIdentifier._val = dict([(u'ExtnType', _subjectKeyIdentifier_val_ExtnType), (u'id', (2, 5, 29, 14))])
    
    #-----< SubjectKeyIdentifier >-----#
    SubjectKeyIdentifier = OCT_STR(name=u'SubjectKeyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'KeyIdentifier')))
    
    #-----< keyUsage >-----#
    keyUsage = CLASS(name=u'keyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _keyUsage_val_ExtnType = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'KeyUsage')))
    keyUsage._val = dict([(u'ExtnType', _keyUsage_val_ExtnType), (u'id', (2, 5, 29, 15))])
    
    #-----< KeyUsage >-----#
    KeyUsage = BIT_STR(name=u'KeyUsage', mode=MODE_TYPE)
    KeyUsage._cont = ASN1Dict([(u'digitalSignature', 0), (u'contentCommitment', 1), (u'keyEncipherment', 2), (u'dataEncipherment', 3), (u'keyAgreement', 4), (u'keyCertSign', 5), (u'cRLSign', 6), (u'encipherOnly', 7), (u'decipherOnly', 8)])
    
    #-----< extKeyUsage >-----#
    extKeyUsage = CLASS(name=u'extKeyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _extKeyUsage_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE)
    __extKeyUsage_val_ExtnType__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'KeyPurposeId')))
    _extKeyUsage_val_ExtnType._cont = __extKeyUsage_val_ExtnType__item_
    _extKeyUsage_val_ExtnType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    extKeyUsage._val = dict([(u'ExtnType', _extKeyUsage_val_ExtnType), (u'id', (2, 5, 29, 37))])
    
    #-----< KeyPurposeId >-----#
    KeyPurposeId = OID(name=u'KeyPurposeId', mode=MODE_TYPE)
    
    #-----< privateKeyUsagePeriod >-----#
    privateKeyUsagePeriod = CLASS(name=u'privateKeyUsagePeriod', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _privateKeyUsagePeriod_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PrivateKeyUsagePeriod')))
    privateKeyUsagePeriod._val = dict([(u'ExtnType', _privateKeyUsagePeriod_val_ExtnType), (u'id', (2, 5, 29, 16))])
    
    #-----< PrivateKeyUsagePeriod >-----#
    PrivateKeyUsagePeriod = SEQ(name=u'PrivateKeyUsagePeriod', mode=MODE_TYPE)
    _PrivateKeyUsagePeriod_notBefore = TIME_GEN(name=u'notBefore', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PrivateKeyUsagePeriod_notAfter = TIME_GEN(name=u'notAfter', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PrivateKeyUsagePeriod._cont = ASN1Dict([
        (u'notBefore', _PrivateKeyUsagePeriod_notBefore),
        (u'notAfter', _PrivateKeyUsagePeriod_notAfter),
        ])
    PrivateKeyUsagePeriod._ext = []
    
    #-----< certificatePolicies >-----#
    certificatePolicies = CLASS(name=u'certificatePolicies', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _certificatePolicies_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePoliciesSyntax')))
    certificatePolicies._val = dict([(u'ExtnType', _certificatePolicies_val_ExtnType), (u'id', (2, 5, 29, 32))])
    
    #-----< CertificatePoliciesSyntax >-----#
    CertificatePoliciesSyntax = SEQ_OF(name=u'CertificatePoliciesSyntax', mode=MODE_TYPE)
    _CertificatePoliciesSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PolicyInformation')))
    CertificatePoliciesSyntax._cont = _CertificatePoliciesSyntax__item_
    CertificatePoliciesSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PolicyInformation >-----#
    PolicyInformation = SEQ(name=u'PolicyInformation', mode=MODE_TYPE)
    _PolicyInformation_policyIdentifier = OID(name=u'policyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    _PolicyInformation_policyQualifiers = SEQ_OF(name=u'policyQualifiers', mode=MODE_TYPE, opt=True)
    __PolicyInformation_policyQualifiers__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PolicyQualifierInfo')))
    _PolicyInformation_policyQualifiers._cont = __PolicyInformation_policyQualifiers__item_
    _PolicyInformation_policyQualifiers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PolicyInformation._cont = ASN1Dict([
        (u'policyIdentifier', _PolicyInformation_policyIdentifier),
        (u'policyQualifiers', _PolicyInformation_policyQualifiers),
        ])
    PolicyInformation._ext = []
    
    #-----< CertPolicyId >-----#
    CertPolicyId = OID(name=u'CertPolicyId', mode=MODE_TYPE)
    
    #-----< PolicyQualifierInfo >-----#
    PolicyQualifierInfo = SEQ(name=u'PolicyQualifierInfo', mode=MODE_TYPE)
    _PolicyQualifierInfo_policyQualifierId = OID(name=u'policyQualifierId', mode=MODE_TYPE, typeref=ASN1RefClassField(('CertificateExtensions', 'CERT-POLICY-QUALIFIER'), [u'id']))
    __PolicyQualifierInfo_policyQualifierId_tab = CLASS(name='_tab_CERT-POLICY-QUALIFIER', mode=MODE_SET, typeref=ASN1RefType(('CertificateExtensions', 'CERT-POLICY-QUALIFIER')))
    __PolicyQualifierInfo_policyQualifierId_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PolicyQualifierInfo_policyQualifierId._const_tab = __PolicyQualifierInfo_policyQualifierId_tab
    _PolicyQualifierInfo_policyQualifierId._const_tab_at = None
    _PolicyQualifierInfo_policyQualifierId._const_tab_id = u'id'
    _PolicyQualifierInfo_qualifier = OPEN(name=u'qualifier', mode=MODE_TYPE, typeref=ASN1RefClassField(('CertificateExtensions', 'CERT-POLICY-QUALIFIER'), [u'Qualifier']), opt=True)
    __PolicyQualifierInfo_qualifier_tab = CLASS(name='_tab_CERT-POLICY-QUALIFIER', mode=MODE_SET, typeref=ASN1RefType(('CertificateExtensions', 'CERT-POLICY-QUALIFIER')))
    __PolicyQualifierInfo_qualifier_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PolicyQualifierInfo_qualifier._const_tab = __PolicyQualifierInfo_qualifier_tab
    _PolicyQualifierInfo_qualifier._const_tab_at = ('..', u'policyQualifierId')
    _PolicyQualifierInfo_qualifier._const_tab_id = u'Qualifier'
    PolicyQualifierInfo._cont = ASN1Dict([
        (u'policyQualifierId', _PolicyQualifierInfo_policyQualifierId),
        (u'qualifier', _PolicyQualifierInfo_qualifier),
        ])
    PolicyQualifierInfo._ext = []
    
    #-----< SupportedPolicyQualifiers >-----#
    SupportedPolicyQualifiers = CLASS(name=u'SupportedPolicyQualifiers', mode=MODE_SET, typeref=ASN1RefType(('CertificateExtensions', 'CERT-POLICY-QUALIFIER')))
    SupportedPolicyQualifiers._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< anyPolicy >-----#
    anyPolicy = OID(name=u'anyPolicy', mode=MODE_VALUE)
    anyPolicy._val = (2, 5, 29, 32, 0)
    
    #-----< CERT-POLICY-QUALIFIER >-----#
    CERT_POLICY_QUALIFIER = CLASS(name=u'CERT-POLICY-QUALIFIER', mode=MODE_TYPE)
    _CERT_POLICY_QUALIFIER_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _CERT_POLICY_QUALIFIER_Qualifier = OPEN(name=u'Qualifier', mode=MODE_TYPE, opt=True)
    CERT_POLICY_QUALIFIER._cont = ASN1Dict([
        (u'id', _CERT_POLICY_QUALIFIER_id),
        (u'Qualifier', _CERT_POLICY_QUALIFIER_Qualifier),
        ])
    
    #-----< policyMappings >-----#
    policyMappings = CLASS(name=u'policyMappings', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _policyMappings_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PolicyMappingsSyntax')))
    policyMappings._val = dict([(u'ExtnType', _policyMappings_val_ExtnType), (u'id', (2, 5, 29, 33))])
    
    #-----< PolicyMappingsSyntax >-----#
    PolicyMappingsSyntax = SEQ_OF(name=u'PolicyMappingsSyntax', mode=MODE_TYPE)
    _PolicyMappingsSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __PolicyMappingsSyntax__item__issuerDomainPolicy = OID(name=u'issuerDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    __PolicyMappingsSyntax__item__subjectDomainPolicy = OID(name=u'subjectDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    _PolicyMappingsSyntax__item_._cont = ASN1Dict([
        (u'issuerDomainPolicy', __PolicyMappingsSyntax__item__issuerDomainPolicy),
        (u'subjectDomainPolicy', __PolicyMappingsSyntax__item__subjectDomainPolicy),
        ])
    _PolicyMappingsSyntax__item_._ext = []
    PolicyMappingsSyntax._cont = _PolicyMappingsSyntax__item_
    PolicyMappingsSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< authorizationValidation >-----#
    authorizationValidation = CLASS(name=u'authorizationValidation', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _authorizationValidation_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'AvlId')))
    authorizationValidation._val = dict([(u'ExtnType', _authorizationValidation_val_ExtnType), (u'id', (2, 5, 29, 70))])
    
    #-----< AvlId >-----#
    AvlId = SEQ(name=u'AvlId', mode=MODE_TYPE)
    _AvlId_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _AvlId_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AvlSerialNumber')), opt=True)
    AvlId._cont = ASN1Dict([
        (u'issuer', _AvlId_issuer),
        (u'serialNumber', _AvlId_serialNumber),
        ])
    AvlId._ext = []
    
    #-----< subjectAltName >-----#
    subjectAltName = CLASS(name=u'subjectAltName', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _subjectAltName_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    subjectAltName._val = dict([(u'ExtnType', _subjectAltName_val_ExtnType), (u'id', (2, 5, 29, 17))])
    
    #-----< GeneralNames >-----#
    GeneralNames = SEQ_OF(name=u'GeneralNames', mode=MODE_TYPE)
    _GeneralNames__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    GeneralNames._cont = _GeneralNames__item_
    GeneralNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralName >-----#
    GeneralName = CHOICE(name=u'GeneralName', mode=MODE_TYPE)
    _GeneralName_otherName = SEQ(name=u'otherName', mode=MODE_TYPE)
    __GeneralName_otherName_type_id = OID(name='type-id', mode=MODE_TYPE, typeref=ASN1RefClassField(('CertificateExtensions', 'OTHER-NAME'), ['id']))
    __GeneralName_otherName_value = OPEN(name='value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('CertificateExtensions', 'OTHER-NAME'), ['Type']))
    _GeneralName_otherName._cont = ASN1Dict([
        ('type-id', __GeneralName_otherName_type_id),
        ('value', __GeneralName_otherName_value),
        ])
    _GeneralName_otherName._ext = None
    _GeneralName_otherName.TAG = 8
    _GeneralName_rfc822Name = STR_IA5(name=u'rfc822Name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_dNSName = STR_IA5(name=u'dNSName', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_x400Address = SEQ(name=u'x400Address', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PkiPmiExternalDataTypes', 'ORAddress')))
    _GeneralName_directoryName = CHOICE(name=u'directoryName', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _GeneralName_ediPartyName = SEQ(name=u'ediPartyName', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'EDIPartyName')))
    _GeneralName_uniformResourceIdentifier = STR_IA5(name=u'uniformResourceIdentifier', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_iPAddress = OCT_STR(name=u'iPAddress', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_registeredID = OID(name=u'registeredID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GeneralName._cont = ASN1Dict([
        (u'otherName', _GeneralName_otherName),
        (u'rfc822Name', _GeneralName_rfc822Name),
        (u'dNSName', _GeneralName_dNSName),
        (u'x400Address', _GeneralName_x400Address),
        (u'directoryName', _GeneralName_directoryName),
        (u'ediPartyName', _GeneralName_ediPartyName),
        (u'uniformResourceIdentifier', _GeneralName_uniformResourceIdentifier),
        (u'iPAddress', _GeneralName_iPAddress),
        (u'registeredID', _GeneralName_registeredID),
        ])
    GeneralName._ext = []
    
    #-----< OTHER-NAME >-----#
    OTHER_NAME = CLASS(name=u'OTHER-NAME', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< EDIPartyName >-----#
    EDIPartyName = SEQ(name=u'EDIPartyName', mode=MODE_TYPE)
    _EDIPartyName_nameAssigner = CHOICE(name=u'nameAssigner', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')), opt=True)
    _EDIPartyName_partyName = CHOICE(name=u'partyName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    EDIPartyName._cont = ASN1Dict([
        (u'nameAssigner', _EDIPartyName_nameAssigner),
        (u'partyName', _EDIPartyName_partyName),
        ])
    EDIPartyName._ext = []
    
    #-----< issuerAltName >-----#
    issuerAltName = CLASS(name=u'issuerAltName', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _issuerAltName_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    issuerAltName._val = dict([(u'ExtnType', _issuerAltName_val_ExtnType), (u'id', (2, 5, 29, 18))])
    
    #-----< subjectDirectoryAttributes >-----#
    subjectDirectoryAttributes = CLASS(name=u'subjectDirectoryAttributes', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _subjectDirectoryAttributes_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'AttributesSyntax')))
    subjectDirectoryAttributes._val = dict([(u'ExtnType', _subjectDirectoryAttributes_val_ExtnType), (u'id', (2, 5, 29, 9))])
    
    #-----< AttributesSyntax >-----#
    AttributesSyntax = SEQ_OF(name=u'AttributesSyntax', mode=MODE_TYPE)
    _AttributesSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    __AttributesSyntax__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ___AttributesSyntax__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ____AttributesSyntax__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    ____AttributesSyntax__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0 = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ___AttributesSyntax__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', ____AttributesSyntax__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ____AttributesSyntax__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    __AttributesSyntax__item__type._const_tab = ___AttributesSyntax__item__type_tab
    __AttributesSyntax__item__type._const_tab_at = None
    __AttributesSyntax__item__type._const_tab_id = u'id'
    __AttributesSyntax__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ___AttributesSyntax__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ___AttributesSyntax__item__values__item_._const_tab = ___AttributesSyntax__item__type_tab
    ___AttributesSyntax__item__values__item_._const_tab_at = ('..', '..', u'type')
    ___AttributesSyntax__item__values__item_._const_tab_id = u'Type'
    __AttributesSyntax__item__values._cont = ___AttributesSyntax__item__values__item_
    __AttributesSyntax__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    __AttributesSyntax__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ___AttributesSyntax__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ____AttributesSyntax__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AttributesSyntax__item__valuesWithContext__item__value._const_tab = ___AttributesSyntax__item__type_tab
    ____AttributesSyntax__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ____AttributesSyntax__item__valuesWithContext__item__value._const_tab_id = u'Type'
    ____AttributesSyntax__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _____AttributesSyntax__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ____AttributesSyntax__item__valuesWithContext__item__contextList._cont = _____AttributesSyntax__item__valuesWithContext__item__contextList__item_
    ____AttributesSyntax__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___AttributesSyntax__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ____AttributesSyntax__item__valuesWithContext__item__value),
        (u'contextList', ____AttributesSyntax__item__valuesWithContext__item__contextList),
        ])
    ___AttributesSyntax__item__valuesWithContext__item_._ext = []
    __AttributesSyntax__item__valuesWithContext._cont = ___AttributesSyntax__item__valuesWithContext__item_
    __AttributesSyntax__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _AttributesSyntax__item_._cont = ASN1Dict([
        (u'type', __AttributesSyntax__item__type),
        (u'values', __AttributesSyntax__item__values),
        (u'valuesWithContext', __AttributesSyntax__item__valuesWithContext),
        ])
    _AttributesSyntax__item_._ext = []
    AttributesSyntax._cont = _AttributesSyntax__item_
    AttributesSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< basicConstraints >-----#
    basicConstraints = CLASS(name=u'basicConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _basicConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'BasicConstraintsSyntax')))
    basicConstraints._val = dict([(u'ExtnType', _basicConstraints_val_ExtnType), (u'id', (2, 5, 29, 19))])
    
    #-----< BasicConstraintsSyntax >-----#
    BasicConstraintsSyntax = SEQ(name=u'BasicConstraintsSyntax', mode=MODE_TYPE)
    _BasicConstraintsSyntax_cA = BOOL(name=u'cA', mode=MODE_TYPE, default=False)
    _BasicConstraintsSyntax_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _BasicConstraintsSyntax_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    BasicConstraintsSyntax._cont = ASN1Dict([
        (u'cA', _BasicConstraintsSyntax_cA),
        (u'pathLenConstraint', _BasicConstraintsSyntax_pathLenConstraint),
        ])
    BasicConstraintsSyntax._ext = []
    
    #-----< nameConstraints >-----#
    nameConstraints = CLASS(name=u'nameConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _nameConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')))
    nameConstraints._val = dict([(u'ExtnType', _nameConstraints_val_ExtnType), (u'id', (2, 5, 29, 30))])
    
    #-----< NameConstraintsSyntax >-----#
    NameConstraintsSyntax = SEQ(name=u'NameConstraintsSyntax', mode=MODE_TYPE)
    _NameConstraintsSyntax_permittedSubtrees = SEQ_OF(name=u'permittedSubtrees', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralSubtrees')), opt=True)
    _NameConstraintsSyntax_excludedSubtrees = SEQ_OF(name=u'excludedSubtrees', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralSubtrees')), opt=True)
    NameConstraintsSyntax._cont = ASN1Dict([
        (u'permittedSubtrees', _NameConstraintsSyntax_permittedSubtrees),
        (u'excludedSubtrees', _NameConstraintsSyntax_excludedSubtrees),
        ])
    NameConstraintsSyntax._ext = []
    
    #-----< GeneralSubtrees >-----#
    GeneralSubtrees = SEQ_OF(name=u'GeneralSubtrees', mode=MODE_TYPE)
    _GeneralSubtrees__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralSubtree')))
    GeneralSubtrees._cont = _GeneralSubtrees__item_
    GeneralSubtrees._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralSubtree >-----#
    GeneralSubtree = SEQ(name=u'GeneralSubtree', mode=MODE_TYPE)
    _GeneralSubtree_base = CHOICE(name=u'base', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _GeneralSubtree_minimum = INT(name=u'minimum', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'BaseDistance')), default=0)
    _GeneralSubtree_maximum = INT(name=u'maximum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'BaseDistance')), opt=True)
    GeneralSubtree._cont = ASN1Dict([
        (u'base', _GeneralSubtree_base),
        (u'minimum', _GeneralSubtree_minimum),
        (u'maximum', _GeneralSubtree_maximum),
        ])
    GeneralSubtree._ext = []
    
    #-----< BaseDistance >-----#
    BaseDistance = INT(name=u'BaseDistance', mode=MODE_TYPE)
    BaseDistance._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< policyConstraints >-----#
    policyConstraints = CLASS(name=u'policyConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _policyConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PolicyConstraintsSyntax')))
    policyConstraints._val = dict([(u'ExtnType', _policyConstraints_val_ExtnType), (u'id', (2, 5, 29, 36))])
    
    #-----< PolicyConstraintsSyntax >-----#
    PolicyConstraintsSyntax = SEQ(name=u'PolicyConstraintsSyntax', mode=MODE_TYPE)
    _PolicyConstraintsSyntax_requireExplicitPolicy = INT(name=u'requireExplicitPolicy', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'SkipCerts')), opt=True)
    _PolicyConstraintsSyntax_inhibitPolicyMapping = INT(name=u'inhibitPolicyMapping', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'SkipCerts')), opt=True)
    PolicyConstraintsSyntax._cont = ASN1Dict([
        (u'requireExplicitPolicy', _PolicyConstraintsSyntax_requireExplicitPolicy),
        (u'inhibitPolicyMapping', _PolicyConstraintsSyntax_inhibitPolicyMapping),
        ])
    PolicyConstraintsSyntax._ext = []
    
    #-----< SkipCerts >-----#
    SkipCerts = INT(name=u'SkipCerts', mode=MODE_TYPE)
    SkipCerts._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< inhibitAnyPolicy >-----#
    inhibitAnyPolicy = CLASS(name=u'inhibitAnyPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _inhibitAnyPolicy_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'SkipCerts')))
    inhibitAnyPolicy._val = dict([(u'ExtnType', _inhibitAnyPolicy_val_ExtnType), (u'id', (2, 5, 29, 54))])
    
    #-----< cRLNumber >-----#
    cRLNumber = CLASS(name=u'cRLNumber', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _cRLNumber_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')))
    cRLNumber._val = dict([(u'ExtnType', _cRLNumber_val_ExtnType), (u'id', (2, 5, 29, 20))])
    
    #-----< CRLNumber >-----#
    CRLNumber = INT(name=u'CRLNumber', mode=MODE_TYPE)
    CRLNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< crlScope >-----#
    crlScope = CLASS(name=u'crlScope', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _crlScope_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLScopeSyntax')))
    crlScope._val = dict([(u'ExtnType', _crlScope_val_ExtnType), (u'id', (2, 5, 29, 44))])
    
    #-----< CRLScopeSyntax >-----#
    CRLScopeSyntax = SEQ_OF(name=u'CRLScopeSyntax', mode=MODE_TYPE)
    _CRLScopeSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PerAuthorityScope')))
    CRLScopeSyntax._cont = _CRLScopeSyntax__item_
    CRLScopeSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PerAuthorityScope >-----#
    PerAuthorityScope = SEQ(name=u'PerAuthorityScope', mode=MODE_TYPE)
    _PerAuthorityScope_authorityName = CHOICE(name=u'authorityName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _PerAuthorityScope_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _PerAuthorityScope_onlyContains = BIT_STR(name=u'onlyContains', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'OnlyCertificateTypes')), opt=True)
    _PerAuthorityScope_onlySomeReasons = BIT_STR(name=u'onlySomeReasons', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _PerAuthorityScope_serialNumberRange = SEQ(name=u'serialNumberRange', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'NumberRange')), opt=True)
    _PerAuthorityScope_subjectKeyIdRange = SEQ(name=u'subjectKeyIdRange', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'NumberRange')), opt=True)
    _PerAuthorityScope_nameSubtrees = SEQ_OF(name=u'nameSubtrees', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _PerAuthorityScope_baseRevocationInfo = SEQ(name=u'baseRevocationInfo', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'BaseRevocationInfo')), opt=True)
    PerAuthorityScope._cont = ASN1Dict([
        (u'authorityName', _PerAuthorityScope_authorityName),
        (u'distributionPoint', _PerAuthorityScope_distributionPoint),
        (u'onlyContains', _PerAuthorityScope_onlyContains),
        (u'onlySomeReasons', _PerAuthorityScope_onlySomeReasons),
        (u'serialNumberRange', _PerAuthorityScope_serialNumberRange),
        (u'subjectKeyIdRange', _PerAuthorityScope_subjectKeyIdRange),
        (u'nameSubtrees', _PerAuthorityScope_nameSubtrees),
        (u'baseRevocationInfo', _PerAuthorityScope_baseRevocationInfo),
        ])
    PerAuthorityScope._ext = []
    
    #-----< OnlyCertificateTypes >-----#
    OnlyCertificateTypes = BIT_STR(name=u'OnlyCertificateTypes', mode=MODE_TYPE)
    OnlyCertificateTypes._cont = ASN1Dict([(u'user', 0), (u'authority', 1), (u'attribute', 2)])
    
    #-----< NumberRange >-----#
    NumberRange = SEQ(name=u'NumberRange', mode=MODE_TYPE)
    _NumberRange_startingNumber = INT(name=u'startingNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NumberRange_endingNumber = INT(name=u'endingNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NumberRange_modulus = INT(name=u'modulus', mode=MODE_TYPE, opt=True)
    NumberRange._cont = ASN1Dict([
        (u'startingNumber', _NumberRange_startingNumber),
        (u'endingNumber', _NumberRange_endingNumber),
        (u'modulus', _NumberRange_modulus),
        ])
    NumberRange._ext = []
    
    #-----< BaseRevocationInfo >-----#
    BaseRevocationInfo = SEQ(name=u'BaseRevocationInfo', mode=MODE_TYPE)
    _BaseRevocationInfo_cRLStreamIdentifier = INT(name=u'cRLStreamIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLStreamIdentifier')), opt=True)
    _BaseRevocationInfo_cRLNumber = INT(name=u'cRLNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')))
    _BaseRevocationInfo_baseThisUpdate = TIME_GEN(name=u'baseThisUpdate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    BaseRevocationInfo._cont = ASN1Dict([
        (u'cRLStreamIdentifier', _BaseRevocationInfo_cRLStreamIdentifier),
        (u'cRLNumber', _BaseRevocationInfo_cRLNumber),
        (u'baseThisUpdate', _BaseRevocationInfo_baseThisUpdate),
        ])
    BaseRevocationInfo._ext = []
    
    #-----< statusReferrals >-----#
    statusReferrals = CLASS(name=u'statusReferrals', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _statusReferrals_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'StatusReferrals')))
    statusReferrals._val = dict([(u'ExtnType', _statusReferrals_val_ExtnType), (u'id', (2, 5, 29, 45))])
    
    #-----< StatusReferrals >-----#
    StatusReferrals = SEQ_OF(name=u'StatusReferrals', mode=MODE_TYPE)
    _StatusReferrals__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'StatusReferral')))
    StatusReferrals._cont = _StatusReferrals__item_
    StatusReferrals._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< StatusReferral >-----#
    StatusReferral = CHOICE(name=u'StatusReferral', mode=MODE_TYPE)
    _StatusReferral_cRLReferral = SEQ(name=u'cRLReferral', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLReferral')))
    _StatusReferral_otherReferral = SEQ(name=u'otherReferral', mode=MODE_TYPE)
    __StatusReferral_otherReferral_type_id = OID(name='type-id', mode=MODE_TYPE, typeref=ASN1RefClassField(('CertificateExtensions', 'OTHER-REFERRAL'), ['id']))
    __StatusReferral_otherReferral_value = OPEN(name='value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('CertificateExtensions', 'OTHER-REFERRAL'), ['Type']))
    _StatusReferral_otherReferral._cont = ASN1Dict([
        ('type-id', __StatusReferral_otherReferral_type_id),
        ('value', __StatusReferral_otherReferral_value),
        ])
    _StatusReferral_otherReferral._ext = None
    _StatusReferral_otherReferral.TAG = 8
    StatusReferral._cont = ASN1Dict([
        (u'cRLReferral', _StatusReferral_cRLReferral),
        (u'otherReferral', _StatusReferral_otherReferral),
        ])
    StatusReferral._ext = []
    
    #-----< CRLReferral >-----#
    CRLReferral = SEQ(name=u'CRLReferral', mode=MODE_TYPE)
    _CRLReferral_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _CRLReferral_location = CHOICE(name=u'location', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _CRLReferral_deltaRefInfo = SEQ(name=u'deltaRefInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DeltaRefInfo')), opt=True)
    _CRLReferral_cRLScope = SEQ_OF(name=u'cRLScope', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLScopeSyntax')))
    _CRLReferral_lastUpdate = TIME_GEN(name=u'lastUpdate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CRLReferral_lastChangedCRL = TIME_GEN(name=u'lastChangedCRL', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    CRLReferral._cont = ASN1Dict([
        (u'issuer', _CRLReferral_issuer),
        (u'location', _CRLReferral_location),
        (u'deltaRefInfo', _CRLReferral_deltaRefInfo),
        (u'cRLScope', _CRLReferral_cRLScope),
        (u'lastUpdate', _CRLReferral_lastUpdate),
        (u'lastChangedCRL', _CRLReferral_lastChangedCRL),
        ])
    CRLReferral._ext = []
    
    #-----< DeltaRefInfo >-----#
    DeltaRefInfo = SEQ(name=u'DeltaRefInfo', mode=MODE_TYPE)
    _DeltaRefInfo_deltaLocation = CHOICE(name=u'deltaLocation', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _DeltaRefInfo_lastDelta = TIME_GEN(name=u'lastDelta', mode=MODE_TYPE, opt=True)
    DeltaRefInfo._cont = ASN1Dict([
        (u'deltaLocation', _DeltaRefInfo_deltaLocation),
        (u'lastDelta', _DeltaRefInfo_lastDelta),
        ])
    DeltaRefInfo._ext = []
    
    #-----< OTHER-REFERRAL >-----#
    OTHER_REFERRAL = CLASS(name=u'OTHER-REFERRAL', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< cRLStreamIdentifier >-----#
    cRLStreamIdentifier = CLASS(name=u'cRLStreamIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _cRLStreamIdentifier_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLStreamIdentifier')))
    cRLStreamIdentifier._val = dict([(u'ExtnType', _cRLStreamIdentifier_val_ExtnType), (u'id', (2, 5, 29, 40))])
    
    #-----< CRLStreamIdentifier >-----#
    CRLStreamIdentifier = INT(name=u'CRLStreamIdentifier', mode=MODE_TYPE)
    CRLStreamIdentifier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< orderedList >-----#
    orderedList = CLASS(name=u'orderedList', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _orderedList_val_ExtnType = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'OrderedListSyntax')))
    orderedList._val = dict([(u'ExtnType', _orderedList_val_ExtnType), (u'id', (2, 5, 29, 47))])
    
    #-----< OrderedListSyntax >-----#
    OrderedListSyntax = ENUM(name=u'OrderedListSyntax', mode=MODE_TYPE)
    OrderedListSyntax._cont = ASN1Dict([(u'ascSerialNum', 0), (u'ascRevDate', 1)])
    OrderedListSyntax._ext = []
    
    #-----< deltaInfo >-----#
    deltaInfo = CLASS(name=u'deltaInfo', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _deltaInfo_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'DeltaInformation')))
    deltaInfo._val = dict([(u'ExtnType', _deltaInfo_val_ExtnType), (u'id', (2, 5, 29, 53))])
    
    #-----< DeltaInformation >-----#
    DeltaInformation = SEQ(name=u'DeltaInformation', mode=MODE_TYPE)
    _DeltaInformation_deltaLocation = CHOICE(name=u'deltaLocation', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _DeltaInformation_nextDelta = TIME_GEN(name=u'nextDelta', mode=MODE_TYPE, opt=True)
    DeltaInformation._cont = ASN1Dict([
        (u'deltaLocation', _DeltaInformation_deltaLocation),
        (u'nextDelta', _DeltaInformation_nextDelta),
        ])
    DeltaInformation._ext = []
    
    #-----< toBeRevoked >-----#
    toBeRevoked = CLASS(name=u'toBeRevoked', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _toBeRevoked_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'ToBeRevokedSyntax')))
    toBeRevoked._val = dict([(u'ExtnType', _toBeRevoked_val_ExtnType), (u'id', (2, 5, 29, 58))])
    
    #-----< ToBeRevokedSyntax >-----#
    ToBeRevokedSyntax = SEQ_OF(name=u'ToBeRevokedSyntax', mode=MODE_TYPE)
    _ToBeRevokedSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'ToBeRevokedGroup')))
    ToBeRevokedSyntax._cont = _ToBeRevokedSyntax__item_
    ToBeRevokedSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< ToBeRevokedGroup >-----#
    ToBeRevokedGroup = SEQ(name=u'ToBeRevokedGroup', mode=MODE_TYPE)
    _ToBeRevokedGroup_certificateIssuer = CHOICE(name=u'certificateIssuer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _ToBeRevokedGroup_reasonInfo = SEQ(name=u'reasonInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonInfo')), opt=True)
    _ToBeRevokedGroup_revocationTime = TIME_GEN(name=u'revocationTime', mode=MODE_TYPE)
    _ToBeRevokedGroup_certificateGroup = CHOICE(name=u'certificateGroup', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateGroup')))
    ToBeRevokedGroup._cont = ASN1Dict([
        (u'certificateIssuer', _ToBeRevokedGroup_certificateIssuer),
        (u'reasonInfo', _ToBeRevokedGroup_reasonInfo),
        (u'revocationTime', _ToBeRevokedGroup_revocationTime),
        (u'certificateGroup', _ToBeRevokedGroup_certificateGroup),
        ])
    ToBeRevokedGroup._ext = []
    
    #-----< ReasonInfo >-----#
    ReasonInfo = SEQ(name=u'ReasonInfo', mode=MODE_TYPE)
    _ReasonInfo_reasonCode = ENUM(name=u'reasonCode', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLReason')))
    _ReasonInfo_holdInstructionCode = OID(name=u'holdInstructionCode', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'HoldInstruction')), opt=True)
    ReasonInfo._cont = ASN1Dict([
        (u'reasonCode', _ReasonInfo_reasonCode),
        (u'holdInstructionCode', _ReasonInfo_holdInstructionCode),
        ])
    ReasonInfo._ext = []
    
    #-----< CertificateGroup >-----#
    CertificateGroup = CHOICE(name=u'CertificateGroup', mode=MODE_TYPE)
    _CertificateGroup_serialNumbers = SEQ_OF(name=u'serialNumbers', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateSerialNumbers')))
    _CertificateGroup_serialNumberRange = SEQ(name=u'serialNumberRange', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateGroupNumberRange')))
    _CertificateGroup_nameSubtree = CHOICE(name=u'nameSubtree', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    CertificateGroup._cont = ASN1Dict([
        (u'serialNumbers', _CertificateGroup_serialNumbers),
        (u'serialNumberRange', _CertificateGroup_serialNumberRange),
        (u'nameSubtree', _CertificateGroup_nameSubtree),
        ])
    CertificateGroup._ext = []
    
    #-----< CertificateGroupNumberRange >-----#
    CertificateGroupNumberRange = SEQ(name=u'CertificateGroupNumberRange', mode=MODE_TYPE)
    _CertificateGroupNumberRange_startingNumber = INT(name=u'startingNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CertificateGroupNumberRange_endingNumber = INT(name=u'endingNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    CertificateGroupNumberRange._cont = ASN1Dict([
        (u'startingNumber', _CertificateGroupNumberRange_startingNumber),
        (u'endingNumber', _CertificateGroupNumberRange_endingNumber),
        ])
    CertificateGroupNumberRange._ext = []
    
    #-----< CertificateSerialNumbers >-----#
    CertificateSerialNumbers = SEQ_OF(name=u'CertificateSerialNumbers', mode=MODE_TYPE)
    _CertificateSerialNumbers__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    CertificateSerialNumbers._cont = _CertificateSerialNumbers__item_
    CertificateSerialNumbers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< revokedGroups >-----#
    revokedGroups = CLASS(name=u'revokedGroups', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _revokedGroups_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'RevokedGroupsSyntax')))
    revokedGroups._val = dict([(u'ExtnType', _revokedGroups_val_ExtnType), (u'id', (2, 5, 29, 59))])
    
    #-----< RevokedGroupsSyntax >-----#
    RevokedGroupsSyntax = SEQ_OF(name=u'RevokedGroupsSyntax', mode=MODE_TYPE)
    _RevokedGroupsSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'RevokedGroup')))
    RevokedGroupsSyntax._cont = _RevokedGroupsSyntax__item_
    RevokedGroupsSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< RevokedGroup >-----#
    RevokedGroup = SEQ(name=u'RevokedGroup', mode=MODE_TYPE)
    _RevokedGroup_certificateIssuer = CHOICE(name=u'certificateIssuer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _RevokedGroup_reasonInfo = SEQ(name=u'reasonInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonInfo')), opt=True)
    _RevokedGroup_invalidityDate = TIME_GEN(name=u'invalidityDate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RevokedGroup_revokedcertificateGroup = CHOICE(name=u'revokedcertificateGroup', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'RevokedCertificateGroup')))
    RevokedGroup._cont = ASN1Dict([
        (u'certificateIssuer', _RevokedGroup_certificateIssuer),
        (u'reasonInfo', _RevokedGroup_reasonInfo),
        (u'invalidityDate', _RevokedGroup_invalidityDate),
        (u'revokedcertificateGroup', _RevokedGroup_revokedcertificateGroup),
        ])
    RevokedGroup._ext = []
    
    #-----< RevokedCertificateGroup >-----#
    RevokedCertificateGroup = CHOICE(name=u'RevokedCertificateGroup', mode=MODE_TYPE)
    _RevokedCertificateGroup_serialNumberRange = SEQ(name=u'serialNumberRange', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'NumberRange')))
    _RevokedCertificateGroup_nameSubtree = CHOICE(name=u'nameSubtree', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    RevokedCertificateGroup._cont = ASN1Dict([
        (u'serialNumberRange', _RevokedCertificateGroup_serialNumberRange),
        (u'nameSubtree', _RevokedCertificateGroup_nameSubtree),
        ])
    RevokedCertificateGroup._ext = None
    
    #-----< expiredCertsOnCRL >-----#
    expiredCertsOnCRL = CLASS(name=u'expiredCertsOnCRL', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _expiredCertsOnCRL_val_ExtnType = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'ExpiredCertsOnCRL')))
    expiredCertsOnCRL._val = dict([(u'ExtnType', _expiredCertsOnCRL_val_ExtnType), (u'id', (2, 5, 29, 60))])
    
    #-----< ExpiredCertsOnCRL >-----#
    ExpiredCertsOnCRL = TIME_GEN(name=u'ExpiredCertsOnCRL', mode=MODE_TYPE)
    
    #-----< reasonCode >-----#
    reasonCode = CLASS(name=u'reasonCode', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _reasonCode_val_ExtnType = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLReason')))
    reasonCode._val = dict([(u'ExtnType', _reasonCode_val_ExtnType), (u'id', (2, 5, 29, 21))])
    
    #-----< CRLReason >-----#
    CRLReason = ENUM(name=u'CRLReason', mode=MODE_TYPE)
    CRLReason._cont = ASN1Dict([(u'unspecified', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'removeFromCRL', 8), (u'privilegeWithdrawn', 9), (u'aACompromise', 10), (u'weakAlgorithmOrKey', 11)])
    CRLReason._ext = [u'weakAlgorithmOrKey']
    
    #-----< holdInstructionCode >-----#
    holdInstructionCode = CLASS(name=u'holdInstructionCode', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _holdInstructionCode_val_ExtnType = OID(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'HoldInstruction')))
    holdInstructionCode._val = dict([(u'ExtnType', _holdInstructionCode_val_ExtnType), (u'id', (2, 5, 29, 23))])
    
    #-----< HoldInstruction >-----#
    HoldInstruction = OID(name=u'HoldInstruction', mode=MODE_TYPE)
    
    #-----< invalidityDate >-----#
    invalidityDate = CLASS(name=u'invalidityDate', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _invalidityDate_val_ExtnType = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    invalidityDate._val = dict([(u'ExtnType', _invalidityDate_val_ExtnType), (u'id', (2, 5, 29, 24))])
    
    #-----< cRLDistributionPoints >-----#
    cRLDistributionPoints = CLASS(name=u'cRLDistributionPoints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _cRLDistributionPoints_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLDistPointsSyntax')))
    cRLDistributionPoints._val = dict([(u'ExtnType', _cRLDistributionPoints_val_ExtnType), (u'id', (2, 5, 29, 31))])
    
    #-----< CRLDistPointsSyntax >-----#
    CRLDistPointsSyntax = SEQ_OF(name=u'CRLDistPointsSyntax', mode=MODE_TYPE)
    _CRLDistPointsSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'DistributionPoint')))
    CRLDistPointsSyntax._cont = _CRLDistPointsSyntax__item_
    CRLDistPointsSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< DistributionPoint >-----#
    DistributionPoint = SEQ(name=u'DistributionPoint', mode=MODE_TYPE)
    _DistributionPoint_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _DistributionPoint_reasons = BIT_STR(name=u'reasons', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _DistributionPoint_cRLIssuer = SEQ_OF(name=u'cRLIssuer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    DistributionPoint._cont = ASN1Dict([
        (u'distributionPoint', _DistributionPoint_distributionPoint),
        (u'reasons', _DistributionPoint_reasons),
        (u'cRLIssuer', _DistributionPoint_cRLIssuer),
        ])
    DistributionPoint._ext = []
    
    #-----< DistributionPointName >-----#
    DistributionPointName = CHOICE(name=u'DistributionPointName', mode=MODE_TYPE)
    _DistributionPointName_fullName = SEQ_OF(name=u'fullName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    _DistributionPointName_nameRelativeToCRLIssuer = SET_OF(name=u'nameRelativeToCRLIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'RelativeDistinguishedName')))
    DistributionPointName._cont = ASN1Dict([
        (u'fullName', _DistributionPointName_fullName),
        (u'nameRelativeToCRLIssuer', _DistributionPointName_nameRelativeToCRLIssuer),
        ])
    DistributionPointName._ext = []
    
    #-----< ReasonFlags >-----#
    ReasonFlags = BIT_STR(name=u'ReasonFlags', mode=MODE_TYPE)
    ReasonFlags._cont = ASN1Dict([(u'unused', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'privilegeWithdrawn', 7), (u'aACompromise', 8), (u'weakAlgorithmOrKey', 9)])
    
    #-----< issuingDistributionPoint >-----#
    issuingDistributionPoint = CLASS(name=u'issuingDistributionPoint', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _issuingDistributionPoint_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'IssuingDistPointSyntax')))
    issuingDistributionPoint._val = dict([(u'ExtnType', _issuingDistributionPoint_val_ExtnType), (u'id', (2, 5, 29, 28))])
    
    #-----< IssuingDistPointSyntax >-----#
    IssuingDistPointSyntax = SEQ(name=u'IssuingDistPointSyntax', mode=MODE_TYPE)
    _IssuingDistPointSyntax_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _IssuingDistPointSyntax_onlyContainsUserPublicKeyCerts = BOOL(name=u'onlyContainsUserPublicKeyCerts', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistPointSyntax_onlyContainsCACerts = BOOL(name=u'onlyContainsCACerts', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistPointSyntax_onlySomeReasons = BIT_STR(name=u'onlySomeReasons', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _IssuingDistPointSyntax_indirectCRL = BOOL(name=u'indirectCRL', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistPointSyntax_onlyContainsAttributeCerts = BOOL(name=u'onlyContainsAttributeCerts', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    IssuingDistPointSyntax._cont = ASN1Dict([
        (u'distributionPoint', _IssuingDistPointSyntax_distributionPoint),
        (u'onlyContainsUserPublicKeyCerts', _IssuingDistPointSyntax_onlyContainsUserPublicKeyCerts),
        (u'onlyContainsCACerts', _IssuingDistPointSyntax_onlyContainsCACerts),
        (u'onlySomeReasons', _IssuingDistPointSyntax_onlySomeReasons),
        (u'indirectCRL', _IssuingDistPointSyntax_indirectCRL),
        (u'onlyContainsAttributeCerts', _IssuingDistPointSyntax_onlyContainsAttributeCerts),
        ])
    IssuingDistPointSyntax._ext = []
    
    #-----< certificateIssuer >-----#
    certificateIssuer = CLASS(name=u'certificateIssuer', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _certificateIssuer_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    certificateIssuer._val = dict([(u'ExtnType', _certificateIssuer_val_ExtnType), (u'id', (2, 5, 29, 29))])
    
    #-----< deltaCRLIndicator >-----#
    deltaCRLIndicator = CLASS(name=u'deltaCRLIndicator', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _deltaCRLIndicator_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'BaseCRLNumber')))
    deltaCRLIndicator._val = dict([(u'ExtnType', _deltaCRLIndicator_val_ExtnType), (u'id', (2, 5, 29, 27))])
    
    #-----< BaseCRLNumber >-----#
    BaseCRLNumber = INT(name=u'BaseCRLNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')))
    
    #-----< baseUpdateTime >-----#
    baseUpdateTime = CLASS(name=u'baseUpdateTime', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _baseUpdateTime_val_ExtnType = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    baseUpdateTime._val = dict([(u'ExtnType', _baseUpdateTime_val_ExtnType), (u'id', (2, 5, 29, 51))])
    
    #-----< freshestCRL >-----#
    freshestCRL = CLASS(name=u'freshestCRL', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _freshestCRL_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLDistPointsSyntax')))
    freshestCRL._val = dict([(u'ExtnType', _freshestCRL_val_ExtnType), (u'id', (2, 5, 29, 46))])
    
    #-----< aAissuingDistributionPoint >-----#
    aAissuingDistributionPoint = CLASS(name=u'aAissuingDistributionPoint', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _aAissuingDistributionPoint_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'AAIssuingDistPointSyntax')))
    aAissuingDistributionPoint._val = dict([(u'ExtnType', _aAissuingDistributionPoint_val_ExtnType), (u'id', (2, 5, 29, 63))])
    
    #-----< AAIssuingDistPointSyntax >-----#
    AAIssuingDistPointSyntax = SEQ(name=u'AAIssuingDistPointSyntax', mode=MODE_TYPE)
    _AAIssuingDistPointSyntax_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _AAIssuingDistPointSyntax_onlySomeReasons = BIT_STR(name=u'onlySomeReasons', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _AAIssuingDistPointSyntax_indirectCRL = BOOL(name=u'indirectCRL', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _AAIssuingDistPointSyntax_containsUserAttributeCerts = BOOL(name=u'containsUserAttributeCerts', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=True)
    _AAIssuingDistPointSyntax_containsAACerts = BOOL(name=u'containsAACerts', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=True)
    _AAIssuingDistPointSyntax_containsSOAPublicKeyCerts = BOOL(name=u'containsSOAPublicKeyCerts', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=True)
    AAIssuingDistPointSyntax._cont = ASN1Dict([
        (u'distributionPoint', _AAIssuingDistPointSyntax_distributionPoint),
        (u'onlySomeReasons', _AAIssuingDistPointSyntax_onlySomeReasons),
        (u'indirectCRL', _AAIssuingDistPointSyntax_indirectCRL),
        (u'containsUserAttributeCerts', _AAIssuingDistPointSyntax_containsUserAttributeCerts),
        (u'containsAACerts', _AAIssuingDistPointSyntax_containsAACerts),
        (u'containsSOAPublicKeyCerts', _AAIssuingDistPointSyntax_containsSOAPublicKeyCerts),
        ])
    AAIssuingDistPointSyntax._ext = []
    
    #-----< certificateExactMatch >-----#
    certificateExactMatch = CLASS(name=u'certificateExactMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificateExactMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')))
    certificateExactMatch._val = dict([(u'AssertionType', _certificateExactMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])
    
    #-----< CertificateExactAssertion >-----#
    CertificateExactAssertion = SEQ(name=u'CertificateExactAssertion', mode=MODE_TYPE)
    _CertificateExactAssertion_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _CertificateExactAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    CertificateExactAssertion._cont = ASN1Dict([
        (u'serialNumber', _CertificateExactAssertion_serialNumber),
        (u'issuer', _CertificateExactAssertion_issuer),
        ])
    CertificateExactAssertion._ext = []
    
    #-----< certificateMatch >-----#
    certificateMatch = CLASS(name=u'certificateMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificateMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateAssertion')))
    certificateMatch._val = dict([(u'AssertionType', _certificateMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 2)), (u'ldapName', [u'certificateMatch']), (u'ldapDesc', u'X.509 Certificate Match'), (u'id', (2, 5, 13, 35))])
    
    #-----< CertificateAssertion >-----#
    CertificateAssertion = SEQ(name=u'CertificateAssertion', mode=MODE_TYPE)
    _CertificateAssertion_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')), opt=True)
    _CertificateAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CertificateAssertion_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'SubjectKeyIdentifier')), opt=True)
    _CertificateAssertion_authorityKeyIdentifier = SEQ(name=u'authorityKeyIdentifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AuthorityKeyIdentifier')), opt=True)
    _CertificateAssertion_certificateValid = CHOICE(name=u'certificateValid', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Time')), opt=True)
    _CertificateAssertion_privateKeyValid = TIME_GEN(name=u'privateKeyValid', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CertificateAssertion_subjectPublicKeyAlgID = OID(name=u'subjectPublicKeyAlgID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CertificateAssertion_keyUsage = BIT_STR(name=u'keyUsage', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'KeyUsage')), opt=True)
    _CertificateAssertion_subjectAltName = CHOICE(name=u'subjectAltName', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AltNameType')), opt=True)
    _CertificateAssertion_policy = SEQ_OF(name=u'policy', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertPolicySet')), opt=True)
    _CertificateAssertion_pathToName = CHOICE(name=u'pathToName', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CertificateAssertion_subject = CHOICE(name=u'subject', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CertificateAssertion_nameConstraints = SEQ(name=u'nameConstraints', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')), opt=True)
    CertificateAssertion._cont = ASN1Dict([
        (u'serialNumber', _CertificateAssertion_serialNumber),
        (u'issuer', _CertificateAssertion_issuer),
        (u'subjectKeyIdentifier', _CertificateAssertion_subjectKeyIdentifier),
        (u'authorityKeyIdentifier', _CertificateAssertion_authorityKeyIdentifier),
        (u'certificateValid', _CertificateAssertion_certificateValid),
        (u'privateKeyValid', _CertificateAssertion_privateKeyValid),
        (u'subjectPublicKeyAlgID', _CertificateAssertion_subjectPublicKeyAlgID),
        (u'keyUsage', _CertificateAssertion_keyUsage),
        (u'subjectAltName', _CertificateAssertion_subjectAltName),
        (u'policy', _CertificateAssertion_policy),
        (u'pathToName', _CertificateAssertion_pathToName),
        (u'subject', _CertificateAssertion_subject),
        (u'nameConstraints', _CertificateAssertion_nameConstraints),
        ])
    CertificateAssertion._ext = []
    
    #-----< AltNameType >-----#
    AltNameType = CHOICE(name=u'AltNameType', mode=MODE_TYPE)
    _AltNameType_builtinNameForm = ENUM(name=u'builtinNameForm', mode=MODE_TYPE)
    _AltNameType_builtinNameForm._cont = ASN1Dict([(u'rfc822Name', 1), (u'dNSName', 2), (u'x400Address', 3), (u'directoryName', 4), (u'ediPartyName', 5), (u'uniformResourceIdentifier', 6), (u'iPAddress', 7), (u'registeredId', 8)])
    _AltNameType_builtinNameForm._ext = []
    _AltNameType_otherNameForm = OID(name=u'otherNameForm', mode=MODE_TYPE)
    AltNameType._cont = ASN1Dict([
        (u'builtinNameForm', _AltNameType_builtinNameForm),
        (u'otherNameForm', _AltNameType_otherNameForm),
        ])
    AltNameType._ext = []
    
    #-----< CertPolicySet >-----#
    CertPolicySet = SEQ_OF(name=u'CertPolicySet', mode=MODE_TYPE)
    _CertPolicySet__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    CertPolicySet._cont = _CertPolicySet__item_
    CertPolicySet._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< certificatePairExactMatch >-----#
    certificatePairExactMatch = CLASS(name=u'certificatePairExactMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificatePairExactMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairExactAssertion')))
    certificatePairExactMatch._val = dict([(u'AssertionType', _certificatePairExactMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 3)), (u'ldapName', [u'certificatePairExactMatch']), (u'ldapDesc', u'X.509 Certificate Pair Exact Match'), (u'id', (2, 5, 13, 36))])
    
    #-----< CertificatePairExactAssertion >-----#
    CertificatePairExactAssertion = SEQ(name=u'CertificatePairExactAssertion', mode=MODE_TYPE)
    _CertificatePairExactAssertion_issuedToThisCAAssertion = SEQ(name=u'issuedToThisCAAssertion', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')), opt=True)
    _CertificatePairExactAssertion_issuedByThisCAAssertion = SEQ(name=u'issuedByThisCAAssertion', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')), opt=True)
    CertificatePairExactAssertion._cont = ASN1Dict([
        (u'issuedToThisCAAssertion', _CertificatePairExactAssertion_issuedToThisCAAssertion),
        (u'issuedByThisCAAssertion', _CertificatePairExactAssertion_issuedByThisCAAssertion),
        ])
    CertificatePairExactAssertion._ext = []
    
    #-----< certificatePairMatch >-----#
    certificatePairMatch = CLASS(name=u'certificatePairMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificatePairMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairAssertion')))
    certificatePairMatch._val = dict([(u'AssertionType', _certificatePairMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 4)), (u'ldapName', [u'certificatePairMatch']), (u'ldapDesc', u'X.509 Certificate Pair Match'), (u'id', (2, 5, 13, 37))])
    
    #-----< CertificatePairAssertion >-----#
    CertificatePairAssertion = SEQ(name=u'CertificatePairAssertion', mode=MODE_TYPE)
    _CertificatePairAssertion_issuedToThisCAAssertion = SEQ(name=u'issuedToThisCAAssertion', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateAssertion')), opt=True)
    _CertificatePairAssertion_issuedByThisCAAssertion = SEQ(name=u'issuedByThisCAAssertion', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateAssertion')), opt=True)
    CertificatePairAssertion._cont = ASN1Dict([
        (u'issuedToThisCAAssertion', _CertificatePairAssertion_issuedToThisCAAssertion),
        (u'issuedByThisCAAssertion', _CertificatePairAssertion_issuedByThisCAAssertion),
        ])
    CertificatePairAssertion._ext = []
    
    #-----< certificateListExactMatch >-----#
    certificateListExactMatch = CLASS(name=u'certificateListExactMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificateListExactMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListExactAssertion')))
    certificateListExactMatch._val = dict([(u'AssertionType', _certificateListExactMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])
    
    #-----< CertificateListExactAssertion >-----#
    CertificateListExactAssertion = SEQ(name=u'CertificateListExactAssertion', mode=MODE_TYPE)
    _CertificateListExactAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _CertificateListExactAssertion_thisUpdate = CHOICE(name=u'thisUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    _CertificateListExactAssertion_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    CertificateListExactAssertion._cont = ASN1Dict([
        (u'issuer', _CertificateListExactAssertion_issuer),
        (u'thisUpdate', _CertificateListExactAssertion_thisUpdate),
        (u'distributionPoint', _CertificateListExactAssertion_distributionPoint),
        ])
    CertificateListExactAssertion._ext = None
    
    #-----< certificateListMatch >-----#
    certificateListMatch = CLASS(name=u'certificateListMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificateListMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListAssertion')))
    certificateListMatch._val = dict([(u'AssertionType', _certificateListMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 6)), (u'ldapName', [u'certificateListMatch']), (u'ldapDesc', u'X.509 Certificate List Match'), (u'id', (2, 5, 13, 39))])
    
    #-----< CertificateListAssertion >-----#
    CertificateListAssertion = SEQ(name=u'CertificateListAssertion', mode=MODE_TYPE)
    _CertificateListAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CertificateListAssertion_minCRLNumber = INT(name=u'minCRLNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')), opt=True)
    _CertificateListAssertion_maxCRLNumber = INT(name=u'maxCRLNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')), opt=True)
    _CertificateListAssertion_reasonFlags = BIT_STR(name=u'reasonFlags', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _CertificateListAssertion_dateAndTime = CHOICE(name=u'dateAndTime', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')), opt=True)
    _CertificateListAssertion_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _CertificateListAssertion_authorityKeyIdentifier = SEQ(name=u'authorityKeyIdentifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AuthorityKeyIdentifier')), opt=True)
    CertificateListAssertion._cont = ASN1Dict([
        (u'issuer', _CertificateListAssertion_issuer),
        (u'minCRLNumber', _CertificateListAssertion_minCRLNumber),
        (u'maxCRLNumber', _CertificateListAssertion_maxCRLNumber),
        (u'reasonFlags', _CertificateListAssertion_reasonFlags),
        (u'dateAndTime', _CertificateListAssertion_dateAndTime),
        (u'distributionPoint', _CertificateListAssertion_distributionPoint),
        (u'authorityKeyIdentifier', _CertificateListAssertion_authorityKeyIdentifier),
        ])
    CertificateListAssertion._ext = []
    
    #-----< algorithmIdentifierMatch >-----#
    algorithmIdentifierMatch = CLASS(name=u'algorithmIdentifierMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _algorithmIdentifierMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __algorithmIdentifierMatch_val_AssertionType_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___algorithmIdentifierMatch_val_AssertionType_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_trailerField),
        ])
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21._ext = None
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___algorithmIdentifierMatch_val_AssertionType_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __algorithmIdentifierMatch_val_AssertionType_algorithm._const_tab = ___algorithmIdentifierMatch_val_AssertionType_algorithm_tab
    __algorithmIdentifierMatch_val_AssertionType_algorithm._const_tab_at = None
    __algorithmIdentifierMatch_val_AssertionType_algorithm._const_tab_id = u'id'
    __algorithmIdentifierMatch_val_AssertionType_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __algorithmIdentifierMatch_val_AssertionType_parameters._const_tab = ___algorithmIdentifierMatch_val_AssertionType_algorithm_tab
    __algorithmIdentifierMatch_val_AssertionType_parameters._const_tab_at = ('..', u'algorithm')
    __algorithmIdentifierMatch_val_AssertionType_parameters._const_tab_id = u'Type'
    _algorithmIdentifierMatch_val_AssertionType._cont = ASN1Dict([
        (u'algorithm', __algorithmIdentifierMatch_val_AssertionType_algorithm),
        (u'parameters', __algorithmIdentifierMatch_val_AssertionType_parameters),
        ])
    _algorithmIdentifierMatch_val_AssertionType._ext = []
    algorithmIdentifierMatch._val = dict([(u'AssertionType', _algorithmIdentifierMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 7)), (u'ldapName', [u'algorithmIdentifierMatch']), (u'ldapDesc', u'X.509 Algorithm Identifier Match'), (u'id', (2, 5, 13, 40))])
    
    #-----< policyMatch >-----#
    policyMatch = CLASS(name=u'policyMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _policyMatch_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicyID')))
    policyMatch._val = dict([(u'AssertionType', _policyMatch_val_AssertionType), (u'id', (2, 5, 13, 60))])
    
    #-----< pkiPathMatch >-----#
    pkiPathMatch = CLASS(name=u'pkiPathMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _pkiPathMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PkiPathMatchSyntax')))
    pkiPathMatch._val = dict([(u'AssertionType', _pkiPathMatch_val_AssertionType), (u'id', (2, 5, 13, 62))])
    
    #-----< PkiPathMatchSyntax >-----#
    PkiPathMatchSyntax = SEQ(name=u'PkiPathMatchSyntax', mode=MODE_TYPE)
    _PkiPathMatchSyntax_firstIssuer = CHOICE(name=u'firstIssuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _PkiPathMatchSyntax_lastSubject = CHOICE(name=u'lastSubject', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    PkiPathMatchSyntax._cont = ASN1Dict([
        (u'firstIssuer', _PkiPathMatchSyntax_firstIssuer),
        (u'lastSubject', _PkiPathMatchSyntax_lastSubject),
        ])
    PkiPathMatchSyntax._ext = []
    
    #-----< enhancedCertificateMatch >-----#
    enhancedCertificateMatch = CLASS(name=u'enhancedCertificateMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _enhancedCertificateMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'EnhancedCertificateAssertion')))
    enhancedCertificateMatch._val = dict([(u'AssertionType', _enhancedCertificateMatch_val_AssertionType), (u'id', (2, 5, 13, 65))])
    
    #-----< EnhancedCertificateAssertion >-----#
    EnhancedCertificateAssertion = SEQ(name=u'EnhancedCertificateAssertion', mode=MODE_TYPE)
    _EnhancedCertificateAssertion_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')), opt=True)
    _EnhancedCertificateAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _EnhancedCertificateAssertion_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'SubjectKeyIdentifier')), opt=True)
    _EnhancedCertificateAssertion_authorityKeyIdentifier = SEQ(name=u'authorityKeyIdentifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AuthorityKeyIdentifier')), opt=True)
    _EnhancedCertificateAssertion_certificateValid = CHOICE(name=u'certificateValid', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Time')), opt=True)
    _EnhancedCertificateAssertion_privateKeyValid = TIME_GEN(name=u'privateKeyValid', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancedCertificateAssertion_subjectPublicKeyAlgID = OID(name=u'subjectPublicKeyAlgID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancedCertificateAssertion_keyUsage = BIT_STR(name=u'keyUsage', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'KeyUsage')), opt=True)
    _EnhancedCertificateAssertion_subjectAltName = SEQ(name=u'subjectAltName', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AltName')), opt=True)
    _EnhancedCertificateAssertion_policy = SEQ_OF(name=u'policy', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertPolicySet')), opt=True)
    _EnhancedCertificateAssertion_pathToName = SEQ_OF(name=u'pathToName', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _EnhancedCertificateAssertion_subject = CHOICE(name=u'subject', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _EnhancedCertificateAssertion_nameConstraints = SEQ(name=u'nameConstraints', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')), opt=True)
    EnhancedCertificateAssertion._cont = ASN1Dict([
        (u'serialNumber', _EnhancedCertificateAssertion_serialNumber),
        (u'issuer', _EnhancedCertificateAssertion_issuer),
        (u'subjectKeyIdentifier', _EnhancedCertificateAssertion_subjectKeyIdentifier),
        (u'authorityKeyIdentifier', _EnhancedCertificateAssertion_authorityKeyIdentifier),
        (u'certificateValid', _EnhancedCertificateAssertion_certificateValid),
        (u'privateKeyValid', _EnhancedCertificateAssertion_privateKeyValid),
        (u'subjectPublicKeyAlgID', _EnhancedCertificateAssertion_subjectPublicKeyAlgID),
        (u'keyUsage', _EnhancedCertificateAssertion_keyUsage),
        (u'subjectAltName', _EnhancedCertificateAssertion_subjectAltName),
        (u'policy', _EnhancedCertificateAssertion_policy),
        (u'pathToName', _EnhancedCertificateAssertion_pathToName),
        (u'subject', _EnhancedCertificateAssertion_subject),
        (u'nameConstraints', _EnhancedCertificateAssertion_nameConstraints),
        ])
    EnhancedCertificateAssertion._ext = []
    
    #-----< AltName >-----#
    AltName = SEQ(name=u'AltName', mode=MODE_TYPE)
    _AltName_altnameType = CHOICE(name=u'altnameType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'AltNameType')))
    _AltName_altNameValue = CHOICE(name=u'altNameValue', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    AltName._cont = ASN1Dict([
        (u'altnameType', _AltName_altnameType),
        (u'altNameValue', _AltName_altNameValue),
        ])
    AltName._ext = None
    
    #-----< certExactAssertion >-----#
    certExactAssertion = CLASS(name=u'certExactAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certExactAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')))
    certExactAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate Exact Assertion'), (u'Type', _certExactAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 1))])
    
    #-----< certAssertion >-----#
    certAssertion = CLASS(name=u'certAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateAssertion')))
    certAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate Assertion'), (u'Type', _certAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 2))])
    
    #-----< certPairExactAssertion >-----#
    certPairExactAssertion = CLASS(name=u'certPairExactAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certPairExactAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairExactAssertion')))
    certPairExactAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate Pair Exact Assertion'), (u'Type', _certPairExactAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 3))])
    
    #-----< certPairAssertion >-----#
    certPairAssertion = CLASS(name=u'certPairAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certPairAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairAssertion')))
    certPairAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate Pair Assertion'), (u'Type', _certPairAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 4))])
    
    #-----< certListExactAssertion >-----#
    certListExactAssertion = CLASS(name=u'certListExactAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certListExactAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListExactAssertion')))
    certListExactAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate List Exact Assertion'), (u'Type', _certListExactAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 5))])
    
    #-----< certListAssertion >-----#
    certListAssertion = CLASS(name=u'certListAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certListAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListAssertion')))
    certListAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate List Assertion'), (u'Type', _certListAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 6))])
    
    #-----< algorithmIdentifier >-----#
    algorithmIdentifier = CLASS(name=u'algorithmIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _algorithmIdentifier_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __algorithmIdentifier_val_Type_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___algorithmIdentifier_val_Type_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_trailerField),
        ])
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21._ext = None
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___algorithmIdentifier_val_Type_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __algorithmIdentifier_val_Type_algorithm._const_tab = ___algorithmIdentifier_val_Type_algorithm_tab
    __algorithmIdentifier_val_Type_algorithm._const_tab_at = None
    __algorithmIdentifier_val_Type_algorithm._const_tab_id = u'id'
    __algorithmIdentifier_val_Type_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __algorithmIdentifier_val_Type_parameters._const_tab = ___algorithmIdentifier_val_Type_algorithm_tab
    __algorithmIdentifier_val_Type_parameters._const_tab_at = ('..', u'algorithm')
    __algorithmIdentifier_val_Type_parameters._const_tab_id = u'Type'
    _algorithmIdentifier_val_Type._cont = ASN1Dict([
        (u'algorithm', __algorithmIdentifier_val_Type_algorithm),
        (u'parameters', __algorithmIdentifier_val_Type_parameters),
        ])
    _algorithmIdentifier_val_Type._ext = []
    algorithmIdentifier._val = dict([(u'ldapDesc', u'X.509 Algorithm Identifier'), (u'Type', _algorithmIdentifier_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 7))])
    
    #-----< id-ce-subjectDirectoryAttributes >-----#
    id_ce_subjectDirectoryAttributes = OID(name=u'id-ce-subjectDirectoryAttributes', mode=MODE_VALUE)
    id_ce_subjectDirectoryAttributes._val = (2, 5, 29, 9)
    
    #-----< id-ce-subjectKeyIdentifier >-----#
    id_ce_subjectKeyIdentifier = OID(name=u'id-ce-subjectKeyIdentifier', mode=MODE_VALUE)
    id_ce_subjectKeyIdentifier._val = (2, 5, 29, 14)
    
    #-----< id-ce-keyUsage >-----#
    id_ce_keyUsage = OID(name=u'id-ce-keyUsage', mode=MODE_VALUE)
    id_ce_keyUsage._val = (2, 5, 29, 15)
    
    #-----< id-ce-privateKeyUsagePeriod >-----#
    id_ce_privateKeyUsagePeriod = OID(name=u'id-ce-privateKeyUsagePeriod', mode=MODE_VALUE)
    id_ce_privateKeyUsagePeriod._val = (2, 5, 29, 16)
    
    #-----< id-ce-subjectAltName >-----#
    id_ce_subjectAltName = OID(name=u'id-ce-subjectAltName', mode=MODE_VALUE)
    id_ce_subjectAltName._val = (2, 5, 29, 17)
    
    #-----< id-ce-issuerAltName >-----#
    id_ce_issuerAltName = OID(name=u'id-ce-issuerAltName', mode=MODE_VALUE)
    id_ce_issuerAltName._val = (2, 5, 29, 18)
    
    #-----< id-ce-basicConstraints >-----#
    id_ce_basicConstraints = OID(name=u'id-ce-basicConstraints', mode=MODE_VALUE)
    id_ce_basicConstraints._val = (2, 5, 29, 19)
    
    #-----< id-ce-cRLNumber >-----#
    id_ce_cRLNumber = OID(name=u'id-ce-cRLNumber', mode=MODE_VALUE)
    id_ce_cRLNumber._val = (2, 5, 29, 20)
    
    #-----< id-ce-reasonCode >-----#
    id_ce_reasonCode = OID(name=u'id-ce-reasonCode', mode=MODE_VALUE)
    id_ce_reasonCode._val = (2, 5, 29, 21)
    
    #-----< id-ce-holdInstructionCode >-----#
    id_ce_holdInstructionCode = OID(name=u'id-ce-holdInstructionCode', mode=MODE_VALUE)
    id_ce_holdInstructionCode._val = (2, 5, 29, 23)
    
    #-----< id-ce-invalidityDate >-----#
    id_ce_invalidityDate = OID(name=u'id-ce-invalidityDate', mode=MODE_VALUE)
    id_ce_invalidityDate._val = (2, 5, 29, 24)
    
    #-----< id-ce-deltaCRLIndicator >-----#
    id_ce_deltaCRLIndicator = OID(name=u'id-ce-deltaCRLIndicator', mode=MODE_VALUE)
    id_ce_deltaCRLIndicator._val = (2, 5, 29, 27)
    
    #-----< id-ce-issuingDistributionPoint >-----#
    id_ce_issuingDistributionPoint = OID(name=u'id-ce-issuingDistributionPoint', mode=MODE_VALUE)
    id_ce_issuingDistributionPoint._val = (2, 5, 29, 28)
    
    #-----< id-ce-certificateIssuer >-----#
    id_ce_certificateIssuer = OID(name=u'id-ce-certificateIssuer', mode=MODE_VALUE)
    id_ce_certificateIssuer._val = (2, 5, 29, 29)
    
    #-----< id-ce-nameConstraints >-----#
    id_ce_nameConstraints = OID(name=u'id-ce-nameConstraints', mode=MODE_VALUE)
    id_ce_nameConstraints._val = (2, 5, 29, 30)
    
    #-----< id-ce-cRLDistributionPoints >-----#
    id_ce_cRLDistributionPoints = OID(name=u'id-ce-cRLDistributionPoints', mode=MODE_VALUE)
    id_ce_cRLDistributionPoints._val = (2, 5, 29, 31)
    
    #-----< id-ce-certificatePolicies >-----#
    id_ce_certificatePolicies = OID(name=u'id-ce-certificatePolicies', mode=MODE_VALUE)
    id_ce_certificatePolicies._val = (2, 5, 29, 32)
    
    #-----< id-ce-policyMappings >-----#
    id_ce_policyMappings = OID(name=u'id-ce-policyMappings', mode=MODE_VALUE)
    id_ce_policyMappings._val = (2, 5, 29, 33)
    
    #-----< id-ce-authorityKeyIdentifier >-----#
    id_ce_authorityKeyIdentifier = OID(name=u'id-ce-authorityKeyIdentifier', mode=MODE_VALUE)
    id_ce_authorityKeyIdentifier._val = (2, 5, 29, 35)
    
    #-----< id-ce-policyConstraints >-----#
    id_ce_policyConstraints = OID(name=u'id-ce-policyConstraints', mode=MODE_VALUE)
    id_ce_policyConstraints._val = (2, 5, 29, 36)
    
    #-----< id-ce-extKeyUsage >-----#
    id_ce_extKeyUsage = OID(name=u'id-ce-extKeyUsage', mode=MODE_VALUE)
    id_ce_extKeyUsage._val = (2, 5, 29, 37)
    
    #-----< id-ce-cRLStreamIdentifier >-----#
    id_ce_cRLStreamIdentifier = OID(name=u'id-ce-cRLStreamIdentifier', mode=MODE_VALUE)
    id_ce_cRLStreamIdentifier._val = (2, 5, 29, 40)
    
    #-----< id-ce-cRLScope >-----#
    id_ce_cRLScope = OID(name=u'id-ce-cRLScope', mode=MODE_VALUE)
    id_ce_cRLScope._val = (2, 5, 29, 44)
    
    #-----< id-ce-statusReferrals >-----#
    id_ce_statusReferrals = OID(name=u'id-ce-statusReferrals', mode=MODE_VALUE)
    id_ce_statusReferrals._val = (2, 5, 29, 45)
    
    #-----< id-ce-freshestCRL >-----#
    id_ce_freshestCRL = OID(name=u'id-ce-freshestCRL', mode=MODE_VALUE)
    id_ce_freshestCRL._val = (2, 5, 29, 46)
    
    #-----< id-ce-orderedList >-----#
    id_ce_orderedList = OID(name=u'id-ce-orderedList', mode=MODE_VALUE)
    id_ce_orderedList._val = (2, 5, 29, 47)
    
    #-----< id-ce-baseUpdateTime >-----#
    id_ce_baseUpdateTime = OID(name=u'id-ce-baseUpdateTime', mode=MODE_VALUE)
    id_ce_baseUpdateTime._val = (2, 5, 29, 51)
    
    #-----< id-ce-deltaInfo >-----#
    id_ce_deltaInfo = OID(name=u'id-ce-deltaInfo', mode=MODE_VALUE)
    id_ce_deltaInfo._val = (2, 5, 29, 53)
    
    #-----< id-ce-inhibitAnyPolicy >-----#
    id_ce_inhibitAnyPolicy = OID(name=u'id-ce-inhibitAnyPolicy', mode=MODE_VALUE)
    id_ce_inhibitAnyPolicy._val = (2, 5, 29, 54)
    
    #-----< id-ce-toBeRevoked >-----#
    id_ce_toBeRevoked = OID(name=u'id-ce-toBeRevoked', mode=MODE_VALUE)
    id_ce_toBeRevoked._val = (2, 5, 29, 58)
    
    #-----< id-ce-revokedGroups >-----#
    id_ce_revokedGroups = OID(name=u'id-ce-revokedGroups', mode=MODE_VALUE)
    id_ce_revokedGroups._val = (2, 5, 29, 59)
    
    #-----< id-ce-expiredCertsOnCRL >-----#
    id_ce_expiredCertsOnCRL = OID(name=u'id-ce-expiredCertsOnCRL', mode=MODE_VALUE)
    id_ce_expiredCertsOnCRL._val = (2, 5, 29, 60)
    
    #-----< id-ce-aAissuingDistributionPoint >-----#
    id_ce_aAissuingDistributionPoint = OID(name=u'id-ce-aAissuingDistributionPoint', mode=MODE_VALUE)
    id_ce_aAissuingDistributionPoint._val = (2, 5, 29, 63)
    
    #-----< id-ce-authorizationValidation >-----#
    id_ce_authorizationValidation = OID(name=u'id-ce-authorizationValidation', mode=MODE_VALUE)
    id_ce_authorizationValidation._val = (2, 5, 29, 70)
    
    #-----< id-mr-certificateExactMatch >-----#
    id_mr_certificateExactMatch = OID(name=u'id-mr-certificateExactMatch', mode=MODE_VALUE)
    id_mr_certificateExactMatch._val = (2, 5, 13, 34)
    
    #-----< id-mr-certificateMatch >-----#
    id_mr_certificateMatch = OID(name=u'id-mr-certificateMatch', mode=MODE_VALUE)
    id_mr_certificateMatch._val = (2, 5, 13, 35)
    
    #-----< id-mr-certificatePairExactMatch >-----#
    id_mr_certificatePairExactMatch = OID(name=u'id-mr-certificatePairExactMatch', mode=MODE_VALUE)
    id_mr_certificatePairExactMatch._val = (2, 5, 13, 36)
    
    #-----< id-mr-certificatePairMatch >-----#
    id_mr_certificatePairMatch = OID(name=u'id-mr-certificatePairMatch', mode=MODE_VALUE)
    id_mr_certificatePairMatch._val = (2, 5, 13, 37)
    
    #-----< id-mr-certificateListExactMatch >-----#
    id_mr_certificateListExactMatch = OID(name=u'id-mr-certificateListExactMatch', mode=MODE_VALUE)
    id_mr_certificateListExactMatch._val = (2, 5, 13, 38)
    
    #-----< id-mr-certificateListMatch >-----#
    id_mr_certificateListMatch = OID(name=u'id-mr-certificateListMatch', mode=MODE_VALUE)
    id_mr_certificateListMatch._val = (2, 5, 13, 39)
    
    #-----< id-mr-algorithmIdentifierMatch >-----#
    id_mr_algorithmIdentifierMatch = OID(name=u'id-mr-algorithmIdentifierMatch', mode=MODE_VALUE)
    id_mr_algorithmIdentifierMatch._val = (2, 5, 13, 40)
    
    #-----< id-mr-policyMatch >-----#
    id_mr_policyMatch = OID(name=u'id-mr-policyMatch', mode=MODE_VALUE)
    id_mr_policyMatch._val = (2, 5, 13, 60)
    
    #-----< id-mr-pkiPathMatch >-----#
    id_mr_pkiPathMatch = OID(name=u'id-mr-pkiPathMatch', mode=MODE_VALUE)
    id_mr_pkiPathMatch._val = (2, 5, 13, 62)
    
    #-----< id-mr-enhancedCertificateMatch >-----#
    id_mr_enhancedCertificateMatch = OID(name=u'id-mr-enhancedCertificateMatch', mode=MODE_VALUE)
    id_mr_enhancedCertificateMatch._val = (2, 5, 13, 65)
    
    #-----< id-ldx-certExactAssertion >-----#
    id_ldx_certExactAssertion = OID(name=u'id-ldx-certExactAssertion', mode=MODE_VALUE)
    id_ldx_certExactAssertion._val = (1, 3, 6, 1, 1, 15, 1)
    
    #-----< id-ldx-certAssertion >-----#
    id_ldx_certAssertion = OID(name=u'id-ldx-certAssertion', mode=MODE_VALUE)
    id_ldx_certAssertion._val = (1, 3, 6, 1, 1, 15, 2)
    
    #-----< id-ldx-certPairExactAssertion >-----#
    id_ldx_certPairExactAssertion = OID(name=u'id-ldx-certPairExactAssertion', mode=MODE_VALUE)
    id_ldx_certPairExactAssertion._val = (1, 3, 6, 1, 1, 15, 3)
    
    #-----< id-ldx-certPairAssertion >-----#
    id_ldx_certPairAssertion = OID(name=u'id-ldx-certPairAssertion', mode=MODE_VALUE)
    id_ldx_certPairAssertion._val = (1, 3, 6, 1, 1, 15, 4)
    
    #-----< id-ldx-certListExactAssertion >-----#
    id_ldx_certListExactAssertion = OID(name=u'id-ldx-certListExactAssertion', mode=MODE_VALUE)
    id_ldx_certListExactAssertion._val = (1, 3, 6, 1, 1, 15, 5)
    
    #-----< id-ldx-certListAssertion >-----#
    id_ldx_certListAssertion = OID(name=u'id-ldx-certListAssertion', mode=MODE_VALUE)
    id_ldx_certListAssertion._val = (1, 3, 6, 1, 1, 15, 6)
    
    #-----< id-ldx-algorithmIdentifier >-----#
    id_ldx_algorithmIdentifier = OID(name=u'id-ldx-algorithmIdentifier', mode=MODE_VALUE)
    id_ldx_algorithmIdentifier._val = (1, 3, 6, 1, 1, 15, 7)
    
    _all_ = [
        authorityKeyIdentifier,
        _authorityKeyIdentifier_val_ExtnType,
        _AuthorityKeyIdentifier_keyIdentifier,
        _AuthorityKeyIdentifier_authorityCertIssuer,
        _AuthorityKeyIdentifier_authorityCertSerialNumber,
        AuthorityKeyIdentifier,
        KeyIdentifier,
        subjectKeyIdentifier,
        _subjectKeyIdentifier_val_ExtnType,
        SubjectKeyIdentifier,
        keyUsage,
        _keyUsage_val_ExtnType,
        KeyUsage,
        extKeyUsage,
        __extKeyUsage_val_ExtnType__item_,
        _extKeyUsage_val_ExtnType,
        KeyPurposeId,
        privateKeyUsagePeriod,
        _privateKeyUsagePeriod_val_ExtnType,
        _PrivateKeyUsagePeriod_notBefore,
        _PrivateKeyUsagePeriod_notAfter,
        PrivateKeyUsagePeriod,
        certificatePolicies,
        _certificatePolicies_val_ExtnType,
        _CertificatePoliciesSyntax__item_,
        CertificatePoliciesSyntax,
        _PolicyInformation_policyIdentifier,
        __PolicyInformation_policyQualifiers__item_,
        _PolicyInformation_policyQualifiers,
        PolicyInformation,
        CertPolicyId,
        __PolicyQualifierInfo_policyQualifierId_tab,
        _PolicyQualifierInfo_policyQualifierId,
        __PolicyQualifierInfo_qualifier_tab,
        _PolicyQualifierInfo_qualifier,
        PolicyQualifierInfo,
        SupportedPolicyQualifiers,
        anyPolicy,
        _CERT_POLICY_QUALIFIER_id,
        _CERT_POLICY_QUALIFIER_Qualifier,
        CERT_POLICY_QUALIFIER,
        policyMappings,
        _policyMappings_val_ExtnType,
        __PolicyMappingsSyntax__item__issuerDomainPolicy,
        __PolicyMappingsSyntax__item__subjectDomainPolicy,
        _PolicyMappingsSyntax__item_,
        PolicyMappingsSyntax,
        authorizationValidation,
        _authorizationValidation_val_ExtnType,
        _AvlId_issuer,
        _AvlId_serialNumber,
        AvlId,
        subjectAltName,
        _subjectAltName_val_ExtnType,
        _GeneralNames__item_,
        GeneralNames,
        __GeneralName_otherName_type_id,
        __GeneralName_otherName_value,
        _GeneralName_otherName,
        _GeneralName_otherName,
        _GeneralName_rfc822Name,
        _GeneralName_dNSName,
        _GeneralName_x400Address,
        _GeneralName_directoryName,
        _GeneralName_ediPartyName,
        _GeneralName_uniformResourceIdentifier,
        _GeneralName_iPAddress,
        _GeneralName_registeredID,
        GeneralName,
        OTHER_NAME,
        _EDIPartyName_nameAssigner,
        _EDIPartyName_partyName,
        EDIPartyName,
        issuerAltName,
        _issuerAltName_val_ExtnType,
        subjectDirectoryAttributes,
        _subjectDirectoryAttributes_val_ExtnType,
        ___AttributesSyntax__item__type_tab,
        ____AttributesSyntax__item__type_tab_val_Type_0,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType,
        ____AttributesSyntax__item__type_tab_val_Type_1,
        ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0,
        __AttributesSyntax__item__type,
        ___AttributesSyntax__item__values__item_,
        __AttributesSyntax__item__values,
        ____AttributesSyntax__item__valuesWithContext__item__value,
        _____AttributesSyntax__item__valuesWithContext__item__contextList__item_,
        ____AttributesSyntax__item__valuesWithContext__item__contextList,
        ___AttributesSyntax__item__valuesWithContext__item_,
        __AttributesSyntax__item__valuesWithContext,
        _AttributesSyntax__item_,
        AttributesSyntax,
        basicConstraints,
        _basicConstraints_val_ExtnType,
        _BasicConstraintsSyntax_cA,
        _BasicConstraintsSyntax_pathLenConstraint,
        BasicConstraintsSyntax,
        nameConstraints,
        _nameConstraints_val_ExtnType,
        _NameConstraintsSyntax_permittedSubtrees,
        _NameConstraintsSyntax_excludedSubtrees,
        NameConstraintsSyntax,
        _GeneralSubtrees__item_,
        GeneralSubtrees,
        _GeneralSubtree_base,
        _GeneralSubtree_minimum,
        _GeneralSubtree_maximum,
        GeneralSubtree,
        BaseDistance,
        policyConstraints,
        _policyConstraints_val_ExtnType,
        _PolicyConstraintsSyntax_requireExplicitPolicy,
        _PolicyConstraintsSyntax_inhibitPolicyMapping,
        PolicyConstraintsSyntax,
        SkipCerts,
        inhibitAnyPolicy,
        _inhibitAnyPolicy_val_ExtnType,
        cRLNumber,
        _cRLNumber_val_ExtnType,
        CRLNumber,
        crlScope,
        _crlScope_val_ExtnType,
        _CRLScopeSyntax__item_,
        CRLScopeSyntax,
        _PerAuthorityScope_authorityName,
        _PerAuthorityScope_distributionPoint,
        _PerAuthorityScope_onlyContains,
        _PerAuthorityScope_onlySomeReasons,
        _PerAuthorityScope_serialNumberRange,
        _PerAuthorityScope_subjectKeyIdRange,
        _PerAuthorityScope_nameSubtrees,
        _PerAuthorityScope_baseRevocationInfo,
        PerAuthorityScope,
        OnlyCertificateTypes,
        _NumberRange_startingNumber,
        _NumberRange_endingNumber,
        _NumberRange_modulus,
        NumberRange,
        _BaseRevocationInfo_cRLStreamIdentifier,
        _BaseRevocationInfo_cRLNumber,
        _BaseRevocationInfo_baseThisUpdate,
        BaseRevocationInfo,
        statusReferrals,
        _statusReferrals_val_ExtnType,
        _StatusReferrals__item_,
        StatusReferrals,
        _StatusReferral_cRLReferral,
        __StatusReferral_otherReferral_type_id,
        __StatusReferral_otherReferral_value,
        _StatusReferral_otherReferral,
        _StatusReferral_otherReferral,
        StatusReferral,
        _CRLReferral_issuer,
        _CRLReferral_location,
        _CRLReferral_deltaRefInfo,
        _CRLReferral_cRLScope,
        _CRLReferral_lastUpdate,
        _CRLReferral_lastChangedCRL,
        CRLReferral,
        _DeltaRefInfo_deltaLocation,
        _DeltaRefInfo_lastDelta,
        DeltaRefInfo,
        OTHER_REFERRAL,
        cRLStreamIdentifier,
        _cRLStreamIdentifier_val_ExtnType,
        CRLStreamIdentifier,
        orderedList,
        _orderedList_val_ExtnType,
        OrderedListSyntax,
        deltaInfo,
        _deltaInfo_val_ExtnType,
        _DeltaInformation_deltaLocation,
        _DeltaInformation_nextDelta,
        DeltaInformation,
        toBeRevoked,
        _toBeRevoked_val_ExtnType,
        _ToBeRevokedSyntax__item_,
        ToBeRevokedSyntax,
        _ToBeRevokedGroup_certificateIssuer,
        _ToBeRevokedGroup_reasonInfo,
        _ToBeRevokedGroup_revocationTime,
        _ToBeRevokedGroup_certificateGroup,
        ToBeRevokedGroup,
        _ReasonInfo_reasonCode,
        _ReasonInfo_holdInstructionCode,
        ReasonInfo,
        _CertificateGroup_serialNumbers,
        _CertificateGroup_serialNumberRange,
        _CertificateGroup_nameSubtree,
        CertificateGroup,
        _CertificateGroupNumberRange_startingNumber,
        _CertificateGroupNumberRange_endingNumber,
        CertificateGroupNumberRange,
        _CertificateSerialNumbers__item_,
        CertificateSerialNumbers,
        revokedGroups,
        _revokedGroups_val_ExtnType,
        _RevokedGroupsSyntax__item_,
        RevokedGroupsSyntax,
        _RevokedGroup_certificateIssuer,
        _RevokedGroup_reasonInfo,
        _RevokedGroup_invalidityDate,
        _RevokedGroup_revokedcertificateGroup,
        RevokedGroup,
        _RevokedCertificateGroup_serialNumberRange,
        _RevokedCertificateGroup_nameSubtree,
        RevokedCertificateGroup,
        expiredCertsOnCRL,
        _expiredCertsOnCRL_val_ExtnType,
        ExpiredCertsOnCRL,
        reasonCode,
        _reasonCode_val_ExtnType,
        CRLReason,
        holdInstructionCode,
        _holdInstructionCode_val_ExtnType,
        HoldInstruction,
        invalidityDate,
        _invalidityDate_val_ExtnType,
        cRLDistributionPoints,
        _cRLDistributionPoints_val_ExtnType,
        _CRLDistPointsSyntax__item_,
        CRLDistPointsSyntax,
        _DistributionPoint_distributionPoint,
        _DistributionPoint_reasons,
        _DistributionPoint_cRLIssuer,
        DistributionPoint,
        _DistributionPointName_fullName,
        _DistributionPointName_nameRelativeToCRLIssuer,
        DistributionPointName,
        ReasonFlags,
        issuingDistributionPoint,
        _issuingDistributionPoint_val_ExtnType,
        _IssuingDistPointSyntax_distributionPoint,
        _IssuingDistPointSyntax_onlyContainsUserPublicKeyCerts,
        _IssuingDistPointSyntax_onlyContainsCACerts,
        _IssuingDistPointSyntax_onlySomeReasons,
        _IssuingDistPointSyntax_indirectCRL,
        _IssuingDistPointSyntax_onlyContainsAttributeCerts,
        IssuingDistPointSyntax,
        certificateIssuer,
        _certificateIssuer_val_ExtnType,
        deltaCRLIndicator,
        _deltaCRLIndicator_val_ExtnType,
        BaseCRLNumber,
        baseUpdateTime,
        _baseUpdateTime_val_ExtnType,
        freshestCRL,
        _freshestCRL_val_ExtnType,
        aAissuingDistributionPoint,
        _aAissuingDistributionPoint_val_ExtnType,
        _AAIssuingDistPointSyntax_distributionPoint,
        _AAIssuingDistPointSyntax_onlySomeReasons,
        _AAIssuingDistPointSyntax_indirectCRL,
        _AAIssuingDistPointSyntax_containsUserAttributeCerts,
        _AAIssuingDistPointSyntax_containsAACerts,
        _AAIssuingDistPointSyntax_containsSOAPublicKeyCerts,
        AAIssuingDistPointSyntax,
        certificateExactMatch,
        _certificateExactMatch_val_AssertionType,
        _CertificateExactAssertion_serialNumber,
        _CertificateExactAssertion_issuer,
        CertificateExactAssertion,
        certificateMatch,
        _certificateMatch_val_AssertionType,
        _CertificateAssertion_serialNumber,
        _CertificateAssertion_issuer,
        _CertificateAssertion_subjectKeyIdentifier,
        _CertificateAssertion_authorityKeyIdentifier,
        _CertificateAssertion_certificateValid,
        _CertificateAssertion_privateKeyValid,
        _CertificateAssertion_subjectPublicKeyAlgID,
        _CertificateAssertion_keyUsage,
        _CertificateAssertion_subjectAltName,
        _CertificateAssertion_policy,
        _CertificateAssertion_pathToName,
        _CertificateAssertion_subject,
        _CertificateAssertion_nameConstraints,
        CertificateAssertion,
        _AltNameType_builtinNameForm,
        _AltNameType_otherNameForm,
        AltNameType,
        _CertPolicySet__item_,
        CertPolicySet,
        certificatePairExactMatch,
        _certificatePairExactMatch_val_AssertionType,
        _CertificatePairExactAssertion_issuedToThisCAAssertion,
        _CertificatePairExactAssertion_issuedByThisCAAssertion,
        CertificatePairExactAssertion,
        certificatePairMatch,
        _certificatePairMatch_val_AssertionType,
        _CertificatePairAssertion_issuedToThisCAAssertion,
        _CertificatePairAssertion_issuedByThisCAAssertion,
        CertificatePairAssertion,
        certificateListExactMatch,
        _certificateListExactMatch_val_AssertionType,
        _CertificateListExactAssertion_issuer,
        _CertificateListExactAssertion_thisUpdate,
        _CertificateListExactAssertion_distributionPoint,
        CertificateListExactAssertion,
        certificateListMatch,
        _certificateListMatch_val_AssertionType,
        _CertificateListAssertion_issuer,
        _CertificateListAssertion_minCRLNumber,
        _CertificateListAssertion_maxCRLNumber,
        _CertificateListAssertion_reasonFlags,
        _CertificateListAssertion_dateAndTime,
        _CertificateListAssertion_distributionPoint,
        _CertificateListAssertion_authorityKeyIdentifier,
        CertificateListAssertion,
        algorithmIdentifierMatch,
        ___algorithmIdentifierMatch_val_AssertionType_algorithm_tab,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_0,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_1,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_6,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_7,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_8,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_9,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_10,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_11,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_12,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_13,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_14,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_15,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_16,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_17,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_18,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_19,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_20,
        _______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_hashAlgorithm,
        _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_saltLength,
        _____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21_trailerField,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_21,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_28,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_29,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_30,
        ____algorithmIdentifierMatch_val_AssertionType_algorithm_tab_val_Type_31,
        __algorithmIdentifierMatch_val_AssertionType_algorithm,
        __algorithmIdentifierMatch_val_AssertionType_parameters,
        _algorithmIdentifierMatch_val_AssertionType,
        policyMatch,
        _policyMatch_val_AssertionType,
        pkiPathMatch,
        _pkiPathMatch_val_AssertionType,
        _PkiPathMatchSyntax_firstIssuer,
        _PkiPathMatchSyntax_lastSubject,
        PkiPathMatchSyntax,
        enhancedCertificateMatch,
        _enhancedCertificateMatch_val_AssertionType,
        _EnhancedCertificateAssertion_serialNumber,
        _EnhancedCertificateAssertion_issuer,
        _EnhancedCertificateAssertion_subjectKeyIdentifier,
        _EnhancedCertificateAssertion_authorityKeyIdentifier,
        _EnhancedCertificateAssertion_certificateValid,
        _EnhancedCertificateAssertion_privateKeyValid,
        _EnhancedCertificateAssertion_subjectPublicKeyAlgID,
        _EnhancedCertificateAssertion_keyUsage,
        _EnhancedCertificateAssertion_subjectAltName,
        _EnhancedCertificateAssertion_policy,
        _EnhancedCertificateAssertion_pathToName,
        _EnhancedCertificateAssertion_subject,
        _EnhancedCertificateAssertion_nameConstraints,
        EnhancedCertificateAssertion,
        _AltName_altnameType,
        _AltName_altNameValue,
        AltName,
        certExactAssertion,
        _certExactAssertion_val_Type,
        certAssertion,
        _certAssertion_val_Type,
        certPairExactAssertion,
        _certPairExactAssertion_val_Type,
        certPairAssertion,
        _certPairAssertion_val_Type,
        certListExactAssertion,
        _certListExactAssertion_val_Type,
        certListAssertion,
        _certListAssertion_val_Type,
        algorithmIdentifier,
        ___algorithmIdentifier_val_Type_algorithm_tab,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_0,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_1,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_6,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_7,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_8,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_9,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_10,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_11,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_12,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_13,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_14,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_15,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_16,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_17,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_18,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_19,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_20,
        _______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ________algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        ______algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_hashAlgorithm,
        _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_saltLength,
        _____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21_trailerField,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_21,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_28,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_29,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_30,
        ____algorithmIdentifier_val_Type_algorithm_tab_val_Type_31,
        __algorithmIdentifier_val_Type_algorithm,
        __algorithmIdentifier_val_Type_parameters,
        _algorithmIdentifier_val_Type,
        id_ce_subjectDirectoryAttributes,
        id_ce_subjectKeyIdentifier,
        id_ce_keyUsage,
        id_ce_privateKeyUsagePeriod,
        id_ce_subjectAltName,
        id_ce_issuerAltName,
        id_ce_basicConstraints,
        id_ce_cRLNumber,
        id_ce_reasonCode,
        id_ce_holdInstructionCode,
        id_ce_invalidityDate,
        id_ce_deltaCRLIndicator,
        id_ce_issuingDistributionPoint,
        id_ce_certificateIssuer,
        id_ce_nameConstraints,
        id_ce_cRLDistributionPoints,
        id_ce_certificatePolicies,
        id_ce_policyMappings,
        id_ce_authorityKeyIdentifier,
        id_ce_policyConstraints,
        id_ce_extKeyUsage,
        id_ce_cRLStreamIdentifier,
        id_ce_cRLScope,
        id_ce_statusReferrals,
        id_ce_freshestCRL,
        id_ce_orderedList,
        id_ce_baseUpdateTime,
        id_ce_deltaInfo,
        id_ce_inhibitAnyPolicy,
        id_ce_toBeRevoked,
        id_ce_revokedGroups,
        id_ce_expiredCertsOnCRL,
        id_ce_aAissuingDistributionPoint,
        id_ce_authorizationValidation,
        id_mr_certificateExactMatch,
        id_mr_certificateMatch,
        id_mr_certificatePairExactMatch,
        id_mr_certificatePairMatch,
        id_mr_certificateListExactMatch,
        id_mr_certificateListMatch,
        id_mr_algorithmIdentifierMatch,
        id_mr_policyMatch,
        id_mr_pkiPathMatch,
        id_mr_enhancedCertificateMatch,
        id_ldx_certExactAssertion,
        id_ldx_certAssertion,
        id_ldx_certPairExactAssertion,
        id_ldx_certPairAssertion,
        id_ldx_certListExactAssertion,
        id_ldx_certListAssertion,
        id_ldx_algorithmIdentifier,
    ]

class CommonProtocolSpecification:

    _name_  = u'CommonProtocolSpecification'
    _oid_   = [2, 5, 1, 35, 8]
    
    _obj_ = [
        u'OPERATION',
        u'ERROR',
        u'Code',
        u'InvokeId',
        u'id-opcode-read',
        u'id-opcode-compare',
        u'id-opcode-abandon',
        u'id-opcode-list',
        u'id-opcode-search',
        u'id-opcode-addEntry',
        u'id-opcode-removeEntry',
        u'id-opcode-modifyEntry',
        u'id-opcode-modifyDN',
        u'id-opcode-changePassword',
        u'id-opcode-administerPassword',
        u'id-opcode-ldapTransport',
        u'id-opcode-linkedLDAP',
        u'id-opcode-requestShadowUpdate',
        u'id-opcode-updateShadow',
        u'id-opcode-coordinateShadowUpdate',
        u'id-op-establishOperationalBinding',
        u'id-op-modifyOperationalBinding',
        u'id-op-terminateOperationalBinding',
        u'id-errcode-attributeError',
        u'id-errcode-nameError',
        u'id-errcode-serviceError',
        u'id-errcode-referral',
        u'id-errcode-abandoned',
        u'id-errcode-securityError',
        u'id-errcode-abandonFailed',
        u'id-errcode-updateError',
        u'id-errcode-dsaReferral',
        u'id-errcode-shadowError',
        u'id-err-operationalBindingError',
        u'DOP-Invokable',
        u'DOP-Returnable',
        ]
    _type_ = [
        u'OPERATION',
        u'ERROR',
        u'Code',
        u'InvokeId',
        ]
    _set_ = [
        u'DOP-Invokable',
        u'DOP-Returnable',
        ]
    _val_ = [
        u'id-opcode-read',
        u'id-opcode-compare',
        u'id-opcode-abandon',
        u'id-opcode-list',
        u'id-opcode-search',
        u'id-opcode-addEntry',
        u'id-opcode-removeEntry',
        u'id-opcode-modifyEntry',
        u'id-opcode-modifyDN',
        u'id-opcode-changePassword',
        u'id-opcode-administerPassword',
        u'id-opcode-ldapTransport',
        u'id-opcode-linkedLDAP',
        u'id-opcode-requestShadowUpdate',
        u'id-opcode-updateShadow',
        u'id-opcode-coordinateShadowUpdate',
        u'id-op-establishOperationalBinding',
        u'id-op-modifyOperationalBinding',
        u'id-op-terminateOperationalBinding',
        u'id-errcode-attributeError',
        u'id-errcode-nameError',
        u'id-errcode-serviceError',
        u'id-errcode-referral',
        u'id-errcode-abandoned',
        u'id-errcode-securityError',
        u'id-errcode-abandonFailed',
        u'id-errcode-updateError',
        u'id-errcode-dsaReferral',
        u'id-errcode-shadowError',
        u'id-err-operationalBindingError',
        ]
    _class_ = [
        u'OPERATION',
        u'ERROR',
        u'DOP-Invokable',
        u'DOP-Returnable',
        ]
    _param_ = [
        ]
    
    #-----< OPERATION >-----#
    OPERATION = CLASS(name=u'OPERATION', mode=MODE_TYPE)
    _OPERATION_ArgumentType = OPEN(name=u'ArgumentType', mode=MODE_TYPE, opt=True)
    _OPERATION_ResultType = OPEN(name=u'ResultType', mode=MODE_TYPE, opt=True)
    _OPERATION_Errors = CLASS(name=u'Errors', mode=MODE_SET, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')), opt=True)
    _OPERATION_operationCode = CHOICE(name=u'operationCode', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')), opt=True, uniq=True)
    OPERATION._cont = ASN1Dict([
        (u'ArgumentType', _OPERATION_ArgumentType),
        (u'ResultType', _OPERATION_ResultType),
        (u'Errors', _OPERATION_Errors),
        (u'operationCode', _OPERATION_operationCode),
        ])
    
    #-----< ERROR >-----#
    ERROR = CLASS(name=u'ERROR', mode=MODE_TYPE)
    _ERROR_ParameterType = OPEN(name=u'ParameterType', mode=MODE_TYPE)
    _ERROR_errorCode = CHOICE(name=u'errorCode', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')), opt=True, uniq=True)
    ERROR._cont = ASN1Dict([
        (u'ParameterType', _ERROR_ParameterType),
        (u'errorCode', _ERROR_errorCode),
        ])
    
    #-----< Code >-----#
    Code = CHOICE(name=u'Code', mode=MODE_TYPE)
    _Code_local = INT(name=u'local', mode=MODE_TYPE)
    _Code_global_ = OID(name=u'global', mode=MODE_TYPE)
    Code._cont = ASN1Dict([
        (u'local', _Code_local),
        (u'global', _Code_global_),
        ])
    Code._ext = []
    
    #-----< InvokeId >-----#
    InvokeId = CHOICE(name=u'InvokeId', mode=MODE_TYPE)
    _InvokeId_present = INT(name=u'present', mode=MODE_TYPE)
    _InvokeId_absent = NULL(name=u'absent', mode=MODE_TYPE)
    InvokeId._cont = ASN1Dict([
        (u'present', _InvokeId_present),
        (u'absent', _InvokeId_absent),
        ])
    InvokeId._ext = []
    
    #-----< id-opcode-read >-----#
    id_opcode_read = CHOICE(name=u'id-opcode-read', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_read._val = (u'local', 1)
    
    #-----< id-opcode-compare >-----#
    id_opcode_compare = CHOICE(name=u'id-opcode-compare', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_compare._val = (u'local', 2)
    
    #-----< id-opcode-abandon >-----#
    id_opcode_abandon = CHOICE(name=u'id-opcode-abandon', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_abandon._val = (u'local', 3)
    
    #-----< id-opcode-list >-----#
    id_opcode_list = CHOICE(name=u'id-opcode-list', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_list._val = (u'local', 4)
    
    #-----< id-opcode-search >-----#
    id_opcode_search = CHOICE(name=u'id-opcode-search', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_search._val = (u'local', 5)
    
    #-----< id-opcode-addEntry >-----#
    id_opcode_addEntry = CHOICE(name=u'id-opcode-addEntry', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_addEntry._val = (u'local', 6)
    
    #-----< id-opcode-removeEntry >-----#
    id_opcode_removeEntry = CHOICE(name=u'id-opcode-removeEntry', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_removeEntry._val = (u'local', 7)
    
    #-----< id-opcode-modifyEntry >-----#
    id_opcode_modifyEntry = CHOICE(name=u'id-opcode-modifyEntry', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_modifyEntry._val = (u'local', 8)
    
    #-----< id-opcode-modifyDN >-----#
    id_opcode_modifyDN = CHOICE(name=u'id-opcode-modifyDN', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_modifyDN._val = (u'local', 9)
    
    #-----< id-opcode-changePassword >-----#
    id_opcode_changePassword = CHOICE(name=u'id-opcode-changePassword', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_changePassword._val = (u'local', 10)
    
    #-----< id-opcode-administerPassword >-----#
    id_opcode_administerPassword = CHOICE(name=u'id-opcode-administerPassword', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_administerPassword._val = (u'local', 11)
    
    #-----< id-opcode-ldapTransport >-----#
    id_opcode_ldapTransport = CHOICE(name=u'id-opcode-ldapTransport', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_ldapTransport._val = (u'local', 12)
    
    #-----< id-opcode-linkedLDAP >-----#
    id_opcode_linkedLDAP = CHOICE(name=u'id-opcode-linkedLDAP', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_linkedLDAP._val = (u'local', 13)
    
    #-----< id-opcode-requestShadowUpdate >-----#
    id_opcode_requestShadowUpdate = CHOICE(name=u'id-opcode-requestShadowUpdate', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_requestShadowUpdate._val = (u'local', 1)
    
    #-----< id-opcode-updateShadow >-----#
    id_opcode_updateShadow = CHOICE(name=u'id-opcode-updateShadow', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_updateShadow._val = (u'local', 2)
    
    #-----< id-opcode-coordinateShadowUpdate >-----#
    id_opcode_coordinateShadowUpdate = CHOICE(name=u'id-opcode-coordinateShadowUpdate', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_coordinateShadowUpdate._val = (u'local', 3)
    
    #-----< id-op-establishOperationalBinding >-----#
    id_op_establishOperationalBinding = CHOICE(name=u'id-op-establishOperationalBinding', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_op_establishOperationalBinding._val = (u'local', 100)
    
    #-----< id-op-modifyOperationalBinding >-----#
    id_op_modifyOperationalBinding = CHOICE(name=u'id-op-modifyOperationalBinding', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_op_modifyOperationalBinding._val = (u'local', 102)
    
    #-----< id-op-terminateOperationalBinding >-----#
    id_op_terminateOperationalBinding = CHOICE(name=u'id-op-terminateOperationalBinding', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_op_terminateOperationalBinding._val = (u'local', 101)
    
    #-----< id-errcode-attributeError >-----#
    id_errcode_attributeError = CHOICE(name=u'id-errcode-attributeError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_attributeError._val = (u'local', 1)
    
    #-----< id-errcode-nameError >-----#
    id_errcode_nameError = CHOICE(name=u'id-errcode-nameError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_nameError._val = (u'local', 2)
    
    #-----< id-errcode-serviceError >-----#
    id_errcode_serviceError = CHOICE(name=u'id-errcode-serviceError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_serviceError._val = (u'local', 3)
    
    #-----< id-errcode-referral >-----#
    id_errcode_referral = CHOICE(name=u'id-errcode-referral', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_referral._val = (u'local', 4)
    
    #-----< id-errcode-abandoned >-----#
    id_errcode_abandoned = CHOICE(name=u'id-errcode-abandoned', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_abandoned._val = (u'local', 5)
    
    #-----< id-errcode-securityError >-----#
    id_errcode_securityError = CHOICE(name=u'id-errcode-securityError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_securityError._val = (u'local', 6)
    
    #-----< id-errcode-abandonFailed >-----#
    id_errcode_abandonFailed = CHOICE(name=u'id-errcode-abandonFailed', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_abandonFailed._val = (u'local', 7)
    
    #-----< id-errcode-updateError >-----#
    id_errcode_updateError = CHOICE(name=u'id-errcode-updateError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_updateError._val = (u'local', 8)
    
    #-----< id-errcode-dsaReferral >-----#
    id_errcode_dsaReferral = CHOICE(name=u'id-errcode-dsaReferral', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_dsaReferral._val = (u'local', 9)
    
    #-----< id-errcode-shadowError >-----#
    id_errcode_shadowError = CHOICE(name=u'id-errcode-shadowError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_shadowError._val = (u'local', 1)
    
    #-----< id-err-operationalBindingError >-----#
    id_err_operationalBindingError = CHOICE(name=u'id-err-operationalBindingError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_err_operationalBindingError._val = (u'local', 100)
    
    #-----< DOP-Invokable >-----#
    DOP_Invokable = CLASS(name=u'DOP-Invokable', mode=MODE_SET, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _DOP_Invokable_val_ArgumentType_0 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'EstablishOperationalBindingArgument')))
    _DOP_Invokable_val_ResultType_0 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'EstablishOperationalBindingResult')))
    __OPERATION_Errors_val_ParameterType_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    ___OPERATION_Errors_val_ParameterType_0_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'OpBindingErrorParam')))
    ___OPERATION_Errors_val_ParameterType_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'OpBindingErrorParam')))
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    __________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    __________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ___________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = __________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = __________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_0_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    ___OPERATION_Errors_val_ParameterType_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier),
        (u'signature', ____OPERATION_Errors_val_ParameterType_0_signed_signature),
        ])
    ___OPERATION_Errors_val_ParameterType_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_0._ext = None
    __OPERATION_Errors_val_ParameterType_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_1_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ___OPERATION_Errors_val_ParameterType_1_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_1_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    ___OPERATION_Errors_val_ParameterType_1_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier),
        (u'signature', ____OPERATION_Errors_val_ParameterType_1_signed_signature),
        ])
    ___OPERATION_Errors_val_ParameterType_1_signed._ext = []
    __OPERATION_Errors_val_ParameterType_1._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_1_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_1_signed),
        ])
    __OPERATION_Errors_val_ParameterType_1._ext = None
    _DOP_Invokable_val_ArgumentType_1 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'ModifyOperationalBindingArgument')))
    _DOP_Invokable_val_ResultType_1 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'ModifyOperationalBindingResult')))
    _DOP_Invokable_val_ArgumentType_2 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'TerminateOperationalBindingArgument')))
    _DOP_Invokable_val_ResultType_2 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'TerminateOperationalBindingResult')))
    DOP_Invokable._val = ASN1Set(rv=[dict([(u'ArgumentType', _DOP_Invokable_val_ArgumentType_0), (u'ResultType', _DOP_Invokable_val_ResultType_0), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 100))]), dict([(u'ArgumentType', _DOP_Invokable_val_ArgumentType_1), (u'ResultType', _DOP_Invokable_val_ResultType_1), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 102))]), dict([(u'ArgumentType', _DOP_Invokable_val_ArgumentType_2), (u'ResultType', _DOP_Invokable_val_ResultType_2), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 101))])], rr=[], ev=None, er=[])
    
    #-----< DOP-Returnable >-----#
    DOP_Returnable = CLASS(name=u'DOP-Returnable', mode=MODE_SET, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _DOP_Returnable_val_ArgumentType_0 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'EstablishOperationalBindingArgument')))
    _DOP_Returnable_val_ResultType_0 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'EstablishOperationalBindingResult')))
    _DOP_Returnable_val_ArgumentType_1 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'ModifyOperationalBindingArgument')))
    _DOP_Returnable_val_ResultType_1 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'ModifyOperationalBindingResult')))
    _DOP_Returnable_val_ArgumentType_2 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'TerminateOperationalBindingArgument')))
    _DOP_Returnable_val_ResultType_2 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'TerminateOperationalBindingResult')))
    DOP_Returnable._val = ASN1Set(rv=[dict([(u'ArgumentType', _DOP_Returnable_val_ArgumentType_0), (u'ResultType', _DOP_Returnable_val_ResultType_0), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 100))]), dict([(u'ArgumentType', _DOP_Returnable_val_ArgumentType_1), (u'ResultType', _DOP_Returnable_val_ResultType_1), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 102))]), dict([(u'ArgumentType', _DOP_Returnable_val_ArgumentType_2), (u'ResultType', _DOP_Returnable_val_ResultType_2), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 101))])], rr=[], ev=None, er=[])
    
    _all_ = [
        _OPERATION_ArgumentType,
        _OPERATION_ResultType,
        _OPERATION_Errors,
        _OPERATION_operationCode,
        OPERATION,
        _ERROR_ParameterType,
        _ERROR_errorCode,
        ERROR,
        _Code_local,
        _Code_global_,
        Code,
        _InvokeId_present,
        _InvokeId_absent,
        InvokeId,
        id_opcode_read,
        id_opcode_compare,
        id_opcode_abandon,
        id_opcode_list,
        id_opcode_search,
        id_opcode_addEntry,
        id_opcode_removeEntry,
        id_opcode_modifyEntry,
        id_opcode_modifyDN,
        id_opcode_changePassword,
        id_opcode_administerPassword,
        id_opcode_ldapTransport,
        id_opcode_linkedLDAP,
        id_opcode_requestShadowUpdate,
        id_opcode_updateShadow,
        id_opcode_coordinateShadowUpdate,
        id_op_establishOperationalBinding,
        id_op_modifyOperationalBinding,
        id_op_terminateOperationalBinding,
        id_errcode_attributeError,
        id_errcode_nameError,
        id_errcode_serviceError,
        id_errcode_referral,
        id_errcode_abandoned,
        id_errcode_securityError,
        id_errcode_abandonFailed,
        id_errcode_updateError,
        id_errcode_dsaReferral,
        id_errcode_shadowError,
        id_err_operationalBindingError,
        DOP_Invokable,
        _DOP_Invokable_val_ArgumentType_0,
        _DOP_Invokable_val_ResultType_0,
        ___OPERATION_Errors_val_ParameterType_0_unsigned,
        ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned,
        ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_0,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_1,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_6,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_7,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_8,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_9,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_10,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_11,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_12,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_13,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_14,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_15,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_16,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_17,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_18,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_19,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_20,
        __________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab,
        ___________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0,
        _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm,
        _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters,
        ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm,
        ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength,
        ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_28,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_29,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_30,
        _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_31,
        _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm,
        _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters,
        ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier,
        ____OPERATION_Errors_val_ParameterType_0_signed_signature,
        ___OPERATION_Errors_val_ParameterType_0_signed,
        __OPERATION_Errors_val_ParameterType_0,
        ___OPERATION_Errors_val_ParameterType_1_unsigned,
        ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned,
        _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm,
        _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters,
        ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier,
        ____OPERATION_Errors_val_ParameterType_1_signed_signature,
        ___OPERATION_Errors_val_ParameterType_1_signed,
        __OPERATION_Errors_val_ParameterType_1,
        _DOP_Invokable_val_ArgumentType_1,
        _DOP_Invokable_val_ResultType_1,
        _DOP_Invokable_val_ArgumentType_2,
        _DOP_Invokable_val_ResultType_2,
        DOP_Returnable,
        _DOP_Returnable_val_ArgumentType_0,
        _DOP_Returnable_val_ResultType_0,
        _DOP_Returnable_val_ArgumentType_1,
        _DOP_Returnable_val_ResultType_1,
        _DOP_Returnable_val_ArgumentType_2,
        _DOP_Returnable_val_ResultType_2,
    ]

class DirectoryAbstractService:

    _name_  = u'DirectoryAbstractService'
    _oid_   = [2, 5, 1, 2, 8]
    
    _obj_ = [
        u'CommonArguments',
        u'CommonArgumentsSeq',
        u'FamilyGrouping',
        u'CommonResults',
        u'CommonResultsSeq',
        u'ServiceControls',
        u'ServiceControlOptions',
        u'EntryInformationSelection',
        u'ContextSelection',
        u'TypeAndContextAssertion',
        u'FamilyReturn',
        u'EntryInformation',
        u'family-information',
        u'FamilyEntries',
        u'FamilyEntry',
        u'Filter',
        u'FilterItem',
        u'MatchingRuleAssertion',
        u'PagedResultsRequest',
        u'SortKey',
        u'SecurityParameters',
        u'ProtectionRequest',
        u'Time',
        u'ErrorProtectionRequest',
        u'directoryBind',
        u'DirectoryBindArgument',
        u'Credentials',
        u'SimpleCredentials',
        u'StrongCredentials',
        u'SpkmCredentials',
        u'SaslCredentials',
        u'ub-saslMechanism',
        u'Token',
        u'TokenContent',
        u'Versions',
        u'DirectoryBindResult',
        u'PwdResponseValue',
        u'directoryBindError',
        u'BindKeyInfo',
        u'read',
        u'ReadArgument',
        u'ReadArgumentData',
        u'ReadResult',
        u'ReadResultData',
        u'ModifyRights',
        u'compare',
        u'CompareArgument',
        u'CompareArgumentData',
        u'CompareResult',
        u'CompareResultData',
        u'abandon',
        u'AbandonArgument',
        u'AbandonArgumentData',
        u'AbandonResult',
        u'AbandonResultData',
        u'list',
        u'ListArgument',
        u'ListArgumentData',
        u'ListResult',
        u'ListResultData',
        u'PartialOutcomeQualifier',
        u'LimitProblem',
        u'search',
        u'SearchArgument',
        u'SearchArgumentData',
        u'HierarchySelections',
        u'SearchControlOptions',
        u'JoinArgument',
        u'DomainLocalID',
        u'JoinAttPair',
        u'JoinContextType',
        u'SearchResult',
        u'SearchResultData',
        u'addEntry',
        u'AddEntryArgument',
        u'AddEntryArgumentData',
        u'AddEntryResult',
        u'AddEntryResultData',
        u'removeEntry',
        u'RemoveEntryArgument',
        u'RemoveEntryArgumentData',
        u'RemoveEntryResult',
        u'RemoveEntryResultData',
        u'modifyEntry',
        u'ModifyEntryArgument',
        u'ModifyEntryArgumentData',
        u'ModifyEntryResult',
        u'ModifyEntryResultData',
        u'EntryModification',
        u'modifyDN',
        u'ModifyDNArgument',
        u'ModifyDNArgumentData',
        u'ModifyDNResult',
        u'ModifyDNResultData',
        u'changePassword',
        u'ChangePasswordArgument',
        u'ChangePasswordArgumentData',
        u'ChangePasswordResult',
        u'ChangePasswordResultData',
        u'administerPassword',
        u'AdministerPasswordArgument',
        u'AdministerPasswordArgumentData',
        u'AdministerPasswordResult',
        u'AdministerPasswordResultData',
        u'ldapTransport',
        u'LdapArgument',
        u'LdapArgumentData',
        u'LinkId',
        u'LdapResult',
        u'LdapResultData',
        u'linkedLDAP',
        u'LinkedArgument',
        u'LinkedArgumentData',
        u'LinkedResult',
        u'abandoned',
        u'AbandonedData',
        u'AbandonedProblem',
        u'abandonFailed',
        u'AbandonFailedData',
        u'AbandonProblem',
        u'attributeError',
        u'AttributeErrorData',
        u'AttributeProblem',
        u'nameError',
        u'NameErrorData',
        u'NameProblem',
        u'referral',
        u'ReferralData',
        u'securityError',
        u'SecurityErrorData',
        u'SecurityProblem',
        u'EncPwdInfo',
        u'serviceError',
        u'ServiceErrorData',
        u'ServiceProblem',
        u'updateError',
        u'UpdateErrorData',
        u'UpdateProblem',
        u'id-at-family-information',
        ]
    _type_ = [
        u'CommonArguments',
        u'CommonArgumentsSeq',
        u'FamilyGrouping',
        u'CommonResults',
        u'CommonResultsSeq',
        u'ServiceControls',
        u'ServiceControlOptions',
        u'EntryInformationSelection',
        u'ContextSelection',
        u'TypeAndContextAssertion',
        u'FamilyReturn',
        u'EntryInformation',
        u'FamilyEntries',
        u'FamilyEntry',
        u'Filter',
        u'FilterItem',
        u'MatchingRuleAssertion',
        u'PagedResultsRequest',
        u'SortKey',
        u'SecurityParameters',
        u'ProtectionRequest',
        u'Time',
        u'ErrorProtectionRequest',
        u'DirectoryBindArgument',
        u'Credentials',
        u'SimpleCredentials',
        u'StrongCredentials',
        u'SpkmCredentials',
        u'SaslCredentials',
        u'Token',
        u'TokenContent',
        u'Versions',
        u'DirectoryBindResult',
        u'PwdResponseValue',
        u'BindKeyInfo',
        u'ReadArgument',
        u'ReadArgumentData',
        u'ReadResult',
        u'ReadResultData',
        u'ModifyRights',
        u'CompareArgument',
        u'CompareArgumentData',
        u'CompareResult',
        u'CompareResultData',
        u'AbandonArgument',
        u'AbandonArgumentData',
        u'AbandonResult',
        u'AbandonResultData',
        u'ListArgument',
        u'ListArgumentData',
        u'ListResult',
        u'ListResultData',
        u'PartialOutcomeQualifier',
        u'LimitProblem',
        u'SearchArgument',
        u'SearchArgumentData',
        u'HierarchySelections',
        u'SearchControlOptions',
        u'JoinArgument',
        u'DomainLocalID',
        u'JoinAttPair',
        u'JoinContextType',
        u'SearchResult',
        u'SearchResultData',
        u'AddEntryArgument',
        u'AddEntryArgumentData',
        u'AddEntryResult',
        u'AddEntryResultData',
        u'RemoveEntryArgument',
        u'RemoveEntryArgumentData',
        u'RemoveEntryResult',
        u'RemoveEntryResultData',
        u'ModifyEntryArgument',
        u'ModifyEntryArgumentData',
        u'ModifyEntryResult',
        u'ModifyEntryResultData',
        u'EntryModification',
        u'ModifyDNArgument',
        u'ModifyDNArgumentData',
        u'ModifyDNResult',
        u'ModifyDNResultData',
        u'ChangePasswordArgument',
        u'ChangePasswordArgumentData',
        u'ChangePasswordResult',
        u'ChangePasswordResultData',
        u'AdministerPasswordArgument',
        u'AdministerPasswordArgumentData',
        u'AdministerPasswordResult',
        u'AdministerPasswordResultData',
        u'LdapArgument',
        u'LdapArgumentData',
        u'LinkId',
        u'LdapResult',
        u'LdapResultData',
        u'LinkedArgument',
        u'LinkedArgumentData',
        u'LinkedResult',
        u'AbandonedData',
        u'AbandonedProblem',
        u'AbandonFailedData',
        u'AbandonProblem',
        u'AttributeErrorData',
        u'AttributeProblem',
        u'NameErrorData',
        u'NameProblem',
        u'ReferralData',
        u'SecurityErrorData',
        u'SecurityProblem',
        u'EncPwdInfo',
        u'ServiceErrorData',
        u'ServiceProblem',
        u'UpdateErrorData',
        u'UpdateProblem',
        ]
    _set_ = [
        ]
    _val_ = [
        u'family-information',
        u'directoryBind',
        u'ub-saslMechanism',
        u'directoryBindError',
        u'read',
        u'compare',
        u'abandon',
        u'list',
        u'search',
        u'addEntry',
        u'removeEntry',
        u'modifyEntry',
        u'modifyDN',
        u'changePassword',
        u'administerPassword',
        u'ldapTransport',
        u'linkedLDAP',
        u'abandoned',
        u'abandonFailed',
        u'attributeError',
        u'nameError',
        u'referral',
        u'securityError',
        u'serviceError',
        u'updateError',
        u'id-at-family-information',
        ]
    _class_ = [
        u'family-information',
        u'directoryBind',
        u'directoryBindError',
        u'read',
        u'compare',
        u'abandon',
        u'list',
        u'search',
        u'addEntry',
        u'removeEntry',
        u'modifyEntry',
        u'modifyDN',
        u'changePassword',
        u'administerPassword',
        u'ldapTransport',
        u'linkedLDAP',
        u'abandoned',
        u'abandonFailed',
        u'attributeError',
        u'nameError',
        u'referral',
        u'securityError',
        u'serviceError',
        u'updateError',
        ]
    _param_ = [
        ]
    
    #-----< CommonArguments >-----#
    CommonArguments = SET(name=u'CommonArguments', mode=MODE_TYPE)
    _CommonArguments_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _CommonArguments_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CommonArguments_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CommonArguments_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _CommonArguments_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CommonArguments_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CommonArguments_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _CommonArguments_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _CommonArguments_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _CommonArguments_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CommonArguments_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _CommonArguments_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    CommonArguments._cont = ASN1Dict([
        (u'serviceControls', _CommonArguments_serviceControls),
        (u'securityParameters', _CommonArguments_securityParameters),
        (u'requestor', _CommonArguments_requestor),
        (u'operationProgress', _CommonArguments_operationProgress),
        (u'aliasedRDNs', _CommonArguments_aliasedRDNs),
        (u'criticalExtensions', _CommonArguments_criticalExtensions),
        (u'referenceType', _CommonArguments_referenceType),
        (u'entryOnly', _CommonArguments_entryOnly),
        (u'exclusions', _CommonArguments_exclusions),
        (u'nameResolveOnMaster', _CommonArguments_nameResolveOnMaster),
        (u'operationContexts', _CommonArguments_operationContexts),
        (u'familyGrouping', _CommonArguments_familyGrouping),
        ])
    CommonArguments._ext = []
    
    #-----< CommonArgumentsSeq >-----#
    CommonArgumentsSeq = SEQ(name=u'CommonArgumentsSeq', mode=MODE_TYPE)
    _CommonArgumentsSeq_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _CommonArgumentsSeq_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CommonArgumentsSeq_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CommonArgumentsSeq_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _CommonArgumentsSeq_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CommonArgumentsSeq_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CommonArgumentsSeq_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _CommonArgumentsSeq_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _CommonArgumentsSeq_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _CommonArgumentsSeq_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CommonArgumentsSeq_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _CommonArgumentsSeq_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    CommonArgumentsSeq._cont = ASN1Dict([
        (u'serviceControls', _CommonArgumentsSeq_serviceControls),
        (u'securityParameters', _CommonArgumentsSeq_securityParameters),
        (u'requestor', _CommonArgumentsSeq_requestor),
        (u'operationProgress', _CommonArgumentsSeq_operationProgress),
        (u'aliasedRDNs', _CommonArgumentsSeq_aliasedRDNs),
        (u'criticalExtensions', _CommonArgumentsSeq_criticalExtensions),
        (u'referenceType', _CommonArgumentsSeq_referenceType),
        (u'entryOnly', _CommonArgumentsSeq_entryOnly),
        (u'exclusions', _CommonArgumentsSeq_exclusions),
        (u'nameResolveOnMaster', _CommonArgumentsSeq_nameResolveOnMaster),
        (u'operationContexts', _CommonArgumentsSeq_operationContexts),
        (u'familyGrouping', _CommonArgumentsSeq_familyGrouping),
        ])
    CommonArgumentsSeq._ext = []
    
    #-----< FamilyGrouping >-----#
    FamilyGrouping = ENUM(name=u'FamilyGrouping', mode=MODE_TYPE)
    FamilyGrouping._cont = ASN1Dict([(u'entryOnly', 1), (u'compoundEntry', 2), (u'strands', 3), (u'multiStrand', 4)])
    FamilyGrouping._ext = []
    
    #-----< CommonResults >-----#
    CommonResults = SET(name=u'CommonResults', mode=MODE_TYPE)
    _CommonResults_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CommonResults_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CommonResults_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CommonResults_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __CommonResults_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___CommonResults_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____CommonResults_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____CommonResults_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    _____CommonResults_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0 = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____CommonResults_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____CommonResults_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____CommonResults_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___CommonResults_notification__item__type._const_tab = ____CommonResults_notification__item__type_tab
    ___CommonResults_notification__item__type._const_tab_at = None
    ___CommonResults_notification__item__type._const_tab_id = u'id'
    ___CommonResults_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____CommonResults_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____CommonResults_notification__item__values__item_._const_tab = ____CommonResults_notification__item__type_tab
    ____CommonResults_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____CommonResults_notification__item__values__item_._const_tab_id = u'Type'
    ___CommonResults_notification__item__values._cont = ____CommonResults_notification__item__values__item_
    ___CommonResults_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___CommonResults_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____CommonResults_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____CommonResults_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____CommonResults_notification__item__valuesWithContext__item__value._const_tab = ____CommonResults_notification__item__type_tab
    _____CommonResults_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____CommonResults_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____CommonResults_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______CommonResults_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____CommonResults_notification__item__valuesWithContext__item__contextList._cont = ______CommonResults_notification__item__valuesWithContext__item__contextList__item_
    _____CommonResults_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____CommonResults_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____CommonResults_notification__item__valuesWithContext__item__value),
        (u'contextList', _____CommonResults_notification__item__valuesWithContext__item__contextList),
        ])
    ____CommonResults_notification__item__valuesWithContext__item_._ext = []
    ___CommonResults_notification__item__valuesWithContext._cont = ____CommonResults_notification__item__valuesWithContext__item_
    ___CommonResults_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __CommonResults_notification__item_._cont = ASN1Dict([
        (u'type', ___CommonResults_notification__item__type),
        (u'values', ___CommonResults_notification__item__values),
        (u'valuesWithContext', ___CommonResults_notification__item__valuesWithContext),
        ])
    __CommonResults_notification__item_._ext = []
    _CommonResults_notification._cont = __CommonResults_notification__item_
    _CommonResults_notification._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    CommonResults._cont = ASN1Dict([
        (u'securityParameters', _CommonResults_securityParameters),
        (u'performer', _CommonResults_performer),
        (u'aliasDereferenced', _CommonResults_aliasDereferenced),
        (u'notification', _CommonResults_notification),
        ])
    CommonResults._ext = []
    
    #-----< CommonResultsSeq >-----#
    CommonResultsSeq = SEQ(name=u'CommonResultsSeq', mode=MODE_TYPE)
    _CommonResultsSeq_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CommonResultsSeq_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CommonResultsSeq_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CommonResultsSeq_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __CommonResultsSeq_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___CommonResultsSeq_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____CommonResultsSeq_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____CommonResultsSeq_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____CommonResultsSeq_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____CommonResultsSeq_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____CommonResultsSeq_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____CommonResultsSeq_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___CommonResultsSeq_notification__item__type._const_tab = ____CommonResultsSeq_notification__item__type_tab
    ___CommonResultsSeq_notification__item__type._const_tab_at = None
    ___CommonResultsSeq_notification__item__type._const_tab_id = u'id'
    ___CommonResultsSeq_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____CommonResultsSeq_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____CommonResultsSeq_notification__item__values__item_._const_tab = ____CommonResultsSeq_notification__item__type_tab
    ____CommonResultsSeq_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____CommonResultsSeq_notification__item__values__item_._const_tab_id = u'Type'
    ___CommonResultsSeq_notification__item__values._cont = ____CommonResultsSeq_notification__item__values__item_
    ___CommonResultsSeq_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___CommonResultsSeq_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____CommonResultsSeq_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____CommonResultsSeq_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____CommonResultsSeq_notification__item__valuesWithContext__item__value._const_tab = ____CommonResultsSeq_notification__item__type_tab
    _____CommonResultsSeq_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____CommonResultsSeq_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____CommonResultsSeq_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______CommonResultsSeq_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____CommonResultsSeq_notification__item__valuesWithContext__item__contextList._cont = ______CommonResultsSeq_notification__item__valuesWithContext__item__contextList__item_
    _____CommonResultsSeq_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____CommonResultsSeq_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____CommonResultsSeq_notification__item__valuesWithContext__item__value),
        (u'contextList', _____CommonResultsSeq_notification__item__valuesWithContext__item__contextList),
        ])
    ____CommonResultsSeq_notification__item__valuesWithContext__item_._ext = []
    ___CommonResultsSeq_notification__item__valuesWithContext._cont = ____CommonResultsSeq_notification__item__valuesWithContext__item_
    ___CommonResultsSeq_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __CommonResultsSeq_notification__item_._cont = ASN1Dict([
        (u'type', ___CommonResultsSeq_notification__item__type),
        (u'values', ___CommonResultsSeq_notification__item__values),
        (u'valuesWithContext', ___CommonResultsSeq_notification__item__valuesWithContext),
        ])
    __CommonResultsSeq_notification__item_._ext = []
    _CommonResultsSeq_notification._cont = __CommonResultsSeq_notification__item_
    _CommonResultsSeq_notification._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    CommonResultsSeq._cont = ASN1Dict([
        (u'securityParameters', _CommonResultsSeq_securityParameters),
        (u'performer', _CommonResultsSeq_performer),
        (u'aliasDereferenced', _CommonResultsSeq_aliasDereferenced),
        (u'notification', _CommonResultsSeq_notification),
        ])
    CommonResultsSeq._ext = []
    
    #-----< ServiceControls >-----#
    ServiceControls = SET(name=u'ServiceControls', mode=MODE_TYPE)
    _ServiceControls_options = BIT_STR(name=u'options', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControlOptions')), default=(0, 0))
    _ServiceControls_priority = INT(name=u'priority', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _ServiceControls_priority._cont = ASN1Dict([(u'low', 0), (u'medium', 1), (u'high', 2)])
    _ServiceControls_timeLimit = INT(name=u'timeLimit', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_sizeLimit = INT(name=u'sizeLimit', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_scopeOfReferral = INT(name=u'scopeOfReferral', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_scopeOfReferral._cont = ASN1Dict([(u'dmd', 0), (u'country', 1)])
    _ServiceControls_attributeSizeLimit = INT(name=u'attributeSizeLimit', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_manageDSAITPlaneRef = SEQ(name=u'manageDSAITPlaneRef', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ServiceControls_manageDSAITPlaneRef_dsaName = CHOICE(name=u'dsaName', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    __ServiceControls_manageDSAITPlaneRef_agreementID = SEQ(name=u'agreementID', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryShadowAbstractService', 'AgreementID')))
    _ServiceControls_manageDSAITPlaneRef._cont = ASN1Dict([
        (u'dsaName', __ServiceControls_manageDSAITPlaneRef_dsaName),
        (u'agreementID', __ServiceControls_manageDSAITPlaneRef_agreementID),
        ])
    _ServiceControls_manageDSAITPlaneRef._ext = []
    _ServiceControls_serviceType = OID(name=u'serviceType', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_userClass = INT(name=u'userClass', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ServiceControls._cont = ASN1Dict([
        (u'options', _ServiceControls_options),
        (u'priority', _ServiceControls_priority),
        (u'timeLimit', _ServiceControls_timeLimit),
        (u'sizeLimit', _ServiceControls_sizeLimit),
        (u'scopeOfReferral', _ServiceControls_scopeOfReferral),
        (u'attributeSizeLimit', _ServiceControls_attributeSizeLimit),
        (u'manageDSAITPlaneRef', _ServiceControls_manageDSAITPlaneRef),
        (u'serviceType', _ServiceControls_serviceType),
        (u'userClass', _ServiceControls_userClass),
        ])
    ServiceControls._ext = []
    
    #-----< ServiceControlOptions >-----#
    ServiceControlOptions = BIT_STR(name=u'ServiceControlOptions', mode=MODE_TYPE)
    ServiceControlOptions._cont = ASN1Dict([(u'preferChaining', 0), (u'chainingProhibited', 1), (u'localScope', 2), (u'dontUseCopy', 3), (u'dontDereferenceAliases', 4), (u'subentries', 5), (u'copyShallDo', 6), (u'partialNameResolution', 7), (u'manageDSAIT', 8), (u'noSubtypeMatch', 9), (u'noSubtypeSelection', 10), (u'countFamily', 11), (u'dontSelectFriends', 12), (u'dontMatchFriends', 13), (u'allowWriteableCopy', 14)])
    
    #-----< EntryInformationSelection >-----#
    EntryInformationSelection = SET(name=u'EntryInformationSelection', mode=MODE_TYPE)
    _EntryInformationSelection_attributes = CHOICE(name=u'attributes', mode=MODE_TYPE, default=(u'allUserAttributes', 0))
    __EntryInformationSelection_attributes_allUserAttributes = NULL(name=u'allUserAttributes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EntryInformationSelection_attributes_select = SET_OF(name=u'select', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EntryInformationSelection_attributes_select__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    __EntryInformationSelection_attributes_select._cont = ___EntryInformationSelection_attributes_select__item_
    _EntryInformationSelection_attributes._cont = ASN1Dict([
        (u'allUserAttributes', __EntryInformationSelection_attributes_allUserAttributes),
        (u'select', __EntryInformationSelection_attributes_select),
        ])
    _EntryInformationSelection_attributes._ext = None
    _EntryInformationSelection_infoTypes = INT(name=u'infoTypes', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _EntryInformationSelection_infoTypes._cont = ASN1Dict([(u'attributeTypesOnly', 0), (u'attributeTypesAndValues', 1)])
    _EntryInformationSelection_extraAttributes = CHOICE(name=u'extraAttributes', mode=MODE_TYPE, opt=True)
    __EntryInformationSelection_extraAttributes_allOperationalAttributes = NULL(name=u'allOperationalAttributes', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EntryInformationSelection_extraAttributes_select = SET_OF(name=u'select', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EntryInformationSelection_extraAttributes_select__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    __EntryInformationSelection_extraAttributes_select._cont = ___EntryInformationSelection_extraAttributes_select__item_
    __EntryInformationSelection_extraAttributes_select._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _EntryInformationSelection_extraAttributes._cont = ASN1Dict([
        (u'allOperationalAttributes', __EntryInformationSelection_extraAttributes_allOperationalAttributes),
        (u'select', __EntryInformationSelection_extraAttributes_select),
        ])
    _EntryInformationSelection_extraAttributes._ext = None
    _EntryInformationSelection_contextSelection = CHOICE(name=u'contextSelection', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _EntryInformationSelection_returnContexts = BOOL(name=u'returnContexts', mode=MODE_TYPE, default=False)
    _EntryInformationSelection_familyReturn = SEQ(name=u'familyReturn', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyReturn')), default=dict([(u'memberSelect', u'contributingEntriesOnly')]))
    EntryInformationSelection._cont = ASN1Dict([
        (u'attributes', _EntryInformationSelection_attributes),
        (u'infoTypes', _EntryInformationSelection_infoTypes),
        (u'extraAttributes', _EntryInformationSelection_extraAttributes),
        (u'contextSelection', _EntryInformationSelection_contextSelection),
        (u'returnContexts', _EntryInformationSelection_returnContexts),
        (u'familyReturn', _EntryInformationSelection_familyReturn),
        ])
    EntryInformationSelection._ext = None
    
    #-----< ContextSelection >-----#
    ContextSelection = CHOICE(name=u'ContextSelection', mode=MODE_TYPE)
    _ContextSelection_allContexts = NULL(name=u'allContexts', mode=MODE_TYPE)
    _ContextSelection_selectedContexts = SET_OF(name=u'selectedContexts', mode=MODE_TYPE)
    __ContextSelection_selectedContexts__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'TypeAndContextAssertion')))
    _ContextSelection_selectedContexts._cont = __ContextSelection_selectedContexts__item_
    _ContextSelection_selectedContexts._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ContextSelection._cont = ASN1Dict([
        (u'allContexts', _ContextSelection_allContexts),
        (u'selectedContexts', _ContextSelection_selectedContexts),
        ])
    ContextSelection._ext = []
    
    #-----< TypeAndContextAssertion >-----#
    TypeAndContextAssertion = SEQ(name=u'TypeAndContextAssertion', mode=MODE_TYPE)
    _TypeAndContextAssertion_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _TypeAndContextAssertion_contextAssertions = CHOICE(name=u'contextAssertions', mode=MODE_TYPE)
    __TypeAndContextAssertion_contextAssertions_preference = SEQ_OF(name=u'preference', mode=MODE_TYPE)
    ___TypeAndContextAssertion_contextAssertions_preference__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'ContextAssertion')))
    __TypeAndContextAssertion_contextAssertions_preference._cont = ___TypeAndContextAssertion_contextAssertions_preference__item_
    __TypeAndContextAssertion_contextAssertions_all = SET_OF(name=u'all', mode=MODE_TYPE)
    ___TypeAndContextAssertion_contextAssertions_all__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'ContextAssertion')))
    __TypeAndContextAssertion_contextAssertions_all._cont = ___TypeAndContextAssertion_contextAssertions_all__item_
    _TypeAndContextAssertion_contextAssertions._cont = ASN1Dict([
        (u'preference', __TypeAndContextAssertion_contextAssertions_preference),
        (u'all', __TypeAndContextAssertion_contextAssertions_all),
        ])
    _TypeAndContextAssertion_contextAssertions._ext = []
    TypeAndContextAssertion._cont = ASN1Dict([
        (u'type', _TypeAndContextAssertion_type),
        (u'contextAssertions', _TypeAndContextAssertion_contextAssertions),
        ])
    TypeAndContextAssertion._ext = []
    
    #-----< FamilyReturn >-----#
    FamilyReturn = SEQ(name=u'FamilyReturn', mode=MODE_TYPE)
    _FamilyReturn_memberSelect = ENUM(name=u'memberSelect', mode=MODE_TYPE)
    _FamilyReturn_memberSelect._cont = ASN1Dict([(u'contributingEntriesOnly', 1), (u'participatingEntriesOnly', 2), (u'compoundEntry', 3)])
    _FamilyReturn_memberSelect._ext = []
    _FamilyReturn_familySelect = SEQ_OF(name=u'familySelect', mode=MODE_TYPE, opt=True)
    __FamilyReturn_familySelect__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'OBJECT-CLASS'), [u'id']))
    _FamilyReturn_familySelect._cont = __FamilyReturn_familySelect__item_
    _FamilyReturn_familySelect._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    FamilyReturn._cont = ASN1Dict([
        (u'memberSelect', _FamilyReturn_memberSelect),
        (u'familySelect', _FamilyReturn_familySelect),
        ])
    FamilyReturn._ext = []
    
    #-----< EntryInformation >-----#
    EntryInformation = SEQ(name=u'EntryInformation', mode=MODE_TYPE)
    _EntryInformation_name = CHOICE(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _EntryInformation_fromEntry = BOOL(name=u'fromEntry', mode=MODE_TYPE, default=True)
    _EntryInformation_information = SET_OF(name=u'information', mode=MODE_TYPE, opt=True)
    __EntryInformation_information__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ___EntryInformation_information__item__attributeType = OID(name=u'attributeType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___EntryInformation_information__item__attribute = SEQ(name=u'attribute', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ____EntryInformation_information__item__attribute_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _____EntryInformation_information__item__attribute_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ______EntryInformation_information__item__attribute_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______EntryInformation_information__item__attribute_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _____EntryInformation_information__item__attribute_type_tab._val = ASN1Set(rv=[dict([(u'Type', ______EntryInformation_information__item__attribute_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ______EntryInformation_information__item__attribute_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ____EntryInformation_information__item__attribute_type._const_tab = _____EntryInformation_information__item__attribute_type_tab
    ____EntryInformation_information__item__attribute_type._const_tab_at = None
    ____EntryInformation_information__item__attribute_type._const_tab_id = u'id'
    ____EntryInformation_information__item__attribute_values = SET_OF(name=u'values', mode=MODE_TYPE)
    _____EntryInformation_information__item__attribute_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____EntryInformation_information__item__attribute_values__item_._const_tab = _____EntryInformation_information__item__attribute_type_tab
    _____EntryInformation_information__item__attribute_values__item_._const_tab_at = ('..', '..', u'type')
    _____EntryInformation_information__item__attribute_values__item_._const_tab_id = u'Type'
    ____EntryInformation_information__item__attribute_values._cont = _____EntryInformation_information__item__attribute_values__item_
    ____EntryInformation_information__item__attribute_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ____EntryInformation_information__item__attribute_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    _____EntryInformation_information__item__attribute_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ______EntryInformation_information__item__attribute_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______EntryInformation_information__item__attribute_valuesWithContext__item__value._const_tab = _____EntryInformation_information__item__attribute_type_tab
    ______EntryInformation_information__item__attribute_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ______EntryInformation_information__item__attribute_valuesWithContext__item__value._const_tab_id = u'Type'
    ______EntryInformation_information__item__attribute_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _______EntryInformation_information__item__attribute_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ______EntryInformation_information__item__attribute_valuesWithContext__item__contextList._cont = _______EntryInformation_information__item__attribute_valuesWithContext__item__contextList__item_
    ______EntryInformation_information__item__attribute_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _____EntryInformation_information__item__attribute_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ______EntryInformation_information__item__attribute_valuesWithContext__item__value),
        (u'contextList', ______EntryInformation_information__item__attribute_valuesWithContext__item__contextList),
        ])
    _____EntryInformation_information__item__attribute_valuesWithContext__item_._ext = []
    ____EntryInformation_information__item__attribute_valuesWithContext._cont = _____EntryInformation_information__item__attribute_valuesWithContext__item_
    ____EntryInformation_information__item__attribute_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___EntryInformation_information__item__attribute._cont = ASN1Dict([
        (u'type', ____EntryInformation_information__item__attribute_type),
        (u'values', ____EntryInformation_information__item__attribute_values),
        (u'valuesWithContext', ____EntryInformation_information__item__attribute_valuesWithContext),
        ])
    ___EntryInformation_information__item__attribute._ext = []
    __EntryInformation_information__item_._cont = ASN1Dict([
        (u'attributeType', ___EntryInformation_information__item__attributeType),
        (u'attribute', ___EntryInformation_information__item__attribute),
        ])
    __EntryInformation_information__item_._ext = []
    _EntryInformation_information._cont = __EntryInformation_information__item_
    _EntryInformation_information._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _EntryInformation_incompleteEntry = BOOL(name=u'incompleteEntry', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _EntryInformation_partialName = BOOL(name=u'partialName', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _EntryInformation_derivedEntry = BOOL(name=u'derivedEntry', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    EntryInformation._cont = ASN1Dict([
        (u'name', _EntryInformation_name),
        (u'fromEntry', _EntryInformation_fromEntry),
        (u'information', _EntryInformation_information),
        (u'incompleteEntry', _EntryInformation_incompleteEntry),
        (u'partialName', _EntryInformation_partialName),
        (u'derivedEntry', _EntryInformation_derivedEntry),
        ])
    EntryInformation._ext = []
    
    #-----< family-information >-----#
    family_information = CLASS(name=u'family-information', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _family_information_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyEntries')))
    family_information._val = dict([(u'Type', _family_information_val_Type), (u'usage', u'directoryOperation'), (u'id', (2, 5, 4, 64))])
    
    #-----< FamilyEntries >-----#
    FamilyEntries = SEQ(name=u'FamilyEntries', mode=MODE_TYPE)
    _FamilyEntries_family_class = OID(name=u'family-class', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'OBJECT-CLASS'), [u'id']))
    _FamilyEntries_familyEntries = SEQ_OF(name=u'familyEntries', mode=MODE_TYPE)
    __FamilyEntries_familyEntries__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyEntry')))
    _FamilyEntries_familyEntries._cont = __FamilyEntries_familyEntries__item_
    FamilyEntries._cont = ASN1Dict([
        (u'family-class', _FamilyEntries_family_class),
        (u'familyEntries', _FamilyEntries_familyEntries),
        ])
    FamilyEntries._ext = []
    
    #-----< FamilyEntry >-----#
    FamilyEntry = SEQ(name=u'FamilyEntry', mode=MODE_TYPE)
    _FamilyEntry_rdn = SET_OF(name=u'rdn', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'RelativeDistinguishedName')))
    _FamilyEntry_information = SEQ_OF(name=u'information', mode=MODE_TYPE)
    __FamilyEntry_information__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ___FamilyEntry_information__item__attributeType = OID(name=u'attributeType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___FamilyEntry_information__item__attribute = SEQ(name=u'attribute', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ____FamilyEntry_information__item__attribute_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _____FamilyEntry_information__item__attribute_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ______FamilyEntry_information__item__attribute_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______FamilyEntry_information__item__attribute_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _____FamilyEntry_information__item__attribute_type_tab._val = ASN1Set(rv=[dict([(u'Type', ______FamilyEntry_information__item__attribute_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ______FamilyEntry_information__item__attribute_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ____FamilyEntry_information__item__attribute_type._const_tab = _____FamilyEntry_information__item__attribute_type_tab
    ____FamilyEntry_information__item__attribute_type._const_tab_at = None
    ____FamilyEntry_information__item__attribute_type._const_tab_id = u'id'
    ____FamilyEntry_information__item__attribute_values = SET_OF(name=u'values', mode=MODE_TYPE)
    _____FamilyEntry_information__item__attribute_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____FamilyEntry_information__item__attribute_values__item_._const_tab = _____FamilyEntry_information__item__attribute_type_tab
    _____FamilyEntry_information__item__attribute_values__item_._const_tab_at = ('..', '..', u'type')
    _____FamilyEntry_information__item__attribute_values__item_._const_tab_id = u'Type'
    ____FamilyEntry_information__item__attribute_values._cont = _____FamilyEntry_information__item__attribute_values__item_
    ____FamilyEntry_information__item__attribute_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ____FamilyEntry_information__item__attribute_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    _____FamilyEntry_information__item__attribute_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__value._const_tab = _____FamilyEntry_information__item__attribute_type_tab
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__value._const_tab_id = u'Type'
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList._cont = _______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList__item_
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _____FamilyEntry_information__item__attribute_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ______FamilyEntry_information__item__attribute_valuesWithContext__item__value),
        (u'contextList', ______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList),
        ])
    _____FamilyEntry_information__item__attribute_valuesWithContext__item_._ext = []
    ____FamilyEntry_information__item__attribute_valuesWithContext._cont = _____FamilyEntry_information__item__attribute_valuesWithContext__item_
    ____FamilyEntry_information__item__attribute_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___FamilyEntry_information__item__attribute._cont = ASN1Dict([
        (u'type', ____FamilyEntry_information__item__attribute_type),
        (u'values', ____FamilyEntry_information__item__attribute_values),
        (u'valuesWithContext', ____FamilyEntry_information__item__attribute_valuesWithContext),
        ])
    ___FamilyEntry_information__item__attribute._ext = []
    __FamilyEntry_information__item_._cont = ASN1Dict([
        (u'attributeType', ___FamilyEntry_information__item__attributeType),
        (u'attribute', ___FamilyEntry_information__item__attribute),
        ])
    __FamilyEntry_information__item_._ext = []
    _FamilyEntry_information._cont = __FamilyEntry_information__item_
    _FamilyEntry_family_info = SEQ_OF(name=u'family-info', mode=MODE_TYPE, opt=True)
    __FamilyEntry_family_info__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyEntries')))
    _FamilyEntry_family_info._cont = __FamilyEntry_family_info__item_
    _FamilyEntry_family_info._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    FamilyEntry._cont = ASN1Dict([
        (u'rdn', _FamilyEntry_rdn),
        (u'information', _FamilyEntry_information),
        (u'family-info', _FamilyEntry_family_info),
        ])
    FamilyEntry._ext = []
    
    #-----< Filter >-----#
    Filter = CHOICE(name=u'Filter', mode=MODE_TYPE)
    _Filter_item = CHOICE(name=u'item', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FilterItem')))
    _Filter_and_ = SET_OF(name=u'and', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __Filter_and___item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')))
    _Filter_and_._cont = __Filter_and___item_
    _Filter_or_ = SET_OF(name=u'or', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __Filter_or___item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')))
    _Filter_or_._cont = __Filter_or___item_
    _Filter_not_ = CHOICE(name=u'not', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')))
    Filter._cont = ASN1Dict([
        (u'item', _Filter_item),
        (u'and', _Filter_and_),
        (u'or', _Filter_or_),
        (u'not', _Filter_not_),
        ])
    Filter._ext = []
    
    #-----< FilterItem >-----#
    FilterItem = CHOICE(name=u'FilterItem', mode=MODE_TYPE)
    _FilterItem_equality = SEQ(name=u'equality', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _FilterItem_substrings = SEQ(name=u'substrings', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __FilterItem_substrings_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ___FilterItem_substrings_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ____FilterItem_substrings_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ____FilterItem_substrings_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ___FilterItem_substrings_type_tab._val = ASN1Set(rv=[dict([(u'Type', ____FilterItem_substrings_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ____FilterItem_substrings_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    __FilterItem_substrings_type._const_tab = ___FilterItem_substrings_type_tab
    __FilterItem_substrings_type._const_tab_at = None
    __FilterItem_substrings_type._const_tab_id = u'id'
    __FilterItem_substrings_strings = SEQ_OF(name=u'strings', mode=MODE_TYPE)
    ___FilterItem_substrings_strings__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ____FilterItem_substrings_strings__item__initial = OPEN(name=u'initial', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____FilterItem_substrings_strings__item__initial._const_tab = ___FilterItem_substrings_type_tab
    ____FilterItem_substrings_strings__item__initial._const_tab_at = ('..', '..', '..', '..', u'substrings', u'type')
    ____FilterItem_substrings_strings__item__initial._const_tab_id = u'Type'
    ____FilterItem_substrings_strings__item__any = OPEN(name=u'any', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____FilterItem_substrings_strings__item__any._const_tab = ___FilterItem_substrings_type_tab
    ____FilterItem_substrings_strings__item__any._const_tab_at = ('..', '..', '..', '..', u'substrings', u'type')
    ____FilterItem_substrings_strings__item__any._const_tab_id = u'Type'
    ____FilterItem_substrings_strings__item__final = OPEN(name=u'final', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____FilterItem_substrings_strings__item__final._const_tab = ___FilterItem_substrings_type_tab
    ____FilterItem_substrings_strings__item__final._const_tab_at = ('..', '..', '..', '..', u'substrings', u'type')
    ____FilterItem_substrings_strings__item__final._const_tab_id = u'Type'
    ____FilterItem_substrings_strings__item__control = SEQ(name=u'control', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    _____FilterItem_substrings_strings__item__control_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _____FilterItem_substrings_strings__item__control_type._const_tab = ___FilterItem_substrings_type_tab
    _____FilterItem_substrings_strings__item__control_type._const_tab_at = None
    _____FilterItem_substrings_strings__item__control_type._const_tab_id = u'id'
    _____FilterItem_substrings_strings__item__control_values = SET_OF(name=u'values', mode=MODE_TYPE)
    ______FilterItem_substrings_strings__item__control_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______FilterItem_substrings_strings__item__control_values__item_._const_tab = ___FilterItem_substrings_type_tab
    ______FilterItem_substrings_strings__item__control_values__item_._const_tab_at = ('..', '..', u'type')
    ______FilterItem_substrings_strings__item__control_values__item_._const_tab_id = u'Type'
    _____FilterItem_substrings_strings__item__control_values._cont = ______FilterItem_substrings_strings__item__control_values__item_
    _____FilterItem_substrings_strings__item__control_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _____FilterItem_substrings_strings__item__control_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ______FilterItem_substrings_strings__item__control_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value._const_tab = ___FilterItem_substrings_type_tab
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value._const_tab_id = u'Type'
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ________FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList._cont = ________FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList__item_
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ______FilterItem_substrings_strings__item__control_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value),
        (u'contextList', _______FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList),
        ])
    ______FilterItem_substrings_strings__item__control_valuesWithContext__item_._ext = []
    _____FilterItem_substrings_strings__item__control_valuesWithContext._cont = ______FilterItem_substrings_strings__item__control_valuesWithContext__item_
    _____FilterItem_substrings_strings__item__control_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____FilterItem_substrings_strings__item__control._cont = ASN1Dict([
        (u'type', _____FilterItem_substrings_strings__item__control_type),
        (u'values', _____FilterItem_substrings_strings__item__control_values),
        (u'valuesWithContext', _____FilterItem_substrings_strings__item__control_valuesWithContext),
        ])
    ____FilterItem_substrings_strings__item__control._ext = []
    ___FilterItem_substrings_strings__item_._cont = ASN1Dict([
        (u'initial', ____FilterItem_substrings_strings__item__initial),
        (u'any', ____FilterItem_substrings_strings__item__any),
        (u'final', ____FilterItem_substrings_strings__item__final),
        (u'control', ____FilterItem_substrings_strings__item__control),
        ])
    ___FilterItem_substrings_strings__item_._ext = []
    __FilterItem_substrings_strings._cont = ___FilterItem_substrings_strings__item_
    _FilterItem_substrings._cont = ASN1Dict([
        (u'type', __FilterItem_substrings_type),
        (u'strings', __FilterItem_substrings_strings),
        ])
    _FilterItem_substrings._ext = []
    _FilterItem_greaterOrEqual = SEQ(name=u'greaterOrEqual', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _FilterItem_lessOrEqual = SEQ(name=u'lessOrEqual', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _FilterItem_present = OID(name=u'present', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _FilterItem_approximateMatch = SEQ(name=u'approximateMatch', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _FilterItem_extensibleMatch = SEQ(name=u'extensibleMatch', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'MatchingRuleAssertion')))
    _FilterItem_contextPresent = SEQ(name=u'contextPresent', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAssertion')))
    FilterItem._cont = ASN1Dict([
        (u'equality', _FilterItem_equality),
        (u'substrings', _FilterItem_substrings),
        (u'greaterOrEqual', _FilterItem_greaterOrEqual),
        (u'lessOrEqual', _FilterItem_lessOrEqual),
        (u'present', _FilterItem_present),
        (u'approximateMatch', _FilterItem_approximateMatch),
        (u'extensibleMatch', _FilterItem_extensibleMatch),
        (u'contextPresent', _FilterItem_contextPresent),
        ])
    FilterItem._ext = []
    
    #-----< MatchingRuleAssertion >-----#
    MatchingRuleAssertion = SEQ(name=u'MatchingRuleAssertion', mode=MODE_TYPE)
    _MatchingRuleAssertion_matchingRule = SET_OF(name=u'matchingRule', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MatchingRuleAssertion_matchingRule__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'MATCHING-RULE'), [u'id']))
    _MatchingRuleAssertion_matchingRule._cont = __MatchingRuleAssertion_matchingRule__item_
    _MatchingRuleAssertion_matchingRule._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _MatchingRuleAssertion_type = OID(name=u'type', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')), opt=True)
    _MatchingRuleAssertion_matchValue = OPEN(name=u'matchValue', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('InformationFramework', 'MATCHING-RULE'), [u'AssertionType']))
    _MatchingRuleAssertion_dnAttributes = BOOL(name=u'dnAttributes', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    MatchingRuleAssertion._cont = ASN1Dict([
        (u'matchingRule', _MatchingRuleAssertion_matchingRule),
        (u'type', _MatchingRuleAssertion_type),
        (u'matchValue', _MatchingRuleAssertion_matchValue),
        (u'dnAttributes', _MatchingRuleAssertion_dnAttributes),
        ])
    MatchingRuleAssertion._ext = []
    
    #-----< PagedResultsRequest >-----#
    PagedResultsRequest = CHOICE(name=u'PagedResultsRequest', mode=MODE_TYPE)
    _PagedResultsRequest_newRequest = SEQ(name=u'newRequest', mode=MODE_TYPE)
    __PagedResultsRequest_newRequest_pageSize = INT(name=u'pageSize', mode=MODE_TYPE)
    __PagedResultsRequest_newRequest_sortKeys = SEQ_OF(name=u'sortKeys', mode=MODE_TYPE, opt=True)
    ___PagedResultsRequest_newRequest_sortKeys__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SortKey')))
    __PagedResultsRequest_newRequest_sortKeys._cont = ___PagedResultsRequest_newRequest_sortKeys__item_
    __PagedResultsRequest_newRequest_sortKeys._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __PagedResultsRequest_newRequest_reverse = BOOL(name=u'reverse', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    __PagedResultsRequest_newRequest_unmerged = BOOL(name=u'unmerged', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    __PagedResultsRequest_newRequest_pageNumber = INT(name=u'pageNumber', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PagedResultsRequest_newRequest._cont = ASN1Dict([
        (u'pageSize', __PagedResultsRequest_newRequest_pageSize),
        (u'sortKeys', __PagedResultsRequest_newRequest_sortKeys),
        (u'reverse', __PagedResultsRequest_newRequest_reverse),
        (u'unmerged', __PagedResultsRequest_newRequest_unmerged),
        (u'pageNumber', __PagedResultsRequest_newRequest_pageNumber),
        ])
    _PagedResultsRequest_newRequest._ext = []
    _PagedResultsRequest_queryReference = OCT_STR(name=u'queryReference', mode=MODE_TYPE)
    _PagedResultsRequest_abandonQuery = OCT_STR(name=u'abandonQuery', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    PagedResultsRequest._cont = ASN1Dict([
        (u'newRequest', _PagedResultsRequest_newRequest),
        (u'queryReference', _PagedResultsRequest_queryReference),
        (u'abandonQuery', _PagedResultsRequest_abandonQuery),
        ])
    PagedResultsRequest._ext = []
    
    #-----< SortKey >-----#
    SortKey = SEQ(name=u'SortKey', mode=MODE_TYPE)
    _SortKey_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _SortKey_orderingRule = OID(name=u'orderingRule', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'MATCHING-RULE'), [u'id']), opt=True)
    SortKey._cont = ASN1Dict([
        (u'type', _SortKey_type),
        (u'orderingRule', _SortKey_orderingRule),
        ])
    SortKey._ext = []
    
    #-----< SecurityParameters >-----#
    SecurityParameters = SET(name=u'SecurityParameters', mode=MODE_TYPE)
    _SecurityParameters_certification_path = SEQ(name=u'certification-path', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificationPath')), opt=True)
    _SecurityParameters_name = SEQ_OF(name=u'name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _SecurityParameters_time = CHOICE(name=u'time', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Time')), opt=True)
    _SecurityParameters_random = BIT_STR(name=u'random', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SecurityParameters_target = INT(name=u'target', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ProtectionRequest')), opt=True)
    _SecurityParameters_operationCode = CHOICE(name=u'operationCode', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')), opt=True)
    _SecurityParameters_errorProtection = INT(name=u'errorProtection', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ErrorProtectionRequest')), opt=True)
    _SecurityParameters_errorCode = CHOICE(name=u'errorCode', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')), opt=True)
    SecurityParameters._cont = ASN1Dict([
        (u'certification-path', _SecurityParameters_certification_path),
        (u'name', _SecurityParameters_name),
        (u'time', _SecurityParameters_time),
        (u'random', _SecurityParameters_random),
        (u'target', _SecurityParameters_target),
        (u'operationCode', _SecurityParameters_operationCode),
        (u'errorProtection', _SecurityParameters_errorProtection),
        (u'errorCode', _SecurityParameters_errorCode),
        ])
    SecurityParameters._ext = []
    
    #-----< ProtectionRequest >-----#
    ProtectionRequest = INT(name=u'ProtectionRequest', mode=MODE_TYPE)
    ProtectionRequest._cont = ASN1Dict([(u'none', 0), (u'signed', 1)])
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalizedTime = TIME_GEN(name=u'generalizedTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalizedTime', _Time_generalizedTime),
        ])
    Time._ext = []
    
    #-----< ErrorProtectionRequest >-----#
    ErrorProtectionRequest = INT(name=u'ErrorProtectionRequest', mode=MODE_TYPE)
    ErrorProtectionRequest._cont = ASN1Dict([(u'none', 0), (u'signed', 1)])
    
    #-----< directoryBind >-----#
    directoryBind = CLASS(name=u'directoryBind', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _directoryBind_val_ArgumentType = SET(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'DirectoryBindArgument')))
    _directoryBind_val_ResultType = SET(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'DirectoryBindResult')))
    __OPERATION_Errors_val_ParameterType_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_0_unsigned = SET(name=u'unsigned', mode=MODE_TYPE)
    ____OPERATION_Errors_val_ParameterType_0_unsigned_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    ____OPERATION_Errors_val_ParameterType_0_unsigned_error = CHOICE(name=u'error', mode=MODE_TYPE)
    _____OPERATION_Errors_val_ParameterType_0_unsigned_error_serviceError = INT(name=u'serviceError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceProblem')))
    _____OPERATION_Errors_val_ParameterType_0_unsigned_error_securityError = INT(name=u'securityError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityProblem')))
    ____OPERATION_Errors_val_ParameterType_0_unsigned_error._cont = ASN1Dict([
        (u'serviceError', _____OPERATION_Errors_val_ParameterType_0_unsigned_error_serviceError),
        (u'securityError', _____OPERATION_Errors_val_ParameterType_0_unsigned_error_securityError),
        ])
    ____OPERATION_Errors_val_ParameterType_0_unsigned_error._ext = []
    ____OPERATION_Errors_val_ParameterType_0_unsigned_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    ___OPERATION_Errors_val_ParameterType_0_unsigned._cont = ASN1Dict([
        (u'versions', ____OPERATION_Errors_val_ParameterType_0_unsigned_versions),
        (u'error', ____OPERATION_Errors_val_ParameterType_0_unsigned_error),
        (u'securityParameters', ____OPERATION_Errors_val_ParameterType_0_unsigned_securityParameters),
        ])
    ___OPERATION_Errors_val_ParameterType_0_unsigned._ext = None
    ___OPERATION_Errors_val_ParameterType_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE)
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error = CHOICE(name=u'error', mode=MODE_TYPE)
    ______OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error_serviceError = INT(name=u'serviceError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceProblem')))
    ______OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error_securityError = INT(name=u'securityError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityProblem')))
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error._cont = ASN1Dict([
        (u'serviceError', ______OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error_serviceError),
        (u'securityError', ______OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error_securityError),
        ])
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error._ext = []
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned._cont = ASN1Dict([
        (u'versions', _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_versions),
        (u'error', _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error),
        (u'securityParameters', _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_securityParameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned._ext = None
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    __________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    __________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ___________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = __________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = __________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', _________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', ________OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_0_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    ___OPERATION_Errors_val_ParameterType_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier),
        (u'signature', ____OPERATION_Errors_val_ParameterType_0_signed_signature),
        ])
    ___OPERATION_Errors_val_ParameterType_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_0._ext = None
    directoryBind._val = dict([(u'ArgumentType', _directoryBind_val_ArgumentType), (u'ResultType', _directoryBind_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0)])], rr=[], ev=None, er=[]))])
    
    #-----< DirectoryBindArgument >-----#
    DirectoryBindArgument = SET(name=u'DirectoryBindArgument', mode=MODE_TYPE)
    _DirectoryBindArgument_credentials = CHOICE(name=u'credentials', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Credentials')), opt=True)
    _DirectoryBindArgument_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    DirectoryBindArgument._cont = ASN1Dict([
        (u'credentials', _DirectoryBindArgument_credentials),
        (u'versions', _DirectoryBindArgument_versions),
        ])
    DirectoryBindArgument._ext = []
    
    #-----< Credentials >-----#
    Credentials = CHOICE(name=u'Credentials', mode=MODE_TYPE)
    _Credentials_simple = SEQ(name=u'simple', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SimpleCredentials')))
    _Credentials_strong = SET(name=u'strong', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'StrongCredentials')))
    _Credentials_externalProcedure = EXT(name=u'externalProcedure', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    _Credentials_spkm = CHOICE(name=u'spkm', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SpkmCredentials')))
    _Credentials_sasl = SEQ(name=u'sasl', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SaslCredentials')))
    Credentials._cont = ASN1Dict([
        (u'simple', _Credentials_simple),
        (u'strong', _Credentials_strong),
        (u'externalProcedure', _Credentials_externalProcedure),
        (u'spkm', _Credentials_spkm),
        (u'sasl', _Credentials_sasl),
        ])
    Credentials._ext = []
    
    #-----< SimpleCredentials >-----#
    SimpleCredentials = SEQ(name=u'SimpleCredentials', mode=MODE_TYPE)
    _SimpleCredentials_name = SEQ_OF(name=u'name', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _SimpleCredentials_validity = SET(name=u'validity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __SimpleCredentials_validity_time1 = CHOICE(name=u'time1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ___SimpleCredentials_validity_time1_utc = TIME_UTC(name=u'utc', mode=MODE_TYPE)
    ___SimpleCredentials_validity_time1_gt = TIME_GEN(name=u'gt', mode=MODE_TYPE)
    __SimpleCredentials_validity_time1._cont = ASN1Dict([
        (u'utc', ___SimpleCredentials_validity_time1_utc),
        (u'gt', ___SimpleCredentials_validity_time1_gt),
        ])
    __SimpleCredentials_validity_time1._ext = None
    __SimpleCredentials_validity_time2 = CHOICE(name=u'time2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ___SimpleCredentials_validity_time2_utc = TIME_UTC(name=u'utc', mode=MODE_TYPE)
    ___SimpleCredentials_validity_time2_gt = TIME_GEN(name=u'gt', mode=MODE_TYPE)
    __SimpleCredentials_validity_time2._cont = ASN1Dict([
        (u'utc', ___SimpleCredentials_validity_time2_utc),
        (u'gt', ___SimpleCredentials_validity_time2_gt),
        ])
    __SimpleCredentials_validity_time2._ext = None
    __SimpleCredentials_validity_random1 = BIT_STR(name=u'random1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __SimpleCredentials_validity_random2 = BIT_STR(name=u'random2', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SimpleCredentials_validity._cont = ASN1Dict([
        (u'time1', __SimpleCredentials_validity_time1),
        (u'time2', __SimpleCredentials_validity_time2),
        (u'random1', __SimpleCredentials_validity_random1),
        (u'random2', __SimpleCredentials_validity_random2),
        ])
    _SimpleCredentials_validity._ext = None
    _SimpleCredentials_password = CHOICE(name=u'password', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __SimpleCredentials_password_unprotected = OCT_STR(name=u'unprotected', mode=MODE_TYPE)
    __SimpleCredentials_password_protected = SEQ(name=u'protected', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'HASH')))
    ___SimpleCredentials_password_protected_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    __________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', __________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ________SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    _____SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ______SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm._const_tab = _____SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab
    ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm._const_tab_at = None
    ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____SimpleCredentials_password_protected_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____SimpleCredentials_password_protected_algorithmIdentifier_parameters._const_tab = _____SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab
    ____SimpleCredentials_password_protected_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____SimpleCredentials_password_protected_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___SimpleCredentials_password_protected_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm),
        (u'parameters', ____SimpleCredentials_password_protected_algorithmIdentifier_parameters),
        ])
    ___SimpleCredentials_password_protected_algorithmIdentifier._ext = []
    ___SimpleCredentials_password_protected_hashValue = BIT_STR(name=u'hashValue', mode=MODE_TYPE)
    __SimpleCredentials_password_protected._cont = ASN1Dict([
        (u'algorithmIdentifier', ___SimpleCredentials_password_protected_algorithmIdentifier),
        (u'hashValue', ___SimpleCredentials_password_protected_hashValue),
        ])
    __SimpleCredentials_password_protected._ext = []
    __SimpleCredentials_password_userPwd = CHOICE(name=u'userPwd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PasswordPolicy', 'UserPwd')))
    _SimpleCredentials_password._cont = ASN1Dict([
        (u'unprotected', __SimpleCredentials_password_unprotected),
        (u'protected', __SimpleCredentials_password_protected),
        (u'userPwd', __SimpleCredentials_password_userPwd),
        ])
    _SimpleCredentials_password._ext = [u'userPwd']
    SimpleCredentials._cont = ASN1Dict([
        (u'name', _SimpleCredentials_name),
        (u'validity', _SimpleCredentials_validity),
        (u'password', _SimpleCredentials_password),
        ])
    SimpleCredentials._ext = None
    
    #-----< StrongCredentials >-----#
    StrongCredentials = SET(name=u'StrongCredentials', mode=MODE_TYPE)
    _StrongCredentials_certification_path = SEQ(name=u'certification-path', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificationPath')), opt=True)
    _StrongCredentials_bind_token = SEQ(name=u'bind-token', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Token')))
    _StrongCredentials_name = SEQ_OF(name=u'name', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _StrongCredentials_attributeCertificationPath = SEQ(name=u'attributeCertificationPath', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificationPath')), opt=True)
    StrongCredentials._cont = ASN1Dict([
        (u'certification-path', _StrongCredentials_certification_path),
        (u'bind-token', _StrongCredentials_bind_token),
        (u'name', _StrongCredentials_name),
        (u'attributeCertificationPath', _StrongCredentials_attributeCertificationPath),
        ])
    StrongCredentials._ext = []
    
    #-----< SpkmCredentials >-----#
    SpkmCredentials = CHOICE(name=u'SpkmCredentials', mode=MODE_TYPE)
    _SpkmCredentials_req = SEQ(name=u'req', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('SpkmGssTokens', 'SPKM-REQ')))
    _SpkmCredentials_rep = SEQ(name=u'rep', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('SpkmGssTokens', 'SPKM-REP-TI')))
    SpkmCredentials._cont = ASN1Dict([
        (u'req', _SpkmCredentials_req),
        (u'rep', _SpkmCredentials_rep),
        ])
    SpkmCredentials._ext = []
    
    #-----< SaslCredentials >-----#
    SaslCredentials = SEQ(name=u'SaslCredentials', mode=MODE_TYPE)
    _SaslCredentials_mechanism = CHOICE(name=u'mechanism', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'DirectoryString')))
    __SaslCredentials_mechanism_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SaslCredentials_mechanism_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    __SaslCredentials_mechanism_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SaslCredentials_mechanism_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    __SaslCredentials_mechanism_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SaslCredentials_mechanism_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    __SaslCredentials_mechanism_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SaslCredentials_mechanism_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    __SaslCredentials_mechanism_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SaslCredentials_mechanism_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    _SaslCredentials_mechanism._cont = ASN1Dict([
        (u'teletexString', __SaslCredentials_mechanism_teletexString),
        (u'printableString', __SaslCredentials_mechanism_printableString),
        (u'bmpString', __SaslCredentials_mechanism_bmpString),
        (u'universalString', __SaslCredentials_mechanism_universalString),
        (u'uTF8String', __SaslCredentials_mechanism_uTF8String),
        ])
    _SaslCredentials_mechanism._ext = None
    _SaslCredentials_credentials = OCT_STR(name=u'credentials', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SaslCredentials_saslAbort = BOOL(name=u'saslAbort', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    SaslCredentials._cont = ASN1Dict([
        (u'mechanism', _SaslCredentials_mechanism),
        (u'credentials', _SaslCredentials_credentials),
        (u'saslAbort', _SaslCredentials_saslAbort),
        ])
    SaslCredentials._ext = []
    
    #-----< ub-saslMechanism >-----#
    ub_saslMechanism = INT(name=u'ub-saslMechanism', mode=MODE_VALUE)
    ub_saslMechanism._val = 20
    
    #-----< Token >-----#
    Token = SEQ(name=u'Token', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    _Token_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'TokenContent')))
    _Token_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __Token_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___Token_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____Token_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____Token_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____Token_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____Token_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____Token_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____Token_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___Token_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____Token_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __Token_algorithmIdentifier_algorithm._const_tab = ___Token_algorithmIdentifier_algorithm_tab
    __Token_algorithmIdentifier_algorithm._const_tab_at = None
    __Token_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __Token_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __Token_algorithmIdentifier_parameters._const_tab = ___Token_algorithmIdentifier_algorithm_tab
    __Token_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __Token_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _Token_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __Token_algorithmIdentifier_algorithm),
        (u'parameters', __Token_algorithmIdentifier_parameters),
        ])
    _Token_algorithmIdentifier._ext = []
    _Token_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    Token._cont = ASN1Dict([
        (u'toBeSigned', _Token_toBeSigned),
        (u'algorithmIdentifier', _Token_algorithmIdentifier),
        (u'signature', _Token_signature),
        ])
    Token._ext = []
    
    #-----< TokenContent >-----#
    TokenContent = SEQ(name=u'TokenContent', mode=MODE_TYPE)
    _TokenContent_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __TokenContent_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___TokenContent_algorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ____TokenContent_algorithm_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _____TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ________TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _____TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ______TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _____TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _____TokenContent_algorithm_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _____TokenContent_algorithm_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ____TokenContent_algorithm_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _____TokenContent_algorithm_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _____TokenContent_algorithm_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _____TokenContent_algorithm_algorithm_tab_val_Type_21_trailerField),
        ])
    ____TokenContent_algorithm_algorithm_tab_val_Type_21._ext = None
    ____TokenContent_algorithm_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ____TokenContent_algorithm_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ___TokenContent_algorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ____TokenContent_algorithm_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    __TokenContent_algorithm_algorithm._const_tab = ___TokenContent_algorithm_algorithm_tab
    __TokenContent_algorithm_algorithm._const_tab_at = None
    __TokenContent_algorithm_algorithm._const_tab_id = u'id'
    __TokenContent_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __TokenContent_algorithm_parameters._const_tab = ___TokenContent_algorithm_algorithm_tab
    __TokenContent_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    __TokenContent_algorithm_parameters._const_tab_id = u'Type'
    _TokenContent_algorithm._cont = ASN1Dict([
        (u'algorithm', __TokenContent_algorithm_algorithm),
        (u'parameters', __TokenContent_algorithm_parameters),
        ])
    _TokenContent_algorithm._ext = []
    _TokenContent_name = SEQ_OF(name=u'name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _TokenContent_time = CHOICE(name=u'time', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Time')))
    _TokenContent_random = BIT_STR(name=u'random', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _TokenContent_response = BIT_STR(name=u'response', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    TokenContent._cont = ASN1Dict([
        (u'algorithm', _TokenContent_algorithm),
        (u'name', _TokenContent_name),
        (u'time', _TokenContent_time),
        (u'random', _TokenContent_random),
        (u'response', _TokenContent_response),
        ])
    TokenContent._ext = []
    
    #-----< Versions >-----#
    Versions = BIT_STR(name=u'Versions', mode=MODE_TYPE)
    Versions._cont = ASN1Dict([(u'v1', 0), (u'v2', 1)])
    
    #-----< DirectoryBindResult >-----#
    DirectoryBindResult = SET(name=u'DirectoryBindResult', mode=MODE_TYPE)
    _DirectoryBindResult_credentials = CHOICE(name=u'credentials', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Credentials')), opt=True)
    _DirectoryBindResult_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    _DirectoryBindResult_pwdResponseValue = SEQ(name=u'pwdResponseValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'PwdResponseValue')), opt=True)
    DirectoryBindResult._cont = ASN1Dict([
        (u'credentials', _DirectoryBindResult_credentials),
        (u'versions', _DirectoryBindResult_versions),
        (u'pwdResponseValue', _DirectoryBindResult_pwdResponseValue),
        ])
    DirectoryBindResult._ext = [u'pwdResponseValue']
    
    #-----< PwdResponseValue >-----#
    PwdResponseValue = SEQ(name=u'PwdResponseValue', mode=MODE_TYPE)
    _PwdResponseValue_warning = CHOICE(name=u'warning', mode=MODE_TYPE, opt=True)
    __PwdResponseValue_warning_timeLeft = INT(name=u'timeLeft', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PwdResponseValue_warning_timeLeft._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    __PwdResponseValue_warning_graceRemaining = INT(name=u'graceRemaining', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PwdResponseValue_warning_graceRemaining._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _PwdResponseValue_warning._cont = ASN1Dict([
        (u'timeLeft', __PwdResponseValue_warning_timeLeft),
        (u'graceRemaining', __PwdResponseValue_warning_graceRemaining),
        ])
    _PwdResponseValue_warning._ext = []
    _PwdResponseValue_error = ENUM(name=u'error', mode=MODE_TYPE, opt=True)
    _PwdResponseValue_error._cont = ASN1Dict([(u'passwordExpired', 0), (u'changeAfterReset', 1)])
    _PwdResponseValue_error._ext = []
    PwdResponseValue._cont = ASN1Dict([
        (u'warning', _PwdResponseValue_warning),
        (u'error', _PwdResponseValue_error),
        ])
    PwdResponseValue._ext = None
    
    #-----< directoryBindError >-----#
    directoryBindError = CLASS(name=u'directoryBindError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _directoryBindError_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __directoryBindError_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE)
    ___directoryBindError_val_ParameterType_unsigned_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    ___directoryBindError_val_ParameterType_unsigned_error = CHOICE(name=u'error', mode=MODE_TYPE)
    ____directoryBindError_val_ParameterType_unsigned_error_serviceError = INT(name=u'serviceError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceProblem')))
    ____directoryBindError_val_ParameterType_unsigned_error_securityError = INT(name=u'securityError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityProblem')))
    ___directoryBindError_val_ParameterType_unsigned_error._cont = ASN1Dict([
        (u'serviceError', ____directoryBindError_val_ParameterType_unsigned_error_serviceError),
        (u'securityError', ____directoryBindError_val_ParameterType_unsigned_error_securityError),
        ])
    ___directoryBindError_val_ParameterType_unsigned_error._ext = []
    ___directoryBindError_val_ParameterType_unsigned_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    __directoryBindError_val_ParameterType_unsigned._cont = ASN1Dict([
        (u'versions', ___directoryBindError_val_ParameterType_unsigned_versions),
        (u'error', ___directoryBindError_val_ParameterType_unsigned_error),
        (u'securityParameters', ___directoryBindError_val_ParameterType_unsigned_securityParameters),
        ])
    __directoryBindError_val_ParameterType_unsigned._ext = None
    __directoryBindError_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___directoryBindError_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE)
    ____directoryBindError_val_ParameterType_signed_toBeSigned_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    ____directoryBindError_val_ParameterType_signed_toBeSigned_error = CHOICE(name=u'error', mode=MODE_TYPE)
    _____directoryBindError_val_ParameterType_signed_toBeSigned_error_serviceError = INT(name=u'serviceError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceProblem')))
    _____directoryBindError_val_ParameterType_signed_toBeSigned_error_securityError = INT(name=u'securityError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityProblem')))
    ____directoryBindError_val_ParameterType_signed_toBeSigned_error._cont = ASN1Dict([
        (u'serviceError', _____directoryBindError_val_ParameterType_signed_toBeSigned_error_serviceError),
        (u'securityError', _____directoryBindError_val_ParameterType_signed_toBeSigned_error_securityError),
        ])
    ____directoryBindError_val_ParameterType_signed_toBeSigned_error._ext = []
    ____directoryBindError_val_ParameterType_signed_toBeSigned_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    ___directoryBindError_val_ParameterType_signed_toBeSigned._cont = ASN1Dict([
        (u'versions', ____directoryBindError_val_ParameterType_signed_toBeSigned_versions),
        (u'error', ____directoryBindError_val_ParameterType_signed_toBeSigned_error),
        (u'securityParameters', ____directoryBindError_val_ParameterType_signed_toBeSigned_securityParameters),
        ])
    ___directoryBindError_val_ParameterType_signed_toBeSigned._ext = None
    ___directoryBindError_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    _______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    __________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', __________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = _________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = _________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    _______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', ________directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    _______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    _______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', _______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', _______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', _______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', ______directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___directoryBindError_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___directoryBindError_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___directoryBindError_val_ParameterType_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    __directoryBindError_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___directoryBindError_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___directoryBindError_val_ParameterType_signed_algorithmIdentifier),
        (u'signature', ___directoryBindError_val_ParameterType_signed_signature),
        ])
    __directoryBindError_val_ParameterType_signed._ext = []
    _directoryBindError_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __directoryBindError_val_ParameterType_unsigned),
        (u'signed', __directoryBindError_val_ParameterType_signed),
        ])
    _directoryBindError_val_ParameterType._ext = None
    directoryBindError._val = dict([(u'ParameterType', _directoryBindError_val_ParameterType)])
    
    #-----< BindKeyInfo >-----#
    BindKeyInfo = BIT_STR(name=u'BindKeyInfo', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED')))
    
    #-----< read >-----#
    read = CLASS(name=u'read', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _read_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadArgument')))
    _read_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadResult')))
    __OPERATION_Errors_val_ParameterType_0_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_0_0_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AttributeErrorData')))
    ___OPERATION_Errors_val_ParameterType_0_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_0_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AttributeErrorData')))
    ____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    ________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    __________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    __________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', ___________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = __________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = __________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    ________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', _________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    ________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    ________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    ________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', ________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', ________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', ________OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_0_0_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    ___OPERATION_Errors_val_ParameterType_0_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_0_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier),
        (u'signature', ____OPERATION_Errors_val_ParameterType_0_0_signed_signature),
        ])
    ___OPERATION_Errors_val_ParameterType_0_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_0_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_0_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_0_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_0_0._ext = None
    __OPERATION_Errors_val_ParameterType_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_1_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'NameErrorData')))
    ___OPERATION_Errors_val_ParameterType_1_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'NameErrorData')))
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_1_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    ___OPERATION_Errors_val_ParameterType_1_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier),
        (u'signature', ____OPERATION_Errors_val_ParameterType_1_signed_signature),
        ])
    ___OPERATION_Errors_val_ParameterType_1_signed._ext = []
    __OPERATION_Errors_val_ParameterType_1._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_1_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_1_signed),
        ])
    __OPERATION_Errors_val_ParameterType_1._ext = None
    __OPERATION_Errors_val_ParameterType_2 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_2_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceErrorData')))
    ___OPERATION_Errors_val_ParameterType_2_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_2_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceErrorData')))
    ____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_2_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    ___OPERATION_Errors_val_ParameterType_2_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_2_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier),
        (u'signature', ____OPERATION_Errors_val_ParameterType_2_signed_signature),
        ])
    ___OPERATION_Errors_val_ParameterType_2_signed._ext = []
    __OPERATION_Errors_val_ParameterType_2._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_2_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_2_signed),
        ])
    __OPERATION_Errors_val_ParameterType_2._ext = None
    __OPERATION_Errors_val_ParameterType_3 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_3_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReferralData')))
    ___OPERATION_Errors_val_ParameterType_3_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_3_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReferralData')))
    ____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_3_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    ___OPERATION_Errors_val_ParameterType_3_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_3_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier),
        (u'signature', ____OPERATION_Errors_val_ParameterType_3_signed_signature),
        ])
    ___OPERATION_Errors_val_ParameterType_3_signed._ext = []
    __OPERATION_Errors_val_ParameterType_3._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_3_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_3_signed),
        ])
    __OPERATION_Errors_val_ParameterType_3._ext = None
    __OPERATION_Errors_val_ParameterType_4 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_4_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    ___OPERATION_Errors_val_ParameterType_4_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_4_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    ____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_4_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    ___OPERATION_Errors_val_ParameterType_4_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_4_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier),
        (u'signature', ____OPERATION_Errors_val_ParameterType_4_signed_signature),
        ])
    ___OPERATION_Errors_val_ParameterType_4_signed._ext = []
    __OPERATION_Errors_val_ParameterType_4._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_4_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_4_signed),
        ])
    __OPERATION_Errors_val_ParameterType_4._ext = None
    __OPERATION_Errors_val_ParameterType_5 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_5_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ___OPERATION_Errors_val_ParameterType_5_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_5_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_5_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    ___OPERATION_Errors_val_ParameterType_5_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_5_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier),
        (u'signature', ____OPERATION_Errors_val_ParameterType_5_signed_signature),
        ])
    ___OPERATION_Errors_val_ParameterType_5_signed._ext = []
    __OPERATION_Errors_val_ParameterType_5._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_5_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_5_signed),
        ])
    __OPERATION_Errors_val_ParameterType_5._ext = None
    read._val = dict([(u'ArgumentType', _read_val_ArgumentType), (u'ResultType', _read_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_0), (u'errorCode', (u'local', 1))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4), (u'errorCode', (u'local', 5))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_5), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 1))])
    
    #-----< ReadArgument >-----#
    ReadArgument = CHOICE(name=u'ReadArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _ReadArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadArgumentData')))
    _ReadArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __ReadArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadArgumentData')))
    __ReadArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___ReadArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____ReadArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    ______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ________ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _________ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ________ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _________ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = ________ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = ________ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    ______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', _______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    ______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    ______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    ______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', ______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', ______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', ______ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ReadArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _____ReadArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    ___ReadArgument_signed_algorithmIdentifier_algorithm._const_tab = ____ReadArgument_signed_algorithmIdentifier_algorithm_tab
    ___ReadArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___ReadArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___ReadArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___ReadArgument_signed_algorithmIdentifier_parameters._const_tab = ____ReadArgument_signed_algorithmIdentifier_algorithm_tab
    ___ReadArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___ReadArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __ReadArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___ReadArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___ReadArgument_signed_algorithmIdentifier_parameters),
        ])
    __ReadArgument_signed_algorithmIdentifier._ext = []
    __ReadArgument_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    _ReadArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __ReadArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __ReadArgument_signed_algorithmIdentifier),
        (u'signature', __ReadArgument_signed_signature),
        ])
    _ReadArgument_signed._ext = []
    ReadArgument._cont = ASN1Dict([
        (u'unsigned', _ReadArgument_unsigned),
        (u'signed', _ReadArgument_signed),
        ])
    ReadArgument._ext = None
    
    #-----< ReadArgumentData >-----#
    ReadArgumentData = SET(name=u'ReadArgumentData', mode=MODE_TYPE)
    _ReadArgumentData_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _ReadArgumentData_selection = SET(name=u'selection', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'EntryInformationSelection')), default=dict([]))
    _ReadArgumentData_modifyRightsRequest = BOOL(name=u'modifyRightsRequest', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ReadArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _ReadArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ReadArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ReadArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _ReadArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ReadArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ReadArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _ReadArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _ReadArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _ReadArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ReadArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _ReadArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    ReadArgumentData._cont = ASN1Dict([
        (u'object', _ReadArgumentData_object),
        (u'selection', _ReadArgumentData_selection),
        (u'modifyRightsRequest', _ReadArgumentData_modifyRightsRequest),
        (u'serviceControls', _ReadArgumentData_serviceControls),
        (u'securityParameters', _ReadArgumentData_securityParameters),
        (u'requestor', _ReadArgumentData_requestor),
        (u'operationProgress', _ReadArgumentData_operationProgress),
        (u'aliasedRDNs', _ReadArgumentData_aliasedRDNs),
        (u'criticalExtensions', _ReadArgumentData_criticalExtensions),
        (u'referenceType', _ReadArgumentData_referenceType),
        (u'entryOnly', _ReadArgumentData_entryOnly),
        (u'exclusions', _ReadArgumentData_exclusions),
        (u'nameResolveOnMaster', _ReadArgumentData_nameResolveOnMaster),
        (u'operationContexts', _ReadArgumentData_operationContexts),
        (u'familyGrouping', _ReadArgumentData_familyGrouping),
        ])
    ReadArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< ReadResult >-----#
    ReadResult = CHOICE(name=u'ReadResult', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _ReadResult_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadResultData')))
    _ReadResult_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __ReadResult_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadResultData')))
    __ReadResult_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___ReadResult_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____ReadResult_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    ______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ________ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _________ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ________ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _________ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = ________ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = ________ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    ______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', _______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    ______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    ______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    ______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', ______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', ______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', ______ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ____ReadResult_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _____ReadResult_signed_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    ___ReadResult_signed_algorithmIdentifier_algorithm._const_tab = ____ReadResult_signed_algorithmIdentifier_algorithm_tab
    ___ReadResult_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___ReadResult_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___ReadResult_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___ReadResult_signed_algorithmIdentifier_parameters._const_tab = ____ReadResult_signed_algorithmIdentifier_algorithm_tab
    ___ReadResult_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___ReadResult_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __ReadResult_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___ReadResult_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___ReadResult_signed_algorithmIdentifier_parameters),
        ])
    __ReadResult_signed_algorithmIdentifier._ext = []
    __ReadResult_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    _ReadResult_signed._cont = ASN1Dict([
        (u'toBeSigned', __ReadResult_signed_toBeSigned),
        (u'algorithmIdentifier', __ReadResult_signed_algorithmIdentifier),
        (u'signature', __ReadResult_signed_signature),
        ])
    _ReadResult_signed._ext = []
    ReadResult._cont = ASN1Dict([
        (u'unsigned', _ReadResult_unsigned),
        (u'signed', _ReadResult_signed),
        ])
    ReadResult._ext = None
    
    #-----< ReadResultData >-----#
    ReadResultData = SET(name=u'ReadResultData', mode=MODE_TYPE)
    _ReadResultData_entry = SEQ(name=u'entry', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'EntryInformation')))
    _ReadResultData_modifyRights = SET_OF(name=u'modifyRights', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyRights')), opt=True)
    _ReadResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ReadResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ReadResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ReadResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ReadResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___ReadResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____ReadResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____ReadResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____ReadResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____ReadResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____ReadResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____ReadResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___ReadResultData_notification__item__type._const_tab = ____ReadResultData_notification__item__type_tab
    ___ReadResultData_notification__item__type._const_tab_at = None
    ___ReadResultData_notification__item__type._const_tab_id = u'id'
    ___ReadResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____ReadResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____ReadResultData_notification__item__values__item_._const_tab = ____ReadResultData_notification__item__type_tab
    ____ReadResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____ReadResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___ReadResultData_notification__item__values._cont = ____ReadResultData_notification__item__values__item_
    ___ReadResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___ReadResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____ReadResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____ReadResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____ReadResultData_notification__item__valuesWithContext__item__value._const_tab = ____ReadResultData_notification__item__type_tab
    _____ReadResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____ReadResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____ReadResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______ReadResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____ReadResultData_notification__item__valuesWithContext__item__contextList._cont = ______ReadResultData_notification__item__valuesWithContext__item__contextList__item_
    _____ReadResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____ReadResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____ReadResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____ReadResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____ReadResultData_notification__item__valuesWithContext__item_._ext = []
    ___ReadResultData_notification__item__valuesWithContext._cont = ____ReadResultData_notification__item__valuesWithContext__item_
    ___ReadResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __ReadResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___ReadResultData_notification__item__type),
        (u'values', ___ReadResultData_notification__item__values),
        (u'valuesWithContext', ___ReadResultData_notification__item__valuesWithContext),
        ])
    __ReadResultData_notification__item_._ext = []
    _ReadResultData_notification._cont = __ReadResultData_notification__item_
    ReadResultData._cont = ASN1Dict([
        (u'entry', _ReadResultData_entry),
        (u'modifyRights', _ReadResultData_modifyRights),
        (u'securityParameters', _ReadResultData_securityParameters),
        (u'performer', _ReadResultData_performer),
        (u'aliasDereferenced', _ReadResultData_aliasDereferenced),
        (u'notification', _ReadResultData_notification),
        ])
    ReadResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< ModifyRights >-----#
    ModifyRights = SET_OF(name=u'ModifyRights', mode=MODE_TYPE)
    _ModifyRights__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __ModifyRights__item__item = CHOICE(name=u'item', mode=MODE_TYPE)
    ___ModifyRights__item__item_entry = NULL(name=u'entry', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ModifyRights__item__item_attribute = OID(name=u'attribute', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___ModifyRights__item__item_value = SEQ(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    __ModifyRights__item__item._cont = ASN1Dict([
        (u'entry', ___ModifyRights__item__item_entry),
        (u'attribute', ___ModifyRights__item__item_attribute),
        (u'value', ___ModifyRights__item__item_value),
        ])
    __ModifyRights__item__item._ext = []
    __ModifyRights__item__permission = BIT_STR(name=u'permission', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ModifyRights__item__permission._cont = ASN1Dict([(u'add', 0), (u'remove', 1), (u'rename', 2), (u'move', 3)])
    _ModifyRights__item_._cont = ASN1Dict([
        (u'item', __ModifyRights__item__item),
        (u'permission', __ModifyRights__item__permission),
        ])
    _ModifyRights__item_._ext = []
    ModifyRights._cont = _ModifyRights__item_
    
    #-----< compare >-----#
    compare = CLASS(name=u'compare', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _compare_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareArgument')))
    _compare_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareResult')))
    compare._val = dict([(u'ArgumentType', _compare_val_ArgumentType), (u'ResultType', _compare_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_0), (u'errorCode', (u'local', 1))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4), (u'errorCode', (u'local', 5))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_5), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 2))])
    
    #-----< CompareArgument >-----#
    CompareArgument = CHOICE(name=u'CompareArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _CompareArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareArgumentData')))
    _CompareArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __CompareArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareArgumentData')))
    __CompareArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___CompareArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____CompareArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    ______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ________CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _________CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ________CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _________CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = ________CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = ________CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    ______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', _______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    ______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    ______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    ______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', ______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', ______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', ______CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CompareArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _____CompareArgument_signed_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    ___CompareArgument_signed_algorithmIdentifier_algorithm._const_tab = ____CompareArgument_signed_algorithmIdentifier_algorithm_tab
    ___CompareArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___CompareArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___CompareArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___CompareArgument_signed_algorithmIdentifier_parameters._const_tab = ____CompareArgument_signed_algorithmIdentifier_algorithm_tab
    ___CompareArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___CompareArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __CompareArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___CompareArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___CompareArgument_signed_algorithmIdentifier_parameters),
        ])
    __CompareArgument_signed_algorithmIdentifier._ext = []
    __CompareArgument_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    _CompareArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __CompareArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __CompareArgument_signed_algorithmIdentifier),
        (u'signature', __CompareArgument_signed_signature),
        ])
    _CompareArgument_signed._ext = []
    CompareArgument._cont = ASN1Dict([
        (u'unsigned', _CompareArgument_unsigned),
        (u'signed', _CompareArgument_signed),
        ])
    CompareArgument._ext = None
    
    #-----< CompareArgumentData >-----#
    CompareArgumentData = SET(name=u'CompareArgumentData', mode=MODE_TYPE)
    _CompareArgumentData_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _CompareArgumentData_purported = SEQ(name=u'purported', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _CompareArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _CompareArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CompareArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CompareArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _CompareArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CompareArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CompareArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _CompareArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _CompareArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _CompareArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CompareArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _CompareArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    CompareArgumentData._cont = ASN1Dict([
        (u'object', _CompareArgumentData_object),
        (u'purported', _CompareArgumentData_purported),
        (u'serviceControls', _CompareArgumentData_serviceControls),
        (u'securityParameters', _CompareArgumentData_securityParameters),
        (u'requestor', _CompareArgumentData_requestor),
        (u'operationProgress', _CompareArgumentData_operationProgress),
        (u'aliasedRDNs', _CompareArgumentData_aliasedRDNs),
        (u'criticalExtensions', _CompareArgumentData_criticalExtensions),
        (u'referenceType', _CompareArgumentData_referenceType),
        (u'entryOnly', _CompareArgumentData_entryOnly),
        (u'exclusions', _CompareArgumentData_exclusions),
        (u'nameResolveOnMaster', _CompareArgumentData_nameResolveOnMaster),
        (u'operationContexts', _CompareArgumentData_operationContexts),
        (u'familyGrouping', _CompareArgumentData_familyGrouping),
        ])
    CompareArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< CompareResult >-----#
    CompareResult = CHOICE(name=u'CompareResult', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _CompareResult_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareResultData')))
    _CompareResult_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __CompareResult_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareResultData')))
    __CompareResult_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___CompareResult_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____CompareResult_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_1 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_6 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_7 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_8 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'AES-InitializationVector')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_9 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_10 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KEA-Parms-Id')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_11 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DSS-Parms')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_12 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_13 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_14 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'X509Curves')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_15 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'DomainParameters')))
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_16 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_17 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_18 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_19 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_20 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE)
    ______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ________CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _________CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0 = NULL(name=u'Type', mode=MODE_TYPE)
    ________CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _________CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab_val_Type_0), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))])], rr=[], ev=None, er=[])
    _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab = ________CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_at = None
    _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm._const_tab_id = u'id'
    _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab = ________CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm_tab
    _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters._const_tab_id = u'Type'
    ______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_algorithm),
        (u'parameters', _______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm_parameters),
        ])
    ______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm._ext = []
    ______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    ______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21._cont = ASN1Dict([
        (u'hashAlgorithm', ______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_hashAlgorithm),
        (u'saltLength', ______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_saltLength),
        (u'trailerField', ______CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21_trailerField),
        ])
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21._ext = None
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_28 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_29 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_30 = NULL(name=u'Type', mode=MODE_TYPE)
    _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_31 = NULL(name=u'Type', mode=MODE_TYPE)
    ____CompareResult_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 2, 5))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_1), (u'id', (1, 3, 14, 3, 2, 26))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_6), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 2))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_7), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 22))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_8), (u'id', (2, 16, 840, 1, 101, 3, 4, 1, 42))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_9), (u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_10), (u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_11), (u'id', (1, 2, 840, 10040, 4, 1))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_12), (u'id', (1, 2, 840, 10045, 2, 1))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_13), (u'id', (1, 3, 132, 1, 12))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_14), (u'id', (1, 3, 132, 1, 13))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_15), (u'id', (1, 2, 840, 10046, 2, 1))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_17), (u'id', (1, 2, 840, 113549, 1, 1, 14))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_18), (u'id', (1, 2, 840, 113549, 1, 1, 11))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_19), (u'id', (1, 2, 840, 113549, 1, 1, 12))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_20), (u'id', (1, 2, 840, 113549, 1, 1, 13))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_28), (u'id', (1, 2, 840, 113549, 2, 8))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_29), (u'id', (1, 2, 840, 113549, 2, 9))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_30), (u'id', (1, 2, 840, 113549, 2, 10))]), dict([(u'Type', _____CompareResult_signed_algorithmIdentifier_algorithm_tab_val_Type_31), (u'id', (1, 2, 840, 113549, 2, 11))])], rr=[], ev=None, er=[])
    ___CompareResult_signed_algorithmIdentifier_algorithm._const_tab = ____CompareResult_signed_algorithmIdentifier_algorithm_tab
    ___CompareResult_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___CompareResult_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___CompareResult_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___CompareResult_signed_algorithmIdentifier_parameters._const_tab = ____CompareResult_signed_algorithmIdentifier_algorithm_tab
    ___CompareResult_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___CompareResult_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __CompareResult_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___CompareResult_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___CompareResult_signed_algorithmIdentifier_parameters),
        ])
    __CompareResult_signed_algorithmIdentifier._ext = []
    __CompareResult_signed_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    _CompareResult_signed._cont = ASN1Dict([
        (u'toBeSigned', __CompareResult_signed_toBeSigned),
        (u'algorithmIdentifier', __CompareResult_signed_algorithmIdentifier),
        (u'signature', __CompareResult_signed_signature),
        ])
    _CompareResult_signed._ext = []
    CompareResult._cont = ASN1Dict([
        (u'unsigned', _CompareResult_unsigned),
        (u'signed', _CompareResult_signed),
        ])
    CompareResult._ext = None
    
    #-----< CompareResultData >-----#
    CompareResultData = SET(name=u'CompareResultData', mode=MODE_TYPE)
    _CompareResultData_name = CHOICE(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CompareResultData_matched = BOOL(name=u'matched', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _CompareResultData_fromEntry = BOOL(name=u'fromEntry', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _CompareResultData_matchedSubtype = OID(name=u'matchedSubtype', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')), opt=True)
    _CompareResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CompareResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CompareResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CompareResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __CompareResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___CompareResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____CompareResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____CompareResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____CompareResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____CompareResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____CompareResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____CompareResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______TBSAttributeCertificate_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___CompareResultData_notification__item__type._const_tab = ____CompareResultData_notification__item__type_tab
    ___CompareResultData_notification__item__type._const_tab_at = None
    ___CompareResultData_notification__item__type._const_tab_id = u'id'
    ___CompareResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____CompareResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____CompareResultData_notification__item__values__item_._const_tab = ____CompareResultData_notification__item__type_tab
    ____CompareResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____CompareResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___CompareResultData_notification__item__values._cont = ____CompareResultData_notification__item__values__item_
    ___CompareResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___CompareResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____CompareResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____CompareResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____CompareResultData_notification__item__valuesWithContext__item__value._const_tab = ____CompareResultData_notification__item__type_tab
    _____CompareResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____CompareResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____CompareResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______CompareResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____CompareResultData_notification__item__valuesWithContext__item__contextList._cont = ______CompareResultData_notification__item__valuesWithContext__item__contextList__item_
    _____CompareResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____CompareResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____CompareResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____CompareResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____CompareResultData_notification__item__valuesWithContext__item_._ext = []
    ___CompareResultData_notification__item__valuesWithContext._cont = ____CompareResultData_notification__item__valuesWithContext__item_
    ___CompareResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __CompareResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___CompareResultData_notification__item__type),
        (u'values', ___CompareResultData_notification__item__values),
        (u'valuesWithContext', ___CompareResultData_notification__item__valuesWithContext),
        ])
    __CompareResultData_notification__item_._ext = []
    _CompareResultData_notification._cont = __CompareResultData_notification__item_
    CompareResultData._cont = ASN1Dict([
        (u'name', _CompareResultData_name),
        (u'matched', _CompareResultData_matched),
        (u'fromEntry', _CompareResultData_fromEntry),
        (u'matchedSubtype', _CompareResultData_matchedSubtype),
        (u'securityParameters', _CompareResultData_securityParameters),
        (u'performer', _CompareResultData_performer),
        (u'aliasDereferenced', _CompareResultData_aliasDereferenced),
        (u'notification', _CompareResultData_notification),
        ])
    CompareResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< abandon >-----#
    abandon = CLASS(name=u'abandon', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _abandon_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonArgument')))
    _abandon_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonResult')))
    __OPERATION_Errors_val_ParameterType_0_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_0_1_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonFailedData')))
    ___OPERATION_Errors_val_ParameterType_0_1_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_1_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonFailedData')))
    ____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefTyp