# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ec_system_information_type_2.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 9.1.43q EC System information type 2
# top-level object: EC System Information Type 2



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

ec_rach_control_parameters_struct = CSN1List(name='ec_rach_control_parameters_struct', list=[
  CSN1Bit(name='ec_max_retrans', bit=2),
  CSN1Bit(name='sm', bit=2),
  CSN1Bit(name='tm', bit=2),
  CSN1Bit(name='access_timeslots'),
  CSN1Bit(name='cc_access_adaptation', bit=2),
  CSN1Bit(name='cell_bar_access'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='ec_access_control_class', bit=7),
    CSN1Bit(name='exception_report_status')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='bt_threshold_ul_margin', bit=3)])})])

coverage_class_selection_parameters_struct = CSN1List(name='coverage_class_selection_parameters_struct', list=[
  CSN1Bit(name='dl_cc_selection'),
  CSN1Bit(name='bt_threshold_dl', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='cc2_range_dl', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='cc3_range_dl', bit=5)])}),
  CSN1Bit(name='bt_threshold_ul', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='cc2_range_ul', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='cc3_range_ul', bit=5)])}),
  CSN1Bit(name='bspwr', bit=6),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='dl_signal_strength_step_size', bit=2)])}),
  CSN1Bit(name='ec_reduced_pdch_allocation')])

short_rach_control_parameters_struct = CSN1List(name='short_rach_control_parameters_struct', list=[
  CSN1Bit(name='max_retrans', bit=2),
  CSN1Bit(name='tx_integer', bit=4),
  CSN1Bit(name='cell_bar_access'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='access_control_class', bit=16),
    CSN1Bit(name='exception_report_status')])})])

ec_cell_options_struct = CSN1List(name='ec_cell_options_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='alpha', bit=4)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='t3168', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='t3192', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='t3226', bit=3)])}),
  CSN1Bit(name='t3248', bit=2)])

ec_cell_selection_parameters_struct = CSN1List(name='ec_cell_selection_parameters_struct', list=[
  CSN1Bit(name='location_area_identification', bit=40),
  CSN1Bit(name='routing_area_code', bit=8),
  CSN1Bit(name='cell_identity', bit=16),
  CSN1Bit(name='ec_bs_cc_chans', bit=2),
  CSN1Bit(name='ec_rxlev_access_min', bit=6),
  CSN1Bit(name='ms_txpwr_max_cch', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='lb_ms_txpwr_max_cch', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='cell_selection_rla_margin', bit=3)])})])

ec_system_information_type_2 = CSN1List(name='ec_system_information_type_2', list=[
  CSN1Bit(name='message_type', bit=3),
  CSN1Bit(name='ec_si_2_index', bit=2),
  CSN1Bit(name='ec_si_2_count', bit=2),
  CSN1Bit(name='ec_si_change_mark', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='ec_cell_selection_parameters', obj=ec_cell_selection_parameters_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='coverage_class_selection_parameters', obj=coverage_class_selection_parameters_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='ec_rach_control_parameters', obj=ec_rach_control_parameters_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='short_rach_control_parameters', obj=short_rach_control_parameters_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='ec_cell_options', obj=ec_cell_options_struct)])}),
  CSN1Ref(obj=spare_padding)])

