# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ps_handover_radio_resources_ie.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 12.42 PS Handover Radio Resources
# top-level object: PS Handover Radio Resources IE

# external references
from pycrate_csn1dir.frequency_parameters_ie import frequency_parameters_ie
from pycrate_csn1dir.global_packet_timing_advance_ie import global_packet_timing_advance_ie
from pycrate_csn1dir.egprs_modulation_and_coding_scheme_ie import egprs_modulation_and_coding_scheme_ie
from pycrate_csn1dir.egprs_window_size_ie import egprs_window_size_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

downlink_tbf_assignment_struct = CSN1List(name='downlink_tbf_assignment_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='pfi', bit=7)])}),
  CSN1Bit(name='rlc_mode'),
  CSN1Bit(name='tfi_assignment', bit=5),
  CSN1Bit(name='control_ack'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='egprs_window_size', obj=egprs_window_size_ie)])})])

ccn_support_description_struct = CSN1List(name='ccn_support_description_struct', list=[
  CSN1Bit(name='number_cells', bit=7),
  CSN1Bit(name='ccn_supported', num=([0], lambda x: x))])

timeslot_description_struct = CSN1Alt(name='timeslot_description_struct', alt={
  '0': ('', [
  CSN1Bit(name='ms_timeslot_allocation', bit=8)]),
  '1': ('', [
  CSN1Bit(name='alpha', bit=4),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gamma_tn0', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gamma_tn1', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gamma_tn2', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gamma_tn3', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gamma_tn4', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gamma_tn5', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gamma_tn6', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='gamma_tn7', bit=5)])})])})

uplink_tbf_assignment_struct = CSN1List(name='uplink_tbf_assignment_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='pfi', bit=7)])}),
  CSN1Bit(name='rlc_mode'),
  CSN1Bit(name='tfi_assignment', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='channel_coding_command', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='egprs_channel_coding_command', obj=egprs_modulation_and_coding_scheme_ie)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='egprs_window_size', obj=egprs_window_size_ie)])}),
  CSN1Bit(name='usf_granularity'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='tbf_timeslot_allocation', bit=('# unprocessed: (N)', lambda: 0))])}),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='usf_allocation', bit=3)]),
    '1': ('', [
    CSN1Bit(name='usf_allocation', bit=3),
    CSN1Alt(num=('# unprocessed: (M-1)', lambda: 0), alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_allocation', bit=3)])})])})])

downlink_assignment_struct = CSN1List(name='downlink_assignment_struct', list=[
  CSN1Bit(name='timeslot_allocation', bit=8),
  CSN1Ref(name='downlink_tbf_assignment', obj=downlink_tbf_assignment_struct)])

gprs_mode_struct = CSN1List(name='gprs_mode_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='channel_coding_command', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='global_timeslot_description', obj=timeslot_description_struct),
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='uplink_assignment', obj=uplink_tbf_assignment_struct)]),
    CSN1Val(name='', val='0')])}),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='1'),
    CSN1Ref(name='downlink_assignment', obj=downlink_assignment_struct)]),
  CSN1Val(name='', val='0')])

egprs_mode_struct = CSN1List(name='egprs_mode_struct', list=[
  CSN1List(list=[
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='egprs_window_size', obj=egprs_window_size_ie)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='egprs_channel_coding_command', obj=egprs_modulation_and_coding_scheme_ie)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='bep_period2', bit=4)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='global_timeslot_description', obj=timeslot_description_struct),
      CSN1List(num=-1, list=[
        CSN1Val(name='', val='1'),
        CSN1Ref(name='uplink_assignment', obj=uplink_tbf_assignment_struct)]),
      CSN1Val(name='', val='0')])})]),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(name='egprs_window_size', obj=egprs_window_size_ie)])}),
      CSN1Bit(name='link_quality_measurement_mode', bit=2),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='bep_period2', bit=4)])})])}),
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='downlink_assignment', obj=downlink_assignment_struct)]),
    CSN1Val(name='', val='0')])})])

ps_handover_radio_resources_ie = CSN1List(name='ps_handover_radio_resources_ie', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='handover_reference', bit=8)])}),
  CSN1Bit(name='arfcn', bit=10),
  CSN1Bit(name='si', bit=2),
  CSN1Bit(name='nci'),
  CSN1Bit(name='bsic', bit=6),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='ccn_active')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_3g_ccn_active')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='ccn_support_description', obj=ccn_support_description_struct)])}),
  CSN1Ref(name='frequency_parameters', obj=frequency_parameters_ie),
  CSN1Bit(name='network_control_order', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='global_packet_timing_advance', obj=global_packet_timing_advance_ie),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='packet_extended_timing_advance', bit=2)])})])}),
  CSN1Bit(name='extended_dynamic_allocation'),
  CSN1Bit(name='rlc_reset'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='p0', bit=4),
    CSN1Bit(name='pr_mode')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='uplink_control_timeslot', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Ref(name='gprs_mode', obj=gprs_mode_struct)]),
    '1': ('', [
    CSN1Ref(name='egprs_mode', obj=egprs_mode_struct)])})])

