# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/psi5_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.23 Packet System Information Type 5
# top-level object: PSI5 message content

# external references
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.packet_cell_change_order_message_content import gprs_3g_additional_measurement_parameters_description_2_struct

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

nc_measurement_parameters_struct = CSN1List(name='nc_measurement_parameters_struct', list=[
  CSN1Bit(name='network_control_order', bit=2),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='nc__non_drx_period', bit=3),
    CSN1Bit(name='nc_reporting_period_i', bit=3),
    CSN1Bit(name='nc_reporting_period_t', bit=3)])})])

gprs_3g_additional_measurement_parameters_2_struct = CSN1Alt(name='gprs_3g_additional_measurement_parameters_2_struct', alt={
  '0': ('', []),
  '1': ('', [
  CSN1Bit(name='fdd_reporting_threshold_2', bit=6)])})

gprs_3g_measurement_parameters_description_struct = CSN1List(name='gprs_3g_measurement_parameters_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='fdd_rep_quant'),
    CSN1Bit(name='fdd_multirat_reporting', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='fdd_reporting_offset', bit=3),
    CSN1Bit(name='fdd_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='tdd_multirat_reporting', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='tdd_reporting_offset', bit=3),
    CSN1Bit(name='tdd_reporting_threshold', bit=3)])})])

gprs_measurement_parameters_description_struct = CSN1List(name='gprs_measurement_parameters_description_struct', list=[
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='multiband_reporting', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='serving_band_reporting', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='scale_ord', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_900_reporting_offset', bit=3),
    CSN1Bit(name='_900_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_1800_reporting_offset', bit=3),
    CSN1Bit(name='_1800_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_400_reporting_offset', bit=3),
    CSN1Bit(name='_400_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_1900_reporting_offset', bit=3),
    CSN1Bit(name='_1900_reporting_threshold', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='_850_reporting_offset', bit=3),
    CSN1Bit(name='_850_reporting_threshold', bit=3)])})])

enh_reporting_parameters_struct = CSN1List(name='enh_reporting_parameters_struct', list=[
  CSN1Bit(name='report_type'),
  CSN1Bit(name='reporting_rate'),
  CSN1Bit(name='invalid_bsic_reporting'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='ncc_permitted', bit=8)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='gprs_measurement_parameters_description', obj=gprs_measurement_parameters_description_struct)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='gprs_3g_measurement_parameters_description', obj=gprs_3g_measurement_parameters_description_struct)])})])

psi5_message_content = CSN1List(name='psi5_message_content', list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1Bit(name='psi5_change_mark', bit=2),
  CSN1Bit(name='psi5_index', bit=3),
  CSN1Bit(name='psi5_count', bit=3),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='nc_measurement_parameters', obj=nc_measurement_parameters_struct)])}),
  CSN1Val(name='', val='0'),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(bit=-1)]),
    '1': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Ref(name='enh_reporting_parameters', obj=enh_reporting_parameters_struct)])}),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(bit=-1)]),
      '1': ('', [
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(name='gprs_3g_additional_measurement_parameters_description_2', obj=gprs_3g_additional_measurement_parameters_description_2_struct)])}),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Bit(bit=-1)]),
        '1': ('', [
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='_700_reporting_offset', bit=3),
          CSN1Bit(name='_700_reporting_threshold', bit=3)])}),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='_810_reporting_offset', bit=3),
          CSN1Bit(name='_810_reporting_threshold', bit=3)])}),
        CSN1Ref(obj=padding_bits)]),
        None: ('', [])})]),
      None: ('', [])})]),
    None: ('', [])})])

