# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/rr_packet_uplink_assignment_value_part.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.25c RR Packet Uplink Assignment
# top-level object: RR Packet Uplink Assignment value part

# external references
from pycrate_csn1dir.pulse_format_ie import pulse_format_ie
from pycrate_csn1dir.egprs_level_ie import egprs_level_ie
from pycrate_csn1dir.packet_timing_advance_ie import packet_timing_advance_ie
from pycrate_csn1dir.egprs_window_size_ie import egprs_window_size_ie
from pycrate_csn1dir.packet_uplink_assignment_message_content import extension
from pycrate_csn1dir.egprs_modulation_and_coding_scheme_ie import egprs_modulation_and_coding_scheme_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_bit = CSN1Bit(name='spare_bit')
Spare_bit = spare_bit
Spare_Bit = spare_bit

timeslot_description_struct = CSN1Alt(name='timeslot_description_struct', alt={
  '0': ('', [
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity')])})]),
  '1': ('', [
  CSN1Bit(name='alpha', bit=4),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity'),
    CSN1Bit(name='gamma_tn0', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity'),
    CSN1Bit(name='gamma_tn1', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity'),
    CSN1Bit(name='gamma_tn2', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity'),
    CSN1Bit(name='gamma_tn3', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity'),
    CSN1Bit(name='gamma_tn4', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity'),
    CSN1Bit(name='gamma_tn5', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity'),
    CSN1Bit(name='gamma_tn6', bit=5)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='usf_granularity'),
    CSN1Bit(name='gamma_tn7', bit=5)])})])})

rlc_entity_struct = CSN1List(name='rlc_entity_struct', list=[
  CSN1Bit(name='uplink_tfi_assignment', bit=5),
  CSN1Bit(name='rlc_mode'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='egprs_window_size', obj=egprs_window_size_ie)])}),
  CSN1Bit(name='pfi', bit=7)])

usf_assignment_struct = CSN1Alt(name='usf_assignment_struct', alt={
  '0': ('', []),
  '1': ('', [
  CSN1Bit(name='usf_allocation', bit=3)])})

dynamic_allocation_struct = CSN1List(name='dynamic_allocation_struct', list=[
  CSN1Bit(name='extended_dynamic_allocation'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='p0', bit=4),
    CSN1Bit(name='pr_mode')])}),
  CSN1Bit(name='usf_granularity'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='uplink_tfi_assignment', bit=5)])}),
  CSN1Val(name='', val='0'),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn0', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn1', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn2', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn3', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn4', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn5', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn6', bit=3)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn7', bit=3)])})]),
    '1': ('', [
    CSN1Bit(name='alpha', bit=4),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn0', bit=3),
      CSN1Bit(name='gamma_tn0', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn1', bit=3),
      CSN1Bit(name='gamma_tn1', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn2', bit=3),
      CSN1Bit(name='gamma_tn2', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn3', bit=3),
      CSN1Bit(name='gamma_tn3', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn4', bit=3),
      CSN1Bit(name='gamma_tn4', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn5', bit=3),
      CSN1Bit(name='gamma_tn5', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn6', bit=3),
      CSN1Bit(name='gamma_tn6', bit=5)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='usf_tn7', bit=3),
      CSN1Bit(name='gamma_tn7', bit=5)])})])})])

uplink_tbf_assignment_struct = CSN1List(name='uplink_tbf_assignment_struct', list=[
  CSN1Bit(name='pfi', bit=7),
  CSN1Bit(name='rlc_mode'),
  CSN1Bit(name='uplink_tfi_assignment', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='channel_coding_command', bit=2)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='egprs_channel_coding_command', obj=egprs_modulation_and_coding_scheme_ie)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='egprs_window_size', obj=egprs_window_size_ie)])}),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='usf_allocation', bit=3)]),
    '1': ('', [
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='usf_assignment', obj=usf_assignment_struct)]),
    CSN1Val(name='', val='0')])})])

additional_pfcs_struct = CSN1List(name='additional_pfcs_struct', list=[
  CSN1Bit(name='uplink_tfi_assignment', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='npm_transfer_time', bit=5)])}),
  CSN1Bit(name='pfi', bit=7)])

multiple_tbf_allocation_struct = CSN1List(name='multiple_tbf_allocation_struct', list=[
  CSN1Bit(name='extended_dynamic_allocation'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='p0', bit=4),
    CSN1Bit(name='pr_mode')])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='timeslot_description', obj=timeslot_description_struct),
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='uplink_tbf_assignment', obj=uplink_tbf_assignment_struct)]),
    CSN1Val(name='', val='0')])})])

rr_packet_uplink_assignment_value_part = CSN1List(name='rr_packet_uplink_assignment_value_part', list=[
  CSN1Bit(name='channel_coding_command', bit=2),
  CSN1Bit(name='tlli_block_channel_coding'),
  CSN1Ref(name='packet_timing_advance', obj=packet_timing_advance_ie),
  CSN1Alt(alt={
    '00': ('', [
    CSN1Alt(alt={
      '0': ('', [
      CSN1Ref(name='multiple_tbf_allocation', obj=multiple_tbf_allocation_struct)]),
      '1': ('', [
      CSN1Ref(obj=extension)])})]),
    '01': ('', [
    CSN1Ref(name='dynamic_allocation', obj=dynamic_allocation_struct)])}),
  CSN1Alt(alt={
    '': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='egprs_mcs_mode', bit=4),
      CSN1Bit(name='resegment'),
      CSN1Ref(name='egprs_window_size', obj=egprs_window_size_ie)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='packet_extended_timing_advance', bit=2)])}),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(bit=-1)]),
      '1': ('', [
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='rlc_mode')])}),
      CSN1List(num=-1, list=[
        CSN1Val(name='', val='1'),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='npm_transfer_time', bit=5)])})]),
      CSN1Val(name='', val='0'),
      CSN1Ref(name='uplink_egprs_level', obj=egprs_level_ie),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Ref(name='pulse_format', obj=pulse_format_ie)])}),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='reported_timeslots', bit=8),
          CSN1Bit(name='tsh', bit=2)])})])}),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Bit(bit=-1)]),
        '1': ('', [
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1List(num=-1, list=[
            CSN1Val(name='', val='1'),
            CSN1Bit(name='measurement_control_e_utran'),
            CSN1Bit(name='e_utran_frequency_index', bit=3),
            CSN1List(num=-1, list=[
              CSN1Val(name='', val='1'),
              CSN1Bit(name='e_utran_frequency_index', bit=3)]),
            CSN1Val(name='', val='0')]),
          CSN1Val(name='', val='0')])}),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1List(num=-1, list=[
            CSN1Val(name='', val='1'),
            CSN1Bit(name='measurement_control_utran'),
            CSN1Bit(name='utran_frequency_index', bit=5),
            CSN1List(num=-1, list=[
              CSN1Val(name='', val='1'),
              CSN1Bit(name='utran_frequency_index', bit=5)]),
            CSN1Val(name='', val='0')]),
          CSN1Val(name='', val='0')])}),
        CSN1Alt(alt={
          '0': ('', [
          CSN1Bit(bit=-1)]),
          '1': ('', [
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(name='emst_nw_capability')]),
            '1': ('', [
            CSN1Ref(name='rlc_entity_2', obj=rlc_entity_struct),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Ref(name='rlc_entity_3', obj=rlc_entity_struct)])})])}),
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(bit=-1)]),
            '1': ('', [
            CSN1List(num=-1, list=[
              CSN1Val(name='', val='1'),
              CSN1Ref(name='emsr_additional_pfcs_1', obj=additional_pfcs_struct)]),
            CSN1Val(name='', val='0'),
            CSN1List(num=-1, list=[
              CSN1Val(name='', val='1'),
              CSN1Ref(name='emsr_additional_pfcs_2', obj=additional_pfcs_struct)]),
            CSN1Val(name='', val='0'),
            CSN1List(num=-1, list=[
              CSN1Val(name='', val='1'),
              CSN1Ref(name='emsr_additional_pfcs_3', obj=additional_pfcs_struct)]),
            CSN1Val(name='', val='0'),
            CSN1Ref(obj=spare_bit, num=-1)]),
            None: ('', [])})]),
          None: ('', [])})]),
        None: ('', [])})]),
      None: ('', [])})]),
    None: ('', [])})])

