# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/si_13_rest_octets.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.37b SI 13 Rest Octets
# top-level object: SI 13 Rest Octets

# external references
from pycrate_csn1dir.gprs_mobile_allocation_ie import gprs_mobile_allocation_ie
from pycrate_csn1dir.gprs_power_control_parameters_ie import gprs_power_control_parameters_ie
from pycrate_csn1dir.gprs_cell_options_ie import gprs_cell_options_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

si_change_alt = CSN1Alt(name='si_change_alt', alt={
  'H': ('', []),
  'L': ('', [])})

pbcch_description_struct = CSN1List(name='pbcch_description_struct', list=[
  CSN1Bit(name='pb', bit=4),
  CSN1Bit(name='tsc', bit=3),
  CSN1Bit(name='tn', bit=3),
  CSN1Alt(alt={
    '00': ('', []),
    '01': ('', [
    CSN1Bit(name='arfcn', bit=10)]),
    '1': ('', [
    CSN1Bit(name='maio', bit=6)])})])

si_13_rest_octets = CSN1List(name='si_13_rest_octets', list=[
  CSN1Alt(alt={
    'H': ('', [
    CSN1Bit(name='bcch_change_mark', bit=3),
    CSN1Bit(name='si_change_field', bit=4),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='si13_change_mark', bit=2),
      CSN1Ref(name='gprs_mobile_allocation', obj=gprs_mobile_allocation_ie)])}),
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(name='rac', bit=8),
      CSN1Bit(name='spgc_ccch_sup'),
      CSN1Bit(name='priority_access_thr', bit=3),
      CSN1Bit(name='network_control_order', bit=2),
      CSN1Ref(name='gprs_cell_options', obj=gprs_cell_options_ie),
      CSN1Ref(name='gprs_power_control_parameters', obj=gprs_power_control_parameters_ie)]),
      '1': ('', [
      CSN1Bit(name='psi1_repeat_period', bit=4),
      CSN1Ref(name='pbcch_description', obj=pbcch_description_struct)])}),
    CSN1Alt(alt={
      'H': ('', [
      CSN1Bit(name='sgsnr'),
      CSN1Alt(alt={
        'H': ('', [
        CSN1Bit(name='si_status_ind'),
        CSN1Alt(trunc=True, alt={
          'H': ('', [
          CSN1Alt(alt={
            '0': ('', []),
            '1': ('', [
            CSN1Bit(name='lb_ms_txpwr_max_cch', bit=5)])}),
          CSN1Bit(name='si2n_support', bit=2),
          CSN1List(list=[
            CSN1Ref(obj=si_change_alt),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='peo_dsc', bit=2),
              CSN1Bit(name='rcc', bit=3)])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Bit(name='c1_delta_min', bit=2),
              CSN1Bit(name='c1_delta_max', bit=3)])})])]),
          'L': ('', []),
          None: ('', [])})]),
        'L': ('', []),
        None: ('', [])})]),
      'L': ('', []),
      None: ('', [])})]),
    'L': ('', [])}),
  CSN1Ref(obj=spare_padding)])

