/*
 * Copyright (c) 2014-2019, 2021, The Linux Foundation. All rights reserved.
 * Copyright (c) 2021-2022, Qualcomm Innovation Center, Inc. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*qca808x_start*/
#ifndef _SW_IOCTL_H_
#define _SW_IOCTL_H_

#ifdef __cplusplus
extern "C" {
#endif                          /* __cplusplus */

    /*init*/
#define SW_API_INIT_OFFSET         10
#define SW_API_SWITCH_INIT         (0  + SW_API_INIT_OFFSET)
#define SW_API_SWITCH_RESET        (1  + SW_API_INIT_OFFSET)
#define SW_API_SSDK_CFG            (2  + SW_API_INIT_OFFSET)
#define SW_API_MODULE_FUNC_CTRL_SET   (3  + SW_API_INIT_OFFSET)
#define SW_API_MODULE_FUNC_CTRL_GET   (4  + SW_API_INIT_OFFSET)
#define SW_API_PPE_CAPACITY_GET       (5  + SW_API_INIT_OFFSET)

    /*port ctrl*/
#define SW_API_PORT_OFFSET          30
#define SW_API_PT_DUPLEX_GET        (0  + SW_API_PORT_OFFSET)
#define SW_API_PT_DUPLEX_SET        (1  + SW_API_PORT_OFFSET)
#define SW_API_PT_SPEED_GET         (2  + SW_API_PORT_OFFSET)
#define SW_API_PT_SPEED_SET         (3  + SW_API_PORT_OFFSET)
#define SW_API_PT_AN_ADV_GET        (4  + SW_API_PORT_OFFSET)
#define SW_API_PT_AN_ADV_SET        (5  + SW_API_PORT_OFFSET)
#define SW_API_PT_AN_GET            (6  + SW_API_PORT_OFFSET)
#define SW_API_PT_AN_ENABLE         (7  + SW_API_PORT_OFFSET)
#define SW_API_PT_AN_RESTART        (8  + SW_API_PORT_OFFSET)
/*qca808x_end*/
#define SW_API_PT_HDR_SET           (9  + SW_API_PORT_OFFSET)
#define SW_API_PT_HDR_GET           (10 + SW_API_PORT_OFFSET)
#define SW_API_PT_FLOWCTRL_SET      (11 + SW_API_PORT_OFFSET)
#define SW_API_PT_FLOWCTRL_GET      (12 + SW_API_PORT_OFFSET)
#define SW_API_PT_FLOWCTRL_MODE_SET (13 + SW_API_PORT_OFFSET)
#define SW_API_PT_FLOWCTRL_MODE_GET (14 + SW_API_PORT_OFFSET)
#define SW_API_PT_POWERSAVE_SET     (15 + SW_API_PORT_OFFSET)
#define SW_API_PT_POWERSAVE_GET     (16 + SW_API_PORT_OFFSET)
/*qca808x_start*/
#define SW_API_PT_HIBERNATE_SET     (17 + SW_API_PORT_OFFSET)
#define SW_API_PT_HIBERNATE_GET     (18 + SW_API_PORT_OFFSET)
#define SW_API_PT_CDT               (19 + SW_API_PORT_OFFSET)
/*qca808x_end*/
#define SW_API_PT_TXHDR_SET         (20 + SW_API_PORT_OFFSET)
#define SW_API_PT_TXHDR_GET         (21 + SW_API_PORT_OFFSET)
#define SW_API_PT_RXHDR_SET         (22 + SW_API_PORT_OFFSET)
#define SW_API_PT_RXHDR_GET         (23 + SW_API_PORT_OFFSET)
#define SW_API_HEADER_TYPE_SET      (24 + SW_API_PORT_OFFSET)
#define SW_API_HEADER_TYPE_GET      (25 + SW_API_PORT_OFFSET)
#define SW_API_TXMAC_STATUS_SET     (26 + SW_API_PORT_OFFSET)
#define SW_API_TXMAC_STATUS_GET     (27 + SW_API_PORT_OFFSET)
#define SW_API_RXMAC_STATUS_SET     (28 + SW_API_PORT_OFFSET)
#define SW_API_RXMAC_STATUS_GET     (29 + SW_API_PORT_OFFSET)
#define SW_API_TXFC_STATUS_SET      (30 + SW_API_PORT_OFFSET)
#define SW_API_TXFC_STATUS_GET      (31 + SW_API_PORT_OFFSET)
#define SW_API_RXFC_STATUS_SET      (32 + SW_API_PORT_OFFSET)
#define SW_API_RXFC_STATUS_GET      (33 + SW_API_PORT_OFFSET)
#define SW_API_BP_STATUS_SET        (34 + SW_API_PORT_OFFSET)
#define SW_API_BP_STATUS_GET        (35 + SW_API_PORT_OFFSET)
#define SW_API_PT_LINK_MODE_SET     (36 + SW_API_PORT_OFFSET)
#define SW_API_PT_LINK_MODE_GET     (37 + SW_API_PORT_OFFSET)
/*qca808x_start*/
#define SW_API_PT_LINK_STATUS_GET   (38 + SW_API_PORT_OFFSET)
/*qca808x_end*/
#define SW_API_PT_MAC_LOOPBACK_SET   (39+ SW_API_PORT_OFFSET)
#define SW_API_PT_MAC_LOOPBACK_GET   (40+ SW_API_PORT_OFFSET)
#define SW_API_PTS_LINK_STATUS_GET   (41 + SW_API_PORT_OFFSET)
#define SW_API_PT_CONGESTION_DROP_SET   (42+ SW_API_PORT_OFFSET)
#define SW_API_PT_CONGESTION_DROP_GET   (43+ SW_API_PORT_OFFSET)
#define SW_API_PT_RING_FLOW_CTRL_THRES_SET   (44+ SW_API_PORT_OFFSET)
#define SW_API_PT_RING_FLOW_CTRL_THRES_GET   (45+ SW_API_PORT_OFFSET)
/*qca808x_start*/
#define SW_API_PT_8023AZ_SET     (46 + SW_API_PORT_OFFSET)
#define SW_API_PT_8023AZ_GET     (47 + SW_API_PORT_OFFSET)
#define SW_API_PT_MDIX_SET  (48 + SW_API_PORT_OFFSET)
#define SW_API_PT_MDIX_GET  (49 + SW_API_PORT_OFFSET)
#define SW_API_PT_MDIX_STATUS_GET  (50 + SW_API_PORT_OFFSET)
/*qca808x_end*/
#define SW_API_PT_COMBO_PREFER_MEDIUM_SET (51 + SW_API_PORT_OFFSET)
#define SW_API_PT_COMBO_PREFER_MEDIUM_GET  (52 + SW_API_PORT_OFFSET)
#define SW_API_PT_COMBO_MEDIUM_STATUS_GET  (53 + SW_API_PORT_OFFSET)
#define SW_API_PT_COMBO_FIBER_MODE_SET  (54 + SW_API_PORT_OFFSET)
#define SW_API_PT_COMBO_FIBER_MODE_GET  (55 + SW_API_PORT_OFFSET)
/*qca808x_start*/
#define SW_API_PT_LOCAL_LOOPBACK_SET  (56 + SW_API_PORT_OFFSET)
#define SW_API_PT_LOCAL_LOOPBACK_GET  (57 + SW_API_PORT_OFFSET)
#define SW_API_PT_REMOTE_LOOPBACK_SET  (58 + SW_API_PORT_OFFSET)
#define SW_API_PT_REMOTE_LOOPBACK_GET  (59 + SW_API_PORT_OFFSET)
#define SW_API_PT_RESET  (60 + SW_API_PORT_OFFSET)
#define SW_API_PT_POWER_OFF  (61 + SW_API_PORT_OFFSET)
#define SW_API_PT_POWER_ON  (62 + SW_API_PORT_OFFSET)
#define SW_API_PT_MAGIC_FRAME_MAC_SET  (63 + SW_API_PORT_OFFSET)
#define SW_API_PT_MAGIC_FRAME_MAC_GET  (64 + SW_API_PORT_OFFSET)
#define SW_API_PT_PHY_ID_GET  (65 + SW_API_PORT_OFFSET)
#define SW_API_PT_WOL_STATUS_SET  (66 + SW_API_PORT_OFFSET)
#define SW_API_PT_WOL_STATUS_GET  (67 + SW_API_PORT_OFFSET)
/*qca808x_end*/
#define SW_API_PT_INTERFACE_MODE_SET  (68 + SW_API_PORT_OFFSET)
#define SW_API_PT_INTERFACE_MODE_GET  (69 + SW_API_PORT_OFFSET)
/*qca808x_start*/
#define SW_API_PT_INTERFACE_MODE_STATUS_GET  (70 + SW_API_PORT_OFFSET)
#define SW_API_DEBUG_PHYCOUNTER_SET  (71 + SW_API_PORT_OFFSET)
#define SW_API_DEBUG_PHYCOUNTER_GET  (72 + SW_API_PORT_OFFSET)
#define SW_API_DEBUG_PHYCOUNTER_SHOW  (73 + SW_API_PORT_OFFSET)
/*qca808x_end*/
#define SW_API_PT_INTERFACE_MODE_APPLY  (74 + SW_API_PORT_OFFSET)
#define SW_API_PT_INTERFACE_3AZ_STATUS_SET  (75 + SW_API_PORT_OFFSET)
#define SW_API_PT_INTERFACE_3AZ_STATUS_GET  (76 + SW_API_PORT_OFFSET)
#define SW_API_PT_PROMISC_MODE_SET   (77  + SW_API_PORT_OFFSET)
#define SW_API_PT_PROMISC_MODE_GET   (78  + SW_API_PORT_OFFSET)
#define SW_API_PT_INTERFACE_EEE_CFG_SET  (79 + SW_API_PORT_OFFSET)
#define SW_API_PT_INTERFACE_EEE_CFG_GET  (80 + SW_API_PORT_OFFSET)
#define SW_API_PT_SWITCH_PORT_LOOPBACK_SET  (81 + SW_API_PORT_OFFSET)
#define SW_API_PT_SWITCH_PORT_LOOPBACK_GET  (82 + SW_API_PORT_OFFSET)
#define SW_API_PT_8023AH_SET  (83 + SW_API_PORT_OFFSET)
#define SW_API_PT_8023AH_GET  (84 + SW_API_PORT_OFFSET)
#define SW_API_PT_RING_FLOW_CTRL_STATUS_GET  (85 + SW_API_PORT_OFFSET)
#define SW_API_PT_RING_UNION_SET	(86 + SW_API_PORT_OFFSET)
#define SW_API_PT_RING_UNION_GET	(87 + SW_API_PORT_OFFSET)
#define SW_API_PT_FLOW_CTRL_THRES_SET	(88 + SW_API_PORT_OFFSET)
#define SW_API_PT_FLOW_CTRL_THRES_GET	(89 + SW_API_PORT_OFFSET)
#define SW_API_PT_RING_FLOW_CTRL_SET	(90 + SW_API_PORT_OFFSET)
#define SW_API_PT_RING_FLOW_CTRL_GET	(91 + SW_API_PORT_OFFSET)
#define SW_API_PT_CNT_CFG_SET		(92 + SW_API_PORT_OFFSET)
#define SW_API_PT_CNT_CFG_GET		(93 + SW_API_PORT_OFFSET)
#define SW_API_PT_CNT_GET		(94 + SW_API_PORT_OFFSET)
#define SW_API_PT_CNT_FLUSH		(95 + SW_API_PORT_OFFSET)

    /*vlan*/
#define SW_API_VLAN_OFFSET         130
#define SW_API_VLAN_ADD            (0 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_DEL            (1 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_MEM_UPDATE     (2 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_FIND           (3 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_NEXT           (4 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_APPEND         (5 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_FLUSH          (6 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_FID_SET        (7 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_FID_GET        (8 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_MEMBER_ADD     (9 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_MEMBER_DEL     (10 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_LEARN_STATE_SET (11 + SW_API_VLAN_OFFSET)
#define SW_API_VLAN_LEARN_STATE_GET (12 + SW_API_VLAN_OFFSET)
#define SW_API_LAN_WAN_CFG_SET      (13 + SW_API_VLAN_OFFSET)
#define SW_API_LAN_WAN_CFG_GET      (14 + SW_API_VLAN_OFFSET)

    /*port ctrl extend*/
#define SW_API_PORT_EXT_OFFSET		160
#define SW_API_PT_MTU_SET  (0 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_MTU_GET  (1 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_MRU_SET  (2 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_MRU_GET  (3 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_SOURCE_FILTER_GET (4 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_SOURCE_FILTER_SET (5 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_FRAME_MAX_SIZE_GET (6 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_FRAME_MAX_SIZE_SET (7 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_SOURCE_FILTER_CONFIG_GET (8 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_SOURCE_FILTER_CONFIG_SET (9 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_MTU_CFG_SET  (10 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_MTU_CFG_GET  (11 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_MRU_MTU_SET  (12 + SW_API_PORT_EXT_OFFSET)
#define SW_API_PT_MRU_MTU_GET  (13 + SW_API_PORT_EXT_OFFSET)

    /*portvlan*/
#define SW_API_PORTVLAN_OFFSET       200
#define SW_API_PT_ING_MODE_GET       (0  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_ING_MODE_SET       (1  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_EG_MODE_GET        (2  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_EG_MODE_SET        (3  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_MEM_ADD       (4  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_MEM_DEL       (5  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_MEM_UPDATE    (6  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_MEM_GET       (7  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_DEF_VID_GET        (8  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_DEF_VID_SET        (9  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_FORCE_DEF_VID_SET  (10  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_FORCE_DEF_VID_GET  (11  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_FORCE_PORTVLAN_SET (12  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_FORCE_PORTVLAN_GET (13  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_NESTVLAN_SET       (14  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_NESTVLAN_GET       (15  + SW_API_PORTVLAN_OFFSET)
#define SW_API_NESTVLAN_TPID_SET     (16  + SW_API_PORTVLAN_OFFSET)
#define SW_API_NESTVLAN_TPID_GET     (17  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_IN_VLAN_MODE_SET   (18  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_IN_VLAN_MODE_GET   (19  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_TLS_SET            (20  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_TLS_GET            (21  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_PRI_PROPAGATION_SET  (22  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_PRI_PROPAGATION_GET  (23  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_DEF_SVID_SET       (24  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_DEF_SVID_GET       (25  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_DEF_CVID_SET       (26  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_DEF_CVID_GET       (27  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_PROPAGATION_SET (28  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_PROPAGATION_GET (29  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_TRANS_ADD     (30  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_TRANS_DEL     (31  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_TRANS_GET     (32  + SW_API_PORTVLAN_OFFSET)
#define SW_API_QINQ_MODE_SET         (33  + SW_API_PORTVLAN_OFFSET)
#define SW_API_QINQ_MODE_GET         (34  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_QINQ_ROLE_SET      (35  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_QINQ_ROLE_GET      (36  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_TRANS_ITERATE (37  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_MAC_VLAN_XLT_SET   (38  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_MAC_VLAN_XLT_GET   (39  + SW_API_PORTVLAN_OFFSET)
#define SW_API_NETISOLATE_SET   (40  + SW_API_PORTVLAN_OFFSET)
#define SW_API_NETISOLATE_GET   (41  + SW_API_PORTVLAN_OFFSET)
#define SW_API_EG_FLTR_BYPASS_EN_SET (42 + SW_API_PORTVLAN_OFFSET)
#define SW_API_EG_FLTR_BYPASS_EN_GET (43 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VRF_ID_SET            (44  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VRF_ID_GET            (45  + SW_API_PORTVLAN_OFFSET)
#define SW_API_GLOBAL_QINQ_MODE_SET (46  + SW_API_PORTVLAN_OFFSET)
#define SW_API_GLOBAL_QINQ_MODE_GET (47  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PORT_QINQ_MODE_SET (48  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PORT_QINQ_MODE_GET (49  + SW_API_PORTVLAN_OFFSET)
#define SW_API_TPID_SET (50  + SW_API_PORTVLAN_OFFSET)
#define SW_API_TPID_GET (51  + SW_API_PORTVLAN_OFFSET)
#define SW_API_EGRESS_TPID_SET (52  + SW_API_PORTVLAN_OFFSET)
#define SW_API_EGRESS_TPID_GET (53  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_INGRESS_VLAN_FILTER_SET (54  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_INGRESS_VLAN_FILTER_GET (55  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_DEFAULT_VLANTAG_SET (56  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_DEFAULT_VLANTAG_GET (57  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_TAG_PROPAGATION_SET (58  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_TAG_PROPAGATION_GET (59  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLANTAG_EGMODE_SET (60  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLANTAG_EGMODE_GET (61  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_XLT_MISS_CMD_SET (62  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_XLT_MISS_CMD_GET (63  + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VSI_EGMODE_SET (64 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VSI_EGMODE_GET (65 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLANTAG_VSI_EGMODE_EN_SET (66 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLANTAG_VSI_EGMODE_EN_GET (67 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_TRANS_ADV_ADD (68 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_TRANS_ADV_DEL (69 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_TRANS_ADV_GETFIRST (70 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_TRANS_ADV_GETNEXT (71 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_COUNTER_GET (72 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_COUNTER_CLEANUP (73 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_VPGROUP_SET	(74 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_VPGROUP_GET	(75 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_ISOL_SET		(76 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_ISOL_GET		(77 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_ISOL_GROUP_SET	(78 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_VLAN_ISOL_GROUP_GET	(79 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_EGRESS_VLAN_FILTER_SET	(80 + SW_API_PORTVLAN_OFFSET)
#define SW_API_PT_EGRESS_VLAN_FILTER_GET	(81 + SW_API_PORTVLAN_OFFSET)



    /*fdb*/
#define SW_API_FDB_OFFSET             300
#define SW_API_FDB_ADD                (0  + SW_API_FDB_OFFSET)
#define SW_API_FDB_DELALL             (1  + SW_API_FDB_OFFSET)
#define SW_API_FDB_DELPORT            (2  + SW_API_FDB_OFFSET)
#define SW_API_FDB_DELMAC             (3  + SW_API_FDB_OFFSET)
#define SW_API_FDB_FIRST              (4  + SW_API_FDB_OFFSET)
#define SW_API_FDB_NEXT               (5  + SW_API_FDB_OFFSET)
#define SW_API_FDB_FIND               (6  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_LEARN_SET       (7  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_LEARN_GET       (8  + SW_API_FDB_OFFSET)
#define SW_API_FDB_AGE_CTRL_SET       (9  + SW_API_FDB_OFFSET)
#define SW_API_FDB_AGE_CTRL_GET       (10  + SW_API_FDB_OFFSET)
#define SW_API_FDB_AGE_TIME_SET       (11  + SW_API_FDB_OFFSET)
#define SW_API_FDB_AGE_TIME_GET       (12  + SW_API_FDB_OFFSET)
#define SW_API_FDB_ITERATE            (13  + SW_API_FDB_OFFSET)
#define SW_API_FDB_EXTEND_NEXT        (14  + SW_API_FDB_OFFSET)
#define SW_API_PT_FDB_LEARN_LIMIT_SET (15  + SW_API_FDB_OFFSET)
#define SW_API_PT_FDB_LEARN_LIMIT_GET (16  + SW_API_FDB_OFFSET)
#define SW_API_PT_FDB_LEARN_EXCEED_CMD_SET (17  + SW_API_FDB_OFFSET)
#define SW_API_PT_FDB_LEARN_EXCEED_CMD_GET (18  + SW_API_FDB_OFFSET)
#define SW_API_FDB_LEARN_LIMIT_SET         (19  + SW_API_FDB_OFFSET)
#define SW_API_FDB_LEARN_LIMIT_GET         (20  + SW_API_FDB_OFFSET)
#define SW_API_FDB_LEARN_EXCEED_CMD_SET    (21  + SW_API_FDB_OFFSET)
#define SW_API_FDB_LEARN_EXCEED_CMD_GET    (22  + SW_API_FDB_OFFSET)
#define SW_API_FDB_RESV_ADD                (23  + SW_API_FDB_OFFSET)
#define SW_API_FDB_RESV_DEL                (24  + SW_API_FDB_OFFSET)
#define SW_API_FDB_RESV_FIND               (25  + SW_API_FDB_OFFSET)
#define SW_API_FDB_RESV_ITERATE            (26  + SW_API_FDB_OFFSET)
#define SW_API_FDB_EXTEND_FIRST            (27  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_LEARN_STATIC_SET     (28  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_LEARN_STATIC_GET     (29  + SW_API_FDB_OFFSET)
#define SW_API_FDB_TRANSFER                (30  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PORT_ADD                (31  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PORT_DEL                (32  + SW_API_FDB_OFFSET)
#define SW_API_FDB_VLAN_IVL_SVL_SET        (33  + SW_API_FDB_OFFSET)
#define SW_API_FDB_VLAN_IVL_SVL_GET        (34  + SW_API_FDB_OFFSET)
#define SW_API_FDB_RFS_SET                 (35  + SW_API_FDB_OFFSET)
#define SW_API_FDB_RFS_DEL                 (36  + SW_API_FDB_OFFSET)
#define SW_API_FDB_LEARN_CTRL_SET          (37  + SW_API_FDB_OFFSET)
#define SW_API_FDB_LEARN_CTRL_GET          (38  + SW_API_FDB_OFFSET)
#define SW_API_PT_FDB_LEARN_COUNTER_GET    (39  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_NEWADDR_LEARN_SET    (40  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_NEWADDR_LEARN_GET    (41  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_STAMOVE_SET          (42  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_STAMOVE_GET          (43  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_MACLIMIT_CTRL_SET    (44  + SW_API_FDB_OFFSET)
#define SW_API_FDB_PT_MACLIMIT_CTRL_GET    (45  + SW_API_FDB_OFFSET)
#define SW_API_FDB_DEL_BY_FID              (46  + SW_API_FDB_OFFSET)


    /*acl*/
#define SW_API_ACL_OFFSET             400
#define SW_API_ACL_LIST_CREAT         (0  + SW_API_ACL_OFFSET)
#define SW_API_ACL_LIST_DESTROY       (1  + SW_API_ACL_OFFSET)
#define SW_API_ACL_RULE_ADD           (2  + SW_API_ACL_OFFSET)
#define SW_API_ACL_RULE_DELETE        (3  + SW_API_ACL_OFFSET)
#define SW_API_ACL_RULE_QUERY         (4  + SW_API_ACL_OFFSET)
#define SW_API_ACL_LIST_BIND          (5  + SW_API_ACL_OFFSET)
#define SW_API_ACL_LIST_UNBIND        (6  + SW_API_ACL_OFFSET)
#define SW_API_ACL_STATUS_SET         (7  + SW_API_ACL_OFFSET)
#define SW_API_ACL_STATUS_GET         (8  + SW_API_ACL_OFFSET)
#define SW_API_ACL_LIST_DUMP          (9  + SW_API_ACL_OFFSET)
#define SW_API_ACL_RULE_DUMP          (10  + SW_API_ACL_OFFSET)
#define SW_API_ACL_PT_UDF_PROFILE_SET (11  + SW_API_ACL_OFFSET)
#define SW_API_ACL_PT_UDF_PROFILE_GET (12  + SW_API_ACL_OFFSET)
#define SW_API_ACL_RULE_ACTIVE        (13  + SW_API_ACL_OFFSET)
#define SW_API_ACL_RULE_DEACTIVE      (14  + SW_API_ACL_OFFSET)
#define SW_API_ACL_RULE_SRC_FILTER_STS_SET      (15  + SW_API_ACL_OFFSET)
#define SW_API_ACL_RULE_SRC_FILTER_STS_GET      (16  + SW_API_ACL_OFFSET)
#define SW_API_ACL_RULE_GET_OFFSET      (17  + SW_API_ACL_OFFSET)
#define SW_API_ACL_UDF_SET (18  + SW_API_ACL_OFFSET)
#define SW_API_ACL_UDF_GET (19  + SW_API_ACL_OFFSET)
#define SW_API_ACL_UDF_PROFILE_ENTRY_ADD	(20  + SW_API_ACL_OFFSET)
#define SW_API_ACL_UDF_PROFILE_ENTRY_DEL	(21  + SW_API_ACL_OFFSET)
#define SW_API_ACL_UDF_PROFILE_ENTRY_GETFIRST	(22  + SW_API_ACL_OFFSET)
#define SW_API_ACL_UDF_PROFILE_ENTRY_GETNEXT	(23  + SW_API_ACL_OFFSET)
#define SW_API_ACL_UDF_PROFILE_CFG_SET		(24  + SW_API_ACL_OFFSET)
#define SW_API_ACL_UDF_PROFILE_CFG_GET		(25  + SW_API_ACL_OFFSET)
#define SW_API_ACL_VPGROUP_SET			(26  + SW_API_ACL_OFFSET)
#define SW_API_ACL_VPGROUP_GET			(27  + SW_API_ACL_OFFSET)
#define SW_API_ACL_MAC_ENTRY_SET		(28  + SW_API_ACL_OFFSET)
#define SW_API_ACL_MAC_ENTRY_DUMP		(29  + SW_API_ACL_OFFSET)

    /*qos*/
#define SW_API_QOS_OFFSET             500
#define SW_API_QOS_SCH_MODE_SET       (0  + SW_API_QOS_OFFSET)
#define SW_API_QOS_SCH_MODE_GET       (1  + SW_API_QOS_OFFSET)
#define SW_API_QOS_QU_TX_BUF_ST_SET   (2  + SW_API_QOS_OFFSET)
#define SW_API_QOS_QU_TX_BUF_ST_GET   (3  + SW_API_QOS_OFFSET)
#define SW_API_QOS_QU_TX_BUF_NR_SET   (4  + SW_API_QOS_OFFSET)
#define SW_API_QOS_QU_TX_BUF_NR_GET   (5  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_TX_BUF_ST_SET   (6  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_TX_BUF_ST_GET   (7  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_TX_BUF_NR_SET   (8  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_TX_BUF_NR_GET   (9  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_RX_BUF_NR_SET   (10  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_RX_BUF_NR_GET   (11  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_MODE_SET        (12  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_MODE_GET        (13  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_MODE_PRI_SET    (14  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_MODE_PRI_GET    (15  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_DEF_UP_SET    (16  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_DEF_UP_GET    (17  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_SCH_MODE_SET  (18  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_SCH_MODE_GET  (19  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_DEF_SPRI_SET    (20  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_DEF_SPRI_GET    (21  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_DEF_CPRI_SET    (22  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_DEF_CPRI_GET    (23  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_FORCE_SPRI_ST_SET   (24  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_FORCE_SPRI_ST_GET   (25  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_FORCE_CPRI_ST_SET   (26  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_FORCE_CPRI_ST_GET   (27  + SW_API_QOS_OFFSET)
#define SW_API_QOS_QUEUE_REMARK_SET   (28  + SW_API_QOS_OFFSET)
#define SW_API_QOS_QUEUE_REMARK_GET   (29  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_RED_EN_SET   (30  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PT_RED_EN_GET   (31  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_GROUP_GET   (32  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_GROUP_SET   (33  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_PRI_GET   (34  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_PRI_SET   (35  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_REMARK_GET   (36  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_REMARK_SET   (37  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PCP_MAP_GET   (38  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PCP_MAP_SET   (39  + SW_API_QOS_OFFSET)
#define SW_API_QOS_FLOW_MAP_GET   (40  + SW_API_QOS_OFFSET)
#define SW_API_QOS_FLOW_MAP_SET   (41  + SW_API_QOS_OFFSET)
#define SW_API_QOS_DSCP_MAP_GET   (42  + SW_API_QOS_OFFSET)
#define SW_API_QOS_DSCP_MAP_SET   (43  + SW_API_QOS_OFFSET)
#define SW_API_QOS_QUEUE_SCHEDULER_GET   (44  + SW_API_QOS_OFFSET)
#define SW_API_QOS_QUEUE_SCHEDULER_SET   (45  + SW_API_QOS_OFFSET)
#define SW_API_QOS_RING_QUEUE_MAP_GET   (46  + SW_API_QOS_OFFSET)
#define SW_API_QOS_RING_QUEUE_MAP_SET   (47  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_QUEUES_GET	(48  + SW_API_QOS_OFFSET)
#define SW_API_QOS_SCHEDULER_DEQUEU_CTRL_GET (49  + SW_API_QOS_OFFSET)
#define SW_API_QOS_SCHEDULER_DEQUEU_CTRL_SET (50  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_SCHEDULER_CFG_RESET (51  + SW_API_QOS_OFFSET)
#define SW_API_QOS_PORT_SCHEDULER_RESOURCE_GET (52  + SW_API_QOS_OFFSET)


    /* igmp */
#define SW_API_IGMP_OFFSET            600
#define SW_API_PT_IGMPS_MODE_SET      (0  + SW_API_IGMP_OFFSET)
#define SW_API_PT_IGMPS_MODE_GET      (1 + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_MLD_CMD_SET       (2  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_MLD_CMD_GET       (3  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_PT_JOIN_SET       (4  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_PT_JOIN_GET       (5  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_PT_LEAVE_SET      (6  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_PT_LEAVE_GET      (7  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_RP_SET            (8  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_RP_GET            (9  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_CREAT_SET   (10  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_CREAT_GET   (11  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_STATIC_SET  (12  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_STATIC_GET  (13  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_LEAKY_SET   (14  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_LEAKY_GET   (15  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_V3_SET      (16  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_V3_GET      (17  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_QUEUE_SET   (18  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_ENTRY_QUEUE_GET   (19  + SW_API_IGMP_OFFSET)
#define SW_API_PT_IGMP_LEARN_LIMIT_SET (20  + SW_API_IGMP_OFFSET)
#define SW_API_PT_IGMP_LEARN_LIMIT_GET (21  + SW_API_IGMP_OFFSET)
#define SW_API_PT_IGMP_LEARN_EXCEED_CMD_SET (22  + SW_API_IGMP_OFFSET)
#define SW_API_PT_IGMP_LEARN_EXCEED_CMD_GET (23  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_SG_ENTRY_SET (24  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_SG_ENTRY_CLEAR (25  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_SG_ENTRY_SHOW (26  + SW_API_IGMP_OFFSET)
#define SW_API_IGMP_SG_ENTRY_QUERY (27  + SW_API_IGMP_OFFSET)

    /* leaky */
#define SW_API_LEAKY_OFFSET           700
#define SW_API_UC_LEAKY_MODE_SET      (0  + SW_API_LEAKY_OFFSET)
#define SW_API_UC_LEAKY_MODE_GET      (1  + SW_API_LEAKY_OFFSET)
#define SW_API_MC_LEAKY_MODE_SET      (2  + SW_API_LEAKY_OFFSET)
#define SW_API_MC_LEAKY_MODE_GET      (3  + SW_API_LEAKY_OFFSET)
#define SW_API_ARP_LEAKY_MODE_SET     (4  + SW_API_LEAKY_OFFSET)
#define SW_API_ARP_LEAKY_MODE_GET     (5  + SW_API_LEAKY_OFFSET)
#define SW_API_PT_UC_LEAKY_MODE_SET   (6  + SW_API_LEAKY_OFFSET)
#define SW_API_PT_UC_LEAKY_MODE_GET   (7  + SW_API_LEAKY_OFFSET)
#define SW_API_PT_MC_LEAKY_MODE_SET   (8  + SW_API_LEAKY_OFFSET)
#define SW_API_PT_MC_LEAKY_MODE_GET   (9  + SW_API_LEAKY_OFFSET)

    /*mirror*/
#define SW_API_MIR_OFFSET             800
#define SW_API_MIRROR_ANALY_PT_SET    (0  + SW_API_MIR_OFFSET)
#define SW_API_MIRROR_ANALY_PT_GET    (1  + SW_API_MIR_OFFSET)
#define SW_API_MIRROR_IN_PT_SET       (2  + SW_API_MIR_OFFSET)
#define SW_API_MIRROR_IN_PT_GET       (3  + SW_API_MIR_OFFSET)
#define SW_API_MIRROR_EG_PT_SET       (4  + SW_API_MIR_OFFSET)
#define SW_API_MIRROR_EG_PT_GET       (5  + SW_API_MIR_OFFSET)
#define SW_API_MIRROR_ANALYSIS_CONFIG_SET	(6  + SW_API_MIR_OFFSET)
#define SW_API_MIRROR_ANALYSIS_CONFIG_GET	(7  + SW_API_MIR_OFFSET)

    /*rate*/
#define SW_API_RATE_OFFSET            900
#define SW_API_RATE_QU_EGRL_SET       (0  + SW_API_RATE_OFFSET)
#define SW_API_RATE_QU_EGRL_GET       (1  + SW_API_RATE_OFFSET)
#define SW_API_RATE_PT_EGRL_SET       (2  + SW_API_RATE_OFFSET)
#define SW_API_RATE_PT_EGRL_GET       (3  + SW_API_RATE_OFFSET)
#define SW_API_RATE_PT_INRL_SET       (4  + SW_API_RATE_OFFSET)
#define SW_API_RATE_PT_INRL_GET       (5  + SW_API_RATE_OFFSET)
#define SW_API_STORM_CTRL_FRAME_SET   (6  + SW_API_RATE_OFFSET)
#define SW_API_STORM_CTRL_FRAME_GET   (7  + SW_API_RATE_OFFSET)
#define SW_API_STORM_CTRL_RATE_SET    (8  + SW_API_RATE_OFFSET)
#define SW_API_STORM_CTRL_RATE_GET    (9  + SW_API_RATE_OFFSET)
#define SW_API_RATE_PORT_POLICER_SET  (10  + SW_API_RATE_OFFSET)
#define SW_API_RATE_PORT_POLICER_GET  (11  + SW_API_RATE_OFFSET)
#define SW_API_RATE_PORT_SHAPER_SET   (12  + SW_API_RATE_OFFSET)
#define SW_API_RATE_PORT_SHAPER_GET   (13  + SW_API_RATE_OFFSET)
#define SW_API_RATE_QUEUE_SHAPER_SET  (14  + SW_API_RATE_OFFSET)
#define SW_API_RATE_QUEUE_SHAPER_GET  (15  + SW_API_RATE_OFFSET)
#define SW_API_RATE_ACL_POLICER_SET   (16  + SW_API_RATE_OFFSET)
#define SW_API_RATE_ACL_POLICER_GET   (17  + SW_API_RATE_OFFSET)
#define  SW_API_RATE_PT_ADDRATEBYTE_SET   (18  + SW_API_RATE_OFFSET)
#define  SW_API_RATE_PT_ADDRATEBYTE_GET   (19  + SW_API_RATE_OFFSET)
#define  SW_API_RATE_PT_GOL_FLOW_EN_SET   (20  + SW_API_RATE_OFFSET)
#define  SW_API_RATE_PT_GOL_FLOW_EN_GET   (21  + SW_API_RATE_OFFSET)

    /*stp*/
#define SW_API_STP_OFFSET             1000
#define SW_API_STP_PT_STATE_SET       (0  + SW_API_STP_OFFSET)
#define SW_API_STP_PT_STATE_GET       (1  + SW_API_STP_OFFSET)

    /*mib*/
#define SW_API_MIB_OFFSET             1100
#define SW_API_PT_MIB_GET             (0  + SW_API_MIB_OFFSET)
#define SW_API_MIB_STATUS_SET         (1  + SW_API_MIB_OFFSET)
#define SW_API_MIB_STATUS_GET         (2  + SW_API_MIB_OFFSET)
#define SW_API_PT_MIB_FLUSH_COUNTERS         (3+ SW_API_MIB_OFFSET)
#define SW_API_MIB_CPU_KEEP_SET         (4+ SW_API_MIB_OFFSET)
#define SW_API_MIB_CPU_KEEP_GET         (5+ SW_API_MIB_OFFSET)
#define SW_API_PT_XGMIB_GET			 (6+ SW_API_MIB_OFFSET)
#define SW_API_PT_MIB_COUNTER_GET     (7+ SW_API_MIB_OFFSET)

    /*misc*/
#define SW_API_MISC_OFFSET            1200
#define SW_API_ARP_STATUS_SET         (0  + SW_API_MISC_OFFSET)
#define SW_API_ARP_STATUS_GET         (1  + SW_API_MISC_OFFSET)
#define SW_API_FRAME_MAX_SIZE_SET     (2  + SW_API_MISC_OFFSET)
#define SW_API_FRAME_MAX_SIZE_GET     (3  + SW_API_MISC_OFFSET)
#define SW_API_PT_UNK_SA_CMD_SET      (4  + SW_API_MISC_OFFSET)
#define SW_API_PT_UNK_SA_CMD_GET      (5  + SW_API_MISC_OFFSET)
#define SW_API_PT_UNK_UC_FILTER_SET   (6  + SW_API_MISC_OFFSET)
#define SW_API_PT_UNK_UC_FILTER_GET   (7  + SW_API_MISC_OFFSET)
#define SW_API_PT_UNK_MC_FILTER_SET   (8  + SW_API_MISC_OFFSET)
#define SW_API_PT_UNK_MC_FILTER_GET   (9  + SW_API_MISC_OFFSET)
#define SW_API_PT_BC_FILTER_SET       (10  + SW_API_MISC_OFFSET)
#define SW_API_PT_BC_FILTER_GET       (11  + SW_API_MISC_OFFSET)
#define SW_API_CPU_PORT_STATUS_SET    (12  + SW_API_MISC_OFFSET)
#define SW_API_CPU_PORT_STATUS_GET    (13  + SW_API_MISC_OFFSET)
#define SW_API_BC_TO_CPU_PORT_SET     (14  + SW_API_MISC_OFFSET)
#define SW_API_BC_TO_CPU_PORT_GET     (15  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_CMD_SET          (16  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_CMD_GET          (17  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_STATUS_SET       (18  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_STATUS_GET       (19  + SW_API_MISC_OFFSET)
#define SW_API_PT_DHCP_SET            (20  + SW_API_MISC_OFFSET)
#define SW_API_PT_DHCP_GET            (21  + SW_API_MISC_OFFSET)
#define SW_API_ARP_CMD_SET            (22  + SW_API_MISC_OFFSET)
#define SW_API_ARP_CMD_GET            (23  + SW_API_MISC_OFFSET)
#define SW_API_EAPOL_CMD_SET          (24  + SW_API_MISC_OFFSET)
#define SW_API_EAPOL_CMD_GET          (25  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_SESSION_ADD      (26  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_SESSION_DEL      (27  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_SESSION_GET      (28  + SW_API_MISC_OFFSET)
#define SW_API_EAPOL_STATUS_SET       (29  + SW_API_MISC_OFFSET)
#define SW_API_EAPOL_STATUS_GET       (30  + SW_API_MISC_OFFSET)
#define SW_API_RIPV1_STATUS_SET       (31  + SW_API_MISC_OFFSET)
#define SW_API_RIPV1_STATUS_GET       (32  + SW_API_MISC_OFFSET)
#define SW_API_PT_ARP_REQ_STATUS_SET         (33  + SW_API_MISC_OFFSET)
#define SW_API_PT_ARP_REQ_STATUS_GET         (34  + SW_API_MISC_OFFSET)
#define SW_API_PT_ARP_ACK_STATUS_SET         (35  + SW_API_MISC_OFFSET)
#define SW_API_PT_ARP_ACK_STATUS_GET         (36  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_SESSION_TABLE_ADD      (37  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_SESSION_TABLE_DEL      (38  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_SESSION_TABLE_GET      (39  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_SESSION_ID_SET         (40  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_SESSION_ID_GET         (41  + SW_API_MISC_OFFSET)
#define SW_API_INTR_MASK_SET                (42  + SW_API_MISC_OFFSET)
#define SW_API_INTR_MASK_GET                (43  + SW_API_MISC_OFFSET)
#define SW_API_INTR_STATUS_GET              (44  + SW_API_MISC_OFFSET)
#define SW_API_INTR_STATUS_CLEAR            (45  + SW_API_MISC_OFFSET)
#define SW_API_INTR_PORT_LINK_MASK_SET      (46  + SW_API_MISC_OFFSET)
#define SW_API_INTR_PORT_LINK_MASK_GET      (47  + SW_API_MISC_OFFSET)
#define SW_API_INTR_PORT_LINK_STATUS_GET    (48  + SW_API_MISC_OFFSET)
#define SW_API_INTR_MASK_MAC_LINKCHG_SET      (49  + SW_API_MISC_OFFSET)
#define SW_API_INTR_MASK_MAC_LINKCHG_GET      (50  + SW_API_MISC_OFFSET)
#define SW_API_INTR_STATUS_MAC_LINKCHG_GET    (51  + SW_API_MISC_OFFSET)
#define SW_API_INTR_STATUS_MAC_LINKCHG_CLEAR    (52 + SW_API_MISC_OFFSET)
#define SW_API_CPU_VID_EN_SET      (53  + SW_API_MISC_OFFSET)
#define SW_API_CPU_VID_EN_GET    (54  + SW_API_MISC_OFFSET)
#define SW_API_RTD_PPPOE_EN_SET      (55  + SW_API_MISC_OFFSET)
#define SW_API_RTD_PPPOE_EN_GET    (56  + SW_API_MISC_OFFSET)
#define SW_API_GLOBAL_MACADDR_SET      (57  + SW_API_MISC_OFFSET)
#define SW_API_GLOBAL_MACADDR_GET    (58  + SW_API_MISC_OFFSET)
#define SW_API_LLDP_STATUS_SET          (59  + SW_API_MISC_OFFSET)
#define SW_API_LLDP_STATUS_GET          (60  + SW_API_MISC_OFFSET)
#define SW_API_FRAME_CRC_RESERVE_SET          (61  + SW_API_MISC_OFFSET)
#define SW_API_FRAME_CRC_RESERVE_GET          (62  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_EN_SET			(63  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_EN_GET			(64  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_L3_INTF_SET		(65  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_L3_INTF_GET		(66  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_GLOBAL_CTRL_SET		(67  + SW_API_MISC_OFFSET)
#define SW_API_PPPOE_GLOBAL_CTRL_GET		(68  + SW_API_MISC_OFFSET)

    /*led*/
#define SW_API_LED_OFFSET             1300
#define SW_API_LED_PATTERN_SET        (0  + SW_API_LED_OFFSET)
#define SW_API_LED_PATTERN_GET        (1  + SW_API_LED_OFFSET)

    /* cosmap */
#define SW_API_COSMAP_OFFSET              1400
#define SW_API_COSMAP_UP_QU_SET           (0  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_UP_QU_GET           (1  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_QU_SET         (2  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_QU_GET         (3  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_TO_PRI_SET     (4  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_TO_PRI_GET     (5  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_TO_DP_SET      (6  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_TO_DP_GET      (7  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_UP_TO_PRI_SET       (8  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_UP_TO_PRI_GET       (9  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_UP_TO_DP_SET        (10  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_UP_TO_DP_GET        (11  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_PRI_TO_QU_SET       (12  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_PRI_TO_QU_GET       (13  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_PRI_TO_EHQU_SET     (14  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_PRI_TO_EHQU_GET     (15  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_EG_REMARK_SET       (16  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_EG_REMARK_GET       (17  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_TO_EHPRI_SET     (18  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_TO_EHPRI_GET     (19  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_TO_EHDP_SET      (20  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_DSCP_TO_EHDP_GET      (21  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_UP_TO_EHPRI_SET       (22  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_UP_TO_EHPRI_GET       (23  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_UP_TO_EHDP_SET        (24  + SW_API_COSMAP_OFFSET)
#define SW_API_COSMAP_UP_TO_EHDP_GET        (25  + SW_API_COSMAP_OFFSET)

    /* sec */
#define SW_API_SEC_OFFSET             1500
#define SW_API_SEC_NORM_SET           (0  + SW_API_SEC_OFFSET)
#define SW_API_SEC_NORM_GET           (1  + SW_API_SEC_OFFSET)
#define SW_API_SEC_MAC_SET            (2  + SW_API_SEC_OFFSET)
#define SW_API_SEC_MAC_GET            (3  + SW_API_SEC_OFFSET)
#define SW_API_SEC_IP_SET             (4  + SW_API_SEC_OFFSET)
#define SW_API_SEC_IP_GET             (5  + SW_API_SEC_OFFSET)
#define SW_API_SEC_IP4_SET            (6  + SW_API_SEC_OFFSET)
#define SW_API_SEC_IP4_GET            (7  + SW_API_SEC_OFFSET)
#define SW_API_SEC_IP6_SET            (8  + SW_API_SEC_OFFSET)
#define SW_API_SEC_IP6_GET            (9  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TCP_SET            (10  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TCP_GET            (11  + SW_API_SEC_OFFSET)
#define SW_API_SEC_UDP_SET            (12  + SW_API_SEC_OFFSET)
#define SW_API_SEC_UDP_GET            (13  + SW_API_SEC_OFFSET)
#define SW_API_SEC_ICMP4_SET          (14  + SW_API_SEC_OFFSET)
#define SW_API_SEC_ICMP4_GET          (15  + SW_API_SEC_OFFSET)
#define SW_API_SEC_ICMP6_SET          (16  + SW_API_SEC_OFFSET)
#define SW_API_SEC_ICMP6_GET          (17  + SW_API_SEC_OFFSET)
#define SW_API_SEC_L3_PARSER_CTRL_GET          (18  + SW_API_SEC_OFFSET)
#define SW_API_SEC_L3_PARSER_CTRL_SET          (19  + SW_API_SEC_OFFSET)
#define SW_API_SEC_L4_PARSER_CTRL_GET          (20  + SW_API_SEC_OFFSET)
#define SW_API_SEC_L4_PARSER_CTRL_SET          (21  + SW_API_SEC_OFFSET)
#define SW_API_SEC_EXP_CTRL_GET          (22  + SW_API_SEC_OFFSET)
#define SW_API_SEC_EXP_CTRL_SET          (23  + SW_API_SEC_OFFSET)
#define SW_API_SEC_L2_EXP_CTRL_SET       (24  + SW_API_SEC_OFFSET)
#define SW_API_SEC_L2_EXP_CTRL_GET       (25  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TUNNEL_EXP_CTRL_SET   (26  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TUNNEL_EXP_CTRL_GET   (27  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TUNNEL_L3_PARSER_CTRL_SET   (28  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TUNNEL_L3_PARSER_CTRL_GET   (29  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TUNNEL_L4_PARSER_CTRL_SET   (30  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TUNNEL_L4_PARSER_CTRL_GET   (31  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_SET   (32  + SW_API_SEC_OFFSET)
#define SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_GET   (33  + SW_API_SEC_OFFSET)



    /* ip */
#define SW_API_IP_OFFSET             1600
#define SW_API_IP_HOST_ADD           (0  + SW_API_IP_OFFSET)
#define SW_API_IP_HOST_DEL           (1  + SW_API_IP_OFFSET)
#define SW_API_IP_HOST_GET           (2  + SW_API_IP_OFFSET)
#define SW_API_IP_HOST_NEXT          (3  + SW_API_IP_OFFSET)
#define SW_API_IP_HOST_COUNTER_BIND  (4  + SW_API_IP_OFFSET)
#define SW_API_IP_HOST_PPPOE_BIND    (5  + SW_API_IP_OFFSET)
#define SW_API_IP_PT_ARP_LEARN_SET   (6  + SW_API_IP_OFFSET)
#define SW_API_IP_PT_ARP_LEARN_GET   (7  + SW_API_IP_OFFSET)
#define SW_API_IP_ARP_LEARN_SET      (8  + SW_API_IP_OFFSET)
#define SW_API_IP_ARP_LEARN_GET      (9  + SW_API_IP_OFFSET)
#define SW_API_IP_SOURCE_GUARD_SET   (10  + SW_API_IP_OFFSET)
#define SW_API_IP_SOURCE_GUARD_GET   (11  + SW_API_IP_OFFSET)
#define SW_API_IP_ARP_GUARD_SET      (12  + SW_API_IP_OFFSET)
#define SW_API_IP_ARP_GUARD_GET      (13  + SW_API_IP_OFFSET)
#define SW_API_IP_ROUTE_STATUS_SET   (14  + SW_API_IP_OFFSET)
#define SW_API_IP_ROUTE_STATUS_GET   (15  + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_ENTRY_ADD       (16  + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_ENTRY_DEL       (17  + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_ENTRY_NEXT      (18  + SW_API_IP_OFFSET)
#define SW_API_IP_UNK_SOURCE_CMD_SET (19  + SW_API_IP_OFFSET)
#define SW_API_IP_UNK_SOURCE_CMD_GET (20  + SW_API_IP_OFFSET)
#define SW_API_ARP_UNK_SOURCE_CMD_SET (21  + SW_API_IP_OFFSET)
#define SW_API_ARP_UNK_SOURCE_CMD_GET (22  + SW_API_IP_OFFSET)
#define SW_API_IP_AGE_TIME_SET       (23  + SW_API_IP_OFFSET)
#define SW_API_IP_AGE_TIME_GET       (24  + SW_API_IP_OFFSET)
#define SW_API_WCMP_HASH_MODE_SET    (25  + SW_API_IP_OFFSET)
#define SW_API_WCMP_HASH_MODE_GET    (26  + SW_API_IP_OFFSET)
#define SW_API_IP_VRF_BASE_ADDR_SET    (27  + SW_API_IP_OFFSET)
#define SW_API_IP_VRF_BASE_ADDR_GET    (28  + SW_API_IP_OFFSET)
#define SW_API_IP_VRF_BASE_MASK_SET    (29  + SW_API_IP_OFFSET)
#define SW_API_IP_VRF_BASE_MASK_GET    (30  + SW_API_IP_OFFSET)
#define SW_API_IP_DEFAULT_ROUTE_SET    (31  + SW_API_IP_OFFSET)
#define SW_API_IP_DEFAULT_ROUTE_GET    (32  + SW_API_IP_OFFSET)
#define SW_API_IP_HOST_ROUTE_SET    (33  + SW_API_IP_OFFSET)
#define SW_API_IP_HOST_ROUTE_GET    (34  + SW_API_IP_OFFSET)
#define SW_API_IP_WCMP_ENTRY_SET    (35  + SW_API_IP_OFFSET)
#define SW_API_IP_WCMP_ENTRY_GET    (36  + SW_API_IP_OFFSET)
#define SW_API_IP_RFS_IP4_SET       (37  + SW_API_IP_OFFSET)
#define SW_API_IP_RFS_IP6_SET       (38  + SW_API_IP_OFFSET)
#define SW_API_IP_RFS_IP4_DEL       (39  + SW_API_IP_OFFSET)
#define SW_API_IP_RFS_IP6_DEL       (40  + SW_API_IP_OFFSET)
#define SW_API_IP_DEFAULT_FLOW_CMD_SET    (41  + SW_API_IP_OFFSET)
#define SW_API_IP_DEFAULT_FLOW_CMD_GET    (42  + SW_API_IP_OFFSET)
#define SW_API_IP_DEFAULT_RT_FLOW_CMD_SET    (43  + SW_API_IP_OFFSET)
#define SW_API_IP_DEFAULT_RT_FLOW_CMD_GET    (44  + SW_API_IP_OFFSET)
#define SW_API_IP_VIS_ARP_SG_CFG_GET    (45  + SW_API_IP_OFFSET)
#define SW_API_IP_VIS_ARP_SG_CFG_SET    (46  + SW_API_IP_OFFSET)
#define SW_API_IP_NETWORK_ROUTE_GET    (47  + SW_API_IP_OFFSET)
#define SW_API_IP_NETWORK_ROUTE_ADD    (48  + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_GET    (49  + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_SET    (50  + SW_API_IP_OFFSET)
#define SW_API_IP_VSI_INTF_GET    (51  + SW_API_IP_OFFSET)
#define SW_API_IP_VSI_INTF_SET    (52  + SW_API_IP_OFFSET)
#define SW_API_IP_NEXTHOP_GET    (53  + SW_API_IP_OFFSET)
#define SW_API_IP_NEXTHOP_SET    (54  + SW_API_IP_OFFSET)
#define SW_API_IP_VSI_SG_SET    (55  + SW_API_IP_OFFSET)
#define SW_API_IP_VSI_SG_GET    (56  + SW_API_IP_OFFSET)
#define SW_API_IP_PORT_SG_SET    (57  + SW_API_IP_OFFSET)
#define SW_API_IP_PORT_SG_GET    (58  + SW_API_IP_OFFSET)
#define SW_API_IP_PUB_IP_SET    (59  + SW_API_IP_OFFSET)
#define SW_API_IP_PUB_IP_GET    (60  + SW_API_IP_OFFSET)
#define SW_API_IP_NETWORK_ROUTE_DEL    (61  + SW_API_IP_OFFSET)
#define SW_API_IP_PORT_INTF_GET    (62  + SW_API_IP_OFFSET)
#define SW_API_IP_PORT_INTF_SET    (63  + SW_API_IP_OFFSET)
#define SW_API_IP_PORT_MAC_GET    (64  + SW_API_IP_OFFSET)
#define SW_API_IP_PORT_MAC_SET    (65  + SW_API_IP_OFFSET)
#define SW_API_IP_ROUTE_MISS_GET    (66  + SW_API_IP_OFFSET)
#define SW_API_IP_ROUTE_MISS_SET    (67  + SW_API_IP_OFFSET)
#define SW_API_IP_PORT_ARP_SG_GET    (68  + SW_API_IP_OFFSET)
#define SW_API_IP_PORT_ARP_SG_SET    (69  + SW_API_IP_OFFSET)
#define SW_API_IP_VSI_MC_MODE_GET    (70  + SW_API_IP_OFFSET)
#define SW_API_IP_VSI_MC_MODE_SET    (71  + SW_API_IP_OFFSET)
#define SW_API_GLOBAL_CTRL_GET    (72  + SW_API_IP_OFFSET)
#define SW_API_GLOBAL_CTRL_SET    (73  + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_MTU_MRU_SET	(74 + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_MTU_MRU_GET	(75 + SW_API_IP_OFFSET)
#define SW_API_IP6_INTF_MTU_MRU_SET	(76 + SW_API_IP_OFFSET)
#define SW_API_IP6_INTF_MTU_MRU_GET	(77 + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_MACADDR_ADD	(78 + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_MACADDR_DEL	(79 + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_MACADDR_GET_FIRST	(80 + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_MACADDR_GET_NEXT		(81 + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_DMAC_CHECK_SET		(82 + SW_API_IP_OFFSET)
#define SW_API_IP_INTF_DMAC_CHECK_GET		(83 + SW_API_IP_OFFSET)

    /* nat */
#define SW_API_NAT_OFFSET            1700
#define SW_API_NAT_ADD               (0  + SW_API_NAT_OFFSET)
#define SW_API_NAT_DEL               (1  + SW_API_NAT_OFFSET)
#define SW_API_NAT_GET               (2  + SW_API_NAT_OFFSET)
#define SW_API_NAT_NEXT              (3  + SW_API_NAT_OFFSET)
#define SW_API_NAT_COUNTER_BIND      (4  + SW_API_NAT_OFFSET)
#define SW_API_NAPT_ADD              (5  + SW_API_NAT_OFFSET)
#define SW_API_NAPT_DEL              (6  + SW_API_NAT_OFFSET)
#define SW_API_NAPT_GET              (7  + SW_API_NAT_OFFSET)
#define SW_API_NAPT_NEXT             (8  + SW_API_NAT_OFFSET)
#define SW_API_NAPT_COUNTER_BIND     (9  + SW_API_NAT_OFFSET)
#define SW_API_NAT_STATUS_SET        (10  + SW_API_NAT_OFFSET)
#define SW_API_NAT_STATUS_GET        (11  + SW_API_NAT_OFFSET)
#define SW_API_NAT_HASH_MODE_SET     (12  + SW_API_NAT_OFFSET)
#define SW_API_NAT_HASH_MODE_GET     (13  + SW_API_NAT_OFFSET)
#define SW_API_NAPT_STATUS_SET       (14  + SW_API_NAT_OFFSET)
#define SW_API_NAPT_STATUS_GET       (15  + SW_API_NAT_OFFSET)
#define SW_API_NAPT_MODE_SET         (16  + SW_API_NAT_OFFSET)
#define SW_API_NAPT_MODE_GET         (17  + SW_API_NAT_OFFSET)
#define SW_API_PRV_BASE_ADDR_SET     (18  + SW_API_NAT_OFFSET)
#define SW_API_PRV_BASE_ADDR_GET     (19  + SW_API_NAT_OFFSET)
#define SW_API_PRV_ADDR_MODE_SET     (20  + SW_API_NAT_OFFSET)
#define SW_API_PRV_ADDR_MODE_GET     (21  + SW_API_NAT_OFFSET)
#define SW_API_PUB_ADDR_ENTRY_ADD    (22  + SW_API_NAT_OFFSET)
#define SW_API_PUB_ADDR_ENTRY_DEL    (23  + SW_API_NAT_OFFSET)
#define SW_API_PUB_ADDR_ENTRY_NEXT   (24  + SW_API_NAT_OFFSET)
#define SW_API_NAT_UNK_SESSION_CMD_SET (25  + SW_API_NAT_OFFSET)
#define SW_API_NAT_UNK_SESSION_CMD_GET (26  + SW_API_NAT_OFFSET)
#define SW_API_PRV_BASE_MASK_SET       (27  + SW_API_NAT_OFFSET)
#define SW_API_PRV_BASE_MASK_GET       (28  + SW_API_NAT_OFFSET)
#define SW_API_NAT_GLOBAL_SET          (29  + SW_API_NAT_OFFSET)
#define SW_API_FLOW_ADD              (30  + SW_API_NAT_OFFSET)
#define SW_API_FLOW_DEL              (31  + SW_API_NAT_OFFSET)
#define SW_API_FLOW_GET              (32  + SW_API_NAT_OFFSET)
#define SW_API_FLOW_NEXT             (33  + SW_API_NAT_OFFSET)
#define SW_API_FLOW_COUNTER_BIND     (34  + SW_API_NAT_OFFSET)
#define SW_API_FLOW_COOKIE_SET       (35  + SW_API_NAT_OFFSET)
#define SW_API_FLOW_RFS_SET          (36  + SW_API_NAT_OFFSET)


    /* trunk */
#define SW_API_TRUNK_OFFSET            1800
#define SW_API_TRUNK_GROUP_SET         (0  + SW_API_TRUNK_OFFSET)
#define SW_API_TRUNK_GROUP_GET         (1  + SW_API_TRUNK_OFFSET)
#define SW_API_TRUNK_HASH_SET          (2  + SW_API_TRUNK_OFFSET)
#define SW_API_TRUNK_HASH_GET          (3  + SW_API_TRUNK_OFFSET)
#define SW_API_TRUNK_MAN_SA_SET        (4  + SW_API_TRUNK_OFFSET)
#define SW_API_TRUNK_MAN_SA_GET        (5  + SW_API_TRUNK_OFFSET)
#define SW_API_TRUNK_FAILOVER_EN_SET        (6  + SW_API_TRUNK_OFFSET)
#define SW_API_TRUNK_FAILOVER_EN_GET        (7  + SW_API_TRUNK_OFFSET)

    /* Interface Control */
#define SW_API_INTERFACE_OFFSET        1900
#define SW_API_MAC_MODE_SET            (0  + SW_API_INTERFACE_OFFSET)
#define SW_API_MAC_MODE_GET            (1  + SW_API_INTERFACE_OFFSET)
#define SW_API_PORT_3AZ_STATUS_SET     (2  + SW_API_INTERFACE_OFFSET)
#define SW_API_PORT_3AZ_STATUS_GET     (3  + SW_API_INTERFACE_OFFSET)
#define SW_API_PHY_MODE_SET            (4  + SW_API_INTERFACE_OFFSET)
#define SW_API_PHY_MODE_GET            (5  + SW_API_INTERFACE_OFFSET)
#define SW_API_FX100_CTRL_SET          (6  + SW_API_INTERFACE_OFFSET)
#define SW_API_FX100_CTRL_GET          (7  + SW_API_INTERFACE_OFFSET)
#define SW_API_FX100_STATUS_GET        (8  + SW_API_INTERFACE_OFFSET)
#define SW_API_MAC06_EXCH_SET          (9  + SW_API_INTERFACE_OFFSET)
#define SW_API_MAC06_EXCH_GET          (10  + SW_API_INTERFACE_OFFSET)

    /* VSI */
#define SW_API_VSI_OFFSET        2000
#define SW_API_VSI_ALLOC               (0  + SW_API_VSI_OFFSET)
#define SW_API_VSI_FREE                (1  + SW_API_VSI_OFFSET)
#define SW_API_PORT_VSI_SET            (2  + SW_API_VSI_OFFSET)
#define SW_API_PORT_VSI_GET            (3  + SW_API_VSI_OFFSET)
#define SW_API_PORT_VLAN_VSI_SET       (4  + SW_API_VSI_OFFSET)
#define SW_API_PORT_VLAN_VSI_GET       (5  + SW_API_VSI_OFFSET)
#define SW_API_VSI_TBL_DUMP	       (6  + SW_API_VSI_OFFSET)
#define SW_API_VSI_NEWADDR_LRN_SET     (7  + SW_API_VSI_OFFSET)
#define SW_API_VSI_NEWADDR_LRN_GET     (8  + SW_API_VSI_OFFSET)
#define SW_API_VSI_STAMOVE_SET	       (9  + SW_API_VSI_OFFSET)
#define SW_API_VSI_STAMOVE_GET	       (10 + SW_API_VSI_OFFSET)
#define SW_API_VSI_MEMBER_SET	       (11 + SW_API_VSI_OFFSET)
#define SW_API_VSI_MEMBER_GET	       (12 + SW_API_VSI_OFFSET)
#define SW_API_VSI_COUNTER_GET	       (13 + SW_API_VSI_OFFSET)
#define SW_API_VSI_COUNTER_CLEANUP	   (14 + SW_API_VSI_OFFSET)
#define SW_API_VSI_BRIDGE_VSI_GET	   (15 + SW_API_VSI_OFFSET)
#define SW_API_VSI_BRIDGE_VSI_SET	   (16 + SW_API_VSI_OFFSET)
#define SW_API_VSI_INVALIDVSI_CTRL_GET	   (17 + SW_API_VSI_OFFSET)
#define SW_API_VSI_INVALIDVSI_CTRL_SET	   (18 + SW_API_VSI_OFFSET)

 /* qm */
#define SW_API_QM_OFFSET            2100
#define SW_API_UCAST_QUEUE_BASE_PROFILE_SET         (0  + SW_API_QM_OFFSET)
#define SW_API_UCAST_QUEUE_BASE_PROFILE_GET         (1  + SW_API_QM_OFFSET)
#define SW_API_UCAST_PRIORITY_CLASS_SET         (2  + SW_API_QM_OFFSET)
#define SW_API_UCAST_PRIORITY_CLASS_GET         (3  + SW_API_QM_OFFSET)
#define SW_API_MCAST_PRIORITY_CLASS_SET         (4  + SW_API_QM_OFFSET)
#define SW_API_MCAST_PRIORITY_CLASS_GET         (5  + SW_API_QM_OFFSET)
#define SW_API_UCAST_HASH_MAP_SET         (6  + SW_API_QM_OFFSET)
#define SW_API_UCAST_HASH_MAP_GET         (7 + SW_API_QM_OFFSET)
#define SW_API_UCAST_DFLT_HASH_MAP_SET         (8  + SW_API_QM_OFFSET)
#define SW_API_UCAST_DFLT_HASH_MAP_GET         (9 + SW_API_QM_OFFSET)
#define SW_API_MCAST_CPUCODE_CLASS_SET         (10  + SW_API_QM_OFFSET)
#define SW_API_MCAST_CPUCODE_CLASS_GET         (11  + SW_API_QM_OFFSET)
#define SW_API_QUEUE_FLUSH         (12  + SW_API_QM_OFFSET)
#define SW_API_AC_CTRL_SET         (13  + SW_API_QM_OFFSET)
#define SW_API_AC_CTRL_GET         (14  + SW_API_QM_OFFSET)
#define SW_API_AC_PRE_BUFFER_SET         (15  + SW_API_QM_OFFSET)
#define SW_API_AC_PRE_BUFFER_GET         (16  + SW_API_QM_OFFSET)
#define SW_API_QUEUE_GROUP_SET         (17  + SW_API_QM_OFFSET)
#define SW_API_QUEUE_GROUP_GET         (18 + SW_API_QM_OFFSET)
#define SW_API_STATIC_THRESH_SET         (19  + SW_API_QM_OFFSET)
#define SW_API_STATIC_THRESH_GET         (20 + SW_API_QM_OFFSET)
#define SW_API_DYNAMIC_THRESH_SET         (21  + SW_API_QM_OFFSET)
#define SW_API_DYNAMIC_THRESH_GET         (22 + SW_API_QM_OFFSET)
#define SW_API_GOURP_BUFFER_SET         (23  + SW_API_QM_OFFSET)
#define SW_API_GOURP_BUFFER_GET         (24 + SW_API_QM_OFFSET)
#define SW_API_QUEUE_CNT_CTRL_GET         (25 + SW_API_QM_OFFSET)
#define SW_API_QUEUE_CNT_CTRL_SET         (26 + SW_API_QM_OFFSET)
#define SW_API_QUEUE_CNT_GET         (27 + SW_API_QM_OFFSET)
#define SW_API_QUEUE_CNT_CLEANUP         (28 + SW_API_QM_OFFSET)
#define SW_API_QM_ENQUEUE_CTRL_SET         (29 + SW_API_QM_OFFSET)
#define SW_API_QM_ENQUEUE_CTRL_GET         (30 + SW_API_QM_OFFSET)
#define SW_API_QM_SOURCE_PROFILE_SET         (31 + SW_API_QM_OFFSET)
#define SW_API_QM_SOURCE_PROFILE_GET         (32 + SW_API_QM_OFFSET)
#define SW_API_QM_ENQUEUE_CFG_GET		(33 + SW_API_QM_OFFSET)
#define SW_API_QM_ENQUEUE_CFG_SET		(34 + SW_API_QM_OFFSET)

/* flow */
#define SW_API_FLOW_OFFSET            2200
#define SW_API_FLOW_STATUS_SET         (0  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_STATUS_GET         (1  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_AGE_TIMER_SET         (2  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_AGE_TIMER_GET         (3  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_CTRL_SET         (4  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_CTRL_GET         (5  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_ENTRY_ADD         (6  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_ENTRY_DEL         (7  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_ENTRY_GET         (8  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_GLOBAL_CFG_GET         (9  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_GLOBAL_CFG_SET         (10  + SW_API_FLOW_OFFSET)
#define SW_API_FLOWENTRY_NEXT         (11  + SW_API_FLOW_OFFSET)

#define SW_API_FLOW_HOST_ADD         (20  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_HOST_DEL         (21  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_HOST_GET         (22  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_COUNTER_GET		(23  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_COUNTER_CLEANUP	(24  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_ENTRY_EN_SET	(25  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_ENTRY_EN_GET	(26  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_QOS_SET		(27  + SW_API_FLOW_OFFSET)
#define SW_API_FLOW_QOS_GET		(28  + SW_API_FLOW_OFFSET)

/* rss hash */
#define SW_API_RSS_HASH_OFFSET		2400
#define SW_API_RSS_HASH_CONFIG_SET	(0 + SW_API_RSS_HASH_OFFSET)
#define SW_API_RSS_HASH_CONFIG_GET	(1 + SW_API_RSS_HASH_OFFSET)

/* bm */
#define SW_API_BM_OFFSET            3000
#define SW_API_BM_CTRL_SET         (0  + SW_API_BM_OFFSET)
#define SW_API_BM_CTRL_GET         (1  + SW_API_BM_OFFSET)
#define SW_API_BM_PORTGROUP_MAP_SET         (2  + SW_API_BM_OFFSET)
#define SW_API_BM_PORTGROUP_MAP_GET         (3  + SW_API_BM_OFFSET)
#define SW_API_BM_GROUP_BUFFER_SET         (4  + SW_API_BM_OFFSET)
#define SW_API_BM_GROUP_BUFFER_GET         (5  + SW_API_BM_OFFSET)
#define SW_API_BM_PORT_RSVBUFFER_SET         (6  + SW_API_BM_OFFSET)
#define SW_API_BM_PORT_RSVBUFFER_GET         (7  + SW_API_BM_OFFSET)
#define SW_API_BM_STATIC_THRESH_SET         (8  + SW_API_BM_OFFSET)
#define SW_API_BM_STATIC_THRESH_GET         (9  + SW_API_BM_OFFSET)
#define SW_API_BM_DYNAMIC_THRESH_SET         (10  + SW_API_BM_OFFSET)
#define SW_API_BM_DYNAMIC_THRESH_GET         (11  + SW_API_BM_OFFSET)
#define SW_API_BM_PORT_COUNTER_GET         (12  + SW_API_BM_OFFSET)

/* ptp */
#define SW_API_PTP_OFFSET                         3100
#define SW_API_PTP_CONFIG_SET                     (0  + SW_API_PTP_OFFSET)
#define SW_API_PTP_CONFIG_GET                     (1  + SW_API_PTP_OFFSET)
#define SW_API_PTP_REFERENCE_CLOCK_SET            (2  + SW_API_PTP_OFFSET)
#define SW_API_PTP_REFERENCE_CLOCK_GET            (3  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RX_TIMESTAMP_MODE_SET          (4  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RX_TIMESTAMP_MODE_GET          (5  + SW_API_PTP_OFFSET)
#define SW_API_PTP_TIMESTAMP_GET                  (6  + SW_API_PTP_OFFSET)
#define SW_API_PTP_PKT_TIMESTAMP_SET              (7  + SW_API_PTP_OFFSET)
#define SW_API_PTP_PKT_TIMESTAMP_GET              (8  + SW_API_PTP_OFFSET)
#define SW_API_PTP_GRANDMASTER_MODE_SET           (9  + SW_API_PTP_OFFSET)
#define SW_API_PTP_GRANDMASTER_MODE_GET           (10  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_TIME_SET                   (11  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_TIME_GET                   (12  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_TIME_CLEAR                 (13  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_ADJTIME_SET                (14  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_ADJFREQ_SET                (15  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_ADJFREQ_GET                (16  + SW_API_PTP_OFFSET)
#define SW_API_PTP_LINK_DELAY_SET                 (17  + SW_API_PTP_OFFSET)
#define SW_API_PTP_LINK_DELAY_GET                 (18  + SW_API_PTP_OFFSET)
#define SW_API_PTP_SECURITY_SET                   (19  + SW_API_PTP_OFFSET)
#define SW_API_PTP_SECURITY_GET                   (20  + SW_API_PTP_OFFSET)
#define SW_API_PTP_PPS_SIGNAL_CONTROL_SET         (21  + SW_API_PTP_OFFSET)
#define SW_API_PTP_PPS_SIGNAL_CONTROL_GET         (22  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RX_CRC_RECALC_SET              (23  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RX_CRC_RECALC_GET              (24  + SW_API_PTP_OFFSET)
#define SW_API_PTP_ASYM_CORRECTION_SET            (25  + SW_API_PTP_OFFSET)
#define SW_API_PTP_ASYM_CORRECTION_GET            (26  + SW_API_PTP_OFFSET)
#define SW_API_PTP_OUTPUT_WAVEFORM_SET            (27  + SW_API_PTP_OFFSET)
#define SW_API_PTP_OUTPUT_WAVEFORM_GET            (28  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_TIME_SNAPSHOT_SET          (29  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_TIME_SNAPSHOT_GET          (30  + SW_API_PTP_OFFSET)
#define SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_SET  (31  + SW_API_PTP_OFFSET)
#define SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_GET  (32  + SW_API_PTP_OFFSET)
#define SW_API_PTP_TOD_UART_SET                   (33  + SW_API_PTP_OFFSET)
#define SW_API_PTP_TOD_UART_GET                   (34  + SW_API_PTP_OFFSET)
#define SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_SET  (35  + SW_API_PTP_OFFSET)
#define SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_GET  (36  + SW_API_PTP_OFFSET)
#define SW_API_PTP_TRIGGER_SET                    (37  + SW_API_PTP_OFFSET)
#define SW_API_PTP_TRIGGER_GET                    (38  + SW_API_PTP_OFFSET)
#define SW_API_PTP_CAPTURE_SET                    (39  + SW_API_PTP_OFFSET)
#define SW_API_PTP_CAPTURE_GET                    (40  + SW_API_PTP_OFFSET)
#define SW_API_PTP_INTERRUPT_SET                  (41  + SW_API_PTP_OFFSET)
#define SW_API_PTP_INTERRUPT_GET                  (42  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_SYNC_SET                   (43  + SW_API_PTP_OFFSET)
#define SW_API_PTP_RTC_SYNC_GET                   (44  + SW_API_PTP_OFFSET)

/* sfp */
#define SW_API_SFP_OFFSET                         3200
#define SW_API_SFP_DATA_GET                       (0  + SW_API_SFP_OFFSET)
#define SW_API_SFP_DATA_SET                       (1  + SW_API_SFP_OFFSET)
#define SW_API_SFP_DEV_TYPE_GET                   (2  + SW_API_SFP_OFFSET)
#define SW_API_SFP_TRANSC_CODE_GET                (3  + SW_API_SFP_OFFSET)
#define SW_API_SFP_RATE_ENCODE_GET                (4  + SW_API_SFP_OFFSET)
#define SW_API_SFP_LINK_LENGTH_GET                (5  + SW_API_SFP_OFFSET)
#define SW_API_SFP_VENDOR_INFO_GET                (6  + SW_API_SFP_OFFSET)
#define SW_API_SFP_LASER_WAVELENGTH_GET           (7  + SW_API_SFP_OFFSET)
#define SW_API_SFP_OPTION_GET                     (8  + SW_API_SFP_OFFSET)
#define SW_API_SFP_CTRL_RATE_GET                  (9  + SW_API_SFP_OFFSET)
#define SW_API_SFP_ENHANCED_CFG_GET               (10  + SW_API_SFP_OFFSET)
#define SW_API_SFP_DIAG_THRESHOLD_GET             (11  + SW_API_SFP_OFFSET)
#define SW_API_SFP_DIAG_CAL_CONST_GET             (12  + SW_API_SFP_OFFSET)
#define SW_API_SFP_DIAG_REALTIME_GET              (13  + SW_API_SFP_OFFSET)
#define SW_API_SFP_DIAG_CTRL_STATUS_GET           (14  + SW_API_SFP_OFFSET)
#define SW_API_SFP_DIAG_ALARM_WARN_FLAG_GET       (15  + SW_API_SFP_OFFSET)
#define SW_API_SFP_CHECKCODE_GET                  (16  + SW_API_SFP_OFFSET)

/* vport */
#define SW_API_VPORT_OFFSET			3300
#define SW_API_VPORT_PHYSICAL_PORT_SET		(0 + SW_API_VPORT_OFFSET)
#define SW_API_VPORT_PHYSICAL_PORT_GET		(1 + SW_API_VPORT_OFFSET)
#define SW_API_VPORT_STATE_CHECK_SET		(2  + SW_API_VPORT_OFFSET)
#define SW_API_VPORT_STATE_CHECK_GET		(3  + SW_API_VPORT_OFFSET)

/* tunnel */
#define SW_API_TUNNEL_OFFSET			3400
#define SW_API_TUNNEL_GLOBAL_CFG_SET		(0 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_GLOBAL_CFG_GET		(1 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_PORT_INTF_SET		(2 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_PORT_INTF_GET		(3 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_INTF_SET			(4 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_INTF_GET			(5 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_VLAN_INTF_ADD		(6 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_VLAN_INTF_GETFIRST	(7 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_VLAN_INTF_GETNEXT		(8 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_VLAN_INTF_DEL		(9 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_RULE_ENTRY_SET	(10 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_RULE_ENTRY_GET	(11 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_RULE_ENTRY_DEL	(12 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_INTF_TUNNELID_SET	(13 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_INTF_TUNNELID_GET	(14 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_PORT_TUNNELID_SET	(15 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_PORT_TUNNELID_GET	(16 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_ENTRY_ADD		(17 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_ENTRY_GET		(18 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_ENTRY_GETNEXT	(19 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_ENTRY_DEL		(20 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_ENTRY_FLUSH		(21 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_ENTRY_ADD		(22 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_ENTRY_GET		(23 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_ENTRY_GETNEXT	(24 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_ENTRY_DEL		(25 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_HEADER_CTRL_SET	(26 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_HEADER_CTRL_GET	(27 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_ECN_MODE_SET	(28 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_ENCAP_ECN_MODE_GET	(29 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_ECN_MODE_SET	(30 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_ECN_MODE_GET	(31 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_UDF_PROFILE_ENTRY_ADD	(32  + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_UDF_PROFILE_ENTRY_DEL	(33  + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETFIRST	(34  + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETNEXT		(35  + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_UDF_PROFILE_CFG_SET		(36  + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_UDF_PROFILE_CFG_GET		(37  + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_EXP_DECAP_SET	(38 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_EXP_DECAP_GET	(39 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_KEY_SET	(40 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_KEY_GET	(41 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_EN_SET	(42 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_EN_GET	(43 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_ACTION_UPDATE	(44 + SW_API_TUNNEL_OFFSET)
#define SW_API_TUNNEL_DECAP_COUNTER_GET		(45 + SW_API_TUNNEL_OFFSET)

/* VXLAN */
#define SW_API_VXLAN_OFFSET                       3500
#define SW_API_VXLAN_ENTRY_ADD                    (0 + SW_API_VXLAN_OFFSET)
#define SW_API_VXLAN_ENTRY_DEL                    (1 + SW_API_VXLAN_OFFSET)
#define SW_API_VXLAN_ENTRY_GETFIRST               (2 + SW_API_VXLAN_OFFSET)
#define SW_API_VXLAN_ENTRY_GETNEXT                (3 + SW_API_VXLAN_OFFSET)
#define SW_API_VXLAN_GPE_PROTO_CFG_SET            (4 + SW_API_VXLAN_OFFSET)
#define SW_API_VXLAN_GPE_PROTO_CFG_GET            (5 + SW_API_VXLAN_OFFSET)


/* GENEVE */
#define SW_API_GENEVE_OFFSET                       3600
#define SW_API_GENEVE_ENTRY_ADD                    (0 + SW_API_GENEVE_OFFSET)
#define SW_API_GENEVE_ENTRY_DEL                    (1 + SW_API_GENEVE_OFFSET)
#define SW_API_GENEVE_ENTRY_GETFIRST               (2 + SW_API_GENEVE_OFFSET)
#define SW_API_GENEVE_ENTRY_GETNEXT                (3 + SW_API_GENEVE_OFFSET)

/* TUNNEL PROGRAM */
#define SW_API_TUNNEL_PROGRAM_OFFSET              3700
#define SW_API_TUNNEL_PROGRAM_ENTRY_ADD           (0 + SW_API_TUNNEL_PROGRAM_OFFSET)
#define SW_API_TUNNEL_PROGRAM_ENTRY_DEL           (1 + SW_API_TUNNEL_PROGRAM_OFFSET)
#define SW_API_TUNNEL_PROGRAM_ENTRY_GETFIRST      (2 + SW_API_TUNNEL_PROGRAM_OFFSET)
#define SW_API_TUNNEL_PROGRAM_ENTRY_GETNEXT       (3 + SW_API_TUNNEL_PROGRAM_OFFSET)
#define SW_API_TUNNEL_PROGRAM_CFG_SET             (4 + SW_API_TUNNEL_PROGRAM_OFFSET)
#define SW_API_TUNNEL_PROGRAM_CFG_GET             (5 + SW_API_TUNNEL_PROGRAM_OFFSET)
#define SW_API_TUNNEL_PROGRAM_UDF_ADD             (6 + SW_API_TUNNEL_PROGRAM_OFFSET)
#define SW_API_TUNNEL_PROGRAM_UDF_DEL             (7 + SW_API_TUNNEL_PROGRAM_OFFSET)
#define SW_API_TUNNEL_PROGRAM_UDF_GETFIRST        (8 + SW_API_TUNNEL_PROGRAM_OFFSET)
#define SW_API_TUNNEL_PROGRAM_UDF_GETNEXT         (9 + SW_API_TUNNEL_PROGRAM_OFFSET)

/* mapt */
#define SW_API_MAPT_OFFSET			3800
#define SW_API_MAPT_DECAP_CTRL_SET		(0 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_CTRL_GET		(1 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_RULE_ENTRY_SET	(2 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_RULE_ENTRY_GET	(3 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_RULE_ENTRY_DEL	(4 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_ENTRY_ADD		(5 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_ENTRY_DEL		(6 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_ENTRY_GETFIRST	(7 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_ENTRY_GETNEXT		(8 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_EN_SET		(9 + SW_API_MAPT_OFFSET)
#define SW_API_MAPT_DECAP_EN_GET		(10 + SW_API_MAPT_OFFSET)

/* athtag */
#define SW_API_ATHTAG_OFFSET			3900
#define SW_API_ATHTAG_PRI_MAPPING_SET		(0 + SW_API_ATHTAG_OFFSET)
#define SW_API_ATHTAG_PRI_MAPPING_GET		(1 + SW_API_ATHTAG_OFFSET)
#define SW_API_ATHTAG_PORT_MAPPING_SET		(2 + SW_API_ATHTAG_OFFSET)
#define SW_API_ATHTAG_PORT_MAPPING_GET		(3 + SW_API_ATHTAG_OFFSET)
#define SW_API_PORT_ATHTAG_RX_SET		(4 + SW_API_ATHTAG_OFFSET)
#define SW_API_PORT_ATHTAG_RX_GET		(5 + SW_API_ATHTAG_OFFSET)
#define SW_API_PORT_ATHTAG_TX_SET		(6 + SW_API_ATHTAG_OFFSET)
#define SW_API_PORT_ATHTAG_TX_GET		(7 + SW_API_ATHTAG_OFFSET)

/* auto_insert_flag */

/*qca808x_start*/
    /*debug*/
#define SW_API_DEBUG_OFFSET        10000
#define SW_API_PHY_GET             (0  + SW_API_DEBUG_OFFSET)
#define SW_API_PHY_SET             (1  + SW_API_DEBUG_OFFSET)
/*qca808x_end*/
#define SW_API_REG_GET             (2  + SW_API_DEBUG_OFFSET)
#define SW_API_REG_SET             (3  + SW_API_DEBUG_OFFSET)
#define SW_API_REG_ENTRY_GET       (4  + SW_API_DEBUG_OFFSET)
#define SW_API_REG_ENTRY_SET       (5  + SW_API_DEBUG_OFFSET)
#define SW_API_REG_FIELD_GET       (6  + SW_API_DEBUG_OFFSET)
#define SW_API_REG_FIELD_SET       (7  + SW_API_DEBUG_OFFSET)
#define SW_API_PSGMII_REG_GET             (8  + SW_API_DEBUG_OFFSET)
#define SW_API_PSGMII_REG_SET             (9  + SW_API_DEBUG_OFFSET)
#define SW_API_REG_DUMP          			(10  + SW_API_DEBUG_OFFSET)
#define SW_API_DBG_REG_DUMP          		(11  + SW_API_DEBUG_OFFSET)
#define SW_API_DBG_PSGMII_SELF_TEST          		(12  + SW_API_DEBUG_OFFSET)
#define SW_API_PHY_DUMP             (13  + SW_API_DEBUG_OFFSET)
#define SW_API_UNIPHY_REG_GET             (20  + SW_API_DEBUG_OFFSET)
#define SW_API_UNIPHY_REG_SET             (21  + SW_API_DEBUG_OFFSET)
    /* Ctrlpkt Control */
#define SW_API_CTRLPKT_OFFSET        2500
#define SW_API_MGMTCTRL_ETHTYPE_PROFILE_SET (0  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_ETHTYPE_PROFILE_GET (1  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_RFDB_PROFILE_SET (2  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_RFDB_PROFILE_GET (3  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_CTRLPKT_PROFILE_ADD (4  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_CTRLPKT_PROFILE_DEL (5  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETFIRST (6  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETNEXT (7  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_VPGROUP_SET (8  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_VPGROUP_GET (9  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_TUNNEL_DECAP_SET (10  + SW_API_CTRLPKT_OFFSET)
#define SW_API_MGMTCTRL_TUNNEL_DECAP_GET (11  + SW_API_CTRLPKT_OFFSET)

    /* Service Code */
#define SW_API_SERVCODE_OFFSET        2600
#define SW_API_SERVCODE_CONFIG_SET	(0  + SW_API_SERVCODE_OFFSET)
#define SW_API_SERVCODE_CONFIG_GET	(1  + SW_API_SERVCODE_OFFSET)
#define SW_API_SERVCODE_LOOPCHECK_EN	(2  + SW_API_SERVCODE_OFFSET)
#define SW_API_SERVCODE_LOOPCHECK_STATUS_GET	(3  + SW_API_SERVCODE_OFFSET)
#define SW_API_PORT_SERVCODE_SET	(4  + SW_API_SERVCODE_OFFSET)
#define SW_API_PORT_SERVCODE_GET	(5  + SW_API_SERVCODE_OFFSET)


	/* POLICER */
#define SW_API_POLICER_OFFSET        2800
#define SW_API_POLICER_TIMESLOT_SET               (0  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_TIMESLOT_GET               (1  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_PORT_COUNTER_GET              (2  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_ACL_COUNTER_GET                (3  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_COMPENSATION_SET               (4  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_COMPENSATION_GET               (5  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_PORT_ENTRY_SET               (6  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_PORT_ENTRY_GET               (7  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_ACL_ENTRY_SET               (8  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_ACL_ENTRY_GET               (9  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_GLOBAL_COUNTER_GET               (10  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_BYPASS_EN_SET              (11  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_BYPASS_EN_GET              (12  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_PRIORITY_REMAP_SET              (13  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_PRIORITY_REMAP_GET              (14  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_CTRL_SET              (15  + SW_API_POLICER_OFFSET)
#define SW_API_POLICER_CTRL_GET              (16  + SW_API_POLICER_OFFSET)

/* SHAPER */
#define SW_API_SHAPER_OFFSET        2900
#define SW_API_PORT_SHAPER_TIMESLOT_SET               (0  + SW_API_SHAPER_OFFSET)
#define SW_API_PORT_SHAPER_TIMESLOT_GET               (1  + SW_API_SHAPER_OFFSET)
#define SW_API_FLOW_SHAPER_TIMESLOT_SET               (2  + SW_API_SHAPER_OFFSET)
#define SW_API_FLOW_SHAPER_TIMESLOT_GET               (3  + SW_API_SHAPER_OFFSET)
#define SW_API_QUEUE_SHAPER_TIMESLOT_SET               (4  + SW_API_SHAPER_OFFSET)
#define SW_API_QUEUE_SHAPER_TIMESLOT_GET               (5  + SW_API_SHAPER_OFFSET)
#define SW_API_PORT_SHAPER_TOKEN_NUMBER_SET               (6  + SW_API_SHAPER_OFFSET)
#define SW_API_PORT_SHAPER_TOKEN_NUMBER_GET               (7  + SW_API_SHAPER_OFFSET)
#define SW_API_FLOW_SHAPER_TOKEN_NUMBER_SET               (8  + SW_API_SHAPER_OFFSET)
#define SW_API_FLOW_SHAPER_TOKEN_NUMBER_GET               (9  + SW_API_SHAPER_OFFSET)
#define SW_API_QUEUE_SHAPER_TOKEN_NUMBER_SET               (10  + SW_API_SHAPER_OFFSET)
#define SW_API_QUEUE_SHAPER_TOKEN_NUMBER_GET               (11  + SW_API_SHAPER_OFFSET)
#define SW_API_PORT_SHAPER_SET               (12  + SW_API_SHAPER_OFFSET)
#define SW_API_PORT_SHAPER_GET               (13  + SW_API_SHAPER_OFFSET)
#define SW_API_FLOW_SHAPER_SET               (14  + SW_API_SHAPER_OFFSET)
#define SW_API_FLOW_SHAPER_GET               (15  + SW_API_SHAPER_OFFSET)
#define SW_API_QUEUE_SHAPER_SET               (16  + SW_API_SHAPER_OFFSET)
#define SW_API_QUEUE_SHAPER_GET               (17  + SW_API_SHAPER_OFFSET)
#define SW_API_SHAPER_IPG_PRE_SET               (18  + SW_API_SHAPER_OFFSET)
#define SW_API_SHAPER_IPG_PRE_GET               (19  + SW_API_SHAPER_OFFSET)
#define SW_API_QUEUE_SHAPER_CTRL_SET               (20  + SW_API_SHAPER_OFFSET)
#define SW_API_QUEUE_SHAPER_CTRL_GET               (21  + SW_API_SHAPER_OFFSET)
#define SW_API_FLOW_SHAPER_CTRL_SET               (22  + SW_API_SHAPER_OFFSET)
#define SW_API_FLOW_SHAPER_CTRL_GET               (23  + SW_API_SHAPER_OFFSET)

/*qca808x_start*/
#define SW_API_MAX                 0xffff
#ifdef __cplusplus
}
#endif                          /* __cplusplus */
#endif                          /* _SW_IOCTL_H_ */
/*qca808x_end*/
