/**
 *	ratched - TLS connection router that performs a man-in-the-middle attack
 *	Copyright (C) 2017-2017 Johannes Bauer
 *
 *	This file is part of ratched.
 *
 *	ratched is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; this program is ONLY licensed under
 *	version 3 of the License, later versions are explicitly excluded.
 *
 *	ratched is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with ratched; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *	Johannes Bauer <JohannesBauer@gmx.de>
**/

#include "testbed.h"
#include <openssl.h>
#include <openssl_clienthello.h>

static const uint8_t client_hello_example[] = {
	0x16, 0x03, 0x01, 0x01, 0x04, 0x01, 0x00, 0x01, 0x00, 0x03, 0x03, 0x5a, 0x0d, 0x6e, 0x1e, 0x52,
	0x94, 0x1c, 0x70, 0xf4, 0xe3, 0x8e, 0x3e, 0x9d, 0x93, 0x5a, 0x7c, 0x3c, 0x73, 0x33, 0xea, 0xb9,
	0xf0, 0x7e, 0x7d, 0xaa, 0x20, 0x9f, 0x95, 0xa4, 0xc3, 0x63, 0x17, 0x00, 0x00, 0x6c, 0xc0, 0x2b,
	0xc0, 0x2c, 0xc0, 0x86, 0xc0, 0x87, 0xc0, 0x09, 0xc0, 0x23, 0xc0, 0x0a, 0xc0, 0x24, 0xc0, 0x72,
	0xc0, 0x73, 0xc0, 0xac, 0xc0, 0xad, 0xc0, 0x08, 0xc0, 0x2f, 0xc0, 0x30, 0xc0, 0x8a, 0xc0, 0x8b,
	0xc0, 0x13, 0xc0, 0x27, 0xc0, 0x14, 0xc0, 0x28, 0xc0, 0x76, 0xc0, 0x77, 0xc0, 0x12, 0x00, 0x9c,
	0x00, 0x9d, 0xc0, 0x7a, 0xc0, 0x7b, 0x00, 0x2f, 0x00, 0x3c, 0x00, 0x35, 0x00, 0x3d, 0x00, 0x41,
	0x00, 0xba, 0x00, 0x84, 0x00, 0xc0, 0xc0, 0x9c, 0xc0, 0x9d, 0x00, 0x0a, 0x00, 0x9e, 0x00, 0x9f,
	0xc0, 0x7c, 0xc0, 0x7d, 0x00, 0x33, 0x00, 0x67, 0x00, 0x39, 0x00, 0x6b, 0x00, 0x45, 0x00, 0xbe,
	0x00, 0x88, 0x00, 0xc4, 0xc0, 0x9e, 0xc0, 0x9f, 0x00, 0x16, 0x01, 0x00, 0x00, 0x6b, 0x00, 0x17,
	0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x05, 0x00, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x00, 0x0c, 0x00, 0x00, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x68, 0x6f, 0x73,
	0x74, 0xff, 0x01, 0x00, 0x01, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x0c, 0x00, 0x0a,
	0x00, 0x17, 0x00, 0x18, 0x00, 0x19, 0x00, 0x15, 0x00, 0x13, 0x00, 0x0b, 0x00, 0x02, 0x01, 0x00,
	0x00, 0x0d, 0x00, 0x16, 0x00, 0x14, 0x04, 0x01, 0x04, 0x03, 0x05, 0x01, 0x05, 0x03, 0x06, 0x01,
	0x06, 0x03, 0x03, 0x01, 0x03, 0x03, 0x02, 0x01, 0x02, 0x03, 0x00, 0x10, 0x00, 0x0b, 0x00, 0x09,
	0x08, 0x68, 0x74, 0x74, 0x70, 0x2f, 0x31, 0x2e, 0x31
};

static void test_clienthello_parse(void) {
	subtest_start();
	openssl_init();

	struct chello_t chello;
	test_assert(parse_client_hello(&chello, client_hello_example, sizeof(client_hello_example)));
	test_assert_str_eq(chello.server_name_indication, "localhost");
	free_client_hello(&chello);
	openssl_deinit();
	subtest_finished();
}

int main(int argc, char **argv) {
	test_start(argc, argv);
	test_clienthello_parse();
	test_finished();
	return 0;
}

