"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.rimraf = exports.sync = exports.rimrafSync = exports.moveRemove = exports.moveRemoveSync = exports.posix = exports.posixSync = exports.windows = exports.windowsSync = exports.manual = exports.manualSync = exports.native = exports.nativeSync = exports.assertRimrafOptions = exports.isRimrafOptions = void 0;
const opt_arg_js_1 = __importDefault(require("./opt-arg.js"));
const path_arg_js_1 = __importDefault(require("./path-arg.js"));
/* c8 ignore start */
const typeOrUndef = (val, t) => typeof val === 'undefined' || typeof val === t;
/* c8 ignore stop */
const isRimrafOptions = (o) => !!o &&
    typeof o === 'object' &&
    typeOrUndef(o.preserveRoot, 'boolean') &&
    typeOrUndef(o.preserveRoot, 'number') &&
    typeOrUndef(o.maxRetries, 'number') &&
    typeOrUndef(o.retryDelay, 'number') &&
    typeOrUndef(o.backoff, 'number') &&
    typeOrUndef(o.maxBackoff, 'number');
exports.isRimrafOptions = isRimrafOptions;
/* c8 ignore start */
const assertRimrafOptions = (o) => {
    if (!(0, exports.isRimrafOptions)(o)) {
        throw new Error('invalid rimraf options');
    }
};
exports.assertRimrafOptions = assertRimrafOptions;
/* c8 ignore stop */
const rimraf_manual_js_1 = require("./rimraf-manual.js");
const rimraf_move_remove_js_1 = require("./rimraf-move-remove.js");
const rimraf_native_js_1 = require("./rimraf-native.js");
const rimraf_posix_js_1 = require("./rimraf-posix.js");
const rimraf_windows_js_1 = require("./rimraf-windows.js");
const use_native_js_1 = require("./use-native.js");
const wrap = (fn) => async (path, opt) => {
    const options = (0, opt_arg_js_1.default)(opt);
    await (Array.isArray(path)
        ? Promise.all(path.map(p => fn((0, path_arg_js_1.default)(p, options), options)))
        : fn((0, path_arg_js_1.default)(path, options), options));
};
const wrapSync = (fn) => (path, opt) => {
    const options = (0, opt_arg_js_1.default)(opt);
    return Array.isArray(path)
        ? path.forEach(p => fn((0, path_arg_js_1.default)(p, options), options))
        : fn((0, path_arg_js_1.default)(path, options), options);
};
exports.nativeSync = wrapSync(rimraf_native_js_1.rimrafNativeSync);
exports.native = Object.assign(wrap(rimraf_native_js_1.rimrafNative), { sync: exports.nativeSync });
exports.manualSync = wrapSync(rimraf_manual_js_1.rimrafManualSync);
exports.manual = Object.assign(wrap(rimraf_manual_js_1.rimrafManual), { sync: exports.manualSync });
exports.windowsSync = wrapSync(rimraf_windows_js_1.rimrafWindowsSync);
exports.windows = Object.assign(wrap(rimraf_windows_js_1.rimrafWindows), { sync: exports.windowsSync });
exports.posixSync = wrapSync(rimraf_posix_js_1.rimrafPosixSync);
exports.posix = Object.assign(wrap(rimraf_posix_js_1.rimrafPosix), { sync: exports.posixSync });
exports.moveRemoveSync = wrapSync(rimraf_move_remove_js_1.rimrafMoveRemoveSync);
exports.moveRemove = Object.assign(wrap(rimraf_move_remove_js_1.rimrafMoveRemove), {
    sync: exports.moveRemoveSync,
});
exports.rimrafSync = wrapSync((path, opt) => (0, use_native_js_1.useNativeSync)() ? (0, rimraf_native_js_1.rimrafNativeSync)(path, opt) : (0, rimraf_manual_js_1.rimrafManualSync)(path, opt));
exports.sync = exports.rimrafSync;
exports.rimraf = Object.assign(wrap((path, opt) => (0, use_native_js_1.useNative)() ? (0, rimraf_native_js_1.rimrafNative)(path, opt) : (0, rimraf_manual_js_1.rimrafManual)(path, opt)), {
    // this weirdness because it's easier than explicitly declaring
    rimraf: exports.manual,
    sync: exports.rimrafSync,
    rimrafSync: exports.rimrafSync,
    manual: exports.manual,
    manualSync: exports.manualSync,
    native: exports.native,
    nativeSync: exports.nativeSync,
    posix: exports.posix,
    posixSync: exports.posixSync,
    windows: exports.windows,
    windowsSync: exports.windowsSync,
    moveRemove: exports.moveRemove,
    moveRemoveSync: exports.moveRemoveSync,
});
exports.rimraf.rimraf = exports.rimraf;
exports.default = exports.rimraf;
//# sourceMappingURL=index.js.map