

(function(globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  var newcatalog = {
    "%curr% of %total%": "%curr% of %total%",
    "(If left blank, owner will be admin)": "(Se lasciato vuoto, il proprietario sar\u00e0 admin)",
    "(current notification)": "(notifica corrente)",
    "(current version)": "(versione corrente)",
    "1 Year": "1 Anno",
    "1 month ago": "1 mese fa",
    "1 week ago": "1 settimana fa",
    "3 days ago": "3 giorni fa",
    "30 Days": "30 Giorni",
    "7 Days": "7 Giorni",
    "A file is being uploaded. Are you sure you want to leave this page?": "Un file \u00e8 in fase di caricamento. Sei sicuro di voler lasciare questa pagina?",
    "A file with the same name already exists in this folder.": "Un file con lo stesso nome esiste gi\u00e0 in questa cartella.",
    "About": "Informazioni su",
    "About Us": "Informazioni su di noi",
    "Accept": "Accettare",
    "Accepted": "Accettato",
    "Accepter": "Approvatore",
    "Access Log": "Log degli accessi",
    "Action": "Azioni",
    "Actions": "Azioni",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Attiva l'utente immediatamente dopo la registrazione. Se deselezionato, un utente deve essere attivato dall'amministratore o tramite l'email di attivazione",
    "Activated": "Attivato",
    "Activated Users": "Utenti attivati",
    "Active": "Attivo",
    "Active Users": "Utenti attivi",
    "Activities": "Attivit\u00e0",
    "Add": "Aggiungi",
    "Add Admins": "Aggiungi Amministratori",
    "Add File": "Aggiungi File",
    "Add Library": "Aggiungi Libreria",
    "Add Member": "Aggiungi un membro",
    "Add Terms and Conditions": "Aggiungi termini e condizioni",
    "Add User": "Aggiungi utente",
    "Add a comment.": "Aggiungi un commento.",
    "Add admin": "Aggiungi amministratore",
    "Add auto expiration": "Aggiungi la scadenza automatica",
    "Add group member": "Aggiungi membro al gruppo",
    "Add institution": "Aggiungi istituzione",
    "Add new notification": "Aggiungi nuova notifica",
    "Add new reviewer": "Aggiungi un nuovo revisore",
    "Add password protection": "Aggiungi la protezione password",
    "Add user": "Aggiungi utente",
    "Added": "Aggiunto",
    "Added user {user}": "Utente {user} aggiunto",
    "Admin": "Amministratore",
    "Admin Login Logs": "Log degli accessi come amministratore",
    "Admin Logs": "Admin Logs",
    "Admin Operation Logs": "Log delle operazioni come amministratore",
    "Admin access": "Accesso amministratore",
    "Admins": "Amministratori",
    "All": "Tutto",
    "All Groups": "Tutti i Gruppi",
    "All Notifications": "Tutte le notifiche",
    "All Public Links": "Tutti i collegamenti pubblici",
    "All file types": "Tutti i tipi di files",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Consenti nuove registrazioni utente. Deseleziona questa opzione per impedire a chiunque di creare un nuovo account.",
    "Allow user to add organization libraries. Otherwise, only system admin can add organization libraries.": "Consenti all'utente di aggiungere librerie. In caso contrario, solo l'amministratore di sistema pu\u00f2 aggiungere librerie.",
    "Allow user to change library history settings": "Consenti all'utente di modificare le impostazioni della cronologia della libreria",
    "Allow user to clean library trash": "Permetti all'utente di svuotare il cestino della libreria",
    "Allow user to create encrypted libraries": "Consenti all'utente di creare librerie crittografate",
    "An integer that is greater than 0 or equal to -2.": "Un numero intero maggiore di 0 o uguale a -2.",
    "An integer that is greater than or equal to 0.": "Un numero intero maggiore o uguale a 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "Un collegamento interno \u00e8 un collegamento a un file o una cartella a cui gli utenti possono accedere con autorizzazione di lettura al file o alla cartella.",
    "Anonymous User": "Utente Anonimo",
    "Are you sure to delete": "Sei sicuro di cancellare",
    "Are you sure you want to clear trash?": "Sei sicuro di voler svuotare il cestino?",
    "Are you sure you want to delete %s ?": "Sei sicuro di voler eliminare %s ?",
    "Are you sure you want to delete the selected user(s) ?": "Sei sicuro di voler eliminare gli utenti selezionati?",
    "Are you sure you want to delete the share link?": "Sei sicuro di voler eliminare il link di condivisione?",
    "Are you sure you want to restore this library?": "Sei sicuro di ripristinare questa libreria?",
    "Are you sure you want to unlink this device?": "Sei sicuro di voler scollegare questo dispositivo?",
    "Audio": "Audio",
    "Author": "Autore",
    "Avatar": "Avatar",
    "Avatar:": "Avatar:",
    "Back": "Indietro",
    "Back to parent directory": "Torna alla cartella precedente",
    "Besides Write permission, user can also share the library.": "Oltre all'autorizzazione alla scrittura, l'utente pu\u00f2 anche condividere la libreria.",
    "Branding": "Marcare",
    "Broken (please contact your administrator to fix this library)": "Interrotto (contattare l'amministratore per correggere questa libreria)",
    "Can not copy directory %(src)s to its subdirectory %(des)s": "Non posso copiare la cartella %(src)s nella sua sottocartella %(des)s",
    "Can not move directory %(src)s to its subdirectory %(des)s": "Non posso spostare la cartella %(src)s nella sua sottocartella %(des)s",
    "Can not select self as a related file.": "Non \u00e8 possibile selezionare self come file correlato.",
    "Cancel": "Annulla",
    "Cancel All": "Cancella tutto",
    "Change": "Cambia",
    "Change Password": "Cambia Password",
    "Change Password of Library {placeholder}": "Modifica password della libreria {placeholder}",
    "Changes": "Modifiche",
    "Clean": "Annulla",
    "Clear": "Cancella",
    "Clear Trash": "Svuota il Cestino",
    "Clear files in trash and history\uff1a": "Cancella i file nel cestino e nella cronologia:",
    "Clients": "Clients",
    "Close": "Chiudi",
    "Close (Esc)": "Chiudi (Esc)",
    "Column": "Colonna",
    "Comment": "Commento",
    "Comments": "Commenti",
    "Community Edition": "Edizione pubblica",
    "Confirm Password": "Conferma Password",
    "Contact Email": "Contatto Email",
    "Contact Email:": "Contatto Email:",
    "Contents": "Contenuti",
    "Copy": "Copia",
    "Copy selected item(s) to:": "Copia gli elementi selezionati su:",
    "Count": "Conta",
    "Create Group": "Creare un gruppo",
    "Create Library": "Crea libreria",
    "Create Report": "Rapporto Creato",
    "Create a new tag": "Crea un nuovo tag",
    "Created": "Creato",
    "Created At": "Creato il",
    "Created draft": "Bozza creata",
    "Created file": "File creato",
    "Created folder": "Cartella creata",
    "Created group {group_name}": "Gruppo {group_name} creato",
    "Created library": "Liberia creata",
    "Created library {library_name} with {owner} as its owner": "Libreria {library_name} creata con {owner} come suo proprietario",
    "Creator": "Creatore ",
    "Current Connected Devices": "Dispositivi Attualmente Connessi",
    "Current Library": "Libreria Corrente",
    "Current Path: ": "Percorso Attuale:",
    "Current Version": "Versione Corrente",
    "Current path: ": "Percorso corrente:",
    "Custom CSS": "CSS personalizzato",
    "Custom file types": "Tipi di file personalizzati",
    "Database": "Database",
    "Date": "Data",
    "Default": "Predefinito",
    "Delete": "Elimina",
    "Delete Account": "Elimina Account",
    "Delete Department": "Dipartimento Rimosso",
    "Delete Expired Invitations": "Elimina inviti scaduti",
    "Delete File": "Rimuovi File",
    "Delete Folder": "Rimuovi Cartella",
    "Delete Group": "Elimina gruppo",
    "Delete Institution": "Elimina istituzione",
    "Delete Library": "Elimina libreria",
    "Delete Member": "Elimina membro",
    "Delete Notification": "Cancella Notifica",
    "Delete Organization": "Cancella l'organizzazione",
    "Delete Time": "Orario Cancellazione",
    "Delete User": "Elimina utente",
    "Delete draft": "Rimuovi Bozza",
    "Delete files from this device the next time it comes online.": "Elimina i file da questo dispositivo la prossima volta che torni online.",
    "Deleted": "Eliminato",
    "Deleted Libraries": "Librerie Eliminate",
    "Deleted Time": "Tempo di cancellazione",
    "Deleted directories": "Cartelle eliminate",
    "Deleted draft": "Bozza cancellata",
    "Deleted file": "File rimosso",
    "Deleted files": "File eliminati",
    "Deleted folder": "Cartella rimossa",
    "Deleted group {group_name}": "Gruppo {group_name} eliminato",
    "Deleted library": "Libreria Rimossa",
    "Deleted library {library_name}": "Libreria {library_name} rimossa",
    "Deleted user {user}": "Utente {user} eliminato",
    "Departments": "Dipartimenti",
    "Description": "Descrizione",
    "Desktop": "Desktop",
    "Detail": "Dettaglio",
    "Details": "Dettagli",
    "Device": "Dispositivo",
    "Device Name": "Nome Dispositivo",
    "Devices": "Dispositivi",
    "Direct Download Link:": "Link per il download diretto:",
    "Direct download link is copied to the clipboard.": "Il collegamento per il download diretto viene copiato negli appunti.",
    "Directory": "Cartella",
    "Disable Two-Factor Authentication": "Disabilita l'autenticazione a due fattori",
    "Document convertion failed.": "Conversione documento fallita.",
    "Documents": "Documenti",
    "Don't keep history": "Non conservare la cronologia",
    "Don't replace": "Non sostituire",
    "Don't send emails": "Email non inviate",
    "Download": "Scarica",
    "Download an example file": "Scarica un file di esempio",
    "Draft has been deleted.": "Bozza \u00e8 stata cancellata.",
    "Drafts": "Bozze",
    "Edit": "Modifica",
    "Edit Draft": "Modifica Bozza",
    "Edit File": "Modifica File",
    "Edit Tag": "Modifica contrassegno",
    "Edit failed.": "Modifica fallita.",
    "Edit labels": "Modifica etichette",
    "Edit on cloud and download": "Modifica nel Cloud e scarica",
    "Edit succeeded": "Modifica eseguita",
    "Email": "Email",
    "Email Notification": "Notifica per Email",
    "Email Notification of File Changes": "Notifica via e-mail delle modifiche ai file",
    "Emails, separated by ','": "Email, separate da ','",
    "Enable Two-Factor Authentication": "Abilita autenticazione a due fattori",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Abilitare l'amministratore di sistema per aggiungere termini e condizioni e tutti gli utenti dovranno accettare i termini.",
    "Enable two factor authentication": "Abilita l'autenticazione a due fattori",
    "Enable users to share libraries to any groups in the system.": "Consenti agli utenti di condividere le librerie con qualsiasi gruppo nel sistema.",
    "Encrypt": "Cifra",
    "Encrypted library": "Libreria crittografata",
    "Error": "Errore",
    "Errors": "Errori",
    "Exit System Admin": "Uscita da Amministrazione di Sistema",
    "Expiration": "Scadenza",
    "Expiration Date:": "Data di scadenza:",
    "Expired": "Scaduto",
    "Expired at": "Scaduro il",
    "Export Excel": "Esporta in Excel",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Estensioni dei file di testo che possono essere visualizzati in anteprima online, ciascun suffisso \u00e8 separato da una virgola.",
    "Failed": "Fallito",
    "Failed to copy %(name)s": "Impossibile copiare %(name)s",
    "Failed to delete draft %(draft)s.": "Errore rimozione bozza %(draft)s",
    "Failed to publish draft %(draft)s.": "Errore pubblicazione bozza %(draft)s.",
    "Failed. Please check the network.": "Errore. Si prega di verificare la configurazione di rete.",
    "Favorites": "Preferiti",
    "File": "File",
    "File Access": "Accesso ai file",
    "File History": "Cronologia dei file",
    "File Operations": "Operazioni sui file",
    "File Update": "Aggiornamento File",
    "File Upload": "Caricare un file",
    "File Uploading...": "Caricamento file...",
    "File download is disabled: the share link traffic of owner is used up.": "File download disabilitato: la quota di traffico del collegamento per l'utente \u00e8 esaurita.",
    "Files": "Documenti",
    "Folder": "Cartella",
    "Folder Permission": "Permessi cartella",
    "Folder does not exist.": "La cartella non esiste.",
    "Folders": "Cartelle",
    "Force user to change password when account is newly added or reset by admin": "Forza l'utente a cambiare la password quando l'account viene aggiunto o ripristinato dall'amministratore",
    "Force user to use a strong password when sign up or change password.": "Forza l'utente a utilizzare una password complessa al momento della registrazione o modifica della password.",
    "Freeze user account when failed login attempts exceed limit.": "Blocca l'account utente quando i tentativi di accesso falliti superano il limite.",
    "Generate": "Generare",
    "Global Address Book": "Rubrica globale",
    "Grid": "Griglia",
    "Group": "Condivise ai miei Gruppi",
    "Group Permission": "Permessi Gruppo",
    "Groups": "Gruppi",
    "Guest": "Ospite",
    "Handled": "Mantenuto",
    "Help": "Aiuto",
    "History": "Cronologia",
    "History Setting": "Preferenze Storico",
    "History Versions": "Versioni cronologia",
    "IP": "IP",
    "If the share link is deleted, no one will be able to access it any more.": "Se il link di condivisione viene eliminato, nessuno sar\u00e0 pi\u00f9 in grado di accedervi.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "Se attivi, i client desktop non saranno in grado di sincronizzare una cartella al di fuori della cartella predefinita Seafile.",
    "If you don't have any device with you, you can access your account using backup codes.": "Se non hai alcun dispositivo con te, puoi accedere al tuo account usando i codici di backup.",
    "Image": "Immagine",
    "Images": "Immagini",
    "Import users from a .xlsx file": "Importa utente da un file .xlsx",
    "In all libraries": "Dentro tutte le librerie",
    "Inactive": "Inattivo",
    "Info": "Info",
    "Input file extensions here, separate with ','": "Inserisci la estensione del file qu\u00ec, separata con ','",
    "Institutions": "Istruzioni",
    "Internal Link": "Collegamento interno",
    "Internal Server Error": "Errore interno del server",
    "Internal link has been copied to clipboard": "Il collegamento interno \u00e8 stato copiato negli appunti",
    "Invalid destination path": "Percorso di destinazione non valido",
    "Invalid month, should be yyyymm.": "Mese non valido, dovrebbe essere espresso nella forma aaaamm.",
    "Invitations": "Inviti",
    "Invite Time": "Tempo di Invito",
    "Invite user": "Invita utente",
    "Invited at": "Invitato il",
    "Inviter": "Invitante",
    "It is required.": "\u00c8 richiesto.",
    "Keep full history": "Conserva la cronologia",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP(importato)",
    "Labels": "Etichette",
    "Language": "Lingua",
    "Language Setting": "Impostazioni Lingua",
    "Last Access": "Ultimo Accesso",
    "Last Login": "Ultimo Accesso",
    "Last Update": "Ultimo aggiornamento",
    "Last modified by": "Ultima modifica da",
    "Leave Share": "Lascia Condivisione",
    "Libraries": "Librerie",
    "Library": "Libreria",
    "Library Name": "Nome Libraria",
    "Library Type": "Tipo di Libreria",
    "Library can not be shared to owner.": "La libreria non pu\u00f2 essere condivisa con il proprietario.",
    "Limits": "Limiti",
    "Link": "Link",
    "Link:": "Link:",
    "Linked Devices": "Dispositivi collegati",
    "Links": "Link",
    "List": "Elenco",
    "List your account in global address book, so that others can find you by typing your name.": "Elenca la rubrica globale del il tuo account, in modo che altri possano trovarti digitando il tuo nome.",
    "Local draft": "Bozza locale",
    "Location": "Posizione",
    "Lock": "Serratura",
    "Log out": "Termina Sessione",
    "Login Background Image": "Immagine di sfondo della schermata di login",
    "Logs": "Logs",
    "Manage Members": "Amministra Membri",
    "Manage group members": "Gestisci i membri del gruppo",
    "Mark all read": "Segna come letti",
    "Mark as resolved": "Contrassegnato come risolto",
    "Member": "Membro",
    "Members": "Membri",
    "Message": "Messaggio",
    "Message (optional):": "Messaggio (opzionale):",
    "Mobile": "Mobile",
    "Modification Details": "Dettaglio Modifiche",
    "Modified": "Modificato",
    "Modified files": "File modificati",
    "Modifier": "Modificatore",
    "Modify": "Modificare",
    "Month:": "Mese:",
    "Monthly User Traffic": "Traffico utenti mensile",
    "More": "Altro",
    "More Operations": "Altro",
    "Move": "Sposta",
    "Move selected item(s) to:": "Sposta gli oggetti selezionati su:",
    "Moved file": "File spostato",
    "Moved folder": "Cartella spostata",
    "My Groups": "I miei Gruppi",
    "My Libraries": "Le Mie Librerie",
    "Name": "Nome",
    "Name is required": "Il nome \u00e8 obbligatorio",
    "Name is required.": "Il nome \u00e8 obbligatorio.",
    "Name should not include '/'.": "Il nome non dovrebbe contenere '/'.",
    "Name(optional)": "Nome(opzionale)",
    "Network error": "Errore rete",
    "New": "Nuovo",
    "New Department": "Nuovo Dipartimento",
    "New Department Library": "Nuova libreria del dipartimento",
    "New Draft": "Nuova Bozza",
    "New Excel File": "Nuovo file Excel",
    "New File": "Nuovo File",
    "New Folder": "Nuova Cartella",
    "New Group": "Nuovo gruppo",
    "New Library": "Nuova libreria",
    "New Markdown File": "Nuovo file Markdown",
    "New Password": "Nuova Password",
    "New Password Again": "Nuova Password Controllo",
    "New PowerPoint File": "Nuovo file di PowerPoint",
    "New Sub-department": "Nuovo Sotto-dipartimento",
    "New Tag": "Nuovo Tag",
    "New Wiki": "Nuovo Wiki",
    "New Word File": "Nuovo file Word",
    "New directories": "Nuove cartelle",
    "New file name": "Nuovo nome file",
    "New files": "Nuovi file",
    "New folder name": "Nuovo nome cartella",
    "New password is too short": "La nuova password \u00e8 troppo corta",
    "New passwords don't match": "Le nuove password non corrispondono",
    "Next": "Successivo",
    "Next (Right arrow key)": "Successivo (tasto freccia destra)",
    "No comment yet.": "Ancora nessun commento.",
    "No connected devices": "Nessun dispositivo connesso",
    "No departments": "Nessun dipartimento",
    "No draft yet": "Ancora nessuna bozza.",
    "No groups": "Nessun gruppo",
    "No libraries": "Nessuna libreria",
    "No members": "Nessun membro",
    "No public libraries": "Nessuna libreria pubblica",
    "No result": "Nessun risultato",
    "No reviewer yet.": "Ancora nessuna recensore.",
    "No sub-departments": "Nessun sotto-dipartimento",
    "No sync errors": "Nessun errore di sincronizzazione",
    "None": "Niente",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Nota: le impostazioni tramite l'interfaccia web vengono salvate nella tabella del database (seahub-db/constance_config). Hanno una priorit\u00e0 pi\u00f9 alta rispetto alle impostazioni contenute dei file di configurazione",
    "Notification Detail": "Dettagli di notifica",
    "Notifications": "Notifiche",
    "Number of changes:": "Numero di modifiche:",
    "Number of days that keep user sign in.": "Numero di giorni in cui l'utente rimane connesso.",
    "Number of groups": "Numero di gruppi",
    "Off": "Spento",
    "Old Password": "Vecchia Password",
    "On": "Acceso",
    "Online Preview": "Anteprima Online",
    "Online view is not applicable to this file format": "La visualizzazione online non \u00e8 applicabile a questo formato di file",
    "Only Show": "Solo Visualizzazione",
    "Only keep a period of history:": "Tieni solamente un periodo della cronologia:",
    "Open in New Tab": "Apri in una nuova scheda",
    "Open parent folder": "Apri cartella principale",
    "Open via Client": "Apri tramite Client ",
    "Operation": "Operazione",
    "Operation succeeded.": "Operazione conclusa con successo.",
    "Operations": "Operazioni",
    "Organization": "Organizzazione",
    "Organization Admin": "Amministratore dell'organizzazione",
    "Organizations": "Organizzazioni",
    "Original file has been deleted.": "Il file originale \u00e8 stato cancellato.",
    "Other Libraries": "Altre Librerie",
    "Owner": "Proprietario",
    "Owner can use admin panel in an organization, must be a new account.": "Il proprietario pu\u00f2 utilizzare il pannello di amministrazione in una organizzazione, deve essere un nuovo account.",
    "Packaging...": "Creazione del file zip in corso...",
    "Password": "Password",
    "Password again": "Ridigita password",
    "Password is too short": "La password \u00e8 troppo corta",
    "Password:": "Password:",
    "Passwords don't match": "Le Password non corrispondono",
    "Per 4 hours": "Per 4 ore",
    "Per day": "Per giorno",
    "Per hour": "Per ora",
    "Per week": "Per settimana",
    "Permission": "Permesso",
    "Permission denied": "Permesso negato.",
    "Platform": "Piattaforma",
    "Please check the network.": "Si prega di controllare la configurazione di rete.",
    "Please choose a .xlsx file.": "Si prega di scegliere un file .xlsx",
    "Please enter 1 or more character": "Prego inserire 1 o pi\u00f9 caratteri",
    "Please enter a new password": "Si prega di inserire una nuova password",
    "Please enter a non-negative integer": "Prego inserire un intero non negativo",
    "Please enter days": "Prego inserire i giorni",
    "Please enter password": "Per favore, inserisci la password",
    "Please enter the new password again": "Si prega di inserire nuovamente la nuova password",
    "Please enter the old password": "Si prega di inserire la vecchia password",
    "Please enter the password again": "Si prega di inserire nuovamente la password",
    "Please input at least an email.": "Per favore inserisci almeno un'email.",
    "Please select a library to share.": "Seleziona una libreria da condividere.",
    "Preview and download": "Anteprima e scarica",
    "Preview only": "Solo Anteprima",
    "Previous": "Precedente",
    "Previous (Left arrow key)": "Precedente (tasto freccia sinistra)",
    "Private": "Privato",
    "Professional Edition": "Versione Professionale",
    "Profile": "Profilo",
    "Profile Setting": "Settaggi del profilo",
    "Public": "Pubblico",
    "Publish": "Pubblica",
    "Publish draft": "Pubblica bozza",
    "Published": "Pubblicato",
    "Quota": "Quota",
    "Read-Only": "Sola lettura",
    "Read-Only folder": "Cartella in sola lettura",
    "Read-Only library": "Libreria in Lettura-Scrittura",
    "Read-Write": "Lettura-Scrittura",
    "Read-Write folder": "Cartella in Lettura-Scrittura",
    "Read-Write library": "Libreria in Lettura-Scrittura",
    "Really want to delete your account?": "Vuoi veramente eliminare il tuo account?",
    "Refresh": "Aggiornare",
    "Related Files": "File correlati",
    "Remove": "Rimuovi",
    "Removed all items from trash.": "Rimossi tutti gli elementi dal cestino.",
    "Removed items older than {n} days from trash.": "Rimossi dal cestino gli elementi pi\u00f9 vecchi di {n} giorni.",
    "Rename": "Rinomina",
    "Rename File": "File Rinominato",
    "Rename Folder": "Cartella Rinominata",
    "Rename Group": "Rinomina Gruppo",
    "Rename group to": "Rinomina gruppo in ",
    "Renamed file": "File rinominato",
    "Renamed folder": "Cartella rinominata",
    "Renamed library": "Libreria Rinominata",
    "Renamed or Moved files": "File rinominati o spostati",
    "Replace": "Sostituire",
    "Replace file {filename}?": "Sostituisci il file {filename}?",
    "Replacing it will overwrite its content.": "Sotituirlo sovrascriver\u00e0 il suo contenuto.",
    "Reports": "Resoconti",
    "Request a review": "Richiedi una recensione",
    "Reset Password": "Cambia Password",
    "ResetPwd": "Ripristina Password",
    "Restore": "Ripristina",
    "Restore Library": "Ripristina Libreria",
    "Restored file": "File recuperato",
    "Restored folder": "Cartella recuperata",
    "Restored library": "Liberaria recuperata",
    "Result": "Risultato",
    "Review": "Revisione",
    "Reviewers": "I revisori",
    "Revoke Admin": "Revoca l'amministratore",
    "Role": "Ruolo",
    "Save": "Salvare",
    "Save as ...": "Salva con nome ...",
    "Saving...": "Salvataggio...",
    "Seafile": "Seafile",
    "Search Files": "Ricerca documenti",
    "Search files in this library": "Ricerca documenti in questa libreria",
    "See All Notifications": "Vedi Tutte le Notifiche",
    "Select File": "Seleziona il file",
    "Select Tags": "Seleziona i tag",
    "Select a color": "Seleziona un colore",
    "Select a group": "Seleziona un gruppo",
    "Select libraries to share": "Selezione le librerie da condividere",
    "Select related file for {placeholder}": "Seleziona il file correlato per {placeholder}",
    "Select users...": "Seleziona utenti ...",
    "Send": "Invia",
    "Send activation Email after user registration.": "Invia l'email di attivazione dopo la registrazione dell'utente.",
    "Send the invitation link to the others, and they will be able to join the organization via scanning the QR code.": "Invia il link di invito agli altri e saranno in grado di unirsi all'organizzazione tramite la scansione del codice QR.",
    "Send to:": "Spedisci a:",
    "Sending...": "Invio...",
    "Server Version: ": "Versione Server:",
    "Set Admin": "Imposta amministratore",
    "Set Quota": "Imposta Quota",
    "Set permission": "Imposta permessi",
    "Set to current": "Imposta a corrente",
    "Set user contact email": "Imposta email di riferimento per l'utente",
    "Set user name": "Imposta il nome utente\"",
    "Set {placeholder}'s permission": "Imposta i permessi di {placeholder}s",
    "Setting library history is disabled by Admin.": "L'impostazione della cronologia delle librerie \u00e8 disabilitata dall'amministratore.",
    "Settings": "Impostazioni",
    "Share": "Condividi",
    "Share Admin": "Amministrazione Condivisioni",
    "Share From": "Condividi Da",
    "Share Link": "Condividi Collegamento",
    "Share Link Traffic": "Condivisione Link del Traffico",
    "Share Links": "Link condivisi",
    "Share To": "Condiviso con",
    "Share existing libraries": "Condividi le librerie esistenti",
    "Share link download": "Condividi il link per scaricare",
    "Share link is copied to the clipboard.": "Il link di condivisione viene copiato negli appunti.",
    "Share link upload": "Condividi il link  di caricamento",
    "Share to group": "Condividi con il gruppo",
    "Share to user": "Condividi con l'utente",
    "Shared By": "Condiviso da",
    "Shared Links": "Collegamenti condivisi",
    "Shared by:": "Condiviso da:",
    "Shared by: ": "Condiviso da:",
    "Shared with all": "Condivisi con tutti",
    "Shared with groups": "Condivisi con i gruppi",
    "Shared with me": "Condivisi con me",
    "Show Codes": "Mostra codici",
    "Show resolved comments": "Mostra commenti risolti",
    "Site name used in email sending": "Nome del sito utilizzato nell'invio di e-mail",
    "Site title shown in a browser tab": "Titolo del sito mostrato nella scheda del browser",
    "Size": "Dimensione",
    "Space Used": "Spazio Utilizzato",
    "Space Used / Quota": "Spazio utilizzato / Quota",
    "Star": "Marca",
    "Statistic": "Statistiche",
    "Status": "Stato",
    "Storage": "Storage",
    "Storage Used": "Archivio utilizzato",
    "Sub-departments": "Sotto-dipartimenti",
    "Submit": "Invia",
    "Success": "Successo",
    "Successfully added label(s) for library {placeholder}": "Etichett(a/e) libreria {placeholder} aggiunta/e con successo",
    "Successfully changed library password.": "Password della biblioteca modificata con successo.",
    "Successfully copied %(name)s and %(amount)s other items.": "%(name)s copiato con successo e %(amount)s altri articoli.",
    "Successfully copied %(name)s and 1 other item.": "%(name)s copiato con successo e 1 altro elemento.",
    "Successfully copied %(name)s.": "%(name)sCopiato con successo.",
    "Successfully deleted %s": "%s cancellato correttamente",
    "Successfully deleted 1 item.": "1 oggetto Eliminato con successo.",
    "Successfully deleted draft %(draft)s.": "Bozza eliminata con successo %(draft)s.",
    "Successfully edited labels.": "Etichette modificate con successo.",
    "Successfully invited %(email) and %(num) other people.": "Invitato con successo %(email) e %(num) altre persone.",
    "Successfully invited %(email).": "Invitato con successo %(email).",
    "Successfully moved %(name)s and %(amount)s other items.": "%(name)s spostato con successo e %(amount)s altri articoli.",
    "Successfully moved %(name)s and 1 other item.": "%(name)s spostato con successo e 1 altro elemento.",
    "Successfully moved %(name)s.": "%(name)s spostato con successo. ",
    "Successfully published draft %(draft)s.": "Bozza %(draft)s pubblicata con successo .",
    "Successfully reset password to %(passwd)s for user %(user)s.": "Ripristino della password con %(passwd)s per l'utente %(user)s eseguito con successo.",
    "Successfully restored 1 item.": "1 oggetto Ripristinato con successo.",
    "Successfully restored the library.": "Libreria ripristinata con successo.",
    "Successfully revoke the admin permission of %s": "Permessi di amministrazione revocati a %s correttamente",
    "Successfully saved": "Salvato con successo",
    "Successfully sent to {placeholder}": "Inviato con successo a {placeholder}",
    "Successfully set %s as admin.": "%s \u00e8 stato correttamente impostato come amministratore correttamente.",
    "Successfully set library history.": "Impostare correttamente la cronologia della libreria.",
    "Successfully transferred the group.": "Gruppo trasferito con successo.",
    "Successfully transferred the library.": "Libreria trasferita con successo.",
    "Successfully unshared library {placeholder}": "Condivisione della libreria {placeholder} annullata con successo",
    "Sync": "Sincronizza",
    "Sync Download": "Sincronizzare il Download",
    "Sync Traffic": "Sincronizzazione Traffico",
    "Sync Upload": "Sincronizzare il Caricamento",
    "System": "Sistema",
    "System Admin": "Amministratore del Sistema",
    "System Info": "Informazioni di Sistema",
    "Tagged Files": "File contrasseganti",
    "Tags": "Tag",
    "Terms": "Termini",
    "Terms and Conditions": "Termini e Condizioni",
    "Text": "Testo",
    "Text files": "Files di testo",
    "The URL of the server, like https://seafile.example.com or http://192.168.1.2:8000": "L'URL del server, per esempio https://seafile.example.com o http://192.168.1.2:8000",
    "The image could not be loaded.": "L'immagine non pu\u00f2 essere caricata.",
    "The internal URL for downloading/uploading files. Users will not be able to download/upload files if this is not set correctly. If you config Seafile behind Nginx/Apache, it should be SERVICE_URL/seafhttp, like https://seafile.example.com/seafhttp .": "URL interno per scaricare/caricare file. Gli utenti non saranno in grado di scaricare/caricare i file se quest'ultimo non \u00e8 impostata correttamente. Se configuri Seafile dietro Nginx/Apache, dovrebbe essere SERVICE_URL/seafhttp, per esempio https://seafile.example.com/seafhttp .",
    "The least number of characters a download/upload link password should include.": "Il numero minimo di caratteri di una password relativa al link utilizzato per scaricare/caricare file.",
    "The least number of characters an account password should include.": "Il numero minimo di caratteri che una password dovrebbe contenere.",
    "The least number of characters an encrypted library password should include.": "Il numero minimo di caratteri di una password che una libreria crittografata dovrebbe contenere",
    "The level(1-4) of an account password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "Il livello di sicurezza di una password (1-4). Ad esempio, '3' significa che la password deve contenete almeno 3 dei seguenti caratteri: numeri, lettere maiuscole, lettere minuiscule ed altri simboli",
    "The maximum number of failed login attempts before showing CAPTCHA.": "Il numero massimo di tentativi di accesso non riusciti prima di mostrare CAPTCHA.",
    "The password will be kept in the server for only 1 hour.": "La password \u00e8 conservata nel server per solo 1 ora.",
    "This file has been updated.": "Questo file \u00e8 stato aggiornato.",
    "This file is in draft stage.": "Questo file \u00e8 in fase di bozza.",
    "This is a draft": "Questa \u00e8 una bozza",
    "This is a special group representing a department.": "Questo \u00e8 un gruppo speciale che rappresenta un dipartimento.",
    "This library is password protected": "Questa libreria \u00e8 protetta da password",
    "This operation will not be reverted. Please think twice!": "Questa operazione non sar\u00e0 reversibile. Per cortesia pensaci due volte!",
    "Time": "Orario",
    "Tip: -2 means no limit.": "Suggerimento: -2 significa nessun limite.",
    "Tip: 0 means default limit": "Suggerimento: 0 significa limite predefinito",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Suggerimento: verr\u00e0 generata un'istantanea dopo la modifica, che registra lo stato della libreria dopo la modifica.",
    "Tip: you can search by keyword in name.": "Suggerimento: puoi cercare per parola chiave nel nome.",
    "Token": "Simbolo",
    "Tools": "Strumenti",
    "Total Devices": "Dispositivi Totali",
    "Total Storage": "Archiviazione totale",
    "Total Traffic": "Traffico Totale",
    "Total Users": "Utenti totali",
    "Traffic": "Traffico",
    "Transfer": "Trasferisci",
    "Transfer Group": "Trasferisci Gruppo",
    "Transfer Library": "Trasferisci Libreria",
    "Transfer group to": "Trasferisci al gruppo",
    "Transferred group {group_name} from {user_from} to {user_to}": "Gruppo {group_name} trasferito da {user_from} a {user_to}",
    "Transferred library {library_name} from {user_from} to {user_to}": "Libreria {library_name} trasferita da {user_from} a {user_to}",
    "Trash": "Cestino",
    "Two-Factor Authentication": "Autenticazione a due fattori",
    "Two-factor authentication is not enabled for your account. Enable two-factor authentication for enhanced account security.": "L'autenticazione a due fattori non \u00e8 abilitata per il tuo account. Abilita l'autenticazione a due fattori per una maggiore sicurezza degli account.",
    "Type": "Tipo",
    "Unknown": "Sconosciuto",
    "Unlink": "Scollega",
    "Unlink device": "Scollega dispositivo",
    "Unlock": "Sbloccato",
    "Unshare": "Elimina condivisione",
    "Unshare Library": "Annulla condivisione libreria",
    "Unstar": "Smarca",
    "Update": "Aggiorna",
    "Update Terms and Conditions": "Aggiorna termini e condizioni",
    "Updated draft": "Bozza aggiornata",
    "Updated file": "File aggiornato",
    "Upgrade to Pro Edition": "Esegui l'avanzamento alla versione professionale",
    "Upload": "Carica",
    "Upload Files": "Carica File",
    "Upload Folder": "Carica cartella",
    "Upload Link": "Link di Upload",
    "Upload Link:": "Link di caricamento:",
    "Upload Links": "Link di Upload",
    "Upload file": "Carica file",
    "Upload link is copied to the clipboard.": "Il link di caricamento viene copiato negli appunti.",
    "Use custom CSS": "Utilizza CSS personalizzato",
    "Use draft": "Usa bozza",
    "Used:": "Utilizzato:",
    "User": "Utente",
    "User Permission": "Permessi Utente",
    "User Storage": "Archiviazione degli utenti",
    "User can only view files online via browser. Files can't be downloaded.": "L'utente pu\u00f2 solo visualizzare i file online tramite browser. I file non possono essere scaricati.",
    "User can read, download and sync files.": "L'utente pu\u00f2 leggere, scaricare e sincronizzare i file.",
    "User can read, write, upload, download and sync files.": "L'utente pu\u00f2 leggere, scrivere, caricare, scaricare e sincronizzare i file.",
    "Username:": "Nome utente:",
    "Users": "Utenti",
    "Version": "Versione",
    "Version Number": "Numero della versione",
    "Video": "Video",
    "View": "Vedi",
    "View Snapshot": "Visualizza Istantanea",
    "View diff": "Visualizza differenze",
    "Virus File": "File infetto",
    "Virus Scan": "Scansione Virus",
    "Virus Scan Records": "Record di scansione virus",
    "Visited": "Visitato",
    "Visits": "Visite",
    "Web Download": "Download via Web",
    "Web Traffic": "Traffico Web",
    "Web Upload": "Caricamento via Web",
    "Wrong password": "Password sbagliata",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "Puoi anche aggiungere come guest, egli non potr\u00e0 creare librerie o gruppi.",
    "You can create libraries by clicking the \"New Library\" button above.": "\u00c8 possibile creare librerie cliccando sul pulsante \"Nuova libreria\".",
    "You can use this field at login.": "Puoi usare questo campo al login.",
    "You don't have any share links": "Non hai collegamenti di condivisione",
    "You don't have any upload links": "Non hai nessun link per il caricamento",
    "You have an unsaved draft. Do you like to use it?": "Hai una bozza non salvata. La vuoi utilizzare?",
    "You have not shared any folders": "Non hai condiviso alcuna cartella",
    "Your notifications will be sent to this email.": "Le tue notifiche verranno inviate a questa email.",
    "ZIP": "ZIP",
    "Zoom in": "Ingrandire",
    "Zoom out": "Rimpicciolire",
    "activate after registration": "attivare dopo la registrazione",
    "all": "tutto/i",
    "all members": "tutti i membri",
    "allow new registrations": "consentire nuove registrazioni",
    "days": "giorni",
    "download/upload link password minimum length": "la lunghezza minima della password relativa al link utilizzato per scaricare/caricare file",
    "draft": "bozza",
    "file": "file",
    "icon": "icona",
    "keep sign in": "rimani connesso",
    "library password minimum length": "lunghezza minima della password della libreria",
    "locked": "bloccato",
    "name": "nome",
    "password minimum length": "lunghezza minima della password",
    "password strength level": "livello di sicurezza della password",
    "progress": "avanzamento",
    "related files": "file correlati",
    "send activation email": "invia l'email di attivazione",
    "show more": "mostra di pi\u00f9",
    "starred": "preferiti",
    "state": "stato",
    "text file extensions": "estensioni dei file di testo",
    "to": "a",
    "unstarred": "non preferiti",
    "you can also press \u2190 ": "puoi anche digitare \u2190",
    "{placeholder} Folder Permission": "{placeholder} Permesso cartella"
  };
  for (var key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      var value = django.catalog[msgid];
      if (typeof(value) == 'undefined') {
        return msgid;
      } else {
        return (typeof(value) == 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      var value = django.catalog[singular];
      if (typeof(value) == 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value[django.pluralidx(count)];
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      var value = django.gettext(context + '\x04' + msgid);
      if (value.indexOf('\x04') != -1) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.indexOf('\x04') != -1) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "l d F Y H:i",
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S",
      "%d/%m/%Y %H:%M:%S.%f",
      "%d/%m/%Y %H:%M",
      "%d/%m/%Y",
      "%d/%m/%y %H:%M:%S",
      "%d/%m/%y %H:%M:%S.%f",
      "%d/%m/%y %H:%M",
      "%d/%m/%y",
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%Y-%m-%d",
      "%d-%m-%Y %H:%M:%S",
      "%d-%m-%Y %H:%M:%S.%f",
      "%d-%m-%Y %H:%M",
      "%d-%m-%Y",
      "%d-%m-%y %H:%M:%S",
      "%d-%m-%y %H:%M:%S.%f",
      "%d-%m-%y %H:%M",
      "%d-%m-%y"
    ],
    "DATE_FORMAT": "d F Y",
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y",
      "%Y/%m/%d",
      "%d-%m-%Y",
      "%Y-%m-%d",
      "%d-%m-%y",
      "%d/%m/%y"
    ],
    "DECIMAL_SEPARATOR": ",",
    "FIRST_DAY_OF_WEEK": "1",
    "MONTH_DAY_FORMAT": "j/F",
    "NUMBER_GROUPING": "3",
    "SHORT_DATETIME_FORMAT": "d/m/Y H:i",
    "SHORT_DATE_FORMAT": "d/m/Y",
    "THOUSAND_SEPARATOR": ".",
    "TIME_FORMAT": "H:i",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      var value = django.formats[format_type];
      if (typeof(value) == 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }

}(this));

