# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-03-21 08:43


import datetime
from django.db import migrations, models
import django.db.models.deletion
import seahub.base.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='GroupMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group_id', models.IntegerField(db_index=True)),
                ('from_email', seahub.base.fields.LowerCaseCharField(max_length=255)),
                ('message', models.TextField()),
                ('timestamp', models.DateTimeField(default=datetime.datetime.now)),
            ],
        ),
        migrations.CreateModel(
            name='MessageAttachment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('repo_id', models.CharField(max_length=40)),
                ('attach_type', models.CharField(max_length=5)),
                ('path', models.TextField()),
                ('src', models.CharField(max_length=20)),
                ('group_message', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.GroupMessage')),
            ],
        ),
        migrations.CreateModel(
            name='MessageReply',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_email', seahub.base.fields.LowerCaseCharField(max_length=255)),
                ('message', models.TextField()),
                ('timestamp', models.DateTimeField(default=datetime.datetime.now)),
                ('reply_to', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='group.GroupMessage')),
            ],
        ),
        migrations.CreateModel(
            name='PublicGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group_id', models.IntegerField(db_index=True)),
            ],
        ),
    ]
