# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-03-21 08:44


from django.db import migrations, models
import django.db.models.deletion
import seahub.base.fields
import seahub.two_factor.models.base
import seahub.two_factor.models.totp
import seahub.two_factor.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='PhoneDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', seahub.base.fields.LowerCaseCharField(help_text='The user that this device belongs to.', max_length=255, unique=True)),
                ('name', models.CharField(help_text='The human-readable name of this device.', max_length=64)),
                ('confirmed', models.BooleanField(default=True, help_text='Is this device ready for use?')),
                ('number', models.CharField(max_length=40)),
                ('key', models.CharField(default=seahub.two_factor.utils.random_hex, help_text='Hex-encoded secret key', max_length=40, validators=[seahub.two_factor.models.base.key_validator])),
                ('method', models.CharField(choices=[('call', 'Phone Call'), ('sms', 'Text Message')], max_length=4, verbose_name='Method')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StaticDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', seahub.base.fields.LowerCaseCharField(help_text='The user that this device belongs to.', max_length=255, unique=True)),
                ('name', models.CharField(help_text='The human-readable name of this device.', max_length=64)),
                ('confirmed', models.BooleanField(default=True, help_text='Is this device ready for use?')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StaticToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(db_index=True, max_length=16)),
                ('device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='token_set', to='two_factor.StaticDevice')),
            ],
        ),
        migrations.CreateModel(
            name='TOTPDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', seahub.base.fields.LowerCaseCharField(help_text='The user that this device belongs to.', max_length=255, unique=True)),
                ('name', models.CharField(help_text='The human-readable name of this device.', max_length=64)),
                ('confirmed', models.BooleanField(default=True, help_text='Is this device ready for use?')),
                ('key', models.CharField(default=seahub.two_factor.models.totp.default_key, help_text='A hex-encoded secret key of up to 40 bytes.', max_length=80, validators=[seahub.two_factor.models.totp.key_validator])),
                ('step', models.PositiveSmallIntegerField(default=30, help_text='The time step in seconds.')),
                ('t0', models.BigIntegerField(default=0, help_text='The Unix time at which to begin counting steps.')),
                ('digits', models.PositiveSmallIntegerField(choices=[(6, 6), (8, 8)], default=6, help_text='The number of digits to expect in a token.')),
                ('tolerance', models.PositiveSmallIntegerField(default=1, help_text='The number of time steps in the past or future to allow.')),
                ('drift', models.SmallIntegerField(default=0, help_text='The number of time steps the prover is known to deviate from our clock.')),
                ('last_t', models.BigIntegerField(default=-1, help_text='The t value of the latest verified token. The next token must be at a higher time step.')),
            ],
            options={
                'abstract': False,
                'verbose_name': 'TOTP device',
            },
        ),
    ]
