/* 
 * Copyright 2018-2020 The Regents of the University of California
 * All rights reserved.
 * 
 * This file is part of Spoofer.
 * 
 * Spoofer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Spoofer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Spoofer.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "spoof_qt.h"
#include <QAbstractSocket>
#include <QHostAddress>
#include "SubnetAddr.h"
#include "../../config.h"
static const char cvsid[] ATR_USED = "$Id: SubnetAddr.cpp,v 1.3 2020/07/16 19:23:40 kkeys Exp $";

SubnetAddr SubnetAddr::prefix() const
{
    if (addr().protocol() == QAbstractSocket::IPv4Protocol) {
	quint32 raw = addr().toIPv4Address();
	raw &= (0xFFFFFFFF << (32 - pfxlen()));
	return SubnetAddr(QHostAddress(raw), pfxlen());

    } else if (addr().protocol() == QAbstractSocket::IPv6Protocol) {
	Q_IPV6ADDR raw = addr().toIPv6Address();
	for (int i = 0, n = pfxlen(); i < 16; i++, n -= 8) {
	    if (n <= 0) {
		raw[i] = 0;
	    } else if (n < 8) {
		raw[i] = quint8(raw[i] & (~0xFFu >> n));
	    }
	}
	return SubnetAddr(QHostAddress(raw), pfxlen());
    } else {
	return SubnetAddr(QHostAddress(), 0);
    }
}

