/* 
 * Copyright 2016-2020 The Regents of the University of California
 * All rights reserved.
 * 
 * This file is part of Spoofer.
 * 
 * Spoofer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Spoofer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Spoofer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ACTIONBUTTON_H
#define ACTIONBUTTON_H

#include <QPushButton>
#include <QAction>
#include "port.h"

// Simple extension of QPushButton that allows a QAction to be attached such
// that clicking the button triggers the action, and the button's status is
// updated when the action's status changes.
// If an alternate action is set, the current and alternate actions will be
// swapped when the button is clicked.
class ActionButton : public QPushButton
{
    Q_OBJECT

private:
    QAction* action;
    QAction* alt;

    ActionButton(const ActionButton&) NO_METHOD; // no copy-ctor
    ActionButton operator=(const ActionButton&) NO_METHOD; // no copy-assign

public:
    explicit ActionButton(QAction *_action = nullptr, QAction *_alt = nullptr,
	QWidget *_parent = nullptr)
	: QPushButton(_parent), action(), alt()
	{ setAction(_action, _alt); }
    void setAction(QAction* action, QAction *alt = nullptr);
    void swap();

private slots:
    void updateStatus();
};

#endif // ACTIONBUTTON_H
