/* 
 * Copyright 2016-2020 The Regents of the University of California
 * All rights reserved.
 * 
 * This file is part of Spoofer.
 * 
 * Spoofer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Spoofer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Spoofer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef COLOREDLABEL_H
#define COLOREDLABEL_H

#include <QLabel>
#include "spoof_qt.h"

class ColoredLabel : public QLabel
{
    Q_OBJECT
    Q_PROPERTY(QColor bgcolor READ bgcolor WRITE setBgcolor)

public:
    ColoredLabel(QWidget *_parent = nullptr) : QLabel(_parent) {}
    ColoredLabel(const QString &_text, QWidget *_parent = nullptr) :
	QLabel(_text, _parent) {}
    void setBgcolor(QColor c) {
	// Note: an alpha value of "1" in rgba() is interpreted in the float
	// 0-1 scale where it means fully opaque, not the int 0-255 scale
	// where it would mean almost transparent.
	setStyleSheet(QSL("background-color: rgba(%1,%2,%3,%4);")
	    .arg(c.red()).arg(c.green()).arg(c.blue()).arg(c.alphaF()));
    }
    QColor bgcolor() {
	return Qt::black; // dummy
    }
};

#endif // COLOREDLABEL_H
