/* 
 * Copyright 2017-2020 The Regents of the University of California
 * All rights reserved.
 * 
 * This file is part of Spoofer.
 * 
 * Spoofer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Spoofer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Spoofer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DOWNLOADER_H
#define DOWNLOADER_H

#include <QString>
#include <QStringRef>
#include <QUrl>
#include "common.h"

QT_BEGIN_NAMESPACE
class QNetworkAccessManager;
class QNetworkReply;
class QFile;
class QTimer;
class QProcess;
QT_END_NAMESPACE

class Downloader : public QObject {
    Downloader(const Downloader&) NO_METHOD; // no copy-ctor
    Downloader operator=(const Downloader&) NO_METHOD; // no copy-assign
    Q_OBJECT

    const QUrl url; // URL of source
    const QString dir; // directory to write in
    QString destpath;
    QNetworkAccessManager *manager;
    QNetworkReply *reply;
    QTemporaryFile *tmp;
    QTimer *reqTimer;
    bool aborted;
    QString errorStr;
    qint64 total;
    QProcess *proc; // external download process
public:
    bool addTaint = true; // set Windows MOTW or OSX quarantine on the file?
    bool verifySig = true; // verify signature of the file?

    Downloader(QUrl _url, QString _dir, QObject *_parent = nullptr) :
	QObject(_parent), url(_url), dir(_dir), destpath(), manager(), reply(),
	tmp(), reqTimer(), aborted(false), errorStr(), total(), proc() {}

    void start();
    QString fileName() { return destpath; }
    QString errorString() { return errorStr; }
    qint64 byteCount() { return total; }

    void abort(const QString &str);
private:
    void finalize();

signals:
    void verifying();
    void finished();
    void error();

private slots:
    void replyRead();
    void replyError();
    void replyFinished();
    void timedout();
#ifdef Q_OS_MACOS
    void procStarted();
    void procError();
    void procFinished();
#endif
};

#endif // DOWNLOADER_H
