/* 
 * Copyright 2018-2022 The Regents of the University of California
 * All rights reserved.
 * 
 * This file is part of Spoofer.
 * 
 * Spoofer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Spoofer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Spoofer.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SUBNETADDR_H
#define SUBNETADDR_H

#include <QtGlobal>
#include <QString>
#include <QDebug>
#include "port.h"

class SubnetAddr : public QPair<QHostAddress,int> {
public:
    SubnetAddr(const QHostAddress &haddr, int len) : QPair(haddr, len) {}
    SubnetAddr(const QPair<QHostAddress,int> &pair) : QPair(pair) {}
    QHostAddress addr() const { return first; }
    int pfxlen() const { return second; }
    SubnetAddr prefix() const;
    QString toString() const {
	return addr().toString() % QSL("/") % QString::number(pfxlen());
    }
};

#endif // INPUTREADER_H
