/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Substitute the type names.  */
#define YYSTYPE         FILTER_EXPR_STYPE
#define YYLTYPE         FILTER_EXPR_LTYPE
/* Substitute the variable and function names.  */
#define yyparse         filter_expr_parse
#define yylex           filter_expr_lex
#define yyerror         filter_expr_error
#define yydebug         filter_expr_debug
#define yynerrs         filter_expr_nerrs


# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_FILTER_EXPR_LIB_FILTER_FILTER_EXPR_GRAMMAR_H_INCLUDED
# define YY_FILTER_EXPR_LIB_FILTER_FILTER_EXPR_GRAMMAR_H_INCLUDED
/* Debug traces.  */
#ifndef FILTER_EXPR_DEBUG
# if defined YYDEBUG
#if YYDEBUG
#   define FILTER_EXPR_DEBUG 1
#  else
#   define FILTER_EXPR_DEBUG 0
#  endif
# else /* ! defined YYDEBUG */
#  define FILTER_EXPR_DEBUG 0
# endif /* ! defined YYDEBUG */
#endif  /* ! defined FILTER_EXPR_DEBUG */
#if FILTER_EXPR_DEBUG
extern int filter_expr_debug;
#endif
/* "%code requires" blocks.  */
#line 25 "lib/filter/filter-expr-grammar.y"


#include "filter/filter-expr-parser.h"


#line 125 "lib/filter/filter-expr-grammar.c"

/* Token kinds.  */
#ifndef FILTER_EXPR_TOKENTYPE
# define FILTER_EXPR_TOKENTYPE
  enum filter_expr_tokentype
  {
    FILTER_EXPR_EMPTY = -2,
    FILTER_EXPR_EOF = 0,           /* "end of file"  */
    FILTER_EXPR_error = 256,       /* error  */
    FILTER_EXPR_UNDEF = 10523,     /* "invalid token"  */
    LL_CONTEXT_ROOT = 1,           /* LL_CONTEXT_ROOT  */
    LL_CONTEXT_DESTINATION = 2,    /* LL_CONTEXT_DESTINATION  */
    LL_CONTEXT_SOURCE = 3,         /* LL_CONTEXT_SOURCE  */
    LL_CONTEXT_PARSER = 4,         /* LL_CONTEXT_PARSER  */
    LL_CONTEXT_REWRITE = 5,        /* LL_CONTEXT_REWRITE  */
    LL_CONTEXT_FILTER = 6,         /* LL_CONTEXT_FILTER  */
    LL_CONTEXT_LOG = 7,            /* LL_CONTEXT_LOG  */
    LL_CONTEXT_BLOCK_DEF = 8,      /* LL_CONTEXT_BLOCK_DEF  */
    LL_CONTEXT_BLOCK_REF = 9,      /* LL_CONTEXT_BLOCK_REF  */
    LL_CONTEXT_BLOCK_CONTENT = 10, /* LL_CONTEXT_BLOCK_CONTENT  */
    LL_CONTEXT_BLOCK_ARG = 11,     /* LL_CONTEXT_BLOCK_ARG  */
    LL_CONTEXT_PRAGMA = 12,        /* LL_CONTEXT_PRAGMA  */
    LL_CONTEXT_FORMAT = 13,        /* LL_CONTEXT_FORMAT  */
    LL_CONTEXT_TEMPLATE_FUNC = 14, /* LL_CONTEXT_TEMPLATE_FUNC  */
    LL_CONTEXT_INNER_DEST = 15,    /* LL_CONTEXT_INNER_DEST  */
    LL_CONTEXT_INNER_SRC = 16,     /* LL_CONTEXT_INNER_SRC  */
    LL_CONTEXT_CLIENT_PROTO = 17,  /* LL_CONTEXT_CLIENT_PROTO  */
    LL_CONTEXT_SERVER_PROTO = 18,  /* LL_CONTEXT_SERVER_PROTO  */
    LL_CONTEXT_OPTIONS = 19,       /* LL_CONTEXT_OPTIONS  */
    LL_CONTEXT_CONFIG = 20,        /* LL_CONTEXT_CONFIG  */
    LL_CONTEXT_MAX = 21,           /* LL_CONTEXT_MAX  */
    KW_SOURCE = 10000,             /* KW_SOURCE  */
    KW_FILTER = 10001,             /* KW_FILTER  */
    KW_PARSER = 10002,             /* KW_PARSER  */
    KW_DESTINATION = 10003,        /* KW_DESTINATION  */
    KW_LOG = 10004,                /* KW_LOG  */
    KW_OPTIONS = 10005,            /* KW_OPTIONS  */
    KW_INCLUDE = 10006,            /* KW_INCLUDE  */
    KW_BLOCK = 10007,              /* KW_BLOCK  */
    KW_JUNCTION = 10008,           /* KW_JUNCTION  */
    KW_CHANNEL = 10009,            /* KW_CHANNEL  */
    KW_IF = 10010,                 /* KW_IF  */
    KW_ELSE = 10011,               /* KW_ELSE  */
    KW_ELIF = 10012,               /* KW_ELIF  */
    KW_INTERNAL = 10020,           /* KW_INTERNAL  */
    KW_SYSLOG = 10060,             /* KW_SYSLOG  */
    KW_MARK_FREQ = 10071,          /* KW_MARK_FREQ  */
    KW_STATS_FREQ = 10072,         /* KW_STATS_FREQ  */
    KW_STATS_LEVEL = 10073,        /* KW_STATS_LEVEL  */
    KW_STATS_LIFETIME = 10074,     /* KW_STATS_LIFETIME  */
    KW_FLUSH_LINES = 10075,        /* KW_FLUSH_LINES  */
    KW_SUPPRESS = 10076,           /* KW_SUPPRESS  */
    KW_FLUSH_TIMEOUT = 10077,      /* KW_FLUSH_TIMEOUT  */
    KW_LOG_MSG_SIZE = 10078,       /* KW_LOG_MSG_SIZE  */
    KW_FILE_TEMPLATE = 10079,      /* KW_FILE_TEMPLATE  */
    KW_PROTO_TEMPLATE = 10080,     /* KW_PROTO_TEMPLATE  */
    KW_MARK_MODE = 10081,          /* KW_MARK_MODE  */
    KW_ENCODING = 10082,           /* KW_ENCODING  */
    KW_TYPE = 10083,               /* KW_TYPE  */
    KW_STATS_MAX_DYNAMIC = 10084,  /* KW_STATS_MAX_DYNAMIC  */
    KW_MIN_IW_SIZE_PER_READER = 10085, /* KW_MIN_IW_SIZE_PER_READER  */
    KW_WORKERS = 10086,            /* KW_WORKERS  */
    KW_BATCH_LINES = 10087,        /* KW_BATCH_LINES  */
    KW_BATCH_TIMEOUT = 10088,      /* KW_BATCH_TIMEOUT  */
    KW_TRIM_LARGE_MESSAGES = 10089, /* KW_TRIM_LARGE_MESSAGES  */
    KW_STATS = 10400,              /* KW_STATS  */
    KW_FREQ = 10401,               /* KW_FREQ  */
    KW_LEVEL = 10402,              /* KW_LEVEL  */
    KW_LIFETIME = 10403,           /* KW_LIFETIME  */
    KW_MAX_DYNAMIC = 10404,        /* KW_MAX_DYNAMIC  */
    KW_SYSLOG_STATS = 10405,       /* KW_SYSLOG_STATS  */
    KW_CHAIN_HOSTNAMES = 10090,    /* KW_CHAIN_HOSTNAMES  */
    KW_NORMALIZE_HOSTNAMES = 10091, /* KW_NORMALIZE_HOSTNAMES  */
    KW_KEEP_HOSTNAME = 10092,      /* KW_KEEP_HOSTNAME  */
    KW_CHECK_HOSTNAME = 10093,     /* KW_CHECK_HOSTNAME  */
    KW_BAD_HOSTNAME = 10094,       /* KW_BAD_HOSTNAME  */
    KW_LOG_LEVEL = 10095,          /* KW_LOG_LEVEL  */
    KW_KEEP_TIMESTAMP = 10100,     /* KW_KEEP_TIMESTAMP  */
    KW_USE_DNS = 10110,            /* KW_USE_DNS  */
    KW_USE_FQDN = 10111,           /* KW_USE_FQDN  */
    KW_CUSTOM_DOMAIN = 10112,      /* KW_CUSTOM_DOMAIN  */
    KW_DNS_CACHE = 10120,          /* KW_DNS_CACHE  */
    KW_DNS_CACHE_SIZE = 10121,     /* KW_DNS_CACHE_SIZE  */
    KW_DNS_CACHE_EXPIRE = 10130,   /* KW_DNS_CACHE_EXPIRE  */
    KW_DNS_CACHE_EXPIRE_FAILED = 10131, /* KW_DNS_CACHE_EXPIRE_FAILED  */
    KW_DNS_CACHE_HOSTS = 10132,    /* KW_DNS_CACHE_HOSTS  */
    KW_PERSIST_ONLY = 10140,       /* KW_PERSIST_ONLY  */
    KW_USE_RCPTID = 10141,         /* KW_USE_RCPTID  */
    KW_USE_UNIQID = 10142,         /* KW_USE_UNIQID  */
    KW_TZ_CONVERT = 10150,         /* KW_TZ_CONVERT  */
    KW_TS_FORMAT = 10151,          /* KW_TS_FORMAT  */
    KW_FRAC_DIGITS = 10152,        /* KW_FRAC_DIGITS  */
    KW_LOG_FIFO_SIZE = 10160,      /* KW_LOG_FIFO_SIZE  */
    KW_LOG_FETCH_LIMIT = 10162,    /* KW_LOG_FETCH_LIMIT  */
    KW_LOG_IW_SIZE = 10163,        /* KW_LOG_IW_SIZE  */
    KW_LOG_PREFIX = 10164,         /* KW_LOG_PREFIX  */
    KW_PROGRAM_OVERRIDE = 10165,   /* KW_PROGRAM_OVERRIDE  */
    KW_HOST_OVERRIDE = 10166,      /* KW_HOST_OVERRIDE  */
    KW_THROTTLE = 10170,           /* KW_THROTTLE  */
    KW_THREADED = 10171,           /* KW_THREADED  */
    KW_PASS_UNIX_CREDENTIALS = 10180, /* KW_PASS_UNIX_CREDENTIALS  */
    KW_PERSIST_NAME = 10181,       /* KW_PERSIST_NAME  */
    KW_READ_OLD_RECORDS = 10182,   /* KW_READ_OLD_RECORDS  */
    KW_USE_SYSLOGNG_PID = 10183,   /* KW_USE_SYSLOGNG_PID  */
    KW_FLAGS = 10190,              /* KW_FLAGS  */
    KW_PAD_SIZE = 10200,           /* KW_PAD_SIZE  */
    KW_TIME_ZONE = 10201,          /* KW_TIME_ZONE  */
    KW_RECV_TIME_ZONE = 10202,     /* KW_RECV_TIME_ZONE  */
    KW_SEND_TIME_ZONE = 10203,     /* KW_SEND_TIME_ZONE  */
    KW_LOCAL_TIME_ZONE = 10204,    /* KW_LOCAL_TIME_ZONE  */
    KW_FORMAT = 10205,             /* KW_FORMAT  */
    KW_TRUNCATE_SIZE = 10206,      /* KW_TRUNCATE_SIZE  */
    KW_TIME_REOPEN = 10210,        /* KW_TIME_REOPEN  */
    KW_TIME_REAP = 10211,          /* KW_TIME_REAP  */
    KW_TIME_SLEEP = 10212,         /* KW_TIME_SLEEP  */
    KW_TMPL_ESCAPE = 10220,        /* KW_TMPL_ESCAPE  */
    KW_OPTIONAL = 10230,           /* KW_OPTIONAL  */
    KW_CREATE_DIRS = 10240,        /* KW_CREATE_DIRS  */
    KW_OWNER = 10250,              /* KW_OWNER  */
    KW_GROUP = 10251,              /* KW_GROUP  */
    KW_PERM = 10252,               /* KW_PERM  */
    KW_DIR_OWNER = 10260,          /* KW_DIR_OWNER  */
    KW_DIR_GROUP = 10261,          /* KW_DIR_GROUP  */
    KW_DIR_PERM = 10262,           /* KW_DIR_PERM  */
    KW_TEMPLATE = 10270,           /* KW_TEMPLATE  */
    KW_TEMPLATE_ESCAPE = 10271,    /* KW_TEMPLATE_ESCAPE  */
    KW_TEMPLATE_FUNCTION = 10272,  /* KW_TEMPLATE_FUNCTION  */
    KW_DEFAULT_FACILITY = 10300,   /* KW_DEFAULT_FACILITY  */
    KW_DEFAULT_SEVERITY = 10301,   /* KW_DEFAULT_SEVERITY  */
    KW_SDATA_PREFIX = 10302,       /* KW_SDATA_PREFIX  */
    KW_PORT = 10323,               /* KW_PORT  */
    KW_USE_TIME_RECVD = 10340,     /* KW_USE_TIME_RECVD  */
    KW_FACILITY = 10350,           /* KW_FACILITY  */
    KW_SEVERITY = 10351,           /* KW_SEVERITY  */
    KW_HOST = 10352,               /* KW_HOST  */
    KW_MATCH = 10353,              /* KW_MATCH  */
    KW_MESSAGE = 10354,            /* KW_MESSAGE  */
    KW_NETMASK = 10355,            /* KW_NETMASK  */
    KW_TAGS = 10356,               /* KW_TAGS  */
    KW_NETMASK6 = 10357,           /* KW_NETMASK6  */
    KW_REWRITE = 10370,            /* KW_REWRITE  */
    KW_CONDITION = 10371,          /* KW_CONDITION  */
    KW_VALUE = 10372,              /* KW_VALUE  */
    KW_YES = 10380,                /* KW_YES  */
    KW_NO = 10381,                 /* KW_NO  */
    KW_AUTO = 10382,               /* KW_AUTO  */
    KW_IFDEF = 10410,              /* KW_IFDEF  */
    KW_ENDIF = 10411,              /* KW_ENDIF  */
    LL_DOTDOT = 10420,             /* LL_DOTDOT  */
    LL_DOTDOTDOT = 10421,          /* LL_DOTDOTDOT  */
    LL_PRAGMA = 10422,             /* LL_PRAGMA  */
    LL_EOL = 10423,                /* LL_EOL  */
    LL_ERROR = 10424,              /* LL_ERROR  */
    LL_ARROW = 10425,              /* LL_ARROW  */
    LL_IDENTIFIER = 10430,         /* LL_IDENTIFIER  */
    LL_NUMBER = 10431,             /* LL_NUMBER  */
    LL_FLOAT = 10432,              /* LL_FLOAT  */
    LL_STRING = 10433,             /* LL_STRING  */
    LL_TOKEN = 10434,              /* LL_TOKEN  */
    LL_BLOCK = 10435,              /* LL_BLOCK  */
    LL_PLUGIN = 10436,             /* LL_PLUGIN  */
    KW_VALUE_PAIRS = 10500,        /* KW_VALUE_PAIRS  */
    KW_EXCLUDE = 10502,            /* KW_EXCLUDE  */
    KW_PAIR = 10503,               /* KW_PAIR  */
    KW_KEY = 10504,                /* KW_KEY  */
    KW_SCOPE = 10505,              /* KW_SCOPE  */
    KW_SHIFT = 10506,              /* KW_SHIFT  */
    KW_SHIFT_LEVELS = 10507,       /* KW_SHIFT_LEVELS  */
    KW_REKEY = 10508,              /* KW_REKEY  */
    KW_ADD_PREFIX = 10509,         /* KW_ADD_PREFIX  */
    KW_REPLACE_PREFIX = 10510,     /* KW_REPLACE_PREFIX  */
    KW_CAST = 10511,               /* KW_CAST  */
    KW_ON_ERROR = 10520,           /* KW_ON_ERROR  */
    KW_RETRIES = 10521,            /* KW_RETRIES  */
    KW_FETCH_NO_DATA_DELAY = 10522, /* KW_FETCH_NO_DATA_DELAY  */
    KW_PROGRAM = 10524,            /* KW_PROGRAM  */
    KW_IN_LIST = 10525,            /* KW_IN_LIST  */
    KW_OR = 10526,                 /* KW_OR  */
    KW_AND = 10527,                /* KW_AND  */
    KW_NOT = 10528,                /* KW_NOT  */
    KW_STR_LT = 10529,             /* KW_STR_LT  */
    KW_STR_LE = 10530,             /* KW_STR_LE  */
    KW_STR_EQ = 10531,             /* KW_STR_EQ  */
    KW_STR_NE = 10532,             /* KW_STR_NE  */
    KW_STR_GE = 10533,             /* KW_STR_GE  */
    KW_STR_GT = 10534,             /* KW_STR_GT  */
    KW_TA_LT = 10535,              /* KW_TA_LT  */
    KW_TA_LE = 10536,              /* KW_TA_LE  */
    KW_TA_EQ = 10537,              /* KW_TA_EQ  */
    KW_TA_NE = 10538,              /* KW_TA_NE  */
    KW_TA_GE = 10539,              /* KW_TA_GE  */
    KW_TA_GT = 10540,              /* KW_TA_GT  */
    KW_TAV_EQ = 10541,             /* KW_TAV_EQ  */
    KW_TAV_NE = 10542              /* KW_TAV_NE  */
  };
  typedef enum filter_expr_tokentype filter_expr_token_kind_t;
#endif
/* Token kinds.  */
#define FILTER_EXPR_EMPTY -2
#define FILTER_EXPR_EOF 0
#define FILTER_EXPR_error 256
#define FILTER_EXPR_UNDEF 10523
#define LL_CONTEXT_ROOT 1
#define LL_CONTEXT_DESTINATION 2
#define LL_CONTEXT_SOURCE 3
#define LL_CONTEXT_PARSER 4
#define LL_CONTEXT_REWRITE 5
#define LL_CONTEXT_FILTER 6
#define LL_CONTEXT_LOG 7
#define LL_CONTEXT_BLOCK_DEF 8
#define LL_CONTEXT_BLOCK_REF 9
#define LL_CONTEXT_BLOCK_CONTENT 10
#define LL_CONTEXT_BLOCK_ARG 11
#define LL_CONTEXT_PRAGMA 12
#define LL_CONTEXT_FORMAT 13
#define LL_CONTEXT_TEMPLATE_FUNC 14
#define LL_CONTEXT_INNER_DEST 15
#define LL_CONTEXT_INNER_SRC 16
#define LL_CONTEXT_CLIENT_PROTO 17
#define LL_CONTEXT_SERVER_PROTO 18
#define LL_CONTEXT_OPTIONS 19
#define LL_CONTEXT_CONFIG 20
#define LL_CONTEXT_MAX 21
#define KW_SOURCE 10000
#define KW_FILTER 10001
#define KW_PARSER 10002
#define KW_DESTINATION 10003
#define KW_LOG 10004
#define KW_OPTIONS 10005
#define KW_INCLUDE 10006
#define KW_BLOCK 10007
#define KW_JUNCTION 10008
#define KW_CHANNEL 10009
#define KW_IF 10010
#define KW_ELSE 10011
#define KW_ELIF 10012
#define KW_INTERNAL 10020
#define KW_SYSLOG 10060
#define KW_MARK_FREQ 10071
#define KW_STATS_FREQ 10072
#define KW_STATS_LEVEL 10073
#define KW_STATS_LIFETIME 10074
#define KW_FLUSH_LINES 10075
#define KW_SUPPRESS 10076
#define KW_FLUSH_TIMEOUT 10077
#define KW_LOG_MSG_SIZE 10078
#define KW_FILE_TEMPLATE 10079
#define KW_PROTO_TEMPLATE 10080
#define KW_MARK_MODE 10081
#define KW_ENCODING 10082
#define KW_TYPE 10083
#define KW_STATS_MAX_DYNAMIC 10084
#define KW_MIN_IW_SIZE_PER_READER 10085
#define KW_WORKERS 10086
#define KW_BATCH_LINES 10087
#define KW_BATCH_TIMEOUT 10088
#define KW_TRIM_LARGE_MESSAGES 10089
#define KW_STATS 10400
#define KW_FREQ 10401
#define KW_LEVEL 10402
#define KW_LIFETIME 10403
#define KW_MAX_DYNAMIC 10404
#define KW_SYSLOG_STATS 10405
#define KW_CHAIN_HOSTNAMES 10090
#define KW_NORMALIZE_HOSTNAMES 10091
#define KW_KEEP_HOSTNAME 10092
#define KW_CHECK_HOSTNAME 10093
#define KW_BAD_HOSTNAME 10094
#define KW_LOG_LEVEL 10095
#define KW_KEEP_TIMESTAMP 10100
#define KW_USE_DNS 10110
#define KW_USE_FQDN 10111
#define KW_CUSTOM_DOMAIN 10112
#define KW_DNS_CACHE 10120
#define KW_DNS_CACHE_SIZE 10121
#define KW_DNS_CACHE_EXPIRE 10130
#define KW_DNS_CACHE_EXPIRE_FAILED 10131
#define KW_DNS_CACHE_HOSTS 10132
#define KW_PERSIST_ONLY 10140
#define KW_USE_RCPTID 10141
#define KW_USE_UNIQID 10142
#define KW_TZ_CONVERT 10150
#define KW_TS_FORMAT 10151
#define KW_FRAC_DIGITS 10152
#define KW_LOG_FIFO_SIZE 10160
#define KW_LOG_FETCH_LIMIT 10162
#define KW_LOG_IW_SIZE 10163
#define KW_LOG_PREFIX 10164
#define KW_PROGRAM_OVERRIDE 10165
#define KW_HOST_OVERRIDE 10166
#define KW_THROTTLE 10170
#define KW_THREADED 10171
#define KW_PASS_UNIX_CREDENTIALS 10180
#define KW_PERSIST_NAME 10181
#define KW_READ_OLD_RECORDS 10182
#define KW_USE_SYSLOGNG_PID 10183
#define KW_FLAGS 10190
#define KW_PAD_SIZE 10200
#define KW_TIME_ZONE 10201
#define KW_RECV_TIME_ZONE 10202
#define KW_SEND_TIME_ZONE 10203
#define KW_LOCAL_TIME_ZONE 10204
#define KW_FORMAT 10205
#define KW_TRUNCATE_SIZE 10206
#define KW_TIME_REOPEN 10210
#define KW_TIME_REAP 10211
#define KW_TIME_SLEEP 10212
#define KW_TMPL_ESCAPE 10220
#define KW_OPTIONAL 10230
#define KW_CREATE_DIRS 10240
#define KW_OWNER 10250
#define KW_GROUP 10251
#define KW_PERM 10252
#define KW_DIR_OWNER 10260
#define KW_DIR_GROUP 10261
#define KW_DIR_PERM 10262
#define KW_TEMPLATE 10270
#define KW_TEMPLATE_ESCAPE 10271
#define KW_TEMPLATE_FUNCTION 10272
#define KW_DEFAULT_FACILITY 10300
#define KW_DEFAULT_SEVERITY 10301
#define KW_SDATA_PREFIX 10302
#define KW_PORT 10323
#define KW_USE_TIME_RECVD 10340
#define KW_FACILITY 10350
#define KW_SEVERITY 10351
#define KW_HOST 10352
#define KW_MATCH 10353
#define KW_MESSAGE 10354
#define KW_NETMASK 10355
#define KW_TAGS 10356
#define KW_NETMASK6 10357
#define KW_REWRITE 10370
#define KW_CONDITION 10371
#define KW_VALUE 10372
#define KW_YES 10380
#define KW_NO 10381
#define KW_AUTO 10382
#define KW_IFDEF 10410
#define KW_ENDIF 10411
#define LL_DOTDOT 10420
#define LL_DOTDOTDOT 10421
#define LL_PRAGMA 10422
#define LL_EOL 10423
#define LL_ERROR 10424
#define LL_ARROW 10425
#define LL_IDENTIFIER 10430
#define LL_NUMBER 10431
#define LL_FLOAT 10432
#define LL_STRING 10433
#define LL_TOKEN 10434
#define LL_BLOCK 10435
#define LL_PLUGIN 10436
#define KW_VALUE_PAIRS 10500
#define KW_EXCLUDE 10502
#define KW_PAIR 10503
#define KW_KEY 10504
#define KW_SCOPE 10505
#define KW_SHIFT 10506
#define KW_SHIFT_LEVELS 10507
#define KW_REKEY 10508
#define KW_ADD_PREFIX 10509
#define KW_REPLACE_PREFIX 10510
#define KW_CAST 10511
#define KW_ON_ERROR 10520
#define KW_RETRIES 10521
#define KW_FETCH_NO_DATA_DELAY 10522
#define KW_PROGRAM 10524
#define KW_IN_LIST 10525
#define KW_OR 10526
#define KW_AND 10527
#define KW_NOT 10528
#define KW_STR_LT 10529
#define KW_STR_LE 10530
#define KW_STR_EQ 10531
#define KW_STR_NE 10532
#define KW_STR_GE 10533
#define KW_STR_GT 10534
#define KW_TA_LT 10535
#define KW_TA_LE 10536
#define KW_TA_EQ 10537
#define KW_TA_NE 10538
#define KW_TA_GE 10539
#define KW_TA_GT 10540
#define KW_TAV_EQ 10541
#define KW_TAV_NE 10542

/* Value type.  */
#if ! defined FILTER_EXPR_STYPE && ! defined FILTER_EXPR_STYPE_IS_DECLARED
typedef CFG_STYPE FILTER_EXPR_STYPE;
# define FILTER_EXPR_STYPE_IS_TRIVIAL 1
# define FILTER_EXPR_STYPE_IS_DECLARED 1
#endif

/* Location type.  */
typedef CFG_LTYPE FILTER_EXPR_LTYPE;




int filter_expr_parse (CfgLexer *lexer, FilterExprNode **result, gpointer arg);


#endif /* !YY_FILTER_EXPR_LIB_FILTER_FILTER_EXPR_GRAMMAR_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_LL_CONTEXT_ROOT = 3,            /* LL_CONTEXT_ROOT  */
  YYSYMBOL_LL_CONTEXT_DESTINATION = 4,     /* LL_CONTEXT_DESTINATION  */
  YYSYMBOL_LL_CONTEXT_SOURCE = 5,          /* LL_CONTEXT_SOURCE  */
  YYSYMBOL_LL_CONTEXT_PARSER = 6,          /* LL_CONTEXT_PARSER  */
  YYSYMBOL_LL_CONTEXT_REWRITE = 7,         /* LL_CONTEXT_REWRITE  */
  YYSYMBOL_LL_CONTEXT_FILTER = 8,          /* LL_CONTEXT_FILTER  */
  YYSYMBOL_LL_CONTEXT_LOG = 9,             /* LL_CONTEXT_LOG  */
  YYSYMBOL_LL_CONTEXT_BLOCK_DEF = 10,      /* LL_CONTEXT_BLOCK_DEF  */
  YYSYMBOL_LL_CONTEXT_BLOCK_REF = 11,      /* LL_CONTEXT_BLOCK_REF  */
  YYSYMBOL_LL_CONTEXT_BLOCK_CONTENT = 12,  /* LL_CONTEXT_BLOCK_CONTENT  */
  YYSYMBOL_LL_CONTEXT_BLOCK_ARG = 13,      /* LL_CONTEXT_BLOCK_ARG  */
  YYSYMBOL_LL_CONTEXT_PRAGMA = 14,         /* LL_CONTEXT_PRAGMA  */
  YYSYMBOL_LL_CONTEXT_FORMAT = 15,         /* LL_CONTEXT_FORMAT  */
  YYSYMBOL_LL_CONTEXT_TEMPLATE_FUNC = 16,  /* LL_CONTEXT_TEMPLATE_FUNC  */
  YYSYMBOL_LL_CONTEXT_INNER_DEST = 17,     /* LL_CONTEXT_INNER_DEST  */
  YYSYMBOL_LL_CONTEXT_INNER_SRC = 18,      /* LL_CONTEXT_INNER_SRC  */
  YYSYMBOL_LL_CONTEXT_CLIENT_PROTO = 19,   /* LL_CONTEXT_CLIENT_PROTO  */
  YYSYMBOL_LL_CONTEXT_SERVER_PROTO = 20,   /* LL_CONTEXT_SERVER_PROTO  */
  YYSYMBOL_LL_CONTEXT_OPTIONS = 21,        /* LL_CONTEXT_OPTIONS  */
  YYSYMBOL_LL_CONTEXT_CONFIG = 22,         /* LL_CONTEXT_CONFIG  */
  YYSYMBOL_LL_CONTEXT_MAX = 23,            /* LL_CONTEXT_MAX  */
  YYSYMBOL_KW_SOURCE = 24,                 /* KW_SOURCE  */
  YYSYMBOL_KW_FILTER = 25,                 /* KW_FILTER  */
  YYSYMBOL_KW_PARSER = 26,                 /* KW_PARSER  */
  YYSYMBOL_KW_DESTINATION = 27,            /* KW_DESTINATION  */
  YYSYMBOL_KW_LOG = 28,                    /* KW_LOG  */
  YYSYMBOL_KW_OPTIONS = 29,                /* KW_OPTIONS  */
  YYSYMBOL_KW_INCLUDE = 30,                /* KW_INCLUDE  */
  YYSYMBOL_KW_BLOCK = 31,                  /* KW_BLOCK  */
  YYSYMBOL_KW_JUNCTION = 32,               /* KW_JUNCTION  */
  YYSYMBOL_KW_CHANNEL = 33,                /* KW_CHANNEL  */
  YYSYMBOL_KW_IF = 34,                     /* KW_IF  */
  YYSYMBOL_KW_ELSE = 35,                   /* KW_ELSE  */
  YYSYMBOL_KW_ELIF = 36,                   /* KW_ELIF  */
  YYSYMBOL_KW_INTERNAL = 37,               /* KW_INTERNAL  */
  YYSYMBOL_KW_SYSLOG = 38,                 /* KW_SYSLOG  */
  YYSYMBOL_KW_MARK_FREQ = 39,              /* KW_MARK_FREQ  */
  YYSYMBOL_KW_STATS_FREQ = 40,             /* KW_STATS_FREQ  */
  YYSYMBOL_KW_STATS_LEVEL = 41,            /* KW_STATS_LEVEL  */
  YYSYMBOL_KW_STATS_LIFETIME = 42,         /* KW_STATS_LIFETIME  */
  YYSYMBOL_KW_FLUSH_LINES = 43,            /* KW_FLUSH_LINES  */
  YYSYMBOL_KW_SUPPRESS = 44,               /* KW_SUPPRESS  */
  YYSYMBOL_KW_FLUSH_TIMEOUT = 45,          /* KW_FLUSH_TIMEOUT  */
  YYSYMBOL_KW_LOG_MSG_SIZE = 46,           /* KW_LOG_MSG_SIZE  */
  YYSYMBOL_KW_FILE_TEMPLATE = 47,          /* KW_FILE_TEMPLATE  */
  YYSYMBOL_KW_PROTO_TEMPLATE = 48,         /* KW_PROTO_TEMPLATE  */
  YYSYMBOL_KW_MARK_MODE = 49,              /* KW_MARK_MODE  */
  YYSYMBOL_KW_ENCODING = 50,               /* KW_ENCODING  */
  YYSYMBOL_KW_TYPE = 51,                   /* KW_TYPE  */
  YYSYMBOL_KW_STATS_MAX_DYNAMIC = 52,      /* KW_STATS_MAX_DYNAMIC  */
  YYSYMBOL_KW_MIN_IW_SIZE_PER_READER = 53, /* KW_MIN_IW_SIZE_PER_READER  */
  YYSYMBOL_KW_WORKERS = 54,                /* KW_WORKERS  */
  YYSYMBOL_KW_BATCH_LINES = 55,            /* KW_BATCH_LINES  */
  YYSYMBOL_KW_BATCH_TIMEOUT = 56,          /* KW_BATCH_TIMEOUT  */
  YYSYMBOL_KW_TRIM_LARGE_MESSAGES = 57,    /* KW_TRIM_LARGE_MESSAGES  */
  YYSYMBOL_KW_STATS = 58,                  /* KW_STATS  */
  YYSYMBOL_KW_FREQ = 59,                   /* KW_FREQ  */
  YYSYMBOL_KW_LEVEL = 60,                  /* KW_LEVEL  */
  YYSYMBOL_KW_LIFETIME = 61,               /* KW_LIFETIME  */
  YYSYMBOL_KW_MAX_DYNAMIC = 62,            /* KW_MAX_DYNAMIC  */
  YYSYMBOL_KW_SYSLOG_STATS = 63,           /* KW_SYSLOG_STATS  */
  YYSYMBOL_KW_CHAIN_HOSTNAMES = 64,        /* KW_CHAIN_HOSTNAMES  */
  YYSYMBOL_KW_NORMALIZE_HOSTNAMES = 65,    /* KW_NORMALIZE_HOSTNAMES  */
  YYSYMBOL_KW_KEEP_HOSTNAME = 66,          /* KW_KEEP_HOSTNAME  */
  YYSYMBOL_KW_CHECK_HOSTNAME = 67,         /* KW_CHECK_HOSTNAME  */
  YYSYMBOL_KW_BAD_HOSTNAME = 68,           /* KW_BAD_HOSTNAME  */
  YYSYMBOL_KW_LOG_LEVEL = 69,              /* KW_LOG_LEVEL  */
  YYSYMBOL_KW_KEEP_TIMESTAMP = 70,         /* KW_KEEP_TIMESTAMP  */
  YYSYMBOL_KW_USE_DNS = 71,                /* KW_USE_DNS  */
  YYSYMBOL_KW_USE_FQDN = 72,               /* KW_USE_FQDN  */
  YYSYMBOL_KW_CUSTOM_DOMAIN = 73,          /* KW_CUSTOM_DOMAIN  */
  YYSYMBOL_KW_DNS_CACHE = 74,              /* KW_DNS_CACHE  */
  YYSYMBOL_KW_DNS_CACHE_SIZE = 75,         /* KW_DNS_CACHE_SIZE  */
  YYSYMBOL_KW_DNS_CACHE_EXPIRE = 76,       /* KW_DNS_CACHE_EXPIRE  */
  YYSYMBOL_KW_DNS_CACHE_EXPIRE_FAILED = 77, /* KW_DNS_CACHE_EXPIRE_FAILED  */
  YYSYMBOL_KW_DNS_CACHE_HOSTS = 78,        /* KW_DNS_CACHE_HOSTS  */
  YYSYMBOL_KW_PERSIST_ONLY = 79,           /* KW_PERSIST_ONLY  */
  YYSYMBOL_KW_USE_RCPTID = 80,             /* KW_USE_RCPTID  */
  YYSYMBOL_KW_USE_UNIQID = 81,             /* KW_USE_UNIQID  */
  YYSYMBOL_KW_TZ_CONVERT = 82,             /* KW_TZ_CONVERT  */
  YYSYMBOL_KW_TS_FORMAT = 83,              /* KW_TS_FORMAT  */
  YYSYMBOL_KW_FRAC_DIGITS = 84,            /* KW_FRAC_DIGITS  */
  YYSYMBOL_KW_LOG_FIFO_SIZE = 85,          /* KW_LOG_FIFO_SIZE  */
  YYSYMBOL_KW_LOG_FETCH_LIMIT = 86,        /* KW_LOG_FETCH_LIMIT  */
  YYSYMBOL_KW_LOG_IW_SIZE = 87,            /* KW_LOG_IW_SIZE  */
  YYSYMBOL_KW_LOG_PREFIX = 88,             /* KW_LOG_PREFIX  */
  YYSYMBOL_KW_PROGRAM_OVERRIDE = 89,       /* KW_PROGRAM_OVERRIDE  */
  YYSYMBOL_KW_HOST_OVERRIDE = 90,          /* KW_HOST_OVERRIDE  */
  YYSYMBOL_KW_THROTTLE = 91,               /* KW_THROTTLE  */
  YYSYMBOL_KW_THREADED = 92,               /* KW_THREADED  */
  YYSYMBOL_KW_PASS_UNIX_CREDENTIALS = 93,  /* KW_PASS_UNIX_CREDENTIALS  */
  YYSYMBOL_KW_PERSIST_NAME = 94,           /* KW_PERSIST_NAME  */
  YYSYMBOL_KW_READ_OLD_RECORDS = 95,       /* KW_READ_OLD_RECORDS  */
  YYSYMBOL_KW_USE_SYSLOGNG_PID = 96,       /* KW_USE_SYSLOGNG_PID  */
  YYSYMBOL_KW_FLAGS = 97,                  /* KW_FLAGS  */
  YYSYMBOL_KW_PAD_SIZE = 98,               /* KW_PAD_SIZE  */
  YYSYMBOL_KW_TIME_ZONE = 99,              /* KW_TIME_ZONE  */
  YYSYMBOL_KW_RECV_TIME_ZONE = 100,        /* KW_RECV_TIME_ZONE  */
  YYSYMBOL_KW_SEND_TIME_ZONE = 101,        /* KW_SEND_TIME_ZONE  */
  YYSYMBOL_KW_LOCAL_TIME_ZONE = 102,       /* KW_LOCAL_TIME_ZONE  */
  YYSYMBOL_KW_FORMAT = 103,                /* KW_FORMAT  */
  YYSYMBOL_KW_TRUNCATE_SIZE = 104,         /* KW_TRUNCATE_SIZE  */
  YYSYMBOL_KW_TIME_REOPEN = 105,           /* KW_TIME_REOPEN  */
  YYSYMBOL_KW_TIME_REAP = 106,             /* KW_TIME_REAP  */
  YYSYMBOL_KW_TIME_SLEEP = 107,            /* KW_TIME_SLEEP  */
  YYSYMBOL_KW_TMPL_ESCAPE = 108,           /* KW_TMPL_ESCAPE  */
  YYSYMBOL_KW_OPTIONAL = 109,              /* KW_OPTIONAL  */
  YYSYMBOL_KW_CREATE_DIRS = 110,           /* KW_CREATE_DIRS  */
  YYSYMBOL_KW_OWNER = 111,                 /* KW_OWNER  */
  YYSYMBOL_KW_GROUP = 112,                 /* KW_GROUP  */
  YYSYMBOL_KW_PERM = 113,                  /* KW_PERM  */
  YYSYMBOL_KW_DIR_OWNER = 114,             /* KW_DIR_OWNER  */
  YYSYMBOL_KW_DIR_GROUP = 115,             /* KW_DIR_GROUP  */
  YYSYMBOL_KW_DIR_PERM = 116,              /* KW_DIR_PERM  */
  YYSYMBOL_KW_TEMPLATE = 117,              /* KW_TEMPLATE  */
  YYSYMBOL_KW_TEMPLATE_ESCAPE = 118,       /* KW_TEMPLATE_ESCAPE  */
  YYSYMBOL_KW_TEMPLATE_FUNCTION = 119,     /* KW_TEMPLATE_FUNCTION  */
  YYSYMBOL_KW_DEFAULT_FACILITY = 120,      /* KW_DEFAULT_FACILITY  */
  YYSYMBOL_KW_DEFAULT_SEVERITY = 121,      /* KW_DEFAULT_SEVERITY  */
  YYSYMBOL_KW_SDATA_PREFIX = 122,          /* KW_SDATA_PREFIX  */
  YYSYMBOL_KW_PORT = 123,                  /* KW_PORT  */
  YYSYMBOL_KW_USE_TIME_RECVD = 124,        /* KW_USE_TIME_RECVD  */
  YYSYMBOL_KW_FACILITY = 125,              /* KW_FACILITY  */
  YYSYMBOL_KW_SEVERITY = 126,              /* KW_SEVERITY  */
  YYSYMBOL_KW_HOST = 127,                  /* KW_HOST  */
  YYSYMBOL_KW_MATCH = 128,                 /* KW_MATCH  */
  YYSYMBOL_KW_MESSAGE = 129,               /* KW_MESSAGE  */
  YYSYMBOL_KW_NETMASK = 130,               /* KW_NETMASK  */
  YYSYMBOL_KW_TAGS = 131,                  /* KW_TAGS  */
  YYSYMBOL_KW_NETMASK6 = 132,              /* KW_NETMASK6  */
  YYSYMBOL_KW_REWRITE = 133,               /* KW_REWRITE  */
  YYSYMBOL_KW_CONDITION = 134,             /* KW_CONDITION  */
  YYSYMBOL_KW_VALUE = 135,                 /* KW_VALUE  */
  YYSYMBOL_KW_YES = 136,                   /* KW_YES  */
  YYSYMBOL_KW_NO = 137,                    /* KW_NO  */
  YYSYMBOL_KW_AUTO = 138,                  /* KW_AUTO  */
  YYSYMBOL_KW_IFDEF = 139,                 /* KW_IFDEF  */
  YYSYMBOL_KW_ENDIF = 140,                 /* KW_ENDIF  */
  YYSYMBOL_LL_DOTDOT = 141,                /* LL_DOTDOT  */
  YYSYMBOL_LL_DOTDOTDOT = 142,             /* LL_DOTDOTDOT  */
  YYSYMBOL_LL_PRAGMA = 143,                /* LL_PRAGMA  */
  YYSYMBOL_LL_EOL = 144,                   /* LL_EOL  */
  YYSYMBOL_LL_ERROR = 145,                 /* LL_ERROR  */
  YYSYMBOL_LL_ARROW = 146,                 /* LL_ARROW  */
  YYSYMBOL_LL_IDENTIFIER = 147,            /* LL_IDENTIFIER  */
  YYSYMBOL_LL_NUMBER = 148,                /* LL_NUMBER  */
  YYSYMBOL_LL_FLOAT = 149,                 /* LL_FLOAT  */
  YYSYMBOL_LL_STRING = 150,                /* LL_STRING  */
  YYSYMBOL_LL_TOKEN = 151,                 /* LL_TOKEN  */
  YYSYMBOL_LL_BLOCK = 152,                 /* LL_BLOCK  */
  YYSYMBOL_LL_PLUGIN = 153,                /* LL_PLUGIN  */
  YYSYMBOL_KW_VALUE_PAIRS = 154,           /* KW_VALUE_PAIRS  */
  YYSYMBOL_KW_EXCLUDE = 155,               /* KW_EXCLUDE  */
  YYSYMBOL_KW_PAIR = 156,                  /* KW_PAIR  */
  YYSYMBOL_KW_KEY = 157,                   /* KW_KEY  */
  YYSYMBOL_KW_SCOPE = 158,                 /* KW_SCOPE  */
  YYSYMBOL_KW_SHIFT = 159,                 /* KW_SHIFT  */
  YYSYMBOL_KW_SHIFT_LEVELS = 160,          /* KW_SHIFT_LEVELS  */
  YYSYMBOL_KW_REKEY = 161,                 /* KW_REKEY  */
  YYSYMBOL_KW_ADD_PREFIX = 162,            /* KW_ADD_PREFIX  */
  YYSYMBOL_KW_REPLACE_PREFIX = 163,        /* KW_REPLACE_PREFIX  */
  YYSYMBOL_KW_CAST = 164,                  /* KW_CAST  */
  YYSYMBOL_KW_ON_ERROR = 165,              /* KW_ON_ERROR  */
  YYSYMBOL_KW_RETRIES = 166,               /* KW_RETRIES  */
  YYSYMBOL_KW_FETCH_NO_DATA_DELAY = 167,   /* KW_FETCH_NO_DATA_DELAY  */
  YYSYMBOL_KW_PROGRAM = 168,               /* KW_PROGRAM  */
  YYSYMBOL_KW_IN_LIST = 169,               /* KW_IN_LIST  */
  YYSYMBOL_170_ = 170,                     /* ';'  */
  YYSYMBOL_KW_OR = 171,                    /* KW_OR  */
  YYSYMBOL_KW_AND = 172,                   /* KW_AND  */
  YYSYMBOL_KW_NOT = 173,                   /* KW_NOT  */
  YYSYMBOL_KW_STR_LT = 174,                /* KW_STR_LT  */
  YYSYMBOL_KW_STR_LE = 175,                /* KW_STR_LE  */
  YYSYMBOL_KW_STR_EQ = 176,                /* KW_STR_EQ  */
  YYSYMBOL_KW_STR_NE = 177,                /* KW_STR_NE  */
  YYSYMBOL_KW_STR_GE = 178,                /* KW_STR_GE  */
  YYSYMBOL_KW_STR_GT = 179,                /* KW_STR_GT  */
  YYSYMBOL_KW_TA_LT = 180,                 /* KW_TA_LT  */
  YYSYMBOL_KW_TA_LE = 181,                 /* KW_TA_LE  */
  YYSYMBOL_KW_TA_EQ = 182,                 /* KW_TA_EQ  */
  YYSYMBOL_KW_TA_NE = 183,                 /* KW_TA_NE  */
  YYSYMBOL_KW_TA_GE = 184,                 /* KW_TA_GE  */
  YYSYMBOL_KW_TA_GT = 185,                 /* KW_TA_GT  */
  YYSYMBOL_KW_TAV_EQ = 186,                /* KW_TAV_EQ  */
  YYSYMBOL_KW_TAV_NE = 187,                /* KW_TAV_NE  */
  YYSYMBOL_188_ = 188,                     /* '('  */
  YYSYMBOL_189_ = 189,                     /* ')'  */
  YYSYMBOL_190_ = 190,                     /* '{'  */
  YYSYMBOL_191_ = 191,                     /* '}'  */
  YYSYMBOL_192_ = 192,                     /* ':'  */
  YYSYMBOL_YYACCEPT = 193,                 /* $accept  */
  YYSYMBOL_start = 194,                    /* start  */
  YYSYMBOL_filter_expr = 195,              /* filter_expr  */
  YYSYMBOL_filter_simple_expr = 196,       /* filter_simple_expr  */
  YYSYMBOL_filter_plugin = 197,            /* filter_plugin  */
  YYSYMBOL_filter_identifier = 198,        /* filter_identifier  */
  YYSYMBOL_filter_comparison = 199,        /* filter_comparison  */
  YYSYMBOL_200_1 = 200,                    /* @1  */
  YYSYMBOL_operator = 201,                 /* operator  */
  YYSYMBOL_filter_re = 202,                /* filter_re  */
  YYSYMBOL_203_2 = 203,                    /* @2  */
  YYSYMBOL_204_3 = 204,                    /* @3  */
  YYSYMBOL_205_4 = 205,                    /* @4  */
  YYSYMBOL_206_5 = 206,                    /* @5  */
  YYSYMBOL_207_6 = 207,                    /* @6  */
  YYSYMBOL_filter_re_params = 208,         /* filter_re_params  */
  YYSYMBOL_filter_re_opts = 209,           /* filter_re_opts  */
  YYSYMBOL_filter_re_opt = 210,            /* filter_re_opt  */
  YYSYMBOL_211_7 = 211,                    /* $@7  */
  YYSYMBOL_filter_match_params = 212,      /* filter_match_params  */
  YYSYMBOL_filter_match_opts = 213,        /* filter_match_opts  */
  YYSYMBOL_filter_match_opt = 214,         /* filter_match_opt  */
  YYSYMBOL_filter_fac_list = 215,          /* filter_fac_list  */
  YYSYMBOL_filter_fac = 216,               /* filter_fac  */
  YYSYMBOL_filter_severity_list = 217,     /* filter_severity_list  */
  YYSYMBOL_filter_severity = 218,          /* filter_severity  */
  YYSYMBOL_template_content_inner = 219,   /* template_content_inner  */
  YYSYMBOL_template_content = 220,         /* template_content  */
  YYSYMBOL_221_9 = 221,                    /* @9  */
  YYSYMBOL_string = 222,                   /* string  */
  YYSYMBOL_string_or_number = 223,         /* string_or_number  */
  YYSYMBOL_string_list = 224,              /* string_list  */
  YYSYMBOL_string_list_build = 225,        /* string_list_build  */
  YYSYMBOL_severity_string = 226,          /* severity_string  */
  YYSYMBOL_facility_string = 227,          /* facility_string  */
  YYSYMBOL_matcher_option = 228,           /* matcher_option  */
  YYSYMBOL_matcher_flags = 229             /* matcher_flags  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;



/* Unqualified %code blocks.  */
#line 31 "lib/filter/filter-expr-grammar.y"


#include "filter/filter-netmask.h"
#include "filter/filter-netmask6.h"
#include "filter/filter-op.h"
#include "filter/filter-cmp.h"
#include "filter/filter-in-list.h"
#include "filter/filter-tags.h"
#include "filter/filter-call.h"
#include "filter/filter-re.h"
#include "filter/filter-pri.h"
#include "messages.h"
#include "template/templates.h"
#include "syslog-ng.h"
#include "syslog-names.h"
#include "plugin.h"
#include "cfg-grammar-internal.h"
#include "parse-number.h"

/* NOTE: this function translates a literal value enclosed in quotes to
 * numeric, if they represent a number. This is needed as older versions of
 * syslog-ng only allowed "strings" as arguments to comparison operators and
 * used the operator to denote numeric/string comparisons.
 *
 * In the post-4.0 world, we want to use type-aware operators by default,
 * which means that type information should not be lost due to having to
 * quote number literals earlier.
 *
 * So if we are using type-aware operators (<, > and ==) and our argument is
 * a quoted number, we turn it into a numeric value and warn the user to
 * remove the quotes.
 *
 */
static LogTemplate *
_translate_number_literals(CfgLexer *lexer, gint compare_mode, LogTemplate *expr, YYLTYPE *location)
{
  /* with string based operators we do nothing */
  if ((compare_mode & FCMP_STRING_BASED))
    return expr;

  /* if there's an explicit type-hint we use that */
  if (expr->type_hint != LM_VT_NONE)
    return expr;

  /* if the argument is not literal we don't do anything */
  if (!log_template_is_literal_string(expr))
    return expr;

  /* let's check if the argument is a numeric value represented as a string,
   * turn it into a numberic value and warn the user. */

  gint64 v;
  if (!parse_int64_with_suffix(log_template_get_literal_value(expr, NULL), &v))
    return expr;
  if (cfg_is_config_version_older(configuration, VERSION_VALUE_4_0))
    {
      if (cfg_is_typing_feature_enabled(configuration))
        {
          msg_warning("WARNING: syslog-ng versions before " VERSION_4_0 " interpreted quoted numeric "
                      "literals as numbers when using the '<', '>' or '==' operators. Please remove "
                      "the quotes around the numeric literal when upgrading to " VERSION_4_0 " format, "
                      "otherwise your comparison will become string based "
                      "instead. Alternatively if your intention is string based "
                      "comparison add a string() type cast around the expression",
                      cfg_lexer_format_location_tag(lexer, location));
        }
      log_template_set_type_hint(expr, "int64", NULL);
    }
  return expr;
}

#line 118 "lib/filter/filter-expr-grammar.y"


# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
  do {                                                                  \
    if (N)                                                              \
      {                                                                 \
        (Current).name         = YYRHSLOC(Rhs, 1).name;                 \
        (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;          \
        (Current).first_column = YYRHSLOC (Rhs, 1).first_column;        \
        (Current).last_line    = YYRHSLOC (Rhs, N).last_line;           \
        (Current).last_column  = YYRHSLOC (Rhs, N).last_column;         \
      }                                                                 \
    else                                                                \
      {                                                                 \
        (Current).name         = YYRHSLOC(Rhs, 0).name;                 \
        (Current).first_line   = (Current).last_line   =                \
          YYRHSLOC (Rhs, 0).last_line;                                  \
        (Current).first_column = (Current).last_column =                \
          YYRHSLOC (Rhs, 0).last_column;                                \
      }                                                                 \
  } while (0)

#define CHECK_ERROR_WITHOUT_MESSAGE(val, token) do {                    \
    if (!(val))                                                         \
      {                                                                 \
        YYERROR;                                                        \
      }                                                                 \
  } while (0)

#define CHECK_ERROR(val, token, errorfmt, ...) do {                     \
    if (!(val))                                                         \
      {                                                                 \
        if (errorfmt)                                                   \
          {                                                             \
            gchar __buf[256];                                           \
            g_snprintf(__buf, sizeof(__buf), errorfmt, ## __VA_ARGS__); \
            yyerror(& (token), lexer, NULL, NULL, __buf);               \
          }                                                             \
        YYERROR;                                                        \
      }                                                                 \
  } while (0)

#define CHECK_ERROR_GERROR(val, token, error, errorfmt, ...) do {       \
    if (!(val))                                                         \
      {                                                                 \
        if (errorfmt)                                                   \
          {                                                             \
            gchar __buf[256];                                           \
            g_snprintf(__buf, sizeof(__buf), errorfmt ", error=%s", ## __VA_ARGS__, error->message); \
            yyerror(& (token), lexer, NULL, NULL, __buf);               \
          }                                                             \
        g_clear_error(&error);						\
        YYERROR;                                                        \
      }                                                                 \
  } while (0)

#define YYMAXDEPTH 20000



#line 903 "lib/filter/filter-expr-grammar.c"

#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined FILTER_EXPR_LTYPE_IS_TRIVIAL && FILTER_EXPR_LTYPE_IS_TRIVIAL \
             && defined FILTER_EXPR_STYPE_IS_TRIVIAL && FILTER_EXPR_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  40
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   186

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  193
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  37
/* YYNRULES -- Number of rules.  */
#define YYNRULES  90
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  154

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   10542


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     188,   189,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   192,   170,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   190,     2,   191,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,     2,     2,     2,     2,     2,     2,     2,
      37,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      38,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      64,    65,    66,    67,    68,    69,     2,     2,     2,     2,
      70,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      71,    72,    73,     2,     2,     2,     2,     2,     2,     2,
      74,    75,     2,     2,     2,     2,     2,     2,     2,     2,
      76,    77,    78,     2,     2,     2,     2,     2,     2,     2,
      79,    80,    81,     2,     2,     2,     2,     2,     2,     2,
      82,    83,    84,     2,     2,     2,     2,     2,     2,     2,
      85,     2,    86,    87,    88,    89,    90,     2,     2,     2,
      91,    92,     2,     2,     2,     2,     2,     2,     2,     2,
      93,    94,    95,    96,     2,     2,     2,     2,     2,     2,
      97,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      98,    99,   100,   101,   102,   103,   104,     2,     2,     2,
     105,   106,   107,     2,     2,     2,     2,     2,     2,     2,
     108,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     109,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     110,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     111,   112,   113,     2,     2,     2,     2,     2,     2,     2,
     114,   115,   116,     2,     2,     2,     2,     2,     2,     2,
     117,   118,   119,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     120,   121,   122,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   123,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     124,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     125,   126,   127,   128,   129,   130,   131,   132,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     133,   134,   135,     2,     2,     2,     2,     2,     2,     2,
     136,   137,   138,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      58,    59,    60,    61,    62,    63,     2,     2,     2,     2,
     139,   140,     2,     2,     2,     2,     2,     2,     2,     2,
     141,   142,   143,   144,   145,   146,     2,     2,     2,     2,
     147,   148,   149,   150,   151,   152,   153,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     154,     2,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,     2,     2,     2,     2,     2,     2,     2,     2,
     165,   166,   167,     2,   168,   169,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187
};

#if FILTER_EXPR_DEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   497,   497,   501,   502,   503,   504,   505,   506,   507,
     511,   512,   513,   514,   515,   516,   524,   525,   539,   553,
     554,   555,   559,   579,   580,   590,   590,   600,   601,   602,
     603,   604,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   617,   617,   618,   618,   619,   619,   620,   620,   621,
     621,   625,   635,   636,   640,   640,   645,   663,   664,   668,
     669,   690,   697,   698,   702,   706,   710,   711,   715,   719,
     963,   970,   980,   988,   996,   996,  1007,  1008,  1079,  1080,
    1081,  1116,  1120,  1121,  1130,  1141,  1149,  1424,  1425,  1429,
    1430
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "LL_CONTEXT_ROOT",
  "LL_CONTEXT_DESTINATION", "LL_CONTEXT_SOURCE", "LL_CONTEXT_PARSER",
  "LL_CONTEXT_REWRITE", "LL_CONTEXT_FILTER", "LL_CONTEXT_LOG",
  "LL_CONTEXT_BLOCK_DEF", "LL_CONTEXT_BLOCK_REF",
  "LL_CONTEXT_BLOCK_CONTENT", "LL_CONTEXT_BLOCK_ARG", "LL_CONTEXT_PRAGMA",
  "LL_CONTEXT_FORMAT", "LL_CONTEXT_TEMPLATE_FUNC", "LL_CONTEXT_INNER_DEST",
  "LL_CONTEXT_INNER_SRC", "LL_CONTEXT_CLIENT_PROTO",
  "LL_CONTEXT_SERVER_PROTO", "LL_CONTEXT_OPTIONS", "LL_CONTEXT_CONFIG",
  "LL_CONTEXT_MAX", "KW_SOURCE", "KW_FILTER", "KW_PARSER",
  "KW_DESTINATION", "KW_LOG", "KW_OPTIONS", "KW_INCLUDE", "KW_BLOCK",
  "KW_JUNCTION", "KW_CHANNEL", "KW_IF", "KW_ELSE", "KW_ELIF",
  "KW_INTERNAL", "KW_SYSLOG", "KW_MARK_FREQ", "KW_STATS_FREQ",
  "KW_STATS_LEVEL", "KW_STATS_LIFETIME", "KW_FLUSH_LINES", "KW_SUPPRESS",
  "KW_FLUSH_TIMEOUT", "KW_LOG_MSG_SIZE", "KW_FILE_TEMPLATE",
  "KW_PROTO_TEMPLATE", "KW_MARK_MODE", "KW_ENCODING", "KW_TYPE",
  "KW_STATS_MAX_DYNAMIC", "KW_MIN_IW_SIZE_PER_READER", "KW_WORKERS",
  "KW_BATCH_LINES", "KW_BATCH_TIMEOUT", "KW_TRIM_LARGE_MESSAGES",
  "KW_STATS", "KW_FREQ", "KW_LEVEL", "KW_LIFETIME", "KW_MAX_DYNAMIC",
  "KW_SYSLOG_STATS", "KW_CHAIN_HOSTNAMES", "KW_NORMALIZE_HOSTNAMES",
  "KW_KEEP_HOSTNAME", "KW_CHECK_HOSTNAME", "KW_BAD_HOSTNAME",
  "KW_LOG_LEVEL", "KW_KEEP_TIMESTAMP", "KW_USE_DNS", "KW_USE_FQDN",
  "KW_CUSTOM_DOMAIN", "KW_DNS_CACHE", "KW_DNS_CACHE_SIZE",
  "KW_DNS_CACHE_EXPIRE", "KW_DNS_CACHE_EXPIRE_FAILED",
  "KW_DNS_CACHE_HOSTS", "KW_PERSIST_ONLY", "KW_USE_RCPTID",
  "KW_USE_UNIQID", "KW_TZ_CONVERT", "KW_TS_FORMAT", "KW_FRAC_DIGITS",
  "KW_LOG_FIFO_SIZE", "KW_LOG_FETCH_LIMIT", "KW_LOG_IW_SIZE",
  "KW_LOG_PREFIX", "KW_PROGRAM_OVERRIDE", "KW_HOST_OVERRIDE",
  "KW_THROTTLE", "KW_THREADED", "KW_PASS_UNIX_CREDENTIALS",
  "KW_PERSIST_NAME", "KW_READ_OLD_RECORDS", "KW_USE_SYSLOGNG_PID",
  "KW_FLAGS", "KW_PAD_SIZE", "KW_TIME_ZONE", "KW_RECV_TIME_ZONE",
  "KW_SEND_TIME_ZONE", "KW_LOCAL_TIME_ZONE", "KW_FORMAT",
  "KW_TRUNCATE_SIZE", "KW_TIME_REOPEN", "KW_TIME_REAP", "KW_TIME_SLEEP",
  "KW_TMPL_ESCAPE", "KW_OPTIONAL", "KW_CREATE_DIRS", "KW_OWNER",
  "KW_GROUP", "KW_PERM", "KW_DIR_OWNER", "KW_DIR_GROUP", "KW_DIR_PERM",
  "KW_TEMPLATE", "KW_TEMPLATE_ESCAPE", "KW_TEMPLATE_FUNCTION",
  "KW_DEFAULT_FACILITY", "KW_DEFAULT_SEVERITY", "KW_SDATA_PREFIX",
  "KW_PORT", "KW_USE_TIME_RECVD", "KW_FACILITY", "KW_SEVERITY", "KW_HOST",
  "KW_MATCH", "KW_MESSAGE", "KW_NETMASK", "KW_TAGS", "KW_NETMASK6",
  "KW_REWRITE", "KW_CONDITION", "KW_VALUE", "KW_YES", "KW_NO", "KW_AUTO",
  "KW_IFDEF", "KW_ENDIF", "LL_DOTDOT", "LL_DOTDOTDOT", "LL_PRAGMA",
  "LL_EOL", "LL_ERROR", "LL_ARROW", "LL_IDENTIFIER", "LL_NUMBER",
  "LL_FLOAT", "LL_STRING", "LL_TOKEN", "LL_BLOCK", "LL_PLUGIN",
  "KW_VALUE_PAIRS", "KW_EXCLUDE", "KW_PAIR", "KW_KEY", "KW_SCOPE",
  "KW_SHIFT", "KW_SHIFT_LEVELS", "KW_REKEY", "KW_ADD_PREFIX",
  "KW_REPLACE_PREFIX", "KW_CAST", "KW_ON_ERROR", "KW_RETRIES",
  "KW_FETCH_NO_DATA_DELAY", "KW_PROGRAM", "KW_IN_LIST", "';'", "KW_OR",
  "KW_AND", "KW_NOT", "KW_STR_LT", "KW_STR_LE", "KW_STR_EQ", "KW_STR_NE",
  "KW_STR_GE", "KW_STR_GT", "KW_TA_LT", "KW_TA_LE", "KW_TA_EQ", "KW_TA_NE",
  "KW_TA_GE", "KW_TA_GT", "KW_TAV_EQ", "KW_TAV_NE", "'('", "')'", "'{'",
  "'}'", "':'", "$accept", "start", "filter_expr", "filter_simple_expr",
  "filter_plugin", "filter_identifier", "filter_comparison", "@1",
  "operator", "filter_re", "@2", "@3", "@4", "@5", "@6",
  "filter_re_params", "filter_re_opts", "filter_re_opt", "$@7",
  "filter_match_params", "filter_match_opts", "filter_match_opt",
  "filter_fac_list", "filter_fac", "filter_severity_list",
  "filter_severity", "template_content_inner", "template_content", "@9",
  "string", "string_or_number", "string_list", "string_list_build",
  "severity_string", "facility_string", "matcher_option", "matcher_flags", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-184)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-75)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -16,  -184,  -183,  -184,  -178,  -166,  -184,  -184,  -184,  -165,
    -160,  -151,  -184,  -184,  -147,   -16,   -16,    42,  -116,  -184,
    -184,  -184,  -184,  -184,    -1,   -97,  -141,  -104,    -7,  -104,
    -141,  -140,  -141,  -104,  -104,  -104,  -141,  -104,  -184,  -159,
    -184,   -24,   -16,   -16,  -184,  -184,  -184,  -184,  -184,  -184,
    -184,  -184,  -184,  -184,  -184,  -184,  -184,  -184,  -184,  -126,
    -184,  -184,  -184,  -184,  -184,  -104,  -184,  -184,  -125,  -184,
    -124,  -123,   -20,  -184,   -78,  -120,  -104,  -184,   -71,  -184,
    -104,  -184,  -184,  -118,  -104,  -112,  -184,  -110,  -184,  -111,
    -184,  -156,   -99,  -184,  -184,   -89,  -109,  -184,  -184,  -184,
    -184,   -20,  -184,  -184,  -104,  -115,  -184,  -184,  -184,  -184,
    -106,  -105,  -184,  -184,  -184,  -184,  -103,  -101,  -109,   -48,
    -184,  -184,   -98,   -96,  -184,  -100,  -115,  -104,  -184,  -184,
    -184,  -184,   -95,   -94,  -184,  -184,  -104,  -184,  -184,   -92,
    -104,  -104,   -72,   -69,   -68,   -67,  -104,   -58,  -184,  -184,
    -184,  -184,  -184,  -184
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
      74,    47,     0,    24,     0,     0,    43,    49,    45,     0,
       0,     0,    23,    41,     0,    74,    74,     0,     2,     3,
      21,    22,    20,    19,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    83,     0,     0,     0,     4,     0,
       1,     8,    74,    74,    33,    34,    35,    36,    37,    38,
      27,    28,    29,    30,    31,    32,    39,    40,    25,    76,
      72,    73,    77,    75,    70,     0,    48,    76,     0,    86,
       0,     0,    63,    85,    65,     0,    67,    84,    69,    44,
       0,    50,    46,     0,    83,     0,    81,     0,    42,     0,
       9,     7,     5,     6,    74,     0,    54,    13,    11,    10,
      62,     0,    12,    66,     0,    54,    14,    82,    16,    15,
       0,     0,    26,    79,    80,    78,     0,     0,    54,     0,
      64,    68,     0,     0,    59,     0,    54,     0,    17,    71,
      51,    52,     0,     0,    55,    74,     0,    56,    57,     0,
       0,    90,     0,     0,     0,     0,    90,     0,    61,    60,
      18,    87,    89,    88
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -184,  -184,    -9,  -184,  -184,  -184,  -184,  -184,  -184,  -184,
    -184,  -184,  -184,  -184,  -184,     8,   -40,   -91,  -184,  -184,
     -43,  -184,    13,  -184,    15,  -184,  -184,   -90,  -184,    -8,
    -184,  -184,    11,    -6,    -2,  -184,   -46
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,    17,    18,    19,    20,    21,    22,    94,    58,    23,
      36,    30,    32,    26,    31,    66,   117,   118,   119,    81,
     125,   126,    71,    72,    75,    76,    63,    24,    25,    73,
     116,    85,    86,    78,    74,   134,   147
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
       1,     2,   122,   132,   112,    27,    38,    39,     1,     2,
      28,    41,    42,    43,   124,    42,    43,    64,    69,    68,
     123,    77,    29,    33,   110,    83,    84,    87,    34,    89,
      90,    69,    91,    92,    93,   124,    67,    35,    79,    62,
      82,    37,    40,    67,    88,   142,    62,    65,    80,   133,
      59,    60,    61,    62,    41,    42,    43,    96,    67,   113,
     114,    62,    95,   101,    97,    98,    99,     3,    77,   102,
     104,   106,   105,    43,   -58,     3,    84,   108,   131,   109,
     -53,   111,   127,   138,   128,   100,   129,   115,   130,   137,
     135,   103,   136,   140,   141,   107,    77,   144,   121,   120,
     152,     4,     5,     6,     7,     8,     9,    10,    11,     4,
       5,     6,     7,     8,     9,    10,    11,   148,     0,   139,
     149,   150,   151,   -74,   -74,   -74,   -74,    67,   143,    12,
      62,   153,   145,   146,     0,     0,     0,    12,   146,     0,
      67,    70,     0,    62,    13,    14,     0,     0,     0,    15,
       0,     0,    13,    14,     0,     0,     0,    15,     0,     0,
       0,     0,     0,     0,    16,     0,     0,     0,     0,     0,
       0,     0,    16,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57
};

static const yytype_int16 yycheck[] =
{
      24,    25,   117,    51,    94,   188,    15,    16,    24,    25,
     188,   170,   171,   172,   105,   171,   172,    25,    38,    27,
     135,    29,   188,   188,   135,    33,    34,    35,   188,    37,
     189,    38,    41,    42,    43,   126,   147,   188,    30,   150,
      32,   188,     0,   147,    36,   135,   150,   188,   188,    97,
     147,   148,   149,   150,   170,   171,   172,    65,   147,   148,
     149,   150,   188,   141,   189,   189,   189,    91,    76,   189,
     141,   189,    80,   172,   189,    91,    84,   189,   118,   189,
     189,    89,   188,   126,   189,    72,   189,    95,   189,   189,
     188,    76,   188,   188,   188,    84,   104,   189,   104,   101,
     146,   125,   126,   127,   128,   129,   130,   131,   132,   125,
     126,   127,   128,   129,   130,   131,   132,   189,    -1,   127,
     189,   189,   189,   147,   148,   149,   150,   147,   136,   153,
     150,   189,   140,   141,    -1,    -1,    -1,   153,   146,    -1,
     147,   148,    -1,   150,   168,   169,    -1,    -1,    -1,   173,
      -1,    -1,   168,   169,    -1,    -1,    -1,   173,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   188,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    24,    25,    91,   125,   126,   127,   128,   129,   130,
     131,   132,   153,   168,   169,   173,   188,   194,   195,   196,
     197,   198,   199,   202,   220,   221,   206,   188,   188,   188,
     204,   207,   205,   188,   188,   188,   203,   188,   195,   195,
       0,   170,   171,   172,   174,   175,   176,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   201,   147,
     148,   149,   150,   219,   222,   188,   208,   147,   222,    38,
     148,   215,   216,   222,   227,   217,   218,   222,   226,   208,
     188,   212,   208,   222,   222,   224,   225,   222,   208,   222,
     189,   195,   195,   195,   200,   188,   222,   189,   189,   189,
     215,   141,   189,   217,   141,   222,   189,   225,   189,   189,
     135,   222,   220,   148,   149,   222,   223,   209,   210,   211,
     227,   226,   117,   135,   210,   213,   214,   188,   189,   189,
     189,   209,    51,    97,   228,   188,   188,   189,   213,   222,
     188,   188,   220,   222,   189,   222,   222,   229,   189,   189,
     189,   189,   229,   189
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   193,   194,   195,   195,   195,   195,   195,   195,   195,
     196,   196,   196,   196,   196,   196,   196,   196,   196,   196,
     196,   196,   197,   198,   198,   200,   199,   201,   201,   201,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     201,   203,   202,   204,   202,   205,   202,   206,   202,   207,
     202,   208,   209,   209,   211,   210,   212,   213,   213,   214,
     214,   214,   215,   215,   216,   216,   217,   217,   218,   218,
     219,   219,   219,   219,   221,   220,   222,   222,   223,   223,
     223,   224,   225,   225,   226,   227,   227,   228,   228,   229,
     229
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     2,     3,     3,     3,     2,     3,
       4,     4,     4,     4,     4,     4,     4,     5,     8,     1,
       1,     1,     1,     1,     1,     0,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     3,     0,     3,     0,     3,     0,     3,     0,
       3,     4,     2,     0,     0,     2,     4,     2,     0,     1,
       4,     4,     2,     1,     3,     1,     2,     1,     3,     1,
       1,     4,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     1,     2,     0,     1,     1,     1,     4,     4,     2,
       0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = FILTER_EXPR_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == FILTER_EXPR_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, lexer, result, arg, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use FILTER_EXPR_error or FILTER_EXPR_UNDEF. */
#define YYERRCODE FILTER_EXPR_UNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if FILTER_EXPR_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined FILTER_EXPR_LTYPE_IS_TRIVIAL && FILTER_EXPR_LTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, lexer, result, arg); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, CfgLexer *lexer, FilterExprNode **result, gpointer arg)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (lexer);
  YY_USE (result);
  YY_USE (arg);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, CfgLexer *lexer, FilterExprNode **result, gpointer arg)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, lexer, result, arg);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, CfgLexer *lexer, FilterExprNode **result, gpointer arg)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), lexer, result, arg);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, lexer, result, arg); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !FILTER_EXPR_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !FILTER_EXPR_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, CfgLexer *lexer, FilterExprNode **result, gpointer arg)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (lexer);
  YY_USE (result);
  YY_USE (arg);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_LL_IDENTIFIER: /* LL_IDENTIFIER  */
#line 385 "lib/filter/filter-expr-grammar.y"
            { free(((*yyvaluep).cptr)); }
#line 3147 "lib/filter/filter-expr-grammar.c"
        break;

    case YYSYMBOL_LL_STRING: /* LL_STRING  */
#line 385 "lib/filter/filter-expr-grammar.y"
            { free(((*yyvaluep).cptr)); }
#line 3153 "lib/filter/filter-expr-grammar.c"
        break;

    case YYSYMBOL_LL_BLOCK: /* LL_BLOCK  */
#line 385 "lib/filter/filter-expr-grammar.y"
            { free(((*yyvaluep).cptr)); }
#line 3159 "lib/filter/filter-expr-grammar.c"
        break;

    case YYSYMBOL_LL_PLUGIN: /* LL_PLUGIN  */
#line 385 "lib/filter/filter-expr-grammar.y"
            { free(((*yyvaluep).cptr)); }
#line 3165 "lib/filter/filter-expr-grammar.c"
        break;

    case YYSYMBOL_filter_identifier: /* filter_identifier  */
#line 385 "lib/filter/filter-expr-grammar.y"
            { free(((*yyvaluep).cptr)); }
#line 3171 "lib/filter/filter-expr-grammar.c"
        break;

    case YYSYMBOL_200_1: /* @1  */
#line 385 "lib/filter/filter-expr-grammar.y"
            { free(((*yyvaluep).cptr)); }
#line 3177 "lib/filter/filter-expr-grammar.c"
        break;

    case YYSYMBOL_string: /* string  */
#line 385 "lib/filter/filter-expr-grammar.y"
            { free(((*yyvaluep).cptr)); }
#line 3183 "lib/filter/filter-expr-grammar.c"
        break;

    case YYSYMBOL_string_or_number: /* string_or_number  */
#line 385 "lib/filter/filter-expr-grammar.y"
            { free(((*yyvaluep).cptr)); }
#line 3189 "lib/filter/filter-expr-grammar.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (CfgLexer *lexer, FilterExprNode **result, gpointer arg)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined FILTER_EXPR_LTYPE_IS_TRIVIAL && FILTER_EXPR_LTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = FILTER_EXPR_EMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == FILTER_EXPR_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, lexer);
    }

  if (yychar <= FILTER_EXPR_EOF)
    {
      yychar = FILTER_EXPR_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == FILTER_EXPR_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = FILTER_EXPR_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = FILTER_EXPR_EMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* start: filter_expr  */
#line 497 "lib/filter/filter-expr-grammar.y"
                                                { *result = (yyvsp[0].node); if (yychar != FILTER_EXPR_EMPTY) { cfg_lexer_unput_token(lexer, &yylval); } YYACCEPT; }
#line 3495 "lib/filter/filter-expr-grammar.c"
    break;

  case 3: /* filter_expr: filter_simple_expr  */
#line 501 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = (yyvsp[0].node); if (!(yyvsp[0].node)) YYERROR; }
#line 3501 "lib/filter/filter-expr-grammar.c"
    break;

  case 4: /* filter_expr: KW_NOT filter_expr  */
#line 502 "lib/filter/filter-expr-grammar.y"
                                                { ((FilterExprNode *) (yyvsp[0].node))->comp = !(((FilterExprNode *) (yyvsp[0].node))->comp); (yyval.node) = (yyvsp[0].node); }
#line 3507 "lib/filter/filter-expr-grammar.c"
    break;

  case 5: /* filter_expr: filter_expr KW_OR filter_expr  */
#line 503 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = fop_or_new((yyvsp[-2].node), (yyvsp[0].node)); }
#line 3513 "lib/filter/filter-expr-grammar.c"
    break;

  case 6: /* filter_expr: filter_expr KW_AND filter_expr  */
#line 504 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = fop_and_new((yyvsp[-2].node), (yyvsp[0].node)); }
#line 3519 "lib/filter/filter-expr-grammar.c"
    break;

  case 7: /* filter_expr: filter_expr ';' filter_expr  */
#line 505 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = fop_and_new((yyvsp[-2].node), (yyvsp[0].node)); }
#line 3525 "lib/filter/filter-expr-grammar.c"
    break;

  case 8: /* filter_expr: filter_expr ';'  */
#line 506 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = (yyvsp[-1].node); }
#line 3531 "lib/filter/filter-expr-grammar.c"
    break;

  case 9: /* filter_expr: '(' filter_expr ')'  */
#line 507 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = (yyvsp[-1].node); }
#line 3537 "lib/filter/filter-expr-grammar.c"
    break;

  case 10: /* filter_simple_expr: KW_FACILITY '(' filter_fac_list ')'  */
#line 511 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = filter_facility_new((yyvsp[-1].num));  }
#line 3543 "lib/filter/filter-expr-grammar.c"
    break;

  case 11: /* filter_simple_expr: KW_FACILITY '(' LL_NUMBER ')'  */
#line 512 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = filter_facility_new(0x80000000 | (yyvsp[-1].num)); }
#line 3549 "lib/filter/filter-expr-grammar.c"
    break;

  case 12: /* filter_simple_expr: KW_SEVERITY '(' filter_severity_list ')'  */
#line 513 "lib/filter/filter-expr-grammar.y"
                                                   { (yyval.node) = filter_severity_new((yyvsp[-1].num)); }
#line 3555 "lib/filter/filter-expr-grammar.c"
    break;

  case 13: /* filter_simple_expr: KW_FILTER '(' string ')'  */
#line 514 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = filter_call_new((yyvsp[-1].cptr), configuration); free((yyvsp[-1].cptr)); }
#line 3561 "lib/filter/filter-expr-grammar.c"
    break;

  case 14: /* filter_simple_expr: KW_NETMASK '(' string ')'  */
#line 515 "lib/filter/filter-expr-grammar.y"
                                       { (yyval.node) = filter_netmask_new((yyvsp[-1].cptr)); free((yyvsp[-1].cptr)); }
#line 3567 "lib/filter/filter-expr-grammar.c"
    break;

  case 15: /* filter_simple_expr: KW_NETMASK6 '(' string ')'  */
#line 516 "lib/filter/filter-expr-grammar.y"
                                       {
  #if SYSLOG_NG_ENABLE_IPV6
                                         (yyval.node) = filter_netmask6_new((yyvsp[-1].cptr));
  #else
                                         YYERROR;
  #endif
                                         free((yyvsp[-1].cptr));
                                       }
#line 3580 "lib/filter/filter-expr-grammar.c"
    break;

  case 16: /* filter_simple_expr: KW_TAGS '(' string_list ')'  */
#line 524 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.node) = filter_tags_new((yyvsp[-1].ptr)); }
#line 3586 "lib/filter/filter-expr-grammar.c"
    break;

  case 17: /* filter_simple_expr: KW_IN_LIST '(' string string ')'  */
#line 526 "lib/filter/filter-expr-grammar.y"
          {
            const gchar *p = (yyvsp[-1].cptr);
            if (p[0] == '$')
              {
                msg_warning("Value references in filters should not use the '$' prefix, those are only needed in templates",
                            evt_tag_str("value", (yyvsp[-1].cptr)),
                            cfg_lexer_format_location_tag(lexer, &(yylsp[-1])));
                p++;
              }
            (yyval.node) = filter_in_list_new((yyvsp[-2].cptr), p);
            free((yyvsp[-2].cptr));
            free((yyvsp[-1].cptr));
          }
#line 3604 "lib/filter/filter-expr-grammar.c"
    break;

  case 18: /* filter_simple_expr: KW_IN_LIST '(' string KW_VALUE '(' string ')' ')'  */
#line 540 "lib/filter/filter-expr-grammar.y"
          {
            const gchar *p = (yyvsp[-2].cptr);
            if (p[0] == '$')
              {
                msg_warning("Value references in filters should not use the '$' prefix, those are only needed in templates",
                            evt_tag_str("value", (yyvsp[-2].cptr)),
                            cfg_lexer_format_location_tag(lexer, &(yylsp[-2])));
                p++;
              }
            (yyval.node) = filter_in_list_new((yyvsp[-5].cptr), p);
            free((yyvsp[-5].cptr));
            free((yyvsp[-2].cptr));
          }
#line 3622 "lib/filter/filter-expr-grammar.c"
    break;

  case 22: /* filter_plugin: filter_identifier  */
#line 560 "lib/filter/filter-expr-grammar.y"
          {
            Plugin *p;
            gint context = LL_CONTEXT_FILTER;
            FilterExprNode *node;

            p = cfg_find_plugin(configuration, context, (yyvsp[0].cptr));
            CHECK_ERROR(p, (yylsp[0]), "%s plugin %s not found OR you may not used double quotes in your filter expression", cfg_lexer_lookup_context_name_by_type(context), (yyvsp[0].cptr));

            node = (FilterExprNode *) cfg_parse_plugin(configuration, p, &(yylsp[0]), NULL);
            free((yyvsp[0].cptr));
            if (!node)
              {
                YYERROR;
              }
            (yyval.node) = node;
          }
#line 3643 "lib/filter/filter-expr-grammar.c"
    break;

  case 24: /* filter_identifier: KW_THROTTLE  */
#line 581 "lib/filter/filter-expr-grammar.y"
            {
              msg_warning_once("WARNING: the throttle() filter has been renamed to rate-limit() in " VERSION_3_36
                               ", please update your configuration to use the name rate-limit() instead of throttle()",
                               cfg_lexer_format_location_tag(lexer, &(yylsp[-1])));
              (yyval.cptr) = g_strdup("rate-limit");
            }
#line 3654 "lib/filter/filter-expr-grammar.c"
    break;

  case 25: /* @1: %empty  */
#line 590 "lib/filter/filter-expr-grammar.y"
                                          { (yyval.cptr) = strdup(lexer->token_text->str); }
#line 3660 "lib/filter/filter-expr-grammar.c"
    break;

  case 26: /* filter_comparison: template_content operator @1 template_content  */
#line 591 "lib/filter/filter-expr-grammar.y"
          {
            (yyvsp[-3].ptr) = _translate_number_literals(lexer, (yyvsp[-2].token), (yyvsp[-3].ptr), &(yylsp[-3]));
            (yyvsp[0].ptr) = _translate_number_literals(lexer, (yyvsp[-2].token), (yyvsp[0].ptr), &(yylsp[0]));
	    (yyval.node) = fop_cmp_new((yyvsp[-3].ptr), (yyvsp[0].ptr), (yyvsp[-1].cptr), (yyvsp[-2].token), cfg_lexer_format_location_tag(lexer, &(yylsp[-4])));
            free((yyvsp[-1].cptr));
          }
#line 3671 "lib/filter/filter-expr-grammar.c"
    break;

  case 27: /* operator: KW_TA_LT  */
#line 600 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_TYPE_AWARE | FCMP_LT; }
#line 3677 "lib/filter/filter-expr-grammar.c"
    break;

  case 28: /* operator: KW_TA_LE  */
#line 601 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_TYPE_AWARE | FCMP_LT | FCMP_EQ; }
#line 3683 "lib/filter/filter-expr-grammar.c"
    break;

  case 29: /* operator: KW_TA_EQ  */
#line 602 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_TYPE_AWARE | FCMP_EQ; }
#line 3689 "lib/filter/filter-expr-grammar.c"
    break;

  case 30: /* operator: KW_TA_NE  */
#line 603 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_TYPE_AWARE | FCMP_LT | FCMP_GT; }
#line 3695 "lib/filter/filter-expr-grammar.c"
    break;

  case 31: /* operator: KW_TA_GE  */
#line 604 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_TYPE_AWARE | FCMP_EQ | FCMP_GT; }
#line 3701 "lib/filter/filter-expr-grammar.c"
    break;

  case 32: /* operator: KW_TA_GT  */
#line 605 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_TYPE_AWARE | FCMP_GT; }
#line 3707 "lib/filter/filter-expr-grammar.c"
    break;

  case 33: /* operator: KW_STR_LT  */
#line 606 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_STRING_BASED | FCMP_LT; }
#line 3713 "lib/filter/filter-expr-grammar.c"
    break;

  case 34: /* operator: KW_STR_LE  */
#line 607 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_STRING_BASED | FCMP_LT | FCMP_EQ; }
#line 3719 "lib/filter/filter-expr-grammar.c"
    break;

  case 35: /* operator: KW_STR_EQ  */
#line 608 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_STRING_BASED | FCMP_EQ; }
#line 3725 "lib/filter/filter-expr-grammar.c"
    break;

  case 36: /* operator: KW_STR_NE  */
#line 609 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_STRING_BASED | FCMP_LT | FCMP_GT; }
#line 3731 "lib/filter/filter-expr-grammar.c"
    break;

  case 37: /* operator: KW_STR_GE  */
#line 610 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_STRING_BASED | FCMP_EQ | FCMP_GT; }
#line 3737 "lib/filter/filter-expr-grammar.c"
    break;

  case 38: /* operator: KW_STR_GT  */
#line 611 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_STRING_BASED | FCMP_GT; }
#line 3743 "lib/filter/filter-expr-grammar.c"
    break;

  case 39: /* operator: KW_TAV_EQ  */
#line 612 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_TYPE_AND_VALUE_BASED | FCMP_EQ; }
#line 3749 "lib/filter/filter-expr-grammar.c"
    break;

  case 40: /* operator: KW_TAV_NE  */
#line 613 "lib/filter/filter-expr-grammar.y"
                            { (yyval.token) = FCMP_TYPE_AND_VALUE_BASED | FCMP_LT | FCMP_GT; }
#line 3755 "lib/filter/filter-expr-grammar.c"
    break;

  case 41: /* @2: %empty  */
#line 617 "lib/filter/filter-expr-grammar.y"
                          { (yyval.ptr) = last_filter_expr = filter_re_new(LM_V_PROGRAM); }
#line 3761 "lib/filter/filter-expr-grammar.c"
    break;

  case 42: /* filter_re: KW_PROGRAM @2 filter_re_params  */
#line 617 "lib/filter/filter-expr-grammar.y"
                                                                                                        { (yyval.ptr) = (yyvsp[-1].ptr); }
#line 3767 "lib/filter/filter-expr-grammar.c"
    break;

  case 43: /* @3: %empty  */
#line 618 "lib/filter/filter-expr-grammar.y"
                          { (yyval.ptr) = last_filter_expr = filter_re_new(LM_V_HOST); }
#line 3773 "lib/filter/filter-expr-grammar.c"
    break;

  case 44: /* filter_re: KW_HOST @3 filter_re_params  */
#line 618 "lib/filter/filter-expr-grammar.y"
                                                                                                        { (yyval.ptr) = (yyvsp[-1].ptr); }
#line 3779 "lib/filter/filter-expr-grammar.c"
    break;

  case 45: /* @4: %empty  */
#line 619 "lib/filter/filter-expr-grammar.y"
                          { (yyval.ptr) = last_filter_expr = filter_re_new(LM_V_MESSAGE); }
#line 3785 "lib/filter/filter-expr-grammar.c"
    break;

  case 46: /* filter_re: KW_MESSAGE @4 filter_re_params  */
#line 619 "lib/filter/filter-expr-grammar.y"
                                                                                                        { (yyval.ptr) = (yyvsp[-1].ptr); }
#line 3791 "lib/filter/filter-expr-grammar.c"
    break;

  case 47: /* @5: %empty  */
#line 620 "lib/filter/filter-expr-grammar.y"
                          { (yyval.ptr) = last_filter_expr = filter_source_new();  }
#line 3797 "lib/filter/filter-expr-grammar.c"
    break;

  case 48: /* filter_re: KW_SOURCE @5 filter_re_params  */
#line 620 "lib/filter/filter-expr-grammar.y"
                                                                                                        { (yyval.ptr) = (yyvsp[-1].ptr); }
#line 3803 "lib/filter/filter-expr-grammar.c"
    break;

  case 49: /* @6: %empty  */
#line 621 "lib/filter/filter-expr-grammar.y"
                          { (yyval.ptr) = last_filter_expr = filter_match_new(); }
#line 3809 "lib/filter/filter-expr-grammar.c"
    break;

  case 50: /* filter_re: KW_MATCH @6 filter_match_params  */
#line 621 "lib/filter/filter-expr-grammar.y"
                                                                                                        { (yyval.ptr) = (yyvsp[-1].ptr); }
#line 3815 "lib/filter/filter-expr-grammar.c"
    break;

  case 51: /* filter_re_params: '(' string filter_re_opts ')'  */
#line 626 "lib/filter/filter-expr-grammar.y"
          {
            GError *error = NULL;

            CHECK_ERROR_GERROR(filter_re_compile_pattern(last_filter_expr, (yyvsp[-2].cptr), &error), (yylsp[-2]), error, "compiling the regexp failed");
            free((yyvsp[-2].cptr));
          }
#line 3826 "lib/filter/filter-expr-grammar.c"
    break;

  case 54: /* $@7: %empty  */
#line 640 "lib/filter/filter-expr-grammar.y"
          { last_matcher_options = filter_re_get_matcher_options(last_filter_expr); }
#line 3832 "lib/filter/filter-expr-grammar.c"
    break;

  case 56: /* filter_match_params: '(' string filter_match_opts ')'  */
#line 646 "lib/filter/filter-expr-grammar.y"
          {
            GError *error = NULL;

            CHECK_ERROR_GERROR(filter_re_compile_pattern(last_filter_expr, (yyvsp[-2].cptr), &error), (yylsp[-2]), error, "compiling the regexp failed");
            free((yyvsp[-2].cptr));

            if (filter_match_is_usage_obsolete(last_filter_expr))
              {
                msg_warning_once("WARNING: the match() filter without the use of the value() "
                                 "option is deprecated and hinders performance, please use a "
                                 "more specific filter like message() and/or program() instead",
                                 cfg_lexer_format_location_tag(lexer, &(yylsp[-4])));
              }

          }
#line 3852 "lib/filter/filter-expr-grammar.c"
    break;

  case 60: /* filter_match_opt: KW_VALUE '(' string ')'  */
#line 670 "lib/filter/filter-expr-grammar.y"
          {
            const gchar *p = (yyvsp[-1].cptr);
            if (p[0] == '$')
              {
                msg_warning("WARNING: value references in filters should not use the '$' prefix, those are only needed in templates, removing automatically",
                            evt_tag_str("value", (yyvsp[-1].cptr)),
                            cfg_lexer_format_location_tag(lexer, &(yylsp[-1])));
                p++;
              }
            if (p[0] == '(' || strchr(p, '$') != NULL)
              {
                msg_error("value() reference for the match() filter cannot contain a full template string, use the template() option or stick to a single value",
                          evt_tag_str("value", (yyvsp[-1].cptr)),
                          cfg_lexer_format_location_tag(lexer, &(yylsp[-1])));
                free((yyvsp[-1].cptr));
                YYERROR;
              }
            filter_match_set_value_handle(last_filter_expr, log_msg_get_value_handle(p));
            free((yyvsp[-1].cptr));
          }
#line 3877 "lib/filter/filter-expr-grammar.c"
    break;

  case 61: /* filter_match_opt: KW_TEMPLATE '(' template_content ')'  */
#line 691 "lib/filter/filter-expr-grammar.y"
          {
            filter_match_set_template_ref(last_filter_expr, (yyvsp[-1].ptr));
          }
#line 3885 "lib/filter/filter-expr-grammar.c"
    break;

  case 62: /* filter_fac_list: filter_fac filter_fac_list  */
#line 697 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.num) = (yyvsp[-1].num) | (yyvsp[0].num); }
#line 3891 "lib/filter/filter-expr-grammar.c"
    break;

  case 63: /* filter_fac_list: filter_fac  */
#line 698 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.num) = (yyvsp[0].num); }
#line 3897 "lib/filter/filter-expr-grammar.c"
    break;

  case 64: /* filter_fac: facility_string LL_DOTDOT facility_string  */
#line 703 "lib/filter/filter-expr-grammar.y"
          {
	    (yyval.num) = syslog_make_range((yyvsp[-2].num) >> 3, (yyvsp[0].num) >> 3);
	  }
#line 3905 "lib/filter/filter-expr-grammar.c"
    break;

  case 65: /* filter_fac: facility_string  */
#line 706 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.num) = 1 << ((yyvsp[0].num) >> 3); }
#line 3911 "lib/filter/filter-expr-grammar.c"
    break;

  case 66: /* filter_severity_list: filter_severity filter_severity_list  */
#line 710 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.num) = (yyvsp[-1].num) | (yyvsp[0].num); }
#line 3917 "lib/filter/filter-expr-grammar.c"
    break;

  case 67: /* filter_severity_list: filter_severity  */
#line 711 "lib/filter/filter-expr-grammar.y"
                                                        { (yyval.num) = (yyvsp[0].num); }
#line 3923 "lib/filter/filter-expr-grammar.c"
    break;

  case 68: /* filter_severity: severity_string LL_DOTDOT severity_string  */
#line 716 "lib/filter/filter-expr-grammar.y"
          {
	    (yyval.num) = syslog_make_range((yyvsp[-2].num), (yyvsp[0].num));
	  }
#line 3931 "lib/filter/filter-expr-grammar.c"
    break;

  case 69: /* filter_severity: severity_string  */
#line 720 "lib/filter/filter-expr-grammar.y"
          {
	    (yyval.num) = 1 << (yyvsp[0].num);
	  }
#line 3939 "lib/filter/filter-expr-grammar.c"
    break;

  case 70: /* template_content_inner: string  */
#line 964 "lib/filter/filter-expr-grammar.y"
        {
          GError *error = NULL;

          CHECK_ERROR_GERROR(log_template_compile(last_template, (yyvsp[0].cptr), &error), (yylsp[0]), error, "Error compiling template");
          free((yyvsp[0].cptr));
        }
#line 3950 "lib/filter/filter-expr-grammar.c"
    break;

  case 71: /* template_content_inner: LL_IDENTIFIER '(' string_or_number ')'  */
#line 971 "lib/filter/filter-expr-grammar.y"
        {
          GError *error = NULL;

          CHECK_ERROR_GERROR(log_template_compile(last_template, (yyvsp[-1].cptr), &error), (yylsp[-1]), error, "Error compiling template");
          free((yyvsp[-1].cptr));

          CHECK_ERROR_GERROR(log_template_set_type_hint(last_template, (yyvsp[-3].cptr), &error), (yylsp[-3]), error, "Error setting the template type-hint \"%s\"", (yyvsp[-3].cptr));
          free((yyvsp[-3].cptr));
        }
#line 3964 "lib/filter/filter-expr-grammar.c"
    break;

  case 72: /* template_content_inner: LL_NUMBER  */
#line 981 "lib/filter/filter-expr-grammar.y"
        {
          gchar decimal[32];

          g_snprintf(decimal, sizeof(decimal), "%" G_GINT64_FORMAT, (yyvsp[0].num));
          log_template_compile_literal_string(last_template, decimal);
          log_template_set_type_hint(last_template, "int64", NULL);
        }
#line 3976 "lib/filter/filter-expr-grammar.c"
    break;

  case 73: /* template_content_inner: LL_FLOAT  */
#line 989 "lib/filter/filter-expr-grammar.y"
        {
          log_template_compile_literal_string(last_template, lexer->token_text->str);
          log_template_set_type_hint(last_template, "float", NULL);
        }
#line 3985 "lib/filter/filter-expr-grammar.c"
    break;

  case 74: /* @9: %empty  */
#line 996 "lib/filter/filter-expr-grammar.y"
               { (yyval.ptr) = last_template = log_template_new(configuration, NULL); }
#line 3991 "lib/filter/filter-expr-grammar.c"
    break;

  case 75: /* template_content: @9 template_content_inner  */
#line 996 "lib/filter/filter-expr-grammar.y"
                                                                                                        { (yyval.ptr) = (yyvsp[-1].ptr); }
#line 3997 "lib/filter/filter-expr-grammar.c"
    break;

  case 78: /* string_or_number: string  */
#line 1079 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.cptr) = (yyvsp[0].cptr); }
#line 4003 "lib/filter/filter-expr-grammar.c"
    break;

  case 79: /* string_or_number: LL_NUMBER  */
#line 1080 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.cptr) = strdup(lexer->token_text->str); }
#line 4009 "lib/filter/filter-expr-grammar.c"
    break;

  case 80: /* string_or_number: LL_FLOAT  */
#line 1081 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.cptr) = strdup(lexer->token_text->str); }
#line 4015 "lib/filter/filter-expr-grammar.c"
    break;

  case 81: /* string_list: string_list_build  */
#line 1116 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.ptr) = (yyvsp[0].ptr); }
#line 4021 "lib/filter/filter-expr-grammar.c"
    break;

  case 82: /* string_list_build: string string_list_build  */
#line 1120 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.ptr) = g_list_prepend((yyvsp[0].ptr), g_strdup((yyvsp[-1].cptr))); free((yyvsp[-1].cptr)); }
#line 4027 "lib/filter/filter-expr-grammar.c"
    break;

  case 83: /* string_list_build: %empty  */
#line 1121 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.ptr) = NULL; }
#line 4033 "lib/filter/filter-expr-grammar.c"
    break;

  case 84: /* severity_string: string  */
#line 1131 "lib/filter/filter-expr-grammar.y"
          {
	    /* return the numeric value of the "level" */
	    int n = syslog_name_lookup_severity_by_name((yyvsp[0].cptr));
	    CHECK_ERROR((n != -1), (yylsp[0]), "Unknown priority level\"%s\"", (yyvsp[0].cptr));
	    free((yyvsp[0].cptr));
            (yyval.num) = n;
	  }
#line 4045 "lib/filter/filter-expr-grammar.c"
    break;

  case 85: /* facility_string: string  */
#line 1142 "lib/filter/filter-expr-grammar.y"
          {
            /* return the numeric value of facility */
	    int n = syslog_name_lookup_facility_by_name((yyvsp[0].cptr));
	    CHECK_ERROR((n != -1), (yylsp[0]), "Unknown facility \"%s\"", (yyvsp[0].cptr));
	    free((yyvsp[0].cptr));
	    (yyval.num) = n;
	  }
#line 4057 "lib/filter/filter-expr-grammar.c"
    break;

  case 86: /* facility_string: KW_SYSLOG  */
#line 1149 "lib/filter/filter-expr-grammar.y"
                                                { (yyval.num) = LOG_SYSLOG; }
#line 4063 "lib/filter/filter-expr-grammar.c"
    break;

  case 87: /* matcher_option: KW_TYPE '(' string ')'  */
#line 1424 "lib/filter/filter-expr-grammar.y"
                                                { CHECK_ERROR(log_matcher_options_set_type(last_matcher_options, (yyvsp[-1].cptr)), (yylsp[-1]), "unknown matcher type \"%s\"", (yyvsp[-1].cptr)); free((yyvsp[-1].cptr)); }
#line 4069 "lib/filter/filter-expr-grammar.c"
    break;

  case 89: /* matcher_flags: string matcher_flags  */
#line 1429 "lib/filter/filter-expr-grammar.y"
                                                { CHECK_ERROR(log_matcher_options_process_flag(last_matcher_options, (yyvsp[-1].cptr)), (yylsp[-1]), "unknown matcher flag \"%s\"", (yyvsp[-1].cptr)); free((yyvsp[-1].cptr)); }
#line 4075 "lib/filter/filter-expr-grammar.c"
    break;


#line 4079 "lib/filter/filter-expr-grammar.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == FILTER_EXPR_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken, &yylloc};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (&yylloc, lexer, result, arg, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= FILTER_EXPR_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == FILTER_EXPR_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, lexer, result, arg);
          yychar = FILTER_EXPR_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, lexer, result, arg);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, lexer, result, arg, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != FILTER_EXPR_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, lexer, result, arg);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, lexer, result, arg);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 1554 "lib/filter/filter-expr-grammar.y"

