/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the ByocTrunkList
 *
 * @param version - Version of the resource
 */
declare function ByocTrunkList(version: V1): ByocTrunkListInstance;

/**
 * Options to pass to update
 *
 * @property cnamLookupEnabled - Whether Caller ID Name (CNAM) lookup is enabled for the trunk
 * @property connectionPolicySid - Origination Connection Policy (to your Carrier)
 * @property friendlyName - A string to describe the resource
 * @property fromDomainSid - The SID of the SIP Domain that should be used in the `From` header of originating calls
 * @property statusCallbackMethod - The HTTP method we should use to call status_callback_url
 * @property statusCallbackUrl - The URL that we should call to pass status updates
 * @property voiceFallbackMethod - The HTTP method used with voice_fallback_url
 * @property voiceFallbackUrl - The URL we should call when an error occurs in executing TwiML
 * @property voiceMethod - The HTTP method we should use with voice_url
 * @property voiceUrl - The URL we should call when receiving a call
 */
interface ByocTrunkInstanceUpdateOptions {
  cnamLookupEnabled?: boolean;
  connectionPolicySid?: string;
  friendlyName?: string;
  fromDomainSid?: string;
  statusCallbackMethod?: string;
  statusCallbackUrl?: string;
  voiceFallbackMethod?: string;
  voiceFallbackUrl?: string;
  voiceMethod?: string;
  voiceUrl?: string;
}

interface ByocTrunkListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ByocTrunkContext;
  /**
   * create a ByocTrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: ByocTrunkInstance) => any): Promise<ByocTrunkInstance>;
  /**
   * create a ByocTrunkInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: ByocTrunkListInstanceCreateOptions, callback?: (error: Error | null, item: ByocTrunkInstance) => any): Promise<ByocTrunkInstance>;
  /**
   * Streams ByocTrunkInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ByocTrunkInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ByocTrunkInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ByocTrunkListInstanceEachOptions, callback?: (item: ByocTrunkInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a byoc_trunk
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): ByocTrunkContext;
  /**
   * Retrieve a single target page of ByocTrunkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ByocTrunkPage) => any): Promise<ByocTrunkPage>;
  /**
   * Retrieve a single target page of ByocTrunkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ByocTrunkPage) => any): Promise<ByocTrunkPage>;
  /**
   * Lists ByocTrunkInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ByocTrunkInstance[]) => any): Promise<ByocTrunkInstance[]>;
  /**
   * Lists ByocTrunkInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ByocTrunkListInstanceOptions, callback?: (error: Error | null, items: ByocTrunkInstance[]) => any): Promise<ByocTrunkInstance[]>;
  /**
   * Retrieve a single page of ByocTrunkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ByocTrunkPage) => any): Promise<ByocTrunkPage>;
  /**
   * Retrieve a single page of ByocTrunkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ByocTrunkListInstancePageOptions, callback?: (error: Error | null, items: ByocTrunkPage) => any): Promise<ByocTrunkPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property cnamLookupEnabled - Whether Caller ID Name (CNAM) lookup is enabled for the trunk
 * @property connectionPolicySid - Origination Connection Policy (to your Carrier)
 * @property friendlyName - A string to describe the resource
 * @property fromDomainSid - The SID of the SIP Domain that should be used in the `From` header of originating calls
 * @property statusCallbackMethod - The HTTP method we should use to call `status_callback_url`
 * @property statusCallbackUrl - The URL that we should call to pass status updates
 * @property voiceFallbackMethod - The HTTP method to use with voice_fallback_url
 * @property voiceFallbackUrl - The URL we should call when an error occurs in executing TwiML
 * @property voiceMethod - The HTTP method to use with voice_url
 * @property voiceUrl - The URL we should call when receiving a call
 */
interface ByocTrunkListInstanceCreateOptions {
  cnamLookupEnabled?: boolean;
  connectionPolicySid?: string;
  friendlyName?: string;
  fromDomainSid?: string;
  statusCallbackMethod?: string;
  statusCallbackUrl?: string;
  voiceFallbackMethod?: string;
  voiceFallbackUrl?: string;
  voiceMethod?: string;
  voiceUrl?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface ByocTrunkListInstanceEachOptions {
  callback?: (item: ByocTrunkInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface ByocTrunkListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface ByocTrunkListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface ByocTrunkPayload extends ByocTrunkResource, Page.TwilioResponsePayload {
}

interface ByocTrunkResource {
  account_sid: string;
  cnam_lookup_enabled: boolean;
  connection_policy_sid: string;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  from_domain_sid: string;
  sid: string;
  status_callback_method: string;
  status_callback_url: string;
  url: string;
  voice_fallback_method: string;
  voice_fallback_url: string;
  voice_method: string;
  voice_url: string;
}

interface ByocTrunkSolution {
}


declare class ByocTrunkContext {
  /**
   * Initialize the ByocTrunkContext
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a ByocTrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ByocTrunkInstance) => any): Promise<ByocTrunkInstance>;
  /**
   * remove a ByocTrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ByocTrunkInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ByocTrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ByocTrunkInstance) => any): Promise<ByocTrunkInstance>;
  /**
   * update a ByocTrunkInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ByocTrunkInstanceUpdateOptions, callback?: (error: Error | null, items: ByocTrunkInstance) => any): Promise<ByocTrunkInstance>;
}


declare class ByocTrunkInstance extends SerializableClass {
  /**
   * Initialize the ByocTrunkContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: ByocTrunkPayload, sid: string);

  private _proxy: ByocTrunkContext;
  accountSid: string;
  cnamLookupEnabled: boolean;
  connectionPolicySid: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a ByocTrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ByocTrunkInstance) => any): Promise<ByocTrunkInstance>;
  friendlyName: string;
  fromDomainSid: string;
  /**
   * remove a ByocTrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ByocTrunkInstance) => any): Promise<boolean>;
  sid: string;
  statusCallbackMethod: string;
  statusCallbackUrl: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ByocTrunkInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ByocTrunkInstance) => any): Promise<ByocTrunkInstance>;
  /**
   * update a ByocTrunkInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ByocTrunkInstanceUpdateOptions, callback?: (error: Error | null, items: ByocTrunkInstance) => any): Promise<ByocTrunkInstance>;
  url: string;
  voiceFallbackMethod: string;
  voiceFallbackUrl: string;
  voiceMethod: string;
  voiceUrl: string;
}


declare class ByocTrunkPage extends Page<V1, ByocTrunkPayload, ByocTrunkResource, ByocTrunkInstance> {
  /**
   * Initialize the ByocTrunkPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ByocTrunkSolution);

  /**
   * Build an instance of ByocTrunkInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ByocTrunkPayload): ByocTrunkInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ByocTrunkContext, ByocTrunkInstance, ByocTrunkInstanceUpdateOptions, ByocTrunkList, ByocTrunkListInstance, ByocTrunkListInstanceCreateOptions, ByocTrunkListInstanceEachOptions, ByocTrunkListInstanceOptions, ByocTrunkListInstancePageOptions, ByocTrunkPage, ByocTrunkPayload, ByocTrunkResource, ByocTrunkSolution }
