/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { ParticipantList } from './room/participant';
import { ParticipantListInstance } from './room/participant';
import { SerializableClass } from '../../../interfaces';

type RoomCodec = 'VP8'|'H264'|'VP9';

type RoomCreatedMethod = 'sdk'|'ad_hoc'|'api';

type RoomEdgeLocation = 'ashburn'|'dublin'|'frankfurt'|'singapore'|'sydney'|'sao_paulo'|'roaming'|'umatilla'|'tokyo';

type RoomEndReason = 'room_ended_via_api'|'timeout';

type RoomProcessingState = 'complete'|'in_progress';

type RoomRoomStatus = 'in_progress'|'completed';

type RoomRoomType = 'go'|'peer_to_peer'|'group'|'group_small';

type RoomTwilioRealm = 'us1'|'us2'|'au1'|'br1'|'ie1'|'jp1'|'sg1'|'in1'|'de1'|'gll';

/**
 * Initialize the RoomList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function RoomList(version: V1): RoomListInstance;

interface RoomListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): RoomContext;
  /**
   * Streams RoomInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: RoomInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams RoomInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: RoomListInstanceEachOptions, callback?: (item: RoomInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a room
   *
   * @param roomSid - The SID of the Room resource.
   */
  get(roomSid: string): RoomContext;
  /**
   * Retrieve a single target page of RoomInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: RoomPage) => any): Promise<RoomPage>;
  /**
   * Retrieve a single target page of RoomInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: RoomPage) => any): Promise<RoomPage>;
  /**
   * Lists RoomInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: RoomInstance[]) => any): Promise<RoomInstance[]>;
  /**
   * Lists RoomInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: RoomListInstanceOptions, callback?: (error: Error | null, items: RoomInstance[]) => any): Promise<RoomInstance[]>;
  /**
   * Retrieve a single page of RoomInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: RoomPage) => any): Promise<RoomPage>;
  /**
   * Retrieve a single page of RoomInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: RoomListInstancePageOptions, callback?: (error: Error | null, items: RoomPage) => any): Promise<RoomPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property codec - Codecs used by participants in the room.
 * @property createdAfter - Only read rooms that started on or after this ISO 8601 timestamp.
 * @property createdBefore - Only read rooms that started before this ISO 8601 timestamp.
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property roomName - Room friendly name.
 * @property roomType - Type of room.
 */
interface RoomListInstanceEachOptions {
  callback?: (item: RoomInstance, done: (err?: Error) => void) => void;
  codec?: RoomCodec | RoomCodec[];
  createdAfter?: Date;
  createdBefore?: Date;
  done?: Function;
  limit?: number;
  pageSize?: number;
  roomName?: string;
  roomType?: RoomRoomType | RoomRoomType[];
}

/**
 * Options to pass to list
 *
 * @property codec - Codecs used by participants in the room.
 * @property createdAfter - Only read rooms that started on or after this ISO 8601 timestamp.
 * @property createdBefore - Only read rooms that started before this ISO 8601 timestamp.
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property roomName - Room friendly name.
 * @property roomType - Type of room.
 */
interface RoomListInstanceOptions {
  codec?: RoomCodec | RoomCodec[];
  createdAfter?: Date;
  createdBefore?: Date;
  limit?: number;
  pageSize?: number;
  roomName?: string;
  roomType?: RoomRoomType | RoomRoomType[];
}

/**
 * Options to pass to page
 *
 * @property codec - Codecs used by participants in the room.
 * @property createdAfter - Only read rooms that started on or after this ISO 8601 timestamp.
 * @property createdBefore - Only read rooms that started before this ISO 8601 timestamp.
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property roomName - Room friendly name.
 * @property roomType - Type of room.
 */
interface RoomListInstancePageOptions {
  codec?: RoomCodec | RoomCodec[];
  createdAfter?: Date;
  createdBefore?: Date;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  roomName?: string;
  roomType?: RoomRoomType | RoomRoomType[];
}

interface RoomPayload extends RoomResource, Page.TwilioResponsePayload {
}

interface RoomResource {
  account_sid: string;
  codecs: RoomCodec[];
  concurrent_participants: number;
  create_time: Date;
  created_method: RoomCreatedMethod;
  duration_sec: number;
  edge_location: RoomEdgeLocation;
  end_reason: RoomEndReason;
  end_time: Date;
  links: string;
  max_concurrent_participants: number;
  max_participants: number;
  media_region: RoomTwilioRealm;
  processing_state: RoomProcessingState;
  recording_enabled: boolean;
  room_name: string;
  room_sid: string;
  room_status: RoomRoomStatus;
  room_type: RoomRoomType;
  status_callback: string;
  status_callback_method: string;
  total_participant_duration_sec: number;
  total_recording_duration_sec: number;
  unique_participant_identities: number;
  unique_participants: number;
  url: string;
}

interface RoomSolution {
}


declare class RoomContext {
  /**
   * Initialize the RoomContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param roomSid - The SID of the Room resource.
   */
  constructor(version: V1, roomSid: string);

  /**
   * fetch a RoomInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: RoomInstance) => any): Promise<RoomInstance>;
  participants: ParticipantListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class RoomInstance extends SerializableClass {
  /**
   * Initialize the RoomContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param roomSid - The SID of the Room resource.
   */
  constructor(version: V1, payload: RoomPayload, roomSid: string);

  private _proxy: RoomContext;
  accountSid: string;
  codecs: RoomCodec[];
  concurrentParticipants: number;
  createTime: Date;
  createdMethod: RoomCreatedMethod;
  durationSec: number;
  edgeLocation: RoomEdgeLocation;
  endReason: RoomEndReason;
  endTime: Date;
  /**
   * fetch a RoomInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: RoomInstance) => any): Promise<RoomInstance>;
  links: string;
  maxConcurrentParticipants: number;
  maxParticipants: number;
  mediaRegion: RoomTwilioRealm;
  /**
   * Access the participants
   */
  participants(): ParticipantListInstance;
  processingState: RoomProcessingState;
  recordingEnabled: boolean;
  roomName: string;
  roomSid: string;
  roomStatus: RoomRoomStatus;
  roomType: RoomRoomType;
  statusCallback: string;
  statusCallbackMethod: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  totalParticipantDurationSec: number;
  totalRecordingDurationSec: number;
  uniqueParticipantIdentities: number;
  uniqueParticipants: number;
  url: string;
}


declare class RoomPage extends Page<V1, RoomPayload, RoomResource, RoomInstance> {
  /**
   * Initialize the RoomPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: RoomSolution);

  /**
   * Build an instance of RoomInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: RoomPayload): RoomInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { RoomCodec, RoomContext, RoomCreatedMethod, RoomEdgeLocation, RoomEndReason, RoomInstance, RoomList, RoomListInstance, RoomListInstanceEachOptions, RoomListInstanceOptions, RoomListInstancePageOptions, RoomPage, RoomPayload, RoomProcessingState, RoomResource, RoomRoomStatus, RoomRoomType, RoomSolution, RoomTwilioRealm }
