'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var PayloadList = require('./addOnResult/payload').PayloadList;
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var AddOnResultList;
var AddOnResultPage;
var AddOnResultInstance;
var AddOnResultContext;

/* jshint ignore:start */
/**
 * Initialize the AddOnResultList
 *
 * @constructor Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultList
 *
 * @param {Twilio.Api.V2010} version - Version of the resource
 * @param {string} accountSid - The SID of the Account that created the resource
 * @param {string} referenceSid -
 *          The SID of the recording to which the AddOnResult resource belongs
 */
/* jshint ignore:end */
AddOnResultList = function AddOnResultList(version, accountSid, referenceSid) {
  /* jshint ignore:start */
  /**
   * @function addOnResults
   * @memberof Twilio.Api.V2010.AccountContext.RecordingContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultContext}
   */
  /* jshint ignore:end */
  function AddOnResultListInstance(sid) {
    return AddOnResultListInstance.get(sid);
  }

  AddOnResultListInstance._version = version;
  // Path Solution
  AddOnResultListInstance._solution = {accountSid: accountSid, referenceSid: referenceSid};
  AddOnResultListInstance._uri = `/Accounts/${accountSid}/Recordings/${referenceSid}/AddOnResults.json`;
  /* jshint ignore:start */
  /**
   * Streams AddOnResultInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  AddOnResultListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists AddOnResultInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AddOnResultListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of AddOnResultInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AddOnResultListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new AddOnResultPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of AddOnResultInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AddOnResultListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new AddOnResultPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a add_on_result
   *
   * @function get
   * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultList#
   *
   * @param {string} sid - The unique string that identifies the resource to fetch
   *
   * @returns {Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultContext}
   */
  /* jshint ignore:end */
  AddOnResultListInstance.get = function get(sid) {
    return new AddOnResultContext(
      this._version,
      this._solution.accountSid,
      this._solution.referenceSid,
      sid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  AddOnResultListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  AddOnResultListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return AddOnResultListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the AddOnResultPage
 *
 * @constructor Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultPage
 *
 * @param {V2010} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {AddOnResultSolution} solution - Path solution
 *
 * @returns AddOnResultPage
 */
/* jshint ignore:end */
AddOnResultPage = function AddOnResultPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(AddOnResultPage.prototype, Page.prototype);
AddOnResultPage.prototype.constructor = AddOnResultPage;

/* jshint ignore:start */
/**
 * Build an instance of AddOnResultInstance
 *
 * @function getInstance
 * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultPage#
 *
 * @param {AddOnResultPayload} payload - Payload response from the API
 *
 * @returns AddOnResultInstance
 */
/* jshint ignore:end */
AddOnResultPage.prototype.getInstance = function getInstance(payload) {
  return new AddOnResultInstance(
    this._version,
    payload,
    this._solution.accountSid,
    this._solution.referenceSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
AddOnResultPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AddOnResultPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AddOnResultContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {add_on_result.status} status - The status of the result
 * @property {string} addOnSid - The SID of the Add-on to which the result belongs
 * @property {string} addOnConfigurationSid - The SID of the Add-on configuration
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT that the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT that the resource was last updated
 * @property {Date} dateCompleted -
 *          The date and time in GMT that the result was completed
 * @property {string} referenceSid -
 *          The SID of the recording to which the AddOnResult resource belongs
 * @property {string} subresourceUris -
 *          A list of related resources identified by their relative URIs
 *
 * @param {V2010} version - Version of the resource
 * @param {AddOnResultPayload} payload - The instance payload
 * @param {sid} accountSid - The SID of the Account that created the resource
 * @param {sid} referenceSid -
 *          The SID of the recording to which the AddOnResult resource belongs
 * @param {sid} sid - The unique string that identifies the resource to fetch
 */
/* jshint ignore:end */
AddOnResultInstance = function AddOnResultInstance(version, payload, accountSid,
                                                    referenceSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.addOnSid = payload.add_on_sid; // jshint ignore:line
  this.addOnConfigurationSid = payload.add_on_configuration_sid; // jshint ignore:line
  this.dateCreated = deserialize.rfc2822DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.rfc2822DateTime(payload.date_updated); // jshint ignore:line
  this.dateCompleted = deserialize.rfc2822DateTime(payload.date_completed); // jshint ignore:line
  this.referenceSid = payload.reference_sid; // jshint ignore:line
  this.subresourceUris = payload.subresource_uris; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {accountSid: accountSid, referenceSid: referenceSid, sid: sid || this.sid, };
};

Object.defineProperty(AddOnResultInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new AddOnResultContext(
          this._version,
          this._solution.accountSid,
          this._solution.referenceSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a AddOnResultInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddOnResultInstance
 */
/* jshint ignore:end */
AddOnResultInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a AddOnResultInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddOnResultInstance
 */
/* jshint ignore:end */
AddOnResultInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Access the payloads
 *
 * @function payloads
 * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultInstance#
 *
 * @returns {Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultContext.PayloadList}
 */
/* jshint ignore:end */
AddOnResultInstance.prototype.payloads = function payloads() {
  return this._proxy.payloads;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
AddOnResultInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AddOnResultInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AddOnResultContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultContext
 *
 * @property {Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultContext.PayloadList} payloads -
 *          payloads resource
 *
 * @param {V2010} version - Version of the resource
 * @param {sid} accountSid -
 *          The SID of the Account that created the resource to fetch
 * @param {sid} referenceSid -
 *          The SID of the recording to which the result to fetch belongs
 * @param {sid} sid - The unique string that identifies the resource to fetch
 */
/* jshint ignore:end */
AddOnResultContext = function AddOnResultContext(version, accountSid,
                                                  referenceSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {accountSid: accountSid, referenceSid: referenceSid, sid: sid, };
  this._uri = `/Accounts/${accountSid}/Recordings/${referenceSid}/AddOnResults/${sid}.json`;

  // Dependents
  this._payloads = undefined;
};

/* jshint ignore:start */
/**
 * fetch a AddOnResultInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddOnResultInstance
 */
/* jshint ignore:end */
AddOnResultContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new AddOnResultInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.referenceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a AddOnResultInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AddOnResultInstance
 */
/* jshint ignore:end */
AddOnResultContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(AddOnResultContext.prototype,
  'payloads', {
    get: function() {
      if (!this._payloads) {
        this._payloads = new PayloadList(
          this._version,
          this._solution.accountSid,
          this._solution.referenceSid,
          this._solution.sid
        );
      }
      return this._payloads;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.RecordingContext.AddOnResultContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
AddOnResultContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

AddOnResultContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  AddOnResultList: AddOnResultList,
  AddOnResultPage: AddOnResultPage,
  AddOnResultInstance: AddOnResultInstance,
  AddOnResultContext: AddOnResultContext
};
