/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import TrustedComms = require('../TrustedComms');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the CurrentCallList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function CurrentCallList(version: TrustedComms): CurrentCallListInstance;

/**
 * Options to pass to fetch
 *
 * @property xXcnamSensitivePhoneNumberFrom - The originating Phone Number
 * @property xXcnamSensitivePhoneNumberTo - The terminating Phone Number
 */
interface CurrentCallInstanceFetchOptions {
  xXcnamSensitivePhoneNumberFrom?: string;
  xXcnamSensitivePhoneNumberTo?: string;
}

interface CurrentCallListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): CurrentCallContext;
  /**
   * Constructs a current_call
   */
  get(): CurrentCallContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface CurrentCallPayload extends CurrentCallResource, Page.TwilioResponsePayload {
}

interface CurrentCallResource {
  bg_color: string;
  caller: string;
  created_at: Date;
  font_color: string;
  from: string;
  logo: string;
  manager: string;
  reason: string;
  shield_img: string;
  sid: string;
  status: string;
  to: string;
  url: string;
  use_case: string;
}

interface CurrentCallSolution {
}


declare class CurrentCallContext {
  /**
   * Initialize the CurrentCallContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   */
  constructor(version: TrustedComms);

  /**
   * fetch a CurrentCallInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CurrentCallInstance) => any): Promise<CurrentCallInstance>;
  /**
   * fetch a CurrentCallInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: CurrentCallInstanceFetchOptions, callback?: (error: Error | null, items: CurrentCallInstance) => any): Promise<CurrentCallInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class CurrentCallInstance extends SerializableClass {
  /**
   * Initialize the CurrentCallContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: TrustedComms, payload: CurrentCallPayload);

  private _proxy: CurrentCallContext;
  bgColor: string;
  caller: string;
  createdAt: Date;
  /**
   * fetch a CurrentCallInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CurrentCallInstance) => any): Promise<CurrentCallInstance>;
  /**
   * fetch a CurrentCallInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: CurrentCallInstanceFetchOptions, callback?: (error: Error | null, items: CurrentCallInstance) => any): Promise<CurrentCallInstance>;
  fontColor: string;
  from: string;
  logo: string;
  manager: string;
  reason: string;
  shieldImg: string;
  sid: string;
  status: string;
  to: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  useCase: string;
}


declare class CurrentCallPage extends Page<TrustedComms, CurrentCallPayload, CurrentCallResource, CurrentCallInstance> {
  /**
   * Initialize the CurrentCallPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: TrustedComms, response: Response<string>, solution: CurrentCallSolution);

  /**
   * Build an instance of CurrentCallInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: CurrentCallPayload): CurrentCallInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { CurrentCallContext, CurrentCallInstance, CurrentCallInstanceFetchOptions, CurrentCallList, CurrentCallListInstance, CurrentCallPage, CurrentCallPayload, CurrentCallResource, CurrentCallSolution }
