'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var AssistantFallbackActionsList;
var AssistantFallbackActionsPage;
var AssistantFallbackActionsInstance;
var AssistantFallbackActionsContext;

/* jshint ignore:start */
/**
 * Initialize the AssistantFallbackActionsList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsList
 *
 * @param {Twilio.Preview.Understand} version - Version of the resource
 * @param {string} assistantSid - The assistant_sid
 */
/* jshint ignore:end */
AssistantFallbackActionsList = function AssistantFallbackActionsList(version,
    assistantSid) {
  /* jshint ignore:start */
  /**
   * @function assistantFallbackActions
   * @memberof Twilio.Preview.Understand.AssistantContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsContext}
   */
  /* jshint ignore:end */
  function AssistantFallbackActionsListInstance(sid) {
    return AssistantFallbackActionsListInstance.get(sid);
  }

  AssistantFallbackActionsListInstance._version = version;
  // Path Solution
  AssistantFallbackActionsListInstance._solution = {assistantSid: assistantSid};
  /* jshint ignore:start */
  /**
   * Constructs a assistant_fallback_actions
   *
   * @function get
   * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsList#
   *
   * @returns {Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsContext}
   */
  /* jshint ignore:end */
  AssistantFallbackActionsListInstance.get = function get() {
    return new AssistantFallbackActionsContext(this._version, this._solution.assistantSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  AssistantFallbackActionsListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  AssistantFallbackActionsListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return AssistantFallbackActionsListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the AssistantFallbackActionsPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsPage
 *
 * @param {Understand} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {AssistantFallbackActionsSolution} solution - Path solution
 *
 * @returns AssistantFallbackActionsPage
 */
/* jshint ignore:end */
AssistantFallbackActionsPage = function AssistantFallbackActionsPage(version,
    response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(AssistantFallbackActionsPage.prototype, Page.prototype);
AssistantFallbackActionsPage.prototype.constructor = AssistantFallbackActionsPage;

/* jshint ignore:start */
/**
 * Build an instance of AssistantFallbackActionsInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsPage#
 *
 * @param {AssistantFallbackActionsPayload} payload - Payload response from the API
 *
 * @returns AssistantFallbackActionsInstance
 */
/* jshint ignore:end */
AssistantFallbackActionsPage.prototype.getInstance = function
    getInstance(payload) {
  return new AssistantFallbackActionsInstance(this._version, payload, this._solution.assistantSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
AssistantFallbackActionsPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AssistantFallbackActionsPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AssistantFallbackActionsContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsInstance
 *
 * @property {string} accountSid - The account_sid
 * @property {string} assistantSid - The assistant_sid
 * @property {string} url - The url
 * @property {object} data - The data
 *
 * @param {Understand} version - Version of the resource
 * @param {AssistantFallbackActionsPayload} payload - The instance payload
 * @param {sid} assistantSid - The assistant_sid
 */
/* jshint ignore:end */
AssistantFallbackActionsInstance = function
    AssistantFallbackActionsInstance(version, payload, assistantSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.assistantSid = payload.assistant_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.data = payload.data; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {assistantSid: assistantSid, };
};

Object.defineProperty(AssistantFallbackActionsInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new AssistantFallbackActionsContext(this._version, this._solution.assistantSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a AssistantFallbackActionsInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AssistantFallbackActionsInstance
 */
/* jshint ignore:end */
AssistantFallbackActionsInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a AssistantFallbackActionsInstance
 *
 * @function update
 * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {object} [opts.fallbackActions] - The fallback_actions
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AssistantFallbackActionsInstance
 */
/* jshint ignore:end */
AssistantFallbackActionsInstance.prototype.update = function update(opts,
    callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
AssistantFallbackActionsInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AssistantFallbackActionsInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AssistantFallbackActionsContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsContext
 *
 * @param {Understand} version - Version of the resource
 * @param {sid_like} assistantSid - The assistant_sid
 */
/* jshint ignore:end */
AssistantFallbackActionsContext = function
    AssistantFallbackActionsContext(version, assistantSid) {
  this._version = version;

  // Path Solution
  this._solution = {assistantSid: assistantSid, };
  this._uri = `/Assistants/${assistantSid}/FallbackActions`;
};

/* jshint ignore:start */
/**
 * fetch a AssistantFallbackActionsInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AssistantFallbackActionsInstance
 */
/* jshint ignore:end */
AssistantFallbackActionsContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new AssistantFallbackActionsInstance(
      this._version,
      payload,
      this._solution.assistantSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a AssistantFallbackActionsInstance
 *
 * @function update
 * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsContext#
 *
 * @param {object} [opts] - Options for request
 * @param {object} [opts.fallbackActions] - The fallback_actions
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AssistantFallbackActionsInstance
 */
/* jshint ignore:end */
AssistantFallbackActionsContext.prototype.update = function update(opts,
    callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'FallbackActions': serialize.object(_.get(opts, 'fallbackActions'))});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new AssistantFallbackActionsInstance(
      this._version,
      payload,
      this._solution.assistantSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Understand.AssistantContext.AssistantFallbackActionsContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
AssistantFallbackActionsContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

AssistantFallbackActionsContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  AssistantFallbackActionsList: AssistantFallbackActionsList,
  AssistantFallbackActionsPage: AssistantFallbackActionsPage,
  AssistantFallbackActionsInstance: AssistantFallbackActionsInstance,
  AssistantFallbackActionsContext: AssistantFallbackActionsContext
};
