/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

type FlowValidateStatus = 'draft'|'published';

/**
 * Initialize the FlowValidateList
 *
 * @param version - Version of the resource
 */
declare function FlowValidateList(version: V2): FlowValidateListInstance;

interface FlowValidateListInstance {
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a FlowValidateInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: FlowValidateListInstanceUpdateOptions, callback?: (error: Error | null, items: FlowValidateListInstance) => any): Promise<FlowValidateInstance>;
}

/**
 * Options to pass to update
 *
 * @property commitMessage - Description of change made in the revision
 * @property definition - JSON representation of flow definition
 * @property friendlyName - The string that you assigned to describe the Flow
 * @property status - The status of the Flow
 */
interface FlowValidateListInstanceUpdateOptions {
  commitMessage?: string;
  definition: object;
  friendlyName: string;
  status: FlowValidateStatus;
}

interface FlowValidatePayload extends FlowValidateResource, Page.TwilioResponsePayload {
}

interface FlowValidateResource {
  valid: boolean;
}

interface FlowValidateSolution {
}


declare class FlowValidateInstance extends SerializableClass {
  /**
   * Initialize the FlowValidateContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V2, payload: FlowValidatePayload);

  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  valid: boolean;
}


declare class FlowValidatePage extends Page<V2, FlowValidatePayload, FlowValidateResource, FlowValidateInstance> {
  /**
   * Initialize the FlowValidatePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: FlowValidateSolution);

  /**
   * Build an instance of FlowValidateInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: FlowValidatePayload): FlowValidateInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { FlowValidateInstance, FlowValidateList, FlowValidateListInstance, FlowValidateListInstanceUpdateOptions, FlowValidatePage, FlowValidatePayload, FlowValidateResource, FlowValidateSolution, FlowValidateStatus }
