/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the ExternalCampaignList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function ExternalCampaignList(version: V1): ExternalCampaignListInstance;

interface ExternalCampaignListInstance {
  /**
   * create a ExternalCampaignInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: ExternalCampaignListInstanceCreateOptions, callback?: (error: Error | null, item: ExternalCampaignInstance) => any): Promise<ExternalCampaignInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property campaignId - ID of the preregistered campaign.
 * @property messagingServiceSid - The SID of the Messaging Service the resource is associated with
 */
interface ExternalCampaignListInstanceCreateOptions {
  campaignId: string;
  messagingServiceSid: string;
}

interface ExternalCampaignPayload extends ExternalCampaignResource, Page.TwilioResponsePayload {
}

interface ExternalCampaignResource {
  account_sid: string;
  campaign_id: string;
  date_created: Date;
  messaging_service_sid: string;
  sid: string;
}

interface ExternalCampaignSolution {
}


declare class ExternalCampaignInstance extends SerializableClass {
  /**
   * Initialize the ExternalCampaignContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: ExternalCampaignPayload);

  accountSid: string;
  campaignId: string;
  dateCreated: Date;
  messagingServiceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class ExternalCampaignPage extends Page<V1, ExternalCampaignPayload, ExternalCampaignResource, ExternalCampaignInstance> {
  /**
   * Initialize the ExternalCampaignPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ExternalCampaignSolution);

  /**
   * Build an instance of ExternalCampaignInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ExternalCampaignPayload): ExternalCampaignInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ExternalCampaignInstance, ExternalCampaignList, ExternalCampaignListInstance, ExternalCampaignListInstanceCreateOptions, ExternalCampaignPage, ExternalCampaignPayload, ExternalCampaignResource, ExternalCampaignSolution }
