/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the WorkersStatisticsList
 *
 * @param version - Version of the resource
 * @param workspaceSid - The SID of the Workspace that contains the Worker
 */
declare function WorkersStatisticsList(version: V1, workspaceSid: string): WorkersStatisticsListInstance;

/**
 * Options to pass to fetch
 *
 * @property endDate - Only calculate statistics from this date and time and earlier
 * @property friendlyName - Only include Workers with `friendly_name` values that match this parameter
 * @property minutes - Only calculate statistics since this many minutes in the past
 * @property startDate - Only calculate statistics from on or after this date
 * @property taskChannel - Only calculate statistics on this TaskChannel
 * @property taskQueueName - The friendly_name of the TaskQueue for which to fetch Worker statistics
 * @property taskQueueSid - The SID of the TaskQueue for which to fetch Worker statistics
 */
interface WorkersStatisticsInstanceFetchOptions {
  endDate?: Date;
  friendlyName?: string;
  minutes?: number;
  startDate?: Date;
  taskChannel?: string;
  taskQueueName?: string;
  taskQueueSid?: string;
}

interface WorkersStatisticsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): WorkersStatisticsContext;
  /**
   * Constructs a workers_statistics
   */
  get(): WorkersStatisticsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface WorkersStatisticsPayload extends WorkersStatisticsResource, Page.TwilioResponsePayload {
}

interface WorkersStatisticsResource {
  account_sid: string;
  cumulative: object;
  realtime: object;
  url: string;
  workspace_sid: string;
}

interface WorkersStatisticsSolution {
  workspaceSid?: string;
}


declare class WorkersStatisticsContext {
  /**
   * Initialize the WorkersStatisticsContext
   *
   * @param version - Version of the resource
   * @param workspaceSid - The SID of the Workspace with the Worker to fetch
   */
  constructor(version: V1, workspaceSid: string);

  /**
   * fetch a WorkersStatisticsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: WorkersStatisticsInstance) => any): Promise<WorkersStatisticsInstance>;
  /**
   * fetch a WorkersStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: WorkersStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: WorkersStatisticsInstance) => any): Promise<WorkersStatisticsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class WorkersStatisticsInstance extends SerializableClass {
  /**
   * Initialize the WorkersStatisticsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param workspaceSid - The SID of the Workspace that contains the Worker
   */
  constructor(version: V1, payload: WorkersStatisticsPayload, workspaceSid: string);

  private _proxy: WorkersStatisticsContext;
  accountSid: string;
  cumulative: any;
  /**
   * fetch a WorkersStatisticsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: WorkersStatisticsInstance) => any): Promise<WorkersStatisticsInstance>;
  /**
   * fetch a WorkersStatisticsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: WorkersStatisticsInstanceFetchOptions, callback?: (error: Error | null, items: WorkersStatisticsInstance) => any): Promise<WorkersStatisticsInstance>;
  realtime: any;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  workspaceSid: string;
}


declare class WorkersStatisticsPage extends Page<V1, WorkersStatisticsPayload, WorkersStatisticsResource, WorkersStatisticsInstance> {
  /**
   * Initialize the WorkersStatisticsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: WorkersStatisticsSolution);

  /**
   * Build an instance of WorkersStatisticsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: WorkersStatisticsPayload): WorkersStatisticsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { WorkersStatisticsContext, WorkersStatisticsInstance, WorkersStatisticsInstanceFetchOptions, WorkersStatisticsList, WorkersStatisticsListInstance, WorkersStatisticsPage, WorkersStatisticsPayload, WorkersStatisticsResource, WorkersStatisticsSolution }
