/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */


declare class MessagingResponse {
  /**
   * <Response> TwiML for Messages
   */
  constructor();

  /**
   * <Message> TwiML Verb
   *
   * @param body - Message Body
   */
  message(body: string): MessagingResponse.Message;
  /**
   * <Message> TwiML Verb
   *
   * @param attributes - TwiML attributes
   * @param body - Message Body
   */
  message(attributes: MessagingResponse.MessageAttributes, body: string): MessagingResponse.Message;
  /**
   * <Redirect> TwiML Verb
   *
   * @param url - Redirect URL
   */
  redirect(url: string): void;
  /**
   * <Redirect> TwiML Verb
   *
   * @param attributes - TwiML attributes
   * @param url - Redirect URL
   */
  redirect(attributes: MessagingResponse.RedirectAttributes, url: string): void;
  /**
   * Convert to XML
   */
  toString(): string;
}

declare namespace MessagingResponse {

  /**
   * Options to pass to message
   *
   * @property action - Action URL
   * @property from - Phone Number to send Message from
   * @property method - Action URL Method
   * @property statusCallback - Status callback URL. Deprecated in favor of action.
   * @property to - Phone Number to send Message to
   */
  export interface MessageAttributes {
    action?: string;
    from?: string;
    method?: string;
    statusCallback?: string;
    to?: string;
  }

  /**
   * Options to pass to redirect
   *
   * @property method - Redirect URL method
   */
  export interface RedirectAttributes {
    method?: string;
  }


  class Message {

    /**
     * <Body> TwiML Noun
     *
     * @param message - Message Body
     */
    body(message: string): void;
    /**
     * <Body> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param message - Message Body
     */
    body(attributes: object, message: string): void;
    /**
     * <Media> TwiML Noun
     *
     * @param url - Media URL
     */
    media(url: string): void;
    /**
     * <Media> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param url - Media URL
     */
    media(attributes: object, url: string): void;
  }
}

export = MessagingResponse;
