/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the SinkValidateList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param sid - A string that uniquely identifies this Sink.
 */
declare function SinkValidateList(version: V1, sid: string): SinkValidateListInstance;

interface SinkValidateListInstance {
  /**
   * create a SinkValidateInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: SinkValidateListInstanceCreateOptions, callback?: (error: Error | null, item: SinkValidateInstance) => any): Promise<SinkValidateInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property testId - A string that uniquely identifies the test event for a Sink being validated.
 */
interface SinkValidateListInstanceCreateOptions {
  testId: string;
}

interface SinkValidatePayload extends SinkValidateResource, Page.TwilioResponsePayload {
}

interface SinkValidateResource {
  result: string;
}

interface SinkValidateSolution {
  sid?: string;
}


declare class SinkValidateInstance extends SerializableClass {
  /**
   * Initialize the SinkValidateContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - A string that uniquely identifies this Sink.
   */
  constructor(version: V1, payload: SinkValidatePayload, sid: string);

  result: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class SinkValidatePage extends Page<V1, SinkValidatePayload, SinkValidateResource, SinkValidateInstance> {
  /**
   * Initialize the SinkValidatePage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SinkValidateSolution);

  /**
   * Build an instance of SinkValidateInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SinkValidatePayload): SinkValidateInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SinkValidateInstance, SinkValidateList, SinkValidateListInstance, SinkValidateListInstanceCreateOptions, SinkValidatePage, SinkValidatePayload, SinkValidateResource, SinkValidateSolution }
