/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type WebChannelChatStatus = 'inactive';

/**
 * Initialize the WebChannelList
 *
 * @param version - Version of the resource
 */
declare function WebChannelList(version: V1): WebChannelListInstance;

/**
 * Options to pass to update
 *
 * @property chatStatus - The chat status
 * @property postEngagementData - The post-engagement data
 */
interface WebChannelInstanceUpdateOptions {
  chatStatus?: WebChannelChatStatus;
  postEngagementData?: string;
}

interface WebChannelListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): WebChannelContext;
  /**
   * create a WebChannelInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: WebChannelListInstanceCreateOptions, callback?: (error: Error | null, item: WebChannelInstance) => any): Promise<WebChannelInstance>;
  /**
   * Streams WebChannelInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: WebChannelInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams WebChannelInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: WebChannelListInstanceEachOptions, callback?: (item: WebChannelInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a web_channel
   *
   * @param sid - The SID of the WebChannel resource to fetch
   */
  get(sid: string): WebChannelContext;
  /**
   * Retrieve a single target page of WebChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: WebChannelPage) => any): Promise<WebChannelPage>;
  /**
   * Retrieve a single target page of WebChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: WebChannelPage) => any): Promise<WebChannelPage>;
  /**
   * Lists WebChannelInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: WebChannelInstance[]) => any): Promise<WebChannelInstance[]>;
  /**
   * Lists WebChannelInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: WebChannelListInstanceOptions, callback?: (error: Error | null, items: WebChannelInstance[]) => any): Promise<WebChannelInstance[]>;
  /**
   * Retrieve a single page of WebChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: WebChannelPage) => any): Promise<WebChannelPage>;
  /**
   * Retrieve a single page of WebChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: WebChannelListInstancePageOptions, callback?: (error: Error | null, items: WebChannelPage) => any): Promise<WebChannelPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property chatFriendlyName - The chat channel's friendly name
 * @property chatUniqueName - The chat channel's unique name
 * @property customerFriendlyName - The chat participant's friendly name
 * @property flexFlowSid - The SID of the Flex Flow
 * @property identity - The chat identity
 * @property preEngagementData - The pre-engagement data
 */
interface WebChannelListInstanceCreateOptions {
  chatFriendlyName: string;
  chatUniqueName?: string;
  customerFriendlyName: string;
  flexFlowSid: string;
  identity: string;
  preEngagementData?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface WebChannelListInstanceEachOptions {
  callback?: (item: WebChannelInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface WebChannelListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface WebChannelListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface WebChannelPayload extends WebChannelResource, Page.TwilioResponsePayload {
}

interface WebChannelResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  flex_flow_sid: string;
  sid: string;
  url: string;
}

interface WebChannelSolution {
}


declare class WebChannelContext {
  /**
   * Initialize the WebChannelContext
   *
   * @param version - Version of the resource
   * @param sid - The SID of the WebChannel resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a WebChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: WebChannelInstance) => any): Promise<WebChannelInstance>;
  /**
   * remove a WebChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: WebChannelInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a WebChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: WebChannelInstance) => any): Promise<WebChannelInstance>;
  /**
   * update a WebChannelInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: WebChannelInstanceUpdateOptions, callback?: (error: Error | null, items: WebChannelInstance) => any): Promise<WebChannelInstance>;
}


declare class WebChannelInstance extends SerializableClass {
  /**
   * Initialize the WebChannelContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID of the WebChannel resource to fetch
   */
  constructor(version: V1, payload: WebChannelPayload, sid: string);

  private _proxy: WebChannelContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a WebChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: WebChannelInstance) => any): Promise<WebChannelInstance>;
  flexFlowSid: string;
  /**
   * remove a WebChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: WebChannelInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a WebChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: WebChannelInstance) => any): Promise<WebChannelInstance>;
  /**
   * update a WebChannelInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: WebChannelInstanceUpdateOptions, callback?: (error: Error | null, items: WebChannelInstance) => any): Promise<WebChannelInstance>;
  url: string;
}


declare class WebChannelPage extends Page<V1, WebChannelPayload, WebChannelResource, WebChannelInstance> {
  /**
   * Initialize the WebChannelPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: WebChannelSolution);

  /**
   * Build an instance of WebChannelInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: WebChannelPayload): WebChannelInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { WebChannelChatStatus, WebChannelContext, WebChannelInstance, WebChannelInstanceUpdateOptions, WebChannelList, WebChannelListInstance, WebChannelListInstanceCreateOptions, WebChannelListInstanceEachOptions, WebChannelListInstanceOptions, WebChannelListInstancePageOptions, WebChannelPage, WebChannelPayload, WebChannelResource, WebChannelSolution }
