/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V1 = require('../../../V1');
import { SerializableClass } from '../../../../../interfaces';

type BuildStatusStatus = 'building'|'completed'|'failed';

/**
 * Initialize the BuildStatusList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param serviceSid - The SID of the Service that the Build resource is associated with
 * @param sid - The unique string that identifies the Build resource
 */
declare function BuildStatusList(version: V1, serviceSid: string, sid: string): BuildStatusListInstance;

interface BuildStatusListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): BuildStatusContext;
  /**
   * Constructs a build_status
   */
  get(): BuildStatusContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface BuildStatusPayload extends BuildStatusResource, Page.TwilioResponsePayload {
}

interface BuildStatusResource {
  account_sid: string;
  service_sid: string;
  sid: string;
  status: BuildStatusStatus;
  url: string;
}

interface BuildStatusSolution {
  serviceSid?: string;
  sid?: string;
}


declare class BuildStatusContext {
  /**
   * Initialize the BuildStatusContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param serviceSid - The SID of the Service to fetch the Build resource from
   * @param sid - The SID of the Build resource to fetch
   */
  constructor(version: V1, serviceSid: string, sid: string);

  /**
   * fetch a BuildStatusInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BuildStatusInstance) => any): Promise<BuildStatusInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class BuildStatusInstance extends SerializableClass {
  /**
   * Initialize the BuildStatusContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - The SID of the Service that the Build resource is associated with
   * @param sid - The unique string that identifies the Build resource
   */
  constructor(version: V1, payload: BuildStatusPayload, serviceSid: string, sid: string);

  private _proxy: BuildStatusContext;
  accountSid: string;
  /**
   * fetch a BuildStatusInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BuildStatusInstance) => any): Promise<BuildStatusInstance>;
  serviceSid: string;
  sid: string;
  status: BuildStatusStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class BuildStatusPage extends Page<V1, BuildStatusPayload, BuildStatusResource, BuildStatusInstance> {
  /**
   * Initialize the BuildStatusPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: BuildStatusSolution);

  /**
   * Build an instance of BuildStatusInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BuildStatusPayload): BuildStatusInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BuildStatusContext, BuildStatusInstance, BuildStatusList, BuildStatusListInstance, BuildStatusPage, BuildStatusPayload, BuildStatusResource, BuildStatusSolution, BuildStatusStatus }
