/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type RecordingRecordingMode = 'do-not-record'|'record-from-ringing'|'record-from-answer'|'record-from-ringing-dual'|'record-from-answer-dual';

type RecordingRecordingTrim = 'trim-silence'|'do-not-trim';

/**
 * Initialize the RecordingList
 *
 * @param version - Version of the resource
 * @param trunkSid - The unique string that identifies the resource
 */
declare function RecordingList(version: V1, trunkSid: string): RecordingListInstance;

/**
 * Options to pass to update
 *
 * @property mode - The recording mode for the trunk.
 * @property trim - The recording trim setting for the trunk.
 */
interface RecordingInstanceUpdateOptions {
  mode?: RecordingRecordingMode;
  trim?: RecordingRecordingTrim;
}

interface RecordingListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): RecordingContext;
  /**
   * Constructs a recording
   */
  get(): RecordingContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface RecordingPayload extends RecordingResource, Page.TwilioResponsePayload {
}

interface RecordingResource {
  mode: RecordingRecordingMode;
  trim: RecordingRecordingTrim;
}

interface RecordingSolution {
  trunkSid?: string;
}


declare class RecordingContext {
  /**
   * Initialize the RecordingContext
   *
   * @param version - Version of the resource
   * @param trunkSid - The SID of the Trunk from which to fetch the recording settings.
   */
  constructor(version: V1, trunkSid: string);

  /**
   * fetch a RecordingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: RecordingInstance) => any): Promise<RecordingInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a RecordingInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: RecordingInstance) => any): Promise<RecordingInstance>;
  /**
   * update a RecordingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: RecordingInstanceUpdateOptions, callback?: (error: Error | null, items: RecordingInstance) => any): Promise<RecordingInstance>;
}


declare class RecordingInstance extends SerializableClass {
  /**
   * Initialize the RecordingContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param trunkSid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: RecordingPayload, trunkSid: string);

  private _proxy: RecordingContext;
  /**
   * fetch a RecordingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: RecordingInstance) => any): Promise<RecordingInstance>;
  mode: RecordingRecordingMode;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  trim: RecordingRecordingTrim;
  /**
   * update a RecordingInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: RecordingInstance) => any): Promise<RecordingInstance>;
  /**
   * update a RecordingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: RecordingInstanceUpdateOptions, callback?: (error: Error | null, items: RecordingInstance) => any): Promise<RecordingInstance>;
}


declare class RecordingPage extends Page<V1, RecordingPayload, RecordingResource, RecordingInstance> {
  /**
   * Initialize the RecordingPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: RecordingSolution);

  /**
   * Build an instance of RecordingInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: RecordingPayload): RecordingInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { RecordingContext, RecordingInstance, RecordingInstanceUpdateOptions, RecordingList, RecordingListInstance, RecordingPage, RecordingPayload, RecordingRecordingMode, RecordingRecordingTrim, RecordingResource, RecordingSolution }
