/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';
import { SubscribedEventList } from './subscription/subscribedEvent';
import { SubscribedEventListInstance } from './subscription/subscribedEvent';

/**
 * Initialize the SubscriptionList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function SubscriptionList(version: V1): SubscriptionListInstance;

/**
 * Options to pass to update
 *
 * @property description - Subscription description.
 * @property sinkSid - Sink SID.
 */
interface SubscriptionInstanceUpdateOptions {
  description?: string;
  sinkSid?: string;
}

interface SubscriptionListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SubscriptionContext;
  /**
   * create a SubscriptionInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: SubscriptionListInstanceCreateOptions, callback?: (error: Error | null, item: SubscriptionInstance) => any): Promise<SubscriptionInstance>;
  /**
   * Streams SubscriptionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: SubscriptionInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams SubscriptionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: SubscriptionListInstanceEachOptions, callback?: (item: SubscriptionInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a subscription
   *
   * @param sid - A string that uniquely identifies this Subscription.
   */
  get(sid: string): SubscriptionContext;
  /**
   * Retrieve a single target page of SubscriptionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: SubscriptionPage) => any): Promise<SubscriptionPage>;
  /**
   * Retrieve a single target page of SubscriptionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: SubscriptionPage) => any): Promise<SubscriptionPage>;
  /**
   * Lists SubscriptionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: SubscriptionInstance[]) => any): Promise<SubscriptionInstance[]>;
  /**
   * Lists SubscriptionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: SubscriptionListInstanceOptions, callback?: (error: Error | null, items: SubscriptionInstance[]) => any): Promise<SubscriptionInstance[]>;
  /**
   * Retrieve a single page of SubscriptionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: SubscriptionPage) => any): Promise<SubscriptionPage>;
  /**
   * Retrieve a single page of SubscriptionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: SubscriptionListInstancePageOptions, callback?: (error: Error | null, items: SubscriptionPage) => any): Promise<SubscriptionPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property description - Subscription description
 * @property sinkSid - Sink SID.
 * @property types - Subscribed Event Types
 */
interface SubscriptionListInstanceCreateOptions {
  description: string;
  sinkSid: string;
  types: object | object[];
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property sinkSid - Sink SID.
 */
interface SubscriptionListInstanceEachOptions {
  callback?: (item: SubscriptionInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
  sinkSid?: string;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property sinkSid - Sink SID.
 */
interface SubscriptionListInstanceOptions {
  limit?: number;
  pageSize?: number;
  sinkSid?: string;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property sinkSid - Sink SID.
 */
interface SubscriptionListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  sinkSid?: string;
}

interface SubscriptionPayload extends SubscriptionResource, Page.TwilioResponsePayload {
}

interface SubscriptionResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  description: string;
  links: string;
  sid: string;
  sink_sid: string;
  url: string;
}

interface SubscriptionSolution {
}


declare class SubscriptionContext {
  /**
   * Initialize the SubscriptionContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param sid - A string that uniquely identifies this Subscription.
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a SubscriptionInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SubscriptionInstance) => any): Promise<SubscriptionInstance>;
  /**
   * remove a SubscriptionInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SubscriptionInstance) => any): Promise<boolean>;
  subscribedEvents: SubscribedEventListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SubscriptionInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: SubscriptionInstance) => any): Promise<SubscriptionInstance>;
  /**
   * update a SubscriptionInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SubscriptionInstanceUpdateOptions, callback?: (error: Error | null, items: SubscriptionInstance) => any): Promise<SubscriptionInstance>;
}


declare class SubscriptionInstance extends SerializableClass {
  /**
   * Initialize the SubscriptionContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - A string that uniquely identifies this Subscription.
   */
  constructor(version: V1, payload: SubscriptionPayload, sid: string);

  private _proxy: SubscriptionContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  description: string;
  /**
   * fetch a SubscriptionInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SubscriptionInstance) => any): Promise<SubscriptionInstance>;
  links: string;
  /**
   * remove a SubscriptionInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SubscriptionInstance) => any): Promise<boolean>;
  sid: string;
  sinkSid: string;
  /**
   * Access the subscribedEvents
   */
  subscribedEvents(): SubscribedEventListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SubscriptionInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: SubscriptionInstance) => any): Promise<SubscriptionInstance>;
  /**
   * update a SubscriptionInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SubscriptionInstanceUpdateOptions, callback?: (error: Error | null, items: SubscriptionInstance) => any): Promise<SubscriptionInstance>;
  url: string;
}


declare class SubscriptionPage extends Page<V1, SubscriptionPayload, SubscriptionResource, SubscriptionInstance> {
  /**
   * Initialize the SubscriptionPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SubscriptionSolution);

  /**
   * Build an instance of SubscriptionInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SubscriptionPayload): SubscriptionInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SubscriptionContext, SubscriptionInstance, SubscriptionInstanceUpdateOptions, SubscriptionList, SubscriptionListInstance, SubscriptionListInstanceCreateOptions, SubscriptionListInstanceEachOptions, SubscriptionListInstanceOptions, SubscriptionListInstancePageOptions, SubscriptionPage, SubscriptionPayload, SubscriptionResource, SubscriptionSolution }
