'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var FieldValueList;
var FieldValuePage;
var FieldValueInstance;
var FieldValueContext;

/* jshint ignore:start */
/**
 * Initialize the FieldValueList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueList
 *
 * @param {Twilio.Preview.Understand} version - Version of the resource
 * @param {string} assistantSid - The unique ID of the Assistant.
 * @param {string} fieldTypeSid -
 *          The unique ID of the Field Type associated with this Field Value.
 */
/* jshint ignore:end */
FieldValueList = function FieldValueList(version, assistantSid, fieldTypeSid) {
  /* jshint ignore:start */
  /**
   * @function fieldValues
   * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueContext}
   */
  /* jshint ignore:end */
  function FieldValueListInstance(sid) {
    return FieldValueListInstance.get(sid);
  }

  FieldValueListInstance._version = version;
  // Path Solution
  FieldValueListInstance._solution = {assistantSid: assistantSid, fieldTypeSid: fieldTypeSid};
  FieldValueListInstance._uri = `/Assistants/${assistantSid}/FieldTypes/${fieldTypeSid}/FieldValues`;
  /* jshint ignore:start */
  /**
   * Streams FieldValueInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.language] -
   *          An ISO language-country string of the value. For example: en-US
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  FieldValueListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists FieldValueInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.language] -
   *          An ISO language-country string of the value. For example: en-US
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FieldValueListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of FieldValueInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.language] -
   *          An ISO language-country string of the value. For example: en-US
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FieldValueListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Language': _.get(opts, 'language'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FieldValuePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of FieldValueInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FieldValueListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new FieldValuePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a FieldValueInstance
   *
   * @function create
   * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.language - An ISO language-country string of the value.
   * @param {string} opts.value -
   *          A user-provided string that uniquely identifies this resource as an alternative to the sid. Unique up to 64 characters long.
   * @param {string} [opts.synonymOf] -
   *          A value that indicates this field value is a synonym of. Empty if the value is not a synonym.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed FieldValueInstance
   */
  /* jshint ignore:end */
  FieldValueListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.language)) {
      throw new Error('Required parameter "opts.language" missing.');
    }
    if (_.isUndefined(opts.value)) {
      throw new Error('Required parameter "opts.value" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'Language': _.get(opts, 'language'),
      'Value': _.get(opts, 'value'),
      'SynonymOf': _.get(opts, 'synonymOf')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FieldValueInstance(
        this._version,
        payload,
        this._solution.assistantSid,
        this._solution.fieldTypeSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a field_value
   *
   * @function get
   * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueList#
   *
   * @param {string} sid - The sid
   *
   * @returns {Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueContext}
   */
  /* jshint ignore:end */
  FieldValueListInstance.get = function get(sid) {
    return new FieldValueContext(
      this._version,
      this._solution.assistantSid,
      this._solution.fieldTypeSid,
      sid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  FieldValueListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  FieldValueListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return FieldValueListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the FieldValuePage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValuePage
 *
 * @param {Understand} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {FieldValueSolution} solution - Path solution
 *
 * @returns FieldValuePage
 */
/* jshint ignore:end */
FieldValuePage = function FieldValuePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(FieldValuePage.prototype, Page.prototype);
FieldValuePage.prototype.constructor = FieldValuePage;

/* jshint ignore:start */
/**
 * Build an instance of FieldValueInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValuePage#
 *
 * @param {FieldValuePayload} payload - Payload response from the API
 *
 * @returns FieldValueInstance
 */
/* jshint ignore:end */
FieldValuePage.prototype.getInstance = function getInstance(payload) {
  return new FieldValueInstance(
    this._version,
    payload,
    this._solution.assistantSid,
    this._solution.fieldTypeSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValuePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
FieldValuePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FieldValuePage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FieldValueContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueInstance
 *
 * @property {string} accountSid -
 *          The unique ID of the Account that created this Field Value.
 * @property {Date} dateCreated - The date that this resource was created
 * @property {Date} dateUpdated - The date that this resource was last updated
 * @property {string} fieldTypeSid -
 *          The unique ID of the Field Type associated with this Field Value.
 * @property {string} language - An ISO language-country string of the value.
 * @property {string} assistantSid - The unique ID of the Assistant.
 * @property {string} sid -
 *          A 34 character string that uniquely identifies this resource.
 * @property {string} value - The Field Value itself.
 * @property {string} url - The url
 * @property {string} synonymOf -
 *          A value that indicates this field value is a synonym of. Empty if the value is not a synonym.
 *
 * @param {Understand} version - Version of the resource
 * @param {FieldValuePayload} payload - The instance payload
 * @param {sid} assistantSid - The unique ID of the Assistant.
 * @param {sid} fieldTypeSid -
 *          The unique ID of the Field Type associated with this Field Value.
 * @param {sid_like} sid - The sid
 */
/* jshint ignore:end */
FieldValueInstance = function FieldValueInstance(version, payload, assistantSid,
                                                  fieldTypeSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.fieldTypeSid = payload.field_type_sid; // jshint ignore:line
  this.language = payload.language; // jshint ignore:line
  this.assistantSid = payload.assistant_sid; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.value = payload.value; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.synonymOf = payload.synonym_of; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {assistantSid: assistantSid, fieldTypeSid: fieldTypeSid, sid: sid || this.sid, };
};

Object.defineProperty(FieldValueInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new FieldValueContext(
          this._version,
          this._solution.assistantSid,
          this._solution.fieldTypeSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a FieldValueInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FieldValueInstance
 */
/* jshint ignore:end */
FieldValueInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a FieldValueInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FieldValueInstance
 */
/* jshint ignore:end */
FieldValueInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
FieldValueInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FieldValueInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FieldValueContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueContext
 *
 * @param {Understand} version - Version of the resource
 * @param {sid_like} assistantSid - The assistant_sid
 * @param {sid_like} fieldTypeSid - The field_type_sid
 * @param {sid_like} sid - The sid
 */
/* jshint ignore:end */
FieldValueContext = function FieldValueContext(version, assistantSid,
                                                fieldTypeSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {assistantSid: assistantSid, fieldTypeSid: fieldTypeSid, sid: sid, };
  this._uri = `/Assistants/${assistantSid}/FieldTypes/${fieldTypeSid}/FieldValues/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a FieldValueInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FieldValueInstance
 */
/* jshint ignore:end */
FieldValueContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new FieldValueInstance(
      this._version,
      payload,
      this._solution.assistantSid,
      this._solution.fieldTypeSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a FieldValueInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FieldValueInstance
 */
/* jshint ignore:end */
FieldValueContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Understand.AssistantContext.FieldTypeContext.FieldValueContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
FieldValueContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

FieldValueContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  FieldValueList: FieldValueList,
  FieldValuePage: FieldValuePage,
  FieldValueInstance: FieldValueInstance,
  FieldValueContext: FieldValueContext
};
