/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the NetworkAccessProfileNetworkList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param networkAccessProfileSid - The unique string that identifies the Network Access Profile resource
 */
declare function NetworkAccessProfileNetworkList(version: V1, networkAccessProfileSid: string): NetworkAccessProfileNetworkListInstance;

interface NetworkAccessProfileNetworkListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): NetworkAccessProfileNetworkContext;
  /**
   * create a NetworkAccessProfileNetworkInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: NetworkAccessProfileNetworkListInstanceCreateOptions, callback?: (error: Error | null, item: NetworkAccessProfileNetworkInstance) => any): Promise<NetworkAccessProfileNetworkInstance>;
  /**
   * Streams NetworkAccessProfileNetworkInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: NetworkAccessProfileNetworkInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams NetworkAccessProfileNetworkInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: NetworkAccessProfileNetworkListInstanceEachOptions, callback?: (item: NetworkAccessProfileNetworkInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a network_access_profile_network
   *
   * @param sid - The SID of the resource to fetch
   */
  get(sid: string): NetworkAccessProfileNetworkContext;
  /**
   * Retrieve a single target page of NetworkAccessProfileNetworkInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: NetworkAccessProfileNetworkPage) => any): Promise<NetworkAccessProfileNetworkPage>;
  /**
   * Retrieve a single target page of NetworkAccessProfileNetworkInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: NetworkAccessProfileNetworkPage) => any): Promise<NetworkAccessProfileNetworkPage>;
  /**
   * Lists NetworkAccessProfileNetworkInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: NetworkAccessProfileNetworkInstance[]) => any): Promise<NetworkAccessProfileNetworkInstance[]>;
  /**
   * Lists NetworkAccessProfileNetworkInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: NetworkAccessProfileNetworkListInstanceOptions, callback?: (error: Error | null, items: NetworkAccessProfileNetworkInstance[]) => any): Promise<NetworkAccessProfileNetworkInstance[]>;
  /**
   * Retrieve a single page of NetworkAccessProfileNetworkInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: NetworkAccessProfileNetworkPage) => any): Promise<NetworkAccessProfileNetworkPage>;
  /**
   * Retrieve a single page of NetworkAccessProfileNetworkInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: NetworkAccessProfileNetworkListInstancePageOptions, callback?: (error: Error | null, items: NetworkAccessProfileNetworkPage) => any): Promise<NetworkAccessProfileNetworkPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property network - The SID that identifies the Network resource
 */
interface NetworkAccessProfileNetworkListInstanceCreateOptions {
  network: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface NetworkAccessProfileNetworkListInstanceEachOptions {
  callback?: (item: NetworkAccessProfileNetworkInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface NetworkAccessProfileNetworkListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface NetworkAccessProfileNetworkListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface NetworkAccessProfileNetworkPayload extends NetworkAccessProfileNetworkResource, Page.TwilioResponsePayload {
}

interface NetworkAccessProfileNetworkResource {
  friendly_name: string;
  identifiers: object[];
  iso_country: string;
  network_access_profile_sid: string;
  sid: string;
  url: string;
}

interface NetworkAccessProfileNetworkSolution {
  networkAccessProfileSid?: string;
}


declare class NetworkAccessProfileNetworkContext {
  /**
   * Initialize the NetworkAccessProfileNetworkContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param networkAccessProfileSid - The unique string that identifies the Network Access Profile resource
   * @param sid - The SID of the resource to fetch
   */
  constructor(version: V1, networkAccessProfileSid: string, sid: string);

  /**
   * fetch a NetworkAccessProfileNetworkInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: NetworkAccessProfileNetworkInstance) => any): Promise<NetworkAccessProfileNetworkInstance>;
  /**
   * remove a NetworkAccessProfileNetworkInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: NetworkAccessProfileNetworkInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class NetworkAccessProfileNetworkInstance extends SerializableClass {
  /**
   * Initialize the NetworkAccessProfileNetworkContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param networkAccessProfileSid - The unique string that identifies the Network Access Profile resource
   * @param sid - The SID of the resource to fetch
   */
  constructor(version: V1, payload: NetworkAccessProfileNetworkPayload, networkAccessProfileSid: string, sid: string);

  private _proxy: NetworkAccessProfileNetworkContext;
  /**
   * fetch a NetworkAccessProfileNetworkInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: NetworkAccessProfileNetworkInstance) => any): Promise<NetworkAccessProfileNetworkInstance>;
  friendlyName: string;
  identifiers: object[];
  isoCountry: string;
  networkAccessProfileSid: string;
  /**
   * remove a NetworkAccessProfileNetworkInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: NetworkAccessProfileNetworkInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class NetworkAccessProfileNetworkPage extends Page<V1, NetworkAccessProfileNetworkPayload, NetworkAccessProfileNetworkResource, NetworkAccessProfileNetworkInstance> {
  /**
   * Initialize the NetworkAccessProfileNetworkPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: NetworkAccessProfileNetworkSolution);

  /**
   * Build an instance of NetworkAccessProfileNetworkInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: NetworkAccessProfileNetworkPayload): NetworkAccessProfileNetworkInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { NetworkAccessProfileNetworkContext, NetworkAccessProfileNetworkInstance, NetworkAccessProfileNetworkList, NetworkAccessProfileNetworkListInstance, NetworkAccessProfileNetworkListInstanceCreateOptions, NetworkAccessProfileNetworkListInstanceEachOptions, NetworkAccessProfileNetworkListInstanceOptions, NetworkAccessProfileNetworkListInstancePageOptions, NetworkAccessProfileNetworkPage, NetworkAccessProfileNetworkPayload, NetworkAccessProfileNetworkResource, NetworkAccessProfileNetworkSolution }
