'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var WorkflowRealTimeStatisticsList;
var WorkflowRealTimeStatisticsPage;
var WorkflowRealTimeStatisticsInstance;
var WorkflowRealTimeStatisticsContext;

/* jshint ignore:start */
/**
 * Initialize the WorkflowRealTimeStatisticsList
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsList
 *
 * @param {Twilio.Taskrouter.V1} version - Version of the resource
 * @param {string} workspaceSid -
 *          The SID of the Workspace that contains the Workflow.
 * @param {string} workflowSid -
 *          Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsList = function
    WorkflowRealTimeStatisticsList(version, workspaceSid, workflowSid) {
  /* jshint ignore:start */
  /**
   * @function realTimeStatistics
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsContext}
   */
  /* jshint ignore:end */
  function WorkflowRealTimeStatisticsListInstance(sid) {
    return WorkflowRealTimeStatisticsListInstance.get(sid);
  }

  WorkflowRealTimeStatisticsListInstance._version = version;
  // Path Solution
  WorkflowRealTimeStatisticsListInstance._solution = {
    workspaceSid: workspaceSid,
    workflowSid: workflowSid
  };
  /* jshint ignore:start */
  /**
   * Constructs a workflow_real_time_statistics
   *
   * @function get
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsList#
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsContext}
   */
  /* jshint ignore:end */
  WorkflowRealTimeStatisticsListInstance.get = function get() {
    return new WorkflowRealTimeStatisticsContext(
      this._version,
      this._solution.workspaceSid,
      this._solution.workflowSid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  WorkflowRealTimeStatisticsListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  WorkflowRealTimeStatisticsListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return WorkflowRealTimeStatisticsListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the WorkflowRealTimeStatisticsPage
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {WorkflowRealTimeStatisticsSolution} solution - Path solution
 *
 * @returns WorkflowRealTimeStatisticsPage
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsPage = function
    WorkflowRealTimeStatisticsPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(WorkflowRealTimeStatisticsPage.prototype, Page.prototype);
WorkflowRealTimeStatisticsPage.prototype.constructor = WorkflowRealTimeStatisticsPage;

/* jshint ignore:start */
/**
 * Build an instance of WorkflowRealTimeStatisticsInstance
 *
 * @function getInstance
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsPage#
 *
 * @param {WorkflowRealTimeStatisticsPayload} payload -
 *          Payload response from the API
 *
 * @returns WorkflowRealTimeStatisticsInstance
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsPage.prototype.getInstance = function
    getInstance(payload) {
  return new WorkflowRealTimeStatisticsInstance(
    this._version,
    payload,
    this._solution.workspaceSid,
    this._solution.workflowSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkflowRealTimeStatisticsPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkflowRealTimeStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {number} longestTaskWaitingAge - The age of the longest waiting Task
 * @property {string} longestTaskWaitingSid - The SID of the longest waiting Task
 * @property {object} tasksByPriority - The number of Tasks by priority
 * @property {object} tasksByStatus - The number of Tasks by their current status
 * @property {number} totalTasks - The total number of Tasks
 * @property {string} workflowSid -
 *          Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
 * @property {string} workspaceSid -
 *          The SID of the Workspace that contains the Workflow.
 * @property {string} url - The absolute URL of the Workflow statistics resource
 *
 * @param {V1} version - Version of the resource
 * @param {WorkflowRealTimeStatisticsPayload} payload - The instance payload
 * @param {sid} workspaceSid - The SID of the Workspace that contains the Workflow.
 * @param {sid} workflowSid -
 *          Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsInstance = function
    WorkflowRealTimeStatisticsInstance(version, payload, workspaceSid,
    workflowSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.longestTaskWaitingAge = deserialize.integer(payload.longest_task_waiting_age); // jshint ignore:line
  this.longestTaskWaitingSid = payload.longest_task_waiting_sid; // jshint ignore:line
  this.tasksByPriority = payload.tasks_by_priority; // jshint ignore:line
  this.tasksByStatus = payload.tasks_by_status; // jshint ignore:line
  this.totalTasks = deserialize.integer(payload.total_tasks); // jshint ignore:line
  this.workflowSid = payload.workflow_sid; // jshint ignore:line
  this.workspaceSid = payload.workspace_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {workspaceSid: workspaceSid, workflowSid: workflowSid, };
};

Object.defineProperty(WorkflowRealTimeStatisticsInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new WorkflowRealTimeStatisticsContext(
          this._version,
          this._solution.workspaceSid,
          this._solution.workflowSid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a WorkflowRealTimeStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.taskChannel] -
 *          Only calculate real-time statistics on this TaskChannel
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkflowRealTimeStatisticsInstance
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsInstance.prototype.fetch = function fetch(opts,
    callback) {
  return this._proxy.fetch(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkflowRealTimeStatisticsInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkflowRealTimeStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} workspaceSid - The SID of the Workspace with the Workflow to fetch
 * @param {sid} workflowSid -
 *          Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsContext = function
    WorkflowRealTimeStatisticsContext(version, workspaceSid, workflowSid) {
  this._version = version;

  // Path Solution
  this._solution = {workspaceSid: workspaceSid, workflowSid: workflowSid, };
  this._uri = `/Workspaces/${workspaceSid}/Workflows/${workflowSid}/RealTimeStatistics`;
};

/* jshint ignore:start */
/**
 * fetch a WorkflowRealTimeStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.taskChannel] -
 *          Only calculate real-time statistics on this TaskChannel
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkflowRealTimeStatisticsInstance
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsContext.prototype.fetch = function fetch(opts,
    callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'TaskChannel': _.get(opts, 'taskChannel')});

  var promise = this._version.fetch({uri: this._uri, method: 'GET', params: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new WorkflowRealTimeStatisticsInstance(
      this._version,
      payload,
      this._solution.workspaceSid,
      this._solution.workflowSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowRealTimeStatisticsContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkflowRealTimeStatisticsContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

WorkflowRealTimeStatisticsContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  WorkflowRealTimeStatisticsList: WorkflowRealTimeStatisticsList,
  WorkflowRealTimeStatisticsPage: WorkflowRealTimeStatisticsPage,
  WorkflowRealTimeStatisticsInstance: WorkflowRealTimeStatisticsInstance,
  WorkflowRealTimeStatisticsContext: WorkflowRealTimeStatisticsContext
};
