/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type SmsCommandDirection = 'to_sim'|'from_sim';

type SmsCommandStatus = 'queued'|'sent'|'delivered'|'received'|'failed';

/**
 * Initialize the SmsCommandList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function SmsCommandList(version: V1): SmsCommandListInstance;

interface SmsCommandListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SmsCommandContext;
  /**
   * create a SmsCommandInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: SmsCommandListInstanceCreateOptions, callback?: (error: Error | null, item: SmsCommandInstance) => any): Promise<SmsCommandInstance>;
  /**
   * Streams SmsCommandInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: SmsCommandInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams SmsCommandInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: SmsCommandListInstanceEachOptions, callback?: (item: SmsCommandInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a sms_command
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): SmsCommandContext;
  /**
   * Retrieve a single target page of SmsCommandInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: SmsCommandPage) => any): Promise<SmsCommandPage>;
  /**
   * Retrieve a single target page of SmsCommandInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: SmsCommandPage) => any): Promise<SmsCommandPage>;
  /**
   * Lists SmsCommandInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: SmsCommandInstance[]) => any): Promise<SmsCommandInstance[]>;
  /**
   * Lists SmsCommandInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: SmsCommandListInstanceOptions, callback?: (error: Error | null, items: SmsCommandInstance[]) => any): Promise<SmsCommandInstance[]>;
  /**
   * Retrieve a single page of SmsCommandInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: SmsCommandPage) => any): Promise<SmsCommandPage>;
  /**
   * Retrieve a single page of SmsCommandInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: SmsCommandListInstancePageOptions, callback?: (error: Error | null, items: SmsCommandPage) => any): Promise<SmsCommandPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property callbackMethod - The HTTP method we should use to call callback_url
 * @property callbackUrl - The URL we should call after we have sent the command
 * @property payload - The message body of the SMS Command
 * @property sim - The sid or unique_name of the SIM to send the SMS Command to
 */
interface SmsCommandListInstanceCreateOptions {
  callbackMethod?: string;
  callbackUrl?: string;
  payload: string;
  sim: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property direction - The direction of the SMS Command
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property sim - The SID or unique name of the Sim resource that SMS Command was sent to or from.
 * @property status - The status of the SMS Command
 */
interface SmsCommandListInstanceEachOptions {
  callback?: (item: SmsCommandInstance, done: (err?: Error) => void) => void;
  direction?: SmsCommandDirection;
  done?: Function;
  limit?: number;
  pageSize?: number;
  sim?: string;
  status?: SmsCommandStatus;
}

/**
 * Options to pass to list
 *
 * @property direction - The direction of the SMS Command
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property sim - The SID or unique name of the Sim resource that SMS Command was sent to or from.
 * @property status - The status of the SMS Command
 */
interface SmsCommandListInstanceOptions {
  direction?: SmsCommandDirection;
  limit?: number;
  pageSize?: number;
  sim?: string;
  status?: SmsCommandStatus;
}

/**
 * Options to pass to page
 *
 * @property direction - The direction of the SMS Command
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property sim - The SID or unique name of the Sim resource that SMS Command was sent to or from.
 * @property status - The status of the SMS Command
 */
interface SmsCommandListInstancePageOptions {
  direction?: SmsCommandDirection;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  sim?: string;
  status?: SmsCommandStatus;
}

interface SmsCommandPayload extends SmsCommandResource, Page.TwilioResponsePayload {
}

interface SmsCommandResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  direction: SmsCommandDirection;
  payload: string;
  sid: string;
  sim_sid: string;
  status: SmsCommandStatus;
  url: string;
}

interface SmsCommandSolution {
}


declare class SmsCommandContext {
  /**
   * Initialize the SmsCommandContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a SmsCommandInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SmsCommandInstance) => any): Promise<SmsCommandInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class SmsCommandInstance extends SerializableClass {
  /**
   * Initialize the SmsCommandContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: SmsCommandPayload, sid: string);

  private _proxy: SmsCommandContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  direction: SmsCommandDirection;
  /**
   * fetch a SmsCommandInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SmsCommandInstance) => any): Promise<SmsCommandInstance>;
  payload: string;
  sid: string;
  simSid: string;
  status: SmsCommandStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class SmsCommandPage extends Page<V1, SmsCommandPayload, SmsCommandResource, SmsCommandInstance> {
  /**
   * Initialize the SmsCommandPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SmsCommandSolution);

  /**
   * Build an instance of SmsCommandInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SmsCommandPayload): SmsCommandInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SmsCommandContext, SmsCommandDirection, SmsCommandInstance, SmsCommandList, SmsCommandListInstance, SmsCommandListInstanceCreateOptions, SmsCommandListInstanceEachOptions, SmsCommandListInstanceOptions, SmsCommandListInstancePageOptions, SmsCommandPage, SmsCommandPayload, SmsCommandResource, SmsCommandSolution, SmsCommandStatus }
