/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../../base/Page');
import Response = require('../../../../../../http/response');
import V1 = require('../../../../V1');
import { SerializableClass } from '../../../../../../interfaces';

/**
 * Initialize the StepContextList
 *
 * @param version - Version of the resource
 * @param flowSid - The SID of the Flow
 * @param engagementSid - The SID of the Engagement
 * @param stepSid - Step SID
 */
declare function StepContextList(version: V1, flowSid: string, engagementSid: string, stepSid: string): StepContextListInstance;

interface StepContextListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): StepContextContext;
  /**
   * Constructs a step_context
   */
  get(): StepContextContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface StepContextPayload extends StepContextResource, Page.TwilioResponsePayload {
}

interface StepContextResource {
  account_sid: string;
  context: object;
  engagement_sid: string;
  flow_sid: string;
  step_sid: string;
  url: string;
}

interface StepContextSolution {
  engagementSid?: string;
  flowSid?: string;
  stepSid?: string;
}


declare class StepContextContext {
  /**
   * Initialize the StepContextContext
   *
   * @param version - Version of the resource
   * @param flowSid - The SID of the Flow
   * @param engagementSid - The SID of the Engagement
   * @param stepSid - Step SID
   */
  constructor(version: V1, flowSid: string, engagementSid: string, stepSid: string);

  /**
   * fetch a StepContextInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: StepContextInstance) => any): Promise<StepContextInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class StepContextInstance extends SerializableClass {
  /**
   * Initialize the StepContextContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param flowSid - The SID of the Flow
   * @param engagementSid - The SID of the Engagement
   * @param stepSid - Step SID
   */
  constructor(version: V1, payload: StepContextPayload, flowSid: string, engagementSid: string, stepSid: string);

  private _proxy: StepContextContext;
  accountSid: string;
  context: any;
  engagementSid: string;
  /**
   * fetch a StepContextInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: StepContextInstance) => any): Promise<StepContextInstance>;
  flowSid: string;
  stepSid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class StepContextPage extends Page<V1, StepContextPayload, StepContextResource, StepContextInstance> {
  /**
   * Initialize the StepContextPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: StepContextSolution);

  /**
   * Build an instance of StepContextInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: StepContextPayload): StepContextInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { StepContextContext, StepContextInstance, StepContextList, StepContextListInstance, StepContextPage, StepContextPayload, StepContextResource, StepContextSolution }
