'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var MediaProcessorList = require('./v1/mediaProcessor').MediaProcessorList;
var PlayerStreamerList = require('./v1/playerStreamer').PlayerStreamerList;
var Version = require('../../base/Version');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize the V1 version of Media
 *
 * @constructor Twilio.Media.V1
 *
 * @property {Twilio.Media.V1.MediaProcessorList} mediaProcessor -
 *          mediaProcessor resource
 * @property {Twilio.Media.V1.PlayerStreamerList} playerStreamer -
 *          playerStreamer resource
 *
 * @param {Twilio.Media} domain - The twilio domain
 */
/* jshint ignore:end */
function V1(domain) {
  Version.prototype.constructor.call(this, domain, 'v1');

  // Resources
  this._mediaProcessor = undefined;
  this._playerStreamer = undefined;
}

_.extend(V1.prototype, Version.prototype);
V1.prototype.constructor = V1;

Object.defineProperty(V1.prototype,
  'mediaProcessor', {
    get: function() {
      this._mediaProcessor = this._mediaProcessor || new MediaProcessorList(this);
      return this._mediaProcessor;
    }
});

Object.defineProperty(V1.prototype,
  'playerStreamer', {
    get: function() {
      this._playerStreamer = this._playerStreamer || new PlayerStreamerList(this);
      return this._playerStreamer;
    }
});

module.exports = V1;
