'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var RatePlanList;
var RatePlanPage;
var RatePlanInstance;
var RatePlanContext;

/* jshint ignore:start */
/**
 * Initialize the RatePlanList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Wireless.RatePlanList
 *
 * @param {Twilio.Preview.Wireless} version - Version of the resource
 */
/* jshint ignore:end */
RatePlanList = function RatePlanList(version) {
  /* jshint ignore:start */
  /**
   * @function ratePlans
   * @memberof Twilio.Preview.Wireless#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Wireless.RatePlanContext}
   */
  /* jshint ignore:end */
  function RatePlanListInstance(sid) {
    return RatePlanListInstance.get(sid);
  }

  RatePlanListInstance._version = version;
  // Path Solution
  RatePlanListInstance._solution = {};
  RatePlanListInstance._uri = `/RatePlans`;
  /* jshint ignore:start */
  /**
   * Streams RatePlanInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.Wireless.RatePlanList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  RatePlanListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists RatePlanInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.Wireless.RatePlanList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RatePlanListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of RatePlanInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.Wireless.RatePlanList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RatePlanListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new RatePlanPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of RatePlanInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.Wireless.RatePlanList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RatePlanListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new RatePlanPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a RatePlanInstance
   *
   * @function create
   * @memberof Twilio.Preview.Wireless.RatePlanList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.uniqueName] - The unique_name
   * @param {string} [opts.friendlyName] - The friendly_name
   * @param {boolean} [opts.dataEnabled] - The data_enabled
   * @param {number} [opts.dataLimit] - The data_limit
   * @param {string} [opts.dataMetering] - The data_metering
   * @param {boolean} [opts.messagingEnabled] - The messaging_enabled
   * @param {boolean} [opts.voiceEnabled] - The voice_enabled
   * @param {boolean} [opts.commandsEnabled] - The commands_enabled
   * @param {boolean} [opts.nationalRoamingEnabled] - The national_roaming_enabled
   * @param {string|list} [opts.internationalRoaming] - The international_roaming
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed RatePlanInstance
   */
  /* jshint ignore:end */
  RatePlanListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'UniqueName': _.get(opts, 'uniqueName'),
      'FriendlyName': _.get(opts, 'friendlyName'),
      'DataEnabled': serialize.bool(_.get(opts, 'dataEnabled')),
      'DataLimit': _.get(opts, 'dataLimit'),
      'DataMetering': _.get(opts, 'dataMetering'),
      'MessagingEnabled': serialize.bool(_.get(opts, 'messagingEnabled')),
      'VoiceEnabled': serialize.bool(_.get(opts, 'voiceEnabled')),
      'CommandsEnabled': serialize.bool(_.get(opts, 'commandsEnabled')),
      'NationalRoamingEnabled': serialize.bool(_.get(opts, 'nationalRoamingEnabled')),
      'InternationalRoaming': serialize.map(_.get(opts, 'internationalRoaming'), function(e) { return e; })
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new RatePlanInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a rate_plan
   *
   * @function get
   * @memberof Twilio.Preview.Wireless.RatePlanList#
   *
   * @param {string} sid - The sid
   *
   * @returns {Twilio.Preview.Wireless.RatePlanContext}
   */
  /* jshint ignore:end */
  RatePlanListInstance.get = function get(sid) {
    return new RatePlanContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Wireless.RatePlanList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  RatePlanListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  RatePlanListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return RatePlanListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the RatePlanPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Wireless.RatePlanPage
 *
 * @param {Wireless} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {RatePlanSolution} solution - Path solution
 *
 * @returns RatePlanPage
 */
/* jshint ignore:end */
RatePlanPage = function RatePlanPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(RatePlanPage.prototype, Page.prototype);
RatePlanPage.prototype.constructor = RatePlanPage;

/* jshint ignore:start */
/**
 * Build an instance of RatePlanInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Wireless.RatePlanPage#
 *
 * @param {RatePlanPayload} payload - Payload response from the API
 *
 * @returns RatePlanInstance
 */
/* jshint ignore:end */
RatePlanPage.prototype.getInstance = function getInstance(payload) {
  return new RatePlanInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Wireless.RatePlanPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
RatePlanPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RatePlanPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RatePlanContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Wireless.RatePlanInstance
 *
 * @property {string} sid - The sid
 * @property {string} uniqueName - The unique_name
 * @property {string} accountSid - The account_sid
 * @property {string} friendlyName - The friendly_name
 * @property {boolean} dataEnabled - The data_enabled
 * @property {string} dataMetering - The data_metering
 * @property {number} dataLimit - The data_limit
 * @property {boolean} messagingEnabled - The messaging_enabled
 * @property {boolean} voiceEnabled - The voice_enabled
 * @property {boolean} nationalRoamingEnabled - The national_roaming_enabled
 * @property {string} internationalRoaming - The international_roaming
 * @property {Date} dateCreated - The date_created
 * @property {Date} dateUpdated - The date_updated
 * @property {string} url - The url
 *
 * @param {Wireless} version - Version of the resource
 * @param {RatePlanPayload} payload - The instance payload
 * @param {sid_like} sid - The sid
 */
/* jshint ignore:end */
RatePlanInstance = function RatePlanInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.dataEnabled = payload.data_enabled; // jshint ignore:line
  this.dataMetering = payload.data_metering; // jshint ignore:line
  this.dataLimit = deserialize.integer(payload.data_limit); // jshint ignore:line
  this.messagingEnabled = payload.messaging_enabled; // jshint ignore:line
  this.voiceEnabled = payload.voice_enabled; // jshint ignore:line
  this.nationalRoamingEnabled = payload.national_roaming_enabled; // jshint ignore:line
  this.internationalRoaming = payload.international_roaming; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(RatePlanInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new RatePlanContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a RatePlanInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Wireless.RatePlanInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RatePlanInstance
 */
/* jshint ignore:end */
RatePlanInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a RatePlanInstance
 *
 * @function update
 * @memberof Twilio.Preview.Wireless.RatePlanInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.uniqueName] - The unique_name
 * @param {string} [opts.friendlyName] - The friendly_name
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RatePlanInstance
 */
/* jshint ignore:end */
RatePlanInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a RatePlanInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Wireless.RatePlanInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RatePlanInstance
 */
/* jshint ignore:end */
RatePlanInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Wireless.RatePlanInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
RatePlanInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RatePlanInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RatePlanContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Wireless.RatePlanContext
 *
 * @param {Wireless} version - Version of the resource
 * @param {sid_like} sid - The sid
 */
/* jshint ignore:end */
RatePlanContext = function RatePlanContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/RatePlans/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a RatePlanInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Wireless.RatePlanContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RatePlanInstance
 */
/* jshint ignore:end */
RatePlanContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new RatePlanInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a RatePlanInstance
 *
 * @function update
 * @memberof Twilio.Preview.Wireless.RatePlanContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.uniqueName] - The unique_name
 * @param {string} [opts.friendlyName] - The friendly_name
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RatePlanInstance
 */
/* jshint ignore:end */
RatePlanContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'UniqueName': _.get(opts, 'uniqueName'),
    'FriendlyName': _.get(opts, 'friendlyName')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new RatePlanInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a RatePlanInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Wireless.RatePlanContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RatePlanInstance
 */
/* jshint ignore:end */
RatePlanContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Wireless.RatePlanContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
RatePlanContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

RatePlanContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  RatePlanList: RatePlanList,
  RatePlanPage: RatePlanPage,
  RatePlanInstance: RatePlanInstance,
  RatePlanContext: RatePlanContext
};
